<?php echo $__env->make('front.layout.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php if(session()->has('success')): ?>
    <div class="alert alert-danger alert-dismissible text-center"><button type="button" class="close" data-dismiss="alert"><span aria-hidden="true">&times;</span></button><?php echo e(session()->get('success')); ?></div> 
<?php endif; ?>
<?php if(session()->has('error')): ?>
    <div class="alert alert-danger alert-dismissible text-center"><button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button><?php echo e(session()->get('error')); ?></div> 
<?php endif; ?>
<!--Hero Section-->
    <div class="hero-section hero-background">
        <h1 class="page-title">Organic Fruits</h1>
    </div>

    <!--Navigation section-->
    <div class="container">
        <nav class="biolife-nav">
            <ul>
                <li class="nav-item"><a href="<?php echo e(url('/')); ?>" class="permal-link">Home</a></li>
                
                <li class="nav-item"><span class="current-page"><?php echo e($product->name); ?></span></li>
            </ul>
        </nav>
    </div>

    <div class="page-contain single-product">
        <div class="container">

            <!-- Main content -->
            <div id="main-content" class="main-content">
                
                <!-- summary info -->
                <div class="sumary-product single-layout">
                    <div class="media">

                        <ul class="biolife-carousel slider-for" data-slick='{"arrows":false,"dots":false,"slidesMargin":30,"slidesToShow":1,"slidesToScroll":1,"fade":true,"asNavFor":".slider-nav"}'>
                            <?php $images = explode(",", $product->image); ?>
                            <?php $__currentLoopData = $images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><img src="<?php echo e(url('public/images/product', $image)); ?>" alt="" width="500" height="500"></li>

                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                        <ul class="biolife-carousel slider-nav" data-slick='{"arrows":false,"dots":false,"centerMode":false,"focusOnSelect":true,"slidesMargin":10,"slidesToShow":4,"slidesToScroll":1,"asNavFor":".slider-for"}'>
                            <?php $images = explode(",", $product->image); ?>
                            <?php $__currentLoopData = $images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><img src="<?php echo e(url('public/images/product', $image)); ?>" alt="<?php echo e($product->name); ?>" width="88" height="88"></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                    <div class="product-attribute">
                        <h3 class="title"><?php echo e($product->name); ?></h3>

                        <?php
                            // Calculate width class for star bar — each star = 20%
                            $ratingPercent = round($averageRating) * 20; // e.g. 4.5 * 20 = 90
                            $ratingClass = "width-{$ratingPercent}percent"; // will become width-90percent etc.
                        ?>

                        <div class="rating">
                            <p class="star-rating">
                                <span class="<?php echo e($ratingClass); ?>"></span>
                            </p>
                            <span class="review-count">(<?php echo e($reviews->count()); ?> Reviews)</span>
                        </div>


                        <span class="sku">Sku: #<?php echo e($product->code); ?></span>
                        <p class="excerpt"><?php echo $product->product_details1; ?></p>
                        <div class="price">
                            <?php if($product->promotion_price != null): ?>
                            <ins><span class="price-amount"><span class="currencySymbol">£</span><?php echo e($product->promotion_price); ?></span></ins>

                            <del><span class="price-amount"><span class="currencySymbol">£</span><?php echo e($product->price); ?></span></del>
                            <?php else: ?>
                            <ins><span class="price-amount"><span class="currencySymbol">£</span><?php echo e($product->price); ?></span></ins>
                            <?php endif; ?>
                        </div>
                       
                    </div>
                    
                    <form id="addItem<?php echo e($product->id); ?>" action="<?php echo e(url('cart/addItem')); ?>" method="POST" class="from-cart"><?php echo csrf_field(); ?>
                        <div class="action-form">
                            <div class="quantity-box">
                                <span class="title">Quantity:</span>
                                <div class="qty-input">
                                    <input 
                                        type="number" 
                                        name="quantity" 
                                        value="1" 
                                        min="1" 
                                        data-max_value="20" 
                                        data-min_value="1" 
                                        class="quantity-input"
                                        data-product-id="<?php echo e($product->id); ?>"
                                    >
                                </div>

                                <div class="total-price-contain">
                                    <span class="title">Total Price:</span>
                                    <p class="price" id="totalPrice<?php echo e($product->id); ?>">£<?php echo e(number_format($product->promotion_price ?? $product->price, 2)); ?></p>
                                </div>

                                <div class="buttons">
                                    <?php if($product->is_variant == null && $product->qty > 0): ?>
                                        <button type="submit" class="btn add-to-cart-btn">Add to Cart</button>
                                    <?php else: ?>
                                        <a href="#" class="btn add-to-cart-btn disabled">Out of Stock</a>
                                    <?php endif; ?>
                                </div>

                                <input type="hidden" name="product_id" value="<?php echo e($product->id); ?>">
                                <input type="hidden" name="name" value="<?php echo e($product->name); ?>">
                                <?php if($product->promotion_price != null): ?>
                                    <input type="hidden" name="price" id="productPrice<?php echo e($product->id); ?>" value="<?php echo e($product->promotion_price); ?>">
                                <?php else: ?>
                                    <input type="hidden" name="price" id="productPrice<?php echo e($product->id); ?>" value="<?php echo e($product->price); ?>">
                                <?php endif; ?>
                                <?php if($product->is_variant != null): ?>
                                    <input type="hidden" name="product_code" value="<?php echo e($product->product_code); ?>">
                                <?php endif; ?>
                            </div>
                        </div>
                    </form>
                </div>

                <!-- Tab info -->
                <div class="product-tabs single-layout biolife-tab-contain">
                    <div class="tab-head">
                        <ul class="tabs">
                            <li class="tab-element active"><a href="#tab_1st" class="tab-link">Products Descriptions</a></li>
                            
                            <li class="tab-element" ><a href="#tab_4th" class="tab-link">Customer Reviews <sup>(<?php echo e($reviews->count()); ?>)</sup></a></li>
                        </ul>
                    </div>
                    <div class="tab-content">
                        <div id="tab_1st" class="tab-contain desc-tab active">
                            <p class="desc"><?php echo $product->product_details2; ?></p>
                            
                        </div>
                       
                      
                        <div id="tab_4th" class="tab-contain review-tab">
                            <div class="container">
                                <div class="row">
                                    <div class="col-lg-5 col-md-5 col-sm-6 col-xs-12">
                                        <div class="rating-info">
                                    <p class="index"><strong class="rating"><?php echo e(round($averageRating)); ?></strong>out of 5</p>
                                            <div class="rating"><p class="star-rating"><span class="width-<?php echo e($ratingPercent); ?>percent"></span></p></div>
                                            <p class="see-all">See all <?php echo e($reviews->count()); ?> reviews</p>
                                            <ul class="options">
                                                <li>
                                                    <div class="detail-for">
                                                        <?php $__currentLoopData = $reviews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $review): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <div class="review-item">
                                                                <h4 class="review-mini-title"><?php echo e($review->customer_name); ?></h4>
                                                                
                                                                <p><?php echo e($review->details); ?></p>
                                                                <span class="review-date">Posted on <?php echo e($review->created_at->format($general_setting->date_format . ' H:i:s')); ?></span>
                                                            </div>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </div>
                                                </li>
                                               
                                            </ul>
                                        </div>
                                    </div>
                                    <?php if(Auth::check()): ?>
                                    <div class="col-lg-7 col-md-7 col-sm-6 col-xs-12">
                                        <div class="review-form-wrapper">
                                            <span class="title">Submit your review</span>

                                            <?php
                                                $user = Auth::user();
                                                $customer = App\Customer::where('user_id', $user->id)->first();
                                            ?>

                                            <?php if($customer != null): ?>
                                                <form action="<?php echo e(route('review.store')); ?>" name="frm-review" method="post">
                                                    <?php echo csrf_field(); ?>
                                                    <input type="hidden" name="product_id" value="<?php echo e($product->id); ?>">
                                                    <input type="hidden" name="customer_id" value="<?php echo e($customer->id); ?>">
                                                    <input type="hidden" name="stars" id="rating-value" value="">

                                                    <div class="comment-form-rating">
                                                        <label>1. Your rating of this product:</label>
                                                        <p class="stars">
                                                            <span>
                                                                <?php for($i = 1; $i <= 5; $i++): ?>
                                                                    <a href="#" class="btn-rating" data-value="<?php echo e($i); ?>"><i class="fa fa-star-o" aria-hidden="true"></i></a>
                                                                <?php endfor; ?>
                                                            </span>
                                                        </p>
                                                    </div>

                                                    <p class="form-row wide-half">
                                                        <input type="text" name="customer_name" value="<?php echo e($customer->name); ?>" placeholder="Your name" required>
                                                    </p>

                                                    <p class="form-row wide-half">
                                                        <input type="email" name="email" value="<?php echo e($customer->email); ?>" placeholder="Email address" readonly>
                                                    </p>

                                                    <p class="form-row">
                                                        <textarea name="details" id="txt-comment" cols="30" rows="10" placeholder="Write your review here..." required></textarea>
                                                    </p>

                                                    <p class="form-row">
                                                        <button type="submit" name="submit" class="btn">Submit Review</button>
                                                    </p>
                                                </form>
                                            <?php endif; ?>
                                            <?php else: ?>
                                                <div class="review-login-notice">
                                                    <h3>Login Or Register to give a review</h3>
                                                    <a href="<?php echo e(route('login')); ?>" class="btn">Login</a>
                                                    <a href="<?php echo e(route('register')); ?>" class="btn">Register</a>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>




                                <!-- <div id="comments">
                                    <ol class="commentlist">
                                        <li class="review">
                                            <div class="comment-container">
                                                <div class="row">
                                                    <div class="comment-content col-lg-8 col-md-9 col-sm-8 col-xs-12">
                                                        <p class="comment-in"><span class="post-name">Quality is our way of life</span><span class="post-date">01/04/2018</span></p>
                                                        <div class="rating"><p class="star-rating"><span class="width-80percent"></span></p></div>
                                                        <p class="author">by: <b>Shop organic</b></p>
                                                        <p class="comment-text">There are few things in life that please people more than the succulence of quality fresh fruit and vegetables.  At Fresh Fruits we work to deliver the world’s freshest, choicest, and juiciest produce to discerning customers across the UAE and GCC.</p>
                                                    </div>
                                                    <div class="comment-review-form col-lg-3 col-lg-offset-1 col-md-3 col-sm-4 col-xs-12">
                                                        <span class="title">Was this review helpful?</span>
                                                        <ul class="actions">
                                                            <li><a href="#" class="btn-act like" data-type="like"><i class="fa fa-thumbs-up" aria-hidden="true"></i>Yes (100)</a></li>
                                                            <li><a href="#" class="btn-act hate" data-type="dislike"><i class="fa fa-thumbs-down" aria-hidden="true"></i>No (20)</a></li>
                                                            <li><a href="#" class="btn-act report" data-type="dislike"><i class="fa fa-flag" aria-hidden="true"></i>Report</a></li>
                                                        </ul>
                                                    </div>
                                                </div>
                                            </div>
                                        </li>
                                        <li class="review">
                                            <div class="comment-container">
                                                <div class="row">
                                                    <div class="comment-content col-lg-8 col-md-9 col-sm-8 col-xs-12">
                                                        <p class="comment-in"><span class="post-name">Quality is our way of life</span><span class="post-date">01/04/2018</span></p>
                                                        <div class="rating"><p class="star-rating"><span class="width-80percent"></span></p></div>
                                                        <p class="author">by: <b>Shop organic</b></p>
                                                        <p class="comment-text">There are few things in life that please people more than the succulence of quality fresh fruit and vegetables.  At Fresh Fruits we work to deliver the world’s freshest, choicest, and juiciest produce to discerning customers across the UAE and GCC.</p>
                                                    </div>
                                                    <div class="comment-review-form col-lg-3 col-lg-offset-1 col-md-3 col-sm-4 col-xs-12">
                                                        <span class="title">Was this review helpful?</span>
                                                        <ul class="actions">
                                                            <li><a href="#" class="btn-act like" data-type="like"><i class="fa fa-thumbs-up" aria-hidden="true"></i>Yes (100)</a></li>
                                                            <li><a href="#" class="btn-act hate" data-type="dislike"><i class="fa fa-thumbs-down" aria-hidden="true"></i>No (20)</a></li>
                                                            <li><a href="#" class="btn-act report" data-type="dislike"><i class="fa fa-flag" aria-hidden="true"></i>Report</a></li>
                                                        </ul>
                                                    </div>
                                                </div>
                                            </div>
                                        </li>
                                        <li class="review">
                                            <div class="comment-container">
                                                <div class="row">
                                                    <div class="comment-content col-lg-8 col-md-9 col-sm-8 col-xs-12">
                                                        <p class="comment-in"><span class="post-name">Quality is our way of life</span><span class="post-date">01/04/2018</span></p>
                                                        <div class="rating"><p class="star-rating"><span class="width-80percent"></span></p></div>
                                                        <p class="author">by: <b>Shop organic</b></p>
                                                        <p class="comment-text">There are few things in life that please people more than the succulence of quality fresh fruit and vegetables.  At Fresh Fruits we work to deliver the world’s freshest, choicest, and juiciest produce to discerning customers across the UAE and GCC.</p>
                                                    </div>
                                                    <div class="comment-review-form col-lg-3 col-lg-offset-1 col-md-3 col-sm-4 col-xs-12">
                                                        <span class="title">Was this review helpful?</span>
                                                        <ul class="actions">
                                                            <li><a href="#" class="btn-act like" data-type="like"><i class="fa fa-thumbs-up" aria-hidden="true"></i>Yes (100)</a></li>
                                                            <li><a href="#" class="btn-act hate" data-type="dislike"><i class="fa fa-thumbs-down" aria-hidden="true"></i>No (20)</a></li>
                                                            <li><a href="#" class="btn-act report" data-type="dislike"><i class="fa fa-flag" aria-hidden="true"></i>Report</a></li>
                                                        </ul>
                                                    </div>
                                                </div>
                                            </div>
                                        </li>
                                    </ol>
                                    <div class="biolife-panigations-block version-2">
                                        <ul class="panigation-contain">
                                            <li><span class="current-page">1</span></li>
                                            <li><a href="#" class="link-page">2</a></li>
                                            <li><a href="#" class="link-page">3</a></li>
                                            <li><span class="sep">....</span></li>
                                            <li><a href="#" class="link-page">20</a></li>
                                            <li><a href="#" class="link-page next"><i class="fa fa-angle-right" aria-hidden="true"></i></a></li>
                                        </ul>
                                        <div class="result-count">
                                            <p class="txt-count"><b>1-5</b> of <b>126</b> reviews</p>
                                            <a href="#" class="link-to">See all<i class="fa fa-caret-right" aria-hidden="true"></i></a>
                                        </div>
                                    </div>
                                </div> -->
                            </div>
                        </div>
                    </div>
                </div>

                <!-- related products -->
                <div class="product-related-box single-layout">
                    <div class="biolife-title-box lg-margin-bottom-26px-im">
                        <span class="biolife-icon icon-organic"></span>
                        <span class="subtitle">All the best item for You</span>
                        <h3 class="main-title">Related Products</h3>
                    </div>
                    <ul class="products-list biolife-carousel nav-center-02 nav-none-on-mobile" data-slick='{"rows":1,"arrows":true,"dots":false,"infinite":false,"speed":400,"slidesMargin":0,"slidesToShow":5, "responsive":[{"breakpoint":1200, "settings":{ "slidesToShow": 4}},{"breakpoint":992, "settings":{ "slidesToShow": 3, "slidesMargin":20 }},{"breakpoint":768, "settings":{ "slidesToShow": 2, "slidesMargin":10}}]}'>
                        <?php $__currentLoopData = $related_products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $related): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li class="product-item">
                            <div class="contain-product layout-default">
                                <?php $images = explode(",", $related->image);$primaryImage = isset($images[0]) ? $images[0] : '';?>
                                <div class="product-thumb">
                                    <a href="<?php echo e(url('/single-product')); ?>/<?php echo e($related->id); ?>" class="link-to-product">
                                        <img src="<?php echo e(url('public/images/product', $primaryImage)); ?>" alt="dd" width="270" height="270" class="product-thumnail">
                                    </a>
                                </div>
                                <div class="info">
                                    <b class="categories">Fresh Fruit</b>
                                    <h4 class="product-title"><a href="<?php echo e(url('/single-product')); ?>/<?php echo e($related->id); ?>" class="pr-name"><?php echo e($related->name); ?></a></h4>
                                    <div class="price">
                                       <?php if($product->promotion_price != null): ?>
                                        <ins><span class="price-amount"><span class="currencySymbol">£</span><?php echo e($product->promotion_price); ?></span></ins>

                                        <del><span class="price-amount"><span class="currencySymbol">£</span><?php echo e($product->price); ?></span></del>
                                        <?php else: ?>
                                        <ins><span class="price-amount"><span class="currencySymbol">£</span><?php echo e($product->price); ?></span></ins>
                                        <?php endif; ?>
                                    </div>
                                    <div class="slide-down-box">
                                        <p class="message">All products are carefully selected to ensure food safety.</p>
                                        <div class="buttons">
                                            <a href="#" class="btn wishlist-btn"><i class="fa fa-heart" aria-hidden="true"></i></a>

                                            <a href="#" class="btn add-to-cart-btn"><i class="fa fa-cart-arrow-down" aria-hidden="true"></i>add to cart</a>
                                            
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </li>
                         <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </ul>
                </div>
                
            </div>
        </div>
    </div>

    <?php echo $__env->make('front.layout.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<script>
        document.addEventListener('DOMContentLoaded', function () {
            const qtyInput = document.querySelector(`input.quantity-input[data-product-id='<?php echo e($product->id); ?>']`);
            const priceDisplay = document.getElementById(`totalPrice<?php echo e($product->id); ?>`);
            const hiddenPriceInput = document.getElementById(`productPrice<?php echo e($product->id); ?>`);
            const basePrice = parseFloat(hiddenPriceInput.value);

            qtyInput.value = 1;
            hiddenPriceInput.value = basePrice.toFixed(2);
            priceDisplay.textContent = `£${basePrice.toFixed(2)}`;

            qtyInput.addEventListener('input', function () {
                let quantity = parseInt(this.value);
                //console.log(quantity);
                    if (isNaN(quantity) || quantity < 1) {
                    this.value = 1;
                    quantity = 1;
                }

                const newTotal = basePrice * quantity;
                //console.log(newTotal);
                // Update visible total price
                priceDisplay.textContent = `£${newTotal.toFixed(2)}`;

                // Update hidden input price (optional, per quantity)
                //hiddenPriceInput.value = newTotal.toFixed(2);
            });
        });
</script>

<!-- JavaScript for star rating -->
<script>
    document.addEventListener("DOMContentLoaded", function () {
        const ratingLinks = document.querySelectorAll(".btn-rating");
        const ratingInput = document.getElementById("rating-value");

        ratingLinks.forEach(link => {
            link.addEventListener("click", function (e) {
                e.preventDefault();
                const rating = this.dataset.value;
                ratingInput.value = rating;

                // Reset all stars first
                ratingLinks.forEach(star => {
                    star.querySelector("i").classList.remove("fa-star");
                    star.querySelector("i").classList.add("fa-star-o");
                });

                // Highlight selected stars
                for (let i = 0; i < rating; i++) {
                    ratingLinks[i].querySelector("i").classList.remove("fa-star-o");
                    ratingLinks[i].querySelector("i").classList.add("fa-star");
                }
            });
        });
    });
</script>
<script>
    document.forms['frm-review'].addEventListener('submit', function (e) {
        const rating = document.getElementById('rating-value').value;
        if (!rating) {
            e.preventDefault();
            alert('Please select a star rating before submitting your review.');
        }
    });
</script>
<?php /**PATH /home/mamusxqr/alamminimarket.co.uk/resources/views/front/single-product.blade.php ENDPATH**/ ?>