
<?php $__env->startSection('content'); ?>

<section>
    <div class="container-fluid">
        <a href="<?php echo e(route('blogs.create')); ?>" class="btn btn-info"><i class="dripicons-plus"></i> Add Blogs</a>
    </div>
    <div class="table-responsive">
        <table id="blogs-table" class="table" style="width: 100%">
            <thead>
                <tr>
                    <th>Title</th>
                    <th>Description</th>
                    <th>Image</th>
                    <th><?php echo e(trans('file.action')); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $blogs_all ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr data-id="<?php echo e($blog->id); ?>">
                    <td><?php echo e($blog->title); ?></td>
                    <td><?php echo e(substr($blog->description, 0, 30)); ?></td>
                    <td><img src="<?php echo e(asset('storage/app/' . $blog->image)); ?>" alt="Blog Image" height="50px" width="100px"></td>
                    <td>
                        <div class="btn-group">
                            <button type="button" class="btn btn-default btn-sm dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><?php echo e(trans('file.action')); ?>

                                <span class="caret"></span>
                                <span class="sr-only">Toggle Dropdown</span>
                            </button>
                            <ul class="dropdown-menu edit-options dropdown-menu-right dropdown-default" user="menu">
                                <li>
                                    <a href="<?php echo e(route('blogs.edit', $blog->id)); ?>" class="btn btn-link"><i class="dripicons-document-edit"></i> <?php echo e(trans('file.edit')); ?></a>
                                </li>
                                <li class="divider"></li>
                                <?php
                                    $role = DB::table('roles')->find(Auth::user()->role_id);
                                    $seo = DB::table('permissions')->where('name', 'seo')->first();
                                    $seo_active = null;
                                    if ($seo) {
                                        $seo_active = DB::table('role_has_permissions')->where([
                                            ['permission_id', $seo->id],
                                            ['role_id', $role->id]
                                        ])->first();
                                    }
                                ?>
                                <?php if(!empty($seo_active)): ?>
                                <li>
                                    <a href="<?php echo e(route('blog.seo_meta', $blog->id)); ?>" class="btn btn-link"><i class="dripicons-document-edit"></i> SEO</a>
                                </li>
                                <?php endif; ?>
                                <?php echo e(Form::open(['route' => ['blogs.destroy', $blog->id], 'method' => 'DELETE'] )); ?>

                                <li>
                                    <button type="submit" class="btn btn-link" onclick="return confirmDelete()"><i class="dripicons-trash"></i> <?php echo e(trans('file.delete')); ?></button>
                                </li>
                                <?php echo e(Form::close()); ?>

                            </ul>
                        </div>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
</section>

<script type="text/javascript">
    $(document).ready(function() {
        $("ul#cms").siblings('a').attr('aria-expanded','true');
        $("ul#cms").addClass("show");
        $("ul#cms #blogs-menu").addClass("active");

        $('#blogs-table').DataTable({
            responsive: true,
            fixedHeader: {
                header: true,
                footer: true
            },
            "order": [],
            'language': {
                'lengthMenu': '_MENU_ <?php echo e(trans("file.records per page")); ?>',
                "info":      '<small><?php echo e(trans("file.Showing")); ?> _START_ - _END_ (_TOTAL_)</small>',
                "search":  '<?php echo e(trans("file.Search")); ?>',
                'paginate': {
                    'previous': '<i class="dripicons-chevron-left"></i>',
                    'next': '<i class="dripicons-chevron-right"></i>'
                }
            },
            'columnDefs': [
                {
                    "orderable": false,
                    'targets': [2, 3]
                },
            ],
            'select': { style: 'multi',  selector: 'td:first-child'},
            'lengthMenu': [[10, 25, 50, -1], [10, 25, 50, "All"]],
            dom: '<"row"lfB>rtip',
            buttons: [
                {
                    extend: 'pdf',
                    text: '<?php echo e(trans("file.PDF")); ?>',
                    exportOptions: {
                        columns: ':visible:Not(.not-exported)',
                        rows: ':visible'
                    },
                },
                {
                    extend: 'csv',
                    text: '<?php echo e(trans("file.CSV")); ?>',
                    exportOptions: {
                        columns: ':visible:Not(.not-exported)',
                        rows: ':visible'
                    },
                },
                {
                    extend: 'print',
                    text: '<?php echo e(trans("file.Print")); ?>',
                    exportOptions: {
                        columns: ':visible:Not(.not-exported)',
                        rows: ':visible'
                    },
                },
                {
                    extend: 'colvis',
                    text: '<?php echo e(trans("file.Column visibility")); ?>',
                    columns: ':gt(0)'
                },
            ],
        });
    });

    function confirmDelete() {
        if (confirm("Are you sure you want to delete this blog?")) {
            return true;
        }
        return false;
    }
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mamusxqr/alamminimarket.co.uk/resources/views/blog/blog-list.blade.php ENDPATH**/ ?>