<?php echo $__env->make('front.layout.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div class="breadcrumb-area">
            <div class="container">
                <ol class="breadcrumb breadcrumb-list">
                    <li class="breadcrumb-item"><a href="<?php echo e(url('/')); ?>">Home</a></li>
                    <li class="breadcrumb-item active">Checkout</li>
                </ol>
            </div>
        </div>
        <!-- show error messages -->
        <div class="coupon-area white-bg pt-90 pb-30">
            <?php if($errors->any()): ?>
                <div class="alert alert-danger">
                    <ul>
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            <?php endif; ?>

            <?php if(session('error')): ?>
                <div class="alert alert-danger">
                    <?php echo e(session('error')); ?>

                </div>
            <?php endif; ?>
            <?php
                $deliveryOptions = App\DeliveryCharge::all();
                $subtotal = floatval(str_replace(',', '', Cart::subtotal()));
            ?>
        </div>
        <!-- show error messages -->
        <!-- Breadcrumb Area End Here -->
        
        <!-- checkout-area start -->
        <?php if(Auth::check()): ?>
            <?php $user = Auth::user();
            $customer = App\Customer::where('user_id',$user->id)->first();?>
        <?php endif; ?>
        <?php
            $deliveryOptions = App\DeliveryCharge::all();
            $subtotal = floatval(str_replace(',', '', Cart::subtotal()));
        ?>
        <?php if(Auth::check() && $customer == null): ?>
        <div class="checkout-area white-bg pb-90">
            <div class="container">
                    <div class="row">
                        <div class="col-lg-6 col-md-6">
                            <h3>Login As A Customer or Logout to Place an Order</h3> 
                        </div>
                    </div>
            </div>
        </div>
        <?php else: ?>
            <div class="checkout-area white-bg pb-90">
                <div class="container">
                    <form action="<?php echo e(route('place_order')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="hidden_shipping_cost" class="shipping-cost-input-customer" value="0">
                        <div class="row">
                            <div class="col-lg-6 col-md-6">
                                <div class="checkbox-form mb-sm-40">
                                    <h3>Billing Details</h3>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="checkout-form-list mb-sm-30">
                                                <label><label>Name / Username <span class="required">*</span></label>
                                                    <?php if(Auth::check()): ?>
                                                    <input class="input-text" name="name" value="<?php echo e($customer_detail->name); ?>" required type="text" placeholder="Name">
                                                    <?php else: ?>
                                                    <input class="input-text" name="name" id="name" type="text" placeholder="" required>
                                                    <?php endif; ?>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="checkout-form-list mb-30">
                                                <label>Phone <span class="required">*</span></label>
                                                <?php if(Auth::check()): ?>
                                                <input class="input-text" name="phone" id="phone" type="text" value="<?php echo e(Auth::user()->phone); ?>" type="text" placeholder="" required>
                                                <?php else: ?>
                                                <input class="input-text" name="phone" id="phone" type="text" placeholder="" required>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="checkout-form-list mb-30">
                                                <label>Email Address <span class="required">*</span></label>
                                                <?php if(Auth::check()): ?>
                                                <input class="input-text" name="email" id="email" type="email"  value="<?php echo e(Auth::user()->email); ?>" required type="email" placeholder="" required>
                                                <?php else: ?>
                                                <input class="input-text" name="email" id="email" type="email" placeholder="example@.." required>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="checkout-form-list mb-30">
                                                <label>Address <span class="required">*</span></label>
                                                <?php if(Auth::check()): ?>
                                                <input class="input-text" name="address" id="address" placeholder="Street address" type="text" value="<?php echo e($customer_detail->address); ?>" required>
                                                <?php else: ?>
                                                <input class="input-text" name="address" id="address" type="text" placeholder="Street address" required>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="checkout-form-list mb-30">
                                                <label>Flat / Apartment / Unit (optional)<span class="required"></span></label>
                                                <?php if(Auth::check()): ?>
                                                <input class="input-text" name="state" id="state" placeholder="" type="text" value="<?php echo e($customer_detail->state); ?>" placeholder="Flat / Apartment / Unit">
                                                <?php else: ?>
                                                <input class="input-text" name="state" id="state" type="text" placeholder="Flat / Apartment / Unit">
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="checkout-form-list mb-30">
                                                <label>Town / City <span class="required">*</span></label>
                                                <?php if(Auth::check()): ?>
                                                <input class="input-text" name="city" id="city" type="text" value="<?php echo e($customer_detail->city); ?>" placeholder="Town / City" required>
                                                <?php else: ?>
                                                <input class="input-text" name="city" id="city" type="text" placeholder="Town / City" required>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="checkout-form-list mb-30">
                                                <label>Postcode / Zip <span class="required"></span></label>
                                                <?php if(Auth::check()): ?>
                                                <input class="input-text" name="postcode" id="postcode" placeholder="" type="text" value="<?php echo e($customer_detail->postal_code); ?>" placeholder="Postcode / Zip">
                                                <?php else: ?>
                                                <input class="input-text" name="postcode" id="postcode" placeholder="" type="text"  placeholder="Postcode / Zip">
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="checkout-form-list">
                                                <label>Order Notes</label>
                                                <textarea class="form-control resize-both" rows="3"></textarea>
                                            </div>
                                        </div>
                                        <?php if(!Auth::check()): ?>
                                        <div class="col-md-12">
                                            <div class="checkout-form-list create-acc mb-30">
                                                <input id="cbox" type="checkbox" name="create_account">
                                                <label>Create an account?</label>
                                            </div>
                                            <div id="cbox_info" class="checkout-form-list create-accounts mb-25">
                                                <p class="mb-10">Create an account by entering the information below. If you are
                                                    a returning customer please login at the top of the page.</p>
                                                <label>Account password <span class="required">*</span></label>
                                                <input type="password" placeholder="password" name="password">
                                            </div>
                                        </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6 col-md-6">
                                <div class="your-order">
                                    <h3>Select Delivery Option:</h3>
                                    <?php $__currentLoopData = $deliveryOptions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="form-check">
                                            <input class="form-check-input delivery-option-user" type="radio" name="deliveryOption" 
                                            id="delivery<?php echo e($option->id); ?>" value="<?php echo e($option->charge); ?>" 
                                            data-location="<?php echo e($option->location); ?>" required>
                                            <label class="form-check-label" for="delivery<?php echo e($option->id); ?>">
                                                <?php echo e($option->location); ?> - £ <?php echo e(number_format($option->charge, 2)); ?>

                                            </label>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                                <div class="your-order">
                                    <div>
                                        <h4>Apply Coupon</h4>
                                        <div>
                                            <form action="javascript:void(0);">
                                                <input type="text" id="checkout-coupon-code" placeholder="Coupon code">
                                                <input type="submit" value="Apply Coupon" id="checkout-apply-coupon">
                                                <button type="button" id="remove-coupon" style="display: none;">Remove Coupon</button>
                                            </form>
                                        </div>
                                    </div>
                                    
                                </div>
                                <div class="your-order">
                                    <h3>Your order</h3>
                                    <div class="your-order-table table-responsive">
                                        <table>
                                            <thead>
                                                <tr>
                                                    <th class="product-name">Product</th>
                                                    <th class="product-total">Total</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php $__currentLoopData = $cart_items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr class="cart_item">
                                                    <td class="product-name">
                                                        <?php echo e($item->name); ?> <span class="product-quantity"> × <?php echo e($item->qty); ?></span>
                                                    </td>
                                                    <?php 
                                                        $subtotal = $item->qty * $item->price; 
                                                    ?>
                                                    <td class="product-total"><b>£ </b>
                                                        <span class="amount"><?php echo e($subtotal); ?></span>
                                                    </td>
                                                </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                            <tfoot>
                                                <tr class="cart-subtotal">
                                                    <th>Cart Subtotal</th>
                                                    <td>£ <span id="subtotal_user"><?php echo e(Cart::subtotal()); ?></span></td>
                                                </tr>
                                                <tr>
                                                    <th>Shipping</th>
                                                    <td>£ <span id="shipping-cost-user">0.00</span></td>
                                                </tr>
                                                <tr class="order-total">
                                                    <th>Order Total</th>
                                                    <td>£ <span id="total_user"><?php echo e(number_format($subtotal, 2)); ?></span>
                                                    </td>
                                                </tr>
                                            </tfoot>
                                        </table>
                                        <!-- Hidden Inputs for Coupon Data -->
                                        <input type="hidden" id="coupon_active" name="coupon_active" value="0">
                                        <input type="hidden" id="coupon_id" name="coupon_id" value="">
                                        <input type="hidden" id="coupon_discount" name="coupon_discount" value="">
                                    </div>
                                    <div class="payment-method">
                                    <!-- Hidden Input to store the selected payment method -->
                                    <input type="hidden" id="selectedPaymentMethod" name="payment_method">

                                    <!-- Accordion Structure for Payment Methods -->
                                    <div class="accordion" id="accordion">

                                    <!-- Cash On Delivery (always shown) -->
                                    <div class="card">
                                        <div class="card-header" id="headingOne">
                                            <button class="btn btn-link" type="button" data-target="#collapseOne">
                                                Cash On Delivery
                                            </button>
                                        </div>
                                        <div id="collapseOne" class="collapse-content" style="display: none;">
                                            <div class="card-body">
                                                Make your payment directly to our delivery man.
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Bkash -->
                                    <?php if(!empty(env('BKASH_USERNAME'))): ?>
                                    <div class="card">
                                        <div class="card-header" id="headingTwo">
                                            <button class="btn btn-link" type="button" data-target="#collapseTwo">
                                                Bkash
                                            </button>
                                        </div>
                                        <div id="collapseTwo" class="collapse-content" style="display: none;">
                                            <div class="card-body">
                                                <?php if(env('BKASH_MODE') === 'merchant'): ?>
                                                    You will be redirected to Bkash payment gateway.
                                                <?php else: ?>
                                                    <p class="no-margin font-15">
                                                        You need to send us the total amount and send your Bkash number<br>
                                                        Account Type: Merchant<br>
                                                        Account Number: <?php echo e(env('BKASH_USERNAME')); ?><br>
                                                        Your bKash Account Number:<br>
                                                        <input type="text" name="bkashNumber" placeholder="01XXXXXXXXX" class="form-control mt-2">
                                                    </p>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                    <?php endif; ?>


                                    <!-- Nagad -->
                                    <?php if(!empty(env('NAGAD_NUMBER'))): ?>
                                    <div class="card">
                                        <div class="card-header" id="headingThree">
                                            <button class="btn btn-link" type="button" data-target="#collapseThree">
                                                Nagad
                                            </button>
                                        </div>
                                        <div id="collapseThree" class="collapse-content" style="display: none;">
                                            <div class="card-body">
                                                <p class="no-margin font-15">
                                                    You need to send us the total amount and send your Nagad number<br>
                                                    Account Type: Merchant<br>
                                                    Account Number: <?php echo e(env('NAGAD_NUMBER')); ?><br>
                                                    Your Nagad Account Number:<br>
                                                    <input type="text" name="nagadNumber" placeholder="01XXXXXXXXX" class="form-control mt-2">
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                    <?php endif; ?>


                                    <!-- Stripe -->
                                    <?php if(!empty(env('STRIPE_KEY')) && !empty(env('STRIPE_SECRET'))): ?>
                                    <div class="card">
                                        <div class="card-header" id="headingStripe">
                                            <button class="btn btn-link" type="button" data-target="#collapseStripe">
                                                Online Payment (Stripe)
                                            </button>
                                        </div>
                                        <div id="collapseStripe" class="collapse-content" style="display: none;">
                                            <div class="card-body">
                                                You will be redirected to Stripe payment gateway.
                                            </div>
                                        </div>
                                    </div>
                                    <?php endif; ?>

                                    <div class="card">
                                        <div class="card-header" id="headingPaypal">
                                            <button class="btn btn-link" type="button" data-target="#collapsePaypal">
                                                Paypal
                                            </button>
                                        </div>
                                        <div id="collapsePaypal" class="collapse-content" style="display: none;">
                                            <div class="card-body">
                                                You will be redirected to paypal payment gateway.
                                            </div>
                                        </div>
                                    </div>

                                    <!-- SSLCommerz -->
                                    <?php if(!empty(env('SSLCZ_STORE_ID')) && !empty(env('SSLCZ_STORE_PASSWORD'))): ?>
                                    <div class="card">
                                        <div class="card-header" id="headingSSL">
                                            <button class="btn btn-link" type="button" data-target="#collapseSSL">
                                                SSLCommerz
                                            </button>
                                        </div>
                                        <div id="collapseSSL" class="collapse-content" style="display: none;">
                                            <div class="card-body">
                                                You will be redirected to SSLCommerz payment gateway.
                                            </div>
                                        </div>
                                    </div>
                                    <?php endif; ?>

                                </div>

                                </div>



                                            <?php if(Cart::count() != 0): ?>
                                                <input value="Place order" class="return-customer-btn" style="
                                                font-size: 14px;
                                                color: #ffffff;
                                                text-transform: uppercase;
                                                border: none;
                                                border-radius: 9999px;
                                                text-align: center;
                                                font-weight: 700;
                                                padding: 12px;
                                                background-color: #e73918; 
                                                min-width: 182px;
                                                margin-top: 20px;
                                                margin-bottom: 23px;
                                                cursor: pointer;
                                                transition: background-color 0.3s ease;
                                            "
                                            type="submit">
                                            <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
        <?php endif; ?>

<?php echo $__env->make('front.layout.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<script>
    /*apply coupon*/
    $(document).ready(function () {
        var coupon_list = <?php echo json_encode($lims_coupon_list); ?>;
        var currency = "£"; // Update this if needed
        var originalTotal = parseFloat($("#total_user").text().replace(/,/g, '')); // Store original total for reverting

        $("#checkout-apply-coupon").on("click", function () {
            applyCheckoutCoupon();
        });

        $("#remove-coupon").on("click", function () {
            removeCheckoutCoupon();
        });

        function applyCheckoutCoupon() {
            var couponCode = $("#checkout-coupon-code").val();
            if (!couponCode) {
                alert("Please enter a coupon code!");
                return;
            }

            var valid = false;
            $.each(coupon_list, function (key, value) {
                if (couponCode === value['code']) {
                    valid = true;
                    var todayDate = <?php echo json_encode(date('Y-m-d')); ?>;

                    if (value['quantity'] <= value['used']) {
                        alert("This Coupon is no longer available.");
                    } else if (todayDate > value['expired_date']) {
                        alert("This Coupon has expired!");
                    } else {
                        var total = originalTotal; // Use original total for calculation
                        var shippingCost = parseAmount($("#shipping-cost-user").text());
                        var discountAmount = 0;

                        if (value['type'] === 'fixed') {
                            if (total >= value['minimum_amount']) {
                                discountAmount = value['amount'];
                                total -= discountAmount;
                                total += shippingCost;
                            } else {
                                alert(
                                    "Order Total is not sufficient for discount! Minimum required: " +
                                        value['minimum_amount'] +
                                        " " +
                                        currency
                                );
                                return;
                            }
                        } else if (value['type'] === 'percentage') {
                            discountAmount = total * (value['amount'] / 100);
                            total -= discountAmount;
                            total += shippingCost;
                        }

                        // Update total
                        $("#total_user").text(total.toFixed(2));

                        // Update hidden fields
                        $("#coupon_active").val(1);
                        $("#coupon_id").val(value['id']);
                        $("#coupon_discount").val(discountAmount.toFixed(2));

                        // Show the remove button and disable coupon input
                        $("#checkout-coupon-code").prop("disabled", true);
                        $("#checkout-apply-coupon").prop("disabled", true);
                        $("#remove-coupon").show();

                        alert(
                            "Congratulations! You got a discount of " +
                                discountAmount.toFixed(2) +
                                " " +
                                currency
                        );
                    }
                }
            });

            if (!valid) {
                alert("Invalid coupon code!");
            }
        }

        function removeCheckoutCoupon() {
            // Reset coupon-related fields
            const couponActiveInput = document.querySelector('input[name="coupon_active"]');
            const couponDiscountInput = document.querySelector('#coupon_discount');
            const discountSpan = document.querySelector("#discount_amount_user");
            const totalSpan = document.querySelector("#total_user");
            const subtotalSpan = document.querySelector("#subtotal_user");
            const shippingSpan = document.querySelector("#shipping-cost-user");

            if (couponActiveInput) couponActiveInput.value = "0";
            if (couponDiscountInput) couponDiscountInput.value = "0";
            if (discountSpan) discountSpan.textContent = "0.00";

            // Recalculate the total without the discount
            updateTotal(subtotalSpan, shippingSpan, totalSpan, couponDiscountInput);

            // Enable the coupon input and apply button
            $("#checkout-coupon-code").prop("disabled", false);
            $("#checkout-apply-coupon").prop("disabled", false);

            // Hide the remove button
            $("#remove-coupon").hide();

            alert("Coupon removed successfully!");
        }
    });


    /*apply coupon ends*/
    /*delivery options*/
    function formatAmount(value) {
        return parseFloat(value).toFixed(2).replace(/\B(?=(\d{3})+(?!\d))/g, ",");
    }

    function parseAmount(value) {
        if (typeof value === 'string') {
            return parseFloat(value.replace(/,/g, '')) || 0;
        }
        return parseFloat(value) || 0;
    }

    function updateTotal(subtotalSpan, shippingSpan, totalSpan, discountSpan) {
        if (!subtotalSpan || !shippingSpan || !totalSpan) return;

        const subtotal = parseAmount(subtotalSpan.textContent);
        const shippingCost = parseAmount(shippingSpan.textContent);
        const discount = discountSpan ? parseAmount(discountSpan.value) : 0; // Read discount from hidden input
        const total = subtotal + shippingCost - discount;

        totalSpan.textContent = formatAmount(Math.max(total, 0)); // Ensure total isn't negative
    }

    function setupDeliveryOptions(options, shippingSpan, totalSpan, subtotalSpan, inputs, discountSpan) {
        options.forEach(option => {
            option.addEventListener('change', function() {
                const shippingCost = parseFloat(this.value) || 0;
                if (shippingSpan) {
                    shippingSpan.textContent = formatAmount(shippingCost);
                }
                
                if (inputs) {
                    inputs.forEach(input => {
                        input.value = shippingCost.toFixed(2);
                    });
                }
                
                updateTotal(subtotalSpan, shippingSpan, totalSpan, discountSpan);
            });
        });
    }

    const userElements = {
        options: document.querySelectorAll('.delivery-option-user'),
        shipping: document.getElementById('shipping-cost-user'),
        total: document.getElementById('total_user'),
        subtotal: document.getElementById('subtotal_user'),
        discount: document.getElementById('coupon_discount'), // Discount input
        inputs: document.querySelectorAll('.shipping-cost-input-user')
    };

    // Setup each form if their elements exist
    [userElements].forEach(elements => {
        if (elements.options.length > 0) {
            setupDeliveryOptions(
                elements.options,
                elements.shipping,
                elements.total,
                elements.subtotal,
                elements.inputs,
                elements.discount // Pass the discount input
            );
        }
    });

    // Initialize all totals
    [userElements].forEach(elements => {
        if (elements.subtotal && elements.shipping && elements.total) {
            updateTotal(elements.subtotal, elements.shipping, elements.total, elements.discount);
        }
    });

</script>

<script>
    document.addEventListener("DOMContentLoaded", function () {
        // Get all the buttons that open the collapsible sections
        const buttons = document.querySelectorAll('.payment-method .card-header button');
        
        // Hide all collapse-content sections initially
        const collapses = document.querySelectorAll('.payment-method .collapse-content');
        collapses.forEach(collapse => {
            collapse.style.display = 'none';
        });

        buttons.forEach((button) => {
            button.addEventListener('click', function () {
                const targetId = this.getAttribute('data-target'); // Get the target collapse ID
                const target = document.querySelector(targetId); // Get the collapse content element

                // Hide all collapse-content sections first
                collapses.forEach(collapse => {
                    collapse.style.display = 'none';
                    collapse.classList.remove('show');
                });

                // Show the selected collapse-content section
                if (target.style.display === "none" || target.style.display === "") {
                    target.style.display = "block";
                    target.classList.add("show");
                } else {
                    target.style.display = "none";
                    target.classList.remove("show");
                }

                // Set the selected payment method in the hidden input
                const methodMap = {
                    'collapseOne': 'cod',
                    'collapseTwo': 'bkash',
                    'collapseThree': 'nagad',
                    'collapseStripe': 'stripe',
                    'collapsePaypal': 'paypal',
                    'collapseSSL': 'sslcommerz'
                };
                const method = methodMap[target.id] || '';
                document.getElementById('selectedPaymentMethod').value = method;
            });
        });

        // Optionally, set the default value if you want the first method to be selected on page load
        const firstMethod = document.querySelector('.payment-method .card-header button');
        if (firstMethod) {
            firstMethod.click(); // This simulates a click on the first payment method button
        }

        //for account information show/hide
        const checkbox = document.getElementById('cbox');
        const infoSection = document.getElementById('cbox_info');

        // Hide the section initially
        infoSection.style.display = 'none';

        // Toggle display on checkbox change
        checkbox.addEventListener('change', function () {
            if (checkbox.checked) {
                infoSection.style.display = 'block';
            } else {
                infoSection.style.display = 'none';
            }
        });

    });
</script>



<?php /**PATH /home/mamusxqr/alamminimarket.co.uk/resources/views/front/checkout.blade.php ENDPATH**/ ?>