 <?php $__env->startSection('content'); ?>

<?php if(session()->has('not_permitted')): ?>
  <div class="alert alert-danger alert-dismissible text-center"><button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button><?php echo e(session()->get('not_permitted')); ?></div> 
<?php endif; ?>
<section class="forms">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header d-flex align-items-center">
                        <h4>Update Slider</h4>
                    </div>
                    <div class="card-body">
                        <p class="italic"><small><?php echo e(trans('file.The field labels marked with * are required input fields')); ?>.</small></p>
                        <?php echo Form::open(['route' => ['slider.update', $lims_user_data->id], 'method' => 'put', 'files' => true]); ?>

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label><strong>Slider Title *</strong> </label>
                                        <input value="<?php echo e($lims_user_data->title); ?>" type="text" name="slider_title" required class="form-control" >
                                        <?php if($errors->has('slider_title')): ?>
                                       <span>
                                           <strong><?php echo e($errors->first('slider_title')); ?></strong>
                                        </span>
                                        <?php endif; ?>
                                    </div>
                                    <div class="form-group">
                                        <label><strong>Details </strong> </label>
                                        <input type="text" name="slider_content1" class="form-control" value="<?php echo e($lims_user_data->slider_content1); ?>">
                                        <?php if($errors->has('slider_content1')): ?>
                                       <span>
                                           <strong><?php echo e($errors->first('slider_content1')); ?></strong>
                                        </span>
                                        <?php endif; ?>
                                    </div>
                                    <div class="form-group">
                                        <label><strong>Link </strong> </label>
                                        <input type="text" name="slider_content2"  class="form-control" value="<?php echo e($lims_user_data->slider_content2); ?>">
                                        <?php if($errors->has('slider_content2')): ?>
                                       <span>
                                           <strong><?php echo e($errors->first('slider_content2')); ?></strong>
                                        </span>
                                        <?php endif; ?>
                                    </div>
                                    <div class="form-group">
                                        <label><strong>Slider Image *</strong> </label>
                                        <input type="file" name="slider_img"  class="form-control" value="<?php echo e($lims_user_data->slider_img); ?>">
                                        <?php if($errors->has('slider_img')): ?>
                                       <span>
                                           <strong><?php echo e($errors->first('slider_img')); ?></strong>
                                        </span>
                                        <?php endif; ?>
                                    </div>
                                    <div class="d-flex align-items-center">
                                        <div class="recent-product-img">
                                            <img src="<?php echo e(url('storage/app/'.$lims_user_data->thumb)); ?>" alt="" style="width: 90px; height: 90px;">
                                        </div>
                                    </div><br>
                                    <div class="form-group">
                                        <input type="submit" value="<?php echo e(trans('file.submit')); ?>" class="btn btn-primary">
                                    </div>
                                </div>                           
                            </div>
                        <?php echo Form::close(); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<script type="text/javascript">
    $("ul#people").siblings('a').attr('aria-expanded','true');
    $("ul#people").addClass("show");
    $('#biller-id').hide();
    $('#warehouseId').hide();
    
    

    $('select[name=role_id]').val($("input[name='role_id_hidden']").val());
    if($('select[name=role_id]').val() > 2){
        $('#warehouseId').show();
        $('select[name=warehouse_id]').val($("input[name='warehouse_id_hidden']").val());
        $('#biller-id').show();
        $('select[name=biller_id]').val($("input[name='biller_id_hidden']").val());
    }
    $('.selectpicker').selectpicker('refresh');

    $('select[name="role_id"]').on('change', function() {
        if($(this).val() > 2){
            $('select[name="warehouse_id"]').prop('required',true);
            $('select[name="biller_id"]').prop('required',true);
            $('#biller-id').show();
            $('#warehouseId').show();
        }
        else{
            $('select[name="warehouse_id"]').prop('required',false);
            $('select[name="biller_id"]').prop('required',false);
            $('#biller-id').hide();
            $('#warehouseId').hide();
        }
    });

    $('#genbutton').on("click", function(){
      $.get('../genpass', function(data){
        $("input[name='password']").val(data);
      });
    });

</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mamusxqr/alamminimarket.co.uk/resources/views/slider/edit.blade.php ENDPATH**/ ?>