 <?php $__env->startSection('content'); ?>

<?php if(session()->has('not_permitted')): ?>
  <div class="alert alert-danger alert-dismissible text-center"><button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button><?php echo e(session()->get('not_permitted')); ?></div> 
<?php endif; ?>
<section class="forms">
    <div class="container-fluid" style="padding-bottom: 20px;">
    <!-- Trigger the modal with a button -->
    <a href="<?php echo e(route('page.create')); ?>" class="btn btn-info"><i class="dripicons-plus"></i> Add New Page</a>
</div>
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header d-flex align-items-center">
                        <h4>Update Page</h4>
                    </div>
                    <div class="card-body">
                        <p class="italic"><small><?php echo e(trans('file.The field labels marked with * are required input fields')); ?>.</small></p>
                        <?php echo Form::open(['route' => ['page.update', $lims_user_data->id], 'method' => 'put', 'files' => true]); ?>

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label><strong>Page Title *</strong> </label>
                                        <input value="<?php echo e($lims_user_data->name); ?>" type="text" name="page_title" required class="form-control" >
                                        <?php if($errors->has('page_title')): ?>
                                       <span>
                                           <strong><?php echo e($errors->first('page_title')); ?></strong>
                                        </span>
                                        <?php endif; ?>
                                    </div>
                                    <div class="form-group">
                                        <label><strong>Introduction</strong> </label>
                                        <input type="text" name="intro"  class="form-control" value="<?php echo e($lims_user_data->intro); ?>">
                                    </div>
                                    <div class="col-md-12"> 
                                        <div class="form-group">
                                            <label><strong>Description</strong></label>
                                            <textarea name="desc" class="form-control" rows="5"><?php echo e($lims_user_data->desc); ?></textarea>

                                        </div>
                                    </div>
                                    <!-- <div class="form-group">
                                        <label><strong>Quote</strong> </label>
                                        <input type="text" name="quote"  class="form-control" value="<?php echo e($lims_user_data->quote); ?>">
                                    </div> -->

                                    <div class="form-group">
                                        <label><strong>Current Page Image</strong></label>
                                        <div>
                                            <img src="<?php echo e(asset('storage/app/' . $lims_user_data->thumb)); ?>" alt="Page Image" style="max-width: 200px; max-height: 200px;">
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label><strong>Change Page Image</strong></label>
                                        <input type="file" name="page_img" class="form-control" value="<?php echo e($lims_user_data->thumb); ?>">
                                    </div>
                                    <div class="form-group">
                                        <input type="submit" value="<?php echo e(trans('file.submit')); ?>" class="btn btn-primary">
                                    </div>
                                </div>                           
                            </div>
                        <?php echo Form::close(); ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<script type="text/javascript">
    $("ul#people").siblings('a').attr('aria-expanded','true');
    $("ul#people").addClass("show");
    $('#biller-id').hide();
    $('#warehouseId').hide();
    
    

    $('select[name=role_id]').val($("input[name='role_id_hidden']").val());
    if($('select[name=role_id]').val() > 2){
        $('#warehouseId').show();
        $('select[name=warehouse_id]').val($("input[name='warehouse_id_hidden']").val());
        $('#biller-id').show();
        $('select[name=biller_id]').val($("input[name='biller_id_hidden']").val());
    }
    $('.selectpicker').selectpicker('refresh');

    $('select[name="role_id"]').on('change', function() {
        if($(this).val() > 2){
            $('select[name="warehouse_id"]').prop('required',true);
            $('select[name="biller_id"]').prop('required',true);
            $('#biller-id').show();
            $('#warehouseId').show();
        }
        else{
            $('select[name="warehouse_id"]').prop('required',false);
            $('select[name="biller_id"]').prop('required',false);
            $('#biller-id').hide();
            $('#warehouseId').hide();
        }
    });

    $('#genbutton').on("click", function(){
      $.get('../genpass', function(data){
        $("input[name='password']").val(data);
      });
    });
    
    /* Text Editor */
    tinymce.init({
      selector: 'textarea',
      height: 130,
      plugins: [
        'advlist autolink lists link image charmap print preview anchor textcolor',
        'searchreplace visualblocks code fullscreen',
        'insertdatetime media table contextmenu paste code wordcount'
      ],
      toolbar: 'insert | undo redo |  formatselect | bold italic backcolor  | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | removeformat',
      branding:false
    });

</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mamusxqr/alamminimarket.co.uk/resources/views/page/edit.blade.php ENDPATH**/ ?>