

<?php $__env->startSection('content'); ?>
<section>
    <div class="container-fluid">
        <!-- Trigger the modal with a button -->
        <a href="<?php echo e(route('dcs.create')); ?>" class="btn btn-info"><i class="dripicons-plus"></i> Add Delivery Charge</a>
    </div>
    <div class="table-responsive">
        <table id="delivery-table" class="table" style="width: 100%">
            <thead>
                <tr>
                    <th class="not-exported"></th>
                    <th>Location</th>
                    <th>Delivery Charge</th>
                    <th class="not-exported"><?php echo e(trans('file.action')); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php $serialNumber = 1; ?> <!-- Initialize serial number -->
                <?php $__currentLoopData = $deliveryCharges ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $deliveryCharge): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($serialNumber); ?></td>
                    <td><?php echo e($deliveryCharge->location); ?></td>
                    <td><?php echo e($deliveryCharge->charge); ?></td>
                    <td>
                        <div class="btn-group">
                            <button type="button" class="btn btn-default btn-sm dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <?php echo e(trans('file.action')); ?>

                                <span class="caret"></span>
                                <span class="sr-only">Toggle Dropdown</span>
                            </button>
                            <ul class="dropdown-menu edit-options dropdown-menu-right dropdown-default" user="menu">
                                <li>
                                    <a href="<?php echo e(route('dcs.edit', $deliveryCharge->id)); ?>" class="btn btn-link">
                                        <i class="dripicons-document-edit"></i> <?php echo e(trans('file.edit')); ?>

                                    </a>
                                </li>
                                <li class="divider"></li>
                                <?php echo e(Form::open(['route' => ['dcs.destroy', $deliveryCharge->id], 'method' => 'DELETE'] )); ?>

                                <li>
                                    <button type="submit" class="btn btn-link" onclick="return confirmDelete()">
                                        <i class="dripicons-trash"></i> <?php echo e(trans('file.delete')); ?>

                                    </button>
                                </li>
                                <?php echo e(Form::close()); ?>

                            </ul>
                        </div>
                    </td>
                </tr>
                <?php $serialNumber++; ?> <!-- Increment serial number -->
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
</section>

<script type="text/javascript">
    $("ul#cms").siblings('a').attr('aria-expanded','true');
    $("ul#cms").addClass("show");
    $("ul#cms #faq-menu").addClass("active");

    function confirmDelete() {
        return confirm("Are you sure you want to delete this delivery charge?");
    }

    $(document).ready(function() {
        $('#delivery-table').DataTable({
            "order": [],
            'language': {
                'lengthMenu': '_MENU_ <?php echo e(trans("file.records per page")); ?>',
                "info": '<small><?php echo e(trans("file.Showing")); ?> _START_ - _END_ (_TOTAL_)</small>',
                "search": '<?php echo e(trans("file.Search")); ?>',
                'paginate': {
                    'previous': '<i class="dripicons-chevron-left"></i>',
                    'next': '<i class="dripicons-chevron-right"></i>'
                }
            },
            'columnDefs': [
                {
                    "orderable": false,
                    'targets': [0, 3]
                },
                {
                    'render': function(data, type, row, meta) {
                        if (type === 'display') {
                            data = '<div class="checkbox"><input type="checkbox" class="dt-checkboxes"><label></label></div>';
                        }
                        return data;
                    },
                    'checkboxes': {
                        'selectRow': true,
                        'selectAllRender': '<div class="checkbox"><input type="checkbox" class="dt-checkboxes"><label></label></div>'
                    },
                    'targets': [0]
                }
            ],
            'select': { style: 'multi', selector: 'td:first-child' },
            'lengthMenu': [[10, 25, 50, -1], [10, 25, 50, "All"]],
            dom: '<"row"lfB>rtip',
            buttons: [
                {
                    extend: 'pdf',
                    text: '<?php echo e(trans("file.PDF")); ?>',
                    exportOptions: {
                        columns: ':visible:Not(.not-exported)',
                        rows: ':visible'
                    },
                },
                {
                    extend: 'csv',
                    text: '<?php echo e(trans("file.CSV")); ?>',
                    exportOptions: {
                        columns: ':visible:Not(.not-exported)',
                        rows: ':visible'
                    },
                },
                {
                    extend: 'print',
                    text: '<?php echo e(trans("file.Print")); ?>',
                    exportOptions: {
                        columns: ':visible:Not(.not-exported)',
                        rows: ':visible'
                    },
                },
                {
                    text: '<?php echo e(trans("file.delete")); ?>',
                    className: 'buttons-delete',
                    action: function(e, dt, node, config) {
                        var user_verified = <?php echo json_encode(env('USER_VERIFIED')) ?>;
                        if (user_verified == '1') {
                            var ids = [];
                            $(':checkbox:checked').each(function(i) {
                                if (i) {
                                    ids[i-1] = $(this).closest('tr').data('id');
                                }
                            });
                            if (ids.length && confirm("Are you sure you want to delete?")) {
                                $.ajax({
                                    type: 'POST',
                                    url: 'dcs/deletebyselection',
                                    data: {
                                        idArray: ids
                                    },
                                    success: function(data) {
                                        alert(data);
                                    }
                                });
                                dt.rows({ page: 'current', selected: true }).remove().draw(false);
                            } else if (!ids.length)
                                alert('No delivery charge is selected!');
                        } else
                            alert('This feature is disabled for demo!');
                    }
                },
                {
                    extend: 'colvis',
                    text: '<?php echo e(trans("file.Column visibility")); ?>',
                    columns: ':gt(0)'
                },
            ],
        });
    });

    if(all_permission.indexOf("users-delete") == -1)
        $('.buttons-delete').addClass('d-none');
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mamusxqr/alamminimarket.co.uk/resources/views/delivery_charge/index.blade.php ENDPATH**/ ?>