

<?php $__env->startSection('content'); ?>

<?php if(session()->has('message')): ?>
  <div class="alert alert-success alert-dismissible text-center">
    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
      <span aria-hidden="true">&times;</span>
    </button>
    <?php echo e(session()->get('message')); ?>

  </div>
<?php endif; ?>

<?php if(session()->has('not_permitted')): ?>
  <div class="alert alert-danger alert-dismissible text-center">
    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
      <span aria-hidden="true">&times;</span>
    </button>
    <?php echo e(session()->get('not_permitted')); ?>

  </div>
<?php endif; ?>

<section class="forms">
  <div class="container-fluid">
    <div class="row">
      <div class="col-md-12">
        <div class="card">
          <div class="card-header d-flex align-items-center">
            <h4>Payment Gateway Settings</h4>
          </div>
          <div class="card-body">
            <p class="italic"><small>The field labels marked with * are required input fields.</small></p>

            <?php echo Form::open(['route' => 'setting.pgStore', 'method' => 'post']); ?>

            <div class="row">

              
              <div class="col-md-6">
                <div class="form-group">
                  <label>Select Payment Gateways</label><br>

                  <div class="form-check">
                    <input class="form-check-input gateway-toggle" type="checkbox" name="gateway[]" value="sslcommerz" id="sslcommerz"
                      <?php echo e(env('SSLCZ_STORE_PASSWORD') ? 'checked' : ''); ?>>
                    <label class="form-check-label" for="sslcommerz">SSLCommerz</label>
                  </div>

                  <div class="form-check">
                    <input class="form-check-input gateway-toggle" type="checkbox" name="gateway[]" value="stripe" id="stripe"
                      <?php echo e(env('STRIPE_KEY') ? 'checked' : ''); ?>>
                    <label class="form-check-label" for="stripe">Stripe</label>
                  </div>

                  <div class="form-check">
                    <input class="form-check-input gateway-toggle" type="checkbox" name="gateway[]" value="bkash" id="bkash"
                      <?php echo e(env('BKASH_USERNAME') ? 'checked' : ''); ?>>
                    <label class="form-check-label" for="bkash">bKash</label>
                  </div>

                  <div class="form-check">
                    <input class="form-check-input gateway-toggle" type="checkbox" name="gateway[]" value="nagad" id="nagad"
                      <?php echo e(env('NAGAD_NUMBER') ? 'checked' : ''); ?>>
                    <label class="form-check-label" for="nagad">Nagad</label>
                  </div>

                  <div class="form-check">
                    <input class="form-check-input gateway-toggle" type="checkbox" name="gateway[]" value="paypal" id="paypal"
                      <?php echo e(env('PAYPAL_CLIENT_ID') || env('PAYPAL_SECRET') ? 'checked' : ''); ?>>
                    <label class="form-check-label" for="paypal">PayPal</label>
                  </div>

                </div>
              </div>

              
              <div class="col-md-6 gateway-section sslcommerz-section" style="display:none;">
                <h5>SSLCommerz</h5>

                
                <div class="form-group">
                  <label>Select Account *</label>
                  <select name="sslcommerz_account_id" class="form-control sslcommerz-input" required>
                    <option value="">-- Select Account --</option>
                    <?php $__currentLoopData = $account_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                      <option value="<?php echo e($account->id); ?>" <?php echo e(($paymentgateway_accounts['sslcommerz'] ?? null) == $account->id ? 'selected' : ''); ?>>
                        <?php echo e($account->name); ?>

                      </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  </select>
                </div>


                
                <div class="form-group form-check">
                  <input type="checkbox" class="form-check-input sslcommerz-input" name="sslcommerz_sandbox"
                         id="sslcommerz_sandbox" value="1" <?php echo e(env('SSLCZ_TESTMODE') == 'true' ? 'checked' : ''); ?>>
                  <label class="form-check-label" for="sslcommerz_sandbox">Enable Sandbox Mode</label>
                </div>

                <div class="form-group">
                  <label>Store ID *</label>
                  <input type="text" name="ssl_store_id" class="form-control sslcommerz-input" value="<?php echo e(env('SSLCZ_STORE_ID')); ?>">
                </div>
                <div class="form-group">
                  <label>Store Password *</label>
                  <input type="text" name="ssl_store_password" class="form-control sslcommerz-input" value="<?php echo e(env('SSLCZ_STORE_PASSWORD')); ?>">
                </div>
              </div>

              
                <div class="col-md-6 gateway-section bkash-section" style="display:none;">
                <h5>bKash</h5>
                <div class="form-group form-check">
                  <input type="checkbox" class="form-check-input bkash-input" name="bkash_sandbox"
                         id="bkash_sandbox" value="1" <?php echo e(env('SANDBOX') == 'true' ? 'checked' : ''); ?>>
                  <label class="form-check-label" for="bkash_sandbox">Enable Sandbox Mode</label>
                </div>
                  <div class="form-group">
                    <label>Mode</label>
                    <select name="bkash_mode" class="form-control bkash-input" id="bkash_mode">
                      <option value="merchant" <?php echo e(env('BKASH_MODE') == 'merchant' ? 'selected' : ''); ?>>Merchant (Online Payment)</option>
                      <option value="manual" <?php echo e(env('BKASH_MODE') == 'manual' ? 'selected' : ''); ?>>Manual (Display Number)</option>
                    </select>
                  </div>

                  <div class="form-group">
                    <label>bKash Number *</label>
                    <input type="text" name="bkash_number" class="form-control bkash-input" value="<?php echo e(env('BKASH_USERNAME')); ?>">
                  </div>

                  
                  <div class="bkash-merchant-fields" style="display:none;">
                    <div class="form-group">
                      <label>Select Account *</label>
                      <select name="bkash_account_id" class="form-control bkash-input" required>
                        <option value="">-- Select Account --</option>
                        <?php $__currentLoopData = $account_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                          <option value="<?php echo e($account->id); ?>" <?php echo e(($paymentgateway_accounts['bkash'] ?? null) == $account->id ? 'selected' : ''); ?>>
                            <?php echo e($account->name); ?>

                          </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                      </select>
                    </div>

                    
                    <div class="form-group">
                      <label>bKash Password *</label>
                      <input type="text" name="bkash_password" class="form-control" value="<?php echo e(env('BKASH_PASSWORD')); ?>">
                    </div>
                    <div class="form-group">
                      <label>bKash App Key *</label>
                      <input type="text" name="bkash_app_key" class="form-control" value="<?php echo e(env('BKASH_APP_KEY')); ?>">
                    </div>
                    <div class="form-group">
                      <label>bKash App Secret *</label>
                      <input type="text" name="bkash_app_secret" class="form-control" value="<?php echo e(env('BKASH_APP_SECRET')); ?>">
                    </div>
                  </div>
                </div>

              
              <div class="col-md-6 gateway-section stripe-section" style="display:none;">
                <h5>Stripe</h5>
                <div class="form-group">
                  <label>Select Account *</label>
                  <select name="stripe_account_id" class="form-control stripe-input" required>
                    <option value="">-- Select Account --</option>
                    <?php $__currentLoopData = $account_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                      <option value="<?php echo e($account->id); ?>" <?php echo e(($paymentgateway_accounts['stripe'] ?? null) == $account->id ? 'selected' : ''); ?>>
                        <?php echo e($account->name); ?>

                      </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  </select>
                </div>


                <div class="form-group">
                  <label>Publishable Key *</label>
                  <input type="text" name="stripe_publishable_key" class="form-control stripe-input" value="<?php echo e(env('STRIPE_KEY')); ?>">
                </div>
                <div class="form-group">
                  <label>Secret Key *</label>
                  <input type="text" name="stripe_secret_key" class="form-control stripe-input" value="<?php echo e(env('STRIPE_SECRET')); ?>">
                </div>
              </div>

              


              
              <div class="col-md-6 gateway-section nagad-section" style="display:none;">
                <h5>Nagad</h5>
                <div class="form-group">
                  <label>Nagad Number *</label>
                  <input type="text" name="nagad_number" class="form-control nagad-input" value="<?php echo e(env('NAGAD_NUMBER')); ?>">
                </div>
              </div>

              
              <div class="col-md-6 gateway-section paypal-section" style="display:none;">
                <h5>PayPal</h5>

                <div class="form-group form-check">
                  <input type="checkbox" class="form-check-input paypal-input" name="paypal_sandbox"
                         id="paypal_sandbox" value="1" <?php echo e(env('PAYPAL_MODE') == 'sandbox' ? 'checked' : ''); ?>>
                  <label class="form-check-label" for="paypal_sandbox">Enable Sandbox Mode</label>
                </div>
                <div class="form-group">
                      <label>Select Account *</label>
                      <select name="paypal_account_id" class="form-control paypal-input" required>
                        <option value="">-- Select Account --</option>
                        <?php $__currentLoopData = $account_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                          <option value="<?php echo e($account->id); ?>" <?php echo e(($paymentgateway_accounts['paypal'] ?? null) == $account->id ? 'selected' : ''); ?>>
                            <?php echo e($account->name); ?>

                          </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                      </select>
                    </div>

                <div class="form-group">
                  <label>Sandbox Client ID *</label>
                  <input type="text" name="paypal_client_id" class="form-control paypal-input" value="<?php echo e(env('PAYPAL_CLIENT_ID')); ?>">
                </div>
                <div class="form-group">
                  <label>Sandbox Client Secret *</label>
                  <input type="text" name="paypal_secret" class="form-control paypal-input" value="<?php echo e(env('PAYPAL_SECRET')); ?>">
                </div>

                <div class="form-group">
                  <label>App ID</label>
                  <input type="text" name="paypal_app_id" class="form-control paypal-input" value="<?php echo e(env('PAYPAL_APP_ID')); ?>">
                </div>

                <div class="form-group">
                  <label>Currency</label>
                  <input type="text" name="paypal_currency" class="form-control paypal-input" value="<?php echo e(env('PAYPAL_CURRENCY', 'USD')); ?>">
                </div>

              </div>


              <div class="col-12 mt-3">
                <input type="submit" value="Submit" class="btn btn-primary">
              </div>

            </div>
            <?php echo Form::close(); ?>

          </div>
        </div>
      </div>
    </div>
  </div>
</section>


<script type="text/javascript">
  $(document).ready(function () {
    function toggleGatewaySection(gateway) {
      const section = $(`.${gateway}-section`);
      const inputs = $(`.${gateway}-input`);
      const checkbox = $(`#${gateway}`);

      if (checkbox.is(':checked')) {
        section.show();
        inputs.prop('required', true);
        if (gateway === 'bkash') toggleBkashMode(); // handle inner logic
      } else {
        section.hide();
        inputs.prop('required', false).val('');
        if (gateway === 'bkash') $('.bkash-merchant-fields').hide();
      }
    }

    function toggleBkashMode() {
      const mode = $('#bkash_mode').val();
      if (mode === 'merchant') {
        $('.bkash-merchant-fields').show();
        $('.bkash-merchant-fields input').prop('required', true);
      } else {
        $('.bkash-merchant-fields').hide();
        $('.bkash-merchant-fields input').prop('required', false).val('');
      }
    }

    // Event listener for bKash mode change
    $(document).on('change', '#bkash_mode', function () {
      toggleBkashMode();
    });

    // Initial toggle setup
    $('.gateway-toggle').on('change', function () {
      toggleGatewaySection($(this).val());
    });

    $('.gateway-toggle').each(function () {
      toggleGatewaySection($(this).val());
    });
  });
</script>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mamusxqr/alamminimarket.co.uk/resources/views/setting/paymentgateway_setting.blade.php ENDPATH**/ ?>