<?php echo $__env->make('front.layout.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php if(session()->has('success')): ?>
    <div class="alert alert-danger alert-dismissible text-center"><button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button><?php echo e(session()->get('success')); ?></div> 
<?php endif; ?>
<?php if(session()->has('error')): ?>
    <div class="alert alert-danger alert-dismissible text-center"><button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button><?php echo e(session()->get('error')); ?></div> 
<?php endif; ?>

        <!-- Breadcrumb Area Start Here -->
        <div class="breadcrumb-area">
            <div class="container">
                <ol class="breadcrumb breadcrumb-list">
                    <li class="breadcrumb-item"><a href="<?php echo e(url('/')); ?>">Home</a></li>
                    <li class="breadcrumb-item active">shop</li>
                </ol>
            </div>
        </div>
        <!-- Breadcrumb Area End Here -->
   

    <div class="page-contain category-page no-sidebar">
        <div class="container">
            <div class="row">

                <!-- Main content -->
                <div id="main-content" class="main-content col-lg-12 col-md-12 col-sm-12 col-xs-12">

                    <div class="product-category grid-style">

                        <div id="top-functions-area" class="top-functions-area" >
                            <div class="flt-item to-left group-on-mobile"></div>
                            <div class="flt-item to-right">
                                <span class="flt-title">Sort</span>
                                <div class="wrap-selectors">
                                    <div class="selector-item orderby-selector">
                                        

                                        <select name="orderby" class="sorter" id="sort-by" aria-label="Shop order">
                                            <option value="default" <?php echo e(request()->input('sort', 'default') == 'default' ? 'selected' : ''); ?>>Default sorting</option>
                                            <option value="name_asc" <?php echo e(request()->input('sort') == 'name_asc' ? 'selected' : ''); ?>>Name, A to Z</option>
                                            <option value="name_desc" <?php echo e(request()->input('sort') == 'name_desc' ? 'selected' : ''); ?>>Name, Z to A</option>
                                            <option value="price_asc" <?php echo e(request()->input('sort') == 'price_asc' ? 'selected' : ''); ?>>Price low to high</option>
                                            <option value="price_desc" <?php echo e(request()->input('sort') == 'price_desc' ? 'selected' : ''); ?>>Price high to low</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <ul class="products-list products">
                                <div class="product-sorting">
                                    <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php $images = explode(",", $product->image);
                                        $primaryImage = isset($images[0]) ? $images[0] : '';
                                        $hoverImage = isset($images[1]) ? $images[1] : $primaryImage;?>
                                        <li class="product-item col-lg-4 col-md-4 col-sm-4 col-xs-6 productitem">
                                            <div class="contain-product layout-default containproduct">
                                                <div class="product-thumb">
                                                    <a href="<?php echo e(url('/single-product')); ?>/<?php echo e($product->id); ?>" class="link-to-product">
                                                        <img src="<?php echo e(url('public/images/product', $primaryImage)); ?>" alt="<?php echo e($product->name); ?>" width="270" height="270" class="product-thumnail">
                                                    </a>
                                                </div>
                                                <div class="info">
                                                    <?php $category = App\Category::find($product->category_id);?>
                                                    <b class="categories"><?php echo e($category->name); ?></b>
                                                    <h4 class="product-title"><a href="<?php echo e(url('/single-product')); ?>/<?php echo e($product->id); ?>" class="pr-name"><?php echo e($product->name); ?></a></h4>

                                                    <div class="price ">
                                                            <?php if($product->promotion_price != null): ?>
                                                            <ins><span class="price-amount"><span class="currencySymbol">£</span><?php echo e($product->promotion_price); ?></span></ins>

                                                            <del><span class="price-amount"><span class="currencySymbol">£</span><?php echo e($product->price); ?></span></del>
                                                            <?php else: ?>
                                                            
                                                            <ins><span class="price-amount"><span class="currencySymbol">£</span><?php echo e($product->price); ?></span></ins>
                                                            <?php endif; ?>
                                                        </div>
                                                    

                                                    <div class="slide-down-box">

                                                        <div class="buttons">    
                                                        <?php if($product->is_variant == null): ?>
                                                            <?php if($product->qty > 0): ?>
                                                                <form id="addItem<?php echo e($product->id); ?>" action="<?php echo e(url('cart/addItem')); ?>" method="POST" class="variants add">
                                                                <?php echo csrf_field(); ?>
                                                                    <input type="hidden" name="quantity" value="1">
                                                                    <input type="hidden" name="product_id" value="<?php echo e($product->id); ?>">
                                                                    <input type="hidden" name="name" value="<?php echo e($product->name); ?>">
                                                                <?php if($product->promotion_price != null): ?>
                                                                    <input type="hidden" name="price" value="<?php echo e($product->promotion_price); ?>">
                                                                <?php else: ?>
                                                                    <input type="hidden" name="price" value="<?php echo e($product->price); ?>">
                                                                <?php endif; ?> 
                                                                </form> 
                                                                    <a href="#" onclick="document.getElementById('addItem<?php echo e($product->id); ?>').submit();" class="btn add-to-cart-btn"><i class="fa fa-cart-arrow-down" aria-hidden="true"></i>add to cart</a>
                                                            <?php else: ?>
                                                                <a href="/single-product/${product.id}" class="btn add-to-cart-btn disabled">
                                                                    <i class="fa fa-ban" aria-hidden="true"></i> Out Of Stock
                                                                </a> 
                                                            <?php endif; ?>
                                                        <?php else: ?>
                                                            <a href="/single-product/${product.id}" class="btn add-to-cart-btn">
                                                                <i class="fa fa-cart-arrow-down" aria-hidden="true"></i> Add To Cart
                                                            </a>
                                                        <?php endif; ?>
                                                                   
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>    
                                </div>             
                            </ul>
                        </div>
                            <?php echo e($products->links('front.content.pagination')); ?>

                                
                    </div>

                    <div class="block-item recently-products-cat md-margin-bottom-39" style="clear: both;">
                        <ul class="products-list biolife-carousel nav-center-02 nav-none-on-mobile" data-slick='{"rows":1,"arrows":true,"dots":false,"infinite":false,"speed":400,"slidesMargin":0,"slidesToShow":5, "responsive":[{"breakpoint":1200, "settings":{ "slidesToShow": 3}},{"breakpoint":992, "settings":{ "slidesToShow": 3, "slidesMargin":30}},{"breakpoint":768, "settings":{ "slidesToShow": 2, "slidesMargin":10}}]}' >
                            <?php $__currentLoopData = $featured_products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php $images = explode(",", $product->image);
                                    $primaryImage = isset($images[0]) ? $images[0] : '';
                                    $hoverImage = isset($images[1]) ? $images[1] : $primaryImage;?>
                            <li class="product-item">
                                <div class="contain-product layout-02">
                                    <div class="product-thumb">
                                        <a href="<?php echo e(url('/single-product')); ?>/<?php echo e($product->id); ?>" class="link-to-product">
                                            <img src="<?php echo e(url('public/images/product', $primaryImage)); ?>" alt="<?php echo e($product->name); ?>" width="270" height="270" class="product-thumnail">
                                        </a>
                                    </div>
                                    <div class="info">
                                         <?php $category = App\Category::find($product->category_id);?>
                                        <b class="categories"><?php echo e($category->name); ?></b>
                                        <h4 class="product-title"><a href="<?php echo e(url('/single-product')); ?>/<?php echo e($product->id); ?>" class="pr-name"><?php echo e($product->name); ?></a></h4>
                                            <div class="price ">
                                                    <?php if($product->promotion_price != null): ?>
                                                    <ins><span class="price-amount"><span class="currencySymbol">£</span><?php echo e($product->promotion_price); ?></span></ins>

                                                    <del><span class="price-amount"><span class="currencySymbol">£</span><?php echo e($product->price); ?></span></del>
                                                    <?php else: ?>
                                                    
                                                    <ins><span class="price-amount"><span class="currencySymbol">£</span><?php echo e($product->price); ?></span></ins>
                                                    <?php endif; ?>
                                                </div>
                                    </div>
                                </div>
                            </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>

                </div>

            </div>
        </div>
    </div>
        <!-- Shop Page End -->
        <!-- Footer Area Start Here -->
        <?php echo $__env->make('front.layout.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <!-- Footer Area End Here -->
        <!-- Quick View Content Start -->
<script>
    var baseUrl = "<?php echo e(url('')); ?>";

    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });

    $(document).ready(function () {
        $('.sorter').on('change', function () {
            const sortBy = $(this).val();
            const currentUrl = new URL(window.location.href);

            // Update or add the 'sort' query parameter
            currentUrl.searchParams.set('sort', sortBy);

            // Redirect to the updated URL
            window.location.href = currentUrl.toString();
        });
    });


    function updateProductList(products) {
        const productContainer = document.querySelector('.product-sorting');
        productContainer.innerHTML = ''; // Clear existing products

        products.data.forEach(product => {
            const images = product.image ? product.image.split(",") : [];
            const primaryImage = images.length > 0 ? images[0] : '';

            const reducedPrice = product.promotion_price ? (product.price - product.promotion_price) : 0;
            const percentage = reducedPrice > 0 ? ((reducedPrice / product.price) * 100).toFixed(2) : null;
            
            let productHtml = `
                <li class="product-item col-lg-4 col-md-4 col-sm-4 col-xs-6">
                    <div class="contain-product layout-default">
                                        <div class="product-thumb">
                            <a href="${baseUrl}/single-product/${product.id}" class="link-to-product">
                                <img src="${baseUrl}/public/images/product/${primaryImage}" alt="product-img" width="270" height="270" class="product-thumnail">
                            </a></div>
                            <div class="info">

                            <h4 class="product-title"><a href="/single-product/${product.id}" class="pr-name">${product.name}</a></h4>

                                            <div class="price ">
                                                    <?php if($product->promotion_price != null): ?>
                                                    <ins><span class="price-amount"><span class="currencySymbol">£</span>${product.promotion_price}</span></ins>

                                                    <del><span class="price-amount"><span class="currencySymbol">£</span>${product.promotion_price || product.price}</span></del>
                                                    <?php else: ?>
                                                    
                                                    <ins><span class="price-amount"><span class="currencySymbol">£</span>${product.promotion_price || product.price}</span></ins>
                                                    <?php endif; ?>
                                                </div>
                    
                            <div class="slide-down-box">
                                <div class="buttons"> 
                                        ${getAddToCartButton(product)}
                                </div>
                            </div>
                        </div>
                    </div>
                </li>
            `;

            productContainer.insertAdjacentHTML('beforeend', productHtml);
        });
    }

    

    function getAddToCartButton(product) {

        if (product.is_variant == null) {
            if (product.qty > 0) {
                return `
                    <div class="buttons">
                        <form id="addItem${product.id}" action="<?php echo e(url('cart/addItem')); ?>" method="POST" class="variants add">
                            <input type="hidden" name="_token" value="${document.querySelector('meta[name="csrf-token"]').getAttribute('content')}">
                            <input type="hidden" name="quantity" value="1">
                            <input type="hidden" name="product_id" value="${product.id}">
                            <input type="hidden" name="name" value="${product.name}">
                            <input type="hidden" name="price" value="${product.promotion_price !== null ? product.promotion_price : product.price}">
                        </form>
                        <a href="#" onclick="document.getElementById('addItem${product.id}').submit();" class="btn add-to-cart-btn">
                            <i class="fa fa-cart-arrow-down" aria-hidden="true"></i>add to cart
                        </a>
                    </div>
                `;
            } else {
                return `
                    <div class="buttons">
                        <a href="/single-product/${product.id}" class="btn add-to-cart-btn disabled">
                            <i class="fa fa-ban" aria-hidden="true"></i> Out Of Stock
                        </a>
                    </div>

                `;
            }
        } else {
            return `
                <div class="buttons">
                    <a href="/single-product/${product.id}" class="btn add-to-cart-btn">
                        <i class="fa fa-cart-arrow-down" aria-hidden="true"></i> Add To Cart
                    </a>
                </div>

            `;
        }
    }


    function getProductRating(reviews) {
        let totalStars = 0;
        let number = 0;

        if (reviews && reviews.length > 0) {
            number = reviews.length;
            totalStars = reviews.reduce((sum, review) => sum + review.stars, 0);
        }

        const averageRating = number > 0 ? totalStars / number : 0;

        let ratingHtml = '<div class="rating">';
        for (let i = 1; i <= 5; i++) {
            ratingHtml += `<i class="font-13 fa fa-${i <= Math.round(averageRating) ? 'star' : 'star-o'}"></i>`;
        }
        ratingHtml += '</div>';

        return ratingHtml;
    }

    function updatePagination(products) {
        const paginationContainer = document.querySelector('.pagination'); // Ensure this is the correct selector
        paginationContainer.innerHTML = products.links; // Update pagination links
    }
</script>

<script>
    window.addEventListener('load', function () {
        let maxHeight = 0;
        document.querySelectorAll('.productitem .containproduct').forEach(function(el) {
            el.style.height = 'auto'; // reset first
            maxHeight = Math.max(maxHeight, el.offsetHeight);
        });
        document.querySelectorAll('.productitem .containproduct').forEach(function(el) {
            el.style.height = maxHeight + 'px';
        });
    });
</script>
<?php /**PATH /home/mamusxqr/alamminimarket.co.uk/resources/views/front/shop.blade.php ENDPATH**/ ?>