@extends('layout.main')
@section('content')

<section>
    <div class="container-fluid">
        <a href="{{route('volunteer.create')}}" class="btn btn-info"><i class="dripicons-plus"></i> Add Staff</a>
    </div>
    <div class="table-responsive">
        <table id="volunteer-table" class="table" style="width: 100%">
            <thead>
                <tr>
                    <th class="not-exported"></th>
                    <th>Name</th>
                    <th>Title</th>
                    <th>Image</th>
                    <th class="not-exported">{{trans('file.action')}}</th>
                </tr>
            </thead>
            <tbody>
                @php $serialNumber = 1; @endphp
                @foreach($lims_volunteer_all ?? [] as $slider)
                <tr data-id="{{ $slider->id }}">
                    <td>{{ $serialNumber++ }}</td>
                    <td>{{ $slider->title }}</td>
                    <td>{{ $slider->details }}</td>
                    <td>
                        <div class="d-flex align-items-center">
                            <div class="recent-product-img">
                                <img src="{{ url('storage/app/'.$slider->thumb) }}" alt="Volunteer Image" style="width: 90px; height: 90px;">
                            </div>
                        </div>
                    </td>
                    <td>
                        <div class="btn-group">
                            <button type="button" class="btn btn-default btn-sm dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">{{trans('file.action')}}
                                <span class="caret"></span>
                                <span class="sr-only">Toggle Dropdown</span>
                            </button>
                            <ul class="dropdown-menu edit-options dropdown-menu-right dropdown-default" user="menu">
                                <li>
                                    <a href="{{ route('volunteer.edit', $slider->id) }}" class="btn btn-link"><i class="dripicons-document-edit"></i> {{trans('file.edit')}}</a>
                                </li>
                                <li class="divider"></li>
                                {{ Form::open(['route' => ['volunteer.destroy', $slider->id], 'method' => 'DELETE']) }}
                                <li>
                                    <button type="submit" class="btn btn-link" onclick="return confirmDelete()"><i class="dripicons-trash"></i> {{trans('file.delete')}}</button>
                                </li>
                                {{ Form::close() }}
                            </ul>
                        </div>
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</section>

<script type="text/javascript">
    $(document).ready(function() {
        $("ul#cms").siblings('a').attr('aria-expanded', 'true');
        $("ul#cms").addClass("show");
        $("ul#cms #slider-menu").addClass("active");

        $('#volunteer-table').DataTable({
            responsive: true,
            fixedHeader: {
                header: true,
                footer: true
            },
            "order": [], // No initial sorting
            'language': {
                'lengthMenu': '_MENU_ {{trans("file.records per page")}}',
                "info":      '<small>{{trans("file.Showing")}} _START_ - _END_ (_TOTAL_)</small>',
                "search":  '{{trans("file.Search")}}',
                'paginate': {
                    'previous': '<i class="dripicons-chevron-left"></i>',
                    'next': '<i class="dripicons-chevron-right"></i>'
                }
            },
            'columnDefs': [
                {
                    "orderable": false, // Disable ordering for certain columns
                    'targets': [0, 4] // Serial number and actions columns
                },
            ],
            'select': { style: 'multi',  selector: 'td:first-child' },
            'lengthMenu': [[10, 25, 50, -1], [10, 25, 50, "All"]],
            dom: '<"row"lfB>rtip',
            buttons: [
                {
                    extend: 'pdf',
                    text: '{{trans("file.PDF")}}',
                    exportOptions: {
                        columns: ':visible:not(.not-exported)',
                        rows: ':visible'
                    },
                },
                {
                    extend: 'csv',
                    text: '{{trans("file.CSV")}}',
                    exportOptions: {
                        columns: ':visible:not(.not-exported)',
                        rows: ':visible'
                    },
                },
                {
                    extend: 'print',
                    text: '{{trans("file.Print")}}',
                    exportOptions: {
                        columns: ':visible:not(.not-exported)',
                        rows: ':visible'
                    },
                },
                {
                    extend: 'colvis',
                    text: '{{trans("file.Column visibility")}}',
                    columns: ':gt(0)' // Show column visibility button
                },
            ],
        });
    });

    function confirmDelete() {
        return confirm("Are you sure you want to delete this volunteer?");
    }
</script>

@endsection
