@extends('layout.main') 
@section('content')

@if(session()->has('success'))
  <div class="alert alert-success alert-dismissible text-center">
      <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
      {{ session()->get('success') }}
  </div> 
@endif

<section class="forms">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header d-flex align-items-center">
                        <h4>SEO & Script Settings</h4>
                    </div>
                    <div class="card-body">
                        <p class="italic"><small>Fields marked with * are optional but recommended for SEO & Analytics integration.</small></p>
                        
                        {!! Form::open(['route' => 'setting.site_settings_store', 'method' => 'post']) !!}
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Google Analytics ID</label>
                                    <input type="text" name="google_analytics_id" class="form-control" value="{{ $site_setting->google_analytics_id ?? '' }}">
                                </div>

                                <div class="form-group">
                                    <label>Google Tag Manager ID</label>
                                    <input type="text" name="google_tag_manager_id" class="form-control" value="{{ $site_setting->google_tag_manager_id ?? '' }}">
                                </div>

                                <div class="form-group">
                                    <label>Google Search Console Meta</label>
                                    <input type="text" name="google_search_console_meta" class="form-control" value="{{ $site_setting->google_search_console_meta ?? '' }}">
                                </div>

                                <div class="form-group">
                                    <label>Bing Webmaster Meta</label>
                                    <input type="text" name="bing_webmaster_meta" class="form-control" value="{{ $site_setting->bing_webmaster_meta ?? '' }}">
                                </div>
                                <div class="form-group">
                                    <label>Yandex Webmaster Meta</label>
                                    <input type="text" name="yandex_webmaster_meta" class="form-control" value="{{ $site_setting->yandex_webmaster_meta ?? '' }}">
                                </div>

                            </div>


                            <div class="col-md-6">
                                
                                <div class="form-group">
                                    <label>Facebook Pixel ID</label>
                                    <input type="text" name="facebook_pixel_id" class="form-control" value="{{ $site_setting->facebook_pixel_id ?? '' }}">
                                </div>

                                <div class="form-group">
                                    <label>Twitter Pixel ID</label>
                                    <input type="text" name="twitter_pixel_id" class="form-control" value="{{ $site_setting->twitter_pixel_id ?? '' }}">
                                </div>

                                <div class="form-group">
                                    <label>Custom &lt;head&gt; Scripts</label>
                                    <textarea name="custom_head_scripts" rows="3" class="form-control">{{ $site_setting->custom_head_scripts ?? '' }}</textarea>
                                </div>

                                <div class="form-group">
                                    <label>Custom &lt;body&gt; Scripts</label>
                                    <textarea name="custom_body_scripts" rows="3" class="form-control">{{ $site_setting->custom_body_scripts ?? '' }}</textarea>
                                </div>

                                
                            </div>
                            <div class="form-group">
                                    <input type="submit" value="Update Settings" class="btn btn-primary">
                                </div>
                        </div>
                        {!! Form::close() !!}
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<script type="text/javascript">
    $("ul#setting").siblings('a').attr('aria-expanded','true');
    $("ul#setting").addClass("show");
    $("ul#setting #seo-setting-menu").addClass("active");
</script>

@endsection
