@extends('layout.main')
@section('content')

<section class="forms">
    <div class="container-fluid">
        <div class="card">
            <div class="card-header mt-2">
                <h4 class="text-center">SMS Report</h4>
            </div>
            {!! Form::open(['route' => 'report.sms', 'method' => 'post']) !!}
            <div class="col-md-6 offset-md-3 mt-4 mb-3">
                <div class="form-group row">
                    <label class="d-tc mt-2"><strong>{{ trans('file.Choose Your Date') }}</strong>&nbsp;</label>
                    <div class="d-tc">
                        <div class="input-group">
                            <input type="text" class="daterangepicker-field form-control" value="{{ $startDate }} To {{ $endDate }}" required />
                            <input type="hidden" name="start_date" value="{{ $startDate }}" />
                            <input type="hidden" name="end_date" value="{{ $endDate }}" />
                            <div class="input-group-append">
                                <button class="btn btn-primary" type="submit">{{ trans('file.submit') }}</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            {!! Form::close() !!}
        </div>
    </div>

    <div class="container-fluid mt-3">
        <div class="alert alert-info">
            <strong>Total SMS Sent:</strong> {{ $totalMessagesSent }} |
            <strong>Total SMS Units Used:</strong> {{ $totalSmsUnitsUsed }} |
            <strong>Remaining SMS:</strong> {{ $remainingSms }} |
            <strong>Success:</strong> {{ $statusSummary['Success'] }} |
            <strong>Failed:</strong> {{ $statusSummary['Failed'] }}
        </div>
    </div>

    <div class="table-responsive mb-4">
        <table id="report-table" class="table table-hover">
            <thead>
                <tr>
                    <th class="not-exported"></th>
                    <th>{{ trans('file.Date') }}</th>
                    <th>{{ trans('file.Message') }}</th>
                    <th>Recipient</th>
                    <th>Number</th>
                    <th>{{ trans('file.Status') }}</th>
                    <th>SMS Count</th>
                </tr>
            </thead>
            <tbody>
                @foreach($smsList as $sms)
                    @foreach($sms->details as $key => $detail)
                    <tr>
                        <td>{{ $key + 1 }}</td>
                        <td>{{ $sms->created_at->format('Y-m-d H:i:s') }}</td>
                        <td>{{ Str::limit($sms->message, 50) }}</td>
                        <td>
                            @if($detail->customer_id)
                                {{ optional($detail->customer)->name }}
                            @else
                                N/A
                            @endif
                        </td>
                        <td>
                            @if($detail->customer_id)
                                {{ optional($detail->customer)->phone_number }}
                            @else
                                {{ $detail->number ?? 'N/A' }}
                            @endif
                         </td>
                        <td>
                            @if(str_contains($detail->status, '"Status":"0"'))
                                <span class="badge badge-success">Success</span>
                            @else
                                <span class="badge badge-danger">Failed</span>
                            @endif
                        </td>
                        <td>{{ $detail->counter }}</td>
                    </tr>
                    @endforeach
                @endforeach
            </tbody>
            <tfoot class="tfoot active">
                <th></th>
                <th colspan="5" class="text-right">{{ trans('file.Total') }}:</th>
                <th>{{ $totalSmsUnitsUsed }}</th>
            </tfoot>
        </table>
    </div>
</section>

<script type="text/javascript">

    $("ul#report").siblings('a').attr('aria-expanded','true');
    $("ul#report").addClass("show");
    $("ul#report #sms-report-menu").addClass("active");

    $('#report-table').DataTable({
        "order": [],
        'language': {
            'lengthMenu': '_MENU_ {{trans("file.records per page")}}',
            "info":      '<small>{{trans("file.Showing")}} _START_ - _END_ (_TOTAL_)</small>',
            "search":  '{{trans("file.Search")}}',
            'paginate': {
                'previous': '<i class="dripicons-chevron-left"></i>',
                'next': '<i class="dripicons-chevron-right"></i>'
            }
        },
        'columnDefs': [
            {
                "orderable": false,
                'targets': 0
            },
            {
                'render': function(data, type, row, meta){
                    if(type === 'display'){
                        data = '<div class="checkbox"><input type="checkbox" class="dt-checkboxes"><label></label></div>';
                    }
                    return data;
                },
                'checkboxes': {
                    'selectRow': true,
                    'selectAllRender': '<div class="checkbox"><input type="checkbox" class="dt-checkboxes"><label></label></div>'
                },
                'targets': [0]
            }
        ],
        'select': { style: 'multi', selector: 'td:first-child' },
        'lengthMenu': [[10, 25, 50, -1], [10, 25, 50, "All"]],
        dom: '<"row"lfB>rtip',
        buttons: [
            {
                extend: 'pdf',
                text: '{{trans("file.PDF")}}',
                exportOptions: {
                    columns: ':visible:Not(.not-exported)',
                    rows: ':visible'
                }
            },
            {
                extend: 'csv',
                text: '{{trans("file.CSV")}}',
                exportOptions: {
                    columns: ':visible:Not(.not-exported)',
                    rows: ':visible'
                }
            },
            {
                extend: 'print',
                text: '{{trans("file.Print")}}',
                exportOptions: {
                    columns: ':visible:Not(.not-exported)',
                    rows: ':visible'
                }
            },
            {
                extend: 'colvis',
                text: '{{trans("file.Column visibility")}}',
                columns: ':gt(0)'
            }
        ]
    });

    $(".daterangepicker-field").daterangepicker({
        callback: function(startDate, endDate, period){
            var start_date = startDate.format('YYYY-MM-DD');
            var end_date = endDate.format('YYYY-MM-DD');
            var title = start_date + ' To ' + end_date;
            $(this).val(title);
            $('input[name="start_date"]').val(start_date);
            $('input[name="end_date"]').val(end_date);
        }
    });

</script>
@endsection
