@extends('layout.main') @section('content')
@if(session()->has('message'))
  <div class="alert alert-success alert-dismissible text-center"><button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>{!! session()->get('message') !!}</div> 
@endif
<section class="forms">
    <div class="container-fluid">

        <h3>Statement of Profit or Loss & other Comprehensive Income</h3>
       
    </div>
    <div class="table-responsive mb-4">
        <table id="account-table" class="table table-hover cell-border compact stripe">
            <thead>
                <tr>
                    <th class="not-exported"></th>
                    <th>Particular</th>
                    <th>{{$start_date}} To {{$end_date}}</th>
                    <th></th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>1</td>
                    <td><strong>Turnover(Sales)</strong></td>
                    <td><strong>{{$turnover}}</strong></td>
                    <td></td>
                </tr>
                <tr>
                    <td></td>
                    <td>Sales</td>
                    <td style="border: 2px solid;">{{$sales}}</td>
                    <td></td>
                </tr>
                <tr>
                    <td></td>
                    <td>less Sales Return</td>
                    <td style="border: 2px solid;">({{$sales_return}})</td>
                    <td></td>
                </tr>

                <!-- cost of goods sold -->
                <tr>
                    <td>2</td>
                    <td><strong>Cost of goods sold</strong></td>
                    <td><strong>{{$total_cog}}</strong></td>
                    <td></td>
                </tr>
                
                <tr style="background-color:#E6E6E6">
                        <td></td>
                        <td><strong>Gross Profit/Loss</strong></td>
                        <td><strong>{{$gross_profit}}</strong></td>
                        <td></td>
                    </tr>
                <!--end of gross profit / loss calculation  -->
               

               <tr>
                        <td>3</td>
                        <td><strong>Operating Expense</strong></td>
                        <td><strong>{{$total_expense}}</strong></td>
                        <td></td>
                </tr>
               @if($lims_expense_by_category != null)
                   @foreach($lims_expense_by_category as $key=>$expense)
                    <?php 

                        $expense_amount = App\Expense::whereDate('created_at', '>=' , $start_date)->whereDate('created_at', '<=' , $end_date)->where('expense_category_id',$expense->expense_category_id)->sum('amount');
                        $expense_acc = App\ExpenseCategory::find($expense->expense_category_id);

                     ?>
                        <tr>
                            <td></td>
                            <td>{{$expense_acc->name}}</td>
                            <td style="border: 2px solid;">{{$expense_amount}}</td>
                            <td></td>
                        </tr>
                   @endforeach
               @endif
                
                     <tr style="background-color:#E6E6E6">
                        <td></td>
                        <td><strong>operating profit/(Loss)</strong></td>
                        <td><strong>{{$operating_profit}}</strong></td>
                        <td></td>
                    </tr>
                <!-- end of operating profit (gross profit - expense) -->

                <!-- operating profit (gross profit - expense) -->
                     <tr>
                        <td></td>
                        <td><strong>Other Income</strong></td>
                        <td><strong>{{$other_income}}</strong></td>
                        <td></td>
                    </tr>

                    @if($investment_cr-$investment_dr != 0 )
                    <tr>
                        <td></td>
                        <td>Investments</td>
                        <td style="border: 2px solid;">{{$investment_cr-$investment_dr}}</td>
                        <td></td>
                    </tr>
                    @endif

                    @if($bankdeposit_cr-$bankdeposit_dr != 0)
                    <tr>
                        <td></td>
                        <td>Bank Deposits</td>
                        <td style="border: 2px solid;">{{$bankdeposit_cr-$bankdeposit_dr}}</td>
                        <td></td>
                    </tr>
                    @endif

                    @if($payable_loan != 0)
                    <tr>
                        <td></td>
                        <td>Payable Loan</td>
                        <td style="border: 2px solid;">{{$payable_loan}}</td>
                        <td></td>
                    </tr>
                    @endif

                    @if($receivable_loan != 0)
                    <tr>
                        <td></td>
                        <td>Receivable Loan</td>
                        <td style="border: 2px solid;">{{$receivable_loan}}</td>
                        <td></td>
                    </tr>
                    @endif

                <!-- end of operating profit (gross profit - expense) -->
                
                 <!-- operating profit (gross profit - expense) -->
                     <tr style="background-color:#E6E6E6">
                        <td></td>
                        <td>Net Profit/(loss)</td>
                        <td>{{$net_profit}}</td>
                        <td></td>
                    </tr>
                <!-- end of operating profit (gross profit - expense) -->


               
            </tbody>
        </table>
    </div>
</section>

<script type="text/javascript">
    $("ul#report").siblings('a').attr('aria-expanded','true');
    $("ul#report").addClass("show");
    $("ul#report #pl-menu").addClass("active");

    
    
    $("#print-btn").on("click", function(){
          var divToPrint=document.getElementById('turnover-details');
          var newWin=window.open('','Print-Window');
          newWin.document.open();
          newWin.document.write('<link rel="stylesheet" href="<?php echo asset('public/vendor/bootstrap/css/bootstrap.min.css') ?>" type="text/css"><style type="text/css">@media print {.modal-dialog { max-width: 1000px;} }</style><body onload="window.print()">'+divToPrint.innerHTML+'</body>');
          newWin.document.close();
          setTimeout(function(){newWin.close();},10);
    });


    
    
    $("#print-btn").on("click", function(){
          var divToPrint=document.getElementById('cog-details');
          var newWin=window.open('','Print-Window');
          newWin.document.open();
          newWin.document.write('<link rel="stylesheet" href="<?php echo asset('public/vendor/bootstrap/css/bootstrap.min.css') ?>" type="text/css"><style type="text/css">@media print {.modal-dialog { max-width: 1000px;} }</style><body onload="window.print()">'+divToPrint.innerHTML+'</body>');
          newWin.document.close();
          setTimeout(function(){newWin.close();},10);
    });

    
    
    $("#print-btn").on("click", function(){
          var divToPrint=document.getElementById('income-details');
          var newWin=window.open('','Print-Window');
          newWin.document.open();
          newWin.document.write('<link rel="stylesheet" href="<?php echo asset('public/vendor/bootstrap/css/bootstrap.min.css') ?>" type="text/css"><style type="text/css">@media print {.modal-dialog { max-width: 1000px;} }</style><body onload="window.print()">'+divToPrint.innerHTML+'</body>');
          newWin.document.close();
          setTimeout(function(){newWin.close();},10);
    });
    var table = $('#account-table').DataTable( {
        "paging": false,
        "order": [],
        'language': {
            'lengthMenu': '_MENU_ {{trans("file.records per page")}}',
             "info":      '<small>{{trans("file.Showing")}} _START_ - _END_ (_TOTAL_)</small>',
            "search":  '{{trans("file.Search")}}',
            'paginate': {
                    'previous': '<i class="dripicons-chevron-left"></i>',
                    'next': '<i class="dripicons-chevron-right"></i>'
            }
        },
        'columnDefs': [
            {
                "orderable": false,
                'targets': 0,

            },
            {
                'render': function(data, type, row, meta){
                    if(type === 'display'){
                        data = '<div class="checkbox"><input type="checkbox" class="dt-checkboxes"><label></label></div>';
                    }

                   return data;
                },
                'checkboxes': {
                   'selectRow': true,
                   'selectAllRender': '<div class="checkbox"><input type="checkbox" class="dt-checkboxes"><label></label></div>'
                },
                'targets': [0]
            }
        ],
        'select': { style: 'multi',  selector: 'td:first-child'},
        'lengthMenu': [[10, 25, 50, -1], [10, 25, 50, "All"]],
        dom: '<"row"lfB>rtip',

        buttons: [
            {
                extend: 'pdf',
                text: '{{trans("PDF")}}',
                footer: true,
                exportOptions: {
                    columns: ':visible:Not(.not-exported)',
                    rows: ':visible'
                },
                title: 'Statement of Profit or Loss & other Comprehensive Income for {{$start_date}} to {{$end_date}}',
                customize: function (doc) {
                var tblBody = doc.content[1].table.body;

                // ***
                //This section creates evenly distributed full width table
                // 
                doc.content[1].table.widths = 
                Array(doc.content[1].table.body[0].length + 1).join('*').split('');
                // ***
                //This section creates a grid border layout
                // ***
                doc.content[1].layout = {
                hLineWidth: function(i, node) {
                    return (i === 0 || i === node.table.body.length) ? 2 : 1;},
                vLineWidth: function(i, node) {
                    return (i === 0 || i === node.table.widths.length) ? 2 : 1;},
                hLineColor: function(i, node) {
                    return (i === 0 || i === node.table.body.length) ? 'black' : 'gray';},
                vLineColor: function(i, node) {
                    return (i === 0 || i === node.table.widths.length) ? 'black' : 'gray';},
                };
                // ***
                //This section loops thru each row in table looking for where either
                //the second or third cell is empty.
                //If both cells empty changes rows background color to '#FFF9C4'
                //if only the third cell is empty changes background color to '#FFFDE7'
                // ***
                $('#tableID').find('tr').each(function (ix, row) {
                    var index = ix;
                    var rowElt = row;
                    $(row).find('td').each(function (ind, elt) {
                        if (tblBody[index][1].text == '' && tblBody[index][2].text == '') {
                            delete tblBody[index][ind].style;
                            tblBody[index][ind].fillColor = '#FFF9C4';
                        }
                        else
                        {
                            if (tblBody[index][2].text == '') {
                                delete tblBody[index][ind].style;
                                tblBody[index][ind].fillColor = '#FFFDE7';
                            }
                        }
                    });
                });
                // Create a footer object with 2 columns
                // Left side: report creation date
                // Right side: current page and total pages
                doc['footer']=(function(page, pages) {
                    return {
                        columns: [
                            {
                                alignment: 'left',
                                text: ['Prepared By: ']
                            },
                            {
                                alignment: 'left',
                                text: ['Received By: ']
                            }
                        ],
                        margin: 20
                    }
                });
            }               
            },
            
            {
                extend: 'csv',
                text: '{{trans("file.CSV")}}',
                exportOptions: {
                    columns: ':visible:Not(.not-exported)',
                    rows: ':visible'
                }
            },
            {
                extend: 'print',
                text: '{{trans("file.Print")}}',
                exportOptions: {
                    columns: ':visible:Not(.not-exported)',
                    rows: ':visible'
                }
            },
            {
                extend: 'colvis',
                text: '{{trans("file.Column visibility")}}',
                columns: ':gt(0)'
            },
        ],

        
    } );



</script>
@endsection