@extends('layout.main') @section('content')
@if(session()->has('message'))
  <div class="alert alert-success alert-dismissible text-center"><button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>{!! session()->get('message') !!}</div> 
@endif
<section class="forms">
    <div class="container-fluid">
        <h3>Investment Report</h3>
        <strong>{{trans('file.Account')}}:</strong> {{$investor->investor_name}} [{{$investor->id}}]
    </div>
    <div class="table-responsive mb-4">
        <table id="account-table" class="table table-hover">
            <thead>
                <tr>
                    <th class="not-exported"></th>
                    <th>{{trans('file.date')}}</th>
                    <th>Investment</th>
                    <th>Return of Investment</th>
                    <th>{{trans('file.Balance')}}</th>
                </tr>
            </thead>
            <tbody>
                <?php $previous_dates = []; $balance = 0;?>
                @foreach($transactionDates as $key=>$date)
                <?php
                     
                    /*for the row investment. Shows only the investment for the perticular dates */
                        $amount_invested = App\Investment::where('investor_id', $investor->id)->where('option','Deposit')->where('date','=',$date)->sum('amount');
                        $amount_withdraw = App\Investment::where('investor_id', $investor->id)->where('option','Withdraw')->where('date','=',$date)->sum('amount');
                        $amount_total = $amount_invested - $amount_withdraw;
                    /*for the row investment. Shows only the investment for the perticular dates */

                    /*for finding investor's ratio upto the row's date*/
                        $previous_dates[] = $date;
                        $is_invested = App\Investment::where('investor_id', $investor->id)->where('date','<=',$date)->first();

                        $deposit= App\Investment::where('investor_id', $investor->id)->where('date','<=',$date)->where('option','Deposit')->sum('amount');
                        $withdraw = App\Investment::where('investor_id', $investor->id)->where('date','<=',$date)->where('option','Withdraw')->sum('amount');

                        if($is_invested){
                            $investment = $deposit - $withdraw; //total investment done by the selected investor 
                        }
                        else{
                            $investment = 0;
                        }

                        $total_investment= App\Investment::where('date','<=',$date)->sum('amount');
                        $investors_ratio = $investment/$total_investment; 
                    /*for finding investor's ratio upto the row's date*/

                    /*finding the profit*/
                    if($key != 0){
                      
                        $sale = App\Sale::whereDate('created_at', '=' , $date)->sum('grand_total');
                        $product_sale_data = App\Product_Sale::select(DB::raw('product_id, product_batch_id, sum(qty) as sold_qty, sum(total) as sold_amount'))->whereDate('created_at', '=' , $date)->groupBy('product_id', 'product_batch_id')->get();

                    }
                    else{
                        $sale = App\Sale::whereDate('created_at', '=' , $date)->sum('grand_total');
                        $product_sale_data = App\Product_Sale::select(DB::raw('product_id, product_batch_id, sum(qty) as sold_qty, sum(total) as sold_amount'))->whereDate('created_at', '=' , $date)->groupBy('product_id', 'product_batch_id')->get();
                                            }

                    $product_revenue = 0;
                    $product_cost = 0;
                    $product_tax = 0;
                    $profit = 0;
                    foreach ($product_sale_data as $key => $product_sale) {
                        if($product_sale->product_batch_id)
                            $product_purchase_data = App\ProductPurchase::where([
                                ['product_id', $product_sale->product_id],
                                ['product_batch_id', $product_sale->product_batch_id]
                            ])->get();
                        else
                            $product_purchase_data = App\ProductPurchase::where('product_id', $product_sale->product_id)->get();

                        $purchased_qty = 0;
                        $purchased_amount = 0;
                        $purchased_tax = 0;
                        $sold_qty = $product_sale->sold_qty;
                        $product_revenue += $product_sale->sold_amount;
                        foreach ($product_purchase_data as $key => $product_purchase) {
                            $purchased_qty += $product_purchase->qty;
                            $purchased_amount += $product_purchase->total;
                            $purchased_tax += $product_purchase->tax;
                            if($purchased_qty >= $sold_qty) {
                                $qty_diff = $purchased_qty - $sold_qty;
                                $unit_cost = $product_purchase->total / $product_purchase->qty;
                                $unit_tax = $product_purchase->tax / $product_purchase->qty;
                                $purchased_amount -= ($qty_diff * $unit_cost);
                                $purchased_tax -= ($qty_diff * $unit_tax);
                                break;
                            }
                        }
                        $product_cost += $purchased_amount;
                        $product_tax += $purchased_tax;
                    }
                    $profit = $sale - ($product_cost-$product_tax) ;

                    $return=$investors_ratio * $profit ;

                    $balance= $return + $balance;
                ?>
               
                <tr>
                    <td>{{$key}}</td>
                    <td>{{$date}}</td>
                    <td>{{$amount_total}}</td>
                    <td>{{$return}}</td>
                    <td>{{$balance}}</td>
                </tr>
                @endforeach


            </tbody>
        </table>
    </div>
</section>

<script type="text/javascript">
    $("ul#report").siblings('a').attr('aria-expanded','true');
    $("ul#report").addClass("show");
    $("ul#report #inv-report-menu").addClass("active");

    var table = $('#account-table').DataTable( {
        "order": [],
        'language': {
            'lengthMenu': '_MENU_ {{trans("file.records per page")}}',
             "info":      '<small>{{trans("file.Showing")}} _START_ - _END_ (_TOTAL_)</small>',
            "search":  '{{trans("file.Search")}}',
            'paginate': {
                    'previous': '<i class="dripicons-chevron-left"></i>',
                    'next': '<i class="dripicons-chevron-right"></i>'
            }
        },
        'columnDefs': [
            {
                "orderable": false,
                'targets': 0
            },
            {
                'render': function(data, type, row, meta){
                    if(type === 'display'){
                        data = '<div class="checkbox"><input type="checkbox" class="dt-checkboxes"><label></label></div>';
                    }

                   return data;
                },
                'checkboxes': {
                   'selectRow': true,
                   'selectAllRender': '<div class="checkbox"><input type="checkbox" class="dt-checkboxes"><label></label></div>'
                },
                'targets': [0]
            }
        ],
        'select': { style: 'multi',  selector: 'td:first-child'},
        'lengthMenu': [[10, 25, 50, -1], [10, 25, 50, "All"]],
        dom: '<"row"lfB>rtip',
        buttons: [
            {
                extend: 'pdf',
                text: '{{trans("file.PDF")}}',
                exportOptions: {
                    columns: ':visible:Not(.not-exported)',
                    rows: ':visible'
                }
            },
            {
                extend: 'csv',
                text: '{{trans("file.CSV")}}',
                exportOptions: {
                    columns: ':visible:Not(.not-exported)',
                    rows: ':visible'
                }
            },
            {
                extend: 'print',
                text: '{{trans("file.Print")}}',
                exportOptions: {
                    columns: ':visible:Not(.not-exported)',
                    rows: ':visible'
                }
            },
            {
                extend: 'colvis',
                text: '{{trans("file.Column visibility")}}',
                columns: ':gt(0)'
            },
        ],
    } );

</script>
@endsection