@extends('layout.main') @section('content')
@if(session()->has('not_permitted'))
  <div class="alert alert-danger alert-dismissible text-center"><button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>{{ session()->get('not_permitted') }}</div> 
@endif
<section class="forms">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header d-flex align-items-center">
                        <h4>Update Payable Loan</h4>
                    </div>
                    <div class="card-body">
                        <p class="italic"><small>{{trans('file.The field labels marked with * are required input fields')}}.</small></p>
                        {!! Form::open(['route' => ['payable_loan.update', $lims_payable_loans->id], 'method' => 'put', 'files' => true]) !!}
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Loan reference *</strong> </label>
                                    <input type="text" name="reference_no" value="{{$lims_payable_loans->reference_no}}" required class="form-control">
                                </div>
                            </div>
                           
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Amount *</label>
                                    <input type="text" name="amount" value="{{$lims_payable_loans->amount}}" required class="form-control">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Date *</label>
                                    <input type="date" name="date" value="{{$lims_payable_loans->date}}" required class="form-control">
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Due Date *</label>
                                    <input type="date" name="due_date" value="{{$lims_payable_loans->due_date}}" required class="form-control">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Borrowed From *</strong> </label>
                                    <input type="text" name="borrowed_from" value="{{$lims_payable_loans->borrowed_from}}" required class="form-control">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Interest Rate *</strong> </label>
                                    <input type="text" name="interest_rate" value="{{$lims_payable_loans->interest_rate}}" required class="form-control">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>No of Installments *</strong> </label>
                                    <input type="text" name="no_of_installments" value="{{$lims_payable_loans->no_of_installments}}" required class="form-control">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>{{trans('file.Note')}}</label>
                                    <textarea rows="5" class="form-control" name="note" >{{ $lims_payable_loans->note }}</textarea>
                                </div>
                            </div>

                            

                            
                            <div class="col-md-12">
                                <div class="form-group mt-3">
                                    <input type="submit" value="{{trans('file.submit')}}" class="btn btn-primary">
                                </div>
                            </div>
                        </div>
                        {!! Form::close() !!}
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<script type="text/javascript">
    $("ul#account").siblings('a').attr('aria-expanded','true');
    $("ul#account").addClass("show");
    $("ul#account #payableloan-list-menu").addClass("active");
</script>
@endsection
