@extends('layout.main')

@section('content')
<section class="forms">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header d-flex align-items-center">
                        <h4>Edit Mail Settings</h4>
                    </div>
                    <div class="card-body">
                        @if(session()->has('success'))
                            <div class="alert alert-success alert-dismissible text-center">
                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                                {{ session()->get('success') }}
                            </div>
                        @endif

                        {!! Form::model($mailSetting, ['route' => ['mail-settings.update', $mailSetting->id], 'method' => 'put']) !!}
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label><strong>Mail Host *</strong></label>
                                        <input type="text" name="mail_host" class="form-control" required value="{{$mailSetting->mail_host}}">
                                    </div>
                                    <div class="form-group">
                                        <label><strong>Mail Port *</strong></label>
                                        <input type="number" name="mail_port" class="form-control" required value="{{$mailSetting->mail_port}}">
                                    </div>
                                    <div class="form-group">
                                        <label><strong>Mail Username *</strong></label>
                                        <input type="text" name="mail_username" class="form-control" required value="{{$mailSetting->mail_username}}">
                                    </div>
                                    <div class="form-group">
                                        <label><strong>Mail Password *</strong></label>
                                        <input type="password" name="mail_password" class="form-control" required value="{{$mailSetting->mail_password}}">
                                    </div>
                                    <div class="form-group">
                                        <label><strong>Mail Encryption *</strong></label>
                                        <input type="text" name="mail_encryption" class="form-control" required value="{{$mailSetting->mail_encryption}}">
                                    </div>
                                    <div class="form-group">
                                        <input type="submit" value="Submit" class="btn btn-primary">
                                    </div>
                                </div>
                            </div>
                        {!! Form::close() !!}
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
@endsection
