@extends('layout.main') @section('content')
@if(session()->has('not_permitted'))
  <div class="alert alert-danger alert-dismissible text-center"><button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>{{ session()->get('not_permitted') }}</div> 
@endif
<section class="forms">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header d-flex align-items-center">
                        <h4>Update Investment</h4>
                    </div>
                    <div class="card-body">
                        <p class="italic"><small>{{trans('file.The field labels marked with * are required input fields')}}.</small></p>
                        {!! Form::open(['route' => ['investment.update', $lims_investment_data->id], 'method' => 'put', 'files' => true]) !!}
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Investment Ref *</strong> </label>
                                    <input type="text" name="investment_id" value="{{$lims_investment_data->investment_id}}" required class="form-control">
                                </div>
                            </div>
                           
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Investor *</label>
                                    <?php $investors= App\Investor::get(); ?>
                                    <input type="hidden" name="investor_id_hidden" value="{{$lims_investor_data->id}}" />

                                        <div class="input-group">
                                          <select name="investor_id" class="selectpicker form-control" data-live-search="true" data-live-search-style="begins" title="Select Investor...">
                                            @foreach($investors as $investor)
                                                <option value="{{$investor->id}}">{{$investor->investor_name}}</option>
                                            @endforeach    
                                          </select>
                                        </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Amount *</label>
                                    <input type="text" name="amount" value="{{$lims_investment_data->amount}}" required class="form-control">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Date *</label>
                                    <input type="date" name="date" value="{{$lims_investment_data->date}}" required class="form-control">
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Payment Methode *</label>
                                    <input type="hidden" name="mathod_id_hidden" value="{{$lims_investment_data->payment_method}}" />
                                    <div class="input-group">
                                          <select name="payment_method" class="selectpicker form-control" data-live-search="true" data-live-search-style="begins" title="Select Investor...">
                                                <option value="Bank">Bank</option>
                                                <option value="bKash">bKash</option>
                                                <option value="Nagad">Nagad</option>
                                          </select>
                                        </div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Account ID *</label>
                                    <input type="hidden" name="account_id_hidden" value="{{$lims_investment_data->account_id}}" />
                                    <div class="input-group">
                                          <select name="account_id" class="selectpicker form-control" data-live-search="true" data-live-search-style="begins" title="Select Account...">
                                            @foreach($account as $acc)
                                                <option value="{{$acc->id}}">{{$acc->name}} ({{ $acc->account_no}})</option>
                                            @endforeach    
                                          </select>
                                        </div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Option *</label>
                                        <input type="hidden" name="mathod_option_hidden" value="{{$lims_investment_data->option}}" />

                                        <div class="input-group">
                                          <select name="option" class="selectpicker form-control" data-live-search="true" data-live-search-style="begins" title="Select Option...">
                                                <option value="Withdraw">Withdraw</option>
                                                <option value="Deposit">Deposit</option>
                                          </select>
                                      </div>  
                                </div>
                            </div>
                            
                            <div class="col-md-12">
                                <div class="form-group mt-3">
                                    <input type="submit" value="{{trans('file.submit')}}" class="btn btn-primary">
                                </div>
                            </div>
                        </div>
                        {!! Form::close() !!}
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<script type="text/javascript">
    $("ul#account").siblings('a').attr('aria-expanded','true');
    $("ul#account").addClass("show");
    $("ul#account #investment-list-menu").addClass("active");
    $('select[name="account_id"]').val($('input[name="account_id_hidden"]').val());
    $('select[name="investor_id"]').val($('input[name="investor_id_hidden"]').val());
    
    $('select[name="option"]').val($('input[name="mathod_option_hidden"]').val());
</script>
@endsection
