@include('front.layout.header2')
@if(session()->has('success'))
    <div class="alert alert-danger alert-dismissible text-center"><button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>{{ session()->get('success') }}</div> 
@endif
@if(session()->has('error'))
    <div class="alert alert-danger alert-dismissible text-center"><button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>{{ session()->get('error') }}</div> 
@endif

        <!-- Main Header Area Three End Here -->

        <!-- Main Header Area End Here -->
        <!-- Breadcrumb Area Start Here -->
        <div class="breadcrumb-area">
            <div class="container">
                <ol class="breadcrumb breadcrumb-list">
                    <li class="breadcrumb-item"><a href="{{url('/')}}">Home</a></li>
                    <li class="breadcrumb-item active">shop</li>
                </ol>
            </div>
        </div>
        <!-- Breadcrumb Area End Here -->
        <!-- Shop Page Start -->
        <div class="main-shop-page ptb-90">
            <div class="container">
                <!-- Row End -->
                <div class="row">
                    <!-- Sidebar Shopping Option Start -->
                    <div class="col-lg-3 order-2 order-lg-1 mt-all-40">
                        <div class="sidebar shop-sidebar">
                            <!-- Price Filter Options Start -->
                            <!-- <div class="search-filter mb-30">
                                <h3 class="sidebar-title">filter by price</h3>
                                <form action="#" class="slider-sidebar">
                                    <div id="slider-range"></div>
                                    <input type="text" id="amount" class="amount-range" readonly="">
                                </form>
                            </div> -->
                            <!-- Price Filter Options End -->
                            <!-- Sidebar Categorie Start -->
                            <?php $cat_image = App\Category::find($id);?>
                            @if($cat_image->image != null)
                                <div class="sidebar-categorie mb-30 position-relative">
                                    <img src="{{ url('public/images/category/'.$cat_image->image) }}" alt="cat-pro" class="img-fluid">
                                    <div class="category-overlay">
                                        <h5 class="text-white">{{ $cat_image->name }}</h5>
                                    </div>
                                </div>
    
                                <style>
                                .sidebar-categorie {
                                    position: relative;
                                }
                                .category-overlay {
                                    position: absolute;
                                    bottom: 0;
                                    left: 0;
                                    right: 0;
                                    background: rgba(0,0,0,0.5);
                                    overflow: hidden;
                                    width: 100%;
                                    height: 50px;
                                    transition: .5s ease;
                                    display: flex;
                                    align-items: center;
                                    justify-content: center;
                                }
                                </style>
                            @endif
                            <div class="sidebar-categorie mb-30">
                                <h3 class="sidebar-title">categories</h3>
                                <ul class="sidbar-style">
                                    <?php $side_cat = App\Category::where('parent_id',$id)->get();?>
                                    @if($side_cat != null)
                                    @foreach($side_cat->take(6) as $category)
                                        <li>
                                            <a href="{{ url('/shop_by_id/' . $category->id) }}"><label>{{ $category->name }}</label></a>
                                        </li>
                                    @endforeach
                                    @else
                                    @foreach($categories->take(6) as $category)
                                        <li>
                                            <a href="{{ url('/shop_by_id/' . $category->id) }}"><label>{{ $category->name }}</label></a>
                                        </li>
                                    @endforeach
                                    @endif
                                </ul>
                            </div>
                        </div>
                        <!-- Single Banner Start -->
                        <div class="sidebar-banner mt-30">
                            <a href="{{url('/shop')}}"><img class="ful" src="{{ url('storage/app/'.$shop->thumb) }}" alt="slider-banner"></a>
                        </div>
                    </div>
                    <!-- Sidebar Shopping Option End -->
                    <!-- Product Categorie List Start -->
                    <div class="col-lg-9 order-1 order-lg-2">
                        <!-- Grid & List View Start -->
                        <div class="grid-list-top border-default universal-padding d-md-flex justify-content-md-between align-items-center mb-30">
                            <div class="grid-list-view d-flex align-items-center  mb-sm-15">
                                <ul class="nav tabs-area d-flex align-items-center">
                                    <!-- <li><a class="active" data-bs-toggle="tab" href="#grid-view"><i class="fa fa-th"></i></a></li> -->
                                    <!-- <li><a data-bs-toggle="tab" href="#list-view"><i class="fa fa-list-ul"></i></a></li> -->
                                </ul>
                                <!-- <span class="show-items">There are 8 products.</span> -->
                            </div>
                            <!-- Toolbar Short Area Start -->
                            <div class="main-toolbar-sorter clearfix">
                                <div class="toolbar-sorter d-md-flex align-items-center">
                                    <label>Sort By:</label>
                                    <select class="sorter wide" id="sort-by">
                                        <option value="relevance">Relevance</option>
                                        <option value="name_asc">Name, A to Z</option>
                                        <option value="name_desc">Name, Z to A</option>
                                        <option value="price_asc">Price low to high</option>
                                        <option value="price_desc">Price high to low</option>
                                    </select>
                                </div>
                            </div>
                            <!-- Toolbar Short Area End -->
                        </div>
                        <!-- Grid & List View End -->
                        <div class="shop-area mb-all-40">
                            <!-- Grid & List Main Area End -->
                            <div class="tab-content">
                                <div id="grid-view" class="tab-pane fade show active">
                                    <div class="row border-hover-effect ">
                                        @foreach($products as $product)
                                            <div class="col-lg-4 col-md-4 col-sm-6 col-6">
                                                <!-- Single Product Start Here -->
                                                <div class="single-makal-product">
                                                    <div class="pro-img">
                                                        <a href="{{url('/single-product')}}/{{$product->id}}">
                                                        <?php $images = explode(",", $product->image);
                                                            $primaryImage = isset($images[0]) ? $images[0] : '';?>
                                                            <img src="{{ url('public/images/product', $primaryImage) }}" alt="product-img" style="width: 270px; height: 327px;">
                                                        </a>
                                                        
                                                        @if($product->promotion_price != null)
                                                            <?php $reduced = $product->price - $product->promotion_price;
                                                            $percentage = ($reduced/$product->price)*100;
                                                            $roundoff = number_format((float)$percentage, 2, '.', ''); ?>
                                                            <span class="sticker-sale">-{{$roundoff}}%</span>
                                                        @endif
                                                        <!-- <div class="quick-view-pro">
                                                            <a data-bs-toggle="modal" data-bs-target="#product-window" class="quick-view" href="#"></a>
                                                        </div> -->
                                                    </div>
                                                    <div class="pro-content">
                                                        <h4 class="pro-title">
                                                            <a href="{{url('/single-product')}}/{{$product->id}}">{{$product->name}}</a>
                                                        </h4>
                                                        <p>
                                                            @if($product->promotion_price != null)
                                                                <span class="price">BDT {{$product->promotion_price}}</span>
                                                            @else
                                                                <span class="price">BDT {{$product->price}}</span>
                                                            @endif
                                                        </p>
                                                        <div class="pro-actions">
                                                            <div class="actions-primary">
                                                                @if($product->is_variant == null)
                                                                    @if($product->qty > 0)
                                                                        <form id="addItem{{$product->id}}" action="{{url('cart/addItem')}}" method="POST" class="variants add">
                                                                        @csrf
                                                                            <input type="hidden" name="quantity" value="1">
                                                                            <input type="hidden" name="product_id" value="{{$product->id}}">
                                                                            <input type="hidden" name="name" value="{{$product->name}}">
                                                                        @if($product->promotion_price != null)
                                                                            <input type="hidden" name="price" value="{{$product->promotion_price}}">
                                                                        @else
                                                                            <input type="hidden" name="price" value="{{$product->price}}">
                                                                    @endif
                                                                            <button class="btn btn-addto-cart" type="button" onclick="document.getElementById('addItem{{$product->id}}').submit();" tabindex="0">Add To Cart</button>
                                                                        </form>
                                                                    @else
                                                                        <form class="variants add" action="#" onclick="window.location.href='{{url('/single-product')}}/{{$product->id}}'"method="post">
                                                                        <button class="btn btn-addto-cart" type="button" tabindex="0">Out Of Stock</button>
                                                                        </form>
                                                                        @endif
                                                                    @else
                                                                    <form class="variants add" action="#" onclick="window.location.href='{{url('/single-product')}}/{{$product->id}}'"method="post">
                                                                    <button class="btn btn-addto-cart" type="button" tabindex="0">Add To Cart</button>
                                                                    </form>
                                                                    </form>
                                                                @endif
                                                            </div>
                                                            
                                                            <div class="actions-secondary">
                                                                <?php 
                                                                    $reviews = App\Review::where('product_id', $product->id)->get();
                                                                    if ($reviews) {
                                                                        $number = $reviews->count();
                                                                        $totalStars = $reviews->sum('stars');
                                                                        $averageRating = $number > 0 ? $totalStars / $number : 0;
                                                                    } else {
                                                                        // Handle the case where the product is not found
                                                                        $reviews = collect();
                                                                        $number = 0;
                                                                        $totalStars = 0;
                                                                        $averageRating = 0;
                                                                    }?>
                                                                <div class="rating">
                                                                    @for ($i = 1; $i <= 5; $i++)
                                                                        <i class="font-13 fa fa-{{ $i <= round($averageRating) ? 'star' : 'star-o' }}"></i>
                                                                    @endfor
                                                                    
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <!-- Single Product End Here -->
                                            </div>
                                        @endforeach
                                    </div>
                                    <!-- Row End -->
                                </div>
                                <!-- #grid view End -->
                              
                                <!-- #list view End -->
                            </div>
                            <!-- Grid & List Main Area End -->
                        </div>
                        <!-- Shop Breadcrumb Area Start -->
                      
                            {{ $products->links('front.content.pagination') }}
                    
                        <!-- Shop Breadcrumb Area End -->
                    </div>
                    <!-- product Categorie List End -->
                </div>
                <!-- Row End -->
            </div>
            <!-- Container End -->
        </div>
        <!-- Shop Page End -->
        <!-- Footer Area Start Here -->
        @include('front.layout.footer')
        <!-- Footer Area End Here -->
        <!-- Quick View Content Start -->
<script>
    var baseUrl = "{{ url('') }}";

    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });

    // Trigger the sorting when the dropdown changes
    $('.sorter').on('change', function(e) {
        e.preventDefault();
        var sortBy = $(this).val(); // Get the selected sorting option

        $.ajax({
            type: 'POST',
            url: '{{ url('sortproducts') }}', // The route for sorting products
            data: {
                _token: $('meta[name="csrf-token"]').attr('content'),
                sortBy: sortBy
            },
            success: function(data) {
                // Update the product list dynamically
                updateProductList(data.products);

                // Update pagination if you have pagination controls
                updatePagination(data.products);
            },
            error: function() {
                alert('Failed to sort products. Please try again.');
            }
        });
    });

    function updateProductList(products) {
        const productContainer = document.querySelector('.row.border-hover-effect');
        productContainer.innerHTML = ''; // Clear existing products

        products.data.forEach(product => {
            const images = product.image ? product.image.split(",") : [];
            const primaryImage = images.length > 0 ? images[0] : '';

            const reducedPrice = product.promotion_price ? (product.price - product.promotion_price) : 0;
            const percentage = reducedPrice > 0 ? ((reducedPrice / product.price) * 100).toFixed(2) : null;
            
            let productHtml = `
                <div class="col-lg-4 col-md-4 col-sm-6 col-6">
                    <div class="single-makal-product">
                        <div class="pro-img">
                            <a href="${baseUrl}/single-product/${product.id}">
                                <img src="${baseUrl}/public/images/product/${primaryImage}" alt="product-img" style="width: 270px; height: 327px;">
                            </a>
                           
                            ${product.promotion_price ? `<span class="sticker-sale">-${percentage}%</span>` : ''}
                        </div>
                        <div class="pro-content">
                            <h4 class="pro-title">
                                <a href="/single-product/${product.id}">${product.name}</a>
                            </h4>
                            <p>
                                <span class="price">BDT ${product.promotion_price || product.price}</span>
                            </p>
                            <div class="pro-actions">
                                <div class="actions-primary">
                                    ${getAddToCartButton(product)}
                                </div>
                                <div class="actions-secondary">
                                    ${getProductRating(product.reviews)}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            `;

            productContainer.insertAdjacentHTML('beforeend', productHtml);
        });
    }

    function getAddToCartButton(product) {
        if (product.is_variant == null) {
            if (product.qty > 0) {
                return `
                    <form id="addItem${product.id}" action="/cart/addItem" method="POST" class="variants add">
                        <input type="hidden" name="_token" value="${document.querySelector('meta[name="csrf-token"]').getAttribute('content')}">
                        <input type="hidden" name="quantity" value="1">
                        <input type="hidden" name="product_id" value="${product.id}">
                        <input type="hidden" name="name" value="${product.name}">
                        <input type="hidden" name="price" value="${product.promotion_price || product.price}">
                        <button class="btn btn-addto-cart" type="button" onclick="document.getElementById('addItem${product.id}').submit();" tabindex="0">Add To Cart</button>
                    </form>
                `;
            } else {
                return `
                    <form class="variants add" action="#" onclick="window.location.href='/single-product/${product.id}'" method="post">
                        <button class="btn btn-addto-cart" type="button" tabindex="0">Out Of Stock</button>
                    </form>
                `;
            }
        } else {
            return `
                <form class="variants add" action="#" onclick="window.location.href='/single-product/${product.id}'" method="post">
                    <button class="btn btn-addto-cart" type="button" tabindex="0">Add To Cart</button>
                </form>
            `;
        }
    }

    function getProductRating(reviews) {
        let totalStars = 0;
        let number = 0;

        if (reviews && reviews.length > 0) {
            number = reviews.length;
            totalStars = reviews.reduce((sum, review) => sum + review.stars, 0);
        }

        const averageRating = number > 0 ? totalStars / number : 0;

        let ratingHtml = '<div class="rating">';
        for (let i = 1; i <= 5; i++) {
            ratingHtml += `<i class="font-13 fa fa-${i <= Math.round(averageRating) ? 'star' : 'star-o'}"></i>`;
        }
        ratingHtml += '</div>';

        return ratingHtml;
    }

    function updatePagination(products) {
        const paginationContainer = document.querySelector('.pagination'); // Ensure this is the correct selector
        paginationContainer.innerHTML = products.links; // Update pagination links
    }
</script>

        