@extends('layout.main')

@section('content')
<section>
    <div class="container-fluid">
        <a href="{{ route('faqs.create') }}" class="btn btn-info"><i class="dripicons-plus"></i> Add Q&A</a>
    </div>
    <div class="table-responsive">
        <table id="faq-table" class="table" style="width: 100%">
            <thead>
                <tr>
                    <th class="not-exported"></th>
                    <th>Question</th>
                    <th>Answer</th>
                    <th>{{ trans('file.action') }}</th>
                </tr>
            </thead>
            <tbody>
                @php $serialNumber = 1; @endphp <!-- Initialize serial number -->
                @foreach($lims_pages_all ?? [] as $faqs)
                <tr data-id="{{ $faqs->id }}">
                    <td>{{ $serialNumber++ }}</td> <!-- Increment serial number -->
                    <td>{{ $faqs->ques }}</td>
                    <td>{{ $faqs->ans }}</td>
                    <td>
                        <div class="btn-group">
                            <button type="button" class="btn btn-default btn-sm dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                {{ trans('file.action') }}
                                <span class="caret"></span>
                                <span class="sr-only">Toggle Dropdown</span>
                            </button>
                            <ul class="dropdown-menu edit-options dropdown-menu-right dropdown-default" user="menu">
                                <li>
                                    <a href="{{ route('faqs.edit', $faqs->id) }}" class="btn btn-link"><i class="dripicons-document-edit"></i> {{ trans('file.edit') }}</a>
                                </li>
                                <li class="divider"></li>
                                {{ Form::open(['route' => ['faqs.destroy', $faqs->id], 'method' => 'DELETE']) }}
                                <li>
                                    <button type="submit" class="btn btn-link" onclick="return confirmDelete()"><i class="dripicons-trash"></i> {{ trans('file.delete') }}</button>
                                </li>
                                {{ Form::close() }}
                            </ul>
                        </div>
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</section>

<script type="text/javascript">
    $(document).ready(function() {
        $("ul#cms").siblings('a').attr('aria-expanded', 'true');
        $("ul#cms").addClass("show");
        $("ul#cms #faq-menu").addClass("active");

        $('#faq-table').DataTable({
            responsive: true,
            fixedHeader: {
                header: true,
                footer: true
            },
            "order": [], // No initial sorting
            'language': {
                'lengthMenu': '_MENU_ {{ trans("file.records per page") }}',
                "info":      '<small>{{ trans("file.Showing") }} _START_ - _END_ (_TOTAL_)</small>',
                "search":  '{{ trans("file.Search") }}',
                'paginate': {
                    'previous': '<i class="dripicons-chevron-left"></i>',
                    'next': '<i class="dripicons-chevron-right"></i>'
                }
            },
            'columnDefs': [
                {
                    "orderable": false, // Disable ordering on specific columns
                    'targets': [0, 3] // Prevent ordering on serial number and actions
                },
            ],
            'select': { style: 'multi',  selector: 'td:first-child' },
            'lengthMenu': [[10, 25, 50, -1], [10, 25, 50, "All"]],
            dom: '<"row"lfB>rtip',
            buttons: [
                {
                    extend: 'pdf',
                    text: '{{ trans("file.PDF") }}',
                    exportOptions: {
                        columns: ':visible:not(.not-exported)',
                        rows: ':visible'
                    },
                },
                {
                    extend: 'csv',
                    text: '{{ trans("file.CSV") }}',
                    exportOptions: {
                        columns: ':visible:not(.not-exported)',
                        rows: ':visible'
                    },
                },
                {
                    extend: 'print',
                    text: '{{ trans("file.Print") }}',
                    exportOptions: {
                        columns: ':visible:not(.not-exported)',
                        rows: ':visible'
                    },
                },
                {
                    extend: 'colvis',
                    text: '{{ trans("file.Column visibility") }}',
                    columns: ':gt(0)' // Show column visibility button
                },
            ],
        });
    });

    function confirmDelete() {
        return confirm("Are you sure you want to delete this Q&A?");
    }
</script>

@endsection
