@extends('layout.main')
@section('content')

<section>
    <div class="container-fluid">
        <a href="{{route('choose.create')}}" class="btn btn-info"><i class="dripicons-plus"></i> Add Profile Segement</a>
    </div>
    <div class="table-responsive">
        <table id="choose-table" class="table" style="width: 100%">
            <thead>
                <tr>
                    <th>Title</th>
                    <th>Details</th>
                    <th>Image</th>
                    <th>{{trans('file.action')}}</th>
                </tr>
            </thead>
            <tbody>
                @foreach($lims_choose_all ?? [] as $key=>$slider)
                <tr data-id="{{ $slider->id }}">
                    <td>{{ $slider->title }}</td>
                    <td>{{ substr($slider->details, 0, 30) }}</td>
                    <td>
                        <div class="d-flex align-items-center">
                            <div class="recent-product-img">
                                <img src="{{ url('storage/app/'.$slider->image) }}" alt="" style="width: 90px; height: 90px;">
                            </div>
                        </div>
                    </td>
                    <td>
                        <div class="btn-group">
                            <button type="button" class="btn btn-default btn-sm dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">{{trans('file.action')}}
                                <span class="caret"></span>
                                <span class="sr-only">Toggle Dropdown</span>
                            </button>
                            <ul class="dropdown-menu edit-options dropdown-menu-right dropdown-default" user="menu">
                                <li>
                                    <a href="{{ route('choose.edit', $slider->id) }}" class="btn btn-link"><i class="dripicons-document-edit"></i> {{trans('file.edit')}}</a>
                                </li>
                                <li class="divider"></li>
                                {{ Form::open(['route' => ['choose.destroy', $slider->id], 'method' => 'DELETE'] ) }}
                                <li>
                                    <button type="submit" class="btn btn-link" onclick="return confirmDelete()"><i class="dripicons-trash"></i> {{trans('file.delete')}}</button>
                                </li>
                                {{ Form::close() }}
                            </ul>
                        </div>
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</section>

<script type="text/javascript">
    $(document).ready(function() {
        $("ul#cms").siblings('a').attr('aria-expanded','true');
        $("ul#cms").addClass("show");
        $("ul#cms #slider-menu").addClass("active");

        $('#choose-table').DataTable({
            responsive: true,
            fixedHeader: {
                header: true,
                footer: true
            },
            "order": [],
            'language': {
                'lengthMenu': '_MENU_ {{trans("file.records per page")}}',
                "info":      '<small>{{trans("file.Showing")}} _START_ - _END_ (_TOTAL_)</small>',
                "search":  '{{trans("file.Search")}}',
                'paginate': {
                    'previous': '<i class="dripicons-chevron-left"></i>',
                    'next': '<i class="dripicons-chevron-right"></i>'
                }
            },
            dom: '<"row"lfB>rtip',
            buttons: [
                {
                    extend: 'pdf',
                    text: '{{trans("file.PDF")}}',
                    exportOptions: {
                        columns: ':visible:Not(.not-exported)',
                        rows: ':visible'
                    },
                },
                {
                    extend: 'csv',
                    text: '{{trans("file.CSV")}}',
                    exportOptions: {
                        columns: ':visible:Not(.not-exported)',
                        rows: ':visible'
                    },
                },
                {
                    extend: 'print',
                    text: '{{trans("file.Print")}}',
                    exportOptions: {
                        columns: ':visible:Not(.not-exported)',
                        rows: ':visible'
                    },
                },
                {
                    extend: 'colvis',
                    text: '{{trans("file.Column visibility")}}',
                    columns: ':gt(0)'
                },
            ],
        });
    });

    function confirmDelete() {
        if (confirm("Are you sure you want to delete this item?")) {
            return true;
        }
        return false;
    }
</script>

@endsection