@include('front.layout.header')

<!-- Hero Section -->
<div class="hero-section hero-background">
    <h1 class="page-title">{{$general_setting->site_title}}</h1>
</div>

<!-- Navigation Section -->
<div class="container">
    <nav class="biolife-nav">
        <ul>
            <li class="nav-item"><a href="{{url('/')}}" class="permal-link">Home</a></li>
            <li class="nav-item"><span class="current-page">ShoppingCart</span></li>
        </ul>
    </nav>
</div>

<div class="page-contain checkout">
    <!-- Main Content -->
    <div id="main-content" class="main-content">
        <div class="container sm-margin-top-37px">
            <div class="row">
                <!-- Checkout Progress Box -->
                <div class="col-lg-7 col-md-7 col-sm-6 col-xs-12">
                    <div class="checkout-progress-wrap">
                        <ul class="steps">
                            <li class="step 1st">
                                <div class="checkout-act active">
                                    <h3 class="title-box"><span class="number">1</span> Billing Details</h3>
                                    <div class="box-content">
                                        <form action="{{route('place_order')}}" method="POST">
                                            @csrf
                                            <div class="row">
                                                <div class="col-md-12">
                                                    <div class="country-select clearfix">
                                                        <label for="district">District <span class="required">*</span></label>
                                                        <div class="dropdown">
                                                            <button class="btn btn-secondary dropdown-toggle form-control" type="button" id="districtDropdown" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                                {{ old('district', $customer_detail->district) ?: 'Select District' }}
                                                            </button>
                                                            <div class="dropdown-menu" aria-labelledby="districtDropdown">
                                                                <a class="dropdown-item" href="#" onclick="selectDistrict('Dhaka')">Dhaka</a>
                                                                <a class="dropdown-item" href="#" onclick="selectDistrict('Chittagong')">Chittagong</a>
                                                                <a class="dropdown-item" href="#" onclick="selectDistrict('Rajshahi')">Rajshahi</a>
                                                                <a class="dropdown-item" href="#" onclick="selectDistrict('Sylhet')">Sylhet</a>
                                                                <a class="dropdown-item" href="#" onclick="selectDistrict('Khulna')">Khulna</a>
                                                            </div>
                                                        </div>
                                                        <input type="hidden" name="district" id="selectedDistrict" value="{{ old('district', $customer_detail->district) }}">
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="checkout-form-list">
                                                        <label for="name">Name <span class="required">*</span></label>
                                                        <input name="name" id="name" placeholder="" type="text" value="{{ old('name', $customer_detail->name) }}" class="form-control">
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="checkout-form-list">
                                                        <label for="company_name">Company Name</label>
                                                        <input name="company_name" id="company_name" placeholder="" type="text" value="{{ old('company_name', $customer_detail->company_name) }}" class="form-control">
                                                    </div>
                                                </div>
                                                <div class="col-md-12">
                                                    <div class="checkout-form-list">
                                                        <label for="address">Address <span class="required">*</span></label>
                                                        <input name="address" id="address" placeholder="Street address" type="text" value="{{ old('address', $customer_detail->address) }}" class="form-control">
                                                    </div>
                                                </div>
                                                <div class="col-md-12">
                                                    <div class="checkout-form-list">
                                                        <input name="apartment" id="apartment" placeholder="Apartment, suite, unit etc. (optional)" type="text" class="form-control">
                                                    </div>
                                                </div>
                                                <div class="col-md-12">
                                                    <div class="checkout-form-list">
                                                        <label for="city">Town / City <span class="required">*</span></label>
                                                        <input name="city" id="city" type="text" value="{{ old('city', $customer_detail->city) }}" class="form-control">
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="checkout-form-list">
                                                        <label for="state">State <span class="required">*</span></label>
                                                        <input name="state" id="state" placeholder="" type="text" value="{{ old('state', $customer_detail->state) }}" class="form-control">
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="checkout-form-list">
                                                        <label for="postcode">Postcode / Zip <span class="required">*</span></label>
                                                        <input name="postcode" id="postcode" placeholder="" type="text" value="{{ old('postcode', $customer_detail->postal_code) }}" class="form-control">
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="checkout-form-list">
                                                        <label for="email">Email Address <span class="required">*</span></label>
                                                        <input name="email" id="email" placeholder="" type="email" value="{{ old('email', $customer_detail->email) }}" class="form-control">
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="checkout-form-list">
                                                        <label for="phone">Phone <span class="required">*</span></label>
                                                        <input name="phone" id="phone" type="text" value="{{ old('phone', $customer_detail->phone_number) }}" class="form-control">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="order-notes">
                                                <div class="checkout-form-list">
                                                    <label for="note">Order Notes</label>
                                                    <textarea name="note" id="checkout-mess" cols="30" rows="10" placeholder="Notes about your order, e.g. special notes for delivery." class="form-control">{{ old('note') }}</textarea>
                                                </div>
                                            </div>
                                            <div class="order-button-payment">
                                                @if(Cart::count() != 0)
                                                    <input value="Place order" type="submit" class="btn btn-primary">
                                                @endif
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </li>
                        </ul>
                    </div>
                </div>

                <!-- Order Summary -->
                <div class="col-lg-5 col-md-5 col-sm-6 col-xs-12">
                    <div class="your-order">
                        <h3>Your order</h3>
                        <div class="your-order-table table-responsive">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th class="cart-product-name">Product</th>
                                        <th class="cart-product-total">Total</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($cart_items as $item)
                                        <tr class="cart_item">
                                            <td class="cart-product-name">{{ $item->name }}<strong class="product-quantity"> × {{ $item->qty }}</strong></td>
                                            <?php $subtotal = $item->qty * $item->price; ?>
                                            <td class="cart-product-total"><span class="amount">BDT {{ $subtotal }}</span></td>
                                        </tr>
                                    @endforeach
                                </tbody>
                                <tfoot>
                                    <tr class="cart-subtotal">
                                        <th>Cart Subtotal</th>
                                        <td><span class="amount">BDT {{ Cart::subtotal() }}</span></td>
                                    </tr>
                                    <tr class="order-total">
                                        <th>Order Total</th>
                                        <td><strong><span class="amount">BDT {{ Cart::subtotal() }}</span></strong></td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                        <div class="payment-method">
                            <div class="payment-accordion">
                                <div id="accordion">
                                    <div class="card">
                                        <div class="card-header" id="#payment-1">
                                            <h5 class="panel-title">
                                                <a class="" data-toggle="collapse" data-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                                                    Cash On Delivery
                                                </a>
                                            </h5>
                                        </div>
                                        <div id="collapseOne" class="collapse show" data-parent="#accordion">
                                            <div class="card-body">
                                                <p>Make your payment directly into our bank account. Please use your Order ID as the payment reference. Your order won’t be shipped until the funds have cleared in our account.</p>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Uncomment and add more payment methods as needed -->
                                    <!-- <div class="card">
                                        <div class="card-header" id="#payment-2">
                                            <h5 class="panel-title">
                                                <a class="collapsed" data-toggle="collapse" data-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                                                    Direct Bank Transfer
                                                </a>
                                            </h5>
                                        </div>
                                        <div id="collapseTwo" class="collapse" data-parent="#accordion">
                                            <div class="card-body">
                                                <p>Make your payment directly into our bank account. Please use your Order ID as the payment reference. Your order won’t be shipped until the funds have cleared in our account.</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card">
                                        <div class="card-header" id="#payment-3">
                                            <h5 class="panel-title">
                                                <a class="collapsed" data-toggle="collapse" data-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                                                    PayPal
                                                </a>
                                            </h5>
                                        </div>
                                        <div id="collapseThree" class="collapse" data-parent="#accordion">
                                            <div class="card-body">
                                                <p>Make your payment directly into our bank account. Please use your Order ID as the payment reference. Your order won’t be shipped until the funds have cleared in our account.</p>
                                            </div>
                                        </div>
                                    </div> -->
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

@include('front.layout.footer')

<style>
    .checkout-form-list {
        margin-bottom: 15px;
    }
    .country-select select {
        width: 100%;
        padding: 10px;
    }
    .checkout-form-list input,
    .checkout-form-list textarea {
        width: 100%;
        padding: 10px;
        border: 1px solid #ccc;
        border-radius: 4px;
    }
    .order-button-payment {
        margin-top: 20px;
    }
    .order-button-payment input {
        width: 100%;
        padding: 15px;
        background-color: #5cb85c;
        border: none;
        color: white;
        border-radius: 4px;
        cursor: pointer;
    }
</style>

<script>
    function selectDistrict(district) {
        document.getElementById('districtDropdown').textContent = district;
        document.getElementById('selectedDistrict').value = district;
    }
</script>
