@extends('layout.main') @section('content')

<section class="forms">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header d-flex align-items-center">
                        <h4>Add Bank Deposit</h4>
                    </div>
                    <div class="card-body">
                        <p class="italic"><small>{{trans('file.The field labels marked with * are required input fields')}}.</small></p>
                        {!! Form::open(['route' => 'bankdeposit.store', 'method' => 'post', 'files' => true]) !!}
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Check No *</strong> </label>
                                    <input type="text" name="check_no" required class="form-control">
                                </div>
                            </div>
                           
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Amount *</label>
                                    <input type="text" name="amount" required class="form-control">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Date *</label>
                                    <input type="date" name="date" required class="form-control">
                                </div>
                            </div>

                           
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Account ID *</label>
                                    <div class="input-group">
                                          <select name="account_id" class="selectpicker form-control" data-live-search="true" data-live-search-style="begins" title="Select Account...">
                                            @foreach($account as $acc)
                                                <option value="{{$acc->id}}">{{$acc->name}} ({{ $acc->account_no}})</option>
                                            @endforeach    
                                          </select>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Option *</label>
                                        <div class="input-group">
                                          <select name="option" class="selectpicker form-control" data-live-search="true" data-live-search-style="begins" title="Select Option...">
                                                <option value="Withdraw">Withdraw</option>
                                                <option value="Deposit">Deposit</option>
                                          </select>
                                      </div>  
                                </div>
                            </div>
                            
                            <div class="col-md-12">
                                <div class="form-group mt-4">
                                    <input type="submit" value="{{trans('file.submit')}}" class="btn btn-primary">
                                </div>
                            </div>
                        </div>
                        {!! Form::close() !!}
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<script type="text/javascript">
    $("ul#account").siblings('a').attr('aria-expanded','true');
    $("ul#account").addClass("show");
    $("ul#account #bankdeposit-list-menu").addClass("active");
</script>
@endsection