@extends('layout.main')
@section('content')
<section>
    <div class="container-fluid">
        <!-- <a href="{{ route('adds.create') }}" class="btn btn-info"><i class="dripicons-plus"></i> Add New</a> -->
    </div>
    <div class="table-responsive">
        <table id="adds-table" class="table" style="width: 100%">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Title</th>
                    <th>Image</th>
                    <th>{{trans('file.action')}}</th>
                </tr>
            </thead>
            <tbody>
                @foreach($adds as $add)
                <tr>
                     <td>
                        @if($loop->iteration == 1)
                            Pop Up Add
                        @elseif($loop->iteration == 2)
                            Featured Category 1
                        @elseif($loop->iteration == 3)
                            Featured Category 2
                        @elseif($loop->iteration == 4)
                            Featured Category 3
                        @elseif($loop->iteration == 5)
                            Trending Category 1
                        @else
                            Trending Category 2
                        @endif
                    </td>
                    <td>{{ substr($add->title, 0, 30) }}</td>
                    <td><img src="{{ url('storage/app/'.$add->image) }}" alt="{{ $add->title }}" style="width: 100px;"></td>
                    <td>
                        <div class="btn-group">
                            <button type="button" class="btn btn-default btn-sm dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">{{trans('file.action')}}
                                <span class="caret"></span>
                                <span class="sr-only">Toggle Dropdown</span>
                            </button>
                            <ul class="dropdown-menu edit-options dropdown-menu-right dropdown-default" user="menu">
                                <li>
                                    <a href="{{ route('adds.edit', $add->id) }}" class="btn btn-link"><i class="dripicons-document-edit"></i> {{trans('file.edit')}}</a>
                                </li>
                                <li class="divider"></li>
                                <!-- <li>
                                    <form action="{{ route('adds.destroy', $add->id) }}" method="POST">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-link" onclick="return confirmDelete()"><i class="dripicons-trash"></i> {{trans('file.delete')}}</button>
                                    </form>
                                </li> -->
                            </ul>
                        </div>
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</section>
<script type="text/javascript">
    function confirmDelete() {
        return confirm("Are you sure you want to delete this item?");
    }
</script>
@endsection
