

CREATE TABLE `accounts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `account_no` varchar(191) NOT NULL,
  `name` varchar(191) NOT NULL,
  `initial_balance` double DEFAULT NULL,
  `total_balance` double NOT NULL,
  `note` text DEFAULT NULL,
  `is_default` tinyint(1) DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO accounts VALUES("1","11111","Sales Account","5000000","5000000","this is first account","1","1","2018-12-17 21:58:02","2023-12-03 16:17:09");
INSERT INTO accounts VALUES("3","21211","Sa","","0","","0","0","2018-12-17 21:58:56","2023-09-20 13:35:26");
INSERT INTO accounts VALUES("4","1234567890","Sale Account","100000","100000","Test","0","1","2023-09-20 12:36:53","2023-10-29 15:58:37");
INSERT INTO accounts VALUES("5","100.101.110.111","Medicine","100000","100000","Medicine A/C","0","1","2023-10-29 15:58:17","2023-10-29 15:58:47");



CREATE TABLE `adjustments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(191) NOT NULL,
  `warehouse_id` int(11) NOT NULL,
  `document` varchar(191) DEFAULT NULL,
  `total_qty` double NOT NULL,
  `item` int(11) NOT NULL,
  `note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `attendances` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `employee_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `checkin` varchar(191) NOT NULL,
  `checkout` varchar(191) NOT NULL,
  `status` int(11) NOT NULL,
  `note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO attendances VALUES("1","2019-01-02","1","1","10:00am","6:30pm","1","","2019-01-01 22:30:50","2019-01-01 22:30:50");
INSERT INTO attendances VALUES("3","2019-01-02","3","1","10:15am","6:30pm","0","","2019-01-01 22:57:12","2019-01-01 22:57:12");
INSERT INTO attendances VALUES("6","2020-02-03","1","1","11:30am","6:00pm","0","","2020-02-03 04:57:30","2020-02-03 04:57:30");



CREATE TABLE `billers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `image` varchar(191) DEFAULT NULL,
  `company_name` varchar(191) NOT NULL,
  `vat_number` varchar(191) DEFAULT NULL,
  `email` varchar(191) NOT NULL,
  `phone_number` varchar(191) NOT NULL,
  `address` varchar(191) NOT NULL,
  `city` varchar(191) NOT NULL,
  `state` varchar(191) DEFAULT NULL,
  `postal_code` varchar(191) DEFAULT NULL,
  `country` varchar(191) DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO billers VALUES("1","yousuf","aks.jpg","aks","31123","yousuf@kds.com","442343324","halishahar","chittagong","","","sdgs","1","2018-05-12 17:49:30","2019-03-02 00:20:38");
INSERT INTO billers VALUES("2","tariq","","big tree","","tariq@bigtree.com","321312","khulshi","chittagong","","","","1","2018-05-12 17:57:54","2018-06-14 20:07:11");
INSERT INTO billers VALUES("3","test","","test","","test@test.com","3211","erewrwqre","afsf","","","","0","2018-05-29 22:38:58","2018-05-29 22:39:57");
INSERT INTO billers VALUES("5","modon","mogaTel.jpg","mogaTel","","modon@gmail.com","32321","nasirabad","chittagong","","","bd","0","2018-08-31 23:59:54","2023-09-20 13:22:14");
INSERT INTO billers VALUES("6","a","","a","","a@a.com","q","q","q","","","","0","2018-10-06 22:33:39","2018-10-06 22:34:18");
INSERT INTO billers VALUES("7","a","","a","","a@a.com","a","a","a","","","","0","2018-10-06 22:34:36","2018-10-06 22:36:07");
INSERT INTO billers VALUES("8","x","x.png","x","","x@x.com","x","x","x","","","","0","2019-03-18 07:02:42","2023-09-20 13:22:14");
INSERT INTO billers VALUES("9","wahid","","CASH & CARRY","","walkie.bd@gmail.com","01879450074","HAMJARBAG","chittagong","chittagong","","banglafesh","1","2022-03-07 09:55:32","2022-03-07 09:55:32");
INSERT INTO billers VALUES("10","Nazmul","","Ebexsoft","","nazmul.ebexsoft@gmail.com","8801820579833","239, 10/A Dhanmondi, Dhaka-1209","Dhaka","Dhaka","1209","Bangladesh","1","2023-09-20 12:30:13","2023-09-20 12:30:13");



CREATE TABLE `brands` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) NOT NULL,
  `image` varchar(191) DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=489 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO brands VALUES("3","HP","HP.jpg","1","2018-05-12 05:06:14","2019-03-02 00:32:21");
INSERT INTO brands VALUES("4","Samsung","samsung.jpg","1","2018-05-12 05:08:41","2023-12-11 15:37:59");
INSERT INTO brands VALUES("5","Apple","Apple.jpg","1","2018-08-31 19:34:49","2018-12-05 22:05:38");
INSERT INTO brands VALUES("6","jjjj","20201019093419.jpg","0","2020-10-19 11:33:52","2020-10-19 11:35:58");
INSERT INTO brands VALUES("7","Lotto","","1","2020-11-15 23:13:41","2020-11-15 23:13:41");
INSERT INTO brands VALUES("8","BBQ","20211219120132.jfif","1","2021-12-19 11:56:42","2021-12-19 12:01:32");
INSERT INTO brands VALUES("9","walkie","","1","2022-03-07 09:53:23","2022-03-07 09:53:23");
INSERT INTO brands VALUES("10","Miyako","","1","2023-09-20 12:10:01","2023-09-20 12:10:01");
INSERT INTO brands VALUES("11","Acer","20231211035756.jpg","1","2023-10-29 13:34:08","2023-12-11 15:57:56");
INSERT INTO brands VALUES("12","Active Fine Chemicals Ltd.","","1","2023-10-29 13:34:08","2023-10-29 13:34:08");
INSERT INTO brands VALUES("13","Ad-din Pharmaceuticals Ltd.","","1","2023-10-29 13:34:08","2023-10-29 13:34:08");
INSERT INTO brands VALUES("14","GREE","","1","2023-12-13 13:18:24","2023-12-13 13:18:24");
INSERT INTO brands VALUES("15","Haier","","1","2023-12-13 13:18:24","2023-12-13 13:18:24");
INSERT INTO brands VALUES("16","JICSON","","1","2023-12-13 13:18:24","2023-12-13 13:18:24");
INSERT INTO brands VALUES("17","Kiam","","1","2023-12-13 13:18:24","2023-12-13 13:18:24");
INSERT INTO brands VALUES("18","LG","","1","2023-12-13 13:18:24","2023-12-13 13:18:24");
INSERT INTO brands VALUES("19","Midea","","1","2023-12-13 13:18:24","2023-12-13 13:18:24");
INSERT INTO brands VALUES("20","Water Bottle","","1","2023-12-13 13:18:25","2023-12-14 18:06:28");
INSERT INTO brands VALUES("21","NOVA","","1","2023-12-13 13:18:25","2023-12-13 13:18:25");
INSERT INTO brands VALUES("22","Osaka","","1","2023-12-13 13:18:25","2023-12-13 13:18:25");
INSERT INTO brands VALUES("23","Panasonic","","1","2023-12-13 13:18:25","2023-12-13 13:18:25");
INSERT INTO brands VALUES("24","Philips","","1","2023-12-13 13:18:25","2023-12-13 13:18:25");
INSERT INTO brands VALUES("25","Unilever","","1","2023-12-13 13:18:25","2023-12-13 13:18:25");
INSERT INTO brands VALUES("26","Super General","","1","2023-12-13 13:18:25","2023-12-13 13:18:25");
INSERT INTO brands VALUES("27","Transtec","","1","2023-12-13 13:18:25","2023-12-13 13:18:25");
INSERT INTO brands VALUES("28","Weidasi","","1","2023-12-13 13:18:25","2023-12-13 13:18:25");
INSERT INTO brands VALUES("29","YAGE","","1","2023-12-13 13:18:25","2023-12-13 13:18:25");
INSERT INTO brands VALUES("30","Floda- JSM","","1","2024-01-10 15:01:00","2024-01-10 15:01:00");
INSERT INTO brands VALUES("31","Guitar","","1","2024-01-10 15:01:00","2024-01-10 15:01:00");
INSERT INTO brands VALUES("32","TGM","","1","2024-01-10 15:01:00","2024-01-10 15:01:00");
INSERT INTO brands VALUES("33","Ukulele","","1","2024-01-10 15:01:00","2024-01-10 15:01:00");
INSERT INTO brands VALUES("34","Altas","","1","2024-01-10 15:01:00","2024-01-10 15:01:00");
INSERT INTO brands VALUES("35","ALTAS- CITY","","1","2024-01-10 15:01:00","2024-01-10 15:01:00");
INSERT INTO brands VALUES("36","Boss","","1","2024-01-10 15:01:00","2024-01-10 15:01:00");
INSERT INTO brands VALUES("37","Casio","","1","2024-01-10 15:01:00","2024-01-10 15:01:00");
INSERT INTO brands VALUES("38","Maraj","","1","2024-01-10 15:01:00","2024-01-10 15:01:00");
INSERT INTO brands VALUES("39","Nonbrand","","1","2024-01-10 15:01:00","2024-01-10 15:01:00");
INSERT INTO brands VALUES("40","Power Adapter-S.T.I","","1","2024-01-10 15:01:00","2024-01-10 15:01:00");
INSERT INTO brands VALUES("41","yamaha","","1","2024-01-10 15:01:00","2024-01-10 15:01:00");
INSERT INTO brands VALUES("42","Zoom","","1","2024-01-10 15:01:00","2024-01-10 15:01:00");
INSERT INTO brands VALUES("43","Labu","","1","2024-01-10 15:01:00","2024-01-10 15:01:00");
INSERT INTO brands VALUES("44","Acoustic ","","1","2024-01-10 15:01:00","2024-01-10 15:01:00");
INSERT INTO brands VALUES("45","Acoustic_Foam_GIGBAG_SBH","","1","2024-01-10 15:01:00","2024-01-10 15:01:00");
INSERT INTO brands VALUES("46","Acoustic_Foam_SBH","","1","2024-01-10 15:01:00","2024-01-10 15:01:00");
INSERT INTO brands VALUES("47","Acoustic_Normal_SBH","","1","2024-01-10 15:01:00","2024-01-10 15:01:00");
INSERT INTO brands VALUES("48","Acoustic_SPECIAL_GIGBAG_SBH","","1","2024-01-10 15:01:00","2024-01-10 15:01:00");
INSERT INTO brands VALUES("49","Converse","","1","2024-01-10 15:01:00","2024-01-10 15:01:00");
INSERT INTO brands VALUES("50","DO ","","1","2024-01-10 15:01:00","2024-01-10 15:01:00");
INSERT INTO brands VALUES("51","Dream Maker","","1","2024-01-10 15:01:00","2024-01-10 15:01:00");
INSERT INTO brands VALUES("52","FINKS","","1","2024-01-10 15:01:00","2024-01-10 15:01:00");
INSERT INTO brands VALUES("53","Lirick Stand","","1","2024-01-10 15:01:00","2024-01-10 15:01:00");
INSERT INTO brands VALUES("54","MDY","","1","2024-01-10 15:01:00","2024-01-10 15:01:00");
INSERT INTO brands VALUES("55","Musicare","","1","2024-01-10 15:01:00","2024-01-10 15:01:00");
INSERT INTO brands VALUES("56","Nihil","","1","2024-01-10 15:01:00","2024-01-10 15:01:00");
INSERT INTO brands VALUES("57","Nike","","1","2024-01-10 15:01:00","2024-01-10 15:01:00");
INSERT INTO brands VALUES("58","Puma","","1","2024-01-10 15:01:01","2024-01-10 15:01:01");
INSERT INTO brands VALUES("59","RNG","","1","2024-01-10 15:01:01","2024-01-10 15:01:01");
INSERT INTO brands VALUES("60","Silvertone","","1","2024-01-10 15:01:01","2024-01-10 15:01:01");
INSERT INTO brands VALUES("61","SQOE-JSM","","1","2024-01-10 15:01:01","2024-01-10 15:01:01");
INSERT INTO brands VALUES("62","SX","","1","2024-01-10 15:01:01","2024-01-10 15:01:01");
INSERT INTO brands VALUES("63","Ukulele_Foam_SBH","","1","2024-01-10 15:01:01","2024-01-10 15:01:01");
INSERT INTO brands VALUES("64","Ukulele_Normal_SBH","","1","2024-01-10 15:01:01","2024-01-10 15:01:01");
INSERT INTO brands VALUES("65","Zealux","","1","2024-01-10 15:01:01","2024-01-10 15:01:01");
INSERT INTO brands VALUES("66","Signature","","1","2024-01-10 15:01:01","2024-01-10 15:01:01");
INSERT INTO brands VALUES("67","Signature-S.T. I","","1","2024-01-10 15:01:01","2024-01-10 15:01:01");
INSERT INTO brands VALUES("68","Bios Battery","","1","2024-01-10 15:01:01","2024-01-10 15:01:01");
INSERT INTO brands VALUES("69","Maxell","","1","2024-01-10 15:01:01","2024-01-10 15:01:01");
INSERT INTO brands VALUES("70","NEW LEADER","","1","2024-01-10 15:01:01","2024-01-10 15:01:01");
INSERT INTO brands VALUES("71","Olympic Gold","","1","2024-01-10 15:01:01","2024-01-10 15:01:01");
INSERT INTO brands VALUES("72","PAKKO","","1","2024-01-10 15:01:01","2024-01-10 15:01:01");
INSERT INTO brands VALUES("73","SEPE","","1","2024-01-10 15:01:01","2024-01-10 15:01:01");
INSERT INTO brands VALUES("74","Sunlite","","1","2024-01-10 15:01:01","2024-01-10 15:01:01");
INSERT INTO brands VALUES("75","XinHuang","","1","2024-01-10 15:01:01","2024-01-10 15:01:01");
INSERT INTO brands VALUES("76","Dance","","1","2024-01-10 15:01:01","2024-01-10 15:01:01");
INSERT INTO brands VALUES("77","Musical   ","","1","2024-01-10 15:01:01","2024-01-10 15:01:01");
INSERT INTO brands VALUES("78","Musical Books","","1","2024-01-10 15:01:01","2024-01-10 15:01:01");
INSERT INTO brands VALUES("79","Robindro Sogit Kolo","","1","2024-01-10 15:01:01","2024-01-10 15:01:01");
INSERT INTO brands VALUES("80","ATV","","1","2024-01-10 15:01:01","2024-01-10 15:01:01");
INSERT INTO brands VALUES("81","Melody","","1","2024-01-10 15:01:01","2024-01-10 15:01:01");
INSERT INTO brands VALUES("82","Anisha ","","1","2024-01-10 15:01:01","2024-01-10 15:01:01");
INSERT INTO brands VALUES("83","Mini Cajon Shaker","","1","2024-01-10 15:01:02","2024-01-10 15:01:02");
INSERT INTO brands VALUES("84","Music World","","1","2024-01-10 15:01:02","2024-01-10 15:01:02");
INSERT INTO brands VALUES("85","Musicon","","1","2024-01-10 15:01:02","2024-01-10 15:01:02");
INSERT INTO brands VALUES("86","Oppa","","1","2024-01-10 15:01:02","2024-01-10 15:01:02");
INSERT INTO brands VALUES("87","Pearl","","1","2024-01-10 15:01:02","2024-01-10 15:01:02");
INSERT INTO brands VALUES("88","R Beats","","1","2024-01-10 15:01:02","2024-01-10 15:01:02");
INSERT INTO brands VALUES("89","Smart","","1","2024-01-10 15:01:02","2024-01-10 15:01:02");
INSERT INTO brands VALUES("90","CC Camera","","1","2024-01-10 15:01:02","2024-01-10 15:01:02");
INSERT INTO brands VALUES("91","Movie","","1","2024-01-10 15:01:02","2024-01-10 15:01:02");
INSERT INTO brands VALUES("92","Movie Collection","","1","2024-01-10 15:01:02","2024-01-10 15:01:02");
INSERT INTO brands VALUES("93","Panda","","1","2024-01-10 15:01:02","2024-01-10 15:01:02");
INSERT INTO brands VALUES("94","valencia ","","1","2024-01-10 15:01:02","2024-01-10 15:01:02");
INSERT INTO brands VALUES("95","Alice","","1","2024-01-10 15:01:02","2024-01-10 15:01:02");
INSERT INTO brands VALUES("96","Alesis","","1","2024-01-10 15:01:02","2024-01-10 15:01:02");
INSERT INTO brands VALUES("97","Paiste","","1","2024-01-10 15:01:02","2024-01-10 15:01:02");
INSERT INTO brands VALUES("98","Tama","","1","2024-01-10 15:01:02","2024-01-10 15:01:02");
INSERT INTO brands VALUES("99","MES","","1","2024-01-10 15:01:02","2024-01-10 15:01:02");
INSERT INTO brands VALUES("100","Peavey","","1","2024-01-10 15:01:02","2024-01-10 15:01:02");
INSERT INTO brands VALUES("101","Zinbao","","1","2024-01-10 15:01:02","2024-01-10 15:01:02");
INSERT INTO brands VALUES("102","Big Beat","","1","2024-01-10 15:01:02","2024-01-10 15:01:02");
INSERT INTO brands VALUES("103","Carlos","","1","2024-01-10 15:01:02","2024-01-10 15:01:02");
INSERT INTO brands VALUES("104","Hund","","1","2024-01-10 15:01:02","2024-01-10 15:01:02");
INSERT INTO brands VALUES("105","Jindao","","1","2024-01-10 15:01:02","2024-01-10 15:01:02");
INSERT INTO brands VALUES("106","Pengyang","","1","2024-01-10 15:01:02","2024-01-10 15:01:02");
INSERT INTO brands VALUES("107","PLAY,BEAT","","1","2024-01-10 15:01:02","2024-01-10 15:01:02");
INSERT INTO brands VALUES("108","PLAY,BEAT- STI","","1","2024-01-10 15:01:02","2024-01-10 15:01:02");
INSERT INTO brands VALUES("109","Premier England-STI","","1","2024-01-10 15:01:02","2024-01-10 15:01:02");
INSERT INTO brands VALUES("110","Promark","","1","2024-01-10 15:01:02","2024-01-10 15:01:02");
INSERT INTO brands VALUES("111","Pulse STI","","1","2024-01-10 15:01:03","2024-01-10 15:01:03");
INSERT INTO brands VALUES("112","RDX","","1","2024-01-10 15:01:03","2024-01-10 15:01:03");
INSERT INTO brands VALUES("113","Rivera","","1","2024-01-10 15:01:03","2024-01-10 15:01:03");
INSERT INTO brands VALUES("114","Rook Band","","1","2024-01-10 15:01:03","2024-01-10 15:01:03");
INSERT INTO brands VALUES("115","S.T.I / MS ALAM","","1","2024-01-10 15:01:03","2024-01-10 15:01:03");
INSERT INTO brands VALUES("116","Vic Firth","","1","2024-01-10 15:01:03","2024-01-10 15:01:03");
INSERT INTO brands VALUES("117","Awei","","1","2024-01-10 15:01:03","2024-01-10 15:01:03");
INSERT INTO brands VALUES("118","Beats","","1","2024-01-10 15:01:03","2024-01-10 15:01:03");
INSERT INTO brands VALUES("119","Doolike","","1","2024-01-10 15:01:03","2024-01-10 15:01:03");
INSERT INTO brands VALUES("120","Genius","","1","2024-01-10 15:01:03","2024-01-10 15:01:03");
INSERT INTO brands VALUES("121","Havit","","1","2024-01-10 15:01:03","2024-01-10 15:01:03");
INSERT INTO brands VALUES("122","MI ","","1","2024-01-10 15:01:03","2024-01-10 15:01:03");
INSERT INTO brands VALUES("123","Remax","","1","2024-01-10 15:01:03","2024-01-10 15:01:03");
INSERT INTO brands VALUES("124","Universal","","1","2024-01-10 15:01:03","2024-01-10 15:01:03");
INSERT INTO brands VALUES("125","FishMan","","1","2024-01-10 15:01:03","2024-01-10 15:01:03");
INSERT INTO brands VALUES("126","City","","1","2024-01-10 15:01:03","2024-01-10 15:01:03");
INSERT INTO brands VALUES("127","Labu Special","","1","2024-01-10 15:01:03","2024-01-10 15:01:03");
INSERT INTO brands VALUES("128","Stranger","","1","2024-01-10 15:01:04","2024-01-10 15:01:04");
INSERT INTO brands VALUES("129","Rockhouse","","1","2024-01-10 15:01:04","2024-01-10 15:01:04");
INSERT INTO brands VALUES("130","interior","","1","2024-01-10 15:01:04","2024-01-10 15:01:04");
INSERT INTO brands VALUES("131","Office","","1","2024-01-10 15:01:04","2024-01-10 15:01:04");
INSERT INTO brands VALUES("132","ABAN-Ukulele Center","","1","2024-01-10 15:01:04","2024-01-10 15:01:04");
INSERT INTO brands VALUES("133","Acoustic Bass Guitar","","1","2024-01-10 15:01:06","2024-01-10 15:01:06");
INSERT INTO brands VALUES("134","AS AXE AG-48T","","1","2024-01-10 15:01:06","2024-01-10 15:01:06");
INSERT INTO brands VALUES("135","Ashton","","1","2024-01-10 15:01:06","2024-01-10 15:01:06");
INSERT INTO brands VALUES("136","AXE","","1","2024-01-10 15:01:06","2024-01-10 15:01:06");
INSERT INTO brands VALUES("137","AXE_SLIM_CITY","","1","2024-01-10 15:01:06","2024-01-10 15:01:06");
INSERT INTO brands VALUES("138","Baby Guitar","","1","2024-01-10 15:01:06","2024-01-10 15:01:06");
INSERT INTO brands VALUES("139","chord","","1","2024-01-10 15:01:06","2024-01-10 15:01:06");
INSERT INTO brands VALUES("140","Classical Guitar","","1","2024-01-10 15:01:06","2024-01-10 15:01:06");
INSERT INTO brands VALUES("141","Custom JSM BLUE","","1","2024-01-10 15:01:06","2024-01-10 15:01:06");
INSERT INTO brands VALUES("142","Deviser","","1","2024-01-10 15:01:06","2024-01-10 15:01:06");
INSERT INTO brands VALUES("143","Deviser -L-770A-City","","1","2024-01-10 15:01:06","2024-01-10 15:01:06");
INSERT INTO brands VALUES("144","Deviser GB","","1","2024-01-10 15:01:06","2024-01-10 15:01:06");
INSERT INTO brands VALUES("145","Deviser-E-G3Semi Floyed City","","1","2024-01-10 15:01:06","2024-01-10 15:01:06");
INSERT INTO brands VALUES("146","Electric Led Guitar","","1","2024-01-10 15:01:06","2024-01-10 15:01:06");
INSERT INTO brands VALUES("147","Electro Acoustic ","","1","2024-01-10 15:01:06","2024-01-10 15:01:06");
INSERT INTO brands VALUES("148","Fender","","1","2024-01-10 15:01:08","2024-01-10 15:01:08");
INSERT INTO brands VALUES("149","FENDER-City-Mat","","1","2024-01-10 15:01:08","2024-01-10 15:01:08");
INSERT INTO brands VALUES("150","Fender_Anisha","","1","2024-01-10 15:01:08","2024-01-10 15:01:08");
INSERT INTO brands VALUES("151","FINKS_FK 423","","1","2024-01-10 15:01:08","2024-01-10 15:01:08");
INSERT INTO brands VALUES("152","Flamango","","1","2024-01-10 15:01:08","2024-01-10 15:01:08");
INSERT INTO brands VALUES("153","Flamenco","","1","2024-01-10 15:01:08","2024-01-10 15:01:08");
INSERT INTO brands VALUES("154","FLODA-BK-JSM","","1","2024-01-10 15:01:08","2024-01-10 15:01:08");
INSERT INTO brands VALUES("155","Givson-City","","1","2024-01-10 15:01:08","2024-01-10 15:01:08");
INSERT INTO brands VALUES("156","Godson-City","","1","2024-01-10 15:01:08","2024-01-10 15:01:08");
INSERT INTO brands VALUES("157","Golden _City","","1","2024-01-10 15:01:08","2024-01-10 15:01:08");
INSERT INTO brands VALUES("158","Hawain Guitar","","1","2024-01-10 15:01:08","2024-01-10 15:01:08");
INSERT INTO brands VALUES("159","Ibanez","","1","2024-01-10 15:01:08","2024-01-10 15:01:08");
INSERT INTO brands VALUES("160","IBANEZ-city-Mat","","1","2024-01-10 15:01:08","2024-01-10 15:01:08");
INSERT INTO brands VALUES("161","Kaysen","","1","2024-01-10 15:01:08","2024-01-10 15:01:08");
INSERT INTO brands VALUES("162","Listen","","1","2024-01-10 15:01:08","2024-01-10 15:01:08");
INSERT INTO brands VALUES("163","New TGM","","1","2024-01-10 15:01:08","2024-01-10 15:01:08");
INSERT INTO brands VALUES("164","New TGM-EQ","","1","2024-01-10 15:01:08","2024-01-10 15:01:08");
INSERT INTO brands VALUES("165","Orange","","1","2024-01-10 15:01:08","2024-01-10 15:01:08");
INSERT INTO brands VALUES("166","seizer_Lefty","","1","2024-01-10 15:01:09","2024-01-10 15:01:09");
INSERT INTO brands VALUES("167","Signature_RNG","","1","2024-01-10 15:01:09","2024-01-10 15:01:09");
INSERT INTO brands VALUES("168","Tayste","","1","2024-01-10 15:01:09","2024-01-10 15:01:09");
INSERT INTO brands VALUES("169","TGM GB","","1","2024-01-10 15:01:09","2024-01-10 15:01:09");
INSERT INTO brands VALUES("170","TGM JSM Black","","1","2024-01-10 15:01:09","2024-01-10 15:01:09");
INSERT INTO brands VALUES("171","TGM JSM WODDEN","","1","2024-01-10 15:01:09","2024-01-10 15:01:09");
INSERT INTO brands VALUES("172","TGM-Anisha","","1","2024-01-10 15:01:09","2024-01-10 15:01:09");
INSERT INTO brands VALUES("173","TGM-Ukulele Center","","1","2024-01-10 15:01:09","2024-01-10 15:01:09");
INSERT INTO brands VALUES("174","THE ROSE","","1","2024-01-10 15:01:09","2024-01-10 15:01:09");
INSERT INTO brands VALUES("175","Vinik EQ TU","","1","2024-01-10 15:01:09","2024-01-10 15:01:09");
INSERT INTO brands VALUES("176","Xmx","","1","2024-01-10 15:01:09","2024-01-10 15:01:09");
INSERT INTO brands VALUES("177","Yamaha FG 200 C","","1","2024-01-10 15:01:09","2024-01-10 15:01:09");
INSERT INTO brands VALUES("178","Yamaha-720-EQ -City","","1","2024-01-10 15:01:09","2024-01-10 15:01:09");
INSERT INTO brands VALUES("179","Yamaha-F/FX- City","","1","2024-01-10 15:01:09","2024-01-10 15:01:09");
INSERT INTO brands VALUES("180","Yamaha-F/FX- EQ-City","","1","2024-01-10 15:01:09","2024-01-10 15:01:09");
INSERT INTO brands VALUES("181","Alphanso_Anisha","","1","2024-01-10 15:01:09","2024-01-10 15:01:09");
INSERT INTO brands VALUES("182","Alphanso_Ben","","1","2024-01-10 15:01:09","2024-01-10 15:01:09");
INSERT INTO brands VALUES("183","Alphanso_LABU","","1","2024-01-10 15:01:09","2024-01-10 15:01:09");
INSERT INTO brands VALUES("184","Aroma","","1","2024-01-10 15:01:09","2024-01-10 15:01:09");
INSERT INTO brands VALUES("185","Effort","","1","2024-01-10 15:01:09","2024-01-10 15:01:09");
INSERT INTO brands VALUES("186","EGM","","1","2024-01-10 15:01:09","2024-01-10 15:01:09");
INSERT INTO brands VALUES("187","Forance","","1","2024-01-10 15:01:09","2024-01-10 15:01:09");
INSERT INTO brands VALUES("188","GT","","1","2024-01-10 15:01:09","2024-01-10 15:01:09");
INSERT INTO brands VALUES("189","GT-20 Uk Center","","1","2024-01-10 15:01:09","2024-01-10 15:01:09");
INSERT INTO brands VALUES("190","GT-40 Uk Center","","1","2024-01-10 15:01:09","2024-01-10 15:01:09");
INSERT INTO brands VALUES("191","SILUERTONE","","1","2024-01-10 15:01:09","2024-01-10 15:01:09");
INSERT INTO brands VALUES("192","STANGER","","1","2024-01-10 15:01:09","2024-01-10 15:01:09");
INSERT INTO brands VALUES("193","TS PG-5","","1","2024-01-10 15:01:09","2024-01-10 15:01:09");
INSERT INTO brands VALUES("194","VIA","","1","2024-01-10 15:01:09","2024-01-10 15:01:09");
INSERT INTO brands VALUES("195","Andier","","1","2024-01-10 15:01:09","2024-01-10 15:01:09");
INSERT INTO brands VALUES("196","Fender_RNG","","1","2024-01-10 15:01:09","2024-01-10 15:01:09");
INSERT INTO brands VALUES("197","Gibson","","1","2024-01-10 15:01:09","2024-01-10 15:01:09");
INSERT INTO brands VALUES("198","Guitar Shop","","1","2024-01-10 15:01:09","2024-01-10 15:01:09");
INSERT INTO brands VALUES("199","IZAL (STI)","","1","2024-01-10 15:01:10","2024-01-10 15:01:10");
INSERT INTO brands VALUES("200","Lespoir","","1","2024-01-10 15:01:10","2024-01-10 15:01:10");
INSERT INTO brands VALUES("201","Levys","","1","2024-01-10 15:01:10","2024-01-10 15:01:10");
INSERT INTO brands VALUES("202","P&P","","1","2024-01-10 15:01:10","2024-01-10 15:01:10");
INSERT INTO brands VALUES("203","Rizo","","1","2024-01-10 15:01:10","2024-01-10 15:01:10");
INSERT INTO brands VALUES("204","Rock you","","1","2024-01-10 15:01:10","2024-01-10 15:01:10");
INSERT INTO brands VALUES("205","SBH","","1","2024-01-10 15:01:10","2024-01-10 15:01:10");
INSERT INTO brands VALUES("206","Smart Case (STI)","","1","2024-01-10 15:01:10","2024-01-10 15:01:10");
INSERT INTO brands VALUES("207","SQOE","","1","2024-01-10 15:01:10","2024-01-10 15:01:10");
INSERT INTO brands VALUES("208","Strinbery","","1","2024-01-10 15:01:10","2024-01-10 15:01:10");
INSERT INTO brands VALUES("209","Woodstock","","1","2024-01-10 15:01:10","2024-01-10 15:01:10");
INSERT INTO brands VALUES("210","good_quality","","1","2024-01-10 15:01:10","2024-01-10 15:01:10");
INSERT INTO brands VALUES("211","Indian","","1","2024-01-10 15:01:10","2024-01-10 15:01:10");
INSERT INTO brands VALUES("212","Donner","","1","2024-01-10 15:01:10","2024-01-10 15:01:10");
INSERT INTO brands VALUES("213","DT","","1","2024-01-10 15:01:10","2024-01-10 15:01:10");
INSERT INTO brands VALUES("214","Flanger","","1","2024-01-10 15:01:10","2024-01-10 15:01:10");
INSERT INTO brands VALUES("215","HK","","1","2024-01-10 15:01:10","2024-01-10 15:01:10");
INSERT INTO brands VALUES("216","INSTRUMENT-Ben","","1","2024-01-10 15:01:10","2024-01-10 15:01:10");
INSERT INTO brands VALUES("217","JTS","","1","2024-01-10 15:01:10","2024-01-10 15:01:10");
INSERT INTO brands VALUES("218","ROHS","","1","2024-01-10 15:01:10","2024-01-10 15:01:10");
INSERT INTO brands VALUES("219","True Magic","","1","2024-01-10 15:01:10","2024-01-10 15:01:10");
INSERT INTO brands VALUES("220","Boston","","1","2024-01-10 15:01:10","2024-01-10 15:01:10");
INSERT INTO brands VALUES("221","Dabbie","","1","2024-01-10 15:01:10","2024-01-10 15:01:10");
INSERT INTO brands VALUES("222","DDL","","1","2024-01-10 15:01:10","2024-01-10 15:01:10");
INSERT INTO brands VALUES("223","Fzone","","1","2024-01-10 15:01:10","2024-01-10 15:01:10");
INSERT INTO brands VALUES("224","HY","","1","2024-01-10 15:01:10","2024-01-10 15:01:10");
INSERT INTO brands VALUES("225","JSM","","1","2024-01-10 15:01:10","2024-01-10 15:01:10");
INSERT INTO brands VALUES("226","Kriens","","1","2024-01-10 15:01:10","2024-01-10 15:01:10");
INSERT INTO brands VALUES("227","Musedo","","1","2024-01-10 15:01:10","2024-01-10 15:01:10");
INSERT INTO brands VALUES("228","Shark Capo","","1","2024-01-10 15:01:11","2024-01-10 15:01:11");
INSERT INTO brands VALUES("229","Spectrum","","1","2024-01-10 15:01:11","2024-01-10 15:01:11");
INSERT INTO brands VALUES("230","Starry Music ","","1","2024-01-10 15:01:11","2024-01-10 15:01:11");
INSERT INTO brands VALUES("231","ZIKO","","1","2024-01-10 15:01:11","2024-01-10 15:01:11");
INSERT INTO brands VALUES("232","Ziko-Anisha","","1","2024-01-10 15:01:11","2024-01-10 15:01:11");
INSERT INTO brands VALUES("233","AKS GITER","","1","2024-01-10 15:01:11","2024-01-10 15:01:11");
INSERT INTO brands VALUES("234","BEN_MUSIC","","1","2024-01-10 15:01:11","2024-01-10 15:01:11");
INSERT INTO brands VALUES("235","Colt","","1","2024-01-10 15:01:11","2024-01-10 15:01:11");
INSERT INTO brands VALUES("236","Colt_rng","","1","2024-01-10 15:01:11","2024-01-10 15:01:11");
INSERT INTO brands VALUES("237","Hercules","","1","2024-01-10 15:01:11","2024-01-10 15:01:11");
INSERT INTO brands VALUES("238","Rowin","","1","2024-01-10 15:01:11","2024-01-10 15:01:11");
INSERT INTO brands VALUES("239","Octave Guitar","","1","2024-01-10 15:01:11","2024-01-10 15:01:11");
INSERT INTO brands VALUES("240","Cherub","","1","2024-01-10 15:01:11","2024-01-10 15:01:11");
INSERT INTO brands VALUES("241","DH","","1","2024-01-10 15:01:11","2024-01-10 15:01:11");
INSERT INTO brands VALUES("242","Homeland","","1","2024-01-10 15:01:11","2024-01-10 15:01:11");
INSERT INTO brands VALUES("243","Nux","","1","2024-01-10 15:01:11","2024-01-10 15:01:11");
INSERT INTO brands VALUES("244","Daddario","","1","2024-01-10 15:01:11","2024-01-10 15:01:11");
INSERT INTO brands VALUES("245","Dunlop","","1","2024-01-10 15:01:11","2024-01-10 15:01:11");
INSERT INTO brands VALUES("246","Lemon Oil","","1","2024-01-10 15:01:11","2024-01-10 15:01:11");
INSERT INTO brands VALUES("247","Music Nomad","","1","2024-01-10 15:01:11","2024-01-10 15:01:11");
INSERT INTO brands VALUES("248","Digitech","","1","2024-01-10 15:01:11","2024-01-10 15:01:11");
INSERT INTO brands VALUES("249","GEM_BOX","","1","2024-01-10 15:01:11","2024-01-10 15:01:11");
INSERT INTO brands VALUES("250","Joyo","","1","2024-01-10 15:01:11","2024-01-10 15:01:11");
INSERT INTO brands VALUES("251","Mooer","","1","2024-01-10 15:01:11","2024-01-10 15:01:11");
INSERT INTO brands VALUES("252","AKS","","1","2024-01-10 15:01:11","2024-01-10 15:01:11");
INSERT INTO brands VALUES("253","Cherry","","1","2024-01-10 15:01:12","2024-01-10 15:01:12");
INSERT INTO brands VALUES("254","Jakir","","1","2024-01-10 15:01:12","2024-01-10 15:01:12");
INSERT INTO brands VALUES("255","RNG_CHINA","","1","2024-01-10 15:01:12","2024-01-10 15:01:12");
INSERT INTO brands VALUES("256","ROCK _","","1","2024-01-10 15:01:12","2024-01-10 15:01:12");
INSERT INTO brands VALUES("257","Darco","","1","2024-01-10 15:01:12","2024-01-10 15:01:12");
INSERT INTO brands VALUES("258","elixer","","1","2024-01-10 15:01:12","2024-01-10 15:01:12");
INSERT INTO brands VALUES("259","Ernie Ball","","1","2024-01-10 15:01:12","2024-01-10 15:01:12");
INSERT INTO brands VALUES("260","Karuna","","1","2024-01-10 15:01:13","2024-01-10 15:01:13");
INSERT INTO brands VALUES("261","Orfee","","1","2024-01-10 15:01:13","2024-01-10 15:01:13");
INSERT INTO brands VALUES("262","Renold","","1","2024-01-10 15:01:13","2024-01-10 15:01:13");
INSERT INTO brands VALUES("263","Spock","","1","2024-01-10 15:01:13","2024-01-10 15:01:13");
INSERT INTO brands VALUES("264","Warner","","1","2024-01-10 15:01:13","2024-01-10 15:01:13");
INSERT INTO brands VALUES("265","Eno Music","","1","2024-01-10 15:01:13","2024-01-10 15:01:13");
INSERT INTO brands VALUES("266","Features","","1","2024-01-10 15:01:13","2024-01-10 15:01:13");
INSERT INTO brands VALUES("267","Caesar","","1","2024-01-10 15:01:13","2024-01-10 15:01:13");
INSERT INTO brands VALUES("268","Honsing","","1","2024-01-10 15:01:14","2024-01-10 15:01:14");
INSERT INTO brands VALUES("269","Start","","1","2024-01-10 15:01:14","2024-01-10 15:01:14");
INSERT INTO brands VALUES("270","Texas","","1","2024-01-10 15:01:14","2024-01-10 15:01:14");
INSERT INTO brands VALUES("271","wadarwood","","1","2024-01-10 15:01:14","2024-01-10 15:01:14");
INSERT INTO brands VALUES("272","Diapason ","","1","2024-01-10 15:01:14","2024-01-10 15:01:14");
INSERT INTO brands VALUES("273","DMTS","","1","2024-01-10 15:01:14","2024-01-10 15:01:14");
INSERT INTO brands VALUES("274","East Top","","1","2024-01-10 15:01:14","2024-01-10 15:01:14");
INSERT INTO brands VALUES("275","FUTURE_STAR","","1","2024-01-10 15:01:14","2024-01-10 15:01:14");
INSERT INTO brands VALUES("276","Golden Cup","","1","2024-01-10 15:01:14","2024-01-10 15:01:14");
INSERT INTO brands VALUES("277","GrandOleopry","","1","2024-01-10 15:01:14","2024-01-10 15:01:14");
INSERT INTO brands VALUES("278","Hdowlin Harp","","1","2024-01-10 15:01:14","2024-01-10 15:01:14");
INSERT INTO brands VALUES("279","Hohner","","1","2024-01-10 15:01:14","2024-01-10 15:01:14");
INSERT INTO brands VALUES("280","IRIN","","1","2024-01-10 15:01:14","2024-01-10 15:01:14");
INSERT INTO brands VALUES("281","JIMM","","1","2024-01-10 15:01:14","2024-01-10 15:01:14");
INSERT INTO brands VALUES("282","Kaine.Z","","1","2024-01-10 15:01:14","2024-01-10 15:01:14");
INSERT INTO brands VALUES("283","Maxtone","","1","2024-01-10 15:01:14","2024-01-10 15:01:14");
INSERT INTO brands VALUES("284","QIMEI","","1","2024-01-10 15:01:14","2024-01-10 15:01:14");
INSERT INTO brands VALUES("285","Stagg","","1","2024-01-10 15:01:14","2024-01-10 15:01:14");
INSERT INTO brands VALUES("286","Suzuki","","1","2024-01-10 15:01:14","2024-01-10 15:01:14");
INSERT INTO brands VALUES("287","Swan","","1","2024-01-10 15:01:14","2024-01-10 15:01:14");
INSERT INTO brands VALUES("288","swan senior","","1","2024-01-10 15:01:14","2024-01-10 15:01:14");
INSERT INTO brands VALUES("289","Swing","","1","2024-01-10 15:01:14","2024-01-10 15:01:14");
INSERT INTO brands VALUES("290","Tower","","1","2024-01-10 15:01:14","2024-01-10 15:01:14");
INSERT INTO brands VALUES("291","Twer","","1","2024-01-10 15:01:14","2024-01-10 15:01:14");
INSERT INTO brands VALUES("292","Winner","","1","2024-01-10 15:01:14","2024-01-10 15:01:14");
INSERT INTO brands VALUES("293","Melody New","","1","2024-01-10 15:01:14","2024-01-10 15:01:14");
INSERT INTO brands VALUES("294","Givson","","1","2024-01-10 15:01:15","2024-01-10 15:01:15");
INSERT INTO brands VALUES("295","Audio-technica","","1","2024-01-10 15:01:15","2024-01-10 15:01:15");
INSERT INTO brands VALUES("296","Cosonic","","1","2024-01-10 15:01:15","2024-01-10 15:01:15");
INSERT INTO brands VALUES("297","ESI ","","1","2024-01-10 15:01:15","2024-01-10 15:01:15");
INSERT INTO brands VALUES("298","Intex","","1","2024-01-10 15:01:15","2024-01-10 15:01:15");
INSERT INTO brands VALUES("299","Jbl","","1","2024-01-10 15:01:15","2024-01-10 15:01:15");
INSERT INTO brands VALUES("300","Jeway","","1","2024-01-10 15:01:15","2024-01-10 15:01:15");
INSERT INTO brands VALUES("301","Logitech","","1","2024-01-10 15:01:15","2024-01-10 15:01:15");
INSERT INTO brands VALUES("302","Marshall","","1","2024-01-10 15:01:15","2024-01-10 15:01:15");
INSERT INTO brands VALUES("303","Oneodio","","1","2024-01-10 15:01:15","2024-01-10 15:01:15");
INSERT INTO brands VALUES("304","Pioneer","","1","2024-01-10 15:01:15","2024-01-10 15:01:15");
INSERT INTO brands VALUES("305","Sony","","1","2024-01-10 15:01:15","2024-01-10 15:01:15");
INSERT INTO brands VALUES("306","Superlux","","1","2024-01-10 15:01:15","2024-01-10 15:01:15");
INSERT INTO brands VALUES("307","Wirless","","1","2024-01-10 15:01:15","2024-01-10 15:01:15");
INSERT INTO brands VALUES("308","Neutrik","","1","2024-01-10 15:01:15","2024-01-10 15:01:15");
INSERT INTO brands VALUES("309","Rean","","1","2024-01-10 15:01:15","2024-01-10 15:01:15");
INSERT INTO brands VALUES("310","Pearl-Soor Sathi","","1","2024-01-10 15:01:15","2024-01-10 15:01:15");
INSERT INTO brands VALUES("311","PROMIR","","1","2024-01-10 15:01:15","2024-01-10 15:01:15");
INSERT INTO brands VALUES("312","PROMIR_KAHON","","1","2024-01-10 15:01:15","2024-01-10 15:01:15");
INSERT INTO brands VALUES("313","Chaina   ","","1","2024-01-10 15:01:15","2024-01-10 15:01:15");
INSERT INTO brands VALUES("314","China","","1","2024-01-10 15:01:15","2024-01-10 15:01:15");
INSERT INTO brands VALUES("315","Rifat","","1","2024-01-10 15:01:15","2024-01-10 15:01:15");
INSERT INTO brands VALUES("316","Moukey","","1","2024-01-10 15:01:15","2024-01-10 15:01:15");
INSERT INTO brands VALUES("317","Wsier","","1","2024-01-10 15:01:15","2024-01-10 15:01:15");
INSERT INTO brands VALUES("318","X1 PLUSH","","1","2024-01-10 15:01:15","2024-01-10 15:01:15");
INSERT INTO brands VALUES("319","Alesis V 49 MIDI","","1","2024-01-10 15:01:16","2024-01-10 15:01:16");
INSERT INTO brands VALUES("320","Infrasonic","","1","2024-01-10 15:01:16","2024-01-10 15:01:16");
INSERT INTO brands VALUES("321","M STUDIO","","1","2024-01-10 15:01:16","2024-01-10 15:01:16");
INSERT INTO brands VALUES("322","M-Audio","","1","2024-01-10 15:01:16","2024-01-10 15:01:16");
INSERT INTO brands VALUES("323","Meike","","1","2024-01-10 15:01:16","2024-01-10 15:01:16");
INSERT INTO brands VALUES("324","MK","","1","2024-01-10 15:01:16","2024-01-10 15:01:16");
INSERT INTO brands VALUES("325","Novation","","1","2024-01-10 15:01:16","2024-01-10 15:01:16");
INSERT INTO brands VALUES("326","Novation Launch MIDI 49","","1","2024-01-10 15:01:16","2024-01-10 15:01:16");
INSERT INTO brands VALUES("327","ROCK STAR","","1","2024-01-10 15:01:16","2024-01-10 15:01:16");
INSERT INTO brands VALUES("328","Roland","","1","2024-01-10 15:01:16","2024-01-10 15:01:16");
INSERT INTO brands VALUES("329","Trinity","","1","2024-01-10 15:01:16","2024-01-10 15:01:16");
INSERT INTO brands VALUES("330","Yamaha MOTIF X F- 6","","1","2024-01-10 15:01:16","2024-01-10 15:01:16");
INSERT INTO brands VALUES("331","Hard Case","","1","2024-01-10 15:01:16","2024-01-10 15:01:16");
INSERT INTO brands VALUES("332","Double Tube X Senior-City","","1","2024-01-10 15:01:16","2024-01-10 15:01:16");
INSERT INTO brands VALUES("333","GB","","1","2024-01-10 15:01:16","2024-01-10 15:01:16");
INSERT INTO brands VALUES("334","PA- 520 JSM","","1","2024-01-10 15:01:17","2024-01-10 15:01:17");
INSERT INTO brands VALUES("335","Weida","","1","2024-01-10 15:01:17","2024-01-10 15:01:17");
INSERT INTO brands VALUES("336","English","","1","2024-01-10 15:01:17","2024-01-10 15:01:17");
INSERT INTO brands VALUES("337","Jiangsu","","1","2024-01-10 15:01:17","2024-01-10 15:01:17");
INSERT INTO brands VALUES("338","GODSON","","1","2024-01-10 15:01:17","2024-01-10 15:01:17");
INSERT INTO brands VALUES("339","Hobner","","1","2024-01-10 15:01:17","2024-01-10 15:01:17");
INSERT INTO brands VALUES("340","king lion","","1","2024-01-10 15:01:17","2024-01-10 15:01:17");
INSERT INTO brands VALUES("341","Ahuja","","1","2024-01-10 15:01:17","2024-01-10 15:01:17");
INSERT INTO brands VALUES("342","AKG","","1","2024-01-10 15:01:17","2024-01-10 15:01:17");
INSERT INTO brands VALUES("343","Aver Media AM133","","1","2024-01-10 15:01:17","2024-01-10 15:01:17");
INSERT INTO brands VALUES("344","Blue","","1","2024-01-10 15:01:17","2024-01-10 15:01:17");
INSERT INTO brands VALUES("345","BM","","1","2024-01-10 15:01:17","2024-01-10 15:01:17");
INSERT INTO brands VALUES("346","Boya","","1","2024-01-10 15:01:17","2024-01-10 15:01:17");
INSERT INTO brands VALUES("347","Carol","","1","2024-01-10 15:01:17","2024-01-10 15:01:17");
INSERT INTO brands VALUES("348","CEER","","1","2024-01-10 15:01:17","2024-01-10 15:01:17");
INSERT INTO brands VALUES("349","DJ Plus Professional","","1","2024-01-10 15:01:17","2024-01-10 15:01:17");
INSERT INTO brands VALUES("350","EALSEM","","1","2024-01-10 15:01:17","2024-01-10 15:01:17");
INSERT INTO brands VALUES("351","Fifine","","1","2024-01-10 15:01:17","2024-01-10 15:01:17");
INSERT INTO brands VALUES("352","K8","","1","2024-01-10 15:01:17","2024-01-10 15:01:17");
INSERT INTO brands VALUES("353","Max ","","1","2024-01-10 15:01:17","2024-01-10 15:01:17");
INSERT INTO brands VALUES("354","Rode","","1","2024-01-10 15:01:17","2024-01-10 15:01:17");
INSERT INTO brands VALUES("355","Rode_NT usb","","1","2024-01-10 15:01:17","2024-01-10 15:01:17");
INSERT INTO brands VALUES("356","Sennheiser","","1","2024-01-10 15:01:17","2024-01-10 15:01:17");
INSERT INTO brands VALUES("357","Shure","","1","2024-01-10 15:01:17","2024-01-10 15:01:17");
INSERT INTO brands VALUES("358","Shure-Wireless","","1","2024-01-10 15:01:17","2024-01-10 15:01:17");
INSERT INTO brands VALUES("359","UHF","","1","2024-01-10 15:01:17","2024-01-10 15:01:17");
INSERT INTO brands VALUES("360","Tennery","","1","2024-01-10 15:01:17","2024-01-10 15:01:17");
INSERT INTO brands VALUES("361","mic.stand_ciity_FS_107","","1","2024-01-10 15:01:17","2024-01-10 15:01:17");
INSERT INTO brands VALUES("362","Platinum","","1","2024-01-10 15:01:18","2024-01-10 15:01:18");
INSERT INTO brands VALUES("363","Pro Stand","","1","2024-01-10 15:01:18","2024-01-10 15:01:18");
INSERT INTO brands VALUES("364","PLANET WAVES","","1","2024-01-10 15:01:18","2024-01-10 15:01:18");
INSERT INTO brands VALUES("365","MINI KALIMBA -CHINA","","1","2024-01-10 15:01:18","2024-01-10 15:01:18");
INSERT INTO brands VALUES("366","Aptech","","1","2024-01-10 15:01:18","2024-01-10 15:01:18");
INSERT INTO brands VALUES("367","Rock Star Pro","","1","2024-01-10 15:01:18","2024-01-10 15:01:18");
INSERT INTO brands VALUES("368","Lunch pad","","1","2024-01-10 15:01:18","2024-01-10 15:01:18");
INSERT INTO brands VALUES("369","Iron Cobra","","1","2024-01-10 15:01:18","2024-01-10 15:01:18");
INSERT INTO brands VALUES("370","Maraca","","1","2024-01-10 15:01:18","2024-01-10 15:01:18");
INSERT INTO brands VALUES("371","Sound Eggs","","1","2024-01-10 15:01:18","2024-01-10 15:01:18");
INSERT INTO brands VALUES("372","Tambourine","","1","2024-01-10 15:01:18","2024-01-10 15:01:18");
INSERT INTO brands VALUES("373","GSBD","","1","2024-01-10 15:01:18","2024-01-10 15:01:18");
INSERT INTO brands VALUES("374","Alice- S.T.I","","1","2024-01-10 15:01:19","2024-01-10 15:01:19");
INSERT INTO brands VALUES("375","AZAD Picks","","1","2024-01-10 15:01:19","2024-01-10 15:01:19");
INSERT INTO brands VALUES("376","Classic","","1","2024-01-10 15:01:19","2024-01-10 15:01:19");
INSERT INTO brands VALUES("377","Designed","","1","2024-01-10 15:01:19","2024-01-10 15:01:19");
INSERT INTO brands VALUES("378","Greek","","1","2024-01-10 15:01:19","2024-01-10 15:01:19");
INSERT INTO brands VALUES("379","Jack Daniels","","1","2024-01-10 15:01:19","2024-01-10 15:01:19");
INSERT INTO brands VALUES("380","John Petrucci","","1","2024-01-10 15:01:19","2024-01-10 15:01:19");
INSERT INTO brands VALUES("381","Print","","1","2024-01-10 15:01:19","2024-01-10 15:01:19");
INSERT INTO brands VALUES("382","Printed","","1","2024-01-10 15:01:19","2024-01-10 15:01:19");
INSERT INTO brands VALUES("383","Rock Man","","1","2024-01-10 15:01:19","2024-01-10 15:01:19");
INSERT INTO brands VALUES("384","EYS","","1","2024-01-10 15:01:19","2024-01-10 15:01:19");
INSERT INTO brands VALUES("385","Knox","","1","2024-01-10 15:01:19","2024-01-10 15:01:19");
INSERT INTO brands VALUES("386","VIVITEK","","1","2024-01-10 15:01:19","2024-01-10 15:01:19");
INSERT INTO brands VALUES("387","Training","","1","2024-01-10 15:01:19","2024-01-10 15:01:19");
INSERT INTO brands VALUES("388","Focusrite","","1","2024-01-10 15:01:19","2024-01-10 15:01:19");
INSERT INTO brands VALUES("389","Focusrite_scarlet","","1","2024-01-10 15:01:19","2024-01-10 15:01:19");
INSERT INTO brands VALUES("390","Komplete","","1","2024-01-10 15:01:19","2024-01-10 15:01:19");
INSERT INTO brands VALUES("391","Midiplus","","1","2024-01-10 15:01:19","2024-01-10 15:01:19");
INSERT INTO brands VALUES("392","Scarlett","","1","2024-01-10 15:01:19","2024-01-10 15:01:19");
INSERT INTO brands VALUES("393","Bose","","1","2024-01-10 15:01:19","2024-01-10 15:01:19");
INSERT INTO brands VALUES("394","Digital X","","1","2024-01-10 15:01:19","2024-01-10 15:01:19");
INSERT INTO brands VALUES("395","ESI Octiv 05","","1","2024-01-10 15:01:19","2024-01-10 15:01:19");
INSERT INTO brands VALUES("396","Kamasonic","","1","2024-01-10 15:01:20","2024-01-10 15:01:20");
INSERT INTO brands VALUES("397","Mctim","","1","2024-01-10 15:01:20","2024-01-10 15:01:20");
INSERT INTO brands VALUES("398","Microlab","","1","2024-01-10 15:01:20","2024-01-10 15:01:20");
INSERT INTO brands VALUES("399","Mini Speaker","","1","2024-01-10 15:01:20","2024-01-10 15:01:20");
INSERT INTO brands VALUES("400","My Vision","","1","2024-01-10 15:01:20","2024-01-10 15:01:20");
INSERT INTO brands VALUES("401","Pixxo","","1","2024-01-10 15:01:20","2024-01-10 15:01:20");
INSERT INTO brands VALUES("402","Presonus","","1","2024-01-10 15:01:20","2024-01-10 15:01:20");
INSERT INTO brands VALUES("403","SK ONE","","1","2024-01-10 15:01:20","2024-01-10 15:01:20");
INSERT INTO brands VALUES("404","Stanza","","1","2024-01-10 15:01:20","2024-01-10 15:01:20");
INSERT INTO brands VALUES("405","Vker","","1","2024-01-10 15:01:20","2024-01-10 15:01:20");
INSERT INTO brands VALUES("406","Wireless Speaker","","1","2024-01-10 15:01:20","2024-01-10 15:01:20");
INSERT INTO brands VALUES("407","XCL","","1","2024-01-10 15:01:20","2024-01-10 15:01:20");
INSERT INTO brands VALUES("408","Xtreme","","1","2024-01-10 15:01:20","2024-01-10 15:01:20");
INSERT INTO brands VALUES("409","Good Quality","","1","2024-01-10 15:01:20","2024-01-10 15:01:20");
INSERT INTO brands VALUES("410","WRI","","1","2024-01-10 15:01:20","2024-01-10 15:01:20");
INSERT INTO brands VALUES("411","Raagini","","1","2024-01-10 15:01:20","2024-01-10 15:01:20");
INSERT INTO brands VALUES("412","Radel","","1","2024-01-10 15:01:20","2024-01-10 15:01:20");
INSERT INTO brands VALUES("413","Sangat","","1","2024-01-10 15:01:20","2024-01-10 15:01:20");
INSERT INTO brands VALUES("414","Miles 40th Anniversary","","1","2024-01-10 15:01:20","2024-01-10 15:01:20");
INSERT INTO brands VALUES("415","TOSHIBA","","1","2024-01-10 15:01:20","2024-01-10 15:01:20");
INSERT INTO brands VALUES("416","Ammoon","","1","2024-01-10 15:01:20","2024-01-10 15:01:20");
INSERT INTO brands VALUES("417","Amos","","1","2024-01-10 15:01:20","2024-01-10 15:01:20");
INSERT INTO brands VALUES("418","Aquila","","1","2024-01-10 15:01:20","2024-01-10 15:01:20");
INSERT INTO brands VALUES("419","AXE-Ukulele Center","","1","2024-01-10 15:01:20","2024-01-10 15:01:20");
INSERT INTO brands VALUES("420","B W S- JM","","1","2024-01-10 15:01:20","2024-01-10 15:01:20");
INSERT INTO brands VALUES("421","Birds","","1","2024-01-10 15:01:21","2024-01-10 15:01:21");
INSERT INTO brands VALUES("422","Blackwolf","","1","2024-01-10 15:01:21","2024-01-10 15:01:21");
INSERT INTO brands VALUES("423","BWS","","1","2024-01-10 15:01:21","2024-01-10 15:01:21");
INSERT INTO brands VALUES("424","Carte","","1","2024-01-10 15:01:21","2024-01-10 15:01:21");
INSERT INTO brands VALUES("425","Chanson & Robles","","1","2024-01-10 15:01:21","2024-01-10 15:01:21");
INSERT INTO brands VALUES("426","Chenson and Rubles","","1","2024-01-10 15:01:21","2024-01-10 15:01:21");
INSERT INTO brands VALUES("427","Cordoba Azad","","1","2024-01-10 15:01:21","2024-01-10 15:01:21");
INSERT INTO brands VALUES("428","Deviser- JM","","1","2024-01-10 15:01:21","2024-01-10 15:01:21");
INSERT INTO brands VALUES("429","DEVISER_LABU","","1","2024-01-10 15:01:21","2024-01-10 15:01:21");
INSERT INTO brands VALUES("430","Dodomi","","1","2024-01-10 15:01:21","2024-01-10 15:01:21");
INSERT INTO brands VALUES("431","Dong Ling","","1","2024-01-10 15:01:21","2024-01-10 15:01:21");
INSERT INTO brands VALUES("432","DOTCH-City","","1","2024-01-10 15:01:21","2024-01-10 15:01:21");
INSERT INTO brands VALUES("433","EKO","","1","2024-01-10 15:01:21","2024-01-10 15:01:21");
INSERT INTO brands VALUES("434","Epiphone-Ukulele Center-26 new","","1","2024-01-10 15:01:21","2024-01-10 15:01:21");
INSERT INTO brands VALUES("435","Flight","","1","2024-01-10 15:01:21","2024-01-10 15:01:21");
INSERT INTO brands VALUES("436","Guliani","","1","2024-01-10 15:01:21","2024-01-10 15:01:21");
INSERT INTO brands VALUES("437","Guson","","1","2024-01-10 15:01:21","2024-01-10 15:01:21");
INSERT INTO brands VALUES("438","GW","","1","2024-01-10 15:01:21","2024-01-10 15:01:21");
INSERT INTO brands VALUES("439","Harley Benton","","1","2024-01-10 15:01:21","2024-01-10 15:01:21");
INSERT INTO brands VALUES("440","HOKE-Ukulele Center","","1","2024-01-10 15:01:21","2024-01-10 15:01:21");
INSERT INTO brands VALUES("441","HOLA ! -JSM","","1","2024-01-10 15:01:21","2024-01-10 15:01:21");
INSERT INTO brands VALUES("442","HOLA ! -Package","","1","2024-01-10 15:01:21","2024-01-10 15:01:21");
INSERT INTO brands VALUES("443","J&D","","1","2024-01-10 15:01:21","2024-01-10 15:01:21");
INSERT INTO brands VALUES("444","Joker Azad","","1","2024-01-10 15:01:21","2024-01-10 15:01:21");
INSERT INTO brands VALUES("445","Kabat","","1","2024-01-10 15:01:21","2024-01-10 15:01:21");
INSERT INTO brands VALUES("446","Kala","","1","2024-01-10 15:01:21","2024-01-10 15:01:21");
INSERT INTO brands VALUES("447","Kane","","1","2024-01-10 15:01:21","2024-01-10 15:01:21");
INSERT INTO brands VALUES("448","Lankro","","1","2024-01-10 15:01:21","2024-01-10 15:01:21");
INSERT INTO brands VALUES("449","LEEN","","1","2024-01-10 15:01:21","2024-01-10 15:01:21");
INSERT INTO brands VALUES("450","Mahalo","","1","2024-01-10 15:01:21","2024-01-10 15:01:21");
INSERT INTO brands VALUES("451","MAHALO-Ukulele Center","","1","2024-01-10 15:01:21","2024-01-10 15:01:21");
INSERT INTO brands VALUES("452","Matilda","","1","2024-01-10 15:01:21","2024-01-10 15:01:21");
INSERT INTO brands VALUES("453","Matthew","","1","2024-01-10 15:01:21","2024-01-10 15:01:21");
INSERT INTO brands VALUES("454","Mentreel-JSM","","1","2024-01-10 15:01:21","2024-01-10 15:01:21");
INSERT INTO brands VALUES("455","Olive","","1","2024-01-10 15:01:22","2024-01-10 15:01:22");
INSERT INTO brands VALUES("456","Olive New Package ","","1","2024-01-10 15:01:22","2024-01-10 15:01:22");
INSERT INTO brands VALUES("457","Omugo","","1","2024-01-10 15:01:22","2024-01-10 15:01:22");
INSERT INTO brands VALUES("458","QTE Azad","","1","2024-01-10 15:01:22","2024-01-10 15:01:22");
INSERT INTO brands VALUES("459","Quired","","1","2024-01-10 15:01:22","2024-01-10 15:01:22");
INSERT INTO brands VALUES("460","Rainie","","1","2024-01-10 15:01:22","2024-01-10 15:01:22");
INSERT INTO brands VALUES("461","RGM_LABU","","1","2024-01-10 15:01:22","2024-01-10 15:01:22");
INSERT INTO brands VALUES("462","Rock Breath","","1","2024-01-10 15:01:22","2024-01-10 15:01:22");
INSERT INTO brands VALUES("463","Rock Jam","","1","2024-01-10 15:01:22","2024-01-10 15:01:22");
INSERT INTO brands VALUES("464","SANA","","1","2024-01-10 15:01:22","2024-01-10 15:01:22");
INSERT INTO brands VALUES("465","STI/Aban","","1","2024-01-10 15:01:22","2024-01-10 15:01:22");
INSERT INTO brands VALUES("466","Strinberg ","","1","2024-01-10 15:01:22","2024-01-10 15:01:22");
INSERT INTO brands VALUES("467","Tayste-Ukulele Center-26 new","","1","2024-01-10 15:01:22","2024-01-10 15:01:22");
INSERT INTO brands VALUES("468","TGM Azad","","1","2024-01-10 15:01:22","2024-01-10 15:01:22");
INSERT INTO brands VALUES("469","TGM-JSM","","1","2024-01-10 15:01:22","2024-01-10 15:01:22");
INSERT INTO brands VALUES("470","TGM_LABU","","1","2024-01-10 15:01:22","2024-01-10 15:01:22");
INSERT INTO brands VALUES("471","Tyson","","1","2024-01-10 15:01:22","2024-01-10 15:01:22");
INSERT INTO brands VALUES("472","washburn","","1","2024-01-10 15:01:22","2024-01-10 15:01:22");
INSERT INTO brands VALUES("473","YAEL","","1","2024-01-10 15:01:22","2024-01-10 15:01:22");
INSERT INTO brands VALUES("474","YAHAMA-Ukulele Center-26 new","","1","2024-01-10 15:01:22","2024-01-10 15:01:22");
INSERT INTO brands VALUES("475","Yamaha-JM","","1","2024-01-10 15:01:22","2024-01-10 15:01:22");
INSERT INTO brands VALUES("476","YAMAHA-Ukulele Center","","1","2024-01-10 15:01:22","2024-01-10 15:01:22");
INSERT INTO brands VALUES("477","YAMAHA_LABU","","1","2024-01-10 15:01:22","2024-01-10 15:01:22");
INSERT INTO brands VALUES("478","Yeal","","1","2024-01-10 15:01:22","2024-01-10 15:01:22");
INSERT INTO brands VALUES("479","Amola","","1","2024-01-10 15:01:22","2024-01-10 15:01:22");
INSERT INTO brands VALUES("480","NIHIL- White Nylon","","1","2024-01-10 15:01:22","2024-01-10 15:01:22");
INSERT INTO brands VALUES("481","Chaina Black","","1","2024-01-10 15:01:23","2024-01-10 15:01:23");
INSERT INTO brands VALUES("482","Deviser_MDY","","1","2024-01-10 15:01:23","2024-01-10 15:01:23");
INSERT INTO brands VALUES("483","Jewelley","","1","2024-01-10 15:01:23","2024-01-10 15:01:23");
INSERT INTO brands VALUES("484","Juliana","","1","2024-01-10 15:01:23","2024-01-10 15:01:23");
INSERT INTO brands VALUES("485","Fom","","1","2024-01-10 15:01:23","2024-01-10 15:01:23");
INSERT INTO brands VALUES("486","Alice loose","","1","2024-01-10 15:01:23","2024-01-10 15:01:23");
INSERT INTO brands VALUES("487","PLASTIC","","1","2024-01-10 15:01:23","2024-01-10 15:01:23");
INSERT INTO brands VALUES("488","Dolphin","","1","2024-01-10 15:01:23","2024-01-10 15:01:23");



CREATE TABLE `cash_registers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cash_in_hand` double NOT NULL,
  `user_id` int(11) NOT NULL,
  `warehouse_id` int(11) NOT NULL,
  `status` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO cash_registers VALUES("1","100","9","1","0","2020-10-13 03:32:54","2020-10-23 20:27:42");
INSERT INTO cash_registers VALUES("2","50","9","1","1","2020-10-13 11:25:26","2020-10-13 11:25:26");
INSERT INTO cash_registers VALUES("3","200","1","1","1","2020-10-22 03:53:07","2020-10-23 20:33:32");
INSERT INTO cash_registers VALUES("4","100","1","2","1","2020-10-23 21:04:39","2020-10-23 21:04:39");
INSERT INTO cash_registers VALUES("5","1000","29","1","0","2022-03-02 13:01:08","2022-03-05 13:34:58");
INSERT INTO cash_registers VALUES("6","100","29","1","1","2022-03-05 13:38:27","2022-03-05 13:38:27");
INSERT INTO cash_registers VALUES("7","1000","1","9","1","2022-05-21 23:10:51","2022-05-21 23:10:51");
INSERT INTO cash_registers VALUES("8","10000","1","7","1","2022-05-24 22:00:08","2022-05-24 22:00:08");
INSERT INTO cash_registers VALUES("9","5000","1","1","1","2022-11-05 23:10:42","2022-11-05 23:10:42");
INSERT INTO cash_registers VALUES("10","1000","1","7","1","2022-12-21 16:05:43","2022-12-21 16:05:43");
INSERT INTO cash_registers VALUES("11","2000","1","1","1","2022-12-21 16:05:57","2022-12-21 16:05:57");
INSERT INTO cash_registers VALUES("12","10000","1","8","1","2022-12-21 16:06:05","2022-12-21 16:06:05");



CREATE TABLE `categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `image` varchar(191) DEFAULT NULL,
  `parent_id` int(11) DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=947 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO categories VALUES("1","Fruits","","9","0","2018-05-11 23:27:25","2023-11-23 16:57:37");
INSERT INTO categories VALUES("2","electronics","","","0","2018-05-11 23:35:57","2023-11-23 16:55:54");
INSERT INTO categories VALUES("3","computer","20200701093146.jpg","51","0","2018-05-11 23:36:08","2023-11-25 16:15:12");
INSERT INTO categories VALUES("4","toy","","","0","2018-05-23 18:57:48","2023-11-23 17:12:13");
INSERT INTO categories VALUES("7","jacket","","","0","2018-05-27 18:39:51","2018-05-27 18:40:48");
INSERT INTO categories VALUES("9","food","","","0","2018-06-24 21:21:40","2023-11-23 16:53:26");
INSERT INTO categories VALUES("10","anda","","","0","2018-08-28 19:36:31","2018-08-28 19:37:34");
INSERT INTO categories VALUES("11","anda","","","0","2018-08-28 19:48:06","2018-08-28 19:53:22");
INSERT INTO categories VALUES("12","Accessories","","","0","2018-12-04 18:28:53","2024-01-10 12:32:20");
INSERT INTO categories VALUES("14","nn","","","0","2019-04-10 00:22:30","2019-04-10 01:38:47");
INSERT INTO categories VALUES("15","nm","","","0","2019-04-10 00:22:36","2019-04-10 01:41:43");
INSERT INTO categories VALUES("16","desktop","","3","0","2020-03-11 06:42:33","2023-11-25 16:15:21");
INSERT INTO categories VALUES("17","tostos","20200701080042.png","","0","2020-07-01 10:00:42","2020-07-01 11:35:34");
INSERT INTO categories VALUES("19","Paracetamol","","","0","2021-03-07 02:16:01","2023-11-23 17:11:05");
INSERT INTO categories VALUES("20","Shows","","","0","2022-03-05 13:44:04","2023-11-23 17:11:05");
INSERT INTO categories VALUES("21","fish","","9","0","2022-03-07 09:25:23","2023-11-23 16:57:28");
INSERT INTO categories VALUES("22","apparel","","","0","2022-03-07 09:25:23","2023-09-20 13:40:00");
INSERT INTO categories VALUES("23","ladies","","25","0","2022-03-07 09:26:17","2023-11-23 16:58:03");
INSERT INTO categories VALUES("24","GENTS","","25","0","2022-03-07 10:03:31","2023-11-23 17:11:05");
INSERT INTO categories VALUES("25","FOOTWEAR","","","0","2022-03-07 11:57:05","2022-03-07 15:37:17");
INSERT INTO categories VALUES("26","BABYS","","25","0","2022-03-07 11:57:53","2023-11-23 17:12:13");
INSERT INTO categories VALUES("27","thai","","","0","2022-03-16 16:34:02","2023-11-23 17:12:13");
INSERT INTO categories VALUES("28","Spectacles","","","0","2022-05-21 23:03:00","2023-11-23 17:12:13");
INSERT INTO categories VALUES("29","Rui","","","0","2022-10-12 01:07:37","2023-11-23 17:11:05");
INSERT INTO categories VALUES("30","honey","","","0","2022-10-23 22:42:10","2023-11-23 16:57:52");
INSERT INTO categories VALUES("31","Kaner Dul","","","0","2023-07-27 01:40:30","2023-11-23 17:09:57");
INSERT INTO categories VALUES("32","Volume Padal","20231125043155.jpg","","1","2023-09-20 12:11:19","2024-01-10 13:32:19");
INSERT INTO categories VALUES("33","Medicine","","","0","2023-10-09 13:34:10","2023-11-23 16:58:23");
INSERT INTO categories VALUES("34","","","","0","2023-10-09 16:07:50","2023-11-23 17:09:57");
INSERT INTO categories VALUES("35","Azithromycin","","","0","2023-10-29 13:39:11","2023-11-23 16:54:50");
INSERT INTO categories VALUES("36","Cefuroxime","","","0","2023-10-29 13:39:11","2023-11-23 16:54:32");
INSERT INTO categories VALUES("37","Rosuvastatin","","","0","2023-10-29 13:39:11","2023-11-23 17:11:05");
INSERT INTO categories VALUES("38","Albendazole","","","0","2023-10-29 13:54:24","2023-11-23 16:53:45");
INSERT INTO categories VALUES("39","Omeprazole","","","0","2023-10-29 17:27:13","2023-11-23 17:09:57");
INSERT INTO categories VALUES("40","Levetiracetam","","","0","2023-10-29 17:27:13","2023-11-23 17:09:57");
INSERT INTO categories VALUES("41","Cefixime","","","0","2023-10-29 17:27:13","2023-11-23 16:55:54");
INSERT INTO categories VALUES("42","Esomeprazole","","","0","2023-10-29 17:27:13","2023-11-23 16:55:54");
INSERT INTO categories VALUES("43","Atorvastatin","","","0","2023-10-29 17:27:13","2023-11-23 16:54:41");
INSERT INTO categories VALUES("44","Ticagrelor","","","0","2023-10-29 17:27:13","2023-11-23 17:12:13");
INSERT INTO categories VALUES("45","Mebendazole","","","0","2023-10-29 17:27:13","2023-11-23 16:58:14");
INSERT INTO categories VALUES("46","Amoxicillin","","","0","2023-10-29 17:27:13","2023-11-23 16:54:11");
INSERT INTO categories VALUES("47","Diclofenac Sodium","","","0","2023-10-29 17:27:13","2023-11-23 16:55:02");
INSERT INTO categories VALUES("48","Ferrous Sulphate","","","0","2023-10-29 17:27:13","2023-11-23 16:56:15");
INSERT INTO categories VALUES("49","Zinc","","","0","2023-10-29 17:27:13","2023-11-23 17:12:13");
INSERT INTO categories VALUES("50","Metronidazole","","","0","2023-10-29 17:27:13","2023-11-23 16:58:37");
INSERT INTO categories VALUES("51","VOLUME NOB","20231123053929.png","","1","2023-11-23 17:14:03","2024-01-10 13:32:49");
INSERT INTO categories VALUES("52","Used Laptop","20231214123959.jpeg","","0","2023-11-23 17:38:50","2023-12-14 12:40:08");
INSERT INTO categories VALUES("53","Violin String","20231204014640.jpg","","1","2023-12-04 12:24:31","2024-01-10 13:33:22");
INSERT INTO categories VALUES("54","Vocal Studio Pro","20231204014410.jpg","","1","2023-12-04 13:44:10","2024-01-10 13:33:10");
INSERT INTO categories VALUES("55","VR Box","20231204014449.jpg","","1","2023-12-04 13:44:49","2024-01-10 13:31:54");
INSERT INTO categories VALUES("56","Wrist Band","20231204014548.jpg","","1","2023-12-04 13:45:48","2024-01-10 13:31:27");
INSERT INTO categories VALUES("57","Air Conditioner","","","0","2023-12-11 16:55:44","2023-12-14 13:20:23");
INSERT INTO categories VALUES("58","Air Curtain","","","0","2023-12-11 16:56:10","2023-12-14 17:51:44");
INSERT INTO categories VALUES("59","Air Fryer","","93","0","2023-12-11 16:56:26","2024-01-10 12:32:20");
INSERT INTO categories VALUES("60","Blender","","93","0","2023-12-11 16:56:42","2024-01-10 12:32:21");
INSERT INTO categories VALUES("61","Breakfast Maker","","93","0","2023-12-11 16:57:01","2024-01-10 12:32:21");
INSERT INTO categories VALUES("62","Coffee Grinder","","93","0","2023-12-11 16:57:19","2024-01-10 12:32:21");
INSERT INTO categories VALUES("63","Doi Maker","","95","0","2023-12-11 16:57:31","2024-01-10 13:04:56");
INSERT INTO categories VALUES("64","Dry Iron","","92","0","2023-12-11 16:57:43","2024-01-10 13:04:56");
INSERT INTO categories VALUES("65","Egg Beater","","95","0","2023-12-11 16:57:55","2024-01-10 13:04:56");
INSERT INTO categories VALUES("66","Electric Kettle","","93","0","2023-12-11 16:58:17","2024-01-10 13:04:57");
INSERT INTO categories VALUES("67","Food Processor","","93","0","2023-12-11 16:59:11","2024-01-10 13:04:57");
INSERT INTO categories VALUES("68","Gas Stove","","93","0","2023-12-11 16:59:22","2024-01-10 13:04:57");
INSERT INTO categories VALUES("69","Germ Kit","","","0","2023-12-11 16:59:37","2023-12-14 17:49:30");
INSERT INTO categories VALUES("70","Hairdryer","","92","0","2023-12-11 17:00:28","2024-01-10 13:04:57");
INSERT INTO categories VALUES("71","Hand Mixer","","95","0","2023-12-11 17:00:40","2024-01-10 13:04:57");
INSERT INTO categories VALUES("72","Induction Cooker","","93","0","2023-12-11 17:00:54","2024-01-10 13:04:57");
INSERT INTO categories VALUES("73","Infrared Cooker","","93","0","2023-12-11 17:01:03","2024-01-10 13:04:57");
INSERT INTO categories VALUES("74","Germ Kit","","95","0","2023-12-11 17:03:35","2024-01-10 13:04:57");
INSERT INTO categories VALUES("75","LED Light","","95","0","2023-12-11 17:03:47","2024-01-10 13:04:58");
INSERT INTO categories VALUES("76","LED TV","","51","0","2023-12-11 17:04:30","2024-01-10 13:04:58");
INSERT INTO categories VALUES("77","Microwave Oven","","93","0","2023-12-11 17:04:51","2024-01-10 13:04:58");
INSERT INTO categories VALUES("78","Mosquito Swatter","","95","0","2023-12-11 17:05:04","2024-01-10 13:05:19");
INSERT INTO categories VALUES("79","Non Stick","","93","0","2023-12-11 17:05:16","2024-01-10 13:06:09");
INSERT INTO categories VALUES("80","Pressure Cooker","","93","0","2023-12-11 17:05:42","2024-01-10 13:06:09");
INSERT INTO categories VALUES("81","Refrigerator","","92","0","2023-12-11 17:05:52","2023-12-14 18:04:11");
INSERT INTO categories VALUES("82","Rice Cooker","","93","0","2023-12-11 17:17:50","2024-01-10 13:06:09");
INSERT INTO categories VALUES("83","Sandwich Maker","","93","0","2023-12-11 17:18:13","2024-01-10 13:06:09");
INSERT INTO categories VALUES("84","Smart TV","","","0","2023-12-11 17:18:26","2023-12-14 17:49:05");
INSERT INTO categories VALUES("85","Washing Machine","","","0","2023-12-11 17:18:44","2023-12-14 18:03:22");
INSERT INTO categories VALUES("86","Water Bottle","","","0","2023-12-11 17:19:07","2023-12-14 17:50:36");
INSERT INTO categories VALUES("87","Water Filter","","95","0","2023-12-11 17:19:24","2024-01-10 13:07:10");
INSERT INTO categories VALUES("88","Coffee Maker","","93","0","2023-12-13 13:18:25","2024-01-10 12:32:21");
INSERT INTO categories VALUES("89","Electric Juicer","","92","0","2023-12-13 13:18:25","2024-01-10 13:04:57");
INSERT INTO categories VALUES("90","Meat Chopper","","93","0","2023-12-13 13:18:25","2024-01-10 13:04:58");
INSERT INTO categories VALUES("91","Water Bottle","","95","0","2023-12-13 13:18:25","2024-01-10 13:07:10");
INSERT INTO categories VALUES("92","Home Appliance","","32","0","2023-12-14 12:03:51","2024-01-10 13:04:57");
INSERT INTO categories VALUES("93","Kitchen Appliance","","32","0","2023-12-14 12:05:46","2024-01-10 13:04:57");
INSERT INTO categories VALUES("94","Multi-Purpose Appliances","","32","0","2023-12-14 12:06:03","2023-12-14 12:14:47");
INSERT INTO categories VALUES("95","Multi Purpose","","32","0","2023-12-14 12:15:54","2024-01-10 13:06:09");
INSERT INTO categories VALUES("96","Air-conditioners","","","0","2023-12-14 12:35:20","2023-12-14 12:48:18");
INSERT INTO categories VALUES("97","Used Laptop","","","0","2023-12-14 12:35:32","2024-01-10 13:07:10");
INSERT INTO categories VALUES("98","Smart TV","","51","0","2023-12-14 12:35:51","2024-01-10 12:30:50");
INSERT INTO categories VALUES("99","Blenders","","","0","2023-12-14 12:48:35","2023-12-14 12:49:30");
INSERT INTO categories VALUES("100","Air Conditioner","","51","0","2023-12-14 12:49:46","2024-01-10 12:32:20");
INSERT INTO categories VALUES("101","Tablet","","51","0","2023-12-26 13:20:28","2024-01-10 13:07:10");
INSERT INTO categories VALUES("102","Office Equipment","","","0","2023-12-26 15:11:10","2024-01-10 12:31:21");
INSERT INTO categories VALUES("103","POS Printer","","102","0","2023-12-26 15:11:45","2024-01-10 13:06:09");
INSERT INTO categories VALUES("104","Bar Code Scanner","","102","0","2023-12-26 15:28:51","2024-01-10 12:32:21");
INSERT INTO categories VALUES("105","Bar Code Label Printer","","102","0","2023-12-26 15:30:30","2024-01-10 12:32:21");
INSERT INTO categories VALUES("106","POS Cash Drawer","","102","0","2023-12-26 15:36:26","2024-01-10 13:06:09");
INSERT INTO categories VALUES("107","TGM   ","","","0","2024-01-10 12:29:59","2024-01-10 13:07:10");
INSERT INTO categories VALUES("108","City AG-3B","","","0","2024-01-10 12:29:59","2024-01-10 12:32:21");
INSERT INTO categories VALUES("109","City-Uk30-26","","","0","2024-01-10 12:29:59","2024-01-10 12:32:21");
INSERT INTO categories VALUES("110","9 Volt","","","0","2024-01-10 12:29:59","2024-01-10 12:32:20");
INSERT INTO categories VALUES("111","mini keyboard","","","0","2024-01-10 12:29:59","2024-01-10 13:04:58");
INSERT INTO categories VALUES("112","AC adaptor","","","0","2024-01-10 12:29:59","2024-01-10 12:32:20");
INSERT INTO categories VALUES("113",".","","","0","2024-01-10 12:29:59","2024-01-10 12:32:20");
INSERT INTO categories VALUES("114","9V (AC Adapter)","","","0","2024-01-10 12:29:59","2024-01-10 12:32:20");
INSERT INTO categories VALUES("115","Multiple ac/dc","","","0","2024-01-10 12:29:59","2024-01-10 13:06:09");
INSERT INTO categories VALUES("116","Zoom","","","0","2024-01-10 12:29:59","2024-01-10 13:07:11");
INSERT INTO categories VALUES("117","S.T.I ","","","0","2024-01-10 12:29:59","2024-01-10 13:06:09");
INSERT INTO categories VALUES("118","Guitar Processor","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("119","Extra Tk","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("120","Indian  ","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("121","Normal","","","0","2024-01-10 12:30:00","2024-01-10 13:06:09");
INSERT INTO categories VALUES("122","Wooden","","","0","2024-01-10 12:30:00","2024-01-10 13:07:11");
INSERT INTO categories VALUES("123","Acoustic  Guitar","","","0","2024-01-10 12:30:00","2024-01-10 12:32:20");
INSERT INTO categories VALUES("124","mini","","","0","2024-01-10 12:30:00","2024-01-10 13:04:58");
INSERT INTO categories VALUES("125","city_normal","","","0","2024-01-10 12:30:00","2024-01-10 12:32:21");
INSERT INTO categories VALUES("126","SBH","","","0","2024-01-10 12:30:00","2024-01-10 13:06:10");
INSERT INTO categories VALUES("127","Keyboard","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("128","Acoustic","","","0","2024-01-10 12:30:00","2024-01-10 12:32:20");
INSERT INTO categories VALUES("129","Acoustic Hard Box","","","0","2024-01-10 12:30:00","2024-01-10 12:32:20");
INSERT INTO categories VALUES("130","FINKS Box Soft city","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("131","Soft Case","","","0","2024-01-10 12:30:00","2024-01-10 13:06:19");
INSERT INTO categories VALUES("132","Elc Led","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("133","Acoustic Guitar","","","0","2024-01-10 12:30:00","2024-01-10 12:32:20");
INSERT INTO categories VALUES("134","Cajon Bag","","","0","2024-01-10 12:30:00","2024-01-10 12:32:21");
INSERT INTO categories VALUES("135","GIG BAG","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("136","Guitar_lele","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("137","Harmonium","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("138","led  bag","","","0","2024-01-10 12:30:00","2024-01-10 13:04:58");
INSERT INTO categories VALUES("139","Mandolin","","","0","2024-01-10 12:30:00","2024-01-10 13:04:58");
INSERT INTO categories VALUES("140","Tabla Baya","","","0","2024-01-10 12:30:00","2024-01-10 13:07:10");
INSERT INTO categories VALUES("141","Travel Bag","","","0","2024-01-10 12:30:00","2024-01-10 13:07:10");
INSERT INTO categories VALUES("142","Ukulele","","","0","2024-01-10 12:30:00","2024-01-10 13:07:10");
INSERT INTO categories VALUES("143","Drum stick","","","0","2024-01-10 12:30:00","2024-01-10 13:04:56");
INSERT INTO categories VALUES("144","Elc. Bass","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("145","Elc. lead","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("146","Flute","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("147","Leather","","","0","2024-01-10 12:30:00","2024-01-10 13:04:58");
INSERT INTO categories VALUES("148","Processor Hard case","","","0","2024-01-10 12:30:00","2024-01-10 13:06:09");
INSERT INTO categories VALUES("149","Ukulele 6 String","","","0","2024-01-10 12:30:00","2024-01-10 13:07:10");
INSERT INTO categories VALUES("150","Violin","","","0","2024-01-10 12:30:00","2024-01-10 13:07:10");
INSERT INTO categories VALUES("151","GUITAS","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("152","Electro Acostic","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("153","Lithium 3V","","","0","2024-01-10 12:30:00","2024-01-10 13:04:58");
INSERT INTO categories VALUES("154","60 Volt","","","0","2024-01-10 12:30:00","2024-01-10 12:32:20");
INSERT INTO categories VALUES("155","AA 1.5V","","","0","2024-01-10 12:30:00","2024-01-10 12:32:20");
INSERT INTO categories VALUES("156","Lithium 3V CR2025","","","0","2024-01-10 12:30:00","2024-01-10 13:04:58");
INSERT INTO categories VALUES("157","AAA","","","0","2024-01-10 12:30:00","2024-01-10 12:32:20");
INSERT INTO categories VALUES("158","Dance Learning","","","0","2024-01-10 12:30:00","2024-01-10 13:04:56");
INSERT INTO categories VALUES("159","learning","","","0","2024-01-10 12:30:00","2024-01-10 13:04:58");
INSERT INTO categories VALUES("160","Ashok Kumar paul","","","0","2024-01-10 12:30:00","2024-01-10 12:32:20");
INSERT INTO categories VALUES("161","Band Music ","","","0","2024-01-10 12:30:00","2024-01-10 12:32:21");
INSERT INTO categories VALUES("162","Lalon","","","0","2024-01-10 12:30:00","2024-01-10 13:04:58");
INSERT INTO categories VALUES("163","Manna de","","","0","2024-01-10 12:30:00","2024-01-10 13:04:58");
INSERT INTO categories VALUES("164","Music Learning","","","0","2024-01-10 12:30:00","2024-01-10 13:06:09");
INSERT INTO categories VALUES("165","Nazrul","","","0","2024-01-10 12:30:00","2024-01-10 13:06:09");
INSERT INTO categories VALUES("166","Rabindra Nath","","","0","2024-01-10 12:30:00","2024-01-10 13:06:09");
INSERT INTO categories VALUES("167","Song Lerning","","","0","2024-01-10 12:30:00","2024-01-10 13:07:10");
INSERT INTO categories VALUES("168","Touhidul alam sonet","","","0","2024-01-10 12:30:00","2024-01-10 13:07:10");
INSERT INTO categories VALUES("169","Kichu _Dure_ Nodi","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("170","Literature","","","0","2024-01-10 12:30:00","2024-01-10 13:04:58");
INSERT INTO categories VALUES("171","Musical Books","","","0","2024-01-10 12:30:00","2024-01-10 13:06:09");
INSERT INTO categories VALUES("172","Audio Auxilary","","","0","2024-01-10 12:30:00","2024-01-10 12:32:20");
INSERT INTO categories VALUES("173","Guitar","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("174","Microphone","","","0","2024-01-10 12:30:00","2024-01-10 13:04:58");
INSERT INTO categories VALUES("175","Jack Cable Loose","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("176","Normal With Jack","","","0","2024-01-10 12:30:00","2024-01-10 13:06:09");
INSERT INTO categories VALUES("177","XLR custome made","","","0","2024-01-10 12:30:00","2024-01-10 13:07:11");
INSERT INTO categories VALUES("178","EQ","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("179","elc. acs","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("180","GB","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("181","Anisha","","","0","2024-01-10 12:30:00","2024-01-10 12:32:20");
INSERT INTO categories VALUES("182","with seat","","","0","2024-01-10 12:30:00","2024-01-10 13:07:11");
INSERT INTO categories VALUES("183","Adjustable","","","0","2024-01-10 12:30:00","2024-01-10 12:32:20");
INSERT INTO categories VALUES("184","Sargor","","","0","2024-01-10 12:30:00","2024-01-10 13:06:09");
INSERT INTO categories VALUES("185","CITY","","","0","2024-01-10 12:30:00","2024-01-10 12:32:21");
INSERT INTO categories VALUES("186","Special","","","0","2024-01-10 12:30:00","2024-01-10 13:07:10");
INSERT INTO categories VALUES("187","CC Camera","","","0","2024-01-10 12:30:00","2024-01-10 12:32:21");
INSERT INTO categories VALUES("188","Best Quality","","","0","2024-01-10 12:30:00","2024-01-10 12:32:21");
INSERT INTO categories VALUES("189","Album","","","0","2024-01-10 12:30:00","2024-01-10 12:32:20");
INSERT INTO categories VALUES("190","Chord","","","0","2024-01-10 12:30:00","2024-01-10 12:32:21");
INSERT INTO categories VALUES("191","Concert","","","0","2024-01-10 12:30:00","2024-01-10 13:01:46");
INSERT INTO categories VALUES("192","Abar Album","","","0","2024-01-10 12:30:00","2024-01-10 12:32:20");
INSERT INTO categories VALUES("193","Antivirus","","","0","2024-01-10 12:30:00","2024-01-10 12:32:20");
INSERT INTO categories VALUES("194","Nylon String","","","0","2024-01-10 12:30:00","2024-01-10 13:06:09");
INSERT INTO categories VALUES("195","Classical Nylon","","","0","2024-01-10 12:30:00","2024-01-10 12:32:21");
INSERT INTO categories VALUES("196","PA system","","","0","2024-01-10 12:30:00","2024-01-10 13:06:09");
INSERT INTO categories VALUES("197","Desktop","","","0","2024-01-10 12:30:00","2024-01-10 13:04:56");
INSERT INTO categories VALUES("198","USB 2 MIDI","","","0","2024-01-10 12:30:00","2024-01-10 13:07:10");
INSERT INTO categories VALUES("199","Guitar Mini","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("200","Guitar to Speaker","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("201","Head Phone","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("202","Medium","","","0","2024-01-10 12:30:00","2024-01-10 13:04:58");
INSERT INTO categories VALUES("203","Common","","","0","2024-01-10 12:30:00","2024-01-10 12:32:21");
INSERT INTO categories VALUES("204","Piano","","","0","2024-01-10 12:30:00","2024-01-10 13:06:09");
INSERT INTO categories VALUES("205","Good Quality","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("206","Good Quality_Fret","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("207","SET","","","0","2024-01-10 12:30:00","2024-01-10 13:06:10");
INSERT INTO categories VALUES("208","7 set","","","0","2024-01-10 12:30:00","2024-01-10 12:32:20");
INSERT INTO categories VALUES("209","School Drum","","","0","2024-01-10 12:30:00","2024-01-10 13:06:10");
INSERT INTO categories VALUES("210","With Gripper","","","0","2024-01-10 12:30:00","2024-01-10 13:07:11");
INSERT INTO categories VALUES("211","7A","","","0","2024-01-10 12:30:00","2024-01-10 12:32:20");
INSERT INTO categories VALUES("212","PAD STICK","","","0","2024-01-10 12:30:00","2024-01-10 13:06:09");
INSERT INTO categories VALUES("213","Both side","","","0","2024-01-10 12:30:00","2024-01-10 12:32:21");
INSERT INTO categories VALUES("214","Fiber ","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("215","5 A","","","0","2024-01-10 12:30:00","2024-01-10 12:32:20");
INSERT INTO categories VALUES("216","PLAY,BEAT- STI","","","0","2024-01-10 12:30:00","2024-01-10 13:06:09");
INSERT INTO categories VALUES("217","Premier England-STI","","","0","2024-01-10 12:30:00","2024-01-10 13:06:09");
INSERT INTO categories VALUES("218","AMERICAN HICKROY","","","0","2024-01-10 12:30:00","2024-01-10 12:32:20");
INSERT INTO categories VALUES("219","American Maple","","","0","2024-01-10 12:30:00","2024-01-10 12:32:20");
INSERT INTO categories VALUES("220","TXR","","","0","2024-01-10 12:30:00","2024-01-10 13:07:10");
INSERT INTO categories VALUES("221","Maple","","","0","2024-01-10 12:30:00","2024-01-10 13:04:58");
INSERT INTO categories VALUES("222","Brush","","","0","2024-01-10 12:30:00","2024-01-10 12:32:21");
INSERT INTO categories VALUES("223","Sunglass","","","0","2024-01-10 12:30:00","2024-01-10 13:07:10");
INSERT INTO categories VALUES("224","Mobile Phone","","","0","2024-01-10 12:30:00","2024-01-10 13:05:19");
INSERT INTO categories VALUES("225","Wired  ","","","0","2024-01-10 12:30:00","2024-01-10 13:07:10");
INSERT INTO categories VALUES("226","Bluetooth","","","0","2024-01-10 12:30:00","2024-01-10 12:32:21");
INSERT INTO categories VALUES("227","Wired Music Headset","","","0","2024-01-10 12:30:00","2024-01-10 13:07:10");
INSERT INTO categories VALUES("228","FishMan","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("229","4 Band","","","0","2024-01-10 12:30:00","2024-01-10 12:32:20");
INSERT INTO categories VALUES("230","5 Band","","","0","2024-01-10 12:30:00","2024-01-10 12:32:20");
INSERT INTO categories VALUES("231","C#_TUNE","","","0","2024-01-10 12:30:00","2024-01-10 12:32:21");
INSERT INTO categories VALUES("232","Steal Good Quality","","","0","2024-01-10 12:30:00","2024-01-10 13:07:10");
INSERT INTO categories VALUES("233","Wishtle","","","0","2024-01-10 12:30:00","2024-01-10 13:07:10");
INSERT INTO categories VALUES("234","Recorder","","","0","2024-01-10 12:30:00","2024-01-10 13:06:09");
INSERT INTO categories VALUES("235","Bamboo","","","0","2024-01-10 12:30:00","2024-01-10 12:32:21");
INSERT INTO categories VALUES("236","Bamboo Ar","","","0","2024-01-10 12:30:00","2024-01-10 12:32:21");
INSERT INTO categories VALUES("237","Bamboo Ar Pora","","","0","2024-01-10 12:30:00","2024-01-10 12:32:21");
INSERT INTO categories VALUES("238","Bamboo Good Quality ","","","0","2024-01-10 12:30:00","2024-01-10 12:32:21");
INSERT INTO categories VALUES("239","C_# TUNE","","","0","2024-01-10 12:30:00","2024-01-10 12:32:21");
INSERT INTO categories VALUES("240","C_8 TUNE","","","0","2024-01-10 12:30:00","2024-01-10 12:32:21");
INSERT INTO categories VALUES("241","Design","","","0","2024-01-10 12:30:00","2024-01-10 13:04:56");
INSERT INTO categories VALUES("242","Mukh   ","","","0","2024-01-10 12:30:00","2024-01-10 13:06:09");
INSERT INTO categories VALUES("243","Silver Flute bass","","","0","2024-01-10 12:30:00","2024-01-10 13:06:10");
INSERT INTO categories VALUES("244","Tuned Bamboo flute","","","0","2024-01-10 12:30:00","2024-01-10 13:07:10");
INSERT INTO categories VALUES("245","Bamboo Mohon","","","0","2024-01-10 12:30:00","2024-01-10 12:32:21");
INSERT INTO categories VALUES("246","Mukh Good Quality","","","0","2024-01-10 12:30:00","2024-01-10 13:06:09");
INSERT INTO categories VALUES("247","Silver ","","","0","2024-01-10 12:30:00","2024-01-10 13:06:10");
INSERT INTO categories VALUES("248","Translucent ","","","0","2024-01-10 12:30:00","2024-01-10 13:07:10");
INSERT INTO categories VALUES("249","Drums and Keyboard","","","0","2024-01-10 12:30:00","2024-01-10 13:04:56");
INSERT INTO categories VALUES("250","Fixed","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("251","Decoration","","","0","2024-01-10 12:30:00","2024-01-10 13:04:56");
INSERT INTO categories VALUES("252","Wrist Watch","","","0","2024-01-10 12:30:00","2024-01-10 13:07:11");
INSERT INTO categories VALUES("253","ABAN-Ukulele Center","","","0","2024-01-10 12:30:00","2024-01-10 12:32:20");
INSERT INTO categories VALUES("254","ABIBA","","","0","2024-01-10 12:30:00","2024-01-10 12:32:20");
INSERT INTO categories VALUES("255","Adam Smith","","","0","2024-01-10 12:30:00","2024-01-10 12:32:20");
INSERT INTO categories VALUES("256","Adam Smith_120","","","0","2024-01-10 12:30:00","2024-01-10 12:32:20");
INSERT INTO categories VALUES("257","Adam Smith_160","","","0","2024-01-10 12:30:00","2024-01-10 12:32:20");
INSERT INTO categories VALUES("258","adam Smith_570","","","0","2024-01-10 12:30:00","2024-01-10 12:32:20");
INSERT INTO categories VALUES("259","Albino","","","0","2024-01-10 12:30:00","2024-01-10 12:32:20");
INSERT INTO categories VALUES("260","Aria","","","0","2024-01-10 12:30:00","2024-01-10 12:32:20");
INSERT INTO categories VALUES("261","AS Melody_Travel","","","0","2024-01-10 12:30:00","2024-01-10 12:32:20");
INSERT INTO categories VALUES("262","Ashai","","","0","2024-01-10 12:30:00","2024-01-10 12:32:20");
INSERT INTO categories VALUES("263","AXE","","","0","2024-01-10 12:30:00","2024-01-10 12:32:20");
INSERT INTO categories VALUES("264","Bull Fighter","","","0","2024-01-10 12:30:00","2024-01-10 12:32:21");
INSERT INTO categories VALUES("265","Caeser _City","","","0","2024-01-10 12:30:00","2024-01-10 12:32:21");
INSERT INTO categories VALUES("266","Caeser Anisha","","","0","2024-01-10 12:30:00","2024-01-10 12:32:21");
INSERT INTO categories VALUES("267","Caravan Music","","","0","2024-01-10 12:30:00","2024-01-10 12:32:21");
INSERT INTO categories VALUES("268","Caraya_Anisha","","","0","2024-01-10 12:30:00","2024-01-10 12:32:21");
INSERT INTO categories VALUES("269","CHAD_CITY_TRAVEL","","","0","2024-01-10 12:30:00","2024-01-10 12:32:21");
INSERT INTO categories VALUES("270","Chard","","","0","2024-01-10 12:30:00","2024-01-10 12:32:21");
INSERT INTO categories VALUES("271","Classical Guitar","","","0","2024-01-10 12:30:00","2024-01-10 12:32:21");
INSERT INTO categories VALUES("272","CMC","","","0","2024-01-10 12:30:00","2024-01-10 12:32:21");
INSERT INTO categories VALUES("273","Crafter","","","0","2024-01-10 12:30:00","2024-01-10 13:03:23");
INSERT INTO categories VALUES("274","Custom","","","0","2024-01-10 12:30:00","2024-01-10 13:04:56");
INSERT INTO categories VALUES("275","Dadarwood","","","0","2024-01-10 12:30:00","2024-01-10 13:04:56");
INSERT INTO categories VALUES("276","Deviser","","","0","2024-01-10 12:30:00","2024-01-10 13:04:56");
INSERT INTO categories VALUES("277","Deviser L 620 JSM","","","0","2024-01-10 12:30:00","2024-01-10 13:04:56");
INSERT INTO categories VALUES("278","DO ","","","0","2024-01-10 12:30:00","2024-01-10 13:04:56");
INSERT INTO categories VALUES("279","Doris","","","0","2024-01-10 12:30:00","2024-01-10 13:04:56");
INSERT INTO categories VALUES("280","DOTCH","","","0","2024-01-10 12:30:00","2024-01-10 13:04:56");
INSERT INTO categories VALUES("281","Dream Catcher","","","0","2024-01-10 12:30:00","2024-01-10 13:04:56");
INSERT INTO categories VALUES("282","Dream Maker","","","0","2024-01-10 12:30:00","2024-01-10 13:04:56");
INSERT INTO categories VALUES("283","Epiphone","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("284","Fender","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("285","Fiberovasion","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("286","Finks","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("287","Finks_city_fk 423","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("288","Finks_fk423_city","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("289","FINLAY","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("290","Firefly_Anisha","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("291","Five","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("292","Flamango","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("293","Floda","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("294","Gavial","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("295","Givson","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("296","Glashutte","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("297","Golden","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("298","Grace","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("299","Greag","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("300","Guiliani GAG","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("301","Gusion","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("302","Horn Grind","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("303","Ibanez","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("304","Italia","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("305","JA 4040 TBS","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("306","Jack Daniels","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("307","Joker","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("308","Joy","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("309","KAXIDIA","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("310","KEYSEN","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("311","KImmy","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("312","Kramer","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("313","Kulun ","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("314","LAG_CITY","","","0","2024-01-10 12:30:00","2024-01-10 13:04:58");
INSERT INTO categories VALUES("315","Listen","","","0","2024-01-10 12:30:00","2024-01-10 13:04:58");
INSERT INTO categories VALUES("316","Local Normal","","","0","2024-01-10 12:30:00","2024-01-10 13:04:58");
INSERT INTO categories VALUES("317","Luna","","","0","2024-01-10 12:30:00","2024-01-10 13:04:58");
INSERT INTO categories VALUES("318","Mantek_City","","","0","2024-01-10 12:30:00","2024-01-10 13:04:58");
INSERT INTO categories VALUES("319","Mataulun","","","0","2024-01-10 12:30:00","2024-01-10 13:04:58");
INSERT INTO categories VALUES("320","mentreel","","","0","2024-01-10 12:30:00","2024-01-10 13:04:58");
INSERT INTO categories VALUES("321","MVERIK_CITY","","","0","2024-01-10 12:30:00","2024-01-10 13:06:09");
INSERT INTO categories VALUES("322","Palmer","","","0","2024-01-10 12:30:00","2024-01-10 13:06:09");
INSERT INTO categories VALUES("323","QTE","","","0","2024-01-10 12:30:00","2024-01-10 13:06:09");
INSERT INTO categories VALUES("324","RC Stromm","","","0","2024-01-10 12:30:00","2024-01-10 13:06:09");
INSERT INTO categories VALUES("325","Rockjam","","","0","2024-01-10 12:30:00","2024-01-10 13:06:09");
INSERT INTO categories VALUES("326","ROCKSTAR","","","0","2024-01-10 12:30:00","2024-01-10 13:06:09");
INSERT INTO categories VALUES("327","Ruison_Anisha","","","0","2024-01-10 12:30:00","2024-01-10 13:06:09");
INSERT INTO categories VALUES("328","Saijer","","","0","2024-01-10 12:30:00","2024-01-10 13:06:09");
INSERT INTO categories VALUES("329","Sandy","","","0","2024-01-10 12:30:00","2024-01-10 13:06:09");
INSERT INTO categories VALUES("330","Sayt","","","0","2024-01-10 12:30:00","2024-01-10 13:06:09");
INSERT INTO categories VALUES("331","Seiger","","","0","2024-01-10 12:30:00","2024-01-10 13:06:10");
INSERT INTO categories VALUES("332","Silvertone","","","0","2024-01-10 12:30:00","2024-01-10 13:06:10");
INSERT INTO categories VALUES("333","Sonata","","","0","2024-01-10 12:30:00","2024-01-10 13:07:10");
INSERT INTO categories VALUES("334","SQOE ","","","0","2024-01-10 12:30:00","2024-01-10 13:07:10");
INSERT INTO categories VALUES("335","SQOE City","","","0","2024-01-10 12:30:00","2024-01-10 13:07:10");
INSERT INTO categories VALUES("336","SQOE OCTAVE","","","0","2024-01-10 12:30:00","2024-01-10 13:07:10");
INSERT INTO categories VALUES("337","SQOE-SQ-J","","","0","2024-01-10 12:30:00","2024-01-10 13:07:10");
INSERT INTO categories VALUES("338","Square","","","0","2024-01-10 12:30:00","2024-01-10 13:07:10");
INSERT INTO categories VALUES("339","Sunrise","","","0","2024-01-10 12:30:00","2024-01-10 13:07:10");
INSERT INTO categories VALUES("340","SX","","","0","2024-01-10 12:30:00","2024-01-10 13:07:10");
INSERT INTO categories VALUES("341","TAGIMA","","","0","2024-01-10 12:30:00","2024-01-10 13:07:10");
INSERT INTO categories VALUES("342","Takamyne","","","0","2024-01-10 12:30:00","2024-01-10 13:07:10");
INSERT INTO categories VALUES("343","TAKLA- Anisha","","","0","2024-01-10 12:30:00","2024-01-10 13:07:10");
INSERT INTO categories VALUES("344","TAKLA-Black Mat-Anisha","","","0","2024-01-10 12:30:00","2024-01-10 13:07:10");
INSERT INTO categories VALUES("345","Tanglewood","","","0","2024-01-10 12:30:00","2024-01-10 13:07:10");
INSERT INTO categories VALUES("346","Tayste","","","0","2024-01-10 12:30:00","2024-01-10 13:07:10");
INSERT INTO categories VALUES("347","URO","","","0","2024-01-10 12:30:00","2024-01-10 13:07:10");
INSERT INTO categories VALUES("348","Valencia","","","0","2024-01-10 12:30:00","2024-01-10 13:07:10");
INSERT INTO categories VALUES("349","Vivid","","","0","2024-01-10 12:30:00","2024-01-10 13:07:10");
INSERT INTO categories VALUES("350","Washbun","","","0","2024-01-10 12:30:00","2024-01-10 13:07:10");
INSERT INTO categories VALUES("351","X-WOOD","","","0","2024-01-10 12:30:00","2024-01-10 13:07:11");
INSERT INTO categories VALUES("352","Yamaha","","","0","2024-01-10 12:30:00","2024-01-10 13:07:11");
INSERT INTO categories VALUES("353","Yemaha","","","0","2024-01-10 12:30:00","2024-01-10 13:07:11");
INSERT INTO categories VALUES("354","Zealux","","","0","2024-01-10 12:30:00","2024-01-10 13:07:11");
INSERT INTO categories VALUES("355","Zuodanny","","","0","2024-01-10 12:30:00","2024-01-10 13:07:11");
INSERT INTO categories VALUES("356","Enya","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("357","Ukulele center","","","0","2024-01-10 12:30:00","2024-01-10 13:07:10");
INSERT INTO categories VALUES("358","Godson","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("359","Jielisi","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("360","Novelty","","","0","2024-01-10 12:30:00","2024-01-10 13:06:09");
INSERT INTO categories VALUES("361","GRAPE","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("362","Nihil ","","","0","2024-01-10 12:30:00","2024-01-10 13:06:09");
INSERT INTO categories VALUES("363","Texas ","","","0","2024-01-10 12:30:00","2024-01-10 13:07:10");
INSERT INTO categories VALUES("364","Elc. Bass 4 string","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("365","jsm  L 620","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("366","Electro Acostic EQ","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("367","Travel Guitar","","","0","2024-01-10 12:30:00","2024-01-10 13:07:10");
INSERT INTO categories VALUES("368","Ashbury","","","0","2024-01-10 12:30:00","2024-01-10 12:32:20");
INSERT INTO categories VALUES("369","Ashton","","","0","2024-01-10 12:30:00","2024-01-10 12:32:20");
INSERT INTO categories VALUES("370","Azalea","","","0","2024-01-10 12:30:00","2024-01-10 12:32:20");
INSERT INTO categories VALUES("371","B.C Rich","","","0","2024-01-10 12:30:00","2024-01-10 12:32:21");
INSERT INTO categories VALUES("372","Fernandez","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("373","Gibson","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("374","GUSON-","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("375","Ibanez GRG 170 DXB","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("376","Ibanez Semi Floyed","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("377","Ibenez","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("378","Jackson JS 12 Dinky","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("379","JSM","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("380","LTD","","","0","2024-01-10 12:30:00","2024-01-10 13:04:58");
INSERT INTO categories VALUES("381","SEIB 760-NA JSM","","","0","2024-01-10 12:30:00","2024-01-10 13:06:10");
INSERT INTO categories VALUES("382","SQOE-SEIB 760-NA JSM","","","0","2024-01-10 12:30:00","2024-01-10 13:07:10");
INSERT INTO categories VALUES("383","SQOE-SQ-Jsm","","","0","2024-01-10 12:30:00","2024-01-10 13:07:10");
INSERT INTO categories VALUES("384","Acoustic__RNG","","","0","2024-01-10 12:30:00","2024-01-10 12:32:20");
INSERT INTO categories VALUES("385","Alonso","","","0","2024-01-10 12:30:00","2024-01-10 12:32:20");
INSERT INTO categories VALUES("386","AS Melody","","","0","2024-01-10 12:30:00","2024-01-10 12:32:20");
INSERT INTO categories VALUES("387","Astone_AMC","","","0","2024-01-10 12:30:00","2024-01-10 12:32:20");
INSERT INTO categories VALUES("388","AXE-Anisha-EQ","","","0","2024-01-10 12:30:00","2024-01-10 12:32:20");
INSERT INTO categories VALUES("389","Daisy Rock","","","0","2024-01-10 12:30:00","2024-01-10 13:04:56");
INSERT INTO categories VALUES("390","Econ","","","0","2024-01-10 12:30:00","2024-01-10 13:04:56");
INSERT INTO categories VALUES("391","Flamango_City","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("392","Flora","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("393","Givson_AMC","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("394","Hobner","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("395","KAXIDIA_EQ","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("396","Mantek_City_EQ","","","0","2024-01-10 12:30:00","2024-01-10 13:04:58");
INSERT INTO categories VALUES("397","Occan","","","0","2024-01-10 12:30:00","2024-01-10 13:06:09");
INSERT INTO categories VALUES("398","Pleasure","","","0","2024-01-10 12:30:00","2024-01-10 13:06:09");
INSERT INTO categories VALUES("399","Puretone","","","0","2024-01-10 12:30:00","2024-01-10 13:06:09");
INSERT INTO categories VALUES("400","Signature","","","0","2024-01-10 12:30:00","2024-01-10 13:06:10");
INSERT INTO categories VALUES("401","Signature_AMC","","","0","2024-01-10 12:30:00","2024-01-10 13:06:10");
INSERT INTO categories VALUES("402","Suymphoni","","","0","2024-01-10 12:30:00","2024-01-10 13:07:10");
INSERT INTO categories VALUES("403","TAKLA-EQ- Anisha","","","0","2024-01-10 12:30:00","2024-01-10 13:07:10");
INSERT INTO categories VALUES("404","TGM- Anisha","","","0","2024-01-10 12:30:00","2024-01-10 13:07:10");
INSERT INTO categories VALUES("405","Vinik","","","0","2024-01-10 12:30:00","2024-01-10 13:07:10");
INSERT INTO categories VALUES("406","Winner","","","0","2024-01-10 12:30:00","2024-01-10 13:07:10");
INSERT INTO categories VALUES("407","X-MEN","","","0","2024-01-10 12:30:00","2024-01-10 13:07:11");
INSERT INTO categories VALUES("408","Electric Guitar Package ","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("409","FENDER-City-Mat","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("410","Baby Guitar-City","","","0","2024-01-10 12:30:00","2024-01-10 12:32:21");
INSERT INTO categories VALUES("411","Electric","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("412","IBANEZ-city-Mat","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("413","MDY","","","0","2024-01-10 12:30:00","2024-01-10 13:04:58");
INSERT INTO categories VALUES("414","Baby Guitar","","","0","2024-01-10 12:30:00","2024-01-10 12:32:21");
INSERT INTO categories VALUES("415","Electro Acostic.","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("416","Acoustic-jsm","","","0","2024-01-10 12:30:00","2024-01-10 12:32:20");
INSERT INTO categories VALUES("417","TGM-Ukulele Center","","","0","2024-01-10 12:30:00","2024-01-10 13:07:10");
INSERT INTO categories VALUES("418","Acoustic-City","","","0","2024-01-10 12:30:00","2024-01-10 12:32:20");
INSERT INTO categories VALUES("419","10 WAT","","","0","2024-01-10 12:30:00","2024-01-10 12:32:20");
INSERT INTO categories VALUES("420","22 Watt","","","0","2024-01-10 12:30:00","2024-01-10 12:32:20");
INSERT INTO categories VALUES("421","52 watt","","","0","2024-01-10 12:30:00","2024-01-10 12:32:20");
INSERT INTO categories VALUES("422","Bass Amp-MARTINA 8","","","0","2024-01-10 12:30:00","2024-01-10 12:32:21");
INSERT INTO categories VALUES("423","Bass_Amp 10 watt","","","0","2024-01-10 12:30:00","2024-01-10 12:32:21");
INSERT INTO categories VALUES("424","7 WATT","","","0","2024-01-10 12:30:00","2024-01-10 12:32:20");
INSERT INTO categories VALUES("425","25 WAT","","","0","2024-01-10 12:30:00","2024-01-10 12:32:20");
INSERT INTO categories VALUES("426","GT-20-UK Center","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("427","GT-40 Uk Center","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("428","12 Watt","","","0","2024-01-10 12:30:00","2024-01-10 12:32:20");
INSERT INTO categories VALUES("429","3 Watt","","","0","2024-01-10 12:30:00","2024-01-10 12:32:20");
INSERT INTO categories VALUES("430","CRUSH-20","","","0","2024-01-10 12:30:00","2024-01-10 13:03:23");
INSERT INTO categories VALUES("431","CUBE_20","","","0","2024-01-10 12:30:00","2024-01-10 13:04:56");
INSERT INTO categories VALUES("432","CUBE_27","","","0","2024-01-10 12:30:00","2024-01-10 13:04:56");
INSERT INTO categories VALUES("433","C-15","","","0","2024-01-10 12:30:00","2024-01-10 12:32:21");
INSERT INTO categories VALUES("434","C-6","","","0","2024-01-10 12:30:00","2024-01-10 12:32:21");
INSERT INTO categories VALUES("435","CUBE 40M","","","0","2024-01-10 12:30:00","2024-01-10 13:04:56");
INSERT INTO categories VALUES("436","CUBE-29","","","0","2024-01-10 12:30:00","2024-01-10 13:04:56");
INSERT INTO categories VALUES("437","CUBE-80","","","0","2024-01-10 12:30:00","2024-01-10 13:04:56");
INSERT INTO categories VALUES("438","STI","","","0","2024-01-10 12:30:00","2024-01-10 13:07:10");
INSERT INTO categories VALUES("439","Acoustic Amp","","","0","2024-01-10 12:30:00","2024-01-10 12:32:20");
INSERT INTO categories VALUES("440","Bass Amp","","","0","2024-01-10 12:30:00","2024-01-10 12:32:21");
INSERT INTO categories VALUES("441","Lead Amp","","","0","2024-01-10 12:30:00","2024-01-10 13:04:58");
INSERT INTO categories VALUES("442","Pocked Amp","","","0","2024-01-10 12:30:00","2024-01-10 13:06:09");
INSERT INTO categories VALUES("443","Elc ","","","0","2024-01-10 12:30:00","2024-01-10 13:04:56");
INSERT INTO categories VALUES("444","Normal /Anisha","","","0","2024-01-10 12:30:00","2024-01-10 13:06:09");
INSERT INTO categories VALUES("445","GOOD","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("446","Coloured ","","","0","2024-01-10 12:30:00","2024-01-10 12:32:21");
INSERT INTO categories VALUES("447","Tucana","","","0","2024-01-10 12:30:00","2024-01-10 13:07:10");
INSERT INTO categories VALUES("448","Janani Music","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("449","Slim","","","0","2024-01-10 12:30:00","2024-01-10 13:06:10");
INSERT INTO categories VALUES("450","Wide","","","0","2024-01-10 12:30:00","2024-01-10 13:07:10");
INSERT INTO categories VALUES("451","melody","","","0","2024-01-10 12:30:00","2024-01-10 13:04:58");
INSERT INTO categories VALUES("452","Special_Chaina.","","","0","2024-01-10 12:30:00","2024-01-10 13:07:10");
INSERT INTO categories VALUES("453","Push","","","0","2024-01-10 12:30:00","2024-01-10 13:06:09");
INSERT INTO categories VALUES("454","10 Feet (Good Quality)","","","0","2024-01-10 12:30:00","2024-01-10 12:32:20");
INSERT INTO categories VALUES("455","3 mtr","","","0","2024-01-10 12:30:00","2024-01-10 12:32:20");
INSERT INTO categories VALUES("456","Vintage Voltage","","","0","2024-01-10 12:30:00","2024-01-10 13:07:10");
INSERT INTO categories VALUES("457","Vintage Voltage_10ft","","","0","2024-01-10 12:30:00","2024-01-10 13:07:10");
INSERT INTO categories VALUES("458","Vintage Voltage_20ft","","","0","2024-01-10 12:30:00","2024-01-10 13:07:10");
INSERT INTO categories VALUES("459","10 mtr","","","0","2024-01-10 12:30:00","2024-01-10 12:32:20");
INSERT INTO categories VALUES("460","PJ-28N-Z002","","","0","2024-01-10 12:30:00","2024-01-10 13:06:09");
INSERT INTO categories VALUES("461","Wireless Jack","","","0","2024-01-10 12:30:00","2024-01-10 13:07:10");
INSERT INTO categories VALUES("462","A007A","","","0","2024-01-10 12:30:00","2024-01-10 12:32:20");
INSERT INTO categories VALUES("463","A007D","","","0","2024-01-10 12:30:00","2024-01-10 12:32:20");
INSERT INTO categories VALUES("464","A007H/BR","","","0","2024-01-10 12:30:00","2024-01-10 12:32:20");
INSERT INTO categories VALUES("465","A007K","","","0","2024-01-10 12:30:00","2024-01-10 12:32:20");
INSERT INTO categories VALUES("466","Metal","","","0","2024-01-10 12:30:00","2024-01-10 13:04:58");
INSERT INTO categories VALUES("467","Plastic","","","0","2024-01-10 12:30:00","2024-01-10 13:06:09");
INSERT INTO categories VALUES("468","A/C Elelctric Guitar","","","0","2024-01-10 12:30:00","2024-01-10 12:32:20");
INSERT INTO categories VALUES("469","ED-03","","","0","2024-01-10 12:30:00","2024-01-10 13:04:56");
INSERT INTO categories VALUES("470","Capo+Tuner","","","0","2024-01-10 12:30:00","2024-01-10 12:32:21");
INSERT INTO categories VALUES("471","Anisha- Black","","","0","2024-01-10 12:30:00","2024-01-10 12:32:20");
INSERT INTO categories VALUES("472","Janani Music-Black","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("473","Metal_RNG","","","0","2024-01-10 12:30:00","2024-01-10 13:04:58");
INSERT INTO categories VALUES("474","STI _BLACK","","","0","2024-01-10 12:30:00","2024-01-10 13:07:10");
INSERT INTO categories VALUES("475","Pick, Bottom & Bottom Puller","","","0","2024-01-10 12:30:00","2024-01-10 13:06:09");
INSERT INTO categories VALUES("476","Wall","","","0","2024-01-10 12:30:00","2024-01-10 13:07:10");
INSERT INTO categories VALUES("477","China","","","0","2024-01-10 12:30:00","2024-01-10 12:32:21");
INSERT INTO categories VALUES("478","Full Set","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("479","Guitar Shop","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("480","Black key","","","0","2024-01-10 12:30:00","2024-01-10 12:32:21");
INSERT INTO categories VALUES("481","Box set 6 pics","","","0","2024-01-10 12:30:00","2024-01-10 12:32:21");
INSERT INTO categories VALUES("482","Lossoe","","","0","2024-01-10 12:30:00","2024-01-10 13:04:58");
INSERT INTO categories VALUES("483","Round shape key","","","0","2024-01-10 12:30:00","2024-01-10 13:06:09");
INSERT INTO categories VALUES("484","TGM Set 6 pics","","","0","2024-01-10 12:30:00","2024-01-10 13:07:10");
INSERT INTO categories VALUES("485","Pickup With Jack","","","0","2024-01-10 12:30:00","2024-01-10 13:06:09");
INSERT INTO categories VALUES("486","Head Phone Amp","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("487","Big","","","0","2024-01-10 12:30:00","2024-01-10 12:32:21");
INSERT INTO categories VALUES("488","Small","","","0","2024-01-10 12:30:00","2024-01-10 13:06:10");
INSERT INTO categories VALUES("489","Body Polish","","","0","2024-01-10 12:30:00","2024-01-10 12:32:21");
INSERT INTO categories VALUES("490","PW-PL-03","","","0","2024-01-10 12:30:00","2024-01-10 13:06:09");
INSERT INTO categories VALUES("491","Fretboard","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("492","shine 60ml","","","0","2024-01-10 12:30:00","2024-01-10 13:06:10");
INSERT INTO categories VALUES("493","Lemon Oil","","","0","2024-01-10 12:30:00","2024-01-10 13:04:58");
INSERT INTO categories VALUES("494","shine 50ml","","","0","2024-01-10 12:30:00","2024-01-10 13:06:10");
INSERT INTO categories VALUES("495","String Care Kit","","","0","2024-01-10 12:30:00","2024-01-10 13:07:10");
INSERT INTO categories VALUES("496","Turbo Distortion","","","0","2024-01-10 12:30:00","2024-01-10 13:07:10");
INSERT INTO categories VALUES("497","STOMP BOX","","","0","2024-01-10 12:30:00","2024-01-10 13:07:10");
INSERT INTO categories VALUES("498","JOYO_","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("499","Crunch Distortion","","","0","2024-01-10 12:30:00","2024-01-10 13:03:23");
INSERT INTO categories VALUES("500","M-G-100","","","0","2024-01-10 12:30:00","2024-01-10 13:04:58");
INSERT INTO categories VALUES("501","G 1_Four","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("502","Electric Guitar   ","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("503","India","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("504","3 Guitar","","","0","2024-01-10 12:30:00","2024-01-10 12:32:20");
INSERT INTO categories VALUES("505","7 Guitar","","","0","2024-01-10 12:30:00","2024-01-10 12:32:20");
INSERT INTO categories VALUES("506","Nine Guitar","","","0","2024-01-10 12:30:00","2024-01-10 13:06:09");
INSERT INTO categories VALUES("507","Single","","","0","2024-01-10 12:30:00","2024-01-10 13:06:10");
INSERT INTO categories VALUES("508","Elc & Ac","","","0","2024-01-10 12:30:00","2024-01-10 13:04:56");
INSERT INTO categories VALUES("509","Triple ","","","0","2024-01-10 12:30:00","2024-01-10 13:07:10");
INSERT INTO categories VALUES("510","Fret Sticker","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("511","Deviser Colour","","","0","2024-01-10 12:30:00","2024-01-10 13:04:56");
INSERT INTO categories VALUES("512","Acoustic Color String","","","0","2024-01-10 12:30:00","2024-01-10 12:32:20");
INSERT INTO categories VALUES("513","Acoustic Loose","","","0","2024-01-10 12:30:00","2024-01-10 12:32:20");
INSERT INTO categories VALUES("514","Elc bass loose","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("515","Elc. Loose","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("516","Acoustic 12 String","","","0","2024-01-10 12:30:00","2024-01-10 12:32:20");
INSERT INTO categories VALUES("517","Hawaiian Guitar Acoustic","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("518","Hawaiian Guitar Electric","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("519"," Electric 5 String","","","0","2024-01-10 12:30:00","2024-01-10 12:32:20");
INSERT INTO categories VALUES("520","Elc. Bass 5 string","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("521","extra light","","","0","2024-01-10 12:30:00","2024-01-10 13:04:57");
INSERT INTO categories VALUES("522","AT-2","","","0","2024-01-10 12:30:00","2024-01-10 12:32:20");
INSERT INTO categories VALUES("523","Digital","","","0","2024-01-10 12:30:00","2024-01-10 13:04:56");
INSERT INTO categories VALUES("524","Digital cromatic","","","0","2024-01-10 12:30:00","2024-01-10 13:04:56");
INSERT INTO categories VALUES("525","Rechargable Touch","","","0","2024-01-10 12:30:01","2024-01-10 13:06:09");
INSERT INTO categories VALUES("526","Aktara","","","0","2024-01-10 12:30:01","2024-01-10 12:32:20");
INSERT INTO categories VALUES("527","Lamp","","","0","2024-01-10 12:30:01","2024-01-10 13:04:58");
INSERT INTO categories VALUES("528","Stereo Recording","","","0","2024-01-10 12:30:01","2024-01-10 13:07:10");
INSERT INTO categories VALUES("529","Single Scale","","","0","2024-01-10 12:30:01","2024-01-10 13:06:10");
INSERT INTO categories VALUES("530","Diatonic 16 Holes","","","0","2024-01-10 12:30:01","2024-01-10 13:04:56");
INSERT INTO categories VALUES("531","DM-10B","","","0","2024-01-10 12:30:01","2024-01-10 13:04:56");
INSERT INTO categories VALUES("532","DM-24B","","","0","2024-01-10 12:30:01","2024-01-10 13:04:56");
INSERT INTO categories VALUES("533","DM-24B-JSM","","","0","2024-01-10 12:30:01","2024-01-10 13:04:56");
INSERT INTO categories VALUES("534","DM-24B-S.T.I","","","0","2024-01-10 12:30:01","2024-01-10 13:04:56");
INSERT INTO categories VALUES("535","Chromatic-Forerunner","","","0","2024-01-10 12:30:01","2024-01-10 12:32:21");
INSERT INTO categories VALUES("536","Chromatic-MDY","","","0","2024-01-10 12:30:01","2024-01-10 12:32:21");
INSERT INTO categories VALUES("537","Single Scale C- 10 Holes","","","0","2024-01-10 12:30:01","2024-01-10 13:06:10");
INSERT INTO categories VALUES("538","Single Scale C-22 Holes","","","0","2024-01-10 12:30:01","2024-01-10 13:06:10");
INSERT INTO categories VALUES("539","10 HOLE","","","0","2024-01-10 12:30:01","2024-01-10 12:32:20");
INSERT INTO categories VALUES("540","24 hole","","","0","2024-01-10 12:30:01","2024-01-10 12:32:20");
INSERT INTO categories VALUES("541","Single Small","","","0","2024-01-10 12:30:01","2024-01-10 13:06:10");
INSERT INTO categories VALUES("542","Chromatic","","","0","2024-01-10 12:30:01","2024-01-10 12:32:21");
INSERT INTO categories VALUES("543","Diatonic 10 Hole","","","0","2024-01-10 12:30:01","2024-01-10 13:04:56");
INSERT INTO categories VALUES("544","Tremolo 24 H","","","0","2024-01-10 12:30:01","2024-01-10 13:07:10");
INSERT INTO categories VALUES("545","21 Hole","","","0","2024-01-10 12:30:01","2024-01-10 12:32:20");
INSERT INTO categories VALUES("546","Double Scale","","","0","2024-01-10 12:30:01","2024-01-10 13:04:56");
INSERT INTO categories VALUES("547","HH-001","","","0","2024-01-10 12:30:01","2024-01-10 13:04:57");
INSERT INTO categories VALUES("548","3 Octave","","","0","2024-01-10 12:30:01","2024-01-10 12:32:20");
INSERT INTO categories VALUES("549","3 Octave New","","","0","2024-01-10 12:30:01","2024-01-10 12:32:20");
INSERT INTO categories VALUES("550","German Key","","","0","2024-01-10 12:30:01","2024-01-10 13:04:57");
INSERT INTO categories VALUES("551","Platinum","","","0","2024-01-10 12:30:01","2024-01-10 13:06:09");
INSERT INTO categories VALUES("552","Scale Changer","","","0","2024-01-10 12:30:01","2024-01-10 13:06:10");
INSERT INTO categories VALUES("553","Studio ","","","0","2024-01-10 12:30:01","2024-01-10 13:07:10");
INSERT INTO categories VALUES("554","Gaming","","","0","2024-01-10 12:30:01","2024-01-10 13:04:57");
INSERT INTO categories VALUES("555","Stereo HeadPhone","","","0","2024-01-10 12:30:01","2024-01-10 13:07:10");
INSERT INTO categories VALUES("556","USB","","","0","2024-01-10 12:30:01","2024-01-10 13:07:10");
INSERT INTO categories VALUES("557","Stereo ","","","0","2024-01-10 12:30:01","2024-01-10 13:07:10");
INSERT INTO categories VALUES("558","Professional Monitor","","","0","2024-01-10 12:30:01","2024-01-10 13:06:09");
INSERT INTO categories VALUES("559","14 inch","","","0","2024-01-10 12:30:01","2024-01-10 12:32:20");
INSERT INTO categories VALUES("560","Mono Phone ","","","0","2024-01-10 12:30:01","2024-01-10 13:05:19");
INSERT INTO categories VALUES("561","Stereo Phone","","","0","2024-01-10 12:30:01","2024-01-10 13:07:10");
INSERT INTO categories VALUES("562","XLR Female","","","0","2024-01-10 12:30:01","2024-01-10 13:07:11");
INSERT INTO categories VALUES("563","XLR Male","","","0","2024-01-10 12:30:01","2024-01-10 13:07:11");
INSERT INTO categories VALUES("564","XLR MALE FEMALE","","","0","2024-01-10 12:30:01","2024-01-10 13:07:11");
INSERT INTO categories VALUES("565","Kahon Normal","","","0","2024-01-10 12:30:01","2024-01-10 13:04:57");
INSERT INTO categories VALUES("566","Kahon With Tuner","","","0","2024-01-10 12:30:01","2024-01-10 13:04:57");
INSERT INTO categories VALUES("567","Hand Kahon-Soor Sathi","","","0","2024-01-10 12:30:01","2024-01-10 13:04:57");
INSERT INTO categories VALUES("568","With Set-Soor sathi","","","0","2024-01-10 12:30:01","2024-01-10 13:07:11");
INSERT INTO categories VALUES("569","FLOOR_KAHON","","","0","2024-01-10 12:30:01","2024-01-10 13:04:57");
INSERT INTO categories VALUES("570","HAND_kAHON","","","0","2024-01-10 12:30:01","2024-01-10 13:04:57");
INSERT INTO categories VALUES("571","TRANSPARENT","","","0","2024-01-10 12:30:01","2024-01-10 13:07:10");
INSERT INTO categories VALUES("572","JSM Karaoke","","","0","2024-01-10 12:30:01","2024-01-10 13:04:57");
INSERT INTO categories VALUES("573","Mobile Portable Speaker","","","0","2024-01-10 12:30:01","2024-01-10 13:05:19");
INSERT INTO categories VALUES("574","Metal- Anisha","","","0","2024-01-10 12:30:01","2024-01-10 13:04:58");
INSERT INTO categories VALUES("575","X1 PLUSH-Anisha","","","0","2024-01-10 12:30:01","2024-01-10 13:07:11");
INSERT INTO categories VALUES("576","MIDI KEYBOARD","","","0","2024-01-10 12:30:01","2024-01-10 13:04:58");
INSERT INTO categories VALUES("577","standard Key","","","0","2024-01-10 12:30:01","2024-01-10 13:07:10");
INSERT INTO categories VALUES("578","Midi","","","0","2024-01-10 12:30:01","2024-01-10 13:04:58");
INSERT INTO categories VALUES("579","32 KEYS","","","0","2024-01-10 12:30:01","2024-01-10 12:32:20");
INSERT INTO categories VALUES("580","PA-49X","","","0","2024-01-10 12:30:01","2024-01-10 13:06:09");
INSERT INTO categories VALUES("581","PSR -E463-City","","","0","2024-01-10 12:30:01","2024-01-10 13:06:09");
INSERT INTO categories VALUES("582","PSR-E 473- MDY","","","0","2024-01-10 12:30:01","2024-01-10 13:06:09");
INSERT INTO categories VALUES("583","Yamaha-psr-463-Azad","","","0","2024-01-10 12:30:01","2024-01-10 13:07:11");
INSERT INTO categories VALUES("584","NoneBrand","","","0","2024-01-10 12:30:01","2024-01-10 13:06:09");
INSERT INTO categories VALUES("585","Double Tube X Senior-City","","","0","2024-01-10 12:30:01","2024-01-10 13:04:56");
INSERT INTO categories VALUES("586","Double Leg","","","0","2024-01-10 12:30:01","2024-01-10 13:04:56");
INSERT INTO categories VALUES("587","Flexi Stand","","","0","2024-01-10 12:30:01","2024-01-10 13:04:57");
INSERT INTO categories VALUES("588","wodden","","","0","2024-01-10 12:30:01","2024-01-10 13:07:11");
INSERT INTO categories VALUES("589","FOOT SWICH","","","0","2024-01-10 12:30:01","2024-01-10 13:04:57");
INSERT INTO categories VALUES("590","Selector Switch Knob","","","0","2024-01-10 12:30:01","2024-01-10 13:06:10");
INSERT INTO categories VALUES("591","LED USB","","","0","2024-01-10 12:30:01","2024-01-10 13:04:58");
INSERT INTO categories VALUES("592","PA- 520 JSM","","","0","2024-01-10 12:30:01","2024-01-10 13:06:09");
INSERT INTO categories VALUES("593","WD-517","","","0","2024-01-10 12:30:01","2024-01-10 13:07:10");
INSERT INTO categories VALUES("594","M&T","","","0","2024-01-10 12:30:01","2024-01-10 13:04:58");
INSERT INTO categories VALUES("595","AM03","","","0","2024-01-10 12:30:01","2024-01-10 12:32:20");
INSERT INTO categories VALUES("596","ESTD 1942","","","0","2024-01-10 12:30:01","2024-01-10 13:04:57");
INSERT INTO categories VALUES("597","chaina M221","","","0","2024-01-10 12:30:01","2024-01-10 12:32:21");
INSERT INTO categories VALUES("598","Dynamic","","","0","2024-01-10 12:30:01","2024-01-10 13:04:56");
INSERT INTO categories VALUES("599","Condensor","","","0","2024-01-10 12:30:01","2024-01-10 13:03:23");
INSERT INTO categories VALUES("600","Live Streamer MIC 133","","","0","2024-01-10 12:30:01","2024-01-10 13:04:58");
INSERT INTO categories VALUES("601","Clip-on","","","0","2024-01-10 12:30:01","2024-01-10 12:32:21");
INSERT INTO categories VALUES("602","Vocal ","","","0","2024-01-10 12:30:01","2024-01-10 13:07:10");
INSERT INTO categories VALUES("603","DJ Plus","","","0","2024-01-10 12:30:01","2024-01-10 13:04:56");
INSERT INTO categories VALUES("604","Studio Series","","","0","2024-01-10 12:30:01","2024-01-10 13:07:10");
INSERT INTO categories VALUES("605","Wireless System","","","0","2024-01-10 12:30:01","2024-01-10 13:07:10");
INSERT INTO categories VALUES("606","wireless mic","","","0","2024-01-10 12:30:01","2024-01-10 13:07:10");
INSERT INTO categories VALUES("607","Package","","","0","2024-01-10 12:30:01","2024-01-10 13:06:09");
INSERT INTO categories VALUES("608","Shock Mount","","","0","2024-01-10 12:30:01","2024-01-10 13:06:10");
INSERT INTO categories VALUES("609","Shure-Wireless","","","0","2024-01-10 12:30:01","2024-01-10 13:06:10");
INSERT INTO categories VALUES("610","Male and Female Jack","","","0","2024-01-10 12:30:01","2024-01-10 13:04:58");
INSERT INTO categories VALUES("611","Foam","","","0","2024-01-10 12:30:01","2024-01-10 13:04:57");
INSERT INTO categories VALUES("612","Live Voice MIC.STAND","","","0","2024-01-10 12:30:01","2024-01-10 13:04:58");
INSERT INTO categories VALUES("613","Hydrolic","","","0","2024-01-10 12:30:01","2024-01-10 13:04:57");
INSERT INTO categories VALUES("614","1 NO.","","","0","2024-01-10 12:30:01","2024-01-10 12:32:20");
INSERT INTO categories VALUES("615","2 NO.","","","0","2024-01-10 12:30:01","2024-01-10 12:32:20");
INSERT INTO categories VALUES("616","3 NO.","","","0","2024-01-10 12:30:01","2024-01-10 12:32:20");
INSERT INTO categories VALUES("617","Table Stand","","","0","2024-01-10 12:30:01","2024-01-10 13:07:10");
INSERT INTO categories VALUES("618","Labu","","","0","2024-01-10 12:30:01","2024-01-10 13:04:57");
INSERT INTO categories VALUES("619","Prostand_RNG","","","0","2024-01-10 12:30:01","2024-01-10 13:06:09");
INSERT INTO categories VALUES("620","pro microphone","","","0","2024-01-10 12:30:01","2024-01-10 13:06:09");
INSERT INTO categories VALUES("621","Midisport","","","0","2024-01-10 12:30:01","2024-01-10 13:04:58");
INSERT INTO categories VALUES("622","5 Pin","","","0","2024-01-10 12:30:01","2024-01-10 12:32:20");
INSERT INTO categories VALUES("623","MINI KALIMBA -UK CENTER","","","0","2024-01-10 12:30:01","2024-01-10 13:04:58");
INSERT INTO categories VALUES("624","4 Channel","","","0","2024-01-10 12:30:01","2024-01-10 12:32:20");
INSERT INTO categories VALUES("625","Stereo Echo","","","0","2024-01-10 12:30:01","2024-01-10 13:07:10");
INSERT INTO categories VALUES("626","Professional","","","0","2024-01-10 12:30:01","2024-01-10 13:06:09");
INSERT INTO categories VALUES("627","Portable","","","0","2024-01-10 12:30:01","2024-01-10 13:06:09");
INSERT INTO categories VALUES("628","Cloth","","","0","2024-01-10 12:30:01","2024-01-10 12:32:21");
INSERT INTO categories VALUES("629","Thread","","","0","2024-01-10 12:30:01","2024-01-10 13:07:10");
INSERT INTO categories VALUES("630","Pad 20 pro","","","0","2024-01-10 12:30:01","2024-01-10 13:06:09");
INSERT INTO categories VALUES("631","SPD-20X","","","0","2024-01-10 12:30:01","2024-01-10 13:07:10");
INSERT INTO categories VALUES("632","SPD Stand","","","0","2024-01-10 12:30:01","2024-01-10 13:07:10");
INSERT INTO categories VALUES("633","Octapad Stand-City","","","0","2024-01-10 12:30:01","2024-01-10 13:06:09");
INSERT INTO categories VALUES("634","novetion","","","0","2024-01-10 12:30:01","2024-01-10 13:06:09");
INSERT INTO categories VALUES("635","Double Paddle","","","0","2024-01-10 12:30:01","2024-01-10 13:04:56");
INSERT INTO categories VALUES("636","Hand Jhunjhuni big","","","0","2024-01-10 12:30:01","2024-01-10 13:04:57");
INSERT INTO categories VALUES("637","Hand Jhunjhuni Small","","","0","2024-01-10 12:30:01","2024-01-10 13:04:57");
INSERT INTO categories VALUES("638","Maraca","","","0","2024-01-10 12:30:01","2024-01-10 13:04:58");
INSERT INTO categories VALUES("639","Tamborine","","","0","2024-01-10 12:30:01","2024-01-10 13:07:10");
INSERT INTO categories VALUES("640","Finger Shaker","","","0","2024-01-10 12:30:01","2024-01-10 13:04:57");
INSERT INTO categories VALUES("641","Juri (Korotal)","","","0","2024-01-10 12:30:01","2024-01-10 13:04:57");
INSERT INTO categories VALUES("642","Mandira","","","0","2024-01-10 12:30:01","2024-01-10 13:04:58");
INSERT INTO categories VALUES("643","Prem Juri","","","0","2024-01-10 12:30:01","2024-01-10 13:06:09");
INSERT INTO categories VALUES("644","Baya","","","0","2024-01-10 12:30:01","2024-01-10 12:32:21");
INSERT INTO categories VALUES("645","Khomok","","","0","2024-01-10 12:30:01","2024-01-10 13:04:57");
INSERT INTO categories VALUES("646","Egg Small","","","0","2024-01-10 12:30:01","2024-01-10 13:04:56");
INSERT INTO categories VALUES("647","Soft Plastic","","","0","2024-01-10 12:30:01","2024-01-10 13:07:10");
INSERT INTO categories VALUES("648","Cabasa","","","0","2024-01-10 12:30:01","2024-01-10 12:32:21");
INSERT INTO categories VALUES("649","Pipe Shaker","","","0","2024-01-10 12:30:01","2024-01-10 13:06:09");
INSERT INTO categories VALUES("650","Premjuri (Krisno Kathi)","","","0","2024-01-10 12:30:01","2024-01-10 13:06:09");
INSERT INTO categories VALUES("651","Rain maker","","","0","2024-01-10 12:30:01","2024-01-10 13:06:09");
INSERT INTO categories VALUES("652","Sistro","","","0","2024-01-10 12:30:01","2024-01-10 13:06:10");
INSERT INTO categories VALUES("653","Wooden Hand Held","","","0","2024-01-10 12:30:01","2024-01-10 13:07:11");
INSERT INTO categories VALUES("654","Alice","","","0","2024-01-10 12:30:01","2024-01-10 12:32:20");
INSERT INTO categories VALUES("655","BLACK ","","","0","2024-01-10 12:30:01","2024-01-10 12:32:21");
INSERT INTO categories VALUES("656","G.Shop","","","0","2024-01-10 12:30:01","2024-01-10 13:04:57");
INSERT INTO categories VALUES("657","3D   ","","","0","2024-01-10 12:30:01","2024-01-10 12:32:20");
INSERT INTO categories VALUES("658","Base Pik","","","0","2024-01-10 12:30:01","2024-01-10 12:32:21");
INSERT INTO categories VALUES("659","Mini Box Pic","","","0","2024-01-10 12:30:01","2024-01-10 13:04:58");
INSERT INTO categories VALUES("660","Steal","","","0","2024-01-10 12:30:01","2024-01-10 13:07:10");
INSERT INTO categories VALUES("661","THUMB","","","0","2024-01-10 12:30:01","2024-01-10 13:07:10");
INSERT INTO categories VALUES("662","Alice- S.T.I","","","0","2024-01-10 12:30:01","2024-01-10 12:32:20");
INSERT INTO categories VALUES("663","Hawain Loose + steel","","","0","2024-01-10 12:30:01","2024-01-10 13:04:57");
INSERT INTO categories VALUES("664","Hawaiian Guitar","","","0","2024-01-10 12:30:01","2024-01-10 13:04:57");
INSERT INTO categories VALUES("665","Jazz","","","0","2024-01-10 12:30:01","2024-01-10 13:04:57");
INSERT INTO categories VALUES("666","Jim","","","0","2024-01-10 12:30:01","2024-01-10 13:04:57");
INSERT INTO categories VALUES("667","Joyo ","","","0","2024-01-10 12:30:01","2024-01-10 13:04:57");
INSERT INTO categories VALUES("668","Nylon pik","","","0","2024-01-10 12:30:01","2024-01-10 13:06:09");
INSERT INTO categories VALUES("669","Tortex","","","0","2024-01-10 12:30:01","2024-01-10 13:07:10");
INSERT INTO categories VALUES("670","H ","","","0","2024-01-10 12:30:01","2024-01-10 13:04:57");
INSERT INTO categories VALUES("671","Delrin ","","","0","2024-01-10 12:30:01","2024-01-10 13:04:56");
INSERT INTO categories VALUES("672","Original","","","0","2024-01-10 12:30:01","2024-01-10 13:06:09");
INSERT INTO categories VALUES("673","China loose","","","0","2024-01-10 12:30:01","2024-01-10 12:32:21");
INSERT INTO categories VALUES("674","Hawain Loose","","","0","2024-01-10 12:30:01","2024-01-10 13:04:57");
INSERT INTO categories VALUES("675","Indian loose","","","0","2024-01-10 12:30:01","2024-01-10 13:04:57");
INSERT INTO categories VALUES("676","Heavy ","","","0","2024-01-10 12:30:01","2024-01-10 13:04:57");
INSERT INTO categories VALUES("677","Hwaiian Guitar","","","0","2024-01-10 12:30:01","2024-01-10 13:04:57");
INSERT INTO categories VALUES("678","Shade","","","0","2024-01-10 12:30:01","2024-01-10 13:06:10");
INSERT INTO categories VALUES("679","speceal","","","0","2024-01-10 12:30:01","2024-01-10 13:07:10");
INSERT INTO categories VALUES("680","Microphone Filter","","","0","2024-01-10 12:30:01","2024-01-10 13:04:58");
INSERT INTO categories VALUES("681","Acoustic Filter","","","0","2024-01-10 12:30:01","2024-01-10 12:32:20");
INSERT INTO categories VALUES("682","PF-08","","","0","2024-01-10 12:30:01","2024-01-10 13:06:09");
INSERT INTO categories VALUES("683","Repairing","","","0","2024-01-10 12:30:01","2024-01-10 13:06:09");
INSERT INTO categories VALUES("684","Drum","","","0","2024-01-10 12:30:01","2024-01-10 13:04:56");
INSERT INTO categories VALUES("685","Acounting software","","","0","2024-01-10 12:30:01","2024-01-10 12:32:20");
INSERT INTO categories VALUES("686","Studio Package","","","0","2024-01-10 12:30:01","2024-01-10 13:07:10");
INSERT INTO categories VALUES("687","FireWire","","","0","2024-01-10 12:30:01","2024-01-10 13:04:57");
INSERT INTO categories VALUES("688","Saffire ","","","0","2024-01-10 12:30:01","2024-01-10 13:06:09");
INSERT INTO categories VALUES("689"," 3rd Gen","","","0","2024-01-10 12:30:01","2024-01-10 12:32:20");
INSERT INTO categories VALUES("690","2i2 3rd  generation","","","0","2024-01-10 12:30:01","2024-01-10 12:32:20");
INSERT INTO categories VALUES("691","M-Track   ","","","0","2024-01-10 12:30:01","2024-01-10 13:04:58");
INSERT INTO categories VALUES("692","M-Track  Duo","","","0","2024-01-10 12:30:01","2024-01-10 13:04:58");
INSERT INTO categories VALUES("693","M-Track Plus","","","0","2024-01-10 12:30:01","2024-01-10 13:04:58");
INSERT INTO categories VALUES("694","Studio 2","","","0","2024-01-10 12:30:01","2024-01-10 13:07:10");
INSERT INTO categories VALUES("695","2:01","","","0","2024-01-10 12:30:01","2024-01-10 12:32:20");
INSERT INTO categories VALUES("696","5:01","","","0","2024-01-10 12:30:01","2024-01-10 12:32:20");
INSERT INTO categories VALUES("697","Studio Monitor","","","0","2024-01-10 12:30:01","2024-01-10 13:07:10");
INSERT INTO categories VALUES("698","Ctnno-34","","","0","2024-01-10 12:30:01","2024-01-10 13:03:23");
INSERT INTO categories VALUES("699","Ctnno-40","","","0","2024-01-10 12:30:01","2024-01-10 13:03:23");
INSERT INTO categories VALUES("700","2 pcs","","","0","2024-01-10 12:30:01","2024-01-10 12:32:20");
INSERT INTO categories VALUES("701","USB 2pcs","","","0","2024-01-10 12:30:01","2024-01-10 13:07:10");
INSERT INTO categories VALUES("702","Monitor Speaker","","","0","2024-01-10 12:30:01","2024-01-10 13:05:19");
INSERT INTO categories VALUES("703","vk-558","","","0","2024-01-10 12:30:01","2024-01-10 13:07:10");
INSERT INTO categories VALUES("704","JHW-V361","","","0","2024-01-10 12:30:01","2024-01-10 13:04:57");
INSERT INTO categories VALUES("705","Home theater","","","0","2024-01-10 12:30:01","2024-01-10 13:04:57");
INSERT INTO categories VALUES("706","Tower Speaker","","","0","2024-01-10 12:30:01","2024-01-10 13:07:10");
INSERT INTO categories VALUES("707","ALICE _AW430","","","0","2024-01-10 12:30:01","2024-01-10 12:32:20");
INSERT INTO categories VALUES("708","Clour","","","0","2024-01-10 12:30:01","2024-01-10 12:32:21");
INSERT INTO categories VALUES("709","Sarengi","","","0","2024-01-10 12:30:01","2024-01-10 13:06:09");
INSERT INTO categories VALUES("710","Duel","","","0","2024-01-10 12:30:01","2024-01-10 13:04:56");
INSERT INTO categories VALUES("711","Combo","","","0","2024-01-10 12:30:01","2024-01-10 12:32:21");
INSERT INTO categories VALUES("712","Combo-Anisha","","","0","2024-01-10 12:30:01","2024-01-10 12:32:21");
INSERT INTO categories VALUES("713","All","","","0","2024-01-10 12:30:01","2024-01-10 12:32:20");
INSERT INTO categories VALUES("714","All Size","","","0","2024-01-10 12:30:01","2024-01-10 12:32:20");
INSERT INTO categories VALUES("715","M Size","","","0","2024-01-10 12:30:01","2024-01-10 13:04:58");
INSERT INTO categories VALUES("716","Electronic ","","","0","2024-01-10 12:30:01","2024-01-10 13:04:57");
INSERT INTO categories VALUES("717","MAESTRO_DX","","","0","2024-01-10 12:30:01","2024-01-10 13:04:58");
INSERT INTO categories VALUES("718","City-AG_3","","","0","2024-01-10 12:30:01","2024-01-10 12:32:21");
INSERT INTO categories VALUES("719","FAN ZONE","","","0","2024-01-10 12:30:01","2024-01-10 13:04:57");
INSERT INTO categories VALUES("720","Special Zone","","","0","2024-01-10 12:30:01","2024-01-10 13:07:10");
INSERT INTO categories VALUES("721","VIP ZONE","","","0","2024-01-10 12:30:01","2024-01-10 13:07:10");
INSERT INTO categories VALUES("722","LED  ","","","0","2024-01-10 12:30:01","2024-01-10 13:04:58");
INSERT INTO categories VALUES("723","24 Inch","","","0","2024-01-10 12:30:01","2024-01-10 12:32:20");
INSERT INTO categories VALUES("724","26 Inch","","","0","2024-01-10 12:30:01","2024-01-10 12:32:20");
INSERT INTO categories VALUES("725","with EQ","","","0","2024-01-10 12:30:01","2024-01-10 13:07:10");
INSERT INTO categories VALUES("726","AXE-Ukulele Center-24","","","0","2024-01-10 12:30:01","2024-01-10 12:32:20");
INSERT INTO categories VALUES("727","AXE-Ukulele Center-26 new","","","0","2024-01-10 12:30:01","2024-01-10 12:32:20");
INSERT INTO categories VALUES("728","Electro Acostic 26 Inch","","","0","2024-01-10 12:30:01","2024-01-10 13:04:57");
INSERT INTO categories VALUES("729","Cordoba 24","","","0","2024-01-10 12:30:01","2024-01-10 13:03:23");
INSERT INTO categories VALUES("730","Azad 24 Inch","","","0","2024-01-10 12:30:01","2024-01-10 12:32:20");
INSERT INTO categories VALUES("731","City-24 Inch","","","0","2024-01-10 12:30:01","2024-01-10 12:32:21");
INSERT INTO categories VALUES("732","City-26 Inch","","","0","2024-01-10 12:30:01","2024-01-10 12:32:21");
INSERT INTO categories VALUES("733","PA-U30","","","0","2024-01-10 12:30:01","2024-01-10 13:06:09");
INSERT INTO categories VALUES("734","Ovation","","","0","2024-01-10 12:30:01","2024-01-10 13:06:09");
INSERT INTO categories VALUES("735","Epiphone-Ukulele Center-26 new","","","0","2024-01-10 12:30:01","2024-01-10 13:04:57");
INSERT INTO categories VALUES("736","China_24 inch","","","0","2024-01-10 12:30:01","2024-01-10 12:32:21");
INSERT INTO categories VALUES("737","HOKE-Ukulele Center-26","","","0","2024-01-10 12:30:01","2024-01-10 13:04:57");
INSERT INTO categories VALUES("738","HOLA ! -Package-24","","","0","2024-01-10 12:30:01","2024-01-10 13:04:57");
INSERT INTO categories VALUES("739","Joker 24","","","0","2024-01-10 12:30:01","2024-01-10 13:04:57");
INSERT INTO categories VALUES("740","26 Inch-KYTH","","","0","2024-01-10 12:30:01","2024-01-10 12:32:20");
INSERT INTO categories VALUES("741","UK210-24","","","0","2024-01-10 12:30:01","2024-01-10 13:07:10");
INSERT INTO categories VALUES("742","MAHALO-Ukulele Center-24","","","0","2024-01-10 12:30:01","2024-01-10 13:04:58");
INSERT INTO categories VALUES("743","Mentreel-26 Inch","","","0","2024-01-10 12:30:01","2024-01-10 13:04:58");
INSERT INTO categories VALUES("744","21 Inch","","","0","2024-01-10 12:30:01","2024-01-10 12:32:20");
INSERT INTO categories VALUES("745","QTE 24","","","0","2024-01-10 12:30:01","2024-01-10 13:06:09");
INSERT INTO categories VALUES("746","Winfer","","","0","2024-01-10 12:30:01","2024-01-10 13:07:10");
INSERT INTO categories VALUES("747","XCC","","","0","2024-01-10 12:30:01","2024-01-10 13:07:11");
INSERT INTO categories VALUES("748","Costellation","","","0","2024-01-10 12:30:01","2024-01-10 13:03:23");
INSERT INTO categories VALUES("749","Garage band","","","0","2024-01-10 12:30:01","2024-01-10 13:04:57");
INSERT INTO categories VALUES("750","Tayste-Ukulele Center-26 new","","","0","2024-01-10 12:30:01","2024-01-10 13:07:10");
INSERT INTO categories VALUES("751","TGM-Ukulele Center-24","","","0","2024-01-10 12:30:01","2024-01-10 13:07:10");
INSERT INTO categories VALUES("752","TGM-Ukulele Center-26","","","0","2024-01-10 12:30:01","2024-01-10 13:07:10");
INSERT INTO categories VALUES("753","EQ_24","","","0","2024-01-10 12:30:01","2024-01-10 13:04:57");
INSERT INTO categories VALUES("754","YAHAMA-Ukulele Center-26 new","","","0","2024-01-10 12:30:01","2024-01-10 13:07:11");
INSERT INTO categories VALUES("755","labu_UK 24","","","0","2024-01-10 12:30:01","2024-01-10 13:04:57");
INSERT INTO categories VALUES("756","YAMAHA-Ukulele Center-24","","","0","2024-01-10 12:30:01","2024-01-10 13:07:11");
INSERT INTO categories VALUES("757","With Input","","","0","2024-01-10 12:30:01","2024-01-10 13:07:11");
INSERT INTO categories VALUES("758","Octave Guitar","","","0","2024-01-10 12:30:01","2024-01-10 13:06:09");
INSERT INTO categories VALUES("759","Rifat","","","0","2024-01-10 12:30:01","2024-01-10 13:06:09");
INSERT INTO categories VALUES("760","flat","","","0","2024-01-10 12:30:01","2024-01-10 13:04:57");
INSERT INTO categories VALUES("761","White Nylon","","","0","2024-01-10 12:30:01","2024-01-10 13:07:10");
INSERT INTO categories VALUES("762","nylgut","","","0","2024-01-10 12:30:01","2024-01-10 13:06:09");
INSERT INTO categories VALUES("763","NIHIL- White Nylon","","","0","2024-01-10 12:30:01","2024-01-10 13:06:09");
INSERT INTO categories VALUES("764","6 inc","","","0","2024-01-10 12:30:01","2024-01-10 12:32:20");
INSERT INTO categories VALUES("765","MAT","","","0","2024-01-10 12:30:01","2024-01-10 13:04:58");
INSERT INTO categories VALUES("766","Azad","","","0","2024-01-10 12:30:01","2024-01-10 12:32:20");
INSERT INTO categories VALUES("767","V_20","","","0","2024-01-10 12:30:02","2024-01-10 13:07:10");
INSERT INTO categories VALUES("768","Chaina","","","0","2024-01-10 12:30:02","2024-01-10 12:32:21");
INSERT INTO categories VALUES("769","Yeanling","","","0","2024-01-10 12:30:02","2024-01-10 13:07:11");
INSERT INTO categories VALUES("770","ME-044","","","0","2024-01-10 12:30:02","2024-01-10 13:04:58");
INSERT INTO categories VALUES("771","1","","","0","2024-01-10 12:30:02","2024-01-10 12:32:20");
INSERT INTO categories VALUES("772","2","","","0","2024-01-10 12:30:02","2024-01-10 12:32:20");
INSERT INTO categories VALUES("773","3","","","0","2024-01-10 12:30:02","2024-01-10 12:32:20");
INSERT INTO categories VALUES("774","4 no.","","","0","2024-01-10 12:30:02","2024-01-10 12:32:20");
INSERT INTO categories VALUES("775","3D Vr Box","","","0","2024-01-10 12:30:02","2024-01-10 12:32:20");
INSERT INTO categories VALUES("776","Acoustic","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("777","Adapter","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("778","Adjustment","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("779","Aktara","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("780","Aline Key","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("781","Amplifire","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("782","Bag","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("783","Banjo","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("784","Battery","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("785","Battery Cover","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("786","Books","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("787","Cable","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("788","Cajon","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("789","CC Camera","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("790","CD/DVD","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("791","Central Rack","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("792","classical guitar ","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("793","Classical guitar String","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("794","Commission Received","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("795","Computer","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("796","Converter","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("797","Cymbal","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("798","Decoration Eeuipment","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("799","Digital Piano","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("800","Discout Received","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("801","DOTARA","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("802","DOTARA STRING","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("803","Drum Skin","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("804","Drums Set","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("805","Drums Stick","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("806","Ear phone","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("807","Earphone","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("808","Equilizer","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("809","Esraj","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("810","Filter","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("811","Finger Protector","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("812","Flute","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("813","FOOT STAND","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("814","Foot Switch","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("815","Fret","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("816","FretWrap","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("817","Furniture","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("818","Gift","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("819","Guitar","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("820","Guitar Amplifier","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("821","Guitar Belt","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("822","Guitar Bottom","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("823","Guitar Cable","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("824","Guitar Capo","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("825","Guitar Combo","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("826","Guitar Hanger","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("827","Guitar key","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("828","Guitar Pickup","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("829","Guitar Plug","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("830","Guitar Polish","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("831","Guitar Processor","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("832","Guitar Rack ","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("833","Guitar Sadle","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("834","Guitar Slides","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("835","Guitar Stand","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("836","Guitar Sticker","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("837","Guitar String","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("838","Guitar Swarasoti","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("839","Guitar Tuner","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("840","Guitarlele","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("841","Handicraft","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("842","Handy Recorder","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("843","Harmonica   ","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("844","Harmonica Cover","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("845","Harmonica Holder","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("846","Harmonium","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("847","Hawaiian Guitar","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("848","Headphone","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("849","Hi-hat","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("850","HOODIE","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("851","Jack","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("852","Kahon","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("853","kahon/Cajon","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("854","KALIMBA","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("855","Karaoke","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("856","Kazoo","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("857","Keayboard","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("858","Keayboard Adupter","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("859","Keayboard Hard Case","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("860","Keayboard Stand","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("861","Keayboard_Hard case","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("862","Key Ring","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("863","KEYBOARD FOOT PADDLE","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("864","Khomok","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("865","Knob","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("866","Lamp","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("867","Link Cable","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("868","Locket","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("869","LYRIC STAND","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("870","Magazine","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("871","Melodica","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("872","Mendolin","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("873","Mendolin String","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("874","Microphone","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("875","Microphone Cable","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("876","Microphone Cover","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("877","Microphone Holder","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("878","Microphone Shock Mount","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("879","Microphone Stand","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("880","MIDI TO USB CABLE","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("881","MIDI_CABLE","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("882","MINI KALIMBA -UK CENTER","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("883","Mixer","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("884","Multi Plug","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("885","Music Light","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("886","Neckless","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("887","Nupur","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("888","Octapad","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("889","Octapad Stand","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("890","Office Equipment","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("891","Pad","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("892","Paddel","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("893","Pen","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("894","Pen Stand","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("895","Percussion","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("896","Pic Holder","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("897","Pick Guard","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("898","pickup","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("899","Pik","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("900","Pop Shield","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("901","Poster","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("902","Prem Juri","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("903","Previous Due ","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("904","Printer","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("905","Projecter","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("906","Service","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("907","Snare Chain","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("908","Snare Skin","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("909","Software","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("910","Sound Card","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("911","Sound Hole Block","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("912","Speaker","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("913","Strap Bottom","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("914","String   ","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("915","String Winder","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("916","Sustain pedal","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("917","T Shirt","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("918","Tabla","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("919","Tanpura ","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("920","Tanpura String","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("921","Termello","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("922","TGM","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("923","Ticket","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("924","touch picup","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("925","Tune Locker","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("926","Tuner","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("927","TV ","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("928","Ukulele","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("929","Ukulele Belt","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("930","Ukulele Capo","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("931","Ukulele Key","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("932","UKULELE STAND","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("933","Ukulele String","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("934","USB Charger","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("935","USB Fan","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("936","Varigrip Hand Exerciser","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("937","Violin","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("938","Violin Adjuster","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("939","Violin Bag","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("940","Violin Bow","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("941","Violin Bridge","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("942","Violin Chin Rest","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("943","Violin Key","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("944","Violin Muter","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("945","Violin Rozon","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");
INSERT INTO categories VALUES("946","Violin Shoulder Rest","","","1","2024-01-10 13:34:09","2024-01-10 13:34:09");



CREATE TABLE `coupons` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(191) NOT NULL,
  `type` varchar(191) NOT NULL,
  `amount` double NOT NULL,
  `minimum_amount` double DEFAULT NULL,
  `quantity` int(11) NOT NULL,
  `used` int(11) NOT NULL,
  `expired_date` date NOT NULL,
  `user_id` int(11) NOT NULL,
  `is_active` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO coupons VALUES("1","sonar bangla","percentage","20","0","100","4","2020-11-19","1","1","2018-10-25 18:38:50","2020-11-17 19:52:39");
INSERT INTO coupons VALUES("2","i love bangladesh","fixed","200","1000","50","1","2018-12-31","1","1","2018-10-26 22:59:26","2019-03-02 00:46:48");



CREATE TABLE `currencies` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `code` varchar(191) NOT NULL,
  `exchange_rate` double NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO currencies VALUES("1","US Dollar","USD","1","2020-10-31 20:22:58","2020-10-31 20:34:55");
INSERT INTO currencies VALUES("2","Euro","Euro","0.85","2020-10-31 21:29:12","2020-11-10 18:15:34");
INSERT INTO currencies VALUES("3","Taka","BDT","1","2021-10-06 12:24:50","2021-10-06 12:24:50");



CREATE TABLE `customer_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `percentage` varchar(191) NOT NULL,
  `is_active` tinyint(1) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO customer_groups VALUES("1","general","0","1","2018-05-12 04:09:36","2019-03-02 01:01:35");
INSERT INTO customer_groups VALUES("2","distributor","-10","1","2018-05-12 04:12:14","2019-03-02 01:02:12");
INSERT INTO customer_groups VALUES("3","reseller","5","1","2018-05-12 04:12:26","2018-05-29 21:18:14");
INSERT INTO customer_groups VALUES("4","test","12","0","2018-05-29 21:17:16","2018-05-29 21:17:57");
INSERT INTO customer_groups VALUES("5","test","0","0","2018-08-03 05:10:27","2018-08-03 05:10:34");
INSERT INTO customer_groups VALUES("6","Doctors","0","1","2023-07-27 01:38:23","2023-07-27 01:38:23");
INSERT INTO customer_groups VALUES("7","Bankers","0","1","2023-07-27 01:38:35","2023-07-27 01:38:35");
INSERT INTO customer_groups VALUES("8","Paikari","10","1","2023-07-27 01:39:05","2023-07-27 01:39:05");
INSERT INTO customer_groups VALUES("9","Walking Customer","000","1","2023-09-20 12:25:08","2023-09-20 12:25:08");



CREATE TABLE `customers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `customer_group_id` int(11) NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `name` varchar(191) NOT NULL,
  `company_name` varchar(191) DEFAULT NULL,
  `email` varchar(191) DEFAULT NULL,
  `phone_number` varchar(191) NOT NULL,
  `tax_no` varchar(191) DEFAULT NULL,
  `address` varchar(191) NOT NULL,
  `city` varchar(191) NOT NULL,
  `state` varchar(191) DEFAULT NULL,
  `postal_code` varchar(191) DEFAULT NULL,
  `country` varchar(191) DEFAULT NULL,
  `deposit` double DEFAULT NULL,
  `expense` double DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO customers VALUES("1","1","22","dhiman","lioncoders","dhiman@gmail.com","+8801111111101","","kajir deuri","chittagong","","","bd","190","20","0","2018-05-12 06:00:48","2023-09-20 13:32:59");
INSERT INTO customers VALUES("2","2","","moinul","lioncoders","","+8801200000001","","jamalkhan","chittagong","","","bd","100","20","1","2018-05-12 06:04:51","2019-02-22 00:38:08");
INSERT INTO customers VALUES("3","3","","tariq","big tree","","3424","","khulshi","chittagong","","","bd","","","1","2018-05-12 06:07:52","2019-03-02 00:54:07");
INSERT INTO customers VALUES("4","1","","test","","","4234","","frwerw","qwerwqr","","","","","","0","2018-05-29 21:35:28","2018-05-29 21:37:38");
INSERT INTO customers VALUES("8","1","","anwar","smart it","anwar@smartit.com","32321","","nasirabad","chittagong","","","bd","","","0","2018-08-31 23:26:13","2018-08-31 23:29:55");
INSERT INTO customers VALUES("11","1","","walk-in-customer","","","01923000001","11111","mohammadpur","dhaka","","","","","0","1","2018-09-01 21:30:54","2020-07-27 10:28:19");
INSERT INTO customers VALUES("15","1","","s","","","2","","s","3e","","","","","","0","2018-11-04 23:00:39","2018-11-07 22:37:08");
INSERT INTO customers VALUES("16","1","","asas","","","2121","","dasd","asdd","","","","","","0","2018-11-30 19:07:53","2018-12-03 16:55:46");
INSERT INTO customers VALUES("17","1","","sadman","","","312312","","khulshi","ctg","","","","","","0","2020-06-22 05:45:35","2020-06-22 05:45:51");
INSERT INTO customers VALUES("19","1","19","shakalaka","Digital image","shakalaka@gmail.com","1212","999","Andorkillah","Chittagong","Chittagong","1234","Bangladesh","","","0","2020-11-08 19:07:16","2023-09-20 13:32:59");
INSERT INTO customers VALUES("21","1","21","Modon Miya","modon company","modon@gmail.com","2222","","kuril road","Dhaka","","","","","","0","2020-11-13 02:12:11","2023-09-20 13:32:59");
INSERT INTO customers VALUES("25","1","28","Imran miya","","imran@gmail.com","01923000001","","kljkj","hhjhh","","","","","","0","2021-02-04 01:26:47","2021-02-04 01:26:47");
INSERT INTO customers VALUES("26","1","31","maruf","CASH & CARRY","shajed88@gmail.com","01879450074","","SHOP NO: G7, NUPUR MARKET. CHATTOGRAM.","chittagong","chittagong","","Bangladesh","","","1","2022-03-07 09:36:12","2022-03-07 09:36:12");
INSERT INTO customers VALUES("27","1","","saikat","","","01731153813","","kharkhari","rajshahi","bd","","bangladesh","","","1","2022-10-12 21:00:11","2022-10-12 21:00:11");
INSERT INTO customers VALUES("28","1","","saikat","","","88015217819","","kharkhari","rajshahi","","","","","","0","2022-10-23 23:07:45","2023-09-20 13:32:59");
INSERT INTO customers VALUES("29","9","","Walking Customer","","abc@abc.com","880","","Dhaka","Dhaka","Dhaka","","Bangladesh","","","1","2023-09-20 12:26:53","2023-09-20 12:26:53");
INSERT INTO customers VALUES("30","1","34","autushi","","autushi@gmail.com","015628900987","","Dhanmondi, Dhaka","Dhaka","Dhaka","1209","Bangladesh","","","1","2023-11-01 12:06:54","2023-11-01 12:06:54");
INSERT INTO customers VALUES("31","1","35","Mohammad Nazmul Hossain","Ebexsoft","mnhomi@gmail.com","01820579833","","254, Dhanmondi 10/A","Dhaka","Dhaka","1209","Bangladesh","500","400","1","2023-12-03 15:39:07","2023-12-03 17:14:05");
INSERT INTO customers VALUES("32","1","36","Anika","","anika.ebexsoft.com@gmail.com","01521101888","","Dhanmondi, Dhaka","Dhaka","","","","","","1","2023-12-04 13:37:15","2023-12-04 13:37:15");
INSERT INTO customers VALUES("33","1","37","Mamunur Rashid","Ebexsoft","ecomuser@gmail.com","01977663736","","254, Dhanmondi 10/A","Dhaka","Dhaka","1209","Bangladesh","","","0","2024-01-04 13:55:42","2024-01-04 17:38:17");



CREATE TABLE `deliveries` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(191) NOT NULL,
  `sale_id` int(11) NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `address` text NOT NULL,
  `delivered_by` varchar(191) DEFAULT NULL,
  `recieved_by` varchar(191) DEFAULT NULL,
  `file` varchar(191) DEFAULT NULL,
  `note` varchar(191) DEFAULT NULL,
  `status` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO deliveries VALUES("1","dr-20180808-044431","1","1","kajir deuri chittagong bd","abul","dhiman","","Instrument 1","3","2018-08-08 06:44:55","2020-09-26 08:25:39");
INSERT INTO deliveries VALUES("2","dr-20181106-105936","88","1","mohammadpur dhaka","","","","","1","2018-11-05 23:59:43","2023-12-03 16:10:02");
INSERT INTO deliveries VALUES("3","dr-20181106-111321","79","1","mohammadpur dhaka","Harun","Amjad","","","3","2018-11-06 00:13:25","2020-09-26 09:22:11");
INSERT INTO deliveries VALUES("5","dr-20230920-041435","330","29","Dhaka Dhaka Bangladesh","","","","","3","2023-09-20 16:14:54","2023-09-20 16:15:49");
INSERT INTO deliveries VALUES("6","dr-20230920-043952","331","29","Dhaka Dhaka Bangladesh","","","","","3","2023-09-20 16:40:10","2023-09-20 16:40:10");
INSERT INTO deliveries VALUES("7","dr-20230920-044306","332","29","Dhaka Dhaka Bangladesh","","","","","2","2023-09-20 16:43:17","2023-09-20 16:43:17");
INSERT INTO deliveries VALUES("8","dr-20231101-120730","342","34","address:Dhanmondi, Dhaka, apt:, city:Dhaka, state:Dhaka, postcode:1209, email:autushi@gmail.com, phone:015628900987","ebexshop","autushi","","autushi","0","2023-11-01 12:07:30","2023-11-01 12:07:30");
INSERT INTO deliveries VALUES("9","dr-20231203-034016","346","32","address:254, Dhanmondi 10/A, apt:, city:Dhaka, state:Dhaka, postcode:1205, email:mnhomi@gmail.com, phone:01820579833","ebexshop","Mohammad Nazmul Hossain","","Mohammad Nazmul Hossain","3","2023-12-03 15:40:16","2023-12-03 15:45:14");
INSERT INTO deliveries VALUES("10","dr-20231203-035319","347","32","address:254, Dhanmondi 10/A, apt:, city:Dhaka, state:Dhaka, postcode:1205, email:mnhomi@gmail.com, phone:01820579833","ebexshop","Mohammad Nazmul Hossain","","Mohammad Nazmul Hossain","3","2023-12-03 15:53:19","2023-12-03 16:09:37");
INSERT INTO deliveries VALUES("11","dr-20231204-013814","348","36","address:Dhanmondi, Dhaka, apt:, city:Dhaka, state:Dhaka, postcode:1209, email:anika.ebexsoft.com@gmail.com, phone:01521101888","ebexshop","Anika","","Anika","0","2023-12-04 13:38:14","2023-12-04 13:38:14");
INSERT INTO deliveries VALUES("12","dr-20231204-013947","349","36","address:Dhanmondi, Dhaka, apt:, city:Dhaka, state:, postcode:, email:anika.ebexsoft.com@gmail.com, phone:01521101888","ebexshop","Anika","","Anika","0","2023-12-04 13:39:47","2023-12-04 13:39:47");
INSERT INTO deliveries VALUES("13","dr-20231212-050452","350","35","address:254, Dhanmondi 10/A, apt:, city:Dhaka, state:Dhaka, postcode:1209, email:mnhomi@gmail.com, phone:01820579833","ebexshop","Mohammad Nazmul Hossain","","Mohammad Nazmul Hossain","0","2023-12-12 17:04:52","2023-12-12 17:04:52");



CREATE TABLE `departments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `is_active` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO departments VALUES("1","Sale","1","2018-12-27 00:16:47","2018-12-27 05:40:23");
INSERT INTO departments VALUES("2","xyz","0","2018-12-27 05:28:47","2023-09-20 13:35:07");



CREATE TABLE `deposits` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `amount` double NOT NULL,
  `customer_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO deposits VALUES("1","90","1","1","first deposit","2018-08-25 18:48:23","2018-08-25 21:18:55");
INSERT INTO deposits VALUES("3","100","2","1","","2018-08-25 20:53:16","2018-08-26 17:42:39");
INSERT INTO deposits VALUES("4","50","1","1","","2018-09-04 18:56:19","2018-09-04 18:56:19");
INSERT INTO deposits VALUES("5","50","1","1","","2018-09-09 20:08:40","2018-09-09 20:08:40");
INSERT INTO deposits VALUES("6","500","31","32","Deposit","2023-12-03 17:14:05","2023-12-03 17:14:05");



CREATE TABLE `employees` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `email` varchar(191) NOT NULL,
  `phone_number` varchar(191) NOT NULL,
  `department_id` int(11) NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `image` varchar(191) DEFAULT NULL,
  `address` varchar(191) DEFAULT NULL,
  `city` varchar(191) DEFAULT NULL,
  `country` varchar(191) DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO employees VALUES("1","john","john@gmail.com","10001","2","12","johngmailcom.jpg","GEC","chittagong","Bangladesh","1","2018-12-29 19:48:37","2019-03-02 01:50:23");
INSERT INTO employees VALUES("3","tests","test@test.com","111","1","","","","","","1","2018-12-30 17:20:51","2019-01-02 19:03:54");



CREATE TABLE `expense_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(191) NOT NULL,
  `name` varchar(191) NOT NULL,
  `is_active` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO expense_categories VALUES("1","16718342","washing","0","2018-08-15 20:32:48","2023-09-20 13:38:00");
INSERT INTO expense_categories VALUES("2","60128975","Electric Bill","1","2018-08-15 20:39:18","2023-09-20 13:38:20");
INSERT INTO expense_categories VALUES("3","83954970","test","0","2018-08-15 20:50:28","2018-08-15 20:51:40");
INSERT INTO expense_categories VALUES("4","1234","Snacks","1","2018-08-31 22:40:04","2023-09-20 13:38:32");
INSERT INTO expense_categories VALUES("5","01","Office","1","2022-03-07 09:46:25","2023-09-20 13:38:48");



CREATE TABLE `expenses` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(191) NOT NULL,
  `expense_category_id` int(11) NOT NULL,
  `warehouse_id` int(11) NOT NULL,
  `account_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `cash_register_id` int(11) DEFAULT NULL,
  `amount` double NOT NULL,
  `note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=40 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO expenses VALUES("2","er-20180817-012254","1","2","1","1","","150","first expense...","2018-08-17 03:22:54","2018-08-17 03:44:13");
INSERT INTO expenses VALUES("3","er-20180817-014241","1","1","1","1","","125","second expense...","2018-08-17 03:42:41","2018-08-17 03:43:50");
INSERT INTO expenses VALUES("4","er-20181022-043609","2","1","1","1","","1000","","2018-10-22 06:36:09","2018-10-22 06:36:09");
INSERT INTO expenses VALUES("5","er-20181101-050207","2","2","1","1","","1000","","2018-10-31 19:02:07","2018-10-31 19:02:07");
INSERT INTO expenses VALUES("6","er-20181101-050231","2","1","1","1","","550","","2018-10-31 19:02:31","2018-10-31 19:02:31");
INSERT INTO expenses VALUES("7","er-20181105-091913","1","1","1","1","","2000","","2018-11-04 22:19:13","2018-11-04 22:19:13");
INSERT INTO expenses VALUES("8","er-20181105-091929","2","2","1","1","","1000","","2018-11-04 22:19:29","2018-11-04 22:19:29");
INSERT INTO expenses VALUES("9","er-20190101-063342","2","1","1","1","","100","","2018-12-31 19:33:42","2018-12-31 19:33:42");
INSERT INTO expenses VALUES("10","er-20190103-070018","2","2","1","9","","2000","","2019-01-02 20:00:18","2019-01-02 20:00:18");
INSERT INTO expenses VALUES("11","er-20190209-104656","2","2","1","1","","500","","2019-02-08 23:46:56","2019-02-08 23:46:56");
INSERT INTO expenses VALUES("12","er-20190209-104716","2","1","1","1","","400","","2019-02-08 23:47:16","2019-02-08 23:47:16");
INSERT INTO expenses VALUES("14","er-20190303-104142","2","2","1","1","","250","jjj","2019-03-02 23:41:42","2019-03-20 05:17:16");
INSERT INTO expenses VALUES("15","er-20190404-095645","2","1","1","1","","200","","2019-04-03 23:56:45","2019-04-03 23:56:45");
INSERT INTO expenses VALUES("16","er-20190528-103306","2","1","1","1","","560","","2019-05-28 00:33:06","2019-05-28 00:33:06");
INSERT INTO expenses VALUES("17","er-20190528-103325","2","2","1","1","","600","","2019-05-28 00:33:25","2019-05-28 00:33:25");
INSERT INTO expenses VALUES("19","er-20190613-101955","2","2","1","1","","800","","2019-06-13 00:19:55","2019-06-13 00:19:55");
INSERT INTO expenses VALUES("20","er-20191019-033149","2","1","1","1","","300","","2019-10-19 05:31:49","2019-10-19 05:31:49");
INSERT INTO expenses VALUES("21","er-20191222-023508","2","1","1","1","","550","","2019-12-22 03:35:08","2019-12-22 03:35:08");
INSERT INTO expenses VALUES("22","er-20200101-022304","2","2","1","1","","500","","2020-01-01 03:23:04","2020-01-01 03:23:04");
INSERT INTO expenses VALUES("23","er-20200204-105938","1","1","1","1","","400","","2020-02-04 11:59:38","2020-02-04 11:59:38");
INSERT INTO expenses VALUES("24","er-20200204-105957","1","2","1","1","","350","","2020-02-04 11:59:57","2020-02-04 11:59:57");
INSERT INTO expenses VALUES("25","er-20200406-075239","2","2","1","1","","750","","2020-04-06 09:52:39","2020-04-06 09:52:39");
INSERT INTO expenses VALUES("26","er-20200506-110112","2","2","1","1","","1260","","2020-05-06 13:01:12","2020-05-06 13:01:12");
INSERT INTO expenses VALUES("27","er-20200609-124344","2","1","1","1","","500","","2020-06-09 02:43:44","2020-06-09 02:43:44");
INSERT INTO expenses VALUES("28","er-20200609-124406","2","2","1","1","","1000","","2020-06-09 02:44:06","2020-06-09 02:44:06");
INSERT INTO expenses VALUES("29","er-20200703-064005","2","2","1","1","","630","","2020-07-03 08:40:05","2020-07-03 08:40:05");
INSERT INTO expenses VALUES("30","er-20200812-062947","1","2","1","1","","320","","2020-08-12 08:29:47","2020-08-12 08:29:47");
INSERT INTO expenses VALUES("31","er-20200812-063010","2","2","1","1","","730","","2020-08-12 08:30:10","2020-08-12 08:30:10");
INSERT INTO expenses VALUES("32","er-20201018-124438","2","1","1","9","2","100","","2020-10-18 02:44:38","2020-10-18 02:44:38");
INSERT INTO expenses VALUES("33","er-20201101-072257","1","2","1","1","4","50","","2020-10-31 21:22:57","2020-10-31 21:22:57");
INSERT INTO expenses VALUES("34","er-20201118-062500","4","1","1","1","3","200","","2020-11-17 19:25:00","2020-11-17 19:25:00");
INSERT INTO expenses VALUES("37","er-20210114-065938","2","2","1","1","4","25.5","","2021-01-13 19:59:38","2021-01-13 19:59:38");
INSERT INTO expenses VALUES("38","er-20211016-035622","2","2","1","1","4","2000","","2021-10-16 15:56:22","2021-10-16 15:56:22");
INSERT INTO expenses VALUES("39","er-20220307-094714","4","1","1","29","6","500","","2022-03-07 09:47:14","2022-03-07 09:47:14");



CREATE TABLE `failed_jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `connection` text NOT NULL,
  `queue` text NOT NULL,
  `payload` longtext NOT NULL,
  `exception` longtext NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `general_settings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `site_title` varchar(191) NOT NULL,
  `site_logo` varchar(191) DEFAULT NULL,
  `currency` varchar(191) NOT NULL,
  `staff_access` varchar(191) NOT NULL,
  `date_format` varchar(191) NOT NULL,
  `developed_by` varchar(191) DEFAULT NULL,
  `invoice_format` varchar(191) DEFAULT NULL,
  `state` int(11) DEFAULT NULL,
  `theme` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `currency_position` varchar(191) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO general_settings VALUES("1","Music Care","20240110115942.png","3","own","d/m/Y","Ebexsoft","standard","1","default.css","2018-07-06 02:13:11","2024-01-10 11:59:42","prefix");



CREATE TABLE `gift_card_recharges` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `gift_card_id` int(11) NOT NULL,
  `amount` double NOT NULL,
  `user_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO gift_card_recharges VALUES("1","2","100","1","2018-08-24 19:08:29","2018-08-24 19:08:29");
INSERT INTO gift_card_recharges VALUES("2","1","200","1","2018-08-24 19:08:50","2018-08-24 19:08:50");
INSERT INTO gift_card_recharges VALUES("3","1","100","1","2018-09-04 19:50:41","2018-09-04 19:50:41");
INSERT INTO gift_card_recharges VALUES("4","1","50","1","2018-09-04 19:51:38","2018-09-04 19:51:38");
INSERT INTO gift_card_recharges VALUES("5","1","50","1","2018-09-04 19:53:36","2018-09-04 19:53:36");
INSERT INTO gift_card_recharges VALUES("6","2","50","1","2018-09-04 19:54:34","2018-09-04 19:54:34");
INSERT INTO gift_card_recharges VALUES("7","5","10","1","2018-09-29 20:19:48","2018-09-29 20:19:48");
INSERT INTO gift_card_recharges VALUES("8","5","10","1","2018-09-29 20:20:04","2018-09-29 20:20:04");
INSERT INTO gift_card_recharges VALUES("9","2","100","1","2018-10-06 23:13:05","2018-10-06 23:13:05");
INSERT INTO gift_card_recharges VALUES("10","1","200","1","2018-10-06 23:13:39","2018-10-06 23:13:39");
INSERT INTO gift_card_recharges VALUES("11","1","300","1","2018-10-22 20:22:49","2018-10-22 20:22:49");
INSERT INTO gift_card_recharges VALUES("12","2","130","1","2021-02-11 02:36:01","2021-02-11 02:36:01");



CREATE TABLE `gift_cards` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `card_no` varchar(191) NOT NULL,
  `amount` double NOT NULL,
  `expense` double NOT NULL,
  `customer_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `expired_date` date DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `is_active` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO gift_cards VALUES("1","3571097513020486","1400","450","1","","2020-12-31","1","1","2018-08-17 21:57:40","2020-10-18 01:14:26");
INSERT INTO gift_cards VALUES("2","0452297501931931","500","100","2","","2021-12-31","1","1","2018-08-17 22:46:43","2021-02-11 02:36:01");
INSERT INTO gift_cards VALUES("3","123","13123","0","1","","2018-08-19","1","0","2018-08-18 18:38:21","2018-08-18 18:38:28");
INSERT INTO gift_cards VALUES("4","1862381252690499","100","0","","1","2018-10-04","1","0","2018-09-29 20:16:28","2018-09-29 20:17:21");
INSERT INTO gift_cards VALUES("5","2300813717254199","143","0","","1","2018-10-04","1","0","2018-09-29 20:18:49","2018-09-29 20:20:20");
INSERT INTO gift_cards VALUES("6","8327019475026421","1","0","1","","2018-10-07","1","0","2018-10-06 23:12:41","2018-10-06 23:12:55");
INSERT INTO gift_cards VALUES("7","2063379780590151","1","0","1","","2018-10-23","1","0","2018-10-22 20:23:22","2018-10-22 20:23:39");



CREATE TABLE `holidays` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `from_date` date NOT NULL,
  `to_date` date NOT NULL,
  `note` text DEFAULT NULL,
  `is_approved` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `hrm_settings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `checkin` varchar(191) NOT NULL,
  `checkout` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO hrm_settings VALUES("1","10:00am","6:00pm","2019-01-01 21:20:08","2019-01-01 23:20:53");



CREATE TABLE `languages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO languages VALUES("1","en","2018-07-07 18:59:17","2019-12-24 12:34:20");



CREATE TABLE `migrations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(191) NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=133 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO migrations VALUES("1","2014_10_12_000000_create_users_table","1");
INSERT INTO migrations VALUES("2","2014_10_12_100000_create_password_resets_table","1");
INSERT INTO migrations VALUES("3","2018_02_17_060412_create_categories_table","1");
INSERT INTO migrations VALUES("4","2018_02_20_035727_create_brands_table","1");
INSERT INTO migrations VALUES("5","2018_02_25_100635_create_suppliers_table","1");
INSERT INTO migrations VALUES("6","2018_02_27_101619_create_warehouse_table","1");
INSERT INTO migrations VALUES("7","2018_03_03_040448_create_units_table","1");
INSERT INTO migrations VALUES("8","2018_03_04_041317_create_taxes_table","1");
INSERT INTO migrations VALUES("9","2018_03_10_061915_create_customer_groups_table","1");
INSERT INTO migrations VALUES("10","2018_03_10_090534_create_customers_table","1");
INSERT INTO migrations VALUES("11","2018_03_11_095547_create_billers_table","1");
INSERT INTO migrations VALUES("12","2018_04_05_054401_create_products_table","1");
INSERT INTO migrations VALUES("13","2018_04_06_133606_create_purchases_table","1");
INSERT INTO migrations VALUES("14","2018_04_06_154600_create_product_purchases_table","1");
INSERT INTO migrations VALUES("15","2018_04_06_154915_create_product_warhouse_table","1");
INSERT INTO migrations VALUES("16","2018_04_10_085927_create_sales_table","1");
INSERT INTO migrations VALUES("17","2018_04_10_090133_create_product_sales_table","1");
INSERT INTO migrations VALUES("18","2018_04_10_090254_create_payments_table","1");
INSERT INTO migrations VALUES("19","2018_04_10_090341_create_payment_with_cheque_table","1");
INSERT INTO migrations VALUES("20","2018_04_10_090509_create_payment_with_credit_card_table","1");
INSERT INTO migrations VALUES("21","2018_04_13_121436_create_quotation_table","1");
INSERT INTO migrations VALUES("22","2018_04_13_122324_create_product_quotation_table","1");
INSERT INTO migrations VALUES("23","2018_04_14_121802_create_transfers_table","1");
INSERT INTO migrations VALUES("24","2018_04_14_121913_create_product_transfer_table","1");
INSERT INTO migrations VALUES("25","2018_05_13_082847_add_payment_id_and_change_sale_id_to_payments_table","2");
INSERT INTO migrations VALUES("26","2018_05_13_090906_change_customer_id_to_payment_with_credit_card_table","3");
INSERT INTO migrations VALUES("27","2018_05_20_054532_create_adjustments_table","4");
INSERT INTO migrations VALUES("28","2018_05_20_054859_create_product_adjustments_table","4");
INSERT INTO migrations VALUES("29","2018_05_21_163419_create_returns_table","5");
INSERT INTO migrations VALUES("30","2018_05_21_163443_create_product_returns_table","5");
INSERT INTO migrations VALUES("31","2018_06_02_050905_create_roles_table","6");
INSERT INTO migrations VALUES("32","2018_06_02_073430_add_columns_to_users_table","7");
INSERT INTO migrations VALUES("33","2018_06_03_053738_create_permission_tables","8");
INSERT INTO migrations VALUES("36","2018_06_21_063736_create_pos_setting_table","9");
INSERT INTO migrations VALUES("37","2018_06_21_094155_add_user_id_to_sales_table","10");
INSERT INTO migrations VALUES("38","2018_06_21_101529_add_user_id_to_purchases_table","11");
INSERT INTO migrations VALUES("39","2018_06_21_103512_add_user_id_to_transfers_table","12");
INSERT INTO migrations VALUES("40","2018_06_23_061058_add_user_id_to_quotations_table","13");
INSERT INTO migrations VALUES("41","2018_06_23_082427_add_is_deleted_to_users_table","14");
INSERT INTO migrations VALUES("42","2018_06_25_043308_change_email_to_users_table","15");
INSERT INTO migrations VALUES("43","2018_07_06_115449_create_general_settings_table","16");
INSERT INTO migrations VALUES("44","2018_07_08_043944_create_languages_table","17");
INSERT INTO migrations VALUES("45","2018_07_11_102144_add_user_id_to_returns_table","18");
INSERT INTO migrations VALUES("46","2018_07_11_102334_add_user_id_to_payments_table","18");
INSERT INTO migrations VALUES("47","2018_07_22_130541_add_digital_to_products_table","19");
INSERT INTO migrations VALUES("49","2018_07_24_154250_create_deliveries_table","20");
INSERT INTO migrations VALUES("50","2018_08_16_053336_create_expense_categories_table","21");
INSERT INTO migrations VALUES("51","2018_08_17_115415_create_expenses_table","22");
INSERT INTO migrations VALUES("55","2018_08_18_050418_create_gift_cards_table","23");
INSERT INTO migrations VALUES("56","2018_08_19_063119_create_payment_with_gift_card_table","24");
INSERT INTO migrations VALUES("57","2018_08_25_042333_create_gift_card_recharges_table","25");
INSERT INTO migrations VALUES("58","2018_08_25_101354_add_deposit_expense_to_customers_table","26");
INSERT INTO migrations VALUES("59","2018_08_26_043801_create_deposits_table","27");
INSERT INTO migrations VALUES("60","2018_09_02_044042_add_keybord_active_to_pos_setting_table","28");
INSERT INTO migrations VALUES("61","2018_09_09_092713_create_payment_with_paypal_table","29");
INSERT INTO migrations VALUES("62","2018_09_10_051254_add_currency_to_general_settings_table","30");
INSERT INTO migrations VALUES("63","2018_10_22_084118_add_biller_and_store_id_to_users_table","31");
INSERT INTO migrations VALUES("65","2018_10_26_034927_create_coupons_table","32");
INSERT INTO migrations VALUES("66","2018_10_27_090857_add_coupon_to_sales_table","33");
INSERT INTO migrations VALUES("67","2018_11_07_070155_add_currency_position_to_general_settings_table","34");
INSERT INTO migrations VALUES("68","2018_11_19_094650_add_combo_to_products_table","35");
INSERT INTO migrations VALUES("69","2018_12_09_043712_create_accounts_table","36");
INSERT INTO migrations VALUES("70","2018_12_17_112253_add_is_default_to_accounts_table","37");
INSERT INTO migrations VALUES("71","2018_12_19_103941_add_account_id_to_payments_table","38");
INSERT INTO migrations VALUES("72","2018_12_20_065900_add_account_id_to_expenses_table","39");
INSERT INTO migrations VALUES("73","2018_12_20_082753_add_account_id_to_returns_table","40");
INSERT INTO migrations VALUES("74","2018_12_26_064330_create_return_purchases_table","41");
INSERT INTO migrations VALUES("75","2018_12_26_144210_create_purchase_product_return_table","42");
INSERT INTO migrations VALUES("76","2018_12_26_144708_create_purchase_product_return_table","43");
INSERT INTO migrations VALUES("77","2018_12_27_110018_create_departments_table","44");
INSERT INTO migrations VALUES("78","2018_12_30_054844_create_employees_table","45");
INSERT INTO migrations VALUES("79","2018_12_31_125210_create_payrolls_table","46");
INSERT INTO migrations VALUES("80","2018_12_31_150446_add_department_id_to_employees_table","47");
INSERT INTO migrations VALUES("81","2019_01_01_062708_add_user_id_to_expenses_table","48");
INSERT INTO migrations VALUES("82","2019_01_02_075644_create_hrm_settings_table","49");
INSERT INTO migrations VALUES("83","2019_01_02_090334_create_attendances_table","50");
INSERT INTO migrations VALUES("84","2019_01_27_160956_add_three_columns_to_general_settings_table","51");
INSERT INTO migrations VALUES("85","2019_02_15_183303_create_stock_counts_table","52");
INSERT INTO migrations VALUES("86","2019_02_17_101604_add_is_adjusted_to_stock_counts_table","53");
INSERT INTO migrations VALUES("87","2019_04_13_101707_add_tax_no_to_customers_table","54");
INSERT INTO migrations VALUES("89","2019_10_14_111455_create_holidays_table","55");
INSERT INTO migrations VALUES("90","2019_11_13_145619_add_is_variant_to_products_table","56");
INSERT INTO migrations VALUES("91","2019_11_13_150206_create_product_variants_table","57");
INSERT INTO migrations VALUES("92","2019_11_13_153828_create_variants_table","57");
INSERT INTO migrations VALUES("93","2019_11_25_134041_add_qty_to_product_variants_table","58");
INSERT INTO migrations VALUES("94","2019_11_25_134922_add_variant_id_to_product_purchases_table","58");
INSERT INTO migrations VALUES("95","2019_11_25_145341_add_variant_id_to_product_warehouse_table","58");
INSERT INTO migrations VALUES("96","2019_11_29_182201_add_variant_id_to_product_sales_table","59");
INSERT INTO migrations VALUES("97","2019_12_04_121311_add_variant_id_to_product_quotation_table","60");
INSERT INTO migrations VALUES("98","2019_12_05_123802_add_variant_id_to_product_transfer_table","61");
INSERT INTO migrations VALUES("100","2019_12_08_114954_add_variant_id_to_product_returns_table","62");
INSERT INTO migrations VALUES("101","2019_12_08_203146_add_variant_id_to_purchase_product_return_table","63");
INSERT INTO migrations VALUES("102","2020_02_28_103340_create_money_transfers_table","64");
INSERT INTO migrations VALUES("103","2020_07_01_193151_add_image_to_categories_table","65");
INSERT INTO migrations VALUES("105","2020_09_26_130426_add_user_id_to_deliveries_table","66");
INSERT INTO migrations VALUES("107","2020_10_11_125457_create_cash_registers_table","67");
INSERT INTO migrations VALUES("108","2020_10_13_155019_add_cash_register_id_to_sales_table","68");
INSERT INTO migrations VALUES("109","2020_10_13_172624_add_cash_register_id_to_returns_table","69");
INSERT INTO migrations VALUES("110","2020_10_17_212338_add_cash_register_id_to_payments_table","70");
INSERT INTO migrations VALUES("111","2020_10_18_124200_add_cash_register_id_to_expenses_table","71");
INSERT INTO migrations VALUES("112","2020_10_21_121632_add_developed_by_to_general_settings_table","72");
INSERT INTO migrations VALUES("113","2019_08_19_000000_create_failed_jobs_table","73");
INSERT INTO migrations VALUES("114","2020_10_30_135557_create_notifications_table","73");
INSERT INTO migrations VALUES("115","2020_11_01_044954_create_currencies_table","74");
INSERT INTO migrations VALUES("116","2020_11_01_140736_add_price_to_product_warehouse_table","75");
INSERT INTO migrations VALUES("117","2020_11_02_050633_add_is_diff_price_to_products_table","76");
INSERT INTO migrations VALUES("118","2020_11_09_055222_add_user_id_to_customers_table","77");
INSERT INTO migrations VALUES("119","2020_11_17_054806_add_invoice_format_to_general_settings_table","78");
INSERT INTO migrations VALUES("120","2021_02_10_074859_add_variant_id_to_product_adjustments_table","79");
INSERT INTO migrations VALUES("121","2021_03_07_093606_create_product_batches_table","80");
INSERT INTO migrations VALUES("122","2021_03_07_093759_add_product_batch_id_to_product_warehouse_table","80");
INSERT INTO migrations VALUES("123","2021_03_07_093900_add_product_batch_id_to_product_purchases_table","80");
INSERT INTO migrations VALUES("124","2021_03_11_132603_add_product_batch_id_to_product_sales_table","81");
INSERT INTO migrations VALUES("127","2021_03_25_125421_add_is_batch_to_products_table","82");
INSERT INTO migrations VALUES("128","2021_05_19_120127_add_product_batch_id_to_product_returns_table","82");
INSERT INTO migrations VALUES("130","2021_05_22_105611_add_product_batch_id_to_purchase_product_return_table","83");
INSERT INTO migrations VALUES("131","2021_05_23_124848_add_product_batch_id_to_product_transfer_table","84");
INSERT INTO migrations VALUES("132","2021_05_26_153106_add_product_batch_id_to_product_quotation_table","85");



CREATE TABLE `money_transfers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(191) NOT NULL,
  `from_account_id` int(11) NOT NULL,
  `to_account_id` int(11) NOT NULL,
  `amount` double NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO money_transfers VALUES("2","mtr-20200228-071852","1","3","100","2020-02-28 08:18:52","2020-02-28 08:18:52");



CREATE TABLE `notifications` (
  `id` char(36) NOT NULL,
  `type` varchar(191) NOT NULL,
  `notifiable_type` varchar(191) NOT NULL,
  `notifiable_id` bigint(20) unsigned NOT NULL,
  `data` text NOT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `notifications_notifiable_type_notifiable_id_index` (`notifiable_type`,`notifiable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO notifications VALUES("249beded-5431-40a3-ba1e-d255ffb047a3","App\Notifications\SendNotification","App\User","9","{"message":"Please delete all pending purchase."}","2020-10-31 21:33:32","2020-10-31 21:33:07","2020-10-31 21:33:32");



CREATE TABLE `password_resets` (
  `email` varchar(191) NOT NULL,
  `token` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `password_resets_email_index` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `payment_with_cheque` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `payment_id` int(11) NOT NULL,
  `cheque_no` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO payment_with_cheque VALUES("1","19","23425235235","2018-06-30 23:09:48","2018-06-30 23:09:48");
INSERT INTO payment_with_cheque VALUES("2","24","3123123123","2018-07-09 21:21:32","2018-07-09 21:21:32");
INSERT INTO payment_with_cheque VALUES("3","31","767867678","2018-08-08 06:36:22","2018-08-08 06:36:22");
INSERT INTO payment_with_cheque VALUES("4","34","3123412","2018-08-08 19:55:54","2018-08-08 19:55:54");
INSERT INTO payment_with_cheque VALUES("5","35","7765","2018-08-08 20:32:14","2018-08-08 20:32:14");
INSERT INTO payment_with_cheque VALUES("6","44","3124142412","2018-08-29 23:07:18","2018-08-29 23:07:18");
INSERT INTO payment_with_cheque VALUES("7","51","6576764646","2018-09-03 00:08:21","2018-09-03 00:08:21");
INSERT INTO payment_with_cheque VALUES("8","53","111111111","2018-09-03 00:15:24","2018-09-03 00:15:24");
INSERT INTO payment_with_cheque VALUES("9","79","1111","2018-10-05 20:51:55","2018-10-05 20:51:55");
INSERT INTO payment_with_cheque VALUES("10","147","221133","2018-12-03 19:58:35","2018-12-03 19:58:35");
INSERT INTO payment_with_cheque VALUES("11","175","1111","2019-02-07 01:38:23","2019-02-07 01:38:23");
INSERT INTO payment_with_cheque VALUES("12","176","1111","2019-02-07 01:54:59","2019-02-07 01:54:59");
INSERT INTO payment_with_cheque VALUES("13","178","420","2019-02-07 02:07:04","2019-02-07 02:07:04");
INSERT INTO payment_with_cheque VALUES("14","216","12344321","2019-11-10 23:39:11","2019-11-10 23:39:11");
INSERT INTO payment_with_cheque VALUES("15","295","111122222","2020-10-18 01:17:24","2020-10-18 01:17:24");
INSERT INTO payment_with_cheque VALUES("16","382","111222333","2023-09-20 16:36:27","2023-09-20 16:36:27");



CREATE TABLE `payment_with_credit_card` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `payment_id` int(11) NOT NULL,
  `customer_id` int(11) DEFAULT NULL,
  `customer_stripe_id` varchar(191) DEFAULT NULL,
  `charge_id` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO payment_with_credit_card VALUES("4","294","1","cus_IDw8z9yJZn4qH3","ch_1HdUGJKwOmA8HLXePiqphlky","2020-10-18 01:16:55","2020-10-18 01:16:55");



CREATE TABLE `payment_with_gift_card` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `payment_id` int(11) NOT NULL,
  `gift_card_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO payment_with_gift_card VALUES("1","36","2","2018-08-24 17:48:36","2018-08-24 20:57:35");
INSERT INTO payment_with_gift_card VALUES("4","39","1","2018-08-24 22:36:34","2018-08-24 22:36:34");
INSERT INTO payment_with_gift_card VALUES("6","50","1","2018-09-02 19:01:38","2018-09-02 19:01:38");
INSERT INTO payment_with_gift_card VALUES("8","293","1","2020-10-18 01:14:26","2020-10-18 01:14:26");



CREATE TABLE `payment_with_paypal` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `payment_id` int(11) NOT NULL,
  `transaction_id` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `payments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `payment_reference` varchar(191) NOT NULL,
  `user_id` int(11) NOT NULL,
  `purchase_id` int(11) DEFAULT NULL,
  `sale_id` int(11) DEFAULT NULL,
  `cash_register_id` int(11) DEFAULT NULL,
  `account_id` int(11) NOT NULL,
  `amount` double NOT NULL,
  `change` double NOT NULL,
  `paying_method` varchar(191) NOT NULL,
  `payment_note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=403 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO payments VALUES("33","spr-20180809-055453","1","","2","","1","1000","0","Cash","","2018-08-08 19:54:53","2018-08-08 19:54:53");
INSERT INTO payments VALUES("34","spr-20180809-055553","1","","2","","1","1200","0","Cheque","","2018-08-08 19:55:53","2018-08-08 19:56:36");
INSERT INTO payments VALUES("35","spr-20180809-063214","1","","3","","1","897","0","Cheque","","2018-08-08 20:32:14","2018-08-08 20:32:14");
INSERT INTO payments VALUES("36","spr-20180825-034836","1","","4","","1","100","0","Gift Card","100 bucks paid...","2018-08-24 17:48:36","2018-08-24 20:57:35");
INSERT INTO payments VALUES("39","spr-20180825-083634","1","","4","","1","200","0","Gift Card","","2018-08-24 22:36:34","2018-08-24 22:36:34");
INSERT INTO payments VALUES("41","spr-20180826-094836","1","","6","","1","20","0","Deposit","20 bucks paid","2018-08-25 23:48:36","2018-08-26 17:42:13");
INSERT INTO payments VALUES("42","spr-20180827-073545","1","","7","","1","880","0","Cash","","2018-08-26 21:35:45","2018-08-26 21:35:45");
INSERT INTO payments VALUES("43","ppr-20180830-071637","1","13","","","1","100","0","Cash","100 bucks paid...","2018-08-29 21:16:37","2018-08-29 21:16:37");
INSERT INTO payments VALUES("44","ppr-20180830-090718","1","13","","","1","200","0","Cheque","","2018-08-29 23:07:18","2018-08-29 23:07:18");
INSERT INTO payments VALUES("46","spr-20180902-053954","1","","8","","1","3529.8","0","Cash","fully paid","2018-09-01 19:39:54","2018-09-01 19:39:54");
INSERT INTO payments VALUES("49","spr-20180903-033314","1","","9","","1","20","0","Deposit","fully paid","2018-09-02 17:33:14","2018-09-02 17:33:14");
INSERT INTO payments VALUES("50","spr-20180903-050138","1","","10","","1","200","0","Gift Card","50 bucks due...","2018-09-02 19:01:38","2018-09-09 17:40:28");
INSERT INTO payments VALUES("51","spr-20180903-100821","1","","11","","1","5500","0","Cheque","","2018-09-03 00:08:21","2018-09-03 00:08:21");
INSERT INTO payments VALUES("53","ppr-20180903-101524","1","16","","","1","1750","0","Cheque","","2018-09-03 00:15:24","2018-10-05 21:09:20");
INSERT INTO payments VALUES("78","spr-20180926-092105","1","","31","","1","560","0","Cash","","2018-09-25 23:21:05","2018-09-25 23:21:05");
INSERT INTO payments VALUES("79","spr-20181006-065017","1","","30","","1","100","0","Cheque","","2018-10-05 20:50:17","2018-10-05 20:51:55");
INSERT INTO payments VALUES("80","spr-20181006-065222","1","","30","","1","20","0","Cash","","2018-10-05 20:52:22","2018-10-05 20:52:22");
INSERT INTO payments VALUES("82","ppr-20181006-070935","1","16","","","1","1600","0","Cash","","2018-10-05 21:09:35","2018-10-05 21:09:35");
INSERT INTO payments VALUES("83","spr-20181010-041636","1","","41","","1","461","0","Cash","","2018-10-09 18:16:36","2018-10-09 18:16:36");
INSERT INTO payments VALUES("84","spr-20181010-053456","1","","42","","1","440","0","Cash","","2018-10-09 19:34:56","2018-10-09 19:34:56");
INSERT INTO payments VALUES("91","spr-20181021-065338","1","","55","","1","250","0","Cash","","2018-10-20 20:53:38","2018-10-20 20:53:38");
INSERT INTO payments VALUES("92","spr-20181021-082618","1","","57","","1","575.2","0","Cash","","2018-10-20 22:26:18","2018-10-20 22:26:18");
INSERT INTO payments VALUES("93","spr-20181022-032730","1","","58","","1","1220","0","Cash","","2018-10-22 05:27:30","2018-10-22 05:27:30");
INSERT INTO payments VALUES("104","spr-20181023-071548","11","","73","","1","5500","0","Cash","","2018-10-22 21:15:48","2018-10-22 21:15:48");
INSERT INTO payments VALUES("105","spr-20181023-071648","1","","74","","1","2320","0","Cash","","2018-10-22 21:16:48","2018-10-22 21:16:48");
INSERT INTO payments VALUES("126","spr-20181101-050033","1","","75","","1","7678","0","Cash","","2018-10-31 19:00:33","2018-10-31 19:00:33");
INSERT INTO payments VALUES("127","spr-20181101-050130","1","","76","","1","1424","0","Cash","","2018-10-31 19:01:30","2018-11-07 22:44:51");
INSERT INTO payments VALUES("129","spr-20181105-091523","1","","79","","1","14454","0","Cash","","2018-11-04 22:15:23","2018-11-04 22:15:23");
INSERT INTO payments VALUES("130","spr-20181105-092002","1","","80","","1","2500","0","Cash","","2018-11-04 22:20:02","2018-11-04 22:20:02");
INSERT INTO payments VALUES("131","ppr-20181105-092128","1","24","","","1","15950","0","Cash","","2018-11-04 22:21:28","2018-11-04 22:21:28");
INSERT INTO payments VALUES("137","spr-20181105-095952","1","","86","","1","1100","0","Cash","","2018-11-04 22:59:52","2018-11-04 22:59:52");
INSERT INTO payments VALUES("138","spr-20181105-100310","1","","88","","1","1100","0","Cash","","2018-11-04 23:03:10","2018-11-04 23:03:10");
INSERT INTO payments VALUES("139","spr-20181126-020534","1","","94","","1","120","0","Cash","","2018-11-26 03:05:34","2018-11-26 03:05:34");
INSERT INTO payments VALUES("140","spr-20181128-071515","1","","96","","1","132","0","Cash","","2018-11-27 20:15:15","2018-11-27 20:15:15");
INSERT INTO payments VALUES("141","spr-20181201-060524","1","","97","","1","200","300","Cash","","2018-11-30 19:05:24","2018-12-03 19:21:05");
INSERT INTO payments VALUES("148","ppr-20181204-065932","1","23","","","1","500","500","Cash","","2018-12-03 19:59:32","2018-12-03 19:59:44");
INSERT INTO payments VALUES("149","ppr-20181205-053443","1","25","","","1","4450","550","Cash","","2018-12-04 18:34:43","2018-12-04 18:34:43");
INSERT INTO payments VALUES("150","spr-20181205-053608","1","","98","","1","800","200","Cash","","2018-12-04 18:36:08","2018-12-04 18:36:08");
INSERT INTO payments VALUES("151","spr-20181205-053724","1","","99","","1","800","0","Cash","","2018-12-04 18:37:24","2018-12-04 18:37:24");
INSERT INTO payments VALUES("152","spr-20181208-062032","1","","101","","1","100","400","Cash","","2018-12-07 19:20:32","2018-12-10 22:19:39");
INSERT INTO payments VALUES("157","ppr-20181220-063439","1","27","","","1","10","0","Cash","","2018-12-19 19:34:39","2018-12-19 19:35:01");
INSERT INTO payments VALUES("159","spr-20181224-045832","1","","103","","1","120","0","Cash","","2018-12-23 17:58:32","2018-12-23 17:58:32");
INSERT INTO payments VALUES("160","spr-20190101-054544","1","","105","","1","21","0","Cash","","2018-12-31 18:45:44","2018-12-31 18:45:44");
INSERT INTO payments VALUES("161","spr-20190101-091040","1","","106","","1","860","0","Cash","","2018-12-31 22:10:40","2018-12-31 22:10:40");
INSERT INTO payments VALUES("162","spr-20190103-065627","1","","107","","1","5040","960","Cash","","2019-01-02 19:56:27","2019-01-02 19:56:27");
INSERT INTO payments VALUES("163","spr-20190120-035824","1","","108","","1","120","0","Cash","","2019-01-20 04:58:24","2019-01-20 04:58:24");
INSERT INTO payments VALUES("164","ppr-20190129-100302","9","36","","","1","650","350","Cash","","2019-01-28 23:03:02","2019-01-28 23:03:02");
INSERT INTO payments VALUES("165","ppr-20190129-100324","9","34","","","1","2860","140","Cash","","2019-01-28 23:03:24","2019-01-28 23:03:24");
INSERT INTO payments VALUES("166","spr-20190129-101451","9","","109","","1","540","460","Cash","","2019-01-28 23:14:51","2019-01-28 23:14:51");
INSERT INTO payments VALUES("167","spr-20190129-115048","9","","110","","1","1700","300","Cash","","2019-01-29 00:50:48","2019-01-29 00:50:48");
INSERT INTO payments VALUES("168","spr-20190131-110839","9","","111","","1","271","0","Cash","","2019-01-31 00:08:39","2019-01-31 00:08:39");
INSERT INTO payments VALUES("169","spr-20190202-104045","1","","112","","1","440","0","Cash","","2019-02-01 23:40:45","2019-02-01 23:40:45");
INSERT INTO payments VALUES("170","spr-20190202-114117","1","","113","","1","350","0","Cash","","2019-02-02 00:41:17","2019-02-02 00:41:17");
INSERT INTO payments VALUES("171","spr-20190205-030454","1","","114","","1","440","0","Cash","","2019-02-05 04:04:54","2019-02-05 04:04:54");
INSERT INTO payments VALUES("176","ppr-20190207-125418","1","35","","","1","50","50","Cash","","2019-02-07 01:54:18","2019-02-07 02:05:23");
INSERT INTO payments VALUES("178","ppr-20190207-010640","1","35","","","1","50","50","Cheque","","2019-02-07 02:06:40","2019-02-07 02:07:04");
INSERT INTO payments VALUES("179","spr-20190207-010915","1","","120","","1","50","50","Cash","","2019-02-07 02:09:15","2019-02-07 02:09:15");
INSERT INTO payments VALUES("180","spr-20190209-104816","1","","121","","1","1272","728","Cash","","2019-02-08 23:48:16","2019-02-08 23:48:16");
INSERT INTO payments VALUES("181","ppr-20190209-104940","1","38","","","1","1660","0","Cash","","2019-02-08 23:49:40","2019-02-08 23:49:40");
INSERT INTO payments VALUES("182","ppr-20190209-104959","1","39","","","1","973.5","0","Cash","","2019-02-08 23:49:59","2019-02-08 23:49:59");
INSERT INTO payments VALUES("183","spr-20190219-023214","1","","123","","1","440","0","Cash","","2019-02-19 03:32:14","2019-02-19 03:32:14");
INSERT INTO payments VALUES("189","spr-20190303-104010","1","","127","","1","2500","0","Cash","","2019-03-02 23:40:10","2019-03-02 23:40:10");
INSERT INTO payments VALUES("190","ppr-20190303-104046","1","40","","","1","100","0","Cash","","2019-03-02 23:40:46","2019-03-02 23:40:46");
INSERT INTO payments VALUES("191","ppr-20190303-104222","1","37","","","1","4000","0","Cash","","2019-03-02 23:42:22","2019-03-02 23:42:22");
INSERT INTO payments VALUES("192","ppr-20190303-104414","1","41","","","1","1000","0","Cash","","2019-03-02 23:44:14","2019-03-02 23:44:14");
INSERT INTO payments VALUES("193","spr-20190404-095555","1","","128","","1","560","0","Cash","","2019-04-03 23:55:55","2019-04-03 23:55:55");
INSERT INTO payments VALUES("194","ppr-20190404-095910","1","42","","","1","300","200","Cash","","2019-04-03 23:59:10","2019-04-13 06:52:38");
INSERT INTO payments VALUES("195","spr-20190404-095937","1","","129","","1","120","0","Cash","","2019-04-03 23:59:37","2019-04-03 23:59:37");
INSERT INTO payments VALUES("196","spr-20190421-122124","1","","130","","1","586","0","Cash","","2019-04-21 02:21:24","2019-04-21 02:21:24");
INSERT INTO payments VALUES("197","spr-20190528-103229","1","","131","","1","2890","0","Cash","","2019-05-28 00:32:29","2019-05-28 00:32:29");
INSERT INTO payments VALUES("198","ppr-20190613-101351","1","37","","","1","2390","0","Cash","","2019-06-13 00:13:51","2019-06-13 00:13:51");
INSERT INTO payments VALUES("199","spr-20190613-101637","1","","132","","1","840","0","Cash","","2019-06-13 00:16:37","2019-06-13 00:16:37");
INSERT INTO payments VALUES("200","ppr-20190613-101713","1","43","","","1","1000","0","Cash","","2019-06-13 00:17:13","2019-06-13 00:17:13");
INSERT INTO payments VALUES("201","spr-20190613-101752","1","","133","","1","2700","0","Cash","","2019-06-13 00:17:52","2019-06-13 00:17:52");
INSERT INTO payments VALUES("202","ppr-20191019-032925","1","43","","","1","3290","710","Cash","","2019-10-19 05:29:25","2019-10-19 05:29:25");
INSERT INTO payments VALUES("203","spr-20191019-033028","1","","134","","1","2940","60","Cash","","2019-10-19 05:30:28","2019-10-19 05:30:28");
INSERT INTO payments VALUES("205","spr-20191103-114044","1","","139","","1","488","12","Cash","","2019-11-03 01:40:44","2019-11-03 01:40:44");
INSERT INTO payments VALUES("206","ppr-20191103-114222","1","46","","","1","200","0","Cash","","2019-11-03 01:42:22","2019-11-03 01:42:22");
INSERT INTO payments VALUES("211","spr-20191109-074131","1","","144","","1","1220","0","Cash","","2019-11-09 08:41:31","2019-11-09 08:41:31");
INSERT INTO payments VALUES("216","ppr-20191111-103911","1","49","","","1","5000","0","Cheque","","2019-11-10 23:39:11","2019-11-10 23:39:11");
INSERT INTO payments VALUES("217","spr-20191111-104008","1","","147","","1","2220","780","Cash","","2019-11-10 23:40:08","2019-11-10 23:40:08");
INSERT INTO payments VALUES("222","spr-20191203-115128","1","","163","","1","3","0","Cash","","2019-12-03 00:51:28","2019-12-03 00:51:28");
INSERT INTO payments VALUES("227","ppr-20191204-111124","1","57","","","1","220","280","Cash","","2019-12-04 12:11:24","2019-12-04 12:11:24");
INSERT INTO payments VALUES("228","spr-20191205-092712","1","","173","","1","621","0","Cash","","2019-12-04 22:27:12","2019-12-04 22:27:12");
INSERT INTO payments VALUES("239","spr-20191222-104058","1","","187","","1","288","212","Cash","","2019-12-21 23:40:58","2019-12-21 23:40:58");
INSERT INTO payments VALUES("241","spr-20191223-125946","1","","190","","1","1100","400","Cash","","2019-12-23 01:59:46","2019-12-23 01:59:46");
INSERT INTO payments VALUES("244","ppr-20200101-010750","1","61","","","1","60","0","Cash","","2020-01-01 02:07:50","2020-01-01 02:07:50");
INSERT INTO payments VALUES("246","spr-20200101-022028","1","","193","","1","1100","400","Cash","","2020-01-01 03:20:28","2020-01-01 03:20:28");
INSERT INTO payments VALUES("247","ppr-20200101-022131","1","59","","","1","6","0","Cash","","2020-01-01 03:21:31","2020-01-01 03:21:31");
INSERT INTO payments VALUES("248","ppr-20200101-022137","1","58","","","1","4","0","Cash","","2020-01-01 03:21:37","2020-01-01 03:21:37");
INSERT INTO payments VALUES("249","ppr-20200101-022144","1","56","","","1","2","0","Cash","","2020-01-01 03:21:44","2020-01-01 03:21:44");
INSERT INTO payments VALUES("250","ppr-20200101-022152","1","55","","","1","4","0","Cash","","2020-01-01 03:21:52","2020-01-01 03:21:52");
INSERT INTO payments VALUES("251","ppr-20200101-022225","1","49","","","1","2000","0","Cash","","2020-01-01 03:22:25","2020-01-01 03:22:25");
INSERT INTO payments VALUES("252","spr-20200102-043947","1","","194","","1","892","108","Cash","","2020-01-02 05:39:47","2020-01-02 05:39:47");
INSERT INTO payments VALUES("258","spr-20200203-035256","1","","201","","1","120","880","Cash","","2020-02-03 04:52:56","2020-02-03 04:52:56");
INSERT INTO payments VALUES("259","spr-20200204-105853","1","","202","","1","1400","100","Cash","","2020-02-04 11:58:53","2020-02-04 11:58:53");
INSERT INTO payments VALUES("260","ppr-20200204-110050","1","67","","","1","300","0","Cash","","2020-02-04 12:00:50","2020-02-04 12:00:50");
INSERT INTO payments VALUES("261","spr-20200302-115414","1","","203","","1","350","150","Cash","","2020-03-02 00:54:14","2020-03-02 00:54:14");
INSERT INTO payments VALUES("262","spr-20200302-115741","1","","204","","1","40","10","Cash","","2020-03-02 00:57:41","2020-03-02 00:57:41");
INSERT INTO payments VALUES("263","ppr-20200302-115811","1","70","","","1","50","0","Cash","","2020-03-02 00:58:11","2020-03-02 00:58:11");
INSERT INTO payments VALUES("264","ppr-20200302-115820","1","69","","","1","50","0","Cash","","2020-03-02 00:58:20","2020-03-02 00:58:20");
INSERT INTO payments VALUES("265","spr-20200311-044642","1","","205","","1","352","148","Cash","","2020-03-11 06:46:42","2020-03-11 06:46:42");
INSERT INTO payments VALUES("266","ppr-20200406-073823","1","71","","","1","2000","1000","Cash","First Payment","2020-04-06 09:38:23","2020-04-06 09:38:55");
INSERT INTO payments VALUES("267","spr-20200406-074024","1","","207","","1","500","500","Cash","","2020-04-06 09:40:24","2020-04-06 09:40:24");
INSERT INTO payments VALUES("268","spr-20200406-074201","1","","207","","1","144","56","Cash","","2020-04-06 09:42:01","2020-04-06 09:42:01");
INSERT INTO payments VALUES("269","spr-20200506-105950","1","","208","","1","1540","460","Cash","","2020-05-06 12:59:50","2020-05-06 12:59:50");
INSERT INTO payments VALUES("270","spr-20200609-124248","1","","209","","1","1220","780","Cash","","2020-06-09 02:42:48","2020-06-09 02:42:48");
INSERT INTO payments VALUES("273","spr-20200703-063914","1","","212","","1","2585","415","Cash","","2020-07-03 08:39:14","2020-07-03 08:39:14");
INSERT INTO payments VALUES("274","spr-20200712-095153","1","","213","","1","13","37","Cash","","2020-07-12 11:51:53","2020-07-12 11:51:53");
INSERT INTO payments VALUES("276","spr-20200727-083808","1","","217","","1","385","0","Cash","","2020-07-27 10:38:08","2020-07-27 10:38:08");
INSERT INTO payments VALUES("277","spr-20200727-084024","1","","218","","1","385","0","Cash","","2020-07-27 10:40:24","2020-07-27 10:40:24");
INSERT INTO payments VALUES("278","spr-20200727-084645","1","","219","","1","385","0","Cash","","2020-07-27 10:46:45","2020-07-27 10:46:45");
INSERT INTO payments VALUES("279","spr-20200812-062806","1","","220","","1","760","240","Cash","","2020-08-12 08:28:06","2020-08-12 08:28:06");
INSERT INTO payments VALUES("280","ppr-20200812-062853","1","62","","","1","1650","0","Cash","","2020-08-12 08:28:53","2020-08-12 08:28:53");
INSERT INTO payments VALUES("281","spr-20200812-063035","1","","221","","1","1100","0","Cash","","2020-08-12 08:30:35","2020-08-12 08:30:35");
INSERT INTO payments VALUES("282","spr-20200816-100426","1","","222","","1","23000","2000","Cash","","2020-08-16 12:04:26","2020-08-16 12:04:26");
INSERT INTO payments VALUES("283","spr-20200816-100523","1","","223","","1","300","200","Cash","","2020-08-16 12:05:23","2020-08-16 12:05:23");
INSERT INTO payments VALUES("284","spr-20200816-100632","1","","223","","1","100","0","Cash","","2020-08-16 12:06:32","2020-08-16 12:06:32");
INSERT INTO payments VALUES("285","spr-20200816-100735","1","","223","","1","40","0","Cash","","2020-08-16 12:07:35","2020-08-16 12:07:35");
INSERT INTO payments VALUES("290","spr-20201017-092854","9","","230","2","1","200","0","Cash","","2020-10-17 11:28:54","2020-10-18 00:48:54");
INSERT INTO payments VALUES("291","spr-20201018-105138","9","","230","2","1","50","0","Cash","","2020-10-18 00:51:38","2020-10-18 00:51:38");
INSERT INTO payments VALUES("292","spr-20201018-111333","9","","231","2","1","100","0","Cash","","2020-10-18 01:13:33","2020-10-18 01:13:33");
INSERT INTO payments VALUES("293","spr-20201018-111426","9","","231","2","1","50","0","Gift Card","","2020-10-18 01:14:26","2020-10-18 01:14:26");
INSERT INTO payments VALUES("294","spr-20201018-111651","9","","231","2","1","50","0","Credit Card","","2020-10-18 01:16:51","2020-10-18 01:16:51");
INSERT INTO payments VALUES("295","spr-20201018-111724","9","","231","2","1","50","0","Cheque","","2020-10-18 01:17:24","2020-10-18 01:17:24");
INSERT INTO payments VALUES("296","spr-20201022-013018","9","","232","2","1","100","0","Cash","","2020-10-22 03:30:18","2020-10-22 03:30:18");
INSERT INTO payments VALUES("297","spr-20201022-015606","1","","233","3","1","250","0","Cash","","2020-10-22 03:56:06","2020-10-22 03:56:06");
INSERT INTO payments VALUES("298","spr-20201024-070508","1","","234","4","1","11500","0","Cash","","2020-10-23 21:05:08","2020-10-23 21:05:08");
INSERT INTO payments VALUES("299","spr-20201024-070753","1","","235","4","1","250","0","Cash","","2020-10-23 21:07:53","2020-10-23 21:07:53");
INSERT INTO payments VALUES("300","spr-20201024-034619","1","","237","4","1","61900","0","Cash","","2020-10-24 05:46:19","2020-10-24 05:46:19");
INSERT INTO payments VALUES("302","spr-20201027-054004","1","","239","3","1","2","0","Cash","","2020-10-26 19:40:04","2020-10-26 19:40:04");
INSERT INTO payments VALUES("303","spr-20201027-054207","1","","240","3","1","6","0","Cash","","2020-10-26 19:42:07","2020-10-26 19:42:07");
INSERT INTO payments VALUES("304","spr-20201027-063202","1","","241","4","1","250","0","Cash","","2020-10-26 20:32:02","2020-10-26 20:32:02");
INSERT INTO payments VALUES("305","spr-20201029-073033","1","","242","4","1","250","0","Cash","","2020-10-28 21:30:33","2020-10-28 21:30:33");
INSERT INTO payments VALUES("306","spr-20201101-072115","1","","243","4","1","250","0","Cash","","2020-10-31 21:21:15","2020-10-31 21:21:15");
INSERT INTO payments VALUES("307","spr-20201101-074225","1","","245","3","1","1130","0","Cash","","2020-10-31 21:42:25","2020-10-31 21:42:25");
INSERT INTO payments VALUES("308","spr-20201101-075019","1","","246","4","1","440","0","Cash","","2020-10-31 21:50:19","2020-10-31 21:50:19");
INSERT INTO payments VALUES("310","spr-20201106-013042","1","","250","4","1","378.4","0","Cash","","2020-11-06 02:30:42","2020-11-06 02:30:42");
INSERT INTO payments VALUES("311","spr-20201109-011527","1","","251","4","1","500","0","Cash","","2020-11-09 02:15:27","2020-11-09 02:15:27");
INSERT INTO payments VALUES("312","spr-20201111-055902","1","","252","3","1","229.5","0","Cash","","2020-11-10 18:59:02","2020-11-10 18:59:02");
INSERT INTO payments VALUES("313","spr-20201114-064739","1","","253","4","1","10242.5","0","Cash","","2020-11-13 19:47:39","2020-11-13 19:47:39");
INSERT INTO payments VALUES("316","spr-20201117-064751","1","","256","4","1","715","0","Cash","","2020-11-16 19:47:51","2020-11-16 19:47:51");
INSERT INTO payments VALUES("317","spr-20201117-070920","1","","257","4","1","250","0","Cash","","2020-11-16 20:09:20","2020-11-16 20:09:20");
INSERT INTO payments VALUES("320","ppr-20201118-062036","1","90","","","1","33000","0","Cash","","2020-11-17 19:20:36","2020-11-17 19:20:36");
INSERT INTO payments VALUES("321","spr-20201118-065242","1","","258","4","1","27200","0","Cash","","2020-11-17 19:52:42","2020-11-17 19:52:42");
INSERT INTO payments VALUES("324","spr-20201208-094000","1","","263","4","1","300","200","Cash","","2020-12-07 22:40:00","2020-12-07 22:40:00");
INSERT INTO payments VALUES("325","spr-20210106-022350","1","","263","4","1","50","0","Cash","","2021-01-06 03:23:50","2021-01-06 03:23:50");
INSERT INTO payments VALUES("330","spr-20210111-021625","1","","271","3","1","1274","0","Cash","","2021-01-11 03:16:25","2021-01-11 03:16:25");
INSERT INTO payments VALUES("332","spr-20210113-070243","1","","274","4","1","1556","0","Cash","","2021-01-12 20:02:43","2021-01-12 20:02:43");
INSERT INTO payments VALUES("333","spr-20210201-023748","1","","275","4","1","484","0","Cash","","2021-02-01 03:37:48","2021-02-01 03:37:48");
INSERT INTO payments VALUES("335","spr-20210216-070948","1","","277","4","1","15156","0","Cash","","2021-02-15 20:09:48","2021-02-15 20:09:48");
INSERT INTO payments VALUES("336","spr-20210217-073238","1","","278","4","1","26949.9","0","Cash","","2021-02-16 20:32:38","2021-02-16 20:32:38");
INSERT INTO payments VALUES("338","spr-20210524-074506","1","","290","3","1","250","0","Cash","","2021-05-24 09:45:06","2021-05-24 09:45:06");
INSERT INTO payments VALUES("339","spr-20210524-074647","1","","290","3","1","-130","0","Cash","","2021-05-24 09:46:47","2021-05-24 09:46:47");
INSERT INTO payments VALUES("341","spr-20211016-035124","1","","294","3","1","750","250","Cash","","2021-10-16 15:51:24","2021-10-16 15:51:24");
INSERT INTO payments VALUES("342","spr-20211016-035233","1","","294","3","1","750","0","Cash","","2021-10-16 15:52:33","2021-10-16 15:52:33");
INSERT INTO payments VALUES("343","spr-20211016-035454","1","","295","4","1","2200","0","Cash","","2021-10-16 15:54:54","2021-10-16 15:54:54");
INSERT INTO payments VALUES("344","spr-20211219-112641","1","","296","4","1","440","60","Cash","","2021-12-19 11:26:41","2021-12-19 11:26:41");
INSERT INTO payments VALUES("345","spr-20211219-024746","1","","297","3","1","5475","0","Credit Card","","2021-12-19 14:47:46","2021-12-19 14:47:46");
INSERT INTO payments VALUES("346","spr-20220205-070121","1","","298","3","1","414.9","0","Cash","","2022-02-05 19:01:21","2022-02-05 19:01:21");
INSERT INTO payments VALUES("347","ppr-20220205-070451","1","129","","","1","80000","8000","Cash","","2022-02-05 19:04:51","2022-02-05 19:04:51");
INSERT INTO payments VALUES("348","spr-20220303-123331","29","","300","5","1","450","50","Cash","","2022-03-03 00:33:31","2022-03-03 00:33:31");
INSERT INTO payments VALUES("349","spr-20220303-123501","29","","301","5","1","1580","20","Cash","","2022-03-03 00:35:01","2022-03-03 00:35:01");
INSERT INTO payments VALUES("350","spr-20220303-083006","29","","302","5","1","800","200","Cash","","2022-03-03 20:30:06","2022-03-03 20:30:06");
INSERT INTO payments VALUES("351","spr-20220304-052937","29","","303","5","1","875","0","Cash","","2022-03-04 17:29:37","2022-03-04 17:29:37");
INSERT INTO payments VALUES("352","spr-20220305-120209","29","","305","5","1","236","0","Cash","","2022-03-05 12:02:09","2022-03-05 12:02:09");
INSERT INTO payments VALUES("353","spr-20220307-094015","29","","307","6","1","5600","400","Cash","","2022-03-07 09:40:15","2022-03-07 09:40:15");
INSERT INTO payments VALUES("354","spr-20220307-094217","29","","307","6","1","2000","0","Cash","","2022-03-07 09:42:17","2022-03-07 09:42:17");
INSERT INTO payments VALUES("355","spr-20220307-120704","29","","308","6","1","2600","13000","Cash","","2022-03-07 12:07:04","2022-03-07 12:07:04");
INSERT INTO payments VALUES("356","spr-20220307-121321","29","","309","6","3","1500","10000","Cash","","2022-03-07 12:13:21","2022-03-07 12:13:21");
INSERT INTO payments VALUES("357","spr-20220316-013429","29","","310","6","1","222","28","Cash","","2022-03-16 13:34:29","2022-03-16 13:34:29");
INSERT INTO payments VALUES("358","ppr-20220521-110922","1","136","","","1","3000","2000","Cash","","2022-05-21 23:09:22","2022-05-21 23:09:22");
INSERT INTO payments VALUES("359","spr-20220521-111201","1","","312","7","1","1200","800","Cash","","2022-05-21 23:12:01","2022-05-21 23:12:01");
INSERT INTO payments VALUES("365","spr-20221222-114615","1","","318","3","1","1820","0","Cash","","2022-12-22 11:46:15","2022-12-22 11:46:15");
INSERT INTO payments VALUES("367","spr-20230720-040200","29","","319","6","1","11550","0","Cash","","2023-07-20 16:02:00","2023-07-20 16:02:00");
INSERT INTO payments VALUES("369","spr-20230727-015012","29","","320","6","1","200000","0","Cash","","2023-07-27 01:50:12","2023-07-27 01:50:12");
INSERT INTO payments VALUES("370","spr-20230907-121210","1","","322","3","1","1620","0","Cash","","2023-09-07 12:12:10","2023-09-07 12:12:10");
INSERT INTO payments VALUES("371","spr-20230919-084115","1","","325","3","1","2910","0","Cash","","2023-09-19 20:41:15","2023-09-19 20:41:15");
INSERT INTO payments VALUES("373","spr-20230920-040203","29","","326","6","4","600","0","Cash","Test","2023-09-20 16:02:03","2023-09-20 16:02:03");
INSERT INTO payments VALUES("374","spr-20230920-040817","29","","327","6","4","360","140","Cash","Test","2023-09-20 16:08:17","2023-09-20 16:08:17");
INSERT INTO payments VALUES("375","spr-20230920-040952","29","","328","6","4","120","0","Cash","Test","2023-09-20 16:09:52","2023-09-20 16:09:52");
INSERT INTO payments VALUES("376","spr-20230920-041118","29","","329","6","4","120","0","Credit Card","Test","2023-09-20 16:11:18","2023-09-20 16:11:18");
INSERT INTO payments VALUES("377","spr-20230920-041311","29","","330","6","4","300","0","Cash","Test","2023-09-20 16:13:11","2023-09-20 16:13:11");
INSERT INTO payments VALUES("378","spr-20230920-041424","29","","330","6","4","300","0","Cash","Test","2023-09-20 16:14:24","2023-09-20 16:14:24");
INSERT INTO payments VALUES("379","spr-20230920-042157","29","","331","6","4","500","100","Cash","Test","2023-09-20 16:21:57","2023-09-20 16:21:57");
INSERT INTO payments VALUES("380","spr-20230920-042433","29","","332","6","4","396","4","Cash","Test","2023-09-20 16:24:33","2023-09-20 16:24:33");
INSERT INTO payments VALUES("381","spr-20230920-043443","29","","333","6","4","235","0","Cash","","2023-09-20 16:34:43","2023-09-20 16:34:43");
INSERT INTO payments VALUES("382","spr-20230920-043627","29","","334","6","4","650","50","Cheque","Test","2023-09-20 16:36:27","2023-09-20 16:36:27");
INSERT INTO payments VALUES("383","spr-20230920-044029","29","","331","6","4","100","0","Cash","","2023-09-20 16:40:29","2023-09-20 16:40:29");
INSERT INTO payments VALUES("384","spr-20230920-044738","29","","335","6","4","550","0","Cash","650.00","2023-09-20 16:47:38","2023-09-20 16:47:38");
INSERT INTO payments VALUES("385","spr-20230921-075831","29","","336","6","4","2200","0","Cash","","2023-09-21 19:58:31","2023-09-21 19:58:31");
INSERT INTO payments VALUES("386","spr-20230926-084913","29","","337","6","4","1140","0","Cash","","2023-09-26 20:49:13","2023-09-26 20:49:13");
INSERT INTO payments VALUES("387","ppr-20231029-040427","29","146","","","5","17500","0","Cash","","2023-10-29 16:04:27","2023-10-29 16:04:27");
INSERT INTO payments VALUES("388","ppr-20231029-043140","29","150","","","1","15300","0","Cash","","2023-10-29 16:31:40","2023-10-29 16:31:40");
INSERT INTO payments VALUES("389","ppr-20231029-043315","29","151","","","1","5000","0","Cash","","2023-10-29 16:33:15","2023-10-29 16:33:15");
INSERT INTO payments VALUES("390","spr-20231029-044725","33","","338","","1","400","0","Cash","","2023-10-29 16:47:25","2023-10-29 16:47:25");
INSERT INTO payments VALUES("391","spr-20231029-044823","33","","339","","1","350","50","Cash","","2023-10-29 16:48:23","2023-10-29 16:48:23");
INSERT INTO payments VALUES("392","spr-20231029-044925","33","","340","","1","70","0","Cash","","2023-10-29 16:49:25","2023-10-29 16:49:25");
INSERT INTO payments VALUES("393","spr-20231030-064604","29","","341","6","1","2780","0","Cash","","2023-10-30 18:46:04","2023-10-30 18:46:04");
INSERT INTO payments VALUES("394","spr-20231113-062211","29","","343","6","1","500","0","Cash","","2023-11-13 18:22:11","2023-11-13 18:22:11");
INSERT INTO payments VALUES("395","ppr-20231123-060012","29","154","","","4","420000","0","Cash","","2023-11-23 18:00:12","2023-11-23 18:00:12");
INSERT INTO payments VALUES("396","ppr-20231126-021530","29","156","","","1","2690990","0","Cash","","2023-11-26 14:15:30","2023-11-26 14:15:30");
INSERT INTO payments VALUES("397","spr-20231126-022238","29","","344","6","1","6535","0","Cash","","2023-11-26 14:22:38","2023-11-26 14:22:38");
INSERT INTO payments VALUES("398","spr-20231126-022359","29","","345","6","1","85460","0","Cash","","2023-11-26 14:23:59","2023-11-26 14:23:59");
INSERT INTO payments VALUES("399","spr-20231203-034919","32","","346","","1","50000","0","Cash","","2023-12-03 15:49:19","2023-12-03 15:49:19");
INSERT INTO payments VALUES("400","spr-20231203-040433","32","","347","","1","400","0","Deposit","","2023-12-03 16:04:33","2023-12-03 16:04:33");
INSERT INTO payments VALUES("401","spr-20231203-041419","32","","347","","1","-20","0","Cash","","2023-12-03 16:14:19","2023-12-03 16:14:19");
INSERT INTO payments VALUES("402","spr-20231212-050738","32","","350","","1","30700","0","Cash","","2023-12-12 17:07:38","2023-12-12 17:07:38");



CREATE TABLE `payrolls` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(191) NOT NULL,
  `employee_id` int(11) NOT NULL,
  `account_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `amount` double NOT NULL,
  `paying_method` varchar(191) NOT NULL,
  `note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO payrolls VALUES("8","payroll-20190101-055231","1","1","1","100","0","","2018-12-31 18:52:31","2018-12-31 18:52:31");
INSERT INTO payrolls VALUES("9","payroll-20191204-113802","1","1","1","10000","0","","2019-12-04 12:38:02","2019-12-04 12:38:02");



CREATE TABLE `permissions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `guard_name` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=105 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO permissions VALUES("4","products-edit","web","2018-06-02 21:00:09","2018-06-02 21:00:09");
INSERT INTO permissions VALUES("5","products-delete","web","2018-06-03 18:54:22","2018-06-03 18:54:22");
INSERT INTO permissions VALUES("6","products-add","web","2018-06-03 20:34:14","2018-06-03 20:34:14");
INSERT INTO permissions VALUES("7","products-index","web","2018-06-03 23:34:27","2018-06-03 23:34:27");
INSERT INTO permissions VALUES("8","purchases-index","web","2018-06-04 04:03:19","2018-06-04 04:03:19");
INSERT INTO permissions VALUES("9","purchases-add","web","2018-06-04 04:12:25","2018-06-04 04:12:25");
INSERT INTO permissions VALUES("10","purchases-edit","web","2018-06-04 05:47:36","2018-06-04 05:47:36");
INSERT INTO permissions VALUES("11","purchases-delete","web","2018-06-04 05:47:36","2018-06-04 05:47:36");
INSERT INTO permissions VALUES("12","sales-index","web","2018-06-04 06:49:08","2018-06-04 06:49:08");
INSERT INTO permissions VALUES("13","sales-add","web","2018-06-04 06:49:52","2018-06-04 06:49:52");
INSERT INTO permissions VALUES("14","sales-edit","web","2018-06-04 06:49:52","2018-06-04 06:49:52");
INSERT INTO permissions VALUES("15","sales-delete","web","2018-06-04 06:49:53","2018-06-04 06:49:53");
INSERT INTO permissions VALUES("16","quotes-index","web","2018-06-04 18:05:10","2018-06-04 18:05:10");
INSERT INTO permissions VALUES("17","quotes-add","web","2018-06-04 18:05:10","2018-06-04 18:05:10");
INSERT INTO permissions VALUES("18","quotes-edit","web","2018-06-04 18:05:10","2018-06-04 18:05:10");
INSERT INTO permissions VALUES("19","quotes-delete","web","2018-06-04 18:05:10","2018-06-04 18:05:10");
INSERT INTO permissions VALUES("20","transfers-index","web","2018-06-04 18:30:03","2018-06-04 18:30:03");
INSERT INTO permissions VALUES("21","transfers-add","web","2018-06-04 18:30:03","2018-06-04 18:30:03");
INSERT INTO permissions VALUES("22","transfers-edit","web","2018-06-04 18:30:03","2018-06-04 18:30:03");
INSERT INTO permissions VALUES("23","transfers-delete","web","2018-06-04 18:30:03","2018-06-04 18:30:03");
INSERT INTO permissions VALUES("24","returns-index","web","2018-06-04 18:50:24","2018-06-04 18:50:24");
INSERT INTO permissions VALUES("25","returns-add","web","2018-06-04 18:50:24","2018-06-04 18:50:24");
INSERT INTO permissions VALUES("26","returns-edit","web","2018-06-04 18:50:25","2018-06-04 18:50:25");
INSERT INTO permissions VALUES("27","returns-delete","web","2018-06-04 18:50:25","2018-06-04 18:50:25");
INSERT INTO permissions VALUES("28","customers-index","web","2018-06-04 19:15:54","2018-06-04 19:15:54");
INSERT INTO permissions VALUES("29","customers-add","web","2018-06-04 19:15:55","2018-06-04 19:15:55");
INSERT INTO permissions VALUES("30","customers-edit","web","2018-06-04 19:15:55","2018-06-04 19:15:55");
INSERT INTO permissions VALUES("31","customers-delete","web","2018-06-04 19:15:55","2018-06-04 19:15:55");
INSERT INTO permissions VALUES("32","suppliers-index","web","2018-06-04 19:40:12","2018-06-04 19:40:12");
INSERT INTO permissions VALUES("33","suppliers-add","web","2018-06-04 19:40:12","2018-06-04 19:40:12");
INSERT INTO permissions VALUES("34","suppliers-edit","web","2018-06-04 19:40:12","2018-06-04 19:40:12");
INSERT INTO permissions VALUES("35","suppliers-delete","web","2018-06-04 19:40:12","2018-06-04 19:40:12");
INSERT INTO permissions VALUES("36","product-report","web","2018-06-24 19:05:33","2018-06-24 19:05:33");
INSERT INTO permissions VALUES("37","purchase-report","web","2018-06-24 19:24:56","2018-06-24 19:24:56");
INSERT INTO permissions VALUES("38","sale-report","web","2018-06-24 19:33:13","2018-06-24 19:33:13");
INSERT INTO permissions VALUES("39","customer-report","web","2018-06-24 19:36:51","2018-06-24 19:36:51");
INSERT INTO permissions VALUES("40","due-report","web","2018-06-24 19:39:52","2018-06-24 19:39:52");
INSERT INTO permissions VALUES("41","users-index","web","2018-06-24 20:00:10","2018-06-24 20:00:10");
INSERT INTO permissions VALUES("42","users-add","web","2018-06-24 20:00:10","2018-06-24 20:00:10");
INSERT INTO permissions VALUES("43","users-edit","web","2018-06-24 20:01:30","2018-06-24 20:01:30");
INSERT INTO permissions VALUES("44","users-delete","web","2018-06-24 20:01:30","2018-06-24 20:01:30");
INSERT INTO permissions VALUES("45","profit-loss","web","2018-07-14 17:50:05","2018-07-14 17:50:05");
INSERT INTO permissions VALUES("46","best-seller","web","2018-07-14 18:01:38","2018-07-14 18:01:38");
INSERT INTO permissions VALUES("47","daily-sale","web","2018-07-14 18:24:21","2018-07-14 18:24:21");
INSERT INTO permissions VALUES("48","monthly-sale","web","2018-07-14 18:30:41","2018-07-14 18:30:41");
INSERT INTO permissions VALUES("49","daily-purchase","web","2018-07-14 18:36:46","2018-07-14 18:36:46");
INSERT INTO permissions VALUES("50","monthly-purchase","web","2018-07-14 18:48:17","2018-07-14 18:48:17");
INSERT INTO permissions VALUES("51","payment-report","web","2018-07-14 19:10:41","2018-07-14 19:10:41");
INSERT INTO permissions VALUES("52","warehouse-stock-report","web","2018-07-14 19:16:55","2018-07-14 19:16:55");
INSERT INTO permissions VALUES("53","product-qty-alert","web","2018-07-14 19:33:21","2018-07-14 19:33:21");
INSERT INTO permissions VALUES("54","supplier-report","web","2018-07-29 23:00:01","2018-07-29 23:00:01");
INSERT INTO permissions VALUES("55","expenses-index","web","2018-09-04 21:07:10","2018-09-04 21:07:10");
INSERT INTO permissions VALUES("56","expenses-add","web","2018-09-04 21:07:10","2018-09-04 21:07:10");
INSERT INTO permissions VALUES("57","expenses-edit","web","2018-09-04 21:07:10","2018-09-04 21:07:10");
INSERT INTO permissions VALUES("58","expenses-delete","web","2018-09-04 21:07:11","2018-09-04 21:07:11");
INSERT INTO permissions VALUES("59","general_setting","web","2018-10-19 19:10:04","2018-10-19 19:10:04");
INSERT INTO permissions VALUES("60","mail_setting","web","2018-10-19 19:10:04","2018-10-19 19:10:04");
INSERT INTO permissions VALUES("61","pos_setting","web","2018-10-19 19:10:04","2018-10-19 19:10:04");
INSERT INTO permissions VALUES("62","hrm_setting","web","2019-01-02 05:30:23","2019-01-02 05:30:23");
INSERT INTO permissions VALUES("63","purchase-return-index","web","2019-01-02 16:45:14","2019-01-02 16:45:14");
INSERT INTO permissions VALUES("64","purchase-return-add","web","2019-01-02 16:45:14","2019-01-02 16:45:14");
INSERT INTO permissions VALUES("65","purchase-return-edit","web","2019-01-02 16:45:14","2019-01-02 16:45:14");
INSERT INTO permissions VALUES("66","purchase-return-delete","web","2019-01-02 16:45:14","2019-01-02 16:45:14");
INSERT INTO permissions VALUES("67","account-index","web","2019-01-02 17:06:13","2019-01-02 17:06:13");
INSERT INTO permissions VALUES("68","balance-sheet","web","2019-01-02 17:06:14","2019-01-02 17:06:14");
INSERT INTO permissions VALUES("69","account-statement","web","2019-01-02 17:06:14","2019-01-02 17:06:14");
INSERT INTO permissions VALUES("70","department","web","2019-01-02 17:30:01","2019-01-02 17:30:01");
INSERT INTO permissions VALUES("71","attendance","web","2019-01-02 17:30:01","2019-01-02 17:30:01");
INSERT INTO permissions VALUES("72","payroll","web","2019-01-02 17:30:01","2019-01-02 17:30:01");
INSERT INTO permissions VALUES("73","employees-index","web","2019-01-02 17:52:19","2019-01-02 17:52:19");
INSERT INTO permissions VALUES("74","employees-add","web","2019-01-02 17:52:19","2019-01-02 17:52:19");
INSERT INTO permissions VALUES("75","employees-edit","web","2019-01-02 17:52:19","2019-01-02 17:52:19");
INSERT INTO permissions VALUES("76","employees-delete","web","2019-01-02 17:52:19","2019-01-02 17:52:19");
INSERT INTO permissions VALUES("77","user-report","web","2019-01-16 01:48:18","2019-01-16 01:48:18");
INSERT INTO permissions VALUES("78","stock_count","web","2019-02-17 05:32:01","2019-02-17 05:32:01");
INSERT INTO permissions VALUES("79","adjustment","web","2019-02-17 05:32:02","2019-02-17 05:32:02");
INSERT INTO permissions VALUES("80","sms_setting","web","2019-02-22 00:18:03","2019-02-22 00:18:03");
INSERT INTO permissions VALUES("81","create_sms","web","2019-02-22 00:18:03","2019-02-22 00:18:03");
INSERT INTO permissions VALUES("82","print_barcode","web","2019-03-07 00:02:19","2019-03-07 00:02:19");
INSERT INTO permissions VALUES("83","empty_database","web","2019-03-07 00:02:19","2019-03-07 00:02:19");
INSERT INTO permissions VALUES("84","customer_group","web","2019-03-07 00:37:15","2019-03-07 00:37:15");
INSERT INTO permissions VALUES("85","unit","web","2019-03-07 00:37:15","2019-03-07 00:37:15");
INSERT INTO permissions VALUES("86","tax","web","2019-03-07 00:37:15","2019-03-07 00:37:15");
INSERT INTO permissions VALUES("87","gift_card","web","2019-03-07 01:29:38","2019-03-07 01:29:38");
INSERT INTO permissions VALUES("88","coupon","web","2019-03-07 01:29:38","2019-03-07 01:29:38");
INSERT INTO permissions VALUES("89","holiday","web","2019-10-19 04:57:15","2019-10-19 04:57:15");
INSERT INTO permissions VALUES("90","warehouse-report","web","2019-10-22 02:00:23","2019-10-22 02:00:23");
INSERT INTO permissions VALUES("91","warehouse","web","2020-02-26 01:47:32","2020-02-26 01:47:32");
INSERT INTO permissions VALUES("92","brand","web","2020-02-26 01:59:59","2020-02-26 01:59:59");
INSERT INTO permissions VALUES("93","billers-index","web","2020-02-26 02:11:15","2020-02-26 02:11:15");
INSERT INTO permissions VALUES("94","billers-add","web","2020-02-26 02:11:15","2020-02-26 02:11:15");
INSERT INTO permissions VALUES("95","billers-edit","web","2020-02-26 02:11:15","2020-02-26 02:11:15");
INSERT INTO permissions VALUES("96","billers-delete","web","2020-02-26 02:11:15","2020-02-26 02:11:15");
INSERT INTO permissions VALUES("97","money-transfer","web","2020-03-02 00:41:48","2020-03-02 00:41:48");
INSERT INTO permissions VALUES("98","category","web","2020-07-13 08:13:16","2020-07-13 08:13:16");
INSERT INTO permissions VALUES("99","delivery","web","2020-07-13 08:13:16","2020-07-13 08:13:16");
INSERT INTO permissions VALUES("100","send_notification","web","2020-10-31 02:21:31","2020-10-31 02:21:31");
INSERT INTO permissions VALUES("101","today_sale","web","2020-10-31 02:57:04","2020-10-31 02:57:04");
INSERT INTO permissions VALUES("102","today_profit","web","2020-10-31 02:57:04","2020-10-31 02:57:04");
INSERT INTO permissions VALUES("103","currency","web","2020-11-08 19:23:11","2020-11-08 19:23:11");
INSERT INTO permissions VALUES("104","backup_database","web","2020-11-14 19:16:55","2020-11-14 19:16:55");



CREATE TABLE `pos_setting` (
  `id` int(11) NOT NULL,
  `customer_id` int(11) NOT NULL,
  `warehouse_id` int(11) NOT NULL,
  `biller_id` int(11) NOT NULL,
  `product_number` int(11) NOT NULL,
  `keybord_active` tinyint(1) NOT NULL,
  `stripe_public_key` varchar(191) DEFAULT NULL,
  `stripe_secret_key` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  UNIQUE KEY `pos_setting_id_unique` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO pos_setting VALUES("1","11","8","9","4","0","pk_test_ITN7KOYiIsHSCQ0UMRcgaYUB","sk_test_TtQQaawhEYRwa3mU9CzttrEy","2018-09-01 23:17:04","2022-03-07 15:51:41");



CREATE TABLE `product_adjustments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `adjustment_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `variant_id` int(11) DEFAULT NULL,
  `qty` double NOT NULL,
  `action` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




CREATE TABLE `product_batches` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int(11) NOT NULL,
  `batch_no` varchar(191) NOT NULL,
  `expired_date` date NOT NULL,
  `qty` double NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO product_batches VALUES("1","71","1001","2023-05-31","28","2021-03-07 03:14:05","2021-05-30 03:41:19");
INSERT INTO product_batches VALUES("2","71","1002","2023-05-31","7","2021-03-07 03:55:06","2021-05-30 03:33:04");
INSERT INTO product_batches VALUES("3","71","1003","2023-08-31","0","2021-03-09 04:42:13","2021-05-22 03:28:15");
INSERT INTO product_batches VALUES("4","151","001","2024-06-30","490","2023-10-29 15:54:18","2023-10-29 16:47:25");



CREATE TABLE `product_purchases` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `purchase_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `product_batch_id` int(11) DEFAULT NULL,
  `variant_id` int(11) DEFAULT NULL,
  `qty` double NOT NULL,
  `recieved` double NOT NULL,
  `purchase_unit_id` int(11) NOT NULL,
  `net_unit_cost` double NOT NULL,
  `discount` double NOT NULL,
  `tax_rate` double NOT NULL,
  `tax` double NOT NULL,
  `total` double NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=374 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO product_purchases VALUES("59","12","4","","","200","200","1","1","0","0","0","200","2018-08-08 19:48:36","2018-08-08 19:48:36");
INSERT INTO product_purchases VALUES("60","12","5","","","100","100","1","100","0","0","0","10000","2018-08-08 19:48:36","2018-08-08 19:48:36");
INSERT INTO product_purchases VALUES("66","13","2","","","100","100","3","166.96","0","15","2504.35","19200","2018-08-08 19:49:55","2018-08-08 19:49:55");
INSERT INTO product_purchases VALUES("67","13","3","","","100","100","1","200","0","0","0","20000","2018-08-08 19:49:55","2018-08-08 19:49:55");
INSERT INTO product_purchases VALUES("68","13","1","","","150","150","1","320","0","10","4800","52800","2018-08-08 19:49:55","2018-08-08 19:49:55");
INSERT INTO product_purchases VALUES("69","13","10","","","60","60","7","10","0","0","0","600","2018-08-08 19:49:55","2018-08-08 19:49:55");
INSERT INTO product_purchases VALUES("70","14","1","","","100","100","1","320","0","10","3200","35200","2018-08-09 03:23:48","2018-08-09 03:23:48");
INSERT INTO product_purchases VALUES("71","14","2","","","50","50","3","166.96","0","15","1252.17","9600","2018-08-09 03:23:48","2018-08-09 03:23:48");
INSERT INTO product_purchases VALUES("72","14","3","","","100","100","1","200","0","0","0","20000","2018-08-09 03:23:49","2018-08-09 03:23:49");
INSERT INTO product_purchases VALUES("73","14","5","","","100","100","1","100","0","0","0","10000","2018-08-09 03:23:49","2018-08-09 03:23:49");
INSERT INTO product_purchases VALUES("74","14","10","","","50","50","7","10","0","0","0","500","2018-08-09 03:23:49","2018-08-09 03:23:49");
INSERT INTO product_purchases VALUES("76","15","22","","","20","20","1","800","0","10","1600","17600","2018-09-03 00:06:46","2018-09-03 00:06:46");
INSERT INTO product_purchases VALUES("87","16","22","","","20","20","1","800","0","10","1600","17600","2018-09-20 05:09:12","2018-09-20 05:09:12");
INSERT INTO product_purchases VALUES("89","18","4","","","50","50","1","1","0","0","0","50","2018-10-22 06:26:25","2018-10-22 06:26:25");
INSERT INTO product_purchases VALUES("90","19","4","","","50","50","1","1","0","0","0","50","2018-10-22 06:26:52","2018-10-22 06:26:52");
INSERT INTO product_purchases VALUES("91","20","25","","","15","15","1","500","0","10","750","8250","2018-10-22 21:14:21","2018-10-22 21:14:21");
INSERT INTO product_purchases VALUES("93","21","25","","","15","15","1","500","0","10","750","8250","2018-10-22 21:14:58","2018-10-22 21:14:58");
INSERT INTO product_purchases VALUES("94","22","22","","","5","5","1","800","0","10","400","4400","2018-10-31 18:59:03","2018-10-31 18:59:03");
INSERT INTO product_purchases VALUES("96","23","22","","","5","5","1","800","0","10","400","4400","2018-11-02 23:23:52","2018-11-02 23:23:52");
INSERT INTO product_purchases VALUES("97","24","22","","","15","15","1","800","0","10","1200","13200","2018-11-04 22:18:19","2018-11-04 22:18:19");
INSERT INTO product_purchases VALUES("98","24","25","","","5","5","1","500","0","10","250","2750","2018-11-04 22:18:19","2018-11-04 22:18:19");
INSERT INTO product_purchases VALUES("99","25","31","","","15","15","1","250","0","0","0","3750","2018-12-04 18:34:30","2018-12-04 18:34:30");
INSERT INTO product_purchases VALUES("100","25","30","","","15","15","1","50","0","0","0","750","2018-12-04 18:34:30","2018-12-04 18:34:30");
INSERT INTO product_purchases VALUES("101","26","31","","","15","15","1","250","0","0","0","3750","2018-12-04 18:35:08","2018-12-04 18:35:08");
INSERT INTO product_purchases VALUES("102","26","30","","","15","15","1","50","0","0","0","750","2018-12-04 18:35:08","2018-12-04 18:35:08");
INSERT INTO product_purchases VALUES("104","27","32","","","10","10","1","1","0","0","0","10","2018-12-18 18:57:41","2018-12-18 18:57:41");
INSERT INTO product_purchases VALUES("112","33","33","","","10","10","1","1","0","0","0","10","2018-12-23 22:04:21","2018-12-23 22:04:21");
INSERT INTO product_purchases VALUES("113","34","25","","","2","2","1","500","0","10","100","1100","2019-01-02 20:01:24","2019-01-02 20:01:24");
INSERT INTO product_purchases VALUES("114","34","22","","","2","2","1","800","0","10","160","1760","2019-01-02 20:01:24","2019-01-02 20:01:24");
INSERT INTO product_purchases VALUES("115","35","31","","","2","2","1","250","0","0","0","500","2019-01-28 22:54:48","2019-01-28 22:54:48");
INSERT INTO product_purchases VALUES("116","35","30","","","2","2","1","50","0","0","0","100","2019-01-28 22:54:48","2019-01-28 22:54:48");
INSERT INTO product_purchases VALUES("117","36","30","","","3","3","1","50","0","0","0","150","2019-01-28 22:55:58","2019-01-28 22:55:58");
INSERT INTO product_purchases VALUES("118","36","31","","","2","2","1","250","0","0","0","500","2019-01-28 22:55:58","2019-01-28 22:55:58");
INSERT INTO product_purchases VALUES("121","39","1","","","2","2","1","315","10","10","63","693","2019-02-08 23:44:13","2019-02-08 23:44:13");
INSERT INTO product_purchases VALUES("122","39","2","","","1","1","3","192","0","0","0","192","2019-02-08 23:44:13","2019-02-08 23:44:13");
INSERT INTO product_purchases VALUES("123","38","32","","","10","10","1","1","0","0","0","10","2019-02-08 23:45:24","2019-02-08 23:45:24");
INSERT INTO product_purchases VALUES("124","38","25","","","3","3","1","500","0","10","150","1650","2019-02-08 23:45:24","2019-02-08 23:45:24");
INSERT INTO product_purchases VALUES("125","37","33","","","10","10","1","1","0","0","0","10","2019-02-08 23:46:22","2019-02-08 23:46:22");
INSERT INTO product_purchases VALUES("126","37","25","","","2","2","1","500","0","10","100","1100","2019-02-08 23:46:23","2019-02-08 23:46:23");
INSERT INTO product_purchases VALUES("127","37","22","","","6","6","1","800","0","10","480","5280","2019-02-08 23:46:23","2019-02-08 23:46:23");
INSERT INTO product_purchases VALUES("128","40","33","","","10","10","1","10","0","0","0","100","2019-03-02 23:39:17","2019-03-02 23:39:17");
INSERT INTO product_purchases VALUES("129","41","33","","","5","5","1","10","0","0","0","50","2019-03-02 23:43:58","2019-03-02 23:43:58");
INSERT INTO product_purchases VALUES("130","41","1","","","10","10","1","320","0","10","320","3520","2019-03-02 23:43:59","2019-03-02 23:43:59");
INSERT INTO product_purchases VALUES("133","42","30","","","1","1","1","50","0","0","0","50","2019-04-13 09:50:08","2019-04-13 09:50:08");
INSERT INTO product_purchases VALUES("134","42","31","","","1","1","1","250","0","0","0","250","2019-04-13 09:50:08","2019-04-13 09:50:08");
INSERT INTO product_purchases VALUES("135","43","25","","","3","3","1","500","0","10","150","1650","2019-06-13 00:16:00","2019-06-13 00:16:00");
INSERT INTO product_purchases VALUES("136","43","22","","","3","3","1","800","0","10","240","2640","2019-06-13 00:16:01","2019-06-13 00:16:01");
INSERT INTO product_purchases VALUES("137","44","25","","","1","1","1","500","0","10","50","550","2019-10-19 05:31:19","2019-10-19 05:31:19");
INSERT INTO product_purchases VALUES("138","44","22","","","1","1","1","800","0","10","80","880","2019-10-19 05:31:20","2019-10-19 05:31:20");
INSERT INTO product_purchases VALUES("140","46","33","","","10","10","1","10","0","0","0","100","2019-11-03 01:39:49","2019-11-03 01:39:49");
INSERT INTO product_purchases VALUES("141","46","32","","","10","10","1","5","0","0","0","50","2019-11-03 01:39:49","2019-11-03 01:39:49");
INSERT INTO product_purchases VALUES("142","47","1","","","2","2","1","315","10","10","63","693","2019-11-09 00:25:10","2019-11-09 00:25:10");
INSERT INTO product_purchases VALUES("143","47","2","","","1","1","3","192","0","0","0","192","2019-11-09 00:25:10","2019-11-09 00:25:10");
INSERT INTO product_purchases VALUES("144","48","4","","","100","100","1","1","0","0","0","100","2019-11-10 08:02:21","2019-11-10 08:02:21");
INSERT INTO product_purchases VALUES("149","49","22","","","10","10","1","800","0","10","800","8800","2019-11-10 23:28:59","2019-11-10 23:28:59");
INSERT INTO product_purchases VALUES("158","55","48","","3","1","1","1","2","0","0","0","2","2019-11-27 11:28:35","2019-11-27 11:28:35");
INSERT INTO product_purchases VALUES("159","55","48","","2","1","1","1","2","0","0","0","2","2019-11-27 11:28:35","2019-11-27 11:28:35");
INSERT INTO product_purchases VALUES("161","57","3","","","1","1","1","200","0","0","0","200","2019-12-04 12:07:49","2019-12-04 12:07:49");
INSERT INTO product_purchases VALUES("162","58","48","","2","1","1","1","2","0","0","0","2","2019-12-04 23:21:10","2019-12-04 23:21:10");
INSERT INTO product_purchases VALUES("163","58","48","","3","1","1","1","2","0","0","0","2","2019-12-04 23:21:10","2019-12-04 23:21:10");
INSERT INTO product_purchases VALUES("169","59","48","","3","1","1","1","2","0","0","0","2","2019-12-21 05:22:29","2019-12-21 05:22:29");
INSERT INTO product_purchases VALUES("170","59","48","","2","1","1","1","2","0","0","0","2","2019-12-21 05:22:29","2019-12-21 05:22:29");
INSERT INTO product_purchases VALUES("171","59","48","","5","1","1","1","2","0","0","0","2","2019-12-21 05:22:29","2019-12-21 05:22:29");
INSERT INTO product_purchases VALUES("174","56","48","","2","1","1","1","2","0","0","0","2","2019-12-21 08:27:16","2019-12-21 08:27:16");
INSERT INTO product_purchases VALUES("178","61","48","","3","10","10","1","2","0","0","0","20","2020-01-01 02:06:31","2020-01-01 02:06:31");
INSERT INTO product_purchases VALUES("179","61","48","","2","10","10","1","2","0","0","0","20","2020-01-01 02:06:31","2020-01-01 02:06:31");
INSERT INTO product_purchases VALUES("180","61","48","","5","10","10","1","2","0","0","0","20","2020-01-01 02:06:31","2020-01-01 02:06:31");
INSERT INTO product_purchases VALUES("181","62","25","","","3","3","1","500","0","10","150","1650","2020-01-01 03:24:02","2020-01-01 03:24:02");
INSERT INTO product_purchases VALUES("209","67","31","","","1","1","1","250","0","0","0","250","2020-02-04 12:00:41","2020-02-04 12:00:41");
INSERT INTO product_purchases VALUES("210","67","30","","","1","1","1","50","0","0","0","50","2020-02-04 12:00:41","2020-02-04 12:00:41");
INSERT INTO product_purchases VALUES("212","69","4","","","50","50","1","1","0","0","0","50","2020-03-02 00:55:10","2020-03-02 00:55:10");
INSERT INTO product_purchases VALUES("213","70","4","","","50","50","1","1","0","0","0","50","2020-03-02 00:56:03","2020-03-02 00:56:03");
INSERT INTO product_purchases VALUES("214","71","25","","","3","3","1","500","0","10","150","1650","2020-04-06 09:35:12","2020-04-06 09:35:12");
INSERT INTO product_purchases VALUES("215","71","31","","","5","5","1","250","0","0","0","1250","2020-04-06 09:35:12","2020-04-06 09:35:12");
INSERT INTO product_purchases VALUES("216","71","30","","","3","3","1","50","0","0","0","150","2020-04-06 09:35:12","2020-04-06 09:35:12");
INSERT INTO product_purchases VALUES("217","72","61","","","10","10","1","2500","5000","15","3750","28750","2020-08-16 12:02:07","2020-08-16 12:02:07");
INSERT INTO product_purchases VALUES("219","73","62","","12","2","2","1","1","0","0","0","2","2020-09-27 05:07:44","2020-09-27 05:07:44");
INSERT INTO product_purchases VALUES("221","74","61","","","11","11","1","3000","0","15","4950","37950","2020-10-23 21:03:16","2020-10-23 21:03:16");
INSERT INTO product_purchases VALUES("222","74","22","","","4","4","1","800","0","10","320","3520","2020-10-23 21:03:16","2020-10-23 21:03:16");
INSERT INTO product_purchases VALUES("232","83","60","","9","2","2","1","1","0","0","0","2","2020-10-26 18:56:11","2020-10-26 18:56:11");
INSERT INTO product_purchases VALUES("233","84","60","","9","2","2","1","2","0","0","0","4","2020-10-26 18:56:58","2020-10-26 18:56:58");
INSERT INTO product_purchases VALUES("234","85","1","","","1","1","1","320","0","10","32","352","2020-11-01 22:29:52","2020-11-01 22:29:52");
INSERT INTO product_purchases VALUES("239","87","1","","","1","1","1","320","0","10","32","352","2020-11-02 00:20:34","2020-11-02 00:20:34");
INSERT INTO product_purchases VALUES("242","89","62","","12","1","1","1","1","0","0","0","1","2020-11-16 04:01:45","2020-11-16 04:01:45");
INSERT INTO product_purchases VALUES("243","89","1","","","1","1","1","320","0","10","32","352","2020-11-16 04:01:45","2020-11-16 04:01:45");
INSERT INTO product_purchases VALUES("244","90","61","","","10","10","1","3000","0","15","4500","34500","2020-11-17 19:15:44","2020-11-17 19:15:44");
INSERT INTO product_purchases VALUES("271","98","71","1","","10","10","1","1","0","0","0","10","2021-03-07 03:14:05","2021-03-07 03:14:05");
INSERT INTO product_purchases VALUES("281","100","71","1","","10","10","1","1","0","0","0","10","2021-03-09 04:45:19","2021-03-09 04:45:19");
INSERT INTO product_purchases VALUES("282","99","71","2","","5","5","1","1","0","0","0","5","2021-03-09 04:46:50","2021-03-09 04:46:50");
INSERT INTO product_purchases VALUES("283","102","71","1","","5","5","1","1","0","0","0","5","2021-03-10 22:47:53","2021-03-10 22:47:53");
INSERT INTO product_purchases VALUES("295","105","71","1","","1","1","1","1","0","0","0","1","2021-04-09 11:53:48","2021-04-09 11:53:48");
INSERT INTO product_purchases VALUES("296","105","5","","","1","1","1","100","0","0","0","100","2021-04-09 11:53:48","2021-04-09 11:53:48");
INSERT INTO product_purchases VALUES("297","106","1","","","1","1","1","320","0","10","32","352","2021-05-24 09:18:54","2021-05-24 09:18:54");
INSERT INTO product_purchases VALUES("309","113","3","","","1","1","1","200","0","0","0","200","2021-05-30 03:41:19","2021-05-30 03:41:19");
INSERT INTO product_purchases VALUES("310","113","71","1","","1","1","1","1","0","0","0","1","2021-05-30 03:41:19","2021-05-30 03:41:19");
INSERT INTO product_purchases VALUES("311","115","72","","","1000","1000","1","100","0","0","0","100000","2021-12-19 13:56:35","2021-12-19 13:56:35");
INSERT INTO product_purchases VALUES("312","116","73","","","1000","1000","1","120","0","0","0","120000","2021-12-19 13:57:28","2021-12-19 13:57:28");
INSERT INTO product_purchases VALUES("313","117","74","","","1000","1000","1","450","0","0","0","450000","2021-12-19 13:57:53","2021-12-19 13:57:53");
INSERT INTO product_purchases VALUES("314","118","75","","","1000","1000","1","100","0","0","0","100000","2021-12-19 13:58:17","2021-12-19 13:58:17");
INSERT INTO product_purchases VALUES("315","119","76","","","1000","1000","1","70","0","0","0","70000","2021-12-19 13:58:54","2021-12-19 13:58:54");
INSERT INTO product_purchases VALUES("316","120","83","","","1000","1000","1","100","0","0","0","100000","2021-12-19 13:59:32","2021-12-19 13:59:32");
INSERT INTO product_purchases VALUES("317","121","84","","","1000","1000","1","150","0","0","0","150000","2021-12-19 13:59:58","2021-12-19 13:59:58");
INSERT INTO product_purchases VALUES("318","122","85","","","1000","1000","1","150","0","0","0","150000","2021-12-19 14:00:28","2021-12-19 14:00:28");
INSERT INTO product_purchases VALUES("319","123","86","","","1000","1000","1","80","0","0","0","80000","2021-12-19 14:01:02","2021-12-19 14:01:02");
INSERT INTO product_purchases VALUES("320","124","87","","","1000","1000","1","100","0","0","0","100000","2021-12-19 14:01:38","2021-12-19 14:01:38");
INSERT INTO product_purchases VALUES("321","125","77","","19","1000","1000","1","300","0","0","0","300000","2021-12-19 14:02:40","2021-12-19 14:02:40");
INSERT INTO product_purchases VALUES("322","125","77","","18","1000","1000","1","300","0","0","0","300000","2021-12-19 14:02:40","2021-12-19 14:02:40");
INSERT INTO product_purchases VALUES("323","126","78","","21","1000","1000","1","400","0","0","0","400000","2021-12-19 14:03:21","2021-12-19 14:03:21");
INSERT INTO product_purchases VALUES("324","126","78","","20","1000","1000","1","400","0","0","0","400000","2021-12-19 14:03:21","2021-12-19 14:03:21");
INSERT INTO product_purchases VALUES("325","127","79","","21","1000","1000","1","340","0","0","0","340000","2021-12-19 14:03:59","2021-12-19 14:03:59");
INSERT INTO product_purchases VALUES("326","127","79","","20","1000","1000","1","340","0","0","0","340000","2021-12-19 14:03:59","2021-12-19 14:03:59");
INSERT INTO product_purchases VALUES("327","128","80","","22","1000","1000","1","380","0","0","0","380000","2021-12-19 14:04:42","2021-12-19 14:04:42");
INSERT INTO product_purchases VALUES("328","128","80","","20","1000","1000","1","380","0","0","0","380000","2021-12-19 14:04:42","2021-12-19 14:04:42");
INSERT INTO product_purchases VALUES("329","129","22","","","100","100","1","800","0","10","8000","88000","2022-02-05 16:46:19","2022-02-05 16:46:19");
INSERT INTO product_purchases VALUES("330","130","48","","2","4","4","1","2","0","0","0","8","2022-03-05 13:52:22","2022-03-05 13:52:22");
INSERT INTO product_purchases VALUES("331","131","88","","","200","200","11","1300","0","0","0","260000","2022-03-07 09:34:18","2022-03-07 09:34:18");
INSERT INTO product_purchases VALUES("332","132","88","","","200","200","11","1300","0","0","0","260000","2022-03-07 09:57:03","2022-03-07 09:57:03");
INSERT INTO product_purchases VALUES("333","133","90","","","618","618","11","500","0","0","0","309000","2022-03-07 10:10:27","2022-03-07 10:10:27");
INSERT INTO product_purchases VALUES("334","133","89","","","500","500","11","500","0","0","0","250000","2022-03-07 10:10:27","2022-03-07 10:10:27");
INSERT INTO product_purchases VALUES("335","133","91","","","2550","2550","11","600","0","0","0","1530000","2022-03-07 10:10:27","2022-03-07 10:10:27");
INSERT INTO product_purchases VALUES("336","134","88","","","100","100","11","1300","0","0","0","130000","2022-03-07 12:01:15","2022-03-07 12:01:15");
INSERT INTO product_purchases VALUES("337","134","89","","","100","100","11","500","0","0","0","50000","2022-03-07 12:01:15","2022-03-07 12:01:15");
INSERT INTO product_purchases VALUES("338","135","92","","","1000","1000","1","1000","0","0","0","1000000","2022-03-16 16:36:56","2022-03-16 16:36:56");
INSERT INTO product_purchases VALUES("339","136","93","","","10","10","1","500","0","0","0","5000","2022-05-21 23:08:38","2022-05-21 23:08:38");
INSERT INTO product_purchases VALUES("348","145","150","","30","1","1","1","300","0","0","0","300","2023-10-23 02:16:00","2023-10-23 02:16:00");
INSERT INTO product_purchases VALUES("349","145","150","","29","2","2","1","300","0","0","0","600","2023-10-23 02:16:00","2023-10-23 02:16:00");
INSERT INTO product_purchases VALUES("350","145","150","","28","3","3","1","300","0","0","0","900","2023-10-23 02:16:00","2023-10-23 02:16:00");
INSERT INTO product_purchases VALUES("351","145","150","","27","3","3","1","300","0","0","0","900","2023-10-23 02:16:00","2023-10-23 02:16:00");
INSERT INTO product_purchases VALUES("352","145","150","","26","2","2","1","300","0","0","0","600","2023-10-23 02:16:00","2023-10-23 02:16:00");
INSERT INTO product_purchases VALUES("353","145","150","","25","1","1","1","300","0","0","0","300","2023-10-23 02:16:00","2023-10-23 02:16:00");
INSERT INTO product_purchases VALUES("354","146","151","4","","500","500","1","35","0","0","0","17500","2023-10-29 15:54:18","2023-10-29 15:54:18");
INSERT INTO product_purchases VALUES("356","150","152","","","500","500","1","30","0","0","0","15000","2023-10-29 16:31:25","2023-10-29 16:31:25");
INSERT INTO product_purchases VALUES("357","151","153","","","1000","1000","1","5","0","0","0","5000","2023-10-29 16:33:00","2023-10-29 16:33:00");
INSERT INTO product_purchases VALUES("358","152","135","","","50","50","20","26.41","0","0","0","1320.5","2023-10-30 19:26:48","2023-10-30 19:26:48");
INSERT INTO product_purchases VALUES("359","153","25","","","50","50","1","400","0","10","2000","22000","2023-10-30 19:30:46","2023-10-30 19:30:46");
INSERT INTO product_purchases VALUES("360","154","99","","","100","100","1","4200","0","0","0","420000","2023-11-23 17:59:41","2023-11-23 17:59:41");
INSERT INTO product_purchases VALUES("361","155","169","","","10","10","1","1550","0","0","0","15500","2023-11-26 13:08:02","2023-11-26 13:08:02");
INSERT INTO product_purchases VALUES("362","155","168","","","10","10","1","4500","0","0","0","45000","2023-11-26 13:08:02","2023-11-26 13:08:02");
INSERT INTO product_purchases VALUES("363","155","167","","","10","10","1","2450","0","10","2450","26950","2023-11-26 13:08:02","2023-11-26 13:08:02");
INSERT INTO product_purchases VALUES("364","155","166","","","20","20","1","2050","0","10","4100","45100","2023-11-26 13:08:02","2023-11-26 13:08:02");
INSERT INTO product_purchases VALUES("365","156","185","","","1","1","1","46000","0","0","0","46000","2023-11-26 14:14:59","2023-11-26 14:14:59");
INSERT INTO product_purchases VALUES("366","156","184","","","1","1","1","90000","0","0","0","90000","2023-11-26 14:14:59","2023-11-26 14:14:59");
INSERT INTO product_purchases VALUES("367","156","183","","","1","1","1","80000","0","0","0","80000","2023-11-26 14:14:59","2023-11-26 14:14:59");
INSERT INTO product_purchases VALUES("368","156","181","","","10","10","1","55000","0","0","0","550000","2023-11-26 14:14:59","2023-11-26 14:14:59");
INSERT INTO product_purchases VALUES("369","156","180","","","10","10","1","45000","0","0","0","450000","2023-11-26 14:14:59","2023-11-26 14:14:59");
INSERT INTO product_purchases VALUES("370","156","179","","","10","10","1","50000","0","0","0","500000","2023-11-26 14:14:59","2023-11-26 14:14:59");
INSERT INTO product_purchases VALUES("371","156","178","","","10","10","1","40500","0","0","0","405000","2023-11-26 14:14:59","2023-11-26 14:14:59");
INSERT INTO product_purchases VALUES("372","156","177","","","10","10","1","30000","0","0","0","300000","2023-11-26 14:14:59","2023-11-26 14:14:59");
INSERT INTO product_purchases VALUES("373","156","163","","","10","10","1","24544.55","0","10","24544.55","269990","2023-11-26 14:14:59","2023-11-26 14:14:59");



CREATE TABLE `product_quotation` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `quotation_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `product_batch_id` int(11) DEFAULT NULL,
  `variant_id` int(11) DEFAULT NULL,
  `qty` double NOT NULL,
  `sale_unit_id` int(11) NOT NULL,
  `net_unit_price` double NOT NULL,
  `discount` double NOT NULL,
  `tax_rate` double NOT NULL,
  `tax` double NOT NULL,
  `total` double NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=39 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO product_quotation VALUES("2","1","1","","","1","2","5030","10","15","754.5","5784.5","2018-08-08 19:52:50","2018-08-27 20:09:57");
INSERT INTO product_quotation VALUES("3","1","4","","","50","1","1.5","25","10","7.5","82.5","2018-08-08 19:53:25","2018-08-27 20:34:36");
INSERT INTO product_quotation VALUES("4","1","2","","","6","1","9.55","0","10","5.73","63","2018-08-27 21:03:48","2018-08-27 21:07:07");
INSERT INTO product_quotation VALUES("5","2","10","","","2.5","7","22","0","0","0","55","2018-09-03 18:02:58","2018-09-20 06:37:41");
INSERT INTO product_quotation VALUES("6","2","13","","","1","0","21","0","0","0","21","2018-09-03 18:02:58","2018-09-03 18:02:58");
INSERT INTO product_quotation VALUES("7","3","1","","","1","1","400","0","10","40","440","2018-10-22 20:12:49","2019-12-21 01:41:37");
INSERT INTO product_quotation VALUES("19","3","48","","2","1","1","13","0","0","0","13","2019-12-07 03:50:02","2019-12-21 01:41:37");
INSERT INTO product_quotation VALUES("27","11","61","","","2","1","10000","0","15","3000","23000","2020-10-23 23:08:14","2020-10-23 23:28:35");
INSERT INTO product_quotation VALUES("28","12","3","","","10","1","250","0","0","0","2500","2020-12-09 18:34:01","2020-12-09 18:34:01");
INSERT INTO product_quotation VALUES("29","12","22","","","5","1","1200","0","10","600","6600","2020-12-09 18:34:01","2020-12-09 18:34:01");
INSERT INTO product_quotation VALUES("30","13","2","","","10","1","10.43","0","15","15.65","120","2021-01-12 01:58:03","2021-01-12 01:59:15");
INSERT INTO product_quotation VALUES("32","13","1","","","1","1","400","0","10","40","440","2021-01-12 01:58:03","2021-01-12 01:59:15");
INSERT INTO product_quotation VALUES("33","13","22","","","1","1","1000","0","10","100","1100","2021-01-12 01:59:15","2021-01-12 01:59:15");
INSERT INTO product_quotation VALUES("37","15","71","1","","1","1","2","0","0","0","2","2021-05-29 00:53:56","2021-05-30 04:04:07");
INSERT INTO product_quotation VALUES("38","15","1","","","1","1","400","0","10","40","440","2021-05-29 00:53:56","2021-05-30 04:04:07");



CREATE TABLE `product_returns` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `return_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `product_batch_id` int(11) DEFAULT NULL,
  `variant_id` int(11) DEFAULT NULL,
  `qty` double NOT NULL,
  `sale_unit_id` int(11) NOT NULL,
  `net_unit_price` double NOT NULL,
  `discount` double NOT NULL,
  `tax_rate` double NOT NULL,
  `tax` double NOT NULL,
  `total` double NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=47 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO product_returns VALUES("3","2","4","","","20","1","2","0","0","0","40","","");
INSERT INTO product_returns VALUES("4","3","10","","","2","7","22","0","0","0","44","","2018-10-06 22:19:40");
INSERT INTO product_returns VALUES("6","5","3","","","1","1","250","0","0","0","250","","2018-12-25 17:16:08");
INSERT INTO product_returns VALUES("12","6","1","","","1","1","400","0","10","40","440","","");
INSERT INTO product_returns VALUES("23","11","13","","","1","0","21","0","0","0","21","2019-12-24 00:20:29","2019-12-24 00:20:29");
INSERT INTO product_returns VALUES("26","13","61","","","1","1","10000","0","15","1500","11500","2020-08-16 12:25:02","2020-08-16 12:25:02");
INSERT INTO product_returns VALUES("27","14","1","","","1","1","400","0","10","40","440","2020-10-13 07:39:54","2020-10-13 07:39:54");
INSERT INTO product_returns VALUES("31","18","61","","","1","1","10000","0","15","1500","11500","2020-11-17 20:02:18","2020-11-17 20:02:18");
INSERT INTO product_returns VALUES("32","19","3","","","1","1","250","0","0","0","250","2020-12-09 19:40:25","2020-12-09 19:40:25");
INSERT INTO product_returns VALUES("43","25","71","1","","1","1","2","0","0","0","2","2021-05-24 09:39:50","2021-05-24 09:39:50");
INSERT INTO product_returns VALUES("44","26","88","","","1","11","2600","0","0","0","2600","2022-03-07 09:48:33","2022-03-07 09:48:33");
INSERT INTO product_returns VALUES("45","27","88","","","1","11","2600","0","0","0","2600","2022-03-07 12:14:44","2022-03-07 12:14:44");
INSERT INTO product_returns VALUES("46","28","96","","","200","9","1","0","0","0","200","2022-10-23 23:20:12","2022-10-23 23:20:12");



CREATE TABLE `product_sales` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `sale_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `product_batch_id` int(11) DEFAULT NULL,
  `variant_id` int(11) DEFAULT NULL,
  `qty` double NOT NULL,
  `sale_unit_id` int(11) NOT NULL,
  `net_unit_price` double NOT NULL,
  `discount` double NOT NULL,
  `tax_rate` double NOT NULL,
  `tax` double NOT NULL,
  `total` double NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=561 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO product_sales VALUES("1","1","2","","","1","2","104.35","0","15","15.65","120","2018-08-08 06:36:23","2018-08-08 07:13:27");
INSERT INTO product_sales VALUES("3","1","5","","","2","1","115","10","0","0","230","2018-08-08 07:13:28","2018-08-08 07:13:28");
INSERT INTO product_sales VALUES("4","2","1","","","10","1","420","0","10","420","4620","2018-08-08 19:54:53","2018-08-08 19:54:53");
INSERT INTO product_sales VALUES("5","2","4","","","50","1","2.1","0","0","0","105","2018-08-08 19:54:53","2018-08-08 19:54:53");
INSERT INTO product_sales VALUES("6","2","2","","","3","2","109.57","0","15","49.3","378","2018-08-08 19:54:53","2018-08-08 19:54:53");
INSERT INTO product_sales VALUES("7","3","4","","","20","1","2.1","0","0","0","42","2018-08-08 20:32:15","2018-08-08 20:32:15");
INSERT INTO product_sales VALUES("8","3","5","","","5","1","126","0","0","0","630","2018-08-08 20:32:15","2018-08-08 20:32:15");
INSERT INTO product_sales VALUES("9","3","3","","","1","1","225","0","0","0","225","2018-08-08 20:32:15","2018-08-08 20:32:15");
INSERT INTO product_sales VALUES("10","4","1","","","2","1","400","0","10","80","880","2018-08-24 17:48:37","2018-08-24 17:48:37");
INSERT INTO product_sales VALUES("12","6","13","","","1","0","18.9","0","0","0","18.9","2018-08-25 23:48:36","2018-08-26 01:48:05");
INSERT INTO product_sales VALUES("13","7","1","","","2","1","400","0","10","80","880","2018-08-26 21:35:45","2018-08-26 21:35:45");
INSERT INTO product_sales VALUES("14","8","5","","","2","2","1440","0","10","288","3168","2018-09-01 19:39:54","2018-09-01 19:39:54");
INSERT INTO product_sales VALUES("15","9","4","","","10","1","2","0","0","0","20","2018-09-02 17:33:14","2018-09-02 17:33:14");
INSERT INTO product_sales VALUES("16","10","3","","","1","1","250","0","0","0","250","2018-09-02 19:01:39","2018-09-02 19:01:39");
INSERT INTO product_sales VALUES("17","11","22","","","5","1","1000","0","10","500","5500","2018-09-03 00:08:21","2018-09-03 00:08:21");
INSERT INTO product_sales VALUES("18","12","22","","","10","1","1050","0","10","1050","11550","2018-09-03 00:10:33","2018-09-03 00:10:33");
INSERT INTO product_sales VALUES("46","29","5","","","1","1","120","0","0","0","120","2018-09-08 23:38:41","2018-09-08 23:38:41");
INSERT INTO product_sales VALUES("47","30","1","","","1","1","400","0","10","40","440","2018-09-09 18:57:06","2018-09-20 05:12:38");
INSERT INTO product_sales VALUES("48","31","1","","","1","1","400","0","10","40","440","2018-09-25 23:20:59","2018-09-25 23:21:25");
INSERT INTO product_sales VALUES("49","31","2","","","1","2","104.35","0","15","15.65","120","2018-09-25 23:20:59","2018-09-25 23:21:25");
INSERT INTO product_sales VALUES("50","32","1","","","1","1","400","0","10","40","440","2018-10-03 23:55:48","2018-10-03 23:55:48");
INSERT INTO product_sales VALUES("51","33","1","","","1","1","400","0","10","40","440","2018-10-04 00:00:23","2018-10-04 00:00:23");
INSERT INTO product_sales VALUES("57","37","3","","","1","1","250","0","0","0","250","2018-10-06 20:46:05","2018-10-06 20:46:05");
INSERT INTO product_sales VALUES("58","38","1","","","1","1","400","0","10","40","440","2018-10-06 20:47:19","2018-10-06 20:47:19");
INSERT INTO product_sales VALUES("61","40","1","","","1","1","400","0","10","40","440","2018-10-06 21:13:12","2018-10-06 21:13:12");
INSERT INTO product_sales VALUES("62","41","1","","","1","1","400","0","10","40","440","2018-10-09 18:16:21","2018-10-09 18:16:21");
INSERT INTO product_sales VALUES("63","41","13","","","1","0","21","0","0","0","21","2018-10-09 18:16:21","2018-10-09 18:16:21");
INSERT INTO product_sales VALUES("64","42","1","","","1","1","400","0","10","40","440","2018-10-09 19:34:51","2018-10-09 19:34:51");
INSERT INTO product_sales VALUES("65","43","1","","","1","1","400","0","10","40","440","2018-10-15 17:34:35","2018-10-15 17:34:35");
INSERT INTO product_sales VALUES("78","55","3","","","1","1","250","0","0","0","250","2018-10-20 20:53:34","2018-10-20 20:53:34");
INSERT INTO product_sales VALUES("80","57","1","","","1","1","400","0","10","40","440","2018-10-20 22:26:12","2018-10-20 22:26:12");
INSERT INTO product_sales VALUES("81","57","13","","","2","0","21","0","0","0","42","2018-10-20 22:26:13","2018-10-20 22:26:13");
INSERT INTO product_sales VALUES("82","58","22","","","1","1","1000","0","10","100","1100","2018-10-22 05:27:24","2018-10-22 05:27:24");
INSERT INTO product_sales VALUES("83","58","5","","","1","1","120","0","0","0","120","2018-10-22 05:27:24","2018-10-22 05:27:24");
INSERT INTO product_sales VALUES("101","73","25","","","3","1","1000","0","10","300","3300","2018-10-22 21:15:43","2018-10-22 21:15:43");
INSERT INTO product_sales VALUES("102","73","22","","","2","1","1000","0","10","200","2200","2018-10-22 21:15:44","2018-10-22 21:15:44");
INSERT INTO product_sales VALUES("103","74","22","","","1","1","1000","0","10","100","1100","2018-10-22 21:16:44","2018-10-22 21:16:44");
INSERT INTO product_sales VALUES("104","74","25","","","1","1","1000","0","10","100","1100","2018-10-22 21:16:44","2018-10-22 21:16:44");
INSERT INTO product_sales VALUES("105","74","5","","","1","1","120","0","0","0","120","2018-10-22 21:16:44","2018-10-22 21:16:44");
INSERT INTO product_sales VALUES("106","75","2","","","3","2","104.35","0","15","46.96","360","2018-10-31 19:00:27","2018-10-31 19:00:27");
INSERT INTO product_sales VALUES("107","75","22","","","2","1","1000","0","10","200","2200","2018-10-31 19:00:27","2018-10-31 19:00:27");
INSERT INTO product_sales VALUES("108","75","25","","","3","1","1000","0","10","300","3300","2018-10-31 19:00:27","2018-10-31 19:00:27");
INSERT INTO product_sales VALUES("109","75","1","","","2","1","400","0","10","80","880","2018-10-31 19:00:27","2018-10-31 19:00:27");
INSERT INTO product_sales VALUES("110","75","5","","","2","1","120","0","0","0","240","2018-10-31 19:00:27","2018-10-31 19:00:27");
INSERT INTO product_sales VALUES("111","76","3","","","1","1","250","0","0","0","250","2018-10-31 19:01:26","2018-11-02 23:28:56");
INSERT INTO product_sales VALUES("112","76","22","","","1","1","1000","0","10","100","1100","2018-10-31 19:01:27","2018-11-02 23:28:56");
INSERT INTO product_sales VALUES("113","76","13","","","4","0","21","0","0","0","84","2018-10-31 19:01:27","2018-11-02 23:28:56");
INSERT INTO product_sales VALUES("117","79","1","","","4","1","400","0","10","160","1760","2018-11-04 22:15:17","2018-11-04 22:15:17");
INSERT INTO product_sales VALUES("118","79","2","","","7","2","104.35","0","15","109.57","840","2018-11-04 22:15:17","2018-11-04 22:15:17");
INSERT INTO product_sales VALUES("119","79","3","","","7","1","250","0","0","0","1750","2018-11-04 22:15:17","2018-11-04 22:15:17");
INSERT INTO product_sales VALUES("120","79","4","","","7","1","2","0","0","0","14","2018-11-04 22:15:17","2018-11-04 22:15:17");
INSERT INTO product_sales VALUES("121","79","22","","","8","1","1000","0","10","800","8800","2018-11-04 22:15:17","2018-11-04 22:15:17");
INSERT INTO product_sales VALUES("122","79","13","","","10","0","21","0","0","0","210","2018-11-04 22:15:17","2018-11-04 22:15:17");
INSERT INTO product_sales VALUES("123","79","5","","","9","1","120","0","0","0","1080","2018-11-04 22:15:17","2018-11-04 22:15:17");
INSERT INTO product_sales VALUES("124","80","2","","","2","2","104.35","0","15","31.3","240","2018-11-04 22:19:58","2018-11-04 22:19:58");
INSERT INTO product_sales VALUES("125","80","3","","","2","1","250","0","0","0","500","2018-11-04 22:19:58","2018-11-04 22:19:58");
INSERT INTO product_sales VALUES("126","80","1","","","4","1","400","0","10","160","1760","2018-11-04 22:19:58","2018-11-04 22:19:58");
INSERT INTO product_sales VALUES("132","86","22","","","1","1","1000","0","10","100","1100","2018-11-04 22:59:48","2018-11-04 22:59:48");
INSERT INTO product_sales VALUES("134","88","22","","","1","1","1000","0","10","100","1100","2018-11-04 23:02:58","2018-11-04 23:02:58");
INSERT INTO product_sales VALUES("142","94","2","","","1","2","104.35","0","15","15.65","120","2018-11-26 03:05:34","2018-11-26 03:05:34");
INSERT INTO product_sales VALUES("143","95","5","","","3","1","120","0","0","0","360","2018-11-26 22:36:08","2018-11-26 22:36:08");
INSERT INTO product_sales VALUES("144","95","5","","","3","1","120","0","0","0","360","2018-11-26 22:36:08","2018-11-26 22:36:08");
INSERT INTO product_sales VALUES("145","96","2","","","1","2","104.35","0","15","15.65","120","2018-11-27 20:15:09","2018-11-27 20:15:09");
INSERT INTO product_sales VALUES("146","97","2","","","2","2","104.35","0","15","31.3","240","2018-11-30 19:05:18","2018-11-30 19:05:18");
INSERT INTO product_sales VALUES("147","97","10","","","1","7","22","0","0","0","22","2018-11-30 19:05:18","2018-11-30 19:05:18");
INSERT INTO product_sales VALUES("148","98","30","","","2","1","100","0","0","0","200","2018-12-04 18:35:58","2018-12-04 18:35:58");
INSERT INTO product_sales VALUES("149","98","31","","","2","1","300","0","0","0","600","2018-12-04 18:35:58","2018-12-04 18:35:58");
INSERT INTO product_sales VALUES("150","99","30","","","2","1","100","0","0","0","200","2018-12-04 18:37:19","2018-12-04 18:37:19");
INSERT INTO product_sales VALUES("151","99","31","","","2","1","300","0","0","0","600","2018-12-04 18:37:20","2018-12-04 18:37:20");
INSERT INTO product_sales VALUES("153","101","30","","","1","1","100","0","0","0","100","2018-12-07 19:20:26","2018-12-07 19:20:26");
INSERT INTO product_sales VALUES("155","103","2","","","1","2","104.35","0","15","15.65","120","2018-12-23 17:58:32","2018-12-23 17:58:32");
INSERT INTO product_sales VALUES("156","104","33","","","4","1","2","0","0","0","8","2018-12-23 22:15:27","2018-12-24 16:55:23");
INSERT INTO product_sales VALUES("157","104","26","","","2","0","1250","0","0","0","2500","2018-12-24 16:47:54","2018-12-24 16:55:23");
INSERT INTO product_sales VALUES("158","105","13","","","1","0","21","0","0","0","21","2018-12-31 18:45:38","2018-12-31 18:45:38");
INSERT INTO product_sales VALUES("159","106","2","","","1","2","104.35","0","15","15.65","120","2018-12-31 22:10:40","2018-12-31 22:10:40");
INSERT INTO product_sales VALUES("160","106","3","","","2","1","250","0","0","0","500","2018-12-31 22:10:40","2018-12-31 22:10:40");
INSERT INTO product_sales VALUES("161","106","5","","","2","1","120","0","0","0","240","2018-12-31 22:10:40","2018-12-31 22:10:40");
INSERT INTO product_sales VALUES("162","107","3","","","2","1","250","0","0","0","500","2019-01-02 19:56:27","2019-01-02 19:56:27");
INSERT INTO product_sales VALUES("163","107","5","","","2","1","120","0","0","0","240","2019-01-02 19:56:27","2019-01-02 19:56:27");
INSERT INTO product_sales VALUES("164","107","22","","","2","1","1000","0","10","200","2200","2019-01-02 19:56:27","2019-01-02 19:56:27");
INSERT INTO product_sales VALUES("165","107","25","","","1","1","1000","0","10","100","1100","2019-01-02 19:56:27","2019-01-02 19:56:27");
INSERT INTO product_sales VALUES("166","107","1","","","2","1","400","0","10","80","880","2019-01-02 19:56:27","2019-01-02 19:56:27");
INSERT INTO product_sales VALUES("167","107","2","","","1","2","104.35","0","15","15.65","120","2019-01-02 19:56:27","2019-01-02 19:56:27");
INSERT INTO product_sales VALUES("168","108","2","","","1","2","104.35","0","15","15.65","120","2019-01-20 04:58:24","2019-01-20 04:58:24");
INSERT INTO product_sales VALUES("169","109","1","","","1","1","400","0","10","40","440","2019-01-28 23:14:43","2019-01-28 23:14:43");
INSERT INTO product_sales VALUES("170","109","30","","","1","1","100","0","0","0","100","2019-01-28 23:14:43","2019-01-28 23:14:43");
INSERT INTO product_sales VALUES("171","110","31","","","2","1","300","0","0","0","600","2019-01-29 00:50:41","2019-01-29 00:50:41");
INSERT INTO product_sales VALUES("172","110","25","","","1","1","1000","0","10","100","1100","2019-01-29 00:50:41","2019-01-29 00:50:41");
INSERT INTO product_sales VALUES("173","111","3","","","1","1","250","0","0","0","250","2019-01-31 00:08:39","2019-01-31 00:08:39");
INSERT INTO product_sales VALUES("174","111","13","","","1","0","21","0","0","0","21","2019-01-31 00:08:39","2019-01-31 00:08:39");
INSERT INTO product_sales VALUES("175","112","1","","","1","1","400","0","10","40","440","2019-02-01 23:40:45","2019-02-01 23:40:45");
INSERT INTO product_sales VALUES("176","113","3","","","1","1","250","0","0","0","250","2019-02-02 00:41:17","2019-02-02 00:41:17");
INSERT INTO product_sales VALUES("177","113","30","","","1","1","100","0","0","0","100","2019-02-02 00:41:17","2019-02-02 00:41:17");
INSERT INTO product_sales VALUES("178","114","1","","","1","1","400","0","10","40","440","2019-02-05 04:04:45","2019-02-05 04:04:45");
INSERT INTO product_sales VALUES("183","118","1","","","1","1","400","0","10","40","440","2019-02-07 00:15:42","2019-02-07 00:15:42");
INSERT INTO product_sales VALUES("185","120","1","","","1","1","400","0","10","40","440","2019-02-07 00:40:37","2019-02-07 00:40:37");
INSERT INTO product_sales VALUES("186","121","3","","","1","1","250","0","0","0","250","2019-02-08 23:48:14","2019-02-08 23:48:14");
INSERT INTO product_sales VALUES("187","121","2","","","1","2","104.35","0","15","15.65","120","2019-02-08 23:48:14","2019-02-08 23:48:14");
INSERT INTO product_sales VALUES("188","121","4","","","10","1","2","0","0","0","20","2019-02-08 23:48:15","2019-02-08 23:48:15");
INSERT INTO product_sales VALUES("189","121","13","","","2","0","21","0","0","0","42","2019-02-08 23:48:15","2019-02-08 23:48:15");
INSERT INTO product_sales VALUES("190","121","1","","","1","1","400","0","10","40","440","2019-02-08 23:48:15","2019-02-08 23:48:15");
INSERT INTO product_sales VALUES("191","121","31","","","1","1","300","0","0","0","300","2019-02-08 23:48:15","2019-02-08 23:48:15");
INSERT INTO product_sales VALUES("192","121","30","","","1","1","100","0","0","0","100","2019-02-08 23:48:15","2019-02-08 23:48:15");
INSERT INTO product_sales VALUES("194","123","1","","","1","1","400","0","10","40","440","2019-02-19 03:32:14","2019-02-19 03:32:14");
INSERT INTO product_sales VALUES("198","127","31","","","1","1","300","0","0","0","300","2019-03-02 23:40:10","2019-03-02 23:40:10");
INSERT INTO product_sales VALUES("199","127","25","","","1","1","1000","0","10","100","1100","2019-03-02 23:40:10","2019-03-02 23:40:10");
INSERT INTO product_sales VALUES("200","127","22","","","1","1","1000","0","10","100","1100","2019-03-02 23:40:10","2019-03-02 23:40:10");
INSERT INTO product_sales VALUES("201","128","1","","","1","1","400","0","10","40","440","2019-04-03 23:55:55","2019-04-03 23:55:55");
INSERT INTO product_sales VALUES("202","128","2","","","1","2","104.35","0","15","15.65","120","2019-04-03 23:55:55","2019-04-03 23:55:55");
INSERT INTO product_sales VALUES("203","129","5","","","2","1","120","0","0","0","240","2019-04-03 23:59:37","2019-04-11 00:50:16");
INSERT INTO product_sales VALUES("204","130","1","","","1","1","400","0","10","40","440","2019-04-21 02:21:24","2019-04-21 02:21:24");
INSERT INTO product_sales VALUES("205","130","2","","","1","2","125.22","0","15","18.78","144","2019-04-21 02:21:24","2019-04-21 02:21:24");
INSERT INTO product_sales VALUES("206","130","4","","","1","1","2","0","0","0","2","2019-04-21 02:21:24","2019-04-21 02:21:24");
INSERT INTO product_sales VALUES("207","131","1","","","1","1","400","0","10","40","440","2019-05-28 00:32:29","2019-05-28 00:32:29");
INSERT INTO product_sales VALUES("208","131","3","","","1","1","250","0","0","0","250","2019-05-28 00:32:29","2019-05-28 00:32:29");
INSERT INTO product_sales VALUES("209","131","25","","","1","1","1000","0","10","100","1100","2019-05-28 00:32:29","2019-05-28 00:32:29");
INSERT INTO product_sales VALUES("210","131","22","","","1","1","1000","0","10","100","1100","2019-05-28 00:32:29","2019-05-28 00:32:29");
INSERT INTO product_sales VALUES("211","132","1","","","1","1","400","0","10","40","440","2019-06-13 00:16:37","2019-06-13 00:16:37");
INSERT INTO product_sales VALUES("212","132","30","","","1","1","100","0","0","0","100","2019-06-13 00:16:37","2019-06-13 00:16:37");
INSERT INTO product_sales VALUES("213","132","31","","","1","1","300","0","0","0","300","2019-06-13 00:16:37","2019-06-13 00:16:37");
INSERT INTO product_sales VALUES("214","133","3","","","2","1","250","0","0","0","500","2019-06-13 00:17:51","2019-06-13 00:17:51");
INSERT INTO product_sales VALUES("215","133","25","","","1","1","1000","0","10","100","1100","2019-06-13 00:17:52","2019-06-13 00:17:52");
INSERT INTO product_sales VALUES("216","133","22","","","1","1","1000","0","10","100","1100","2019-06-13 00:17:52","2019-06-13 00:17:52");
INSERT INTO product_sales VALUES("217","134","1","","","1","1","400","0","10","40","440","2019-10-19 05:30:28","2019-10-19 05:30:28");
INSERT INTO product_sales VALUES("218","134","22","","","1","1","1000","0","10","100","1100","2019-10-19 05:30:28","2019-10-19 05:30:28");
INSERT INTO product_sales VALUES("219","134","25","","","1","1","1000","0","10","100","1100","2019-10-19 05:30:28","2019-10-19 05:30:28");
INSERT INTO product_sales VALUES("220","134","31","","","1","1","300","0","0","0","300","2019-10-19 05:30:28","2019-10-19 05:30:28");
INSERT INTO product_sales VALUES("224","138","5","","","1","1","120","0","0","0","120","2019-10-31 02:29:37","2019-10-31 02:29:37");
INSERT INTO product_sales VALUES("225","139","2","","","2","2","125.22","0","15","37.57","288","2019-11-03 01:40:44","2019-11-03 01:40:44");
INSERT INTO product_sales VALUES("226","139","4","","","100","1","2","0","0","0","200","2019-11-03 01:40:44","2019-11-03 01:40:44");
INSERT INTO product_sales VALUES("236","144","22","","","1","1","1000","0","10","100","1100","2019-11-09 08:41:31","2019-11-09 08:41:31");
INSERT INTO product_sales VALUES("237","144","5","","","1","1","120","0","0","0","120","2019-11-09 08:41:31","2019-11-09 08:41:31");
INSERT INTO product_sales VALUES("241","147","22","","","1","1","1000","0","10","100","1100","2019-11-10 23:40:08","2019-11-10 23:40:08");
INSERT INTO product_sales VALUES("242","147","25","","","1","1","1000","0","10","100","1100","2019-11-10 23:40:08","2019-11-10 23:40:08");
INSERT INTO product_sales VALUES("243","147","4","","","10","1","2","0","0","0","20","2019-11-10 23:40:08","2019-11-10 23:40:08");
INSERT INTO product_sales VALUES("282","172","1","","","1","1","400","0","10","40","440","2019-12-03 04:46:31","2019-12-03 04:46:31");
INSERT INTO product_sales VALUES("283","173","3","","","1","1","225","0","0","0","225","2019-12-04 12:19:40","2019-12-04 12:19:40");
INSERT INTO product_sales VALUES("284","173","1","","","1","1","360","0","10","36","396","2019-12-04 12:19:40","2019-12-04 12:19:40");
INSERT INTO product_sales VALUES("306","187","2","","","2","2","125.22","0","15","37.57","288","2019-12-21 23:40:58","2019-12-21 23:40:58");
INSERT INTO product_sales VALUES("308","190","22","","","1","1","1000","0","10","100","1100","2019-12-23 01:59:46","2019-12-23 01:59:46");
INSERT INTO product_sales VALUES("312","193","25","","","1","1","1000","0","10","100","1100","2020-01-01 03:20:28","2020-01-01 03:20:28");
INSERT INTO product_sales VALUES("313","194","1","","","2","1","400","0","10","80","880","2020-01-02 05:39:47","2020-01-02 05:39:47");
INSERT INTO product_sales VALUES("314","194","2","","","1","1","10.43","0","15","1.57","12","2020-01-02 05:39:47","2020-01-02 05:39:47");
INSERT INTO product_sales VALUES("323","201","5","","","1","1","120","0","0","0","120","2020-02-03 04:52:56","2020-02-03 04:52:56");
INSERT INTO product_sales VALUES("324","202","25","","","1","1","1000","0","10","100","1100","2020-02-04 11:58:53","2020-02-04 11:58:53");
INSERT INTO product_sales VALUES("325","202","31","","","1","1","300","0","0","0","300","2020-02-04 11:58:53","2020-02-04 11:58:53");
INSERT INTO product_sales VALUES("326","203","3","","","1","1","250","0","0","0","250","2020-03-02 00:54:14","2020-03-02 00:54:14");
INSERT INTO product_sales VALUES("327","203","30","","","1","1","100","0","0","0","100","2020-03-02 00:54:14","2020-03-02 00:54:14");
INSERT INTO product_sales VALUES("328","204","4","","","20","1","2","0","0","0","40","2020-03-02 00:57:41","2020-03-02 00:57:41");
INSERT INTO product_sales VALUES("329","205","1","","","1","1","400","0","10","40","440","2020-03-11 06:46:42","2020-03-11 06:46:42");
INSERT INTO product_sales VALUES("330","206","5","","","1","1","120","0","0","0","120","2020-03-11 06:52:30","2020-03-11 06:54:04");
INSERT INTO product_sales VALUES("331","207","30","","","2","1","100","0","0","0","200","2020-04-06 09:40:24","2020-04-06 09:41:11");
INSERT INTO product_sales VALUES("332","207","31","","","1","1","300","0","0","0","300","2020-04-06 09:40:24","2020-04-06 09:41:11");
INSERT INTO product_sales VALUES("333","207","2","","","1","2","125.22","0","15","18.78","144","2020-04-06 09:41:11","2020-04-06 09:41:11");
INSERT INTO product_sales VALUES("334","208","25","","","1","1","1000","0","10","100","1100","2020-05-06 12:59:50","2020-05-06 12:59:50");
INSERT INTO product_sales VALUES("335","208","1","","","1","1","400","0","10","40","440","2020-05-06 12:59:50","2020-05-06 12:59:50");
INSERT INTO product_sales VALUES("336","209","5","","","1","1","120","0","0","0","120","2020-06-09 02:42:48","2020-06-09 02:42:48");
INSERT INTO product_sales VALUES("337","209","25","","","1","1","1000","0","10","100","1100","2020-06-09 02:42:48","2020-06-09 02:42:48");
INSERT INTO product_sales VALUES("340","212","1","","","1","1","350","0","10","35","385","2020-07-03 08:39:14","2020-07-03 08:39:14");
INSERT INTO product_sales VALUES("341","212","25","","","1","1","1000","0","10","100","1100","2020-07-03 08:39:14","2020-07-03 08:39:14");
INSERT INTO product_sales VALUES("342","212","22","","","1","1","1000","0","10","100","1100","2020-07-03 08:39:14","2020-07-03 08:39:14");
INSERT INTO product_sales VALUES("343","213","48","","2","1","1","13","0","0","0","13","2020-07-12 11:51:53","2020-07-12 11:51:53");
INSERT INTO product_sales VALUES("344","214","3","","","1","1","250","0","0","0","250","2020-07-14 01:53:41","2020-07-14 01:53:41");
INSERT INTO product_sales VALUES("347","217","1","","","1","1","350","0","10","35","385","2020-07-27 10:38:08","2020-07-27 10:38:08");
INSERT INTO product_sales VALUES("348","218","1","","","1","1","350","0","10","35","385","2020-07-27 10:40:24","2020-07-27 10:40:24");
INSERT INTO product_sales VALUES("349","219","1","","","1","1","350","0","10","35","385","2020-07-27 10:46:45","2020-07-27 10:46:45");
INSERT INTO product_sales VALUES("350","220","31","","","2","1","300","0","0","0","600","2020-08-12 08:28:04","2020-08-12 08:28:04");
INSERT INTO product_sales VALUES("351","220","33","","","3","1","20","0","0","0","60","2020-08-12 08:28:04","2020-08-12 08:28:04");
INSERT INTO product_sales VALUES("352","220","30","","","1","1","100","0","0","0","100","2020-08-12 08:28:04","2020-08-12 08:28:04");
INSERT INTO product_sales VALUES("353","221","25","","","1","1","1000","0","10","100","1100","2020-08-12 08:30:35","2020-08-12 08:30:35");
INSERT INTO product_sales VALUES("354","222","61","","","2","1","10000","0","15","3000","23000","2020-08-16 12:04:24","2020-08-16 12:04:24");
INSERT INTO product_sales VALUES("355","223","1","","","1","1","400","0","10","40","440","2020-08-16 12:05:23","2020-08-16 12:05:23");
INSERT INTO product_sales VALUES("356","224","1","","","3","1","390","30","10","117","1287","2020-08-26 10:01:39","2020-08-26 10:01:39");
INSERT INTO product_sales VALUES("362","230","3","","","1","1","250","0","0","0","250","2020-10-17 11:28:52","2020-10-17 11:28:52");
INSERT INTO product_sales VALUES("363","231","1","","","1","1","400","0","10","40","440","2020-10-18 01:13:33","2020-10-18 01:13:33");
INSERT INTO product_sales VALUES("364","232","30","","","1","1","100","0","0","0","100","2020-10-22 03:30:14","2020-10-22 03:30:14");
INSERT INTO product_sales VALUES("365","233","3","","","1","1","250","0","0","0","250","2020-10-22 03:56:04","2020-10-22 03:56:04");
INSERT INTO product_sales VALUES("366","234","61","","","1","1","10000","0","15","1500","11500","2020-10-23 21:05:06","2020-10-23 21:05:06");
INSERT INTO product_sales VALUES("367","235","3","","","1","1","250","0","0","0","250","2020-10-23 21:07:52","2020-10-23 21:07:52");
INSERT INTO product_sales VALUES("369","237","25","","","2","1","1000","0","10","200","2200","2020-10-24 05:46:01","2020-10-24 05:46:01");
INSERT INTO product_sales VALUES("370","237","22","","","2","1","1000","0","10","200","2200","2020-10-24 05:46:01","2020-10-24 05:46:01");
INSERT INTO product_sales VALUES("371","237","61","","","5","1","10000","0","15","7500","57500","2020-10-24 05:46:01","2020-10-24 05:46:01");
INSERT INTO product_sales VALUES("373","239","60","","9","1","1","2","0","0","0","2","2020-10-26 19:40:02","2020-10-26 19:40:02");
INSERT INTO product_sales VALUES("374","240","60","","9","2","1","3","0","0","0","6","2020-10-26 19:42:06","2020-10-26 19:42:06");
INSERT INTO product_sales VALUES("375","241","3","","","1","1","250","0","0","0","250","2020-10-26 20:32:00","2020-10-26 20:32:00");
INSERT INTO product_sales VALUES("376","242","3","","","1","1","250","0","0","0","250","2020-10-28 21:30:30","2020-10-28 21:30:30");
INSERT INTO product_sales VALUES("377","243","3","","","1","1","250","0","0","0","250","2020-10-31 21:21:12","2020-10-31 21:21:12");
INSERT INTO product_sales VALUES("380","245","1","","","2","1","400","0","10","80","880","2020-10-31 21:42:23","2020-10-31 21:42:23");
INSERT INTO product_sales VALUES("381","245","3","","","1","1","250","0","0","0","250","2020-10-31 21:42:23","2020-10-31 21:42:23");
INSERT INTO product_sales VALUES("382","246","1","","","1","1","400","0","10","40","440","2020-10-31 21:50:18","2020-11-02 05:39:17");
INSERT INTO product_sales VALUES("386","250","1","","","1","1","344","0","10","34.4","378.4","2020-11-06 02:30:41","2020-11-06 02:30:41");
INSERT INTO product_sales VALUES("387","251","1","","","1","1","344","0","10","34.4","378.4","2020-11-09 02:15:24","2020-11-09 02:15:24");
INSERT INTO product_sales VALUES("388","251","3","","","1","1","232.2","0","0","0","232.2","2020-11-09 02:15:24","2020-11-09 02:15:24");
INSERT INTO product_sales VALUES("389","252","3","","","1","1","229.5","0","0","0","229.5","2020-11-10 18:58:58","2020-11-10 18:58:58");
INSERT INTO product_sales VALUES("390","253","3","","","1","1","212.5","0","0","0","212.5","2020-11-13 19:47:36","2020-11-13 19:47:36");
INSERT INTO product_sales VALUES("391","253","31","","","1","1","255","0","0","0","255","2020-11-13 19:47:36","2020-11-13 19:47:36");
INSERT INTO product_sales VALUES("392","253","61","","","1","1","8500","0","15","1275","9775","2020-11-13 19:47:36","2020-11-13 19:47:36");
INSERT INTO product_sales VALUES("395","256","1","","","1","1","400","0","10","40","440","2020-11-16 19:47:48","2020-11-16 19:47:48");
INSERT INTO product_sales VALUES("396","256","3","","","1","1","250","0","10","25","275","2020-11-16 19:47:48","2020-11-16 19:47:48");
INSERT INTO product_sales VALUES("397","257","3","","","1","1","250","0","0","0","250","2020-11-16 20:09:19","2020-11-16 20:09:19");
INSERT INTO product_sales VALUES("398","258","61","","","3","1","10000","0","15","4500","34500","2020-11-17 19:52:39","2020-11-17 19:52:39");
INSERT INTO product_sales VALUES("402","262","61","","","2","1","10000","0","15","3000","23000","2020-11-28 18:21:30","2020-11-28 18:21:30");
INSERT INTO product_sales VALUES("403","263","1","","","1","1","400","0","10","40","440","2020-12-07 22:39:57","2020-12-07 22:39:57");
INSERT INTO product_sales VALUES("416","270","2","","","1","3","250.43","0","15","37.57","288","2021-01-11 02:45:35","2021-01-11 02:58:44");
INSERT INTO product_sales VALUES("419","270","22","","","1","1","1000","0","10","100","1100","2021-01-11 02:54:04","2021-01-11 02:58:44");
INSERT INTO product_sales VALUES("420","271","2","","","1","2","125.22","0","15","18.78","144","2021-01-11 03:16:25","2021-01-11 03:16:25");
INSERT INTO product_sales VALUES("421","271","3","","","1","1","250","0","0","0","250","2021-01-11 03:16:25","2021-01-11 03:16:25");
INSERT INTO product_sales VALUES("422","271","1","","","2","1","400","0","10","80","880","2021-01-11 03:16:25","2021-01-11 03:16:25");
INSERT INTO product_sales VALUES("429","274","2","","","10","1","10.43","0","15","15.65","120","2021-01-12 20:02:43","2021-01-12 20:02:43");
INSERT INTO product_sales VALUES("430","274","30","","","1","1","100","0","0","0","100","2021-01-12 20:02:43","2021-01-12 20:02:43");
INSERT INTO product_sales VALUES("431","274","3","","","2","1","250","0","0","0","500","2021-01-12 20:02:43","2021-01-12 20:02:43");
INSERT INTO product_sales VALUES("432","274","1","","","2","1","380","40","10","76","836","2021-01-12 20:02:43","2021-01-12 20:02:43");
INSERT INTO product_sales VALUES("433","275","1","","","1","1","400","0","10","40","440","2021-02-01 03:37:48","2021-02-01 03:37:48");
INSERT INTO product_sales VALUES("437","277","32","","","1","1","10","0","0","0","10","2021-02-15 20:09:48","2021-02-15 20:09:48");
INSERT INTO product_sales VALUES("438","277","48","","5","1","1","53","0","0","0","53","2021-02-15 20:09:48","2021-02-15 20:09:48");
INSERT INTO product_sales VALUES("439","277","48","","2","1","1","13","0","0","0","13","2021-02-15 20:09:48","2021-02-15 20:09:48");
INSERT INTO product_sales VALUES("440","277","48","","3","1","1","3","0","0","0","3","2021-02-15 20:09:48","2021-02-15 20:09:48");
INSERT INTO product_sales VALUES("441","277","61","","","1","1","10000","0","15","1500","11500","2021-02-15 20:09:48","2021-02-15 20:09:48");
INSERT INTO product_sales VALUES("442","277","31","","","1","1","300","0","0","0","300","2021-02-15 20:09:48","2021-02-15 20:09:48");
INSERT INTO product_sales VALUES("443","277","30","","","1","1","100","0","0","0","100","2021-02-15 20:09:48","2021-02-15 20:09:48");
INSERT INTO product_sales VALUES("444","277","25","","","1","1","1000","0","10","100","1100","2021-02-15 20:09:48","2021-02-15 20:09:48");
INSERT INTO product_sales VALUES("445","277","22","","","1","1","1000","0","10","100","1100","2021-02-15 20:09:48","2021-02-15 20:09:48");
INSERT INTO product_sales VALUES("446","277","13","","","1","0","21","0","0","0","21","2021-02-15 20:09:48","2021-02-15 20:09:48");
INSERT INTO product_sales VALUES("447","277","5","","","1","1","120","0","0","0","120","2021-02-15 20:09:48","2021-02-15 20:09:48");
INSERT INTO product_sales VALUES("448","277","4","","","1","1","2","0","0","0","2","2021-02-15 20:09:48","2021-02-15 20:09:48");
INSERT INTO product_sales VALUES("449","277","3","","","1","1","250","0","0","0","250","2021-02-15 20:09:48","2021-02-15 20:09:48");
INSERT INTO product_sales VALUES("450","277","2","","","1","2","125.22","0","15","18.78","144","2021-02-15 20:09:48","2021-02-15 20:09:48");
INSERT INTO product_sales VALUES("451","277","1","","","1","1","400","0","10","40","440","2021-02-15 20:09:48","2021-02-15 20:09:48");
INSERT INTO product_sales VALUES("452","278","1","","","1","1","400","0","10","40","440","2021-02-16 20:32:38","2021-02-16 20:32:38");
INSERT INTO product_sales VALUES("453","278","61","","","2","1","10000","0","15","3000","23000","2021-02-16 20:32:38","2021-02-16 20:32:38");
INSERT INTO product_sales VALUES("454","278","22","","","1","1","1000","0","10","100","1100","2021-02-16 20:32:38","2021-02-16 20:32:38");
INSERT INTO product_sales VALUES("455","278","3","","","1","1","250","0","0","0","250","2021-02-16 20:32:38","2021-02-16 20:32:38");
INSERT INTO product_sales VALUES("456","278","5","","","1","1","120","0","0","0","120","2021-02-16 20:32:38","2021-02-16 20:32:38");
INSERT INTO product_sales VALUES("457","279","71","1","","2","1","2","0","0","0","4","2021-03-11 02:40:34","2021-03-11 02:40:34");
INSERT INTO product_sales VALUES("458","280","71","2","","1","1","2","0","0","0","2","2021-03-16 18:14:11","2021-03-16 18:14:11");
INSERT INTO product_sales VALUES("459","282","71","1","","1","1","2","0","0","0","2","2021-03-17 19:47:29","2021-03-20 00:59:57");
INSERT INTO product_sales VALUES("468","288","5","","","1","1","120","0","0","0","120","2021-04-12 03:40:46","2021-04-12 03:40:46");
INSERT INTO product_sales VALUES("473","290","5","","","1","1","120","0","0","0","120","2021-05-24 09:45:58","2021-05-24 09:45:58");
INSERT INTO product_sales VALUES("478","294","31","","","5","1","300","0","0","0","1500","2021-10-16 15:51:24","2021-10-16 15:51:24");
INSERT INTO product_sales VALUES("479","295","1","","","5","1","400","0","10","200","2200","2021-10-16 15:54:54","2021-10-16 15:54:54");
INSERT INTO product_sales VALUES("480","296","1","","","1","1","400","0","10","40","440","2021-12-19 11:26:41","2021-12-19 11:26:41");
INSERT INTO product_sales VALUES("481","297","80","","22","3","1","1825","0","0","0","5475","2021-12-19 14:47:46","2021-12-19 14:47:46");
INSERT INTO product_sales VALUES("482","298","13","","","1","0","18.9","0","0","0","18.9","2022-02-05 19:01:21","2022-02-05 19:01:21");
INSERT INTO product_sales VALUES("483","298","1","","","1","1","360","0","10","36","396","2022-02-05 19:01:21","2022-02-05 19:01:21");
INSERT INTO product_sales VALUES("484","299","22","","","10","1","900","0","10","900","9900","2022-02-05 19:02:51","2022-02-05 19:02:51");
INSERT INTO product_sales VALUES("485","300","85","","","1","1","450","0","0","0","450","2022-03-03 00:33:31","2022-03-03 00:33:31");
INSERT INTO product_sales VALUES("486","301","86","","","1","1","200","0","0","0","200","2022-03-03 00:35:01","2022-03-03 00:35:01");
INSERT INTO product_sales VALUES("487","301","74","","","1","1","1380","0","0","0","1380","2022-03-03 00:35:01","2022-03-03 00:35:01");
INSERT INTO product_sales VALUES("488","302","76","","","2","1","180","0","0","0","360","2022-03-03 20:30:06","2022-03-03 20:30:06");
INSERT INTO product_sales VALUES("489","302","75","","","2","1","200","0","0","0","400","2022-03-03 20:30:06","2022-03-03 20:30:06");
INSERT INTO product_sales VALUES("490","302","74","","","1","1","1380","0","0","0","1380","2022-03-03 20:30:06","2022-03-03 20:30:06");
INSERT INTO product_sales VALUES("491","302","73","","","1","1","240","0","0","0","240","2022-03-03 20:30:06","2022-03-03 20:30:06");
INSERT INTO product_sales VALUES("492","302","72","","","1","1","220","0","0","0","220","2022-03-03 20:30:06","2022-03-03 20:30:06");
INSERT INTO product_sales VALUES("493","303","87","","","1","1","270","0","0","0","270","2022-03-04 17:29:37","2022-03-04 17:29:37");
INSERT INTO product_sales VALUES("494","303","86","","","1","1","200","0","0","0","200","2022-03-04 17:29:37","2022-03-04 17:29:37");
INSERT INTO product_sales VALUES("495","303","85","","","1","1","450","0","0","0","450","2022-03-04 17:29:37","2022-03-04 17:29:37");
INSERT INTO product_sales VALUES("496","304","3","","","1","1","250","0","0","0","250","2022-03-05 11:41:28","2022-03-05 11:41:28");
INSERT INTO product_sales VALUES("497","305","13","","","1","0","21","0","0","0","21","2022-03-05 12:02:09","2022-03-05 12:02:09");
INSERT INTO product_sales VALUES("498","305","72","","","1","1","220","0","0","0","220","2022-03-05 12:02:09","2022-03-05 12:02:09");
INSERT INTO product_sales VALUES("499","306","3","","","1","1","225","0","0","0","225","2022-03-05 12:04:04","2022-03-07 09:43:58");
INSERT INTO product_sales VALUES("500","307","88","","","6","11","2600","0","0","0","15600","2022-03-07 09:40:15","2022-03-07 09:40:15");
INSERT INTO product_sales VALUES("501","308","88","","","6","11","2600","0","0","0","15600","2022-03-07 12:07:04","2022-03-07 12:07:04");
INSERT INTO product_sales VALUES("502","309","22","","","1","1","1000","0","10","100","1100","2022-03-07 12:10:58","2022-03-07 12:10:58");
INSERT INTO product_sales VALUES("503","309","88","","","4","11","2600","0","0","0","10400","2022-03-07 12:10:58","2022-03-07 12:10:58");
INSERT INTO product_sales VALUES("504","310","72","","","1","1","220","0","0","0","220","2022-03-16 13:34:29","2022-03-16 13:34:29");
INSERT INTO product_sales VALUES("505","310","4","","","1","1","2","0","0","0","2","2022-03-16 13:34:29","2022-03-16 13:34:29");
INSERT INTO product_sales VALUES("506","311","92","","","100","1","1200","0","0","0","120000","2022-03-16 16:38:40","2022-03-16 16:38:40");
INSERT INTO product_sales VALUES("507","312","93","","","2","1","600","0","0","0","1200","2022-05-21 23:12:01","2022-05-21 23:12:01");
INSERT INTO product_sales VALUES("512","318","75","","","1","1","200","0","0","0","200","2022-12-22 11:46:15","2022-12-22 11:46:15");
INSERT INTO product_sales VALUES("513","318","74","","","1","1","1380","0","0","0","1380","2022-12-22 11:46:15","2022-12-22 11:46:15");
INSERT INTO product_sales VALUES("514","318","73","","","1","1","240","0","0","0","240","2022-12-22 11:46:15","2022-12-22 11:46:15");
INSERT INTO product_sales VALUES("515","319","22","","","10","1","1050","0","10","1050","11550","2023-07-20 16:01:33","2023-07-20 16:01:33");
INSERT INTO product_sales VALUES("516","320","97","","","1","12","200000","0","0","0","200000","2023-07-27 01:49:11","2023-07-27 01:49:11");
INSERT INTO product_sales VALUES("517","321","22","","","3","1","1000","0","10","300","3300","2023-08-29 22:38:34","2023-08-29 22:38:34");
INSERT INTO product_sales VALUES("518","322","74","","","1","1","1380","0","0","0","1380","2023-09-07 12:12:10","2023-09-07 12:12:10");
INSERT INTO product_sales VALUES("519","322","73","","","1","1","240","0","0","0","240","2023-09-07 12:12:10","2023-09-07 12:12:10");
INSERT INTO product_sales VALUES("520","323","22","","","4","1","1000","0","10","400","4400","2023-09-07 22:19:26","2023-09-07 22:19:26");
INSERT INTO product_sales VALUES("521","324","25","","","1","1","1050","0","10","105","1155","2023-09-18 16:46:59","2023-09-18 16:46:59");
INSERT INTO product_sales VALUES("522","324","88","","","1","1","2730","0","0","0","2730","2023-09-18 16:46:59","2023-09-18 16:46:59");
INSERT INTO product_sales VALUES("523","324","3","","","1","1","262.5","0","0","0","262.5","2023-09-18 16:46:59","2023-09-18 16:46:59");
INSERT INTO product_sales VALUES("524","324","75","","","1","1","210","0","0","0","210","2023-09-18 16:46:59","2023-09-18 16:46:59");
INSERT INTO product_sales VALUES("525","324","5","","","1","1","126","0","0","0","126","2023-09-18 16:46:59","2023-09-18 16:46:59");
INSERT INTO product_sales VALUES("526","325","87","","","1","1","270","0","0","0","270","2023-09-19 20:41:15","2023-09-19 20:41:15");
INSERT INTO product_sales VALUES("527","325","76","","","1","1","180","0","0","0","180","2023-09-19 20:41:15","2023-09-19 20:41:15");
INSERT INTO product_sales VALUES("528","325","75","","","1","1","200","0","0","0","200","2023-09-19 20:41:15","2023-09-19 20:41:15");
INSERT INTO product_sales VALUES("529","325","74","","","1","1","1380","0","0","0","1380","2023-09-19 20:41:15","2023-09-19 20:41:15");
INSERT INTO product_sales VALUES("530","325","1","","","2","1","400","0","10","80","880","2023-09-19 20:41:15","2023-09-19 20:41:15");
INSERT INTO product_sales VALUES("531","326","5","","","5","1","120","0","0","0","600","2023-09-20 16:02:03","2023-09-20 16:02:03");
INSERT INTO product_sales VALUES("532","327","5","","","3","1","120","0","0","0","360","2023-09-20 16:08:17","2023-09-20 16:08:17");
INSERT INTO product_sales VALUES("533","328","5","","","1","1","120","0","0","0","120","2023-09-20 16:09:52","2023-09-20 16:09:52");
INSERT INTO product_sales VALUES("534","329","5","","","1","1","120","0","0","0","120","2023-09-20 16:11:18","2023-09-20 16:11:18");
INSERT INTO product_sales VALUES("535","330","5","","","5","1","120","0","0","0","600","2023-09-20 16:13:11","2023-09-20 16:39:37");
INSERT INTO product_sales VALUES("536","331","5","","","5","1","120","0","0","0","600","2023-09-20 16:17:12","2023-09-20 16:17:12");
INSERT INTO product_sales VALUES("537","332","5","","","3","1","120","0","0","0","360","2023-09-20 16:24:33","2023-09-20 16:24:33");
INSERT INTO product_sales VALUES("538","333","5","","","2","1","120","0","0","0","240","2023-09-20 16:34:43","2023-09-20 16:34:43");
INSERT INTO product_sales VALUES("539","334","5","","","5","1","120","0","0","0","600","2023-09-20 16:36:27","2023-09-20 16:36:27");
INSERT INTO product_sales VALUES("540","335","5","","","5","1","120","0","0","0","600","2023-09-20 16:47:38","2023-09-20 16:47:38");
INSERT INTO product_sales VALUES("541","336","22","","","2","1","1000","0","10","200","2200","2023-09-21 19:58:31","2023-09-21 19:58:31");
INSERT INTO product_sales VALUES("542","337","73","","","2","1","240","0","0","0","480","2023-09-26 20:49:13","2023-09-26 20:49:13");
INSERT INTO product_sales VALUES("543","337","72","","","3","1","220","0","0","0","660","2023-09-26 20:49:13","2023-09-26 20:49:13");
INSERT INTO product_sales VALUES("544","338","151","4","","10","1","40","0","0","0","400","2023-10-29 16:47:25","2023-10-29 16:47:25");
INSERT INTO product_sales VALUES("545","339","152","","","10","1","35","0","0","0","350","2023-10-29 16:48:23","2023-10-29 16:48:23");
INSERT INTO product_sales VALUES("546","340","153","","","10","1","7","0","0","0","70","2023-10-29 16:49:25","2023-10-29 16:49:25");
INSERT INTO product_sales VALUES("547","341","84","","","4","1","350","0","0","0","1400","2023-10-30 18:46:04","2023-10-30 18:46:04");
INSERT INTO product_sales VALUES("548","341","74","","","1","1","1380","0","0","0","1380","2023-10-30 18:46:04","2023-10-30 18:46:04");
INSERT INTO product_sales VALUES("549","342","5","","","1","1","120","0","0","0","120","2023-11-01 12:07:30","2023-11-01 12:07:30");
INSERT INTO product_sales VALUES("550","343","3","","","2","1","250","0","0","0","500","2023-11-13 18:22:11","2023-11-13 18:22:11");
INSERT INTO product_sales VALUES("551","344","168","","","1","1","6500","0","0","0","6500","2023-11-26 14:22:38","2023-11-26 14:22:38");
INSERT INTO product_sales VALUES("552","345","183","","","1","1","85500","0","0","0","85500","2023-11-26 14:23:58","2023-11-26 14:23:58");
INSERT INTO product_sales VALUES("553","346","185","","","1","1","50000","0","0","0","50000","2023-12-03 15:40:16","2023-12-03 15:48:40");
INSERT INTO product_sales VALUES("554","347","1","","","1","1","400","0","0","0","400","2023-12-03 15:53:19","2023-12-03 16:13:44");
INSERT INTO product_sales VALUES("555","348","163","","","1","1","32999","0","0","0","32999","2023-12-04 13:38:14","2023-12-04 13:38:14");
INSERT INTO product_sales VALUES("556","348","1","","","1","1","400","0","0","0","400","2023-12-04 13:38:14","2023-12-04 13:38:14");
INSERT INTO product_sales VALUES("557","349","1","","","1","1","400","0","0","0","400","2023-12-04 13:39:47","2023-12-04 13:39:47");
INSERT INTO product_sales VALUES("558","349","184","","","1","1","95000","0","0","0","95000","2023-12-04 13:39:47","2023-12-04 13:39:47");
INSERT INTO product_sales VALUES("559","350","163","","","1","1","32999","0","0","0","32999","2023-12-12 17:04:52","2023-12-12 17:07:27");
INSERT INTO product_sales VALUES("560","350","1","","","2","1","400","0","0","0","800","2023-12-12 17:04:52","2023-12-12 17:07:27");



CREATE TABLE `product_transfer` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `transfer_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `product_batch_id` int(11) DEFAULT NULL,
  `variant_id` int(11) DEFAULT NULL,
  `qty` double NOT NULL,
  `purchase_unit_id` int(11) NOT NULL,
  `net_unit_cost` double NOT NULL,
  `tax_rate` double NOT NULL,
  `tax` double NOT NULL,
  `total` double NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO product_transfer VALUES("1","1","4","","","100","1","1","0","0","100","2018-08-08 07:17:10","2018-12-24 17:16:55");
INSERT INTO product_transfer VALUES("7","6","48","","3","1","1","2","0","0","2","2019-12-05 08:55:04","2019-12-05 09:09:42");
INSERT INTO product_transfer VALUES("11","8","5","","","10","1","100","0","0","1000","2020-01-22 01:30:59","2020-01-22 01:30:59");
INSERT INTO product_transfer VALUES("13","10","1","","","1","1","320","10","32","352","2020-10-08 03:27:35","2020-10-08 03:29:35");
INSERT INTO product_transfer VALUES("14","11","62","","12","1","1","1","0","0","1","2020-10-18 08:17:08","2020-10-18 08:17:08");
INSERT INTO product_transfer VALUES("15","12","61","","","10","1","3000","15","4500","34500","2020-10-23 23:01:46","2020-10-23 23:01:46");



CREATE TABLE `product_variants` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int(11) NOT NULL,
  `variant_id` int(11) NOT NULL,
  `position` int(11) NOT NULL,
  `item_code` varchar(191) NOT NULL,
  `additional_price` double DEFAULT NULL,
  `qty` double NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=39 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO product_variants VALUES("3","48","3","1","S-93475396","","12","2019-11-21 02:03:04","2021-02-15 20:09:48");
INSERT INTO product_variants VALUES("5","48","5","3","L-93475396","50","10","2019-11-24 01:07:20","2021-02-15 20:09:48");
INSERT INTO product_variants VALUES("6","48","2","2","M-93475396","10","15","2019-11-24 02:17:07","2022-03-05 13:52:22");
INSERT INTO product_variants VALUES("10","60","9","1","a-32081679","","1","2020-05-18 12:44:14","2020-10-26 19:42:06");
INSERT INTO product_variants VALUES("11","60","11","2","b-32081679","","0","2020-05-18 12:58:31","2020-05-18 12:58:31");
INSERT INTO product_variants VALUES("12","62","12","1","variant 1-81145830","","3","2020-09-27 02:08:27","2021-02-10 20:28:16");
INSERT INTO product_variants VALUES("13","62","13","2","variant 2-81145830","","0","2020-09-27 02:08:27","2020-09-27 02:08:27");
INSERT INTO product_variants VALUES("20","77","18","1","Full Chicken-63001857","1300","1000","2021-12-19 12:26:40","2021-12-19 14:02:40");
INSERT INTO product_variants VALUES("21","77","19","2","Half Chicken-63001857","700","1000","2021-12-19 12:26:40","2023-10-09 16:22:18");
INSERT INTO product_variants VALUES("22","78","20","1","Full Plate-60853282","1300","1000","2021-12-19 12:30:26","2021-12-19 14:03:21");
INSERT INTO product_variants VALUES("23","78","21","2","Half Plate-60853282","700","1000","2021-12-19 12:30:26","2021-12-19 14:03:21");
INSERT INTO product_variants VALUES("24","79","20","1","Full plate-90190758","1150","1000","2021-12-19 12:35:35","2021-12-19 14:03:59");
INSERT INTO product_variants VALUES("25","79","21","2","Half Plate-90190758","625","1000","2021-12-19 12:35:35","2021-12-19 14:03:59");
INSERT INTO product_variants VALUES("26","80","20","1","Full Plate-09395091","1200","1000","2021-12-19 12:37:50","2021-12-19 14:04:42");
INSERT INTO product_variants VALUES("27","80","22","2","HalfPlate-09395091","625","997","2021-12-19 12:37:50","2021-12-19 14:47:46");
INSERT INTO product_variants VALUES("28","81","23","1","Full Plate (4 pcs)-30912565","1300","0","2021-12-19 12:42:03","2021-12-19 12:42:03");
INSERT INTO product_variants VALUES("29","81","24","2","Half Plate (2 pcs)-30912565","700","0","2021-12-19 12:42:03","2021-12-19 12:42:03");
INSERT INTO product_variants VALUES("30","100","15","1","S-9999","0","0","2023-10-09 16:07:50","2023-10-09 16:07:50");
INSERT INTO product_variants VALUES("31","100","16","2","M-9999","0","0","2023-10-09 16:07:50","2023-10-09 16:07:50");
INSERT INTO product_variants VALUES("32","100","17","3","L-9999","10","0","2023-10-09 16:07:50","2023-10-09 16:07:50");
INSERT INTO product_variants VALUES("33","150","25","1","35-5011ME06","","1","2023-10-23 02:13:56","2023-10-23 02:16:00");
INSERT INTO product_variants VALUES("34","150","26","2","36-5011ME06","","2","2023-10-23 02:13:56","2023-10-23 02:16:00");
INSERT INTO product_variants VALUES("35","150","27","3","37-5011ME06","","3","2023-10-23 02:13:56","2023-10-23 02:16:00");
INSERT INTO product_variants VALUES("36","150","28","4","38-5011ME06","","3","2023-10-23 02:13:56","2023-10-23 02:16:00");
INSERT INTO product_variants VALUES("37","150","29","5","39-5011ME06","","2","2023-10-23 02:13:56","2023-10-23 02:16:00");
INSERT INTO product_variants VALUES("38","150","30","6","40-5011ME06","","1","2023-10-23 02:13:56","2023-10-23 02:16:00");



CREATE TABLE `product_warehouse` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` varchar(191) NOT NULL,
  `product_batch_id` int(11) DEFAULT NULL,
  `variant_id` int(11) DEFAULT NULL,
  `warehouse_id` int(11) NOT NULL,
  `qty` double NOT NULL,
  `price` double DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=111 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO product_warehouse VALUES("10","1","","","1","126.5","","2018-08-08 04:30:12","2023-12-12 17:07:27");
INSERT INTO product_warehouse VALUES("11","2","","","1","1368","","2018-08-08 04:30:12","2021-01-12 02:12:14");
INSERT INTO product_warehouse VALUES("12","3","","","1","97","","2018-08-08 04:30:13","2023-11-13 18:22:11");
INSERT INTO product_warehouse VALUES("13","5","","","1","40","","2018-08-08 04:30:13","2023-09-20 16:47:38");
INSERT INTO product_warehouse VALUES("14","4","","","1","170","","2018-08-08 05:16:09","2022-03-16 13:34:29");
INSERT INTO product_warehouse VALUES("15","4","","","2","120","","2018-08-08 07:16:15","2021-02-15 20:09:48");
INSERT INTO product_warehouse VALUES("16","2","","","2","1825","","2018-08-08 07:26:49","2021-02-15 20:09:48");
INSERT INTO product_warehouse VALUES("17","1","","","2","52.5","","2018-08-08 07:33:33","2021-12-19 11:26:41");
INSERT INTO product_warehouse VALUES("18","3","","","2","56","","2018-08-08 19:47:23","2021-05-28 13:17:39");
INSERT INTO product_warehouse VALUES("19","5","","","2","60","","2018-08-08 19:48:36","2021-05-24 09:36:47");
INSERT INTO product_warehouse VALUES("20","10","","","1","50","","2018-08-08 19:49:29","2019-12-04 00:49:14");
INSERT INTO product_warehouse VALUES("21","10","","","2","61","","2018-08-08 19:49:55","2018-11-30 19:05:18");
INSERT INTO product_warehouse VALUES("22","22","","","1","3","","2018-09-03 00:06:09","2023-10-09 16:22:00");
INSERT INTO product_warehouse VALUES("23","22","","","2","111","","2018-09-03 00:07:14","2022-02-05 19:02:51");
INSERT INTO product_warehouse VALUES("24","24","","","2","0","","2018-09-15 17:49:30","2018-09-15 17:50:49");
INSERT INTO product_warehouse VALUES("25","25","","","1","13","","2018-10-22 21:14:21","2023-10-09 16:21:59");
INSERT INTO product_warehouse VALUES("26","25","","","2","11","","2018-10-22 21:14:41","2021-02-15 20:09:48");
INSERT INTO product_warehouse VALUES("27","31","","","1","9","","2018-12-04 18:34:30","2021-10-16 15:51:24");
INSERT INTO product_warehouse VALUES("28","30","","","1","14","","2018-12-04 18:34:30","2020-10-22 03:30:14");
INSERT INTO product_warehouse VALUES("29","31","","","2","11","","2018-12-04 18:35:08","2021-02-15 20:09:48");
INSERT INTO product_warehouse VALUES("30","30","","","2","10","","2018-12-04 18:35:08","2021-02-15 20:09:48");
INSERT INTO product_warehouse VALUES("31","32","","","1","10","","2018-12-18 18:57:16","2019-02-08 23:45:23");
INSERT INTO product_warehouse VALUES("32","32","","","2","19","","2018-12-18 18:57:41","2021-02-15 20:09:48");
INSERT INTO product_warehouse VALUES("33","33","","","1","16","","2018-12-23 19:38:40","2019-03-02 23:39:17");
INSERT INTO product_warehouse VALUES("34","33","","","2","22","","2019-02-08 23:21:38","2020-08-12 08:28:04");
INSERT INTO product_warehouse VALUES("35","48","","3","1","2","","2019-11-25 09:23:02","2021-02-10 20:26:56");
INSERT INTO product_warehouse VALUES("36","48","","2","1","7","","2019-11-26 01:47:42","2022-03-05 13:52:22");
INSERT INTO product_warehouse VALUES("37","48","","3","2","10","","2019-11-26 03:12:08","2021-02-15 20:09:48");
INSERT INTO product_warehouse VALUES("38","48","","2","2","9","","2019-11-26 03:12:08","2021-02-15 20:09:48");
INSERT INTO product_warehouse VALUES("39","48","","5","1","1","","2019-12-21 05:18:51","2021-02-10 20:26:56");
INSERT INTO product_warehouse VALUES("40","48","","5","2","9","","2019-12-22 03:36:39","2021-02-15 20:09:48");
INSERT INTO product_warehouse VALUES("45","61","","","2","8","","2020-08-16 12:02:07","2021-02-16 20:32:38");
INSERT INTO product_warehouse VALUES("46","62","","12","1","2","","2020-09-27 02:55:33","2020-11-16 04:01:45");
INSERT INTO product_warehouse VALUES("47","62","","12","2","1","","2020-10-18 08:17:08","2021-02-10 20:28:16");
INSERT INTO product_warehouse VALUES("48","61","","","1","8","","2020-10-23 23:01:46","2020-11-28 18:21:30");
INSERT INTO product_warehouse VALUES("49","60","","9","1","1","","2020-10-26 06:34:05","2020-10-26 19:42:06");
INSERT INTO product_warehouse VALUES("51","71","1","","1","18","","2021-03-07 03:14:05","2021-05-30 03:41:19");
INSERT INTO product_warehouse VALUES("52","71","1","","2","7","","2021-03-07 03:21:16","2021-05-29 02:43:38");
INSERT INTO product_warehouse VALUES("53","71","2","","1","4","","2021-03-07 03:55:06","2021-05-30 03:33:04");
INSERT INTO product_warehouse VALUES("54","71","3","","1","0","","2021-03-09 04:42:13","2021-05-22 03:28:15");
INSERT INTO product_warehouse VALUES("55","71","2","","2","0","","2021-05-23 03:09:03","2021-05-26 03:38:06");
INSERT INTO product_warehouse VALUES("56","72","","","1","995","","2021-12-19 13:56:35","2023-09-26 20:49:13");
INSERT INTO product_warehouse VALUES("57","73","","","1","996","","2021-12-19 13:57:28","2023-09-26 20:49:13");
INSERT INTO product_warehouse VALUES("58","74","","","1","995","","2021-12-19 13:57:53","2023-10-30 18:46:04");
INSERT INTO product_warehouse VALUES("59","75","","","1","997","","2021-12-19 13:58:17","2023-09-19 20:41:15");
INSERT INTO product_warehouse VALUES("60","76","","","1","999","","2021-12-19 13:58:54","2023-09-19 20:41:15");
INSERT INTO product_warehouse VALUES("61","83","","","1","1000","","2021-12-19 13:59:32","2021-12-19 13:59:32");
INSERT INTO product_warehouse VALUES("62","84","","","1","996","","2021-12-19 13:59:58","2023-10-30 18:46:04");
INSERT INTO product_warehouse VALUES("63","85","","","1","998","","2021-12-19 14:00:28","2022-03-04 17:29:37");
INSERT INTO product_warehouse VALUES("64","86","","","1","998","","2021-12-19 14:01:02","2022-03-04 17:29:37");
INSERT INTO product_warehouse VALUES("65","87","","","1","998","","2021-12-19 14:01:38","2023-09-19 20:41:15");
INSERT INTO product_warehouse VALUES("66","77","","19","1","1000","","2021-12-19 14:02:40","2023-10-09 16:22:18");
INSERT INTO product_warehouse VALUES("67","77","","18","1","1000","","2021-12-19 14:02:40","2021-12-19 14:02:40");
INSERT INTO product_warehouse VALUES("68","78","","21","1","1000","","2021-12-19 14:03:21","2021-12-19 14:03:21");
INSERT INTO product_warehouse VALUES("69","78","","20","1","1000","","2021-12-19 14:03:21","2021-12-19 14:03:21");
INSERT INTO product_warehouse VALUES("70","79","","21","1","1000","","2021-12-19 14:03:59","2021-12-19 14:03:59");
INSERT INTO product_warehouse VALUES("71","79","","20","1","1000","","2021-12-19 14:03:59","2021-12-19 14:03:59");
INSERT INTO product_warehouse VALUES("72","80","","22","1","997","","2021-12-19 14:04:42","2021-12-19 14:47:46");
INSERT INTO product_warehouse VALUES("73","80","","20","1","1000","","2021-12-19 14:04:42","2021-12-19 14:04:42");
INSERT INTO product_warehouse VALUES("74","88","","","1","185","","2022-03-07 09:34:18","2023-09-18 16:46:59");
INSERT INTO product_warehouse VALUES("75","88","","","7","200","","2022-03-07 09:57:03","2022-03-07 09:57:03");
INSERT INTO product_warehouse VALUES("76","90","","","8","618","","2022-03-07 10:10:27","2022-03-07 10:10:27");
INSERT INTO product_warehouse VALUES("77","89","","","8","600","","2022-03-07 10:10:27","2022-03-07 12:01:15");
INSERT INTO product_warehouse VALUES("78","91","","","8","2550","","2022-03-07 10:10:27","2022-03-07 10:10:27");
INSERT INTO product_warehouse VALUES("79","88","","","8","100","","2022-03-07 12:01:14","2022-03-07 12:01:14");
INSERT INTO product_warehouse VALUES("80","92","","","1","900","","2022-03-16 16:36:56","2022-03-16 16:38:40");
INSERT INTO product_warehouse VALUES("81","93","","","9","8","","2022-05-21 23:08:38","2022-05-21 23:12:01");
INSERT INTO product_warehouse VALUES("82","95","","","1","0","","2022-10-12 01:12:15","2023-10-09 16:22:18");
INSERT INTO product_warehouse VALUES("83","96","","","1","0.2","","2022-10-23 22:48:38","2023-10-09 16:22:18");
INSERT INTO product_warehouse VALUES("84","97","","","1","-1","","2023-07-27 01:46:31","2023-10-09 16:21:59");
INSERT INTO product_warehouse VALUES("85","99","","","10","0","","2023-09-20 12:22:41","2023-10-09 16:21:59");
INSERT INTO product_warehouse VALUES("86","150","","30","8","1","","2023-10-23 02:16:00","2023-10-23 02:16:00");
INSERT INTO product_warehouse VALUES("87","150","","29","8","2","","2023-10-23 02:16:00","2023-10-23 02:16:00");
INSERT INTO product_warehouse VALUES("88","150","","28","8","3","","2023-10-23 02:16:00","2023-10-23 02:16:00");
INSERT INTO product_warehouse VALUES("89","150","","27","8","3","","2023-10-23 02:16:00","2023-10-23 02:16:00");
INSERT INTO product_warehouse VALUES("90","150","","26","8","2","","2023-10-23 02:16:00","2023-10-23 02:16:00");
INSERT INTO product_warehouse VALUES("91","150","","25","8","1","","2023-10-23 02:16:00","2023-10-23 02:16:00");
INSERT INTO product_warehouse VALUES("92","151","4","","36","490","","2023-10-29 15:54:18","2023-10-29 16:47:25");
INSERT INTO product_warehouse VALUES("93","152","","","36","490","","2023-10-29 16:30:01","2023-10-29 16:48:23");
INSERT INTO product_warehouse VALUES("94","153","","","36","990","","2023-10-29 16:33:00","2023-10-29 16:49:25");
INSERT INTO product_warehouse VALUES("95","135","","","1","50","","2023-10-30 19:26:48","2023-10-30 19:26:48");
INSERT INTO product_warehouse VALUES("96","25","","","8","50","","2023-10-30 19:30:46","2023-10-30 19:30:46");
INSERT INTO product_warehouse VALUES("97","99","","","1","100","","2023-11-23 17:59:41","2023-11-23 17:59:41");
INSERT INTO product_warehouse VALUES("98","169","","","1","10","","2023-11-26 13:08:02","2023-11-26 13:08:02");
INSERT INTO product_warehouse VALUES("99","168","","","1","9","","2023-11-26 13:08:02","2023-11-26 14:22:38");
INSERT INTO product_warehouse VALUES("100","167","","","1","10","","2023-11-26 13:08:02","2023-11-26 13:08:02");
INSERT INTO product_warehouse VALUES("101","166","","","1","20","","2023-11-26 13:08:02","2023-11-26 13:08:02");
INSERT INTO product_warehouse VALUES("102","185","","","1","0","","2023-11-26 14:14:59","2023-12-03 15:48:40");
INSERT INTO product_warehouse VALUES("103","184","","","1","1","","2023-11-26 14:14:59","2023-11-26 14:14:59");
INSERT INTO product_warehouse VALUES("104","183","","","1","0","","2023-11-26 14:14:59","2023-11-26 14:23:58");
INSERT INTO product_warehouse VALUES("105","181","","","1","10","","2023-11-26 14:14:59","2023-11-26 14:14:59");
INSERT INTO product_warehouse VALUES("106","180","","","1","10","","2023-11-26 14:14:59","2023-11-26 14:14:59");
INSERT INTO product_warehouse VALUES("107","179","","","1","10","","2023-11-26 14:14:59","2023-11-26 14:14:59");
INSERT INTO product_warehouse VALUES("108","178","","","1","10","","2023-11-26 14:14:59","2023-11-26 14:14:59");
INSERT INTO product_warehouse VALUES("109","177","","","1","10","","2023-11-26 14:14:59","2023-11-26 14:14:59");
INSERT INTO product_warehouse VALUES("110","163","","","1","9","","2023-11-26 14:14:59","2023-12-12 17:07:27");



CREATE TABLE `products` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `code` varchar(191) NOT NULL,
  `type` varchar(191) NOT NULL,
  `barcode_symbology` varchar(191) NOT NULL,
  `brand_id` int(11) DEFAULT NULL,
  `category_id` int(11) NOT NULL,
  `unit_id` int(11) NOT NULL,
  `purchase_unit_id` int(11) NOT NULL,
  `sale_unit_id` int(11) NOT NULL,
  `cost` varchar(191) NOT NULL,
  `price` varchar(191) NOT NULL,
  `qty` double DEFAULT NULL,
  `alert_quantity` double DEFAULT NULL,
  `promotion` tinyint(4) DEFAULT NULL,
  `promotion_price` varchar(191) DEFAULT NULL,
  `starting_date` varchar(200) DEFAULT NULL,
  `last_date` date DEFAULT NULL,
  `tax_id` int(11) DEFAULT NULL,
  `tax_method` int(11) DEFAULT NULL,
  `image` longtext DEFAULT NULL,
  `file` varchar(191) DEFAULT NULL,
  `is_variant` tinyint(1) DEFAULT NULL,
  `is_batch` tinyint(1) DEFAULT NULL,
  `is_diffPrice` tinyint(1) DEFAULT NULL,
  `featured` tinyint(4) DEFAULT NULL,
  `product_list` varchar(191) DEFAULT NULL,
  `qty_list` varchar(191) DEFAULT NULL,
  `price_list` varchar(191) DEFAULT NULL,
  `product_details` text DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2277 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO products VALUES("1","Mouse","63920719","standard","C39","4","54","1","1","1","320","400","178","20","1","350","2023-11-23","2023-12-31","1","1","toponemouse.jpg","","","","0","0","","","","<p style=@text-align: center;@><span style=@background-color: #ccffff;@>&nbsp;</span></p>","0","2018-05-12 18:23:03","2024-01-10 13:04:58");
INSERT INTO products VALUES("2","mango","72782608","standard","C128","","1","1","3","2","8","12","3193","100","","","","","2","2","mango.jpg","","","","0","0","","","","","0","2018-05-12 18:38:31","2023-11-23 16:57:37");
INSERT INTO products VALUES("3","Earphone","85415108","standard","C128","4","2","1","1","1","200","250","153","25","","220","2020-11-02","2020-11-30","","1","airphonesamsung.jpg","","","","0","0","","","","<p>Earphone with good <strong>sound quality.</strong></p>
<p>jhjkhjkhjh @@</p>","0","2018-05-12 18:39:55","2023-11-23 16:55:54");
INSERT INTO products VALUES("4","lychee","38314290","standard","C128","","1","1","1","1","1","2","290","50","","","","","","1","lychee.jpg","","","","0","0","","","","<p style=@text-align: center;@><em>sweet lychee from <strong>kalipur</strong>, bashkhali</em></p>","0","2018-05-23 18:54:56","2023-11-23 16:57:37");
INSERT INTO products VALUES("5","Baby doll","31261512","standard","C128","3","4","1","1","1","100","120","100","50","1","100","2020-02-28","2020-02-29","","1","lalacrybabydoll.jpg","","","","0","0","","","","","0","2018-05-23 18:58:20","2023-11-23 17:12:13");
INSERT INTO products VALUES("6","test","78041363","standard","C128","","2","1","1","1","12","21","0","","","","","","","1","","","","","","","","","","","0","2018-05-27 19:50:25","2023-11-23 16:55:54");
INSERT INTO products VALUES("10","potato","212132","standard","C128","","9","7","7","7","10","22","111","","","","","","","1","potato.jpeg","","","","","","","","","","0","2018-06-24 21:34:53","2023-11-23 16:53:26");
INSERT INTO products VALUES("13","ldms","40624536","digital","C128","","3","0","0","0","0","21","0","","","","","","","1","ldms.jpg","1532330693.JPG","","","0","0","","","","<p>Amazon Prime 1 Month<br />Price: 300tk</p>
<p>User Ability: Max 2 Mobile User<br />Duration: 1 Month<br />Package: Premium</p>","0","2018-07-22 21:09:29","2023-11-25 16:15:12");
INSERT INTO products VALUES("14","ni","40237871","standard","C128","","9","8","8","8","55","56","0","","","","","","","1","","","","","","","","","","","0","2018-07-31 18:36:51","2023-11-23 16:53:26");
INSERT INTO products VALUES("15","edawe","awd","standard","C128","","1","4","4","4","312","132","0","","","","","","","1","","","","","","","","","","","0","2018-08-04 21:26:19","2023-11-23 16:57:37");
INSERT INTO products VALUES("16","weq","eqw","digital","C128","","2","0","0","0","0","2","0","","","","","","","1","","1533454125.jpg","","","","","","","","","0","2018-08-04 21:28:45","2023-11-23 16:55:54");
INSERT INTO products VALUES("17","et","wer","standard","C128","","2","4","4","4","12","21","0","","","","","","","1","","","","","","","","","","","0","2018-08-06 00:25:43","2023-11-23 16:55:54");
INSERT INTO products VALUES("18","wre","wre","standard","C128","","1","4","4","4","3","2","0","","","","","","","1","","","","","","","","","","","0","2018-08-06 00:45:42","2023-11-23 16:57:37");
INSERT INTO products VALUES("19","ewr","wer","standard","C128","","2","4","4","4","3","23","0","","1","","2018-08-06","2018-08-10","","1","","","","","","","","","","","0","2018-08-06 01:41:46","2023-11-23 16:55:54");
INSERT INTO products VALUES("20","dim","4234","standard","C128","","10","1","1","1","1","2","0","","","","","","","1","","","","","","","","","","","0","2018-08-28 19:37:07","2018-08-28 19:43:18");
INSERT INTO products VALUES("21","dim","1","standard","C128","","11","1","1","1","1","2","0","","","","","","","1","","","","","","","","","","","0","2018-08-28 19:49:27","2018-08-28 19:53:21");
INSERT INTO products VALUES("22","iphone-X","97103461","standard","C128","5","2","1","1","1","800","1000","114","20","","","","","1","1","iphoneX.jpg","","","","0","0","","","","","0","2018-09-03 00:05:17","2023-11-23 16:55:54");
INSERT INTO products VALUES("23","qwq","1237920612311a","standard","C39","","2","1","1","1","1","2","0","","","","","","","1","","","","","","","","","","","0","2018-09-10 19:53:18","2023-11-23 16:55:54");
INSERT INTO products VALUES("24","chocolate","84802317","standard","C128","","9","1","1","1","1","2","0","","","","","","","1","","","","","","1","","","","","0","2018-09-15 17:42:01","2023-11-23 16:53:26");
INSERT INTO products VALUES("25","Galaxy S9","72100265","standard","C128","","2","1","1","1","500","1000","74","50","","","","","1","1","SamsungGalaxyS9.jpg","","","","0","0","","","","","0","2018-10-22 21:13:22","2023-11-23 16:55:54");
INSERT INTO products VALUES("26","Samsung Set","39053411","combo","C128","4","2","0","0","0","0","1250","0","","","","","","","1","zummXD2dvAtI.png","","","","","","3,25","1,1","250,1000","","0","2018-11-18 22:59:06","2023-11-23 16:55:54");
INSERT INTO products VALUES("27","mixed fruit juice","24805187","combo","C128","","9","0","0","0","0","16","0","","","","","","","1","zummXD2dvAtI.png","","","","","","4,2","3,1","2,10","","0","2018-11-19 04:39:26","2023-11-23 16:53:26");
INSERT INTO products VALUES("28","ssaaa","sasas","standard","C128","","2","1","1","2","1","2","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","0","2018-11-19 23:14:12","2023-11-23 16:55:54");
INSERT INTO products VALUES("29","testcloth","16055884","standard","C128","","4","10","10","10","10","15","0","","","","2018-11-29","","","1","zummXD2dvAtI.png","","","","","","","","","","0","2018-11-28 22:49:25","2023-11-23 17:12:13");
INSERT INTO products VALUES("30","Polo Shirt","53467102","standard","C128","","12","1","1","1","50","100","24","10","","","","","","1","PoloShirt.jpg","","","","0","0","","","","","0","2018-12-04 18:29:43","2024-01-10 12:32:20");
INSERT INTO products VALUES("31","Shoe","90471412","standard","C128","","12","1","1","1","250","300","20","10","","","","","","1","Shoe.jpg","","","","0","0","","","","","0","2018-12-04 18:33:09","2024-01-10 12:32:20");
INSERT INTO products VALUES("32","Toothpaste","859875003032","standard","C128","","12","1","1","1","5","10","29","","","","","","","1","1572759415477product-page-fresh-breath.jpg","","","1","0","0","","","","","0","2018-12-18 18:56:08","2024-01-10 12:32:20");
INSERT INTO products VALUES("33","tissue","8941161008066","standard","C128","","12","1","1","1","10","20","38","","","","","","","1","zummXD2dvAtI.png","","","","","0","","","","","0","2018-12-23 18:33:58","2024-01-10 12:32:20");
INSERT INTO products VALUES("48","T-shirt","93475396","standard","C128","","12","1","1","1","2","3","38","","","","","","","1","1577165120189220px-Blue_Tshirt.jpg","","1","","","0","","","","","0","2019-11-21 02:03:04","2024-01-10 12:32:20");
INSERT INTO products VALUES("60","testvar","32081679","standard","C128","","12","1","1","1","1","2","1","","","","","","","1","zummXD2dvAtI.png","","1","","","0","","","","","0","2020-05-18 12:44:14","2024-01-10 12:32:20");
INSERT INTO products VALUES("61","TV","32703342","standard","C128","4","2","1","1","1","3000","10000","16","","","","","","2","1","zummXD2dvAtI.png","","","","0","0","","","","","0","2020-08-16 11:58:39","2023-11-23 16:55:54");
INSERT INTO products VALUES("62","Test variant","81145830","standard","C128","","4","1","1","1","1","2","3","","","","","","","1","zummXD2dvAtI.png","","1","","","","","","","","0","2020-09-27 02:08:27","2023-11-23 17:12:13");
INSERT INTO products VALUES("71","Napa","41930312","standard","C128","","19","1","1","1","1","2","29","","","","","","","1","zummXD2dvAtI.png","","","1","0","0","","","","","0","2021-03-07 03:12:53","2023-11-23 17:11:05");
INSERT INTO products VALUES("72","Chicken Tikka","81133180","standard","C128","8","9","1","1","1","100","220","995","","","","","","","1","1639893850829Chicken_Tikka_Skewers_03.jpeg","","","","","1","","","","","0","2021-12-19 12:05:07","2023-11-23 16:53:26");
INSERT INTO products VALUES("73","KANDAHARI CHICKEN","40015686","standard","C128","8","9","1","1","1","120","240","996","","","","","","","1","1639894475116kandahari chicken.jpeg","","","","","1","","","","","0","2021-12-19 12:14:43","2023-11-23 16:53:26");
INSERT INTO products VALUES("74","RESHMI KEBAB","02724591","standard","C128","8","9","1","1","1","450","1380","995","","","","","","","1","1639894685666chicken-reshmi-kabab...jpg","","","","","1","","","","","0","2021-12-19 12:18:23","2023-11-23 16:53:26");
INSERT INTO products VALUES("75","CHICKEN BOTI KEBAB","69098022","standard","C128","8","9","1","1","1","100","200","997","","","","","","","1","1639894829137095513974c0e077c0cd5ff394b3c9d10.jpg","","","","","1","","","","","0","2021-12-19 12:20:39","2023-11-23 16:53:26");
INSERT INTO products VALUES("76","CHICKEN LIVER KEBAB","02401815","standard","C128","8","9","1","1","1","70","180","999","","","","","","","1","1639894982321Recipes_Grilled_Chicken_Liver_Kabobs_Thumb_420x420.jpg","","","","","1","","","","","0","2021-12-19 12:23:06","2023-11-23 16:53:26");
INSERT INTO products VALUES("77","CHICKEN CHARGHA","63001857","standard","C128","8","9","1","1","1","300","1300","2000","","","","","","","1","1639895195567unnamed.jpg","","1","","0","1","","","","","0","2021-12-19 12:26:40","2023-11-23 16:53:26");
INSERT INTO products VALUES("78","RESHMI KARAI","60853282","standard","C128","8","9","1","1","1","400","1300","2000","","","","","","","1","16398955370425db616952ea6aa1feaaf432aa9cafe04.jpg","","1","","0","1","","","","","0","2021-12-19 12:30:26","2023-11-23 16:53:26");
INSERT INTO products VALUES("79","CHICKEN KARAI","90190758","standard","C128","8","9","1","1","1","340","1150","2000","","","","","","","1","1639895674696KETOCHICKENKARAHI-Vertica-819x1024.jpg","","1","","","1","","","","","0","2021-12-19 12:35:35","2023-11-23 16:53:26");
INSERT INTO products VALUES("80","CHICKEN GREEN KARAI","09395091","standard","C128","8","9","1","1","1","380","1200","1997","","","","","","","1","1639895827028maxresdefault.jpg","","1","","","1","","","","","0","2021-12-19 12:37:50","2023-11-23 16:53:26");
INSERT INTO products VALUES("81","CHICKEN TIKKA KARAI","30912565","standard","C128","8","9","1","1","1","400","1300","0","","","","","","","1","1639896039543chicken-tikka-masala-indian-curry-chicken-tikka-masala-here-served-balti-dish-karahi-garnished-mint-accompanied-115635462.jpg","","1","","","1","","","","","0","2021-12-19 12:42:03","2023-11-23 16:53:26");
INSERT INTO products VALUES("82","CHICKEN SHISH KEBAB","93323066","standard","C128","8","9","1","1","1","100","220","0","","","","","","","1","1639896292985download (1).jpg","","","","","","","","","","0","2021-12-19 12:44:56","2023-11-23 16:53:26");
INSERT INTO products VALUES("83","MUSHROOM BBQ","83235704","standard","C128","8","9","1","1","1","100","250","1000","","","","","","","1","1639896466599190403-balsamic-mushroom-skewers-123-copy-1554496167.jpeg","","","","","1","","","","","0","2021-12-19 12:47:54","2023-11-23 16:53:26");
INSERT INTO products VALUES("84","MUTTON CURY","79419143","standard","C128","8","9","1","1","1","150","350","993","","","","","","","1","163989667194984667091.jpg","","","","","1","","","","","0","2021-12-19 12:51:19","2023-11-23 16:53:26");
INSERT INTO products VALUES("85","HYDERABADI MUTTON BIRYANI","77030216","standard","C128","8","9","1","1","1","150","450","998","","","","","","","1","16398968210321-34.jpg","","","","","1","","","","","0","2021-12-19 12:53:46","2023-11-23 16:53:26");
INSERT INTO products VALUES("86","VEGETABLE SOUP","99405161","standard","C128","8","9","1","1","1","80","200","998","","","","","","","1","1639896898542vegetable-soup-recipe.jpg","","","","","1","","","","","0","2021-12-19 12:55:03","2023-11-23 16:53:26");
INSERT INTO products VALUES("87","PANEER TIKKA","17920159","standard","C128","8","9","1","1","1","100","270","998","","","","","","","1","1639897023500Achari_Paneer_Tikka_Recipe_Party_Food.jpg","","","","","1","","","","","0","2021-12-19 12:57:09","2023-11-23 16:53:26");
INSERT INTO products VALUES("88","F02","19682938","standard","C128","7","23","1","11","11","1300","2600","485","3","","","2022-03-07","","","1","zummXD2dvAtI.png","","","","","","","","","","0","2022-03-07 09:29:15","2023-11-23 16:58:03");
INSERT INTO products VALUES("89","wkl001","34155706","standard","C128","9","23","1","11","11","500","550","600","50","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","0","2022-03-07 10:05:18","2023-11-23 16:58:03");
INSERT INTO products VALUES("90","wkl002","25107861","standard","C128","9","23","1","11","11","500","550","618","50","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","0","2022-03-07 10:06:09","2023-11-23 16:58:03");
INSERT INTO products VALUES("91","F85","20965136","standard","C128","9","24","1","11","11","600","650","2550","50","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","0","2022-03-07 10:07:51","2023-11-23 17:11:05");
INSERT INTO products VALUES("92","Aluminium","29062787","standard","C128","","27","1","1","1","1000","1200","900","10","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","0","2022-03-16 16:36:01","2023-11-23 17:12:13");
INSERT INTO products VALUES("93","Metal Full Frame","71580061","standard","C128","","28","1","1","1","500","600","8","5","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","0","2022-05-21 23:04:58","2023-11-23 17:12:13");
INSERT INTO products VALUES("94","Rb honey","101","standard","C128","","9","7","9","9","450","800","0","1","","","2022-10-02","","","1","1664647584830edit.jpg","","","","","","","","","<p>natural honey</p>","0","2022-10-02 00:07:26","2023-11-23 16:53:26");
INSERT INTO products VALUES("95","Rui","24104937","standard","C128","","21","1","1","1","10","249","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","0","2022-10-12 01:10:18","2023-11-23 16:57:28");
INSERT INTO products VALUES("96","black seeds honey","12413065","standard","C128","","30","7","7","9","550","1000","0.2","5","","","","","","1","zummXD2dvAtI.png","","","","0","1","","","","","0","2022-10-23 22:46:09","2023-11-23 16:57:52");
INSERT INTO products VALUES("97","Jhumka","71959022","standard","C128","","31","12","12","12","170000","200000","-1","5","","","","","","1","1690400161842jhumka.jpg","","","","","","","","","","0","2023-07-27 01:44:02","2023-11-23 17:09:57");
INSERT INTO products VALUES("98","braKE SER","02323876","digital","C128","","2","0","0","0","0","500","0","","","","","","1","1","1693291207425Picture-2023-03-12 10.45.02.jpg","","","","","1","","","","","0","2023-08-29 12:40:57","2023-11-23 16:55:54");
INSERT INTO products VALUES("99","Miyako Blender (Red Horse)","43900118","standard","C128","10","32","1","1","1","4200","6300","100","3","","","2023-11-23","2023-12-26","","1","1702288001000Miyako Blender (Red Horse).png","","","","0","0","","","","<p>1100 Watt</p>","0","2023-09-20 12:13:13","2023-12-13 12:52:50");
INSERT INTO products VALUES("100","Aclosol Cream","1","standard","C128","7","33","35","35","35","39.73","39.73","0","","","","","","","1","zummXD2dvAtI.png","","1","","","","","","","this is test product with variant","0","2023-10-09 16:07:50","2023-11-23 16:58:23");
INSERT INTO products VALUES("101","Ad-All Capsule","2","standard","C128","","33","14","14","14","264.02","264.02","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","this is test product without variant","0","2023-10-09 16:07:50","2023-11-23 16:58:23");
INSERT INTO products VALUES("102","Adlorin 5 Tablet","3","standard","C128","","33","14","14","14","220.02","220.02","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","0","2023-10-09 16:07:50","2023-11-23 16:58:23");
INSERT INTO products VALUES("103","Adrox PFS","4","standard","C128","","33","15","15","15","159.29","159.29","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","0","2023-10-09 16:07:50","2023-11-23 16:58:23");
INSERT INTO products VALUES("104","Airflow 10 Tablet","5","standard","C128","","33","16","16","16","396.03","396.03","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","0","2023-10-09 16:07:50","2023-11-23 16:58:23");
INSERT INTO products VALUES("105","Aladin Tablet","6","standard","C128","","33","16","16","16","290.43","290.43","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","0","2023-10-09 16:07:50","2023-11-23 16:58:23");
INSERT INTO products VALUES("106","Aldaben Suspension","7","standard","C128","","33","17","17","17","17.61","17.61","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","0","2023-10-09 16:07:50","2023-11-23 16:58:23");
INSERT INTO products VALUES("107","Aldaben-DS Tab","8","standard","C128","","33","18","18","18","110.02","110.02","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","0","2023-10-09 16:07:50","2023-11-23 16:58:23");
INSERT INTO products VALUES("108","Alerjess Syrup (100ml)","9","standard","C128","","33","19","19","19","19.00","19.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","0","2023-10-09 16:07:50","2023-11-23 16:58:23");
INSERT INTO products VALUES("109","Alerjess Syrup (60ml)","10","standard","C128","","33","20","20","20","17.61","17.61","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","0","2023-10-09 16:07:50","2023-11-23 16:58:23");
INSERT INTO products VALUES("110","Alerjess Tablet","11","standard","C128","","33","21","21","21","120.00","120.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","0","2023-10-09 16:07:50","2023-11-23 16:58:23");
INSERT INTO products VALUES("111","Alerjess Tablet1","12","standard","C128","","33","14","14","14","17.60","17.60","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","0","2023-10-09 16:07:50","2023-11-23 16:58:23");
INSERT INTO products VALUES("112","Amobet Cream","13","standard","C128","","33","35","35","35","26.40","26.40","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","0","2023-10-09 16:07:50","2023-11-23 16:58:23");
INSERT INTO products VALUES("113","Aroxia 120 Tablet","14","standard","C128","","33","22","22","22","202.41","202.41","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","0","2023-10-09 16:07:50","2023-11-23 16:58:23");
INSERT INTO products VALUES("114","Aroxia 60 Tablet","15","standard","C128","","33","16","16","16","177.42","177.42","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","0","2023-10-09 16:07:50","2023-11-23 16:58:23");
INSERT INTO products VALUES("115","Aroxia 90 Tablet","16","standard","C128","","33","22","22","22","161.93","161.93","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","0","2023-10-09 16:07:50","2023-11-23 16:58:23");
INSERT INTO products VALUES("116","Avidol 6.25mg Tablet","17","standard","C128","","33","24","24","24","158.41","158.41","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","0","2023-10-09 16:07:50","2023-11-23 16:58:23");
INSERT INTO products VALUES("117","B-Plex Syrup (100ml)","18","standard","C128","","33","19","19","19","31.37","31.37","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","0","2023-10-09 16:07:50","2023-11-23 16:58:23");
INSERT INTO products VALUES("118","B-Plex Syrup (200ml)","19","standard","C128","","33","25","25","25","54.74","54.74","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","0","2023-10-09 16:07:50","2023-11-23 16:58:23");
INSERT INTO products VALUES("119","B-Plex Tablet","20","standard","C128","","33","26","26","26","24.55","24.55","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","0","2023-10-09 16:07:50","2023-11-23 16:58:23");
INSERT INTO products VALUES("120","B-Z Tablet","21","standard","C128","","33","27","27","27","52.81","52.81","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","0","2023-10-09 16:07:50","2023-11-23 16:58:23");
INSERT INTO products VALUES("121","Calcium A&D Tablet (15)","22","standard","C128","","33","28","28","28","50.16","50.16","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","0","2023-10-09 16:07:50","2023-11-23 16:58:23");
INSERT INTO products VALUES("122","Calcium A&D Tablet (30)","23","standard","C128","","33","27","27","27","95.00","95.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","0","2023-10-09 16:07:50","2023-11-23 16:58:23");
INSERT INTO products VALUES("123","Calcium-A Tablet","24","standard","C128","","33","14","14","14","299.22","299.22","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","0","2023-10-09 16:07:50","2023-11-23 16:58:23");
INSERT INTO products VALUES("124","Calonil Tablet (100)","25","standard","C128","","33","29","29","29","88.00","88.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","0","2023-10-09 16:07:50","2023-11-23 16:58:23");
INSERT INTO products VALUES("125","Calonil Tablet (50)","26","standard","C128","","33","30","30","30","44.00","44.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","0","2023-10-09 16:07:50","2023-11-23 16:58:23");
INSERT INTO products VALUES("126","Calonil Tablet (500)","27","standard","C128","","33","31","31","31","440.03","440.03","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","0","2023-10-09 16:07:50","2023-11-23 16:58:23");
INSERT INTO products VALUES("127","Carlos 50 Tablet","28","standard","C128","","33","16","16","16","184.83","184.83","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","0","2023-10-09 16:07:50","2023-11-23 16:58:23");
INSERT INTO products VALUES("128","Cartace 2.5mg Tablet","29","standard","C128","","33","16","16","16","161.93","161.93","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","0","2023-10-09 16:07:50","2023-11-23 16:58:23");
INSERT INTO products VALUES("129","Cefixime- A Capsule","30","standard","C128","","33","32","32","32","431.24","431.24","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","0","2023-10-09 16:07:50","2023-11-23 16:58:23");
INSERT INTO products VALUES("130","Cefixime-A PFS","31","standard","C128","","33","33","33","33","184.83","184.83","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","0","2023-10-09 16:07:50","2023-11-23 16:58:23");
INSERT INTO products VALUES("131","Cevozin 5mg Tablet","32","standard","C128","","33","14","14","14","176.02","176.02","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","0","2023-10-09 16:07:50","2023-11-23 16:58:23");
INSERT INTO products VALUES("132","Ciproxen 250 Tablet","33","standard","C128","","33","16","16","16","184.81","184.81","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","0","2023-10-09 16:07:50","2023-11-23 16:58:23");
INSERT INTO products VALUES("133","Ciproxen 500 Tablet","34","standard","C128","","33","16","16","16","396.04","396.04","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","0","2023-10-09 16:07:50","2023-11-23 16:58:23");
INSERT INTO products VALUES("134","Ciproxen PFS","35","standard","C128","","33","20","20","20","88.02","88.02","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","0","2023-10-09 16:07:50","2023-11-23 16:58:23");
INSERT INTO products VALUES("135","Cirizin Syrup","36","standard","C128","","33","20","20","20","26.41","26.41","50","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","0","2023-10-09 16:07:50","2023-11-23 16:58:23");
INSERT INTO products VALUES("136","Cirizin Tablet","37","standard","C128","","33","14","14","14","264.03","264.03","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","0","2023-10-09 16:07:50","2023-11-23 16:58:23");
INSERT INTO products VALUES("137","Cladin 10mg Tablet","38","standard","C128","","33","14","14","14","198.02","198.02","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","0","2023-10-09 16:07:50","2023-11-23 16:58:23");
INSERT INTO products VALUES("138","Clogrel 75 Tablet","39","standard","C128","","33","23","23","23","356.43","356.43","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","0","2023-10-09 16:07:50","2023-11-23 16:58:23");
INSERT INTO products VALUES("139","Clogrel Plus Tablet","40","standard","C128","","33","16","16","16","290.43","290.43","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","0","2023-10-09 16:07:50","2023-11-23 16:58:23");
INSERT INTO products VALUES("140","Co-Try Suspension","41","standard","C128","","33","20","20","20","18.92","18.92","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","0","2023-10-09 16:07:50","2023-11-23 16:58:23");
INSERT INTO products VALUES("141","Co-Try-DS 960mg Tab","42","standard","C128","","33","14","14","14","176.02","176.02","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","0","2023-10-09 16:07:50","2023-11-23 16:58:23");
INSERT INTO products VALUES("142","Combomin Tablet","43","standard","C128","","33","16","16","16","158.42","158.42","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","0","2023-10-09 16:07:50","2023-11-23 16:58:23");
INSERT INTO products VALUES("143","Conatrim Cream","44","standard","C128","","33","35","35","35","29.92","29.92","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","0","2023-10-09 16:07:50","2023-11-23 16:58:23");
INSERT INTO products VALUES("144","D-Met 500 Tablet","45","standard","C128","","33","30","30","30","176.02","176.02","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","0","2023-10-09 16:07:50","2023-11-23 16:58:23");
INSERT INTO products VALUES("145","D-Met 850 Tablet","46","standard","C128","","33","30","30","30","220.02","220.02","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","0","2023-10-09 16:07:50","2023-11-23 16:58:23");
INSERT INTO products VALUES("146","Duomeal Suspension","47","standard","C128","","33","25","25","25","35.21","35.21","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","0","2023-10-09 16:07:50","2023-11-23 16:58:23");
INSERT INTO products VALUES("147","Duomeal Tablet","48","standard","C128","","33","34","34","34","93.29","93.29","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","0","2023-10-09 16:07:50","2023-11-23 16:58:23");
INSERT INTO products VALUES("148","Emigut 8 Tablet","49","standard","C128","","33","16","16","16","290.43","290.43","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","0","2023-10-09 16:07:50","2023-11-23 16:58:23");
INSERT INTO products VALUES("149","Emigut Oral Solution","50","standard","C128","","33","33","33","33","42.26","42.26","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","0","2023-10-09 16:07:50","2023-11-23 16:58:23");
INSERT INTO products VALUES("150","Slingback black","5011ME06","standard","C128","","23","1","1","1","300","990","12","","","","","","","2","1698005536275Fleet 2.JPG","","1","","","","","","","","0","2023-10-23 02:13:56","2023-11-23 16:58:03");
INSERT INTO products VALUES("151","Nimocon 500","Nim500","standard","C128","11","35","1","1","1","35","40","490","10","","","","","","1","zummXD2dvAtI.png","","","1","0","0","","","","<p>500 mg, Tablet</p>","0","2023-10-29 13:54:24","2023-11-23 16:54:50");
INSERT INTO products VALUES("152","Cefufine","Cef125","standard","C128","12","36","1","1","1","30","35","490","","","","","","","1","zummXD2dvAtI.png","","","1","0","0","","","","<p>125 mg/5 ml, Powder For Suspension</p>","0","2023-10-29 13:54:24","2023-11-23 16:54:32");
INSERT INTO products VALUES("153","Aldaben DS 400","Ald400","standard","C128","13","38","1","1","1","5","7","990","","","","","","","1","zummXD2dvAtI.png","","","1","0","0","","","","<p>400 mg, Tablet</p>","0","2023-10-29 13:54:24","2023-11-23 16:53:45");
INSERT INTO products VALUES("154","Acidex 20","Acid20","standard","C128","11","39","1","1","1","5","7","0","","","","","","","1","zummXD2dvAtI.png","","","1","0","0","","","","<p>20 mg, Capsule</p>","0","2023-10-29 17:57:03","2023-11-23 17:09:57");
INSERT INTO products VALUES("155","Levetiracetam 250","Leve250","standard","C128","11","40","1","1","1","12","15","0","","","","","","","1","zummXD2dvAtI.png","","","1","0","0","","","","<p>250 mg, Tablet</p>","0","2023-10-29 17:57:03","2023-11-23 17:09:57");
INSERT INTO products VALUES("156","Levetiracetam 500","Leve500","standard","C128","11","40","1","1","1","18","20","0","","","","","","","1","zummXD2dvAtI.png","","","1","0","0","","","","<p>500 mg, Tablet</p>","0","2023-10-29 17:57:03","2023-11-23 17:09:57");
INSERT INTO products VALUES("157","Cefatop","Cefat","standard","C128","12","41","1","1","1","150","170","0","","","","","","","1","zummXD2dvAtI.png","","","1","0","0","","","","<p>100 mg/5 ml, Powder For Suspension</p>","0","2023-10-29 17:57:03","2023-11-23 16:55:54");
INSERT INTO products VALUES("158","Maxtrol 20","Max20","standard","C128","12","42","1","1","1","8","10","0","","","","","","","1","zummXD2dvAtI.png","","","1","0","0","","","","<p>20 mg, Tablet</p>","0","2023-10-29 17:57:03","2023-11-23 16:55:54");
INSERT INTO products VALUES("159","Atofine 20","Ato20","standard","C128","12","43","1","1","1","10","12","0","","","","","","","1","zummXD2dvAtI.png","","","1","0","0","","","","<p>20 mg, Tablet</p>","0","2023-10-29 17:57:03","2023-11-23 16:54:41");
INSERT INTO products VALUES("160","Atofine 10","Ato10","standard","C128","12","43","1","1","1","7","10","0","","","","","","","1","zummXD2dvAtI.png","","","1","0","0","","","","<p>10 mg, Tablet</p>","0","2023-10-29 17:57:03","2023-11-23 16:54:41");
INSERT INTO products VALUES("161","Azifine","Azif","standard","C128","12","43","1","1","1","180","200","0","","","","","","","1","zummXD2dvAtI.png","","","1","0","0","","","","<p>200 mg/5 ml, Powder For Suspension</p>","0","2023-10-29 17:57:03","2023-11-23 16:54:41");
INSERT INTO products VALUES("162","Azifine 500","Azif500","standard","C128","12","35","1","1","1","30","35","0","","","","","","","1","zummXD2dvAtI.png","","","1","0","0","","","","<p>500 mg, Tablet</p>","0","2023-10-29 17:57:03","2023-11-23 16:54:50");
INSERT INTO products VALUES("163","DOEL Freedom Laptop","95613704","standard","C128","","97","1","1","1","26999","32999","9","10","","30000","2023-11-23","2025-01-01","1","2","1702536782524DOEL Freedom Laptop.jpg","","","","0","1","","","","<p>A9 AMD A9-9425 14.1; HD Laptop</p>
<p>Model: Freedom A9</p>
<p>Processor: AMD A9-9425 (1MB Cache, 3.10GHz up to 3.70GHz)</p>
<p>RAM: 4GB, Storage: 240GB SSD</p>
<p>Display: 14.1@ HD (1366x768)</p>
<p>Features: HD Webcam, Type-C</p>","0","2023-11-23 18:08:30","2024-01-10 13:07:10");
INSERT INTO products VALUES("164","Miyako Blender  	Green Hornet","93107380","standard","C128","10","32","1","1","1","3700","5500","0","10","1","5400","2023-11-23","2025-01-01","1","2","1702287738510green.jpg","","","","0","0","","","","","0","2023-11-23 18:15:32","2023-12-13 12:52:58");
INSERT INTO products VALUES("165","HP fq3617TU FHD Laptop","30543610","standard","C128","3","97","1","1","1","41000","45000","0","10","1","44000","2023-11-23","2025-01-01","1","2","1702288146417hplaptop.jpg","","","","0","1","","","","<h2>Key Features</h2>
<p>15s-fq3617TU Celeron N4500 15.6&amp;amp;amp;quot; FHD Laptop</p>
<ul>
<li>MPN: 7K1K6PA</li>
<li>Model: 15s-fq3617TU</li>
<li>Processor: Intel Celeron N4500 (4M Cache, 1.10 GHz up to 2.80 GHz)</li>
<li>RAM: 4GB 2933 MHz, Storage: 256GB SSD</li>
<li>Display: 15.6@ FHD (1920 x 1080)</li>
<li>Feature: Dual speakers, Type-C</li>
</ul>","0","2023-11-23 18:26:27","2024-01-10 13:07:10");
INSERT INTO products VALUES("166","Miyako Coffee Maker","30210137","standard","C128","10","32","1","1","1","2050","2850","20","10","","","","","1","1","1702293294103Miyako Coffee Maker.jpg","","","","0","0","","","","","0","2023-11-25 16:27:35","2023-12-13 12:52:41");
INSERT INTO products VALUES("167","Miyako Electric Juicer","52691713","standard","C128","10","32","1","1","1","2450","3450","10","10","","","","","1","1","1702373148002Miyako Blender (Red Horse).png","","","","0","0","","","","","0","2023-11-25 16:35:06","2023-12-13 12:49:54");
INSERT INTO products VALUES("168","Miyako Food Processor","01658794","standard","C128","10","32","1","1","1","4500","6700","9","10","1","6500","2023-11-25","2024-06-29","","1","1702291258815Miyako Food Processor.png","","","","0","1","","","","","0","2023-11-25 17:18:11","2023-12-13 12:49:35");
INSERT INTO products VALUES("169","Miyako Dry Iron","19819082","standard","C128","10","32","1","1","1","1550","2550","10","10","1","2400","2023-11-25","2025-01-01","","1","1702291429268Miyako Dry Iron.jpg","","","","0","1","","","","","0","2023-11-25 17:19:44","2023-12-13 12:49:45");
INSERT INTO products VALUES("170","Miyako Sandwich Maker","14110934","standard","C128","10","32","1","1","1","950","1350","0","10","1","1320","2023-11-25","2025-01-01","","1","1702373418896Miyako Sandwich Maker.jpg","","","","0","1","","","","","0","2023-11-25 17:21:02","2023-12-13 12:50:03");
INSERT INTO products VALUES("171","Miyako Hair Dryer","31779340","standard","C128","10","32","1","1","1","1075","1550","0","10","1","1500","2023-11-26","2025-01-01","1","1","1702373315444Miyako Hair Dryer.jpg","","","","0","1","","","","","0","2023-11-26 11:24:34","2023-12-13 12:50:39");
INSERT INTO products VALUES("172","Miyako Doi Maker","96994145","standard","C128","10","32","1","1","1","1600","2650","0","10","1","2600","2023-11-26","2025-01-01","","1","1702373046528Miyako Doi Maker.jpg","","","","0","1","","","","","0","2023-11-26 11:32:21","2023-12-13 12:52:33");
INSERT INTO products VALUES("173","Miyako Electric Kattle","63104978","standard","C128","10","32","1","1","1","1350","2350","0","10","1","2300","2023-11-26","2025-01-01","","1","1702373244314Miyako Electric Kattle.jpg","","","","0","1","","","","","0","2023-11-26 11:34:05","2023-12-13 12:50:50");
INSERT INTO products VALUES("174","NOVA Android TV 	NV-3230H SM","21855217","standard","C128","","32","1","1","1","13800","20700","0","10","1","20500","2023-11-26","2025-01-01","","1","1702285125136android tv.jpg","","","","0","1","","","","<p>32 Inche</p>","0","2023-11-26 11:36:27","2023-12-13 12:50:30");
INSERT INTO products VALUES("175","NOVA Mixer Grinder","77462940","standard","C128","","32","1","1","1","3900","5850","0","10","1","5800","2023-11-26","2025-01-01","","1","1702373620879NOVA Mixer Grinder.jpg","","","","0","1","","","","","0","2023-11-26 11:44:01","2023-12-13 12:50:20");
INSERT INTO products VALUES("176","Weidasi Mosquito Swatter","50912018","standard","C128","","32","1","1","1","400","620","0","10","1","600","2023-11-26","2025-01-01","","1","1702373707920Weidasi Mosquito Swatter.jpg","","","","0","1","","","","","0","2023-11-26 11:45:17","2023-12-13 12:50:12");
INSERT INTO products VALUES("177","HP HD Laptop","62245194","standard","C128","3","97","1","1","1","30000","33000","10","10","1","32000","2023-11-26","2025-01-01","","1","1702288795735laptop1.jpg","","","","0","1","","","","<p>MPN: 7K1K6PA</p>
<p>Model: 15s-fq3617TU</p>
<p>Processor: Intel Celeron N4500 (4M Cache, 1.10 GHz up to 2.80 GHz)</p>
<p>RAM: 4GB 2933 MHz, Storage: 256GB SSD</p>
<p>Display: 15.6@ FHD (1920 x 1080)</p>
<p>Feature: Dual speakers, Type-C</p>","0","2023-11-26 12:02:28","2024-01-10 13:07:10");
INSERT INTO products VALUES("178","HP 15s-fq5786TU","49805131","standard","C128","3","97","1","1","1","40500","42000","10","","1","41500","2023-11-26","2025-01-01","","1","1702293108102HP 15s-Fq5786TU FHD Laptop.jpg","","","","0","1","","","","<p>15s-fq5786TU Core i3 12th Gen 15.6&amp;quot; FHD Laptop</p>
<p>MPN: 681P9PA</p>
<p>Model: 15s-fq5786TU</p>
<p>Processor: Intel Core i3-1215U (10M Cache, up to 4.40 GHz)</p>
<p>RAM: 8GB RAM, Storage: 512GB SSD</p>
<p>Display: 15.6@ FHD (1920 x 1080)</p>
<p>Features: Spill-resistant Keyboard, Type-C</p>","0","2023-11-26 12:04:16","2024-01-10 13:07:10");
INSERT INTO products VALUES("179","HP ProBook 440 2","85311065","standard","C128","3","97","1","1","1","50000","53000","10","10","1","54000","2023-11-26","2025-01-01","","1","1702292808287hppro.jpg","","","","0","1","","","","<p>G9 Core i5 12th Gen 14th; FHD Laptop</p>","0","2023-11-26 12:06:52","2024-01-10 13:07:10");
INSERT INTO products VALUES("180","HP FHD LAPTOP","32842643","standard","C128","3","97","1","1","1","45000","47000","10","","1","46000","2023-11-26","2025-01-01","","1","1702288873593hplaptop.jpg","","","","0","1","","","","<p>15s-eq2618AU Ryzen 3 5300U 15.6&amp;quot; HD Laptop</p>","0","2023-11-26 12:17:45","2024-01-10 13:07:10");
INSERT INTO products VALUES("181","HP Pavilion 15-eg2116TU","53297053","standard","C128","3","97","1","1","1","55000","57000","10","12","1","56000","2023-11-26","2025-01-01","","1","1702292454629hplaptop.jpg","","","","0","1","","","","<p>15-eg2116TU Core i5 12th Gen 15.6&amp;quot; FHD Laptop</p>","0","2023-11-26 12:19:39","2024-01-10 13:07:10");
INSERT INTO products VALUES("182","HP Pavilion 15-eg2117TU  FHD Laptop","04086313","standard","C128","3","97","1","1","1","70000","75000","0","10","1","73000","2023-11-26","","","1","1702292337847HP Pavilion 15-Eg2117TU FHD Laptop.jpg","","","","0","1","","","","<p>Core i7 12th Gen 15.6; FHD Laptop</p>","0","2023-11-26 12:23:07","2024-01-10 13:07:10");
INSERT INTO products VALUES("183","HP Victus","55148983","standard","C128","3","97","1","1","1","80000","85500","0","11","1","84000","2023-11-26","","","1","1702292115534victus.jpg","","","","0","1","","","","<p>15-fa0163TX Core i5 12th Gen RTX 3050 4GB Graphics 15.6; FHD 144Hz Gaming Laptop</p>","0","2023-11-26 12:25:08","2024-01-10 13:07:10");
INSERT INTO products VALUES("184","HP ProBook 440","60214873","standard","C128","3","97","1","1","1","90000","95000","1","11","1","94000","2023-11-26","","","1","1702291942367laptop1.jpg","","","","0","1","","","","<p>G9 Core i7 12th Gen 14; FHD Laptop</p>","0","2023-11-26 12:50:11","2024-01-10 13:07:10");
INSERT INTO products VALUES("185","HP ProBook","39529218","standard","C128","3","97","1","1","1","46000","50000","0","","1","49000","2023-11-26","","","1","1702291696613hplaptop.jpg","","","","0","1","","","","<p>440 G8 Core i3 11th Gen 14; FHD Laptop</p>","0","2023-11-26 12:52:35","2024-01-10 13:07:10");
INSERT INTO products VALUES("186","Kiam Pressure Cooker","32201494","standard","C128","","32","1","1","1","1075","1290","0","11","1","1250","2023-11-26","","","1","1702291576074Kiam Pressure Cooker.jpg","","","","0","1","","","","","0","2023-11-26 13:04:43","2023-12-13 12:49:08");
INSERT INTO products VALUES("187","Acer LFR0V5E","00331-10000-00001-AA095","standard","C128","11","97","1","1","1","11000","16500","0","","1","15000","","","","1","1702289536274l4.png,1702289541690l3.png","","","","0","1","","","","<p>Processor: Intel (R) Core (TM) i3-2310M CPU @ 2.10 GHz&nbsp;&nbsp; 2.10 GHz</p>
<p>RAM: 4.00 GB</p>
<p>SSD: 240 GB</p>
<p>Windows: Windows 10 Pro</p>","0","2023-12-11 15:35:58","2024-01-10 13:07:10");
INSERT INTO products VALUES("188","GREE Air Conditioner (GS-12FA410) 1.0 Ton","82131622","standard","C128","14","100","1","1","1","42350","51000","0","","","","","","","1","1702454327655XPUV3289.png,1702467026231GREE Air Conditioner (GS-12FA410) 1.0 Ton.jpg","","","","0","0","","","","<p>GS-12FA410 Gree Fairy-Split Type Air Conditioner (1.0 TON)<br />৳ 45900 ৳ 51000<br />Control: Remote<br />Function: Cooling<br />Capacity: 12000 BTU<br />Color: White &amp; Golden<br />Comfortable Sleeping mood<br />Cold air prevention<br />Clock Display<br />Washable Air Purify Filters<br />LED Display</p>
<p>Warranty:</p>
<p>Compressor 5 (Years)<br />Spare Parts 1 (Year)<br />After Sales Service 1 (Year)</p>","0","2023-12-13 13:18:24","2024-01-10 12:32:20");
INSERT INTO products VALUES("189","GREE Air Conditioner (GS-12LM410) 1.0 Ton","33617501","standard","C128","14","100","1","1","1","42350","51000","0","","","","","","","1","1702468182718GREE Air Conditioner (GS-12LM410) 1.0 Ton.jpg","","","","0","0","","","","","0","2023-12-13 13:18:24","2024-01-10 12:32:20");
INSERT INTO products VALUES("190","GREE Air Conditioner (GS-12MU410) 1.0 Ton","61299271","standard","C128","14","100","1","1","1","41925","50500","0","","","","","","","1","1702468243498GREE Air Conditioner (GS-12MU410) 1.0 Ton.jpg","","","","0","0","","","","","0","2023-12-13 13:18:24","2024-01-10 12:32:20");
INSERT INTO products VALUES("191","GREE Air Conditioner (GS-18LM410) 1.5 Ton","40399237","standard","C128","14","100","1","1","1","56000","66990","0","","","","","","","1","1702468291544GREE Air Conditioner (GS-18LM410) 1.5 Ton.jpg","","","","0","0","","","","","0","2023-12-13 13:18:24","2024-01-10 12:32:20");
INSERT INTO products VALUES("192","GREE Air Conditioner (GS-18MU410) 1.5 Ton","1721196","standard","C128","14","100","1","1","1","55950","66990","0","","","","","","","1","1702468342342GREE Air Conditioner (GS-18MU410) 1.5 Ton.jpg","","","","0","0","","","","","0","2023-12-13 13:18:24","2024-01-10 12:32:20");
INSERT INTO products VALUES("193","GREE Air Conditioner (GS-18NFA410) 1.5 Ton","34294917","standard","C128","14","100","1","1","1","56000","66990","0","","","","","","","1","1702468399359GREE Air Conditioner (GS-12FA410) 1.0 Ton.jpg","","","","0","0","","","","","0","2023-12-13 13:18:24","2024-01-10 12:32:20");
INSERT INTO products VALUES("194","GREE Air Conditioner (GS-24LM410) 2.0 Ton","90945836","standard","C128","14","100","1","1","1","68700","81990","0","","","","","","","1","1702468425197GREE Air Conditioner (GS-12LM410) 1.0 Ton.jpg","","","","0","0","","","","","0","2023-12-13 13:18:24","2024-01-10 12:32:20");
INSERT INTO products VALUES("195","GREE Air Conditioner (GS-24MU410) 2.0 Ton","78819432","standard","C128","14","100","1","1","1","68700","81990","0","","","","","","","1","1702468448879GREE Air Conditioner (GS-18MU410) 1.5 Ton.jpg","","","","0","0","","","","","0","2023-12-13 13:18:24","2024-01-10 12:32:20");
INSERT INTO products VALUES("196","GREE Air Conditioner (GS-24NFA410) 2.0 Ton","97382162","standard","C128","14","100","1","1","1","69000","82290","0","","","","","","","1","1702468496314GREE Air Conditioner (GS-12FA410) 1.0 Ton.jpg","","","","0","0","","","","","0","2023-12-13 13:18:24","2024-01-10 12:32:20");
INSERT INTO products VALUES("197","GREE Hot Cool Air Conditioner (GS-36XCZV32) 3.0 Ton","52899312","standard","C128","14","100","1","1","1","138400","164000","0","","","","","","","1","1702547925869ac.jpeg","","","","0","0","","","","","0","2023-12-13 13:18:24","2024-01-10 12:32:20");
INSERT INTO products VALUES("198","GREE Hot and Cool Air Conditioner (GSH-12FA410) 1.0 Ton","31635624","standard","C128","14","100","1","1","1","43200","52000","0","","","","","","","1","1702547678350ac.jpeg","","","","0","0","","","","","0","2023-12-13 13:18:24","2024-01-10 12:32:20");
INSERT INTO products VALUES("199","GREE Hot and Cool Air Conditioner 1.5 Ton","97893863","standard","C128","14","100","1","1","1","57500","68890","0","","","","","","","1","1702544992699GREE Air Conditioner .jpg","","","","0","0","","","","<p>Capacity: 18,000 Btu/Hr. (1.5 Ton)<br />Model: GSH-18XFA410 (Non-Inverter System, Hot &amp; Cool AC)<br />Origin &amp; Made In: China</p>","0","2023-12-13 13:18:24","2024-01-10 12:32:20");
INSERT INTO products VALUES("200","GREE Hot and Cool Air Conditioner 2.0 Ton","20893342","standard","C128","14","100","1","1","1","70000","83290","0","","","","","","","1","1702547907178ac.jpeg","","","","0","0","","","","","0","2023-12-13 13:18:24","2024-01-10 12:32:20");
INSERT INTO products VALUES("201","GREE Inverter Air Conditioner (GS-12XFV32) 1.0 Ton","99818351","standard","C128","14","100","1","1","1","48725","58500","0","","","","","","","1","1702540544380GREE Inverter Air Conditioner (GS-24XFV32) 2.0 Ton.jpg","","","","0","0","","","","<p>Comfortable Sleeping Mode</p>
<p>Cold Air Prevention</p>
<p>Timer</p>
<p>Turbo Button</p>
<p>Clock Display</p>
<p>Self Diagnosis</p>
<p>Washable Air Purify Filters</p>
<p>LED Display</p>
<p>Lock</p>
<p>Auto Restart</p>
<p>Auto Clean</p>
<p>Healthy Filters</p>
<p>Cold Plasma</p>
<p>Energy Saving</p>
<p>Golden Fin</p>
<p>Intelligent Defrosting</p>
<p>Compact Design</p>
<p>Low voltage start-up</p>
<p>Automatic Operation</p>
<p>Easy Installation and Maintain</p>
<p>1W Standby</p>
<p>R32A</p>","0","2023-12-13 13:18:24","2024-01-10 12:32:20");
INSERT INTO products VALUES("202","GREE Inverter Air Conditioner (GS-12XLMV32) 1.0 Ton","99681812","standard","C128","14","100","1","1","1","48725","58500","0","","","","","","","1","1702547934983ac.jpeg","","","","0","0","","","","<p>Capacity: 12,000 Btu/Hr. (1.0 Ton)<br />Model: GS-12XLMV32 (Inverter System)<br />(INVERTER + COOL + No WIFI)<br />Origin &amp; Made In: China</p>","0","2023-12-13 13:18:24","2024-01-10 12:32:20");
INSERT INTO products VALUES("203","GREE Inverter Air Conditioner (GS-12XPUV32) 1.0 Ton","12913376","standard","C128","14","100","1","1","1","48700","58400","0","","","","","","","1","1702546920942GREE Air Conditioner (GS-12MU410) 1.0 Ton.jpg","","","","0","0","","","","<p>Efficient cold plasma to make breathing cleaner.</p>
<p>Fully closed air guide louver &amp; top-mounted filter.</p>
<p>Auto clean &amp; Comfortable airflow and wide air supply.</p>
<p>Quiet design &amp; Ai intelligent control Wi-Fi remote control</p>
<p>I Feel</p>
<p>Comfortable Sleeping Mode</p>
<p>Ideal Temperature</p>
<p>Timer</p>
<p>Turbo Button</p>
<p>Clock Display</p>
<p>Self Diagnosis</p>
<p>Washable Air Purify Filters</p>
<p>LED Display</p>
<p>Lock</p>
<p>Auto Restart</p>
<p>Auto Clean</p>
<p>Healthy Filters</p>
<p>Cold Plasma</p>
<p>Energy Saving</p>
<p>Golden Fin</p>
<p>Intelligent Defrosting</p>
<p>Compact Design</p>
<p>Low voltage start-up</p>
<p>Automatic Operation</p>
<p>Easy Installation and Maintain</p>
<p>Wide Air supply-13M</p>
<p>High Temperature-68&deg;</p>
<p>60s Fast Cooling</p>
<p>3D Air Flow</p>
<p>7 Fan Speeds</p>
<p>Four-way air Swing</p>
<p>R32A</p>","0","2023-12-13 13:18:24","2024-01-10 12:32:20");
INSERT INTO products VALUES("204","GREE Inverter Air Conditioner (GS-18XFV32) 1.5 Ton","35902261","standard","C128","14","100","1","1","1","66900","79890","0","","","","","","","1","1702547099130GREE Inverter Air Conditioner (GS-24XFV32) 2.0 Ton.jpg","","","","0","0","","","","<p><strong>Features</strong></p>
<p>I Feel</p>
<p>Comfortable Sleeping Mode</p>
<p>Cold Air Prevention</p>
<p>Timer</p>
<p>Turbo Button</p>
<p>Clock Display</p>
<p>Self Diagnosis</p>
<p>Washable Air Purify Filters</p>
<p>LED Display</p>
<p>Lock</p>
<p>Auto Restart</p>
<p>Auto Clean</p>
<p>Healthy Filters</p>
<p>Cold Plasma</p>
<p>Energy Saving</p>
<p>Golden Fin</p>
<p>Intelligent Defrosting</p>
<p>Compact Design</p>
<p>Low voltage start-up</p>
<p>Automatic Operation</p>
<p>Easy Installation and Maintain</p>
<p>1W Standby</p>
<p>R32A</p>","0","2023-12-13 13:18:24","2024-01-10 12:32:20");
INSERT INTO products VALUES("205","GREE Inverter Air Conditioner (GS-18XLMV32) 1.5 Ton","65090249","standard","C128","14","100","1","1","1","66900","79890","0","","","","","","","1","1702537559956GREE Inverter Air Conditioner (GS-18XPUV32) 1.5 Ton.jpg","","","","0","0","","","","<p>Capacity: 18,000 Btu/Hr. (1.5 Ton)<br />Model: GS-18XLMV32 (Inverter System)<br />(INVERTER + COOL + No WIFI)<br />Origin &amp; Made In: China</p>","0","2023-12-13 13:18:24","2024-01-10 12:32:20");
INSERT INTO products VALUES("206","GREE Inverter Air Conditioner (GS-18XPUV32) 1.5 Ton","19560334","standard","C128","14","100","1","1","1","65500","78390","0","","","","","","","1","1702537342216GREE Inverter Air Conditioner (GS-18XPUV32) 1.5 Ton.jpg","","","","0","0","","","","<p>Comfortable Sleeping Mode</p>
<p>Ideal Temperature</p>
<p>Timer</p>
<p>Turbo Button</p>
<p>Clock Display</p>
<p>Self Diagnosis</p>
<p>Washable Air Purify Filters</p>
<p>LED Display</p>
<p>Lock</p>
<p>Auto Restart</p>
<p>Auto Clean</p>
<p>Healthy Top Mounted Filters</p>
<p>Clean breathing</p>
<p>Golden Fin</p>
<p>Energy Saving</p>
<p>Easy Installation and Maintain</p>
<p>Wide Air supply-13M</p>
<p>Low voltage start-up</p>
<p>High Temperature-68&deg;</p>
<p>60s Fast Cooling</p>
<p>3D Air Flow</p>
<p>7 Fan Speeds</p>
<p>Four-way air Swing</p>
<p>R32A</p>","0","2023-12-13 13:18:24","2024-01-10 12:32:20");
INSERT INTO products VALUES("207","GREE Inverter Air Conditioner (GS-24XFV32) 2.0 Ton","33261088","standard","C128","14","100","1","1","1","78300","93290","0","","","","","","","1","1702537189523GREE Inverter Air Conditioner (GS-24XFV32) 2.0 Ton.jpg","","","","0","0","","","","<p>Model: GS-24XFV32</p>
<p>Capacity: 24,000 BTU/Hr</p>
<p>Only Cooling Technology</p>
<p>Compressor: Rotary Type</p>
<p>Coverage: 181-240 Sft</p>","0","2023-12-13 13:18:24","2024-01-10 12:32:20");
INSERT INTO products VALUES("208","GREE Inverter Air Conditioner (GS-24XLMV32) 2.0 Ton","1187147","standard","C128","14","100","1","1","1","78300","93290","0","","","","","","","1","1702547205970GREE Air Conditioner (GS-12FA410) 1.0 Ton.jpg","","","","0","0","","","","<p><strong>Features</strong></p>
<p>I Feel</p>
<p>Comfortable Sleeping Mode</p>
<p>Cold Air Prevention</p>
<p>Timer</p>
<p>Turbo Button</p>
<p>Clock Display</p>
<p>Self Diagnosis</p>
<p>Washable Air Purify Filters</p>
<p>LED Display</p>
<p>Lock</p>
<p>Auto Restart</p>
<p>Auto Clean</p>
<p>Healthy Filters</p>
<p>Cold Plasma</p>
<p>Energy Saving</p>
<p>Golden Fin</p>
<p>Intelligent Defrosting</p>
<p>Compact Design</p>
<p>Low voltage start-up</p>
<p>Automatic Operation</p>
<p>Easy Installation and Maintain</p>
<p>1W Standby</p>
<p>R32A</p>","0","2023-12-13 13:18:24","2024-01-10 12:32:20");
INSERT INTO products VALUES("209","GREE Inverter Air Conditioner (GS-24XPUV32) 2.0 Ton","77614906","standard","C128","14","100","1","1","1","78300","93280","0","","","","","","","1","1702547283997GREE Inverter Air Conditioner (GS-18XPUV32) 1.5 Ton.jpg","","","","0","0","","","","<p>Capacity: 24,000 Btu/Hr. (2.0 Ton)<br />Model: GS-24XPUV32 (Inverter System)<br />(INVERTER TECHNOLOGY + COOL ONLY + WIFI TECHNOLOGY)</p>","0","2023-12-13 13:18:24","2024-01-10 12:32:20");
INSERT INTO products VALUES("210","GREE Inverter Air Conditioner (GS-30XFV32) 2.5 Ton","9170636","standard","C128","14","100","1","1","1","115500","137000","0","","","","","","","1","1702547336936GREE Inverter Air Conditioner (GS-18XPUV32) 1.5 Ton.jpg","","","","0","0","","","","<p>Capacity: 24,000 Btu/Hr. (2.5 Ton)<br />Model: GS-24XPUV32 (Inverter System)<br />(INVERTER TECHNOLOGY + COOL ONLY + WIFI TECHNOLOGY)</p>","0","2023-12-13 13:18:24","2024-01-10 12:32:20");
INSERT INTO products VALUES("211","GREE Inverter Air Conditioner (GS-30XPUV32) 2.5 Ton","94170027","standard","C128","14","100","1","1","1","114600","136000","0","","","","","","","1","1702547393248GREE Inverter Air Conditioner (GS-24XFV32) 2.0 Ton.jpg","","","","0","0","","","","<p>Capacity: 24,000 Btu/Hr. (2.5 Ton)<br />Model: GS-24XPUV32 (Inverter System)<br />(INVERTER TECHNOLOGY + COOL ONLY + WIFI TECHNOLOGY)</p>","0","2023-12-13 13:18:24","2024-01-10 12:32:20");
INSERT INTO products VALUES("212","Haier Air Conditioner (HSU-12CleanCool) 1.0 Ton","8361479","standard","C128","15","100","1","1","1","33500","45990","0","","","","","","","1","1702547575158Haier Air Conditioner (HSU-12CleanCool) 1.0 Ton.png","","","","0","0","","","","<p>Capacity: 12,000 Btu/Hr. [1.0 Ton]<br />Model: HSU-12CleanCool (Inverter System)</p>","0","2023-12-13 13:18:24","2024-01-10 12:32:20");
INSERT INTO products VALUES("213","Haier Air Conditioner (HSU-18TurboCool:(PA) 1.5 Ton","30905384","standard","C128","15","100","1","1","1","44000","59990","0","","","","","","","1","1702547746800haier2.jpg","","","","0","0","","","","<p>Brand: Haier<br />Model: HSU-18<br />Color: White<br />Capacity (Tons): 1.5 Ton<br />Capacity (BTU): 18000<br />Refrigerant Type: R32<br />Power Supply (V-Hz): 220/50HZ</p>","0","2023-12-13 13:18:24","2024-01-10 12:32:20");
INSERT INTO products VALUES("214","Haier Air Conditioner 2.0 Ton","50141850","standard","C128","15","100","1","1","1","58500","74990","0","","","","","","","1","1702549981180haier2.jpg","","","","0","0","","","","<p>(HSU-24TurboCool:(PA)</p>
<p>1&nbsp;Min&nbsp;Instant&nbsp;Chill</p>
<p>54&deg;C&nbsp;cooling</p>
<p>Quality&nbsp;Filter</p>","0","2023-12-13 13:18:24","2024-01-10 12:32:20");
INSERT INTO products VALUES("215","Haier Inverter Air Conditioner1.0 Ton","36912473","standard","C128","15","100","1","1","1","43000","53990","0","","","","","","","1","1702550219234haier3.jpg","","","","0","0","","","","<p>(HSU-12CleanCool(IVN)</p>
<p>Capacity: 12,000 Btu/Hr. [1.0 Ton]<br />Model: HSU-12CleanCool (Inverter System)</p>
<p>Origin: China.<br />Made In: China.</p>","0","2023-12-13 13:18:24","2024-01-10 12:32:20");
INSERT INTO products VALUES("216","Haier Inverter Air Conditioner (HSU-18CleanCool(IVN)	1.5 Ton","24721791","standard","C128","15","100","1","1","1","56000","69990","0","","","","","","","1","zummXD2dvAtI.png","","","","0","0","","","","","0","2023-12-13 13:18:24","2024-01-10 12:32:20");
INSERT INTO products VALUES("217","Haier Inverter Air Conditioner 2.0 Ton","362139","standard","C128","15","100","1","1","1","70000","88490","0","","","","","","","1","1702550254079haier3.jpg","","","","0","0","","","","<p>(HSU-24CleanCool(IVN)</p>
<p>Capacity: 12,000 Btu/Hr. [1.0 Ton]<br />Model: HSU-12CleanCool (Inverter System)</p>
<p>Origin: China.<br />Made In: China.</p>","0","2023-12-13 13:18:24","2024-01-10 12:32:20");
INSERT INTO products VALUES("218","JICSON LED TV	(JB00WZ) 32 Inches","9766714","standard","C128","16","76","1","1","1","7000","12250","0","","","","","","","1","1702550375578smarttv.jpg","","","","0","0","","","","<p>(JB00WZ) 32 Inches</p>","0","2023-12-13 13:18:24","2024-01-10 13:04:58");
INSERT INTO products VALUES("219","JICSON Smart TV	(JS00WZ) 32 Inches","99016508","standard","C128","16","98","1","1","1","10800","18900","0","","","","","","","1","1702883969092android tv.jpg","","","","0","0","","","","","0","2023-12-13 13:18:24","2024-01-10 12:30:50");
INSERT INTO products VALUES("220","JICSON Smart TV	(JS00WZ) 40 Inches","48509697","standard","C128","16","98","1","1","1","16300","28525","0","","","","","","","1","1702550548577smarttv2.jpg","","","","0","0","","","","<div class=@relative flex flex-col min-w-0 break-words bg-white w-full@>
<div class=@flex-auto@>
<div class=@tab-content tab-space@>
<div id=@link1@ class=@block@>
<p>Aspect Ratio&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; : 16:9</p>
<p>AC Supply Voltage : 100-240V, 50/60Hz<br />Resolution&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; :&nbsp;Full HD -1920*1080 &nbsp;</p>
<p>System&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; : PAL/SECAM BG,DK, 1 NTSC Playback</p>
<p>Receiving TV Band : All Channels Receivable</p>
<p>Input Terminal&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; : USB Input, HDMI Input, VGA Input,</p>
<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; PC Audio Input, Video Input.</p>
<p>Output Terminal&nbsp;&nbsp; : Earphone.</p>
<p>Power Supply&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; : DC 3V (Two batteries, size-AAA,</p>
<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; recommend use alkaline type</p>
<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; batteries)</p>
<p>Full Function Remote Control and 8 metres effective distance power</p>
</div>
</div>
</div>
</div>","0","2023-12-13 13:18:24","2024-01-10 12:30:50");
INSERT INTO products VALUES("221","JICSON Smart TV	(JS4KWZ) 32 Inches","81346601","standard","C128","16","98","1","1","1","15500","27250","0","","","","","","","1","1702883959947android tv.jpg","","","","0","0","","","","<div class=@relative flex flex-col min-w-0 break-words bg-white w-full@>
<div class=@flex-auto@>
<div class=@tab-content tab-space@>
<div id=@link1@ class=@block@>
<p>Screen Size&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; : 32&Prime; Diagonal</p>
<p>Aspect Ratio&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; : 16:9</p>
<p>AC Supply Voltage : 100-240V, 50/60Hz<br />Resolution&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; :&nbsp;Full HD -1920*1080 &nbsp;</p>
<p>System&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; : PAL/SECAM BG,DK, 1 NTSC Playback</p>
<p>Receiving TV Band : All Channels Receivable</p>
<p>Input Terminal&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; : USB Input, HDMI Input, VGA Input,</p>
<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; PC Audio Input, Video Input.</p>
<p>Output Terminal&nbsp;&nbsp; : Earphone.</p>
<p>Power Supply&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; : DC 3V (Two batteries, size-AAA,</p>
<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; recommend use alkaline type</p>
<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; batteries)</p>
<p>Full Function Remote Control and 8 metres effective distance power</p>
</div>
</div>
</div>
</div>","0","2023-12-13 13:18:24","2024-01-10 12:30:50");
INSERT INTO products VALUES("222","JICSON Smart TV	(JS4KWZ) 40 Inches","18347932","standard","C128","16","98","1","1","1","18000","31500","0","","","","","","","1","1702550782766smarttv.jpg","","","","0","0","","","","<div class=@relative flex flex-col min-w-0 break-words bg-white w-full@>
<div class=@flex-auto@>
<div class=@tab-content tab-space@>
<div id=@link1@ class=@block@>
<p>Screen Size&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; : 40&Prime; Diagonal</p>
<p>Aspect Ratio&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; : 16:9</p>
<p>AC Supply Voltage : 100-240V, 50/60Hz<br />Resolution&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; :&nbsp;Full HD -1920*1080 &nbsp;</p>
<p>System&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; : PAL/SECAM BG,DK, 1 NTSC Playback</p>
<p>Receiving TV Band : All Channels Receivable</p>
<p>Input Terminal&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; : USB Input, HDMI Input, VGA Input,</p>
<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; PC Audio Input, Video Input.</p>
<p>Output Terminal&nbsp;&nbsp; : Earphone.</p>
<p>Power Supply&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; : DC 3V (Two batteries, size-AAA,</p>
<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; recommend use alkaline type</p>
<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; batteries)</p>
<p>Full Function Remote Control and 8 metres effective distance power</p>
</div>
</div>
</div>
</div>","0","2023-12-13 13:18:24","2024-01-10 12:30:50");
INSERT INTO products VALUES("223","JICSON Smart TV	(JSBLWZ) 32 Inches","97912543","standard","C128","16","98","1","1","1","14000","24500","0","","","","","","","1","1702550865354smarttv.jpg","","","","0","0","","","","<div class=@relative flex flex-col min-w-0 break-words bg-white w-full@>
<div class=@flex-auto@>
<div class=@tab-content tab-space@>
<div id=@link1@ class=@block@>
<p>Screen Size&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; : 32&Prime; Diagonal</p>
<p>Aspect Ratio&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; : 16:9</p>
<p>AC Supply Voltage : 100-240V, 50/60Hz<br />Resolution&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; :&nbsp;Full HD -1920*1080 &nbsp;</p>
<p>System&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; : PAL/SECAM BG,DK, 1 NTSC Playback</p>
<p>Receiving TV Band : All Channels Receivable</p>
<p>Input Terminal&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; : USB Input, HDMI Input, VGA Input,</p>
<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; PC Audio Input, Video Input.</p>
<p>Output Terminal&nbsp;&nbsp; : Earphone.</p>
<p>Power Supply&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; : DC 3V (Two batteries, size-AAA,</p>
<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; recommend use alkaline type</p>
<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; batteries)</p>
<p>Full Function Remote Control and 8 metres effective distance power</p>
</div>
</div>
</div>
</div>","0","2023-12-13 13:18:24","2024-01-10 12:30:50");
INSERT INTO products VALUES("224","JICSON Smart TV	(JSDGWZ) 32 Inches","29238607","standard","C128","16","98","1","1","1","12000","21000","0","","","","","","","1","1702550908413smarttv2.jpg","","","","0","0","","","","<div class=@relative flex flex-col min-w-0 break-words bg-white w-full@>
<div class=@flex-auto@>
<div class=@tab-content tab-space@>
<div id=@link1@ class=@block@>
<p>Screen Size&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; : 32&Prime; Diagonal</p>
<p>Aspect Ratio&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; : 16:9</p>
<p>AC Supply Voltage : 100-240V, 50/60Hz<br />Resolution&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; :&nbsp;Full HD -1920*1080 &nbsp;</p>
<p>System&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; : PAL/SECAM BG,DK, 1 NTSC Playback</p>
<p>Receiving TV Band : All Channels Receivable</p>
<p>Input Terminal&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; : USB Input, HDMI Input, VGA Input,</p>
<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; PC Audio Input, Video Input.</p>
<p>Output Terminal&nbsp;&nbsp; : Earphone.</p>
<p>Power Supply&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; : DC 3V (Two batteries, size-AAA,</p>
<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; recommend use alkaline type</p>
<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; batteries)</p>
<p>Full Function Remote Control and 8 metres effective distance power</p>
</div>
</div>
</div>
</div>","0","2023-12-13 13:18:24","2024-01-10 12:30:50");
INSERT INTO products VALUES("225","JICSON Smart TV	(JSDGWZ) 40 Inches","91730285","standard","C128","16","98","1","1","1","17000","29750","0","","","","","","","1","1702884022041android tv.jpg","","","","0","0","","","","<div class=@relative flex flex-col min-w-0 break-words bg-white w-full@>
<div class=@flex-auto@>
<div class=@tab-content tab-space@>
<div id=@link1@ class=@block@>
<p>Screen Size&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; : 40&Prime; Diagonal</p>
<p>Aspect Ratio&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; : 16:9</p>
<p>AC Supply Voltage : 100-240V, 50/60Hz<br />Resolution&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; :&nbsp;Full HD -1920*1080 &nbsp;</p>
<p>System&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; : PAL/SECAM BG,DK, 1 NTSC Playback</p>
<p>Receiving TV Band : All Channels Receivable</p>
<p>Input Terminal&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; : USB Input, HDMI Input, VGA Input,</p>
<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; PC Audio Input, Video Input.</p>
<p>Output Terminal&nbsp;&nbsp; : Earphone.</p>
<p>Power Supply&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; : DC 3V (Two batteries, size-AAA,</p>
<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; recommend use alkaline type</p>
<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; batteries)</p>
<p>Full Function Remote Control and 8 metres effective distance power</p>
</div>
</div>
</div>
</div>","0","2023-12-13 13:18:24","2024-01-10 12:30:50");
INSERT INTO products VALUES("226","JICSON Smart TV (JS4KWZ)","3529110","standard","C128","16","98","1","1","1","18000","31500","0","","","","","","","1","1702884030534android tv.jpg","","","","0","0","","","","<p>Official Android 10.0 with Google Authorization<br />Google assistant as AI<br />Bezel-less ultra slim design<br />Voice controlled TV with Google Assistant<br />Bidirectional Bluetooth 5.0<br />ADS Panel technology</p>","0","2023-12-13 13:18:24","2024-01-10 12:30:50");
INSERT INTO products VALUES("227","Kiam Die Casting Deep Fry Pan with Glass Lid (24 CM)","65174223","standard","C128","17","79","1","1","1","1200","1550","0","","","","","","","1","1702551101206Kiam Die Casting Deep Fry Pan with Glass Lid (24 CM).jpg","","","","0","0","","","","<ul>
<li>Size: 24 cm</li>
<li>Material: Aluminum</li>
<li>Type: Non Stick</li>
<li>Induction Friendly</li>
<li>Brand: Kiam</li>
<li>PFOA Free</li>
<li>Hand wash Only</li>
</ul>","0","2023-12-13 13:18:24","2024-01-10 13:06:09");
INSERT INTO products VALUES("228","Kiam Die Casting Deep Fry Pan with Glass Lid (28CM)","20165621","standard","C128","17","79","1","1","1","1400","1850","0","","","","","","","1","1702551215009Kiam Die Casting Deep Fry Pan with Glass Lid (24 CM).jpg","","","","0","0","","","","<ul>
<li>Size: 28 cm</li>
<li>Material: Aluminum</li>
<li>Type: Non Stick</li>
<li>Induction Friendly</li>
<li>Brand: Kiam</li>
<li>PFOA Free</li>
<li>Hand wash Only</li>
</ul>","0","2023-12-13 13:18:24","2024-01-10 13:06:09");
INSERT INTO products VALUES("229","Kiam Die Casting Fry Pan with Glass Lid (24CM)","91479720","standard","C128","17","79","1","1","1","1090","1450","0","","","","","","","1","1702551413791Kiam Die Casting Fry Pan with Glass Lid (24CM).jpg","","","","0","0","","","","<ul>
<li>Size: 24 cm</li>
<li>Material: Aluminum</li>
<li>Type: Non Stick</li>
<li>Induction Friendly</li>
<li>Brand: Kiam</li>
<li>PFOA Free</li>
<li>Hand wash Only</li>
</ul>","0","2023-12-13 13:18:24","2024-01-10 13:06:09");
INSERT INTO products VALUES("230","Kiam Die Casting Fry Pan with Glass Lid (26CM)","65758420","standard","C128","17","79","1","1","1","1195","1580","0","","","","","","","1","1702551485176Kiam Die Casting Fry Pan with Glass Lid (24CM).jpg","","","","0","0","","","","<ul>
<li>Size: 26 cm</li>
<li>Material: Aluminum</li>
<li>Type: Non Stick</li>
<li>Induction Friendly</li>
<li>Brand: Kiam</li>
<li>PFOA Free</li>
<li>Hand wash Only</li>
<li>Size: 24 cm</li>
<li>Material: Aluminum</li>
<li>Type: Non Stick</li>
<li>Induction Friendly</li>
<li>Brand: Kiam</li>
<li>PFOA Free</li>
<li>Hand wash Only</li>
<li>Size: 24 cm</li>
<li>Material: Aluminum</li>
<li>Type: Non Stick</li>
<li>Induction Friendly</li>
<li>Brand: Kiam</li>
<li>PFOA Free</li>
<li>Hand wash Only</li>
<li>Size: 24 cm</li>
<li>Material: Aluminum</li>
<li>Type: Non Stick</li>
<li>Induction Friendly</li>
<li>Brand: Kiam</li>
<li>PFOA Free</li>
<li>Hand wash Only</li>
<li>Size: 24 cm</li>
<li>Material: Aluminum</li>
<li>Type: Non Stick</li>
<li>Induction Friendly</li>
<li>Brand: Kiam</li>
<li>PFOA Free</li>
<li>Hand wash Only</li>
<li>Size: 24 cm</li>
<li>Material: Aluminum</li>
<li>Type: Non Stick</li>
<li>Induction Friendly</li>
<li>Brand: Kiam</li>
<li>PFOA Free</li>
<li>Hand wash Only</li>
<li>Size: 24 cm</li>
<li>Material: Aluminum</li>
<li>Type: Non Stick</li>
<li>Induction Friendly</li>
<li>Brand: Kiam</li>
<li>PFOA Free</li>
<li>Hand wash Only</li>
<li>Size: 24 cm</li>
<li>Material: Aluminum</li>
<li>Type: Non Stick</li>
<li>Induction Friendly</li>
<li>Brand: Kiam</li>
<li>PFOA Free</li>
<li>Hand wash Only</li>
<li>Size: 24 cm</li>
<li>Material: Aluminum</li>
<li>Type: Non Stick</li>
<li>Induction Friendly</li>
<li>Brand: Kiam</li>
<li>PFOA Free</li>
<li>Hand wash Only</li>
<li>Size: 24 cm</li>
<li>Material: Aluminum</li>
<li>Type: Non Stick</li>
<li>Induction Friendly</li>
<li>Brand: Kiam</li>
<li>PFOA Free</li>
<li>Hand wash Only</li>
<li>Size: 24 cm</li>
<li>Material: Aluminum</li>
<li>Type: Non Stick</li>
<li>Induction Friendly</li>
<li>Brand: Kiam</li>
<li>PFOA Free</li>
<li>Hand wash Only</li>
</ul>","0","2023-12-13 13:18:24","2024-01-10 13:06:09");
INSERT INTO products VALUES("231","Kiam Die Casting Fry Pan with Glass Lid (28CM)","23814901","standard","C128","17","79","1","1","1","1310","1700","0","","","","","","","1","1702551520881Kiam Die Casting Fry Pan with Glass Lid (24CM).jpg","","","","0","0","","","","<ul>
<li>Size: 28 cm</li>
<li>Material: Aluminum</li>
<li>Type: Non Stick</li>
<li>Induction Friendly</li>
<li>Brand: Kiam</li>
<li>PFOA Free</li>
<li>Hand wash Only</li>
</ul>","0","2023-12-13 13:18:24","2024-01-10 13:06:09");
INSERT INTO products VALUES("232","Kiam Die Casting Grill Pan (26 CM)","2107245","standard","C128","17","79","1","1","1","1200","1550","0","","","","","","","1","1702551554117Kiam Die Casting Fry Pan with Glass Lid (24CM).jpg","","","","0","0","","","","<ul>
<li>Size: 26 cm</li>
<li>Material: Aluminum</li>
<li>Type: Non Stick</li>
<li>Induction Friendly</li>
<li>Brand: Kiam</li>
<li>PFOA Free</li>
<li>Hand wash Only</li>
</ul>","0","2023-12-13 13:18:24","2024-01-10 13:06:09");
INSERT INTO products VALUES("233","Kiam Die Casting Karai with Glass Lid (26CM)","39638657","standard","C128","17","79","1","1","1","1335","1750","0","","","","","","","1","1702551604061Kiam Die Casting Fry Pan with Glass Lid (24CM).jpg","","","","0","0","","","","<p>Size: 26 cm</p>
<p>Material: Aluminum</p>
<p>Type: Non Stick</p>
<p>Induction Friendly</p>
<p>Brand: Kiam</p>
<p>PFOA Free</p>
<p>Hand wash Only</p>","0","2023-12-13 13:18:24","2024-01-10 13:06:09");
INSERT INTO products VALUES("234","Kiam Die Casting Karai with Glass Lid (28CM)","19058237","standard","C128","17","79","1","1","1","1460","1890","0","","","","","","","1","1702551648909Kiam Die Casting Fry Pan with Glass Lid (24CM).jpg","","","","0","0","","","","<p>Size: 28 cm</p>
<p>Material: Aluminum</p>
<p>Type: Non Stick</p>
<p>Induction Friendly</p>
<p>Brand: Kiam</p>
<p>PFOA Free</p>
<p>Hand wash Only</p>","0","2023-12-13 13:18:24","2024-01-10 13:06:09");
INSERT INTO products VALUES("235","Kiam Dosa Tawa (26CM)","13690799","standard","C128","17","79","1","1","1","855","1120","0","","","","","","","1","1702551798728Kiam Dosa Tawa (26CM).jpg","","","","0","0","","","","<p><strong>Product Name: Kiam Non-Stick Dosa Tawa-26cm</strong></p>
<p><strong>Product Type: Non-Stick DosaTawa</strong></p>
<p><strong>Size: 26cm</strong></p>
<p><strong>Cookware Material: Non-stick Aluminium</strong></p>
<p>This Non-sticky coating Tawa Can Save 60% of your oil, ghee, or butter</p>
<p>Attractive design and shape</p>
<p>Strong fire resist handle and Body</p>
<p>Dishwasher Safe</p>
<p>Easy to use</p>","0","2023-12-13 13:18:24","2024-01-10 13:06:09");
INSERT INTO products VALUES("236","Kiam Fry Pan with Glass Lid (Omega) 24 CM","38877491","standard","C128","17","79","1","1","1","990","1290","0","","","","","","","1","1702552044948Kiam Fry Pan with Glass Lid (Omega) 24 CM.jpg","","","","0","0","","","","<p>Material:&nbsp;German manufacturer in Bangladesh</p>
<p>Diameter:&nbsp;9.5 in (24 cm)&nbsp;&nbsp;</p>
<p>Length:&nbsp;17 in</p>
<p>Weight:&nbsp;1.517 kg</p>
<p>Quality:&nbsp;High-quality</p>
<p>Manufecturar:&nbsp;Kiam Metal Industries Lid.&nbsp;</p>","0","2023-12-13 13:18:24","2024-01-10 13:06:09");
INSERT INTO products VALUES("237","Kiam Fry Pan with Glass Lid (Omega) 26 CM","29130827","standard","C128","17","79","1","1","1","1095","1420","0","","","","","","","1","1702884829092Kiam Die Casting Fry Pan with Glass Lid (24CM).jpg","","","","0","0","","","","<p>Material:&nbsp;German manufacturer in Bangladesh</p>
<p>Diameter:&nbsp;(26 cm)&nbsp;&nbsp;</p>
<p>Length:&nbsp;17 in</p>
<p>Weight:&nbsp;1.517 kg</p>
<p>Quality:&nbsp;High-quality</p>
<p>Manufecturar:&nbsp;Kiam Metal Industries Lid.&nbsp;</p>","0","2023-12-13 13:18:24","2024-01-10 13:06:09");
INSERT INTO products VALUES("238","Kiam Fry Pan with Glass Lid (Omega) 28 CM","32499020","standard","C128","17","79","1","1","1","1210","1580","0","","","","","","","1","1702552209056Kiam Fry Pan with Glass Lid (Omega) 24 CM.jpg","","","","0","0","","","","<p>Material:&nbsp;German manufacturer in Bangladesh</p>
<p>Diameter: (28 cm)&nbsp;&nbsp;</p>
<p>Length:&nbsp;17 in</p>
<p>Weight:&nbsp;1.517 kg</p>
<p>Quality:&nbsp;High-quality</p>
<p>Manufecturar:&nbsp;Kiam Metal Industries Lid.&nbsp;</p>","0","2023-12-13 13:18:24","2024-01-10 13:06:09");
INSERT INTO products VALUES("239","Kiam Fry Pan with Glass Lid (Omega) 28CM","89079162","standard","C128","17","79","1","1","1","1210","1580","0","","","","","","","1","1702552281757Kiam Fry Pan with Glass Lid (Omega) 24 CM.jpg","","","","0","0","","","","<p>Material:&nbsp;German manufacturer in Bangladesh</p>
<p>Diameter: (28 cm)&nbsp;&nbsp;</p>
<p>Length:&nbsp;17 in</p>
<p>Weight:&nbsp;1.517 kg</p>
<p>Quality:&nbsp;High-quality</p>
<p>Manufecturar:&nbsp;Kiam Metal Industries Lid.&nbsp;</p>","0","2023-12-13 13:18:24","2024-01-10 13:06:09");
INSERT INTO products VALUES("240","Kiam Pressure Cooker (1.5 Litres)","52693237","standard","C128","17","80","1","1","1","1075","1290","0","","","","","","","1","1702552369246Kiam Pressure Cooker (1.5 Litres).jpg","","","","0","0","","","","<p>Kiam Classic Pressure Cooker - 1.5L.<br />Product Type: Pressure Cooker.<br />Material: Aluminum Steel.<br />Size: 1.5 Liter.<br />Safety security valve.<br />Heat proof bakelite handle.<br />Easy to Clean and Eco Friendly.<br />Good Quality and Light Weight product.<br />Standard and Smart Design.</p>","0","2023-12-13 13:18:24","2024-01-10 13:06:09");
INSERT INTO products VALUES("241","Kiam Pressure Cooker (5.5 Litres)","13131580","standard","C128","17","80","1","1","1","1525","1850","0","","","","","","","1","1702552443916Kiam Pressure Cooker (1.5 Litres).jpg","","","","0","0","","","","<p>Kiam Classic Pressure Cooker - 5.5L.<br />Product Type: Pressure Cooker.<br />Material: Aluminum Steel.<br />Size: 5.5 Liter.<br />Safety security valve.<br />Heat proof bakelite handle.<br />Easy to Clean and Eco Friendly.<br />Good Quality and Light Weight product.<br />Standard and Smart Design.</p>","0","2023-12-13 13:18:24","2024-01-10 13:06:09");
INSERT INTO products VALUES("242","Kiam Pressure Cooker (6.5 Litres)","93698457","standard","C128","17","80","1","1","1","1625","1950","0","","","","","","","1","1702552489502Kiam Pressure Cooker (1.5 Litres).jpg","","","","0","0","","","","<p>Kiam Classic Pressure Cooker - 6.5L.<br />Product Type: Pressure Cooker.<br />Material: Aluminum Steel.<br />Size: 6.5 Liter.<br />Safety security valve.<br />Heat proof bakelite handle.<br />Easy to Clean and Eco Friendly.<br />Good Quality and Light Weight product.<br />Standard and Smart Design.</p>","0","2023-12-13 13:18:24","2024-01-10 13:06:09");
INSERT INTO products VALUES("243","Kiam Ruti Tawa (26CM)","80590916","standard","C128","17","79","1","1","1","780","1020","0","","","","","","","1","1702552605412Kiam Ruti Tawa (26CM).jpg","","","","0","0","","","","<p>Product Type: Non-Stick Roti Tawa</p>
<p>Size: 26cm</p>
<p>Cookware Material: Aluminium with Non-stick coating</p>
<p>Non-sticky coating Can Save 60% of your oil, ghee, or butter</p>
<p>Attractive design and shape</p>
<p>Strong fire resist handle and Body</p>
<p>Dishwasher Safe</p>
<p>Easy to use</p>","0","2023-12-13 13:18:24","2024-01-10 13:06:09");
INSERT INTO products VALUES("244","LG Mosquito Swatter (ME-986C)","61809046","standard","C128","18","78","1","1","1","350","525","0","","","","","","","1","1702552800608Weidasi Mosquito Swatter.jpg","","","","0","0","","","","<p>&nbsp;6 Months Warranty</p>
<p>Quick Mosquito Killer</p>
<p>&nbsp;Rechargeable</p>
<p>&nbsp;LED Light</p>
<p>&nbsp;Extra power Cord</p>
<p>*On/Off Switch</p>","0","2023-12-13 13:18:24","2024-01-10 13:05:19");
INSERT INTO products VALUES("245","Midea Air Conditioner (MSA- 12 CRN)","24628011","standard","C128","19","100","1","1","1","31500","42500","0","","","","","","","1","1702552896240Midea Air Conditioner (MSA- 12 CRN).jpg","","","","0","0","","","","<ul>
<li>Model: MSA-12CRN</li>
<li>2 Swing in Front Line</li>
<li>120-150 Sft Room Coverage</li>
<li>Noise Less</li>
</ul>","0","2023-12-13 13:18:24","2024-01-10 12:32:20");
INSERT INTO products VALUES("246","Midea Air Conditioner (MSA- 18 CRN)","69897911","standard","C128","19","100","1","1","1","41500","56000","0","","","","","","","1","1702552948622Midea Air Conditioner (MSA- 12 CRN).jpg","","","","0","0","","","","<ul>
<li>Model: MSA-18CRN</li>
<li>2 Swing in Front Line</li>
<li>120-150 Sft Room Coverage</li>
<li>Noise Less</li>
</ul>","0","2023-12-13 13:18:24","2024-01-10 12:32:20");
INSERT INTO products VALUES("247","Midea Air Conditioner (MSA- 24 CRN)","24138209","standard","C128","19","100","1","1","1","51500","69500","0","","","","","","","1","1702554450203Midea Air Conditioner (MSA- 12 CRN).jpg","","","","0","0","","","","<ul>
<li>Model: MSA-12CRN</li>
<li>2 Swing in Front Line</li>
<li>120-150 Sft Room Coverage</li>
<li>Noise Less</li>
</ul>","0","2023-12-13 13:18:24","2024-01-10 12:32:20");
INSERT INTO products VALUES("248","Midea Air Conditioner (MSA- 30 CRN) 2.5 Ton","5097230","standard","C128","19","100","1","1","1","70000","94500","0","","","","","","","1","1702554479578Midea Air Conditioner (MSA- 12 CRN).jpg","","","","0","0","","","","<p>2 Swing in Front Line</p>
<p>120-150 Sft Room Coverage</p>
<p>Noise Less</p>","0","2023-12-13 13:18:25","2024-01-10 12:32:20");
INSERT INTO products VALUES("249","Midea Inverter Air Conditioner 1.0 Ton","28642123","standard","C128","19","100","1","1","1","38000","52500","0","","","","","","","1","1702554764377Midea Inverter Air Conditioner 1.0 Ton.jpg","","","","0","0","","","","<p>MSE- 12 CRN</p>
<p>Power Supply V~, Hz, Ph: 220-240, 50, 1</p>
<p>Inverter Type: Inverter</p>
<p>Cooling Capacity Rated Btu/h: 18000</p>
<p>Cooling Capacity Rated kW: 7.5KW</p>
<p>60% Plus Energy Savings,</p>
<p>SEER W/W: 6.2</p>
<p>SCOP Avg./Warm/Cold W/W: 4.0/5.1/&ndash;</p>","0","2023-12-13 13:18:25","2024-01-10 12:32:20");
INSERT INTO products VALUES("250","Midea Inverter Air Conditioner 1.5 Ton","47194605","standard","C128","19","100","1","1","1","52000","69500","0","","","","","","","1","1702555008917Midea Inverter Air Conditioner 1.0 Ton.jpg","","","","0","0","","","","<p>(MSE- 18 CRN)</p>
<p>Power Supply V~, Hz, Ph: 220-240, 50, 1</p>
<p>Inverter Type: Inverter</p>
<p>Cooling Capacity Rated Btu/h: 18000</p>
<p>Cooling Capacity Rated kW: 7.5KW</p>
<p>60% Plus Energy Savings,</p>
<p>SEER W/W: 6.2</p>
<p>SCOP Avg./Warm/Cold W/W: 4.0/5.1/&ndash;</p>","0","2023-12-13 13:18:25","2024-01-10 12:32:20");
INSERT INTO products VALUES("251","Midea Inverter Air Conditioner 2.0 Ton","93239125","standard","C128","19","100","1","1","1","62000","83000","0","","","","","","","1","1702554938837Midea Inverter Air Conditioner 1.0 Ton.jpg","","","","0","0","","","","<p>(MSE- 24 CRN)</p>
<p>Power Supply V~, Hz, Ph: 220-240, 50, 1</p>
<p>Inverter Type: Inverter</p>
<p>Cooling Capacity Rated Btu/h: 18000</p>
<p>Cooling Capacity Rated kW: 7.5KW</p>
<p>60% Plus Energy Savings,</p>
<p>SEER W/W: 6.2</p>
<p>SCOP Avg./Warm/Cold W/W: 4.0/5.1/&ndash;</p>","0","2023-12-13 13:18:25","2024-01-10 12:32:20");
INSERT INTO products VALUES("252","Miyako Air Fryer (AF- 618)","30157418","standard","C128","10","59","1","1","1","5800","8700","0","","","","","","","1","1702555127093miyako air.jpg","","","","0","0","","","","<ul>
<li>Fries using 80% less oil</li>
<li>Integrated timer with auto shut-off</li>
<li>1400 watt</li>
<li>3.5 Liter basket/ 4.5 Liter pot capacity</li>
</ul>","0","2023-12-13 13:18:25","2024-01-10 12:32:20");
INSERT INTO products VALUES("253","Miyako Air Fryer (AF- 620)","80039721","standard","C128","10","59","1","1","1","4300","6450","0","","","","","","","1","1702555160880miyako air.jpg","","","","0","0","","","","<p>Fries using 80% less oil</p>
<p>Integrated timer with auto shut-off</p>
<p>1400 watt</p>
<p>3.5 Liter basket/ 4.5 Liter pot capacity</p>","0","2023-12-13 13:18:25","2024-01-10 12:32:20");
INSERT INTO products VALUES("254","Miyako Blender (408 B)","91188436","standard","C128","10","60","1","1","1","2000","3250","0","","","","","","","1","1702555336949Miyako Blender.jpg","","","","0","0","","","","<p>4 in 1 Electric Blender</p>
<p>Blending Jar, Dry Mill, Wet Mill, Juice Filter Included</p>
<p>400 Watt Motor.</p>","0","2023-12-13 13:18:25","2024-01-10 12:32:21");
INSERT INTO products VALUES("255","Miyako Blender (Blue Bird)","16892569","standard","C128","10","60","1","1","1","3500","5450","0","","","","","","","1","1702555472083Miyako Blender (Blue Bird).jpg","","","","0","0","","","","<p>Model: BLUE BIRD</p>
<p>Extra Strong &amp; Sharp Stainless Steel Blades</p>
<p>Liquid jar dome with clips for hands free operations</p>
<p>Over load protection</p>
<p>3 Speed with incher</p>
<p>Special grades nylon cuplers for firm grip</p>
<p>Special coating on body for for great aesthetics</p>
<p>Robust Design &amp; Powerful Performance</p>
<p>Powerful 750 Watt/1 HP</p>","0","2023-12-13 13:18:25","2024-01-10 12:32:21");
INSERT INTO products VALUES("256","Miyako Blender (Green Hornet)","13699112","standard","C128","10","60","1","1","1","3700","5550","0","","","","","","","1","1702555598790Miyako Blender (Green Hornet).jpg","","","","0","0","","","","<p>850 Watt Powerful Motor</p>
<p>Overload Protection&nbsp;</p>
<p>Three Speeds with Pulse Function</p>
<p>Extra Strong and Sharp Stainless Steel Blade</p>
<p>Liquid Jardome with Clips for Hands Free Operation</p>","0","2023-12-13 13:18:25","2024-01-10 12:32:21");
INSERT INTO products VALUES("257","Miyako Blender (Grey Hound)","21157880","standard","C128","10","60","1","1","1","3800","5700","0","","","","","","","1","1702555667470green.jpg","","","","0","0","","","","<p>850 Watt Powerful Motor</p>
<p>Overload Protection&nbsp;</p>
<p>Three Speeds with Pulse Function</p>
<p>Extra Strong and Sharp Stainless Steel Blade</p>
<p>Liquid Jardome with Clips for Hands Free Operation</p>","0","2023-12-13 13:18:25","2024-01-10 12:32:21");
INSERT INTO products VALUES("258","Miyako Blender (Red Bull)","61903748","standard","C128","10","60","1","1","1","3700","5550","0","","","","","","","1","1702555727455Miyako Blender (Red Horse).png","","","","0","0","","","","<p>850 Watt Powerful Motor</p>
<p>Overload Protection&nbsp;</p>
<p>Three Speeds with Pulse Function</p>
<p>Extra Strong and Sharp Stainless Steel Blade</p>
<p>Liquid Jardome with Clips for Hands Free Operation</p>","0","2023-12-13 13:18:25","2024-01-10 12:32:21");
INSERT INTO products VALUES("259","Miyako Blender (Red Horse)","92623071","standard","C128","10","60","1","1","1","4200","6300","0","","","","","","","1","1702555753642Miyako Blender (Red Horse).png","","","","0","0","","","","<p>850 Watt Powerful Motor</p>
<p>Overload Protection&nbsp;</p>
<p>Three Speeds with Pulse Function</p>
<p>Extra Strong and Sharp Stainless Steel Blade</p>
<p>Liquid Jardome with Clips for Hands Free Operation</p>","0","2023-12-13 13:18:25","2024-01-10 12:32:21");
INSERT INTO products VALUES("260","Miyako Blender (Steelo)","98320533","standard","C128","10","60","1","1","1","5200","7800","0","","","","","","","1","1702555907111Miyako Blender (Steelo).jpg","","","","0","0","","","","<p>Extra strong and sharp stainless steel blades</p>
<p>Liquid jar dome with clips forhands-freeoperation</p>
<p>Over load protection</p>
<p>Watt : 2200 W</p>
<p>Three speed with pulse</p>
<p>Special grade nylon couplers for firm grip</p>
<p>Special coating on body for great aesthetics</p>
<p>Made in India</p>
<p>100% Copper Motor</p>
<p>4 Stainless steel Set</p>
<p>Heavy ABC Body</p>","0","2023-12-13 13:18:25","2024-01-10 12:32:21");
INSERT INTO products VALUES("261","Miyako Blender (YT-2004 CH)","37902244","standard","C128","10","60","1","1","1","1600","2650","0","","","","","","","1","1702555968426Miyako Blender (Steelo).jpg","","","","0","0","","","","<p>Extra strong and sharp stainless steel blades</p>
<p>Liquid jar dome with clips forhands-freeoperation</p>
<p>Over load protection</p>
<p>Watt : 2200 W</p>
<p>Three speed with pulse</p>
<p>Special grade nylon couplers for firm grip</p>
<p>Special coating on body for great aesthetics</p>
<p>Made in India</p>
<p>100% Copper Motor</p>
<p>4 Stainless steel Set</p>
<p>Heavy ABC Body</p>","0","2023-12-13 13:18:25","2024-01-10 12:32:21");
INSERT INTO products VALUES("262","Miyako Coffee Grinder (MC- 07)","15630962","standard","C128","10","62","1","1","1","2400","3600","0","","","","","","","1","1702556078232Miyako Coffee Grinder (MC- 07).jpg","","","","0","0","","","","<ul>
<li>Stainless Steel Blade</li>
<li>Stainless steel grinder jar</li>
<li>Food grade metal</li>
</ul>","0","2023-12-13 13:18:25","2024-01-10 12:32:21");
INSERT INTO products VALUES("263","Miyako Coffee Maker CM- 327","94157162","standard","C128","10","88","1","1","1","2050","2850","0","","","","","","","1","1702884747744Miyako Coffee Maker.jpg","","","","0","0","","","","<p>Electric Coffee Maker</p>
<p>1000 W // 220 - 240 V&nbsp;</p>
<p>Capacity : 12-15 Cups (Depending on cup size)</p>
<p>Contains Filter / Spoon / Funnel / Glass Jug</p>","0","2023-12-13 13:18:25","2024-01-10 12:32:21");
INSERT INTO products VALUES("264","Miyako Doi Maker (XJ-10101)","183924","standard","C128","10","63","1","1","1","1600","2650","0","","","","","","","1","1702556152560Miyako Doi Maker.jpg","","","","0","0","","","","<p>Body Stainless Steel<br />Cover Transparent<br />Time 5-6hours</p>","0","2023-12-13 13:18:25","2024-01-10 13:04:56");
INSERT INTO products VALUES("265","Miyako Dry Iron (EI- 135)","42876052","standard","C128","10","64","1","1","1","1400","2500","0","","","","","","","1","1702556436376Miyako Dry Iron (EI- 135).jpg","","","","0","0","","","","<p>Dry electric iron</p>
<p>Temperature control</p>
<p>Non stick sole plate</p>
<p>Two pin plug</p>
<p>Pilot lamp</p>
<p>Swivel cord</p>","0","2023-12-13 13:18:25","2024-01-10 13:04:56");
INSERT INTO products VALUES("266","Miyako Dry Iron (EI- 226)","56342991","standard","C128","10","64","1","1","1","1450","2550","0","","","","","","","1","1702556477546Miyako Dry Iron (EI- 135).jpg","","","","0","0","","","","<p>Dry electric iron</p>
<p>Temperature control</p>
<p>Non stick sole plate</p>
<p>Two pin plug</p>
<p>Pilot lamp</p>
<p>Swivel cord</p>","0","2023-12-13 13:18:25","2024-01-10 13:04:56");
INSERT INTO products VALUES("267","Miyako Egg Beater HB-7705","34520919","standard","C128","10","65","1","1","1","1200","1800","0","","","","","","","1","1702556543832Miyako Egg Beater HB-7705.jpg","","","","0","0","","","","<p>Brand: Miyako</p>
<p>Model: HB-7705</p>
<p>Type: Electric Hand Blender/Hand Mixer/Egg Beater</p>
<p>Power: 750 watts</p>
<p>Voltage: Typically 220-240V,</p>
<p>Color Scheme: White with red accents</p>
<p>Dual-function hand mixer with High-Low settings</p>
<p>Durable steel blade</p>
<p>Adjustable speed settings</p>
<p>Easily removable blending rod</p>
<p>Quiet operation.</p>","0","2023-12-13 13:18:25","2024-01-10 13:04:56");
INSERT INTO products VALUES("268","Miyako Electric Juice (MJ-215)","319291","standard","C128","10","89","1","1","1","2350","3525","0","","","","","","","1","1702533784093Miyako Electric Juice (MJ-215).jpg","","","","0","0","","","","<p>Separate Pulp Container</p>
<p>Stainless Strainer Net</p>
<p>300 W / 220 V / 50 Hz</p>","0","2023-12-13 13:18:25","2024-01-10 13:04:57");
INSERT INTO products VALUES("269","Miyako Electric Juicer (MJ-210)","57024663","standard","C128","10","89","1","1","1","2450","3650","0","","","","","","","1","1702468671379Miyako Electric Juicer (MJ-210).jpg","","","","0","0","","","","","0","2023-12-13 13:18:25","2024-01-10 13:04:57");
INSERT INTO products VALUES("270","Miyako Electric Kettle (MJK-180 SSB)","99133624","standard","C128","10","66","1","1","1","900","1600","0","","","","","","","1","1702884513258Miyako Electric Kettle.png","","","","0","0","","","","<p>Time: Only 3 Minutes to make water hot.<br />Capacity: 1.8 liter capacity<br />Cup: 8+<br />Material: Stainless steel exterior &amp; interior.<br />Option: Auto Switch Off.<br />Power: 1500 Watt / 220-240 Volt / 50-60 Hz power consumption.<br />Cord system: Cord wraps under base for easy storage.</p>","0","2023-12-13 13:18:25","2024-01-10 13:04:57");
INSERT INTO products VALUES("271","Miyako Electric Kettle (MJK-18T)","72165317","standard","C128","10","66","1","1","1","1350","2350","0","","","","","","","1","1702884521539Miyako Electric Kettle.png","","","","0","0","","","","<p>Time: Only 3 Minutes to make water hot.<br />Capacity: 1.8 liter capacity<br />Cup: 8+<br />Material: Stainless steel exterior &amp; interior.<br />Option: Auto Switch Off.<br />Power: 1500 Watt / 220-240 Volt / 50-60 Hz power consumption.<br />Cord system: Cord wraps under base for easy storage.</p>","0","2023-12-13 13:18:25","2024-01-10 13:04:57");
INSERT INTO products VALUES("272","Miyako Electric Kettle (MK-23)","22970386","standard","C128","10","66","1","1","1","1200","2250","0","","","","","","","1","1702884565883Miyako Electric Kettle.png","","","","0","0","","","","<p>Time: Only 3 Minutes to make water hot.<br />Capacity: 1.8 liter capacity<br />Cup: 8+<br />Material: Stainless steel exterior &amp; interior.<br />Option: Auto Switch Off.<br />Power: 1500 Watt / 220-240 Volt / 50-60 Hz power consumption.<br />Cord system: Cord wraps under base for easy storage.</p>","0","2023-12-13 13:18:25","2024-01-10 13:04:57");
INSERT INTO products VALUES("273","Miyako Electric Kettle (MK-5016)","36908117","standard","C128","10","66","1","1","1","1350","2500","0","","","","","","","1","1702884572113Miyako Electric Kettle.png","","","","0","0","","","","<p>Time: Only 3 Minutes to make water hot.<br />Capacity: 1.8 liter capacity<br />Cup: 8+<br />Material: Stainless steel exterior &amp; interior.<br />Option: Auto Switch Off.<br />Power: 1500 Watt / 220-240 Volt / 50-60 Hz power consumption.<br />Cord system: Cord wraps under base for easy storage.</p>","0","2023-12-13 13:18:25","2024-01-10 13:04:57");
INSERT INTO products VALUES("274","Miyako Food Processor (MFP- 301)","23842093","standard","C128","10","67","1","1","1","6000","8950","0","","","","","","","1","1702556925128Miyako Food Processor.png","","","","0","0","","","","<p>3 types Jar</p>
<p>1250ML plastuc Bowl</p>
<p>1500ML Blender Jar</p>
<p>Mini grinder Jar</p>
<p>Safety lock device</p>
<p>2 speed Contro Pulse, 0,1and 2</p>
<p>Watt : 800 / 220-240v / ~50Hz</p>","0","2023-12-13 13:18:25","2024-01-10 13:04:57");
INSERT INTO products VALUES("275","Miyako Food Processor (MFP-807)","8350691","standard","C128","10","67","1","1","1","4500","6750","0","","","","","","","1","1702556992474Miyako Food Processor.png","","","","0","0","","","","<p>3 types Jar</p>
<p>1250ML plastuc Bowl</p>
<p>1500ML Blender Jar</p>
<p>Mini grinder Jar</p>
<p>Safety lock device</p>
<p>2 speed Contro Pulse, 0,1and 2</p>
<p>Watt : 800 / 220-240v / ~50Hz</p>","0","2023-12-13 13:18:25","2024-01-10 13:04:57");
INSERT INTO products VALUES("276","Miyako Hair Dryer (RCY-D18)","58730213","standard","C128","10","70","1","1","1","1075","1625","0","","","","","","","1","1702789616788Miyako Hair Dryer (RCY-D18).jpg","","","","0","0","","","","<p>Power: 1200 W. 2 Temperature settings.</p>
<p>Air intake filter. 2 Speed settings.</p>
<p>Power Supply: 230V~50Hz 1200 W.</p>
<p>Cool shot function.</p>
<p>Light weight. Easy to carry.</p>
<p>Professional finger diffuser and styling nozzle.</p>
<p>Hang up hook, cool shot, and fold-able handle.</p>
<p>Automatic cut-off for safety.</p>
<p>Complete drying &amp; styling flexibility.</p>
<p>Convenient &amp; fold-able handle.</p>
<p>Removable end cap for easy cleaning.</p>
<p>For ease of use at home, ideal for travel.</p>
<p>Cord guard with hanging loop for easy storage.</p>","0","2023-12-13 13:18:25","2024-01-10 13:04:57");
INSERT INTO products VALUES("277","Miyako Hand Mixer (GTM-8017A2)","27948315","standard","C128","10","71","1","1","1","1450","2175","0","","","","","","","1","1702789827434Miyako Hand Mixer.jpg","","","","0","0","","","","<p>5 Speed Motor</p>
<p>Copper Motor</p>
<p>250 Watt High Power</p>","0","2023-12-13 13:18:25","2024-01-10 13:04:57");
INSERT INTO products VALUES("278","Miyako Induction Stove (TC- Marble 02)","95135479","standard","C128","10","72","1","1","1","3100","5350","0","","","","","","","1","1702789926135Miyako Induction Stove.jpg","","","","0","0","","","","<p>Induction Cooker with Energy Saving Inverter Technology</p>
<p>800 Degree High Temperature</p>
<p>Marble Vitro Plate</p>
<p>2000 Watt</p>","0","2023-12-13 13:18:25","2024-01-10 13:04:57");
INSERT INTO products VALUES("279","Miyako Infrared Cooker (ATC-20T)","39279114","standard","C128","10","73","1","1","1","3100","5250","0","","","","","","","1","1702790056998Miyako Infrared Cooker.jpg","","","","0","0","","","","<p>Any pan can be used</p>
<p>4 digit display</p>
<p>Timer option&nbsp;</p>
<p>Over heating protection</p>
<p>2000 watt</p>","0","2023-12-13 13:18:25","2024-01-10 13:04:57");
INSERT INTO products VALUES("280","Miyako Meat Chopper (MC- 75)","93616821","standard","C128","10","90","1","1","1","2100","3150","0","","","","","","","1","1702469121730Miyako Meat Chopper (MC- 75).jpg","","","","0","0","","","","","0","2023-12-13 13:18:25","2024-01-10 13:04:58");
INSERT INTO products VALUES("281","Miyako Rice Cooker (Red 1208)","55700662","standard","C128","10","82","1","1","1","2700","4050","0","","","","","","","1","1702790304050Miyako Rice Cooker.jpg","","","","0","0","","","","<p>Food grade coating inside</p>
<p>High temperature protection</p>
<p>Keep warm function</p>
<p>Steam function</p>
<p>220-240 V / 700 WATT / 50-60 Hz</p>","0","2023-12-13 13:18:25","2024-01-10 13:06:09");
INSERT INTO products VALUES("282","Miyako Rice Cooker (Silver 1180)","60430529","standard","C128","10","82","1","1","1","2200","3350","0","","","","","","","1","1702790537843Miyako Rice Cooker (Silver 1180).jpg","","","","0","0","","","","<p>1.8 Liters Automatic Rice Cooker for healthy Rice Cooking and Steaming.</p>
<p>Double pots&ndash; Both made of Food grade anodized Aluminum.</p>
<p>3 in 1 Functions &ndash; Rice Cooker, Keep Warm and Steamer.</p>
<p>Automatic Cook &amp; Warm Button For Easy Control.</p>
<p>High Temperature protection.</p>
<p>Easy and Faster Cooking.</p>
<p>Measuring cup and Spoon included.</p>","0","2023-12-13 13:18:25","2024-01-10 13:06:09");
INSERT INTO products VALUES("283","Miyako Sandwich Maker (SW-219MR)","6731934","standard","C128","10","83","1","1","1","950","1425","0","","","","","","","1","1702790818632Miyako Sandwich Maker2.jpg","","","","0","0","","","","<p>Pilot Lamp<br />Easy Cleaning<br />Overheat Safety Protection<br />Thermostatically Controlled<br />Npon-Stick Coating<br />Stand Upright For<br />Compact Storage<br />220-240 V / 50~60 Hz / 750W</p>","0","2023-12-13 13:18:25","2024-01-10 13:06:09");
INSERT INTO products VALUES("284","Miyako Toaster (KT-6002)","43291496","standard","C128","10","61","1","1","1","1250","1875","0","","","","","","","1","1702790918545Miyako Toaster.jpg","","","","0","0","","","","<p>Complete with automatic bread lifter</p>
<p>Trendy toaster for two slices bread</p>
<p>220-240V/ 50-60Hz/ 750WATT</p>","0","2023-12-13 13:18:25","2024-01-10 12:32:21");
INSERT INTO products VALUES("285","My Battle Water Bottle (500ML)","52767208","standard","C128","20","91","1","1","1","350","600","0","","","","","","","1","1702790986363ZANNUO Water Battle (700 ML).jpg","","","","0","0","","","","","0","2023-12-13 13:18:25","2024-01-10 13:07:10");
INSERT INTO products VALUES("286","NOVA Android TV (NV-3230H SM)","8657036","standard","C128","21","98","1","1","1","13800","20700","0","","","","","","","1","1702884112101android tv.jpg","","","","0","0","","","","<p>FULL HD</p>
<p>FRAME LESS LED TV</p>
<p>PANEL GRADE AA+</p>
<p>UPDATE ANDROID VERSION</p>
<p>SOUND BAR SPEAKER</p>
<p>HDMI, USB</p>
<p>MINI HOME THEATER SOUND SYSTEM</p>
<p>HIGH SPEED INTERNET SUPPORTED</p>","0","2023-12-13 13:18:25","2024-01-10 12:30:50");
INSERT INTO products VALUES("287","NOVA Android TV (NV-3230SBVR)","21096517","standard","C128","21","98","1","1","1","14500","21750","0","","","","","","","1","1702791942899smarttv.jpg","","","","0","0","","","","<p>FULL HD</p>
<p>FRAME LESS LED TV</p>
<p>PANEL GRADE AA+</p>
<p>UPDATE ANDROID VERSION</p>
<p>SOUND BAR SPEAKER</p>
<p>HDMI, USB</p>
<p>MINI HOME THEATER SOUND SYSTEM</p>
<p>HIGH SPEED INTERNET SUPPORTED</p>","0","2023-12-13 13:18:25","2024-01-10 12:30:50");
INSERT INTO products VALUES("288","NOVA Android TV (NV-4305G-H)","78102315","standard","C128","21","98","1","1","1","31500","46500","0","","","","","","","1","1702791990468smarttv2.jpg","","","","0","0","","","","<p>FULL HD</p>
<p>FRAME LESS LED TV</p>
<p>PANEL GRADE AA+</p>
<p>UPDATE ANDROID VERSION</p>
<p>SOUND BAR SPEAKER</p>
<p>HDMI, USB</p>
<p>MINI HOME THEATER SOUND SYSTEM</p>
<p>HIGH SPEED INTERNET SUPPORTED</p>","0","2023-12-13 13:18:25","2024-01-10 12:30:50");
INSERT INTO products VALUES("289","NOVA Mixer Grinder (NV-157J)","10118793","standard","C128","21","60","1","1","1","3900","5850","0","","","","","","","1","1702793794709NOVA Mixer Grinder2.jpg","","","","0","0","","","","<p>FULL HD</p>
<p>FRAME LESS LED TV</p>
<p>PANEL GRADE AA+</p>
<p>UPDATE ANDROID VERSION</p>
<p>SOUND BAR SPEAKER</p>
<p>HDMI, USB</p>
<p>MINI HOME THEATER SOUND SYSTEM</p>
<p>HIGH SPEED INTERNET SUPPORTED</p>","0","2023-12-13 13:18:25","2024-01-10 12:32:21");
INSERT INTO products VALUES("290","NOVA Mixer Grinder (NV-166-RV)","93847049","standard","C128","21","60","1","1","1","4500","6750","0","","","","","","","1","1702793856557Miyako Blender.jpg","","","","0","0","","","","<p>FULL HD</p>
<p>FRAME LESS LED TV</p>
<p>PANEL GRADE AA+</p>
<p>UPDATE ANDROID VERSION</p>
<p>SOUND BAR SPEAKER</p>
<p>HDMI, USB</p>
<p>MINI HOME THEATER SOUND SYSTEM</p>
<p>HIGH SPEED INTERNET SUPPORTED</p>","0","2023-12-13 13:18:25","2024-01-10 12:32:21");
INSERT INTO products VALUES("291","NOVA Rice Cooker (98-2NS-H)","91843621","standard","C128","21","82","1","1","1","2450","3450","0","","","","","","","1","1702796633083NOVA Rice Cooker.jpg","","","","0","0","","","","<p>Capacity:1.8 liter</p>
<p>Model: 220</p>
<p>Voltage: 650W/220-240V</p>
<p>50-60Hz</p>
<p>Power: 650</p>","0","2023-12-13 13:18:25","2024-01-10 13:06:09");
INSERT INTO products VALUES("292","Osaka AC/DC Bulb (10 Watt)","26435489","standard","C128","22","75","1","1","1","435","670","0","","","","","","","1","1702884322290Osaka.png","","","","0","0","","","","<p>Osaka LED Bulb Cold Day Light 10 Watt E27 (Patch/Screw Type)Watt: 10 WFeature: Day Light CoolOsaka ECO 10W LED Bulb is a part of the one of the most successful LED series by OsakaThe Eco series has excellent performance and highly satisfied customer reviewMore energy saving than CFL bulb.</p>","0","2023-12-13 13:18:25","2024-01-10 13:04:58");
INSERT INTO products VALUES("293","Osaka AC/DC Bulb (12 Watt)","82459003","standard","C128","22","75","1","1","1","475","730","0","","","","","","","1","1702884331169Osaka.png","","","","0","0","","","","<p>Osaka LED Bulb Cold Day Light 12 Watt E27 (Patch/Screw Type)Watt: 12 WFeature: Day Light CoolOsaka ECO 12W LED Bulb is a part of the one of the most successful LED series by OsakaThe Eco series has excellent performance and highly satisfied customer reviewMore energy saving than CFL bulb.</p>","0","2023-12-13 13:18:25","2024-01-10 13:04:58");
INSERT INTO products VALUES("294","Panasonic Dry Iron (NI-317T)","94353242","standard","C128","23","64","1","1","1","2000","2850","0","","","","","","","1","1702797320346Panasonic Dry Iron.jpg","","","","0","0","","","","<p>Panasonic NI-317T Electric Iron.</p>
<p>1.000w Power/140v Voltage.</p>
<p>Non-Stick Coating Soleplate.</p>
<p>Steel Type Base Plate.</p>
<p>Light Weight (0.9kg)</p>
<p>Orange, Green, Red color handle.</p>
<p>Wide Heel Rest And&nbsp;Sheathed Heater.</p>","0","2023-12-13 13:18:25","2024-01-10 13:04:56");
INSERT INTO products VALUES("295","Panasonic Hair Dryer (EH-ND11-A)","94870903","standard","C128","23","70","1","1","1","1400","2150","0","","","","","","","1","1702795734894Panasonic Hair Dryer.jpg","","","","0","0","","","","<p>3-flexible speed settings for careful drying</p>
<p>Compact design, portable &amp; durable</p>
<p>Comfortable, textured handle for easy grip</p>
<p>Turbo function consumes 1000W power</p>
<p>Easy storage hook for convenient storage</p>
<p>Tangle-free cord enables easy usage</p>
<p>Selectable temperature/ airflow settings</p>
<p>Healthy mode with airflow of 50 degrees</p>","0","2023-12-13 13:18:25","2024-01-10 13:04:57");
INSERT INTO products VALUES("296","Panasonic Hair Dryer (EH-ND21-P)","76918133","standard","C128","23","70","1","1","1","2100","3150","0","","","","","","","1","1702795816260Panasonic Hair Dryer.jpg","","","","0","0","","","","<p>3-flexible speed settings for careful drying</p>
<p>Compact design, portable &amp; durable</p>
<p>Comfortable, textured handle for easy grip</p>
<p>Turbo function consumes 1000W power</p>
<p>Easy storage hook for convenient storage</p>
<p>Tangle-free cord enables easy usage</p>
<p>Selectable temperature/ airflow settings</p>
<p>Healthy mode with airflow of 50 degrees</p>","0","2023-12-13 13:18:25","2024-01-10 13:04:57");
INSERT INTO products VALUES("297","Pepsi Water Bottle (500ML)","20427194","standard","C128","20","91","1","1","1","475","620","0","","","","","","","1","1702795906727Pepsi Water Bottle.jpg","","","","0","0","","","","<p>Durable water bottle</p>","0","2023-12-13 13:18:25","2024-01-10 13:07:10");
INSERT INTO products VALUES("298","Philips Dry Iron (HD1172)","68199002","standard","C128","24","64","1","1","1","1550","2250","0","","","","","","","1","1702795993603Philips Dry Iron.jpg","","","","0","0","","","","<p>Brand: Philips</p>
<p>High Standard</p>
<p>Length: 1.6m</p>
<p>Cord Freedom: 180 degree</p>
<p>Looking good with well-pressed clothes</p>
<p>Flexible</p>
<p>Better heat transfer</p>
<p>Easily temperature control</p>
<p>Sole Plates: Finished Coated</p>
<p>Panel: Uniform Heating</p>
<p>Power: 750W</p>
<p>Consumption: Low Power</p>
<p>&nbsp;</p>","0","2023-12-13 13:18:25","2024-01-10 13:04:56");
INSERT INTO products VALUES("299","Philips Hair Dryer	(BHC010)","25926795","standard","C128","24","70","1","1","1","1600","2450","0","","","","","","","1","1702796158645Philips Hair Dryer.jpg","","","","0","0","","","","<p>1200W</p>
<p>Thermoprotect temperature setting</p>
<p>Cool air setting</p>
<p>Foldable handle for easy portability</p>","0","2023-12-13 13:18:25","2024-01-10 13:04:57");
INSERT INTO products VALUES("300","Pure it Kit- 1500 LTR","60019748","standard","C128","25","74","1","1","1","727","800","0","","","","","","","1","1702883711197Pure it Kit- 1500 LTR.jpg","","","","0","0","","","","<p>Brand: Unilever</p>
<p>Pureit Germ Kill Kit 1500L</p>
<p>Capacity: 1500 Litres</p>
<p>Activated Carbon Trap (ACT): 1 unit</p>
<p>Activated Carbon Trap (ACT): 1 unit</p>
<p>Germ Kill Processor (GKP): 1 unit</p>","0","2023-12-13 13:18:25","2024-01-10 13:04:57");
INSERT INTO products VALUES("301","Pure it Kit- 3000 LTR","13910298","standard","C128","25","74","1","1","1","1225","1400","0","","","","","","","1","1702883699780Pure it Kit- 1500 LTR.jpg","","","","0","0","","","","<ul>
<li>Brand: Unilever</li>
<li>Pureit Germ Kill Kit 3000L</li>
<li>Capacity: 3000 Litres</li>
<li>Activated Carbon Trap (ACT): 1 unit</li>
<li>Activated Carbon Trap (ACT): 1 unit</li>
<li>Germ Kill Processor (GKP): 1 unit</li>
</ul>","0","2023-12-13 13:18:25","2024-01-10 13:04:57");
INSERT INTO products VALUES("302","Pure it Water Filter (Classic)","11092933","standard","C128","25","87","1","1","1","4200","4999","0","","","","","","","1","1702796508485Pure it Water Filter (Classic).jpg","","","","0","0","","","","<p>Pureit brings to you a practical water purifier with a large storage capacity to<br />make sure you and your family always drink pure water, without any hassle.</p>","0","2023-12-13 13:18:25","2024-01-10 13:07:10");
INSERT INTO products VALUES("303","SAMSUNG Smart TV (UA32T4400AR)","70538746","standard","C128","4","98","1","1","1","23000","34500","0","","","","","","","1","1702538840930smarttv2.jpg","","","","0","0","","","","<p>MPN: UA32T4400ARSFS</p>
<p>Model: 32T4400</p>
<p>Display: 32@ HD (1366 x 768), HDR 10+</p>
<p>Sound Output (RMS):20W</p>
<p>Picture Engine: Hyper Real</p>
<p>PQI (Picture Quality Index): 900</p>","0","2023-12-13 13:18:25","2024-01-10 12:30:50");
INSERT INTO products VALUES("304","SAMSUNG Smart TV (UA43BU8000A)","47376609","standard","C128","4","98","1","1","1","45000","67500","0","","","","","","","1","1702884153682android tv.jpg","","","","0","0","","","","<p><span class=@usp-text@>Dynamic Crystal Color</span></p>
<p><span class=@usp-text@>AirSlim</span></p>
<p><span class=@usp-text@>Crystal Processor 4K</span></p>","0","2023-12-13 13:18:25","2024-01-10 12:30:50");
INSERT INTO products VALUES("305","SAMSUNG Smart TV (UA43T5400AR)","18957046","standard","C128","4","98","1","1","1","34000","51000","0","","","","","","","1","1702537716311smarttv.jpg","","","","0","0","","","","<p>&nbsp;<strong>Full HD Resolution:</strong>&nbsp;Your favorite TV programs and movies get real. The rich and vivid Full HD resolution with twice the resolution of HD TV.<br />&nbsp;<strong>Smart Hub &amp; One Remote Control:</strong>&nbsp;It&rsquo;s all you need to discover tons of different content in one place and get maximum enjoyment. The sleek One Remote Control keeps it simple, allowing you to quickly search all your favorite content from your set-top box to game console, apps, and even live TV.<br /><strong>&nbsp;Multiple Voice Assistants:</strong>&nbsp;Choose your favorite voice assistant; Amazon Alexa or Google Assistant. For the first time, all are built into your Samsung TV to provide the optimal entertainment experience and advanced control in your connected home.<br />&nbsp;<strong>Remote Access:</strong>&nbsp;Get office work done on your TV at home. Remote Access lets you mirror your computer&rsquo;s display on The Sero wirelessly. You can even tap into your office PC to access files, or work on documents using Microsoft Office 365, all from the comfort of your couch.<br />&nbsp;<strong>Slim:</strong>&nbsp;This beautifully slim design melts into any existing d&eacute;cor and elevates the style without taking it over.<br />&nbsp;<strong>See the stunning detail:</strong>&nbsp;High-Dynamic Range levels up the bright expression of your TV, so you can enjoy an immense spectrum of colors and visual details, even in dark scenes.<br />&nbsp;<strong>PurColor:</strong>&nbsp;PurColor makes watching videos feel almost like you&rsquo;re there. It enables the TV to express a huge range of colors for optimal picture performance, and an immersive viewing experience.<br /><strong>&nbsp;Ultra Clean View:</strong>&nbsp;Ultra Clean View delivers high-quality images with less distortion, utilizing an advanced algorithm to analyze original content and deliver improved detail.<br />&nbsp;<strong>Contrast Enhancer:</strong>&nbsp;Contrast Enhancer brings flat images to life by adjusting the contrast, offering outstanding picture quality with deeper depth.<br />&nbsp;<strong>AirPlay 2:</strong>&nbsp;With AirPlay 2 built-in, you can stream or share content from Apple devices to the big screen. Effortlessly play videos, music, photos and more from your iPhone, iPad and Mac on your Samsung TV.</p>","0","2023-12-13 13:18:25","2024-01-10 12:30:50");
INSERT INTO products VALUES("306","Sport Battle Water Bottle (600 ML)","80125499","standard","C128","20","91","1","1","1","220","350","0","","","","","","","1","1702794335607ZANNUO Water Battle (700 ML).jpg","","","","0","0","","","","","0","2023-12-13 13:18:25","2024-01-10 13:07:10");
INSERT INTO products VALUES("307","Super G Food Processor  (SGCF107E) 350 Watt","11397412","standard","C128","26","67","1","1","1","2173","3800","0","","","","","","","1","1702794518245Super G Food Processor.jpg","","","","0","0","","","","<p><span class=@a-list-item@>750 WATTS POWERFUL MOTOR, 3 STAINLESS STEEL JARS ( Jar Size: 1.5L, 1.25L &amp; 0.5L)</span></p>
<p><span class=@a-list-item@>Dry and wet Grinding</span></p>
<p><span class=@a-list-item@>ISI Certified Mixer Grinder</span></p>
<p><span class=@a-list-item@>Includes a Manual book, Warranty card</span></p>","0","2023-12-13 13:18:25","2024-01-10 13:04:57");
INSERT INTO products VALUES("308","Super General (SGST-1203 EB1) 1.0 Ton","1348918","standard","C128","26","100","1","1","1","32000","45500","0","","","","","","","1","1702794833202Super General ac.jpg","","","","0","0","","","","<p>Super General Wall Mounted Split 1.0 Ton | SGST1203 / SGST1203R Specification: Capacity:&nbsp;1.0 Ton Refrigerant: R410a Compressor: ROTARY Climate Type / Air Flow: T1/530 Voltage (V, Hz, Ph): 220-240V, 50Hz, 1Ph Weight (Indoor) (Net /Gross Kg): 8 / 10 Weight (Outdoor) (Net /Gross Kg): 29 / 33 Dimension (Indoor-Prod/Pack WxDxH...</p>
<p>&nbsp;</p>","0","2023-12-13 13:18:25","2024-01-10 12:32:20");
INSERT INTO products VALUES("309","Super General (SGST-1803 EB1) 1.5 Ton","97785051","standard","C128","26","100","1","1","1","42000","56500","0","","","","","","","1","1702794885726Super General ac.jpg","","","","0","0","","","","<p>Super General Wall Mounted Split 1.5 Ton | SGST1203 / SGST1203R Specification: Capacity:&nbsp;1.0 Ton Refrigerant: R410a Compressor: ROTARY Climate Type / Air Flow: T1/530 Voltage (V, Hz, Ph): 220-240V, 50Hz, 1Ph Weight (Indoor) (Net /Gross Kg): 8 / 10 Weight (Outdoor) (Net /Gross Kg): 29 / 33 Dimension (Indoor-Prod/Pack WxDxH...</p>","0","2023-12-13 13:18:25","2024-01-10 12:32:20");
INSERT INTO products VALUES("310","Super General (SGST-2403 EB1) 2.0 Ton","75642360","standard","C128","26","100","1","1","1","52000","67500","0","","","","","","","1","1702794919165Super General ac.jpg","","","","0","0","","","","<p>Super General Wall Mounted Split 2.0 Ton | SGST1203 / SGST1203R Specification: Capacity:&nbsp;1.0 Ton Refrigerant: R410a Compressor: ROTARY Climate Type / Air Flow: T1/530 Voltage (V, Hz, Ph): 220-240V, 50Hz, 1Ph Weight (Indoor) (Net /Gross Kg): 8 / 10 Weight (Outdoor) (Net /Gross Kg): 29 / 33 Dimension (Indoor-Prod/Pack WxDxH...</p>","0","2023-12-13 13:18:25","2024-01-10 12:32:20");
INSERT INTO products VALUES("311","Super General Gas Stove (SGB2020FSC)","35660177","standard","C128","26","68","1","1","1","3724","6200","0","","","","","","","1","1702883553086Super General Gas Stove.jpg","","","","0","0","","","","<p>Introducing our cutting-edge gas stove with a sleek and durable design, perfect for modern kitchens. This high-performance appliance boasts two burners equipped with normal burner caps, ensuring efficient and even cooking. The body of the stove is crafted from a combination of premium stainless steel and glass, adding both elegance and durability to your culinary space.</p>
<p>Experience the convenience of auto-ignition, coupled with a Flame Safety Device (FSD) for enhanced safety measures. The sturdy legs are made from high-quality ABS material, providing stability and reliability during your cooking adventures.</p>
<p>In terms of dimensions, this gas stove measures 710x410x70 mm in its product form and 760x445x150 mm when packed, offering a compact and space-saving solution for your kitchen. The stove is designed to be lightweight, with a net weight of 8.8 kg, while the gross weight, including packaging, is 9.5 kg. Elevate your cooking experience with this efficient, stylish, and user-friendly gas stove.</p>","0","2023-12-13 13:18:25","2024-01-10 13:04:57");
INSERT INTO products VALUES("312","Super General Inverter	 (SGST-1203i) 1.0 Ton","96305594","standard","C128","26","100","1","1","1","38000","51500","0","","","","","","","1","1702795210913Super General Inverter.jpg","","","","0","0","","","","<p>4 Way Swing</p>
<p>Auto Leakage Detection</p>
<p>Auto Restart</p>
<p>Follow Me I Feel</p>
<p>Gold Fin</p>","0","2023-12-13 13:18:25","2024-01-10 12:32:20");
INSERT INTO products VALUES("313","Super General Inverter	 (SGST-1803i) 1.5 Ton","69753228","standard","C128","26","100","1","1","1","52000","69500","0","","","","","","","1","1702795358160Super General ac2.jpeg","","","","0","0","","","","<p>4 Way Swing</p>
<p>Auto Leakage Detection</p>
<p>Auto Restart</p>
<p>Follow Me I Feel</p>
<p>Gold Fin</p>","0","2023-12-13 13:18:25","2024-01-10 12:32:20");
INSERT INTO products VALUES("314","Super General Inverter	 (SGST-2403i) 2.0 Ton","41812339","standard","C128","26","100","1","1","1","62000","83700","0","","","","","","","1","1702797768507Super General Inverter.jpg","","","","0","0","","","","<p>4 Way Swing</p>
<p>Auto Leakage Detection</p>
<p>Auto Restart</p>
<p>Follow Me I Feel</p>
<p>Gold Fin</p>","0","2023-12-13 13:18:25","2024-01-10 12:32:20");
INSERT INTO products VALUES("315","Super General Iron (SGI-293S) 2400 watt","68010694","standard","C128","26","64","1","1","1","1900","3250","0","","","","","","","1","1702797941334Super General Iron.jpg","","","","0","0","","","","<p>Dry/ Steam/Spray</p>
<p>Powerful burst of steam</p>
<p>Anti calcium, Anti drip, Self-cleaning</p>","0","2023-12-13 13:18:25","2024-01-10 13:04:56");
INSERT INTO products VALUES("316","Super General Kettle  (SGEK172PF) 1.7 Litres","10187350","standard","C128","26","66","1","1","1","980","1550","0","","","","","","","1","1702883333831kettle.png","","","","0","0","","","","<ul class=@a-unordered-list a-vertical a-spacing-mini@>
<li class=@a-spacing-mini@><span class=@a-list-item@>【The Kettle】Compact and powerful electric water-kettle made of stainless steel. With its timeless design in silver color it fits amicably in every kitchen environment and style. With XL water capacity of up to 1.8 liters. Boil water within only a few minutes and enjoy freshly brewed tea, coffee or prepare baby food or instant meals. Great to use at home, in the office, coffee shops or other working environments such as hotels, restaurants and bars.</span></li>
<li class=@a-spacing-mini@><span class=@a-list-item@>【Easy handling】This practical and versatile kettle allows for 1-hand operation thanks to the hinged lid with lid opener. With help of the water level indicator, the fill level can be easily read from the outside. Equipped with a 360 degree swivel base for wireless connection, maximum convenience and portability in the kitchen, or any other environment. Thanks to the durable light-weight plastic handle, it can be easily moved around and lies comfortably in the hand - also when filled with water!</span></li>
<li class=@a-spacing-mini@><span class=@a-list-item@>【For your safety】Maximum safety during operation is ensured by the ON/OFF switch with a prominent red indicator light. The auto cut-off feature shuts the kettle down once the water has reached the desired temperature. The boil-dry-protection prevents overheating. The heat-insulated plastic handle in ergonomic design allows for an easy handling of the kettle also when filled with boiling water.</span></li>
<li class=@a-spacing-mini@><span class=@a-list-item@>【Smart Comfort】This practical stainless steel water boiler is the perfect kitchen accessory that should not be missed. It is equipped with a concealed heating element for easy cleaning and a practical cord storage in the 360 degree station. The stainless steel body with a glossy silver finish is easy to clean with water and household-cleaner. The push-to-open button allows for easy re-fill. With its weight of up to 1 kg, the water-heater can be operated and handled with one hand only.</span></li>
<li class=@a-spacing-mini@><span class=@a-list-item@>【Powerful &amp; universal】XL Volume of up to 1.8 liters in a sturdy and high-quality stainless steel body with heat insulated plastic handle and lid with push-to-open function. Easy cleaning thanks to concealed heating element and large opening of lid (diameter 9 cm). Maximum power of 2140W, 240 Volts, 50-60 Hz.</span></li>
</ul>","0","2023-12-13 13:18:25","2024-01-10 13:04:57");
INSERT INTO products VALUES("317","Transtec LED Bulb (05 Watt)","39040652","standard","C128","27","75","1","1","1","88","150","0","","","","","","","1","1702535199323transtec.jpg","","","","0","0","","","","<p data-spm-anchor-id=@0.0.0.i11.7d857463jsC8jM@>&ldquo;Transtec Lighting&rdquo; is the pioneer of world class lighting products in Bangladesh and the only lighting company in the country listed in the stock market. It was incorporated in 1962 as a subsidiary of PHILIPS, Holland NV and started manufacturing Philips bulbs in the then East Pakistan. In 1993, TRANSCOM one of the leading &amp; fastest growing diversiﬁed local business conglomerates acquired the full operation continued manufacturing.</p>
<p>Initial Lumen: 650&plusmn;5%</p>
<p>Beam Angle: 270&deg;</p>
<p>Surge Voltage Protection &ge; 2.5 KV</p>
<p>Torque: 3 N-M</p>
<p>CRI (Ra): 80</p>
<p>SDCM: 3</p>","0","2023-12-13 13:18:25","2024-01-10 13:04:58");
INSERT INTO products VALUES("318","Transtec LED Bulb (07 Watt)","31045803","standard","C128","27","75","1","1","1","110","195","0","","","","","","","1","1702535228778transtec.jpg","","","","0","0","","","","<p data-spm-anchor-id=@0.0.0.i11.7d857463jsC8jM@>&ldquo;Transtec Lighting&rdquo; is the pioneer of world class lighting products in Bangladesh and the only lighting company in the country listed in the stock market. It was incorporated in 1962 as a subsidiary of PHILIPS, Holland NV and started manufacturing Philips bulbs in the then East Pakistan. In 1993, TRANSCOM one of the leading &amp; fastest growing diversiﬁed local business conglomerates acquired the full operation continued manufacturing.</p>
<p>Initial Lumen: 650&plusmn;5%</p>
<p>Beam Angle: 270&deg;</p>
<p>Surge Voltage Protection &ge; 2.5 KV</p>
<p>Torque: 3 N-M</p>
<p>CRI (Ra): 80</p>
<p>SDCM: 3</p>","0","2023-12-13 13:18:25","2024-01-10 13:04:58");
INSERT INTO products VALUES("319","Transtec LED Bulb (09 Watt)","33189065","standard","C128","27","75","1","1","1","135","220","0","","","","","","","1","1702793958785transtec.jpg","","","","0","0","","","","<p data-spm-anchor-id=@0.0.0.i11.7d857463jsC8jM@>&ldquo;Transtec Lighting&rdquo; is the pioneer of world class lighting products in Bangladesh and the only lighting company in the country listed in the stock market. It was incorporated in 1962 as a subsidiary of PHILIPS, Holland NV and started manufacturing Philips bulbs in the then East Pakistan. In 1993, TRANSCOM one of the leading &amp; fastest growing diversiﬁed local business conglomerates acquired the full operation continued manufacturing.</p>
<p>Initial Lumen: 650&plusmn;5%</p>
<p>Beam Angle: 270&deg;</p>
<p>Surge Voltage Protection &ge; 2.5 KV</p>
<p>Torque: 3 N-M</p>
<p>CRI (Ra): 80</p>
<p>SDCM: 3</p>","0","2023-12-13 13:18:25","2024-01-10 13:04:58");
INSERT INTO products VALUES("320","Transtec LED Bulb (13 Watt)","9032318","standard","C128","27","75","1","1","1","158","275","0","","","","","","","1","1702793931173transtec.jpg","","","","0","0","","","","<p data-spm-anchor-id=@0.0.0.i11.7d857463jsC8jM@>&ldquo;Transtec Lighting&rdquo; is the pioneer of world class lighting products in Bangladesh and the only lighting company in the country listed in the stock market. It was incorporated in 1962 as a subsidiary of PHILIPS, Holland NV and started manufacturing Philips bulbs in the then East Pakistan. In 1993, TRANSCOM one of the leading &amp; fastest growing diversiﬁed local business conglomerates acquired the full operation continued manufacturing.</p>
<p>Initial Lumen: 650&plusmn;5%</p>
<p>Beam Angle: 270&deg;</p>
<p>Surge Voltage Protection &ge; 2.5 KV</p>
<p>Torque: 3 N-M</p>
<p>CRI (Ra): 80</p>
<p>SDCM: 3</p>","0","2023-12-13 13:18:25","2024-01-10 13:04:58");
INSERT INTO products VALUES("321","Transtec LED Bulb (15 Watt)","37692615","standard","C128","27","75","1","1","1","168","300","0","","","","","","","1","1702535254022transtec.jpg","","","","0","0","","","","<p data-spm-anchor-id=@0.0.0.i11.7d857463jsC8jM@>&ldquo;Transtec Lighting&rdquo; is the pioneer of world class lighting products in Bangladesh and the only lighting company in the country listed in the stock market. It was incorporated in 1962 as a subsidiary of PHILIPS, Holland NV and started manufacturing Philips bulbs in the then East Pakistan. In 1993, TRANSCOM one of the leading &amp; fastest growing diversiﬁed local business conglomerates acquired the full operation continued manufacturing.</p>
<p>Initial Lumen: 650&plusmn;5%</p>
<p>Beam Angle: 270&deg;</p>
<p>Surge Voltage Protection &ge; 2.5 KV</p>
<p>Torque: 3 N-M</p>
<p>CRI (Ra): 80</p>
<p>SDCM: 3</p>","0","2023-12-13 13:18:25","2024-01-10 13:04:58");
INSERT INTO products VALUES("322","Transtec LED Bulb (18 Watt)","42656800","standard","C128","27","75","1","1","1","208","355","0","","","","","","","1","1702535314550transtec.jpg","","","","0","0","","","","<p data-spm-anchor-id=@0.0.0.i11.7d857463jsC8jM@>&ldquo;Transtec Lighting&rdquo; is the pioneer of world class lighting products in Bangladesh and the only lighting company in the country listed in the stock market. It was incorporated in 1962 as a subsidiary of PHILIPS, Holland NV and started manufacturing Philips bulbs in the then East Pakistan. In 1993, TRANSCOM one of the leading &amp; fastest growing diversiﬁed local business conglomerates acquired the full operation continued manufacturing.</p>
<p>Initial Lumen: 650&plusmn;5%</p>
<p>Beam Angle: 270&deg;</p>
<p>Surge Voltage Protection &ge; 2.5 KV</p>
<p>Torque: 3 N-M</p>
<p>CRI (Ra): 80</p>
<p>SDCM: 3</p>","0","2023-12-13 13:18:25","2024-01-10 13:04:58");
INSERT INTO products VALUES("323","Transtec LED Bulb (20 Watt)","91708149","standard","C128","27","75","1","1","1","285","400","0","","","","","","","1","1702535049558transtec.jpg","","","","0","0","","","","<p data-spm-anchor-id=@0.0.0.i11.7d857463jsC8jM@>&ldquo;Transtec Lighting&rdquo; is the pioneer of world class lighting products in Bangladesh and the only lighting company in the country listed in the stock market. It was incorporated in 1962 as a subsidiary of PHILIPS, Holland NV and started manufacturing Philips bulbs in the then East Pakistan. In 1993, TRANSCOM one of the leading &amp; fastest growing diversiﬁed local business conglomerates acquired the full operation continued manufacturing.</p>
<p>Initial Lumen: 650&plusmn;5%</p>
<p>Beam Angle: 270&deg;</p>
<p>Surge Voltage Protection &ge; 2.5 KV</p>
<p>Torque: 3 N-M</p>
<p>CRI (Ra): 80</p>
<p>SDCM: 3</p>","0","2023-12-13 13:18:25","2024-01-10 13:04:58");
INSERT INTO products VALUES("324","Transtec LED Bulb (30 Watt)","5393617","standard","C128","27","75","1","1","1","380","545","0","","","","","","","1","1702534566256transtec.jpg,1702535161168transtec.jpg","","","","0","0","","","","<p data-spm-anchor-id=@0.0.0.i11.7d857463jsC8jM@>&ldquo;Transtec Lighting&rdquo; is the pioneer of world class lighting products in Bangladesh and the only lighting company in the country listed in the stock market. It was incorporated in 1962 as a subsidiary of PHILIPS, Holland NV and started manufacturing Philips bulbs in the then East Pakistan. In 1993, TRANSCOM one of the leading &amp; fastest growing diversiﬁed local business conglomerates acquired the full operation continued manufacturing.</p>
<p>Initial Lumen: 650&plusmn;5%</p>
<p>Beam Angle: 270&deg;</p>
<p>Surge Voltage Protection &ge; 2.5 KV</p>
<p>Torque: 3 N-M</p>
<p>CRI (Ra): 80</p>
<p>SDCM: 3</p>","0","2023-12-13 13:18:25","2024-01-10 13:04:58");
INSERT INTO products VALUES("325","Vacuum Cup Water Bottle (450 ML)","31921617","standard","C128","20","91","1","1","1","600","780","0","","","","","","","1","1702469036924Vacuum Cup Water Battle (450 ML).jpg","","","","0","0","","","","","0","2023-12-13 13:18:25","2024-01-10 13:07:10");
INSERT INTO products VALUES("326","Weidasi Mosquito Swatter	(WD-922A)","34955121","standard","C128","28","78","1","1","1","370","550","0","","","","","","","1","1702534151870Weidasi Mosquito Swatter.jpg","","","","0","0","","","","<p>Weidasi WD 960 USB Mosquito Killing Bat</p>
<p>Applicable Area: &lt;20 Square Meters</p>
<p>Product: Electric Mosquito Swatter</p>
<p>Power Source: Electrical, Batteries</p>
<p>Charger: Rechargeable</p>
<p>Pest Type: Flies, Mosquitoes, Moths</p>
<p>Model Number: WD-960 Electric Racket</p>
<p>Pest Control Type: Fly Swatter</p>
<p>Material: ABS Plastic</p>
<p>Function: Three-In-One Mosquito Bat And Mosquito Killer Lamp</p>
<p>Power: 5W (110-220V)</p>
<p>Battery: 500mAh Lithium Battery</p>
<p>Usage: Indoor,Outdoor, Home, Hotel</p>","0","2023-12-13 13:18:25","2024-01-10 13:05:19");
INSERT INTO products VALUES("327","Weidasi Mosquito Swatter	(WD-979)","90591031","standard","C128","28","78","1","1","1","420","650","0","","","","","","","1","1702534205479Weidasi Mosquito Swatter.jpg","","","","0","0","","","","<p>Weidasi WD 960 USB Mosquito Killing Bat</p>
<p>Applicable Area: &lt;20 Square Meters</p>
<p>Product: Electric Mosquito Swatter</p>
<p>Power Source: Electrical, Batteries</p>
<p>Charger: Rechargeable</p>
<p>Pest Type: Flies, Mosquitoes, Moths</p>
<p>Model Number: WD-960 Electric Racket</p>
<p>Pest Control Type: Fly Swatter</p>
<p>Material: ABS Plastic</p>
<p>Function: Three-In-One Mosquito Bat And Mosquito Killer Lamp</p>
<p>Power: 5W (110-220V)</p>
<p>Battery: 500mAh Lithium Battery</p>
<p>Usage: Indoor,Outdoor, Home, Hotel</p>","0","2023-12-13 13:18:25","2024-01-10 13:05:19");
INSERT INTO products VALUES("328","Weidasi Mosquito Swatter (WD-960)","15698532","standard","C128","28","78","1","1","1","400","620","0","","","","","","","1","1702534232552swatt.jpg","","","","0","0","","","","<p>Weidasi WD 960 USB Mosquito Killing Bat</p>
<p>Applicable Area: &lt;20 Square Meters</p>
<p>Product: Electric Mosquito Swatter</p>
<p>Power Source: Electrical, Batteries</p>
<p>Charger: Rechargeable</p>
<p>Pest Type: Flies, Mosquitoes, Moths</p>
<p>Model Number: WD-960 Electric Racket</p>
<p>Pest Control Type: Fly Swatter</p>
<p>Material: ABS Plastic</p>
<p>Function: Three-In-One Mosquito Bat And Mosquito Killer Lamp</p>
<p>Power: 5W (110-220V)</p>
<p>Battery: 500mAh Lithium Battery</p>
<p>Usage: Indoor,Outdoor, Home, Hotel</p>","0","2023-12-13 13:18:25","2024-01-10 13:05:19");
INSERT INTO products VALUES("329","YAGE Mosquito Swatter (YG-777A)","97210384","standard","C128","29","78","1","1","1","360","550","0","","","","","","","1","1702534013510swatt.jpg","","","","0","0","","","","<p>Product Type: Insect Killer &amp; Repellents<br />Brand: Yage<br />Color: Blue<br />Type: Fly Swatter<br />Material: Plastic<br />Set Content: Set of 1<br />Sales Package: 1 Mosquito Killer Racket;1 Power Cord<br />Rechargeable battery: Yes<br />Led Light: 0.2 Watt<br />Battery Capacity: 400mAH<br />Charge Rated Voltage: AC 100-240V<br />Charge Rated Current: AC 0.04A<br />Number of Layers: 3 Net Layers<br />Full Charging Time: 10 Hours<br />Working Output Voltage: DC 2200V<br />Using Time: 10 Days (6 days with led light working)</p>","0","2023-12-13 13:18:25","2024-01-10 13:05:19");
INSERT INTO products VALUES("330","ZANNUO Water Bottle (600 ML)","30142276","standard","C128","20","91","1","1","1","280","420","0","","","","","","","1","1702468942557ZANNUO Water Battle (700 ML).jpg,1702536577984ZANNUO Water Battle (700 ML).jpg","","","","0","0","","","","","0","2023-12-13 13:18:25","2024-01-10 13:07:10");
INSERT INTO products VALUES("331","ZANNUO Water Bottle (700 ML)","78320821","standard","C128","20","91","1","1","1","300","450","0","","","","","","","1","1702468883931ZANNUO Water Battle (700 ML).jpg,1702536602148ZANNUO Water Battle (700 ML).jpg","","","","0","0","","","","","0","2023-12-13 13:18:25","2024-01-10 13:07:10");
INSERT INTO products VALUES("332","Havit KB271 USB Exquisite Keyboard with Bangla","36594775","standard","C128","","56","1","1","1","500","500","0","","","","","","","1","1703591055311k.jpg","","","","0","0","","","","","0","2023-12-18 18:05:18","2024-01-10 13:07:26");
INSERT INTO products VALUES("333","Intel 10th Gen Core i3-10100 Desktop PC","10573450","standard","C128","","55","1","1","1","32000","32000","0","","","","","","","1","1702901778689Intel 10th Gen Core i3-10100 Desktop PC.jpg","","","","","","","","","<p>Model: 10th Gen Desktop PC</p>
<p>Intel 10th Gen Core i3 10100 Processor</p>
<p>GIGABYTE H470M H 11th and 10th Gen Micro ATX Motherboard</p>
<p>Corsair Vengeance LPX 8GB 3200MHz DDR4 RAM</p>
<p>Team MP33 256GB M.2 PCIe SSD</p>
<p>Value-Top VT-M700 Mid Tower Micro ATX Casing</p>","0","2023-12-18 18:16:57","2024-01-10 13:01:32");
INSERT INTO products VALUES("334","HUAWEI MatePad SE WiFi 4GB RAM 128GB Storage 10.4-inch Tablet","03457829","standard","C128","","101","1","1","1","24500","24500","0","","","","","","","1","1703576434620HUAWEI MatePad SE WiFi 4GB RAM 128GB Storage 10.4-inch Tablet.jpg","","","","","","","","","<p>MPN: AGS5-W09</p>
<p>Model: MatePad SE</p>
<p>2K Eye Comfort HUAWEI FullView Display</p>
<p>Qualcomm Snapdragon 680 (6nm)</p>
<p>Surround Sound Tuned by Histen 8.0</p>
<p>5100 mAh Battery, Type-C</p>","0","2023-12-26 13:41:40","2024-01-10 13:07:10");
INSERT INTO products VALUES("335","Samsung Galaxy A03 Core Smartphone","81852001","standard","C128","","53","1","1","1","12300","12300","0","","","","","","","1","1703576848732Samsung Galaxy A03 Core Smartphone.jpg","","","","0","0","","","","<p>Model: Galaxy A03 Core</p>
<p>Display: 6.5@ 720 x 1600 (HD+)</p>
<p>Processor: Octa-core (1.6GHz, 1.2GHz)</p>
<p>Camera: 8MP Rear, 5MP Front</p>
<p>Features: 5000mAh Li-Ion Battery</p>","0","2023-12-26 13:48:18","2024-01-10 13:06:10");
INSERT INTO products VALUES("336","Xprinter Mini Thermal Direct Receipt POS Printer","96682041","standard","C128","","103","1","1","1","4500","4500","0","","","","","","","1","1703582652825Xprinter XP-58IIL Mini Thermal Direct Receipt POS Printer.jpg","","","","","","","","","<p>Model: XP-58IIL</p>
<p>Interface: USB</p>
<p>Paper width: 57.5&plusmn;0.5mm</p>
<p>Printing speed: 90 mm/s Max.</p>
<p>Support Linux &amp; windows system</p>","0","2023-12-26 15:24:49","2024-01-10 13:06:09");
INSERT INTO products VALUES("337","Sunlux XL-3206 2D Wired Barcode Scanner","46109238","standard","C128","","104","1","1","1","3000","3000","0","","","","","","","1","1703582957124Sunlux XL-3206 2D Wired Barcode Scanner.jpg","","","","","","","","","<p>Model: XL-3206</p>
<p>Decoder Type: 1D/2D</p>
<p>Image Size: 640 x 480 pixels</p>
<p>Resolution: 300000 Pixels</p>
<p>Drop Height: 1.5 Meters</p>","0","2023-12-26 15:29:50","2024-01-10 12:32:21");
INSERT INTO products VALUES("338","Zebra ZD230 Barcode Label Printer","63961249","standard","C128","","105","1","1","1","16500","16500","0","","","","","","","1","1703583234090Zebra ZD230 Barcode Label Printer.jpg","","","","","","","","","<p>Model: ZD230</p>
<p>300m maximum ribbon length</p>
<p>Resolution: 203 DPI (8 dots/mm)</p>
<p>Maximum Print Speed: 6 inches/second</p>
<p>Max. Print Width: 4 inches</p>","0","2023-12-26 15:35:27","2024-01-10 12:32:21");
INSERT INTO products VALUES("339","Rongta RT420F POS Cash Drawer","93225386","standard","C128","","106","1","1","1","6900","6900","0","","","","","","","1","1703583500631Rongta RT420F POS Cash Drawer.jpg","","","","","","","","","<p>Model: Rongta RT420F</p>
<p>Tray: 5 Bill &amp; 8 Coin Slots</p>
<p>Interface: RJ11, RJ12</p>
<p>Drawer: Microswitch C,NC or C,NO</p>
<p>Length: 183mm; Depth:59mm</p>","0","2023-12-26 15:41:00","2024-01-10 13:06:09");
INSERT INTO products VALUES("340","Vivo Y02A Smartphone (3/32GB)","46363809","standard","C128","","53","1","1","1","12000","12000","0","","","","","","","1","1703583813035Vivo Y02A Smartphone.jpg","","","","","","","","","<p>Model: Y02A</p>
<p>Display: 6.51@ HD+ Eye Protection Screen</p>
<p>Processor: Mediatek MT6765 Helio P35 (12nm)</p>
<p>Camera: Single 8MP on Rear, 5MP Front</p>
<p>Features: 5000mAh Battery</p>","0","2023-12-26 15:44:06","2024-01-10 13:06:10");
INSERT INTO products VALUES("341","Honor X5 Plus Smartphone","93319098","standard","C128","","53","1","1","1","14000","14000","0","","","","","","","1","1703585653631Honor X5 Plus Smartphone.jpg","","","","","","","","","<p>Model: Honor X5 Plus</p>
<p>Display: 6.56@ TFTLCD, 90Hz</p>
<p>Processor: Mediatek Helio G36 (12 nm)</p>
<p>Camera: Triple 50+2 MP on Rear, 5MP Selfie</p>
<p>Features: Side Fingerprint</p>","0","2023-12-26 16:14:54","2024-01-10 13:06:10");
INSERT INTO products VALUES("342","Rongta RP335 Thermal POS Printer","05143211","standard","C128","","103","1","1","1","6500","6500","0","","","","","","","1","1703587745897Rongta RP335 Thermal POS Printer.jpg","","","","","","","","","<p>Model: RP335</p>
<p>Print Resolution: 203dpi</p>
<p>UE-Version, Thermal Line Method</p>
<p>250mm/s high-speed printing</p>
<p>Connectivity: USB, LAN</p>","0","2023-12-26 16:49:51","2024-01-10 13:06:09");
INSERT INTO products VALUES("343","SPRT SP-POS891 POS Printer","28349919","standard","C128","","103","1","1","1","8500","8500","0","","","","","","","1","1703588102029SPRT SP-POS891 POS Printer.jpg","","","","","","","","","<p>Model: SP-POS891</p>
<p>Compact and wall mountable Structure</p>
<p>Versatile thermal receipt printer</p>
<p>Triple connection interface</p>
<p>Simple installation kit</p>","0","2023-12-26 16:56:01","2024-01-10 13:06:09");
INSERT INTO products VALUES("344","Rongta RT410 POS Cash Drawer","92128953","standard","C128","","106","1","1","1","7000","7000","0","","","","","","","1","1703588497347Rongta RT410 POS Cash Drawer.jpg","","","","","","","","","<p>Model: RT410</p>
<p>Interface: RJ11, RJ12,</p>
<p>Tray: 4 Note &amp; 5 Coin Slots</p>
<p>Drawer: Microswitch C, NC or C, NO</p>
<p>Length: 183mm; Depth:59mm</p>","0","2023-12-26 17:02:20","2024-01-10 13:06:09");
INSERT INTO products VALUES("345","Acoustic,BK-JSM","1","standard","C128","30","776","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:00");
INSERT INTO products VALUES("346","TGM   ,City-Ag-3","2","standard","C128","31","776","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:00");
INSERT INTO products VALUES("347","City AG-3B,City-AG-3B","3","standard","C128","32","776","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:00");
INSERT INTO products VALUES("348","City-Uk30-26,Deviser","4","standard","C128","33","776","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:00");
INSERT INTO products VALUES("349","9 volt,.","125","standard","C128","73","784","1","1","1","31.25","31.25","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:01");
INSERT INTO products VALUES("350","mini keyboard,.","6","standard","C128","34","777","1","1","1","191.67","191.67","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:00");
INSERT INTO products VALUES("351","9 Volt,","7","standard","C128","35","777","1","1","1","120","120","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:00");
INSERT INTO products VALUES("352","AC adaptor,PSA-230 / 9V","8","standard","C128","36","777","1","1","1","2,000.00","2,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:00");
INSERT INTO products VALUES("353","AC adaptor,AD-1GL 7.5V","9","standard","C128","37","777","1","1","1","600","600","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:00");
INSERT INTO products VALUES("354","AC adaptor,AD-A1215OLW(U)","10","standard","C128","37","777","1","1","1","1,150.00","1,150.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:00");
INSERT INTO products VALUES("355","AC adaptor,AD-E95100LG","11","standard","C128","37","777","1","1","1","591.07","591.07","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:00");
INSERT INTO products VALUES("356","AC adaptor,LAD-6 AC 9.5V","12","standard","C128","37","777","1","1","1","800","800","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:00");
INSERT INTO products VALUES("357","AC adaptor,LAD-6A New MDY","13","standard","C128","37","777","1","1","1","1,200.00","1,200.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:00");
INSERT INTO products VALUES("358",".,","2227","standard","C128","487","51","1","1","1","50","50","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:23");
INSERT INTO products VALUES("359","9 Volt,Anisha  ","17","standard","C128","39","777","1","1","1","133.33","133.33","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:00");
INSERT INTO products VALUES("360","9 Volt,Casio Adapter (STI)","18","standard","C128","39","777","1","1","1","100","100","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:00");
INSERT INTO products VALUES("361","9 Volt,City Normal","19","standard","C128","39","777","1","1","1","80","80","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:00");
INSERT INTO products VALUES("362","9V (AC Adapter),HKA-0960EC-230 (CITY)","20","standard","C128","39","777","1","1","1","800","800","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:00");
INSERT INTO products VALUES("363","9V (AC Adapter),T090060-2D1","21","standard","C128","39","777","1","1","1","800","800","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:00");
INSERT INTO products VALUES("364","Multiple ac/dc,NA-380S","22","standard","C128","39","777","1","1","1","100","100","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:00");
INSERT INTO products VALUES("365","Zoom,9V","23","standard","C128","39","777","1","1","1","250","250","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:00");
INSERT INTO products VALUES("366","9 Volt,Power Adapter-S.T.I","24","standard","C128","40","777","1","1","1","140","140","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:00");
INSERT INTO products VALUES("367",",PA.200C","25","standard","C128","41","777","1","1","1","500","500","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:00");
INSERT INTO products VALUES("368","S.T.I ,12V","26","standard","C128","41","777","1","1","1","500","500","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:00");
INSERT INTO products VALUES("369","Guitar Processor,AD-16E","27","standard","C128","42","777","1","1","1","1,094.03","1,094.03","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:00");
INSERT INTO products VALUES("370","S.T.I ,12 V ","28","standard","C128","42","777","1","1","1","400","400","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:00");
INSERT INTO products VALUES("371","S.T.I ,9V","29","standard","C128","42","777","1","1","1","350","350","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:00");
INSERT INTO products VALUES("372","Extra Tk,.","30","standard","C128","39","778","1","1","1","64.65","64.65","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:00");
INSERT INTO products VALUES("373","Indian  ,Brown (Labu)","31","standard","C128","43","779","1","1","1","800","800","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:00");
INSERT INTO products VALUES("374","Normal,.","2225","standard","C128","260","53","1","1","1","130","130","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:23");
INSERT INTO products VALUES("375","Wooden,.","2232","standard","C128","43","56","1","1","1","20","20","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:23");
INSERT INTO products VALUES("376","Normal,Large","74","standard","C128","57","782","1","1","1","650","650","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:00");
INSERT INTO products VALUES("377","Normal,Small","102","standard","C128","58","782","1","1","1","550","550","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:01");
INSERT INTO products VALUES("378","Acoustic  Guitar,.","37","standard","C128","39","780","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:00");
INSERT INTO products VALUES("379","mini,.","1717","standard","C128","361","879","1","1","1","2,000.00","2,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:17");
INSERT INTO products VALUES("380","city_normal,.","39","standard","C128","44","782","1","1","1","160","160","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:00");
INSERT INTO products VALUES("381","SBH,.","109","standard","C128","64","782","1","1","1","125","125","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:01");
INSERT INTO products VALUES("382","Keyboard,CBS-100 MDY","44","standard","C128","37","782","1","1","1","1,500.00","1,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:00");
INSERT INTO products VALUES("383","Acoustic,JSM  ","2134","standard","C128","471","928","1","1","1","3,500.00","3,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:22");
INSERT INTO products VALUES("384","Acoustic,RNG Normal","48","standard","C128","51","782","1","1","1","1,000.00","1,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:00");
INSERT INTO products VALUES("385","Acoustic,RNG-Good","49","standard","C128","51","782","1","1","1","1,350.00","1,350.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:00");
INSERT INTO products VALUES("386","Acoustic Hard Box,RNG   ","50","standard","C128","51","782","1","1","1","1,950.00","1,950.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:00");
INSERT INTO products VALUES("387","FINKS Box Soft city,FINKS Box Soft city","51","standard","C128","52","782","1","1","1","1,800.00","1,800.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:00");
INSERT INTO products VALUES("388","Soft Case,Finks_City","52","standard","C128","52","782","1","1","1","2,500.00","2,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:00");
INSERT INTO products VALUES("389","Elc Led,MDY Foam Normal","54","standard","C128","54","782","1","1","1","1,200.00","1,200.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:00");
INSERT INTO products VALUES("390","Acoustic,Travel Bag","55","standard","C128","55","782","1","1","1","165.56","165.56","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:00");
INSERT INTO products VALUES("391","Acoustic Guitar,Normal","56","standard","C128","55","782","1","1","1","180","180","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:00");
INSERT INTO products VALUES("392","Acoustic Guitar,Normal Foam","57","standard","C128","55","782","1","1","1","380","380","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:00");
INSERT INTO products VALUES("393","Acoustic Guitar,Normal Good","58","standard","C128","55","782","1","1","1","207","207","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:00");
INSERT INTO products VALUES("394","Cajon Bag,Normal","59","standard","C128","55","782","1","1","1","216","216","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:00");
INSERT INTO products VALUES("395","GIG BAG,ACUSTIC","60","standard","C128","55","782","1","1","1","900","900","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:00");
INSERT INTO products VALUES("396","Guitar_lele,.","61","standard","C128","55","782","1","1","1","150","150","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:00");
INSERT INTO products VALUES("397","Harmonium,Big","62","standard","C128","55","782","1","1","1","170","170","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:00");
INSERT INTO products VALUES("398","Harmonium,Small","63","standard","C128","55","782","1","1","1","170","170","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:00");
INSERT INTO products VALUES("399","Keyboard,.","1887","standard","C128","387","906","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:19");
INSERT INTO products VALUES("400","led  bag,city foam bag","65","standard","C128","55","782","1","1","1","950","950","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:00");
INSERT INTO products VALUES("401","led  bag,Foam","66","standard","C128","55","782","1","1","1","378.5","378.5","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:00");
INSERT INTO products VALUES("402","Mandolin,Normal","67","standard","C128","55","782","1","1","1","160","160","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:00");
INSERT INTO products VALUES("403","Tabla Baya,Normal","68","standard","C128","55","782","1","1","1","200","200","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:00");
INSERT INTO products VALUES("404","Travel Bag,Foam","69","standard","C128","55","782","1","1","1","370","370","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:00");
INSERT INTO products VALUES("405","Travel Bag,Normal  ","70","standard","C128","55","782","1","1","1","180","180","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:00");
INSERT INTO products VALUES("406","Ukulele,Foam","98","standard","C128","39","782","1","1","1","300","300","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:01");
INSERT INTO products VALUES("407","Ukulele,Normal","99","standard","C128","39","782","1","1","1","140","140","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:01");
INSERT INTO products VALUES("408","Ukulele,.","73","standard","C128","56","782","1","1","1","100","100","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:00");
INSERT INTO products VALUES("409","Acoustic,Baby","76","standard","C128","39","782","1","1","1","190","190","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:00");
INSERT INTO products VALUES("410","Acoustic  Guitar,CIty-Finks-Foam","77","standard","C128","39","782","1","1","1","350","350","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:00");
INSERT INTO products VALUES("411","Acoustic  Guitar,City-Foam","78","standard","C128","39","782","1","1","1","300","300","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:00");
INSERT INTO products VALUES("412","Acoustic Guitar,.","1268","standard","C128","148","837","1","1","1","79.55","79.55","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:12");
INSERT INTO products VALUES("413","Acoustic Guitar,Foam","80","standard","C128","39","782","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:00");
INSERT INTO products VALUES("414","Acoustic Guitar,Foam Black/Blue","81","standard","C128","39","782","1","1","1","1,100.00","1,100.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:00");
INSERT INTO products VALUES("415","Acoustic Guitar,Foam Good Quality","111","standard","C128","65","782","1","1","1","1,000.00","1,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:01");
INSERT INTO products VALUES("416","Acoustic Guitar,JK-Foam","83","standard","C128","39","782","1","1","1","400","400","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:00");
INSERT INTO products VALUES("417","Acoustic Guitar,Multi Pocket Foam","84","standard","C128","39","782","1","1","1","1,500.00","1,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:00");
INSERT INTO products VALUES("418","Acoustic Hard Box,.","85","standard","C128","39","782","1","1","1","2,500.00","2,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:00");
INSERT INTO products VALUES("419","Cajon Bag,Jahangir","86","standard","C128","39","782","1","1","1","210","210","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:00");
INSERT INTO products VALUES("420","Cajon Bag,Melody","87","standard","C128","39","782","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:00");
INSERT INTO products VALUES("421","Drum stick,Foam","88","standard","C128","39","782","1","1","1","150","150","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:00");
INSERT INTO products VALUES("422","Elc. Bass,Foam","89","standard","C128","39","782","1","1","1","377.5","377.5","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:00");
INSERT INTO products VALUES("423","Elc. lead,Foam","90","standard","C128","39","782","1","1","1","400","400","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:00");
INSERT INTO products VALUES("424","Flute,Big","91","standard","C128","39","782","1","1","1","344.29","344.29","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:00");
INSERT INTO products VALUES("425","Flute,Labu","92","standard","C128","39","782","1","1","1","90","90","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:00");
INSERT INTO products VALUES("426","Flute,Normal","93","standard","C128","39","782","1","1","1","88.57","88.57","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:00");
INSERT INTO products VALUES("427","Harmonium,Normal","94","standard","C128","39","782","1","1","1","81","81","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:00");
INSERT INTO products VALUES("428","Leather,Brown (JSM)","96","standard","C128","39","782","1","1","1","1,000.00","1,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:01");
INSERT INTO products VALUES("429","Processor Hard case,G5","97","standard","C128","39","782","1","1","1","3,200.00","3,200.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:01");
INSERT INTO products VALUES("430","Ukulele 6 String,Normal","100","standard","C128","39","782","1","1","1","135","135","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:01");
INSERT INTO products VALUES("431","Violin,.","101","standard","C128","39","782","1","1","1","1,500.00","1,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:44","2024-01-10 15:01:01");
INSERT INTO products VALUES("432","GUITAS,.","103","standard","C128","59","782","1","1","1","1,000.00","1,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:01");
INSERT INTO products VALUES("433","Acoustic,DGB 1680","106","standard","C128","62","782","1","1","1","2,200.00","2,200.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:01");
INSERT INTO products VALUES("434","Elc Led,EGB-1600","107","standard","C128","62","782","1","1","1","2,375.00","2,375.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:01");
INSERT INTO products VALUES("435","Electro Acostic,M. Biswas","112","standard","C128","66","783","1","1","1","8,500.00","8,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:01");
INSERT INTO products VALUES("436","Electro Acostic,M. Biswas 4 String","113","standard","C128","66","783","1","1","1","8,500.00","8,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:01");
INSERT INTO products VALUES("437","Electro Acostic,M. Biswas 5 String","114","standard","C128","66","783","1","1","1","9,000.00","9,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:01");
INSERT INTO products VALUES("438","Electro Acostic,M. Biswas 4 String- S.T.I","115","standard","C128","67","783","1","1","1","9,500.00","9,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:01");
INSERT INTO products VALUES("439",",.","116","standard","C128","68","784","1","1","1","30","30","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:01");
INSERT INTO products VALUES("440","Lithium 3V,CR 2032","117","standard","C128","69","784","1","1","1","35","35","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:01");
INSERT INTO products VALUES("441","60 Volt,.","119","standard","C128","39","784","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:01");
INSERT INTO products VALUES("442","AA 1.5V,.","126","standard","C128","74","784","1","1","1","11.09","11.09","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:01");
INSERT INTO products VALUES("443","Lithium 3V,.","123","standard","C128","23","784","1","1","1","50","50","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:01");
INSERT INTO products VALUES("444","Lithium 3V CR2025,","124","standard","C128","23","784","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:01");
INSERT INTO products VALUES("445","AAA,.","127","standard","C128","74","784","1","1","1","10","10","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:01");
INSERT INTO products VALUES("446","Lithium 3V,CR2032","128","standard","C128","75","784","1","1","1","20.65","20.65","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:01");
INSERT INTO products VALUES("447","Acoustic,EQ Cover","129","standard","C128","39","785","1","1","1","200","200","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:01");
INSERT INTO products VALUES("448","Dance Learning,Nacher Kotha","130","standard","C128","76","786","1","1","1","340","340","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:01");
INSERT INTO products VALUES("449","Dance Learning,World History of the Dance","131","standard","C128","76","786","1","1","1","255","255","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:01");
INSERT INTO products VALUES("450","learning,Jubilant Sea","132","standard","C128","77","786","1","1","1","66","66","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:01");
INSERT INTO products VALUES("451","Ashok Kumar paul,Spanish guitar learning method","133","standard","C128","78","786","1","1","1","1,000.00","1,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:01");
INSERT INTO products VALUES("452","Band Music ,BD Band Music Revolution","134","standard","C128","78","786","1","1","1","213","213","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:01");
INSERT INTO products VALUES("453","Lalon,Lalon sai o uttorsuri","135","standard","C128","78","786","1","1","1","213","213","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:01");
INSERT INTO products VALUES("454","Lalon,Lalon Vasa onusondhan 1","136","standard","C128","78","786","1","1","1","289","289","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:01");
INSERT INTO products VALUES("455","Lalon,Lalon Vasa onusondhan 2","137","standard","C128","78","786","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:01");
INSERT INTO products VALUES("456","learning,Drums","138","standard","C128","78","786","1","1","1","400","400","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:01");
INSERT INTO products VALUES("457","learning,Flute","139","standard","C128","78","786","1","1","1","194","194","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:01");
INSERT INTO products VALUES("458","learning,Guitar","140","standard","C128","78","786","1","1","1","968","968","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:01");
INSERT INTO products VALUES("459","learning,Lyric/Shorolipi","141","standard","C128","78","786","1","1","1","240","240","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:01");
INSERT INTO products VALUES("460","learning,Others","142","standard","C128","78","786","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:01");
INSERT INTO products VALUES("461","learning,Shahed_G_Hand book_Part 1","143","standard","C128","78","786","1","1","1","250","250","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:01");
INSERT INTO products VALUES("462","learning,Violin","144","standard","C128","78","786","1","1","1","263.5","263.5","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:01");
INSERT INTO products VALUES("463","Manna de,Jiboner jolsa ghore","145","standard","C128","78","786","1","1","1","630","630","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:01");
INSERT INTO products VALUES("464","Music Learning,Gane Gane Bangladesh","146","standard","C128","78","786","1","1","1","510","510","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:01");
INSERT INTO products VALUES("465","Music Learning,Songit Kosh","147","standard","C128","78","786","1","1","1","762","762","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:01");
INSERT INTO products VALUES("466","Music Learning,Songit kotha","148","standard","C128","78","786","1","1","1","350","350","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:01");
INSERT INTO products VALUES("467","Nazrul,Musical translation of Nazrul songs","149","standard","C128","78","786","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:01");
INSERT INTO products VALUES("468","Rabindra Nath,Git Bitan","150","standard","C128","78","786","1","1","1","425","425","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:01");
INSERT INTO products VALUES("469","Rabindra Nath,Gitanjali","151","standard","C128","78","786","1","1","1","91","91","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:01");
INSERT INTO products VALUES("470","Rabindra Nath,Rabindra Voirobi Porikroma","152","standard","C128","78","786","1","1","1","176","176","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:01");
INSERT INTO products VALUES("471","Song Lerning,.","153","standard","C128","78","786","1","1","1","207.26","207.26","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:01");
INSERT INTO products VALUES("472","Song Lerning,Sadhin Bangla Betar Kendrer Gan","154","standard","C128","78","786","1","1","1","255","255","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:01");
INSERT INTO products VALUES("473","Song Lerning,Sargam","155","standard","C128","78","786","1","1","1","140.49","140.49","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:01");
INSERT INTO products VALUES("474","Touhidul alam sonet,Guitar er o a ka kha","156","standard","C128","78","786","1","1","1","200","200","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:01");
INSERT INTO products VALUES("475","Kichu _Dure_ Nodi,.","157","standard","C128","39","786","1","1","1","225","225","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:01");
INSERT INTO products VALUES("476","Literature,Ferdous Hasan Rana","158","standard","C128","39","786","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:01");
INSERT INTO products VALUES("477","Literature,Nipa Bristite Vijechilo","159","standard","C128","39","786","1","1","1","80","80","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:01");
INSERT INTO products VALUES("478","Musical Books,Robindro Sogit Kolo","160","standard","C128","79","786","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:01");
INSERT INTO products VALUES("479","Audio Auxilary,Jian yu","161","standard","C128","80","787","1","1","1","30","30","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:01");
INSERT INTO products VALUES("480","Guitar,PC","162","standard","C128","81","787","1","1","1","850","850","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:01");
INSERT INTO products VALUES("481","Microphone,Mono Normal","163","standard","C128","81","787","1","1","1","400","400","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:01");
INSERT INTO products VALUES("482","Microphone,Patching","164","standard","C128","81","787","1","1","1","1,100.00","1,100.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:01");
INSERT INTO products VALUES("483","Jack Cable Loose,1 Meter","165","standard","C128","39","787","1","1","1","65.41","65.41","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:01");
INSERT INTO products VALUES("484","Normal With Jack,.","166","standard","C128","39","787","1","1","1","970","970","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:01");
INSERT INTO products VALUES("485","XLR custome made,50 Ft","167","standard","C128","39","787","1","1","1","1,800.00","1,800.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:01");
INSERT INTO products VALUES("486","EQ,.","168","standard","C128","82","788","1","1","1","3,800.00","3,800.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:01");
INSERT INTO products VALUES("487","elc. acs,.","170","standard","C128","81","788","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:01");
INSERT INTO products VALUES("488","GB,.","172","standard","C128","83","788","1","1","1","500","500","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:02");
INSERT INTO products VALUES("489","Anisha,.","2159","standard","C128","39","930","1","1","1","130","130","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:22");
INSERT INTO products VALUES("490","with seat,.","1533","standard","C128","126","853","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:15");
INSERT INTO products VALUES("491","Adjustable,.","2178","standard","C128","244","936","1","1","1","1,092.00","1,092.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:23");
INSERT INTO products VALUES("492","Sargor,.","178","standard","C128","39","788","1","1","1","2,600.00","2,600.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:02");
INSERT INTO products VALUES("493","Sargor,Mini","179","standard","C128","39","788","1","1","1","1,500.00","1,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:02");
INSERT INTO products VALUES("494","Sargor,Seat","180","standard","C128","39","788","1","1","1","2,800.00","2,800.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:02");
INSERT INTO products VALUES("495","Anisha,Seat","181","standard","C128","86","788","1","1","1","2,600.00","2,600.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:02");
INSERT INTO products VALUES("496","CITY,Seat","183","standard","C128","88","788","1","1","1","3,200.00","3,200.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:02");
INSERT INTO products VALUES("497","Special,.","184","standard","C128","89","788","1","1","1","3,500.00","3,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:02");
INSERT INTO products VALUES("498","CC Camera,CC Camera","185","standard","C128","90","789","1","1","1","2,300.00","2,300.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:02");
INSERT INTO products VALUES("499","Best Quality,3D","186","standard","C128","91","790","1","1","1","50","50","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:02");
INSERT INTO products VALUES("500","Best Quality,HD","187","standard","C128","91","790","1","1","1","60.82","60.82","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:02");
INSERT INTO products VALUES("501","Normal,HD","189","standard","C128","92","790","1","1","1","140","140","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:02");
INSERT INTO products VALUES("502","Album,Learn this love","190","standard","C128","77","790","1","1","1","66","66","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:02");
INSERT INTO products VALUES("503","Chord,Ashok Pal ","191","standard","C128","77","790","1","1","1","190","190","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:02");
INSERT INTO products VALUES("504","Concert,.","192","standard","C128","77","790","1","1","1","60","60","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:02");
INSERT INTO products VALUES("505","learning,.","193","standard","C128","77","790","1","1","1","114.58","114.58","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:02");
INSERT INTO products VALUES("506","learning,Ashok Pal_Part-1","194","standard","C128","77","790","1","1","1","119","119","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:02");
INSERT INTO products VALUES("507","learning,Ashok_Pal_Part-2","195","standard","C128","77","790","1","1","1","110","110","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:02");
INSERT INTO products VALUES("508","Abar Album,.","196","standard","C128","55","790","1","1","1","140","140","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:02");
INSERT INTO products VALUES("509","Antivirus,.","197","standard","C128","93","790","1","1","1","850","850","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:02");
INSERT INTO products VALUES("510","Nylon String,vc 104 Rds ","199","standard","C128","94","792","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:02");
INSERT INTO products VALUES("511","Classical Nylon,A106","200","standard","C128","95","793","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:02");
INSERT INTO products VALUES("512","PA system,.","201","standard","C128","81","794","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:02");
INSERT INTO products VALUES("513","Desktop,pentium dual core 6th generation","202","standard","C128","4","795","1","1","1","12,000.00","12,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:02");
INSERT INTO products VALUES("514","USB 2 MIDI,.","211","standard","C128","39","796","1","1","1","650","650","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:02");
INSERT INTO products VALUES("515","Guitar Mini,Normal","204","standard","C128","39","796","1","1","1","23.23","23.23","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:02");
INSERT INTO products VALUES("516","Guitar to Speaker,.","205","standard","C128","39","796","1","1","1","21.24","21.24","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:02");
INSERT INTO products VALUES("517","Guitar to Speaker,Mono Normal","206","standard","C128","39","796","1","1","1","20","20","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:02");
INSERT INTO products VALUES("518","Guitar to Speaker,Sterio Normal","207","standard","C128","39","796","1","1","1","20","20","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:02");
INSERT INTO products VALUES("519","Head Phone,Mono Normal","208","standard","C128","39","796","1","1","1","18.11","18.11","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:02");
INSERT INTO products VALUES("520","Head Phone,Sterio Good Quality","209","standard","C128","39","796","1","1","1","96.83","96.83","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:02");
INSERT INTO products VALUES("521","Head Phone,Sterio Normal","210","standard","C128","39","796","1","1","1","25","25","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:02");
INSERT INTO products VALUES("522","Medium,PST 5 ","212","standard","C128","97","797","1","1","1","6,200.00","6,200.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:02");
INSERT INTO products VALUES("523","Common,.","213","standard","C128","39","798","1","1","1","230","230","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:02");
INSERT INTO products VALUES("524","Piano,P-45B","214","standard","C128","41","799","1","1","1","60,000.00","60,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:02");
INSERT INTO products VALUES("525","Good Quality,.","2192","standard","C128","39","937","1","1","1","4,800.00","4,800.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:23");
INSERT INTO products VALUES("526","Good Quality_Fret,.","218","standard","C128","43","801","1","1","1","10,500.00","10,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:02");
INSERT INTO products VALUES("527","SET,LABU SET","219","standard","C128","39","802","1","1","1","100","100","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:02");
INSERT INTO products VALUES("528","Normal,22 Inch","220","standard","C128","98","803","1","1","1","1,000.00","1,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:02");
INSERT INTO products VALUES("529","7 set,.","221","standard","C128","99","804","1","1","1","26,000.00","26,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:02");
INSERT INTO products VALUES("530","School Drum,.","222","standard","C128","39","804","1","1","1","6,000.00","6,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:02");
INSERT INTO products VALUES("531","Acoustic,8 pcs","223","standard","C128","100","804","1","1","1","2,800.00","2,800.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:02");
INSERT INTO products VALUES("532","Acoustic,7 pcs","224","standard","C128","41","804","1","1","1","30,000.00","30,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:02");
INSERT INTO products VALUES("533","Acoustic,.","2061","standard","C128","379","928","1","1","1","4,133.33","4,133.33","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:21");
INSERT INTO products VALUES("534","Normal,5A","259","standard","C128","41","805","1","1","1","303.33","303.33","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:03");
INSERT INTO products VALUES("535","With Gripper,5A","261","standard","C128","41","805","1","1","1","378.75","378.75","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:03");
INSERT INTO products VALUES("536","7A,Normal","231","standard","C128","105","805","1","1","1","150","150","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:02");
INSERT INTO products VALUES("537","Normal,5B ","260","standard","C128","41","805","1","1","1","250","250","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:03");
INSERT INTO products VALUES("538","PAD STICK,.","230","standard","C128","104","805","1","1","1","500","500","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:02");
INSERT INTO products VALUES("539","Both side,.","232","standard","C128","39","805","1","1","1","300","300","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:02");
INSERT INTO products VALUES("540","Fiber ,.","233","standard","C128","39","805","1","1","1","750","750","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:02");
INSERT INTO products VALUES("541","Normal,One Pair","234","standard","C128","39","805","1","1","1","37.08","37.08","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:02");
INSERT INTO products VALUES("542","Special,One Pair","235","standard","C128","39","805","1","1","1","45","45","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:02");
INSERT INTO products VALUES("543","5 A,.","237","standard","C128","107","805","1","1","1","120","120","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:02");
INSERT INTO products VALUES("544","7A,Anisha","238","standard","C128","107","805","1","1","1","150","150","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:02");
INSERT INTO products VALUES("545","PLAY,BEAT- STI,Maple 5A- With Gripper","239","standard","C128","108","805","1","1","1","250","250","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:02");
INSERT INTO products VALUES("546","PLAY,BEAT- STI,Maple 7A- With Gripper","240","standard","C128","108","805","1","1","1","250","250","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:02");
INSERT INTO products VALUES("547","Premier England-STI,Premier - 5B WithGripper","241","standard","C128","109","805","1","1","1","250","250","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:45","2024-01-10 15:01:02");
INSERT INTO products VALUES("548","AMERICAN HICKROY,5A","242","standard","C128","110","805","1","1","1","850","850","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:02");
INSERT INTO products VALUES("549","AMERICAN HICKROY,7A","243","standard","C128","110","805","1","1","1","450","450","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:02");
INSERT INTO products VALUES("550","American Maple,5A","244","standard","C128","110","805","1","1","1","500","500","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:02");
INSERT INTO products VALUES("551","American Maple,5B","245","standard","C128","110","805","1","1","1","400","400","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:02");
INSERT INTO products VALUES("552","American Maple,7A","246","standard","C128","110","805","1","1","1","400","400","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:02");
INSERT INTO products VALUES("553","Normal,Hickory 707","247","standard","C128","110","805","1","1","1","900","900","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:02");
INSERT INTO products VALUES("554","Normal,Hickory-2B","248","standard","C128","110","805","1","1","1","900","900","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:02");
INSERT INTO products VALUES("555","Normal,Hickory-5A","249","standard","C128","110","805","1","1","1","900","900","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("556","TXR,7AN","250","standard","C128","110","805","1","1","1","1,050.00","1,050.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("557","Normal,STI ","1173","standard","C128","252","835","1","1","1","599.68","599.68","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:11");
INSERT INTO products VALUES("558","With Gripper,STI ","252","standard","C128","111","805","1","1","1","330","330","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("559","Maple,7AN","253","standard","C128","112","805","1","1","1","178.21","178.21","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("560","Brush,5A","254","standard","C128","113","805","1","1","1","600","600","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("561","Normal,4A","255","standard","C128","114","805","1","1","1","200","200","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("562","7A,.","257","standard","C128","116","805","1","1","1","280","280","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("563","7A,Nova","258","standard","C128","116","805","1","1","1","400","400","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("564","Sunglass,.","262","standard","C128","39","806","1","1","1","1,600.00","1,600.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("565","Good Quality,ES-Q3","263","standard","C128","117","807","1","1","1","315","315","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("566","Good Quality,ES900i","264","standard","C128","117","807","1","1","1","475","475","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("567","Good Quality,Tour","265","standard","C128","118","807","1","1","1","675","675","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("568","Mobile Phone,HF06","266","standard","C128","119","807","1","1","1","350","350","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("569","Mobile Phone,HS-M220","267","standard","C128","120","807","1","1","1","800","800","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("570","Mobile Phone,HS-M250","268","standard","C128","120","807","1","1","1","900","900","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("571","Good Quality,E58P","269","standard","C128","121","807","1","1","1","265","265","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("572","Good Quality,HV-E86P","270","standard","C128","121","807","1","1","1","195","195","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("573","Wired  ,Hi-Res Audio","271","standard","C128","122","807","1","1","1","290","290","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("574","Bluetooth,RB-S-25","272","standard","C128","123","807","1","1","1","650","650","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("575","Bluetooth,RB-S17","273","standard","C128","123","807","1","1","1","1,400.00","1,400.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("576","Bluetooth,S8","274","standard","C128","123","807","1","1","1","1,475.00","1,475.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("577","Wired  ,RM-711","275","standard","C128","123","807","1","1","1","230","230","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("578","Wired  ,VL-610D","276","standard","C128","123","807","1","1","1","215","215","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("579","Wired Music Headset,RM-501","277","standard","C128","123","807","1","1","1","170","170","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("580","Wired Music Headset,RM-512","278","standard","C128","123","807","1","1","1","218.75","218.75","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("581","Wired  ,IC-935","279","standard","C128","4","807","1","1","1","75","75","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("582","Wired  ,.","280","standard","C128","124","807","1","1","1","140","140","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("583","FishMan,.","281","standard","C128","125","808","1","1","1","2,500.00","2,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("584","4 Band,S.T.I","282","standard","C128","39","808","1","1","1","700","700","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("585","5 Band,PS-500","283","standard","C128","39","808","1","1","1","1,000.00","1,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("586","5 Band,S.T.I","284","standard","C128","39","808","1","1","1","900","900","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("587","C#_TUNE,.","286","standard","C128","43","810","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("588","Steal Good Quality,E 10","329","standard","C128","43","812","1","1","1","516.67","516.67","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("589","Wishtle,Feadog golden D","341","standard","C128","43","812","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("590","Microphone,Foam","289","standard","C128","39","810","1","1","1","50","50","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("591","Recorder,.","291","standard","C128","126","812","1","1","1","250","250","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("592","Bamboo,Ar Flute","292","standard","C128","43","812","1","1","1","30.85","30.85","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("593","Bamboo Ar,A#13.5","293","standard","C128","43","812","1","1","1","60","60","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("594","Bamboo Ar,A#6 ","294","standard","C128","43","812","1","1","1","120","120","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("595","Bamboo Ar,D# 9 1/2","295","standard","C128","43","812","1","1","1","60","60","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("596","Bamboo Ar,D9","346","standard","C128","127","812","1","1","1","80","80","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("597","Bamboo Ar,E 10","297","standard","C128","43","812","1","1","1","60","60","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("598","Bamboo Ar,F# 11 1/2","298","standard","C128","43","812","1","1","1","60","60","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("599","Bamboo Ar,F11","299","standard","C128","43","812","1","1","1","60","60","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("600","Bamboo Ar,G 12 ","300","standard","C128","43","812","1","1","1","60","60","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("601","Bamboo Ar,G#12.5","301","standard","C128","43","812","1","1","1","60","60","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("602","Bamboo Ar Pora,B7","302","standard","C128","43","812","1","1","1","25","25","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("603","Bamboo Ar Pora,C#8.5","303","standard","C128","43","812","1","1","1","25","25","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("604","Bamboo Ar Pora,C8","304","standard","C128","43","812","1","1","1","25","25","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("605","Bamboo Ar Pora,D9","305","standard","C128","43","812","1","1","1","25","25","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("606","Bamboo Ar Pora,E10","306","standard","C128","43","812","1","1","1","25","25","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("607","Bamboo Ar Pora,F# 11 1/2","307","standard","C128","43","812","1","1","1","25","25","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("608","Bamboo Ar Pora,F11","308","standard","C128","43","812","1","1","1","25","25","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("609","Bamboo Ar Pora,G 12 ","309","standard","C128","43","812","1","1","1","25","25","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("610","Bamboo Good Quality ,.","310","standard","C128","43","812","1","1","1","260","260","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("611","Bamboo Good Quality ,G5","371","standard","C128","39","812","1","1","1","750","750","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:04");
INSERT INTO products VALUES("612","C_# TUNE,.","312","standard","C128","43","812","1","1","1","80","80","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("613","C_8 TUNE,.","313","standard","C128","43","812","1","1","1","80","80","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("614","Design,Bamboo design","314","standard","C128","43","812","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("615","Mukh   ,.","315","standard","C128","43","812","1","1","1","34","34","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("616","Mukh   ,Tuned Whistle","316","standard","C128","43","812","1","1","1","70","70","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("617","Recorder,Normal","317","standard","C128","43","812","1","1","1","600","600","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("618","Silver Flute bass,A# ","318","standard","C128","43","812","1","1","1","600","600","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("619","Silver Flute bass,B","319","standard","C128","43","812","1","1","1","550","550","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("620","Silver Flute bass,black D","320","standard","C128","43","812","1","1","1","500","500","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("621","Silver Flute bass,black E","321","standard","C128","43","812","1","1","1","500","500","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("622","Silver Flute bass,G ","322","standard","C128","43","812","1","1","1","700","700","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("623","Steal Good Quality,A.6","323","standard","C128","43","812","1","1","1","1,000.00","1,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("624","Steal Good Quality,C Natural  Medium","324","standard","C128","43","812","1","1","1","900","900","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("625","Steal Good Quality,C# 8 1/2","325","standard","C128","43","812","1","1","1","850","850","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("626","Steal Good Quality,C8","326","standard","C128","43","812","1","1","1","800","800","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("627","Steal Good Quality,D# 9 1/2","327","standard","C128","43","812","1","1","1","600","600","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("628","Steal Good Quality,D9","328","standard","C128","43","812","1","1","1","725","725","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("629","Steal Good Quality,F11","330","standard","C128","43","812","1","1","1","550","550","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("630","Steal Good Quality,G 12 ","331","standard","C128","43","812","1","1","1","1,200.00","1,200.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("631","Steal Good Quality,G# 5 1/2","332","standard","C128","43","812","1","1","1","850","850","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("632","Steal Good Quality,G#12.5","333","standard","C128","43","812","1","1","1","1,200.00","1,200.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("633","Steal Good Quality,G12","334","standard","C128","43","812","1","1","1","550","550","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("634","Steal Good Quality,G5","335","standard","C128","43","812","1","1","1","850","850","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("635","Tuned Bamboo flute,.","336","standard","C128","43","812","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("636","Wishtle,C8","337","standard","C128","43","812","1","1","1","1,450.00","1,450.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("637","Wishtle,D9","338","standard","C128","43","812","1","1","1","1,450.00","1,450.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("638","Wishtle,Feadog black D","339","standard","C128","43","812","1","1","1","1,100.00","1,100.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("639","Wishtle,Feadog C","340","standard","C128","43","812","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("640","Wishtle,Generation EB","342","standard","C128","43","812","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("641","Bamboo Ar,A 6","343","standard","C128","127","812","1","1","1","80","80","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("642","Bamboo Ar,C8","344","standard","C128","127","812","1","1","1","80","80","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("643","Bamboo Ar,D# 2 1/2","345","standard","C128","127","812","1","1","1","400","400","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("644","Bamboo Ar,E10","347","standard","C128","127","812","1","1","1","80","80","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:03");
INSERT INTO products VALUES("645","Bamboo Ar,F# 4 1/2","348","standard","C128","127","812","1","1","1","300","300","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:04");
INSERT INTO products VALUES("646","Bamboo Ar,G 5","349","standard","C128","127","812","1","1","1","300","300","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:04");
INSERT INTO products VALUES("647","Bamboo Ar,G# 5 1/2","350","standard","C128","127","812","1","1","1","100","100","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:04");
INSERT INTO products VALUES("648","Bamboo,Large","351","standard","C128","39","812","1","1","1","10","10","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:04");
INSERT INTO products VALUES("649","Bamboo,Small","352","standard","C128","39","812","1","1","1","43.64","43.64","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:04");
INSERT INTO products VALUES("650","Bamboo Good Quality ,A# 6 1/2","353","standard","C128","39","812","1","1","1","650","650","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:04");
INSERT INTO products VALUES("651","Bamboo Good Quality ,A6 ","354","standard","C128","39","812","1","1","1","636.42","636.42","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:04");
INSERT INTO products VALUES("652","Bamboo Good Quality ,B7","355","standard","C128","39","812","1","1","1","550","550","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:04");
INSERT INTO products VALUES("653","Bamboo Good Quality ,C# 1 1/2","356","standard","C128","39","812","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:04");
INSERT INTO products VALUES("654","Bamboo Good Quality ,C# 8 1/2","357","standard","C128","39","812","1","1","1","400","400","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:04");
INSERT INTO products VALUES("655","Bamboo Good Quality ,C8","358","standard","C128","39","812","1","1","1","400","400","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:04");
INSERT INTO products VALUES("656","Bamboo Good Quality ,D# 2 1/2","359","standard","C128","39","812","1","1","1","400","400","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:04");
INSERT INTO products VALUES("657","Bamboo Good Quality ,D# 9 1/2","360","standard","C128","39","812","1","1","1","300","300","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:04");
INSERT INTO products VALUES("658","Bamboo Good Quality ,D9","361","standard","C128","39","812","1","1","1","400","400","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:04");
INSERT INTO products VALUES("659","Bamboo Good Quality ,E10","362","standard","C128","39","812","1","1","1","383.33","383.33","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:04");
INSERT INTO products VALUES("660","Bamboo Good Quality ,E3","363","standard","C128","39","812","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:04");
INSERT INTO products VALUES("661","Bamboo Good Quality ,F# 11 1/2","364","standard","C128","39","812","1","1","1","300","300","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:04");
INSERT INTO products VALUES("662","Bamboo Good Quality ,F# 4 1/2","365","standard","C128","39","812","1","1","1","725","725","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:04");
INSERT INTO products VALUES("663","Bamboo Good Quality ,F11","366","standard","C128","39","812","1","1","1","300","300","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:04");
INSERT INTO products VALUES("664","Bamboo Good Quality ,F4","367","standard","C128","39","812","1","1","1","700","700","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:04");
INSERT INTO products VALUES("665","Bamboo Good Quality ,G# 5 1/2","368","standard","C128","39","812","1","1","1","1,000.00","1,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:46","2024-01-10 15:01:04");
INSERT INTO products VALUES("666","Bamboo Good Quality ,G#12.5","369","standard","C128","39","812","1","1","1","300","300","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:04");
INSERT INTO products VALUES("667","Bamboo Good Quality ,G12","370","standard","C128","39","812","1","1","1","200","200","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:04");
INSERT INTO products VALUES("668","Bamboo Good Quality ,Large","372","standard","C128","39","812","1","1","1","1,500.00","1,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:04");
INSERT INTO products VALUES("669","Bamboo Good Quality ,Small","373","standard","C128","39","812","1","1","1","150","150","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:04");
INSERT INTO products VALUES("670","Bamboo Mohon,Good Quality","374","standard","C128","39","812","1","1","1","242","242","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:04");
INSERT INTO products VALUES("671","Bamboo Mohon,Normal","375","standard","C128","39","812","1","1","1","72.86","72.86","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:04");
INSERT INTO products VALUES("672","Mukh Good Quality,C#","376","standard","C128","39","812","1","1","1","400","400","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:04");
INSERT INTO products VALUES("673","Mukh Good Quality,C8","377","standard","C128","39","812","1","1","1","500","500","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:04");
INSERT INTO products VALUES("674","Mukh Good Quality,D# 9 1/2","378","standard","C128","39","812","1","1","1","425","425","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:04");
INSERT INTO products VALUES("675","Mukh Good Quality,D9","379","standard","C128","39","812","1","1","1","408.33","408.33","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:04");
INSERT INTO products VALUES("676","Mukh Good Quality,E10","380","standard","C128","39","812","1","1","1","387.5","387.5","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:04");
INSERT INTO products VALUES("677","Mukh Good Quality,F# 11 1/2","381","standard","C128","39","812","1","1","1","450","450","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:04");
INSERT INTO products VALUES("678","Mukh Good Quality,G12","382","standard","C128","39","812","1","1","1","500","500","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:04");
INSERT INTO products VALUES("679","Mukh Good Quality,Medium G","383","standard","C128","39","812","1","1","1","80","80","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:04");
INSERT INTO products VALUES("680","Mukh Good Quality,Small C","384","standard","C128","39","812","1","1","1","300","300","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:04");
INSERT INTO products VALUES("681","Mukh Good Quality,Small D","385","standard","C128","39","812","1","1","1","225","225","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:04");
INSERT INTO products VALUES("682","Mukh Good Quality,Small E","386","standard","C128","39","812","1","1","1","300","300","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:04");
INSERT INTO products VALUES("683","Silver ,Big","387","standard","C128","39","812","1","1","1","8,000.00","8,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:04");
INSERT INTO products VALUES("684","Silver ,Small","388","standard","C128","39","812","1","1","1","4,000.00","4,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:04");
INSERT INTO products VALUES("685","Translucent ,YRS-20","389","standard","C128","41","812","1","1","1","800","800","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:04");
INSERT INTO products VALUES("686","Translucent ,YRS-23","390","standard","C128","41","812","1","1","1","800","800","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:04");
INSERT INTO products VALUES("687","Drums and Keyboard,P.S.P-2","392","standard","C128","128","814","1","1","1","800","800","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:04");
INSERT INTO products VALUES("688","Fixed,.","395","standard","C128","130","817","1","1","1","22,300.00","22,300.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:04");
INSERT INTO products VALUES("689","Decoration,.","396","standard","C128","131","817","1","1","1","20,493.00","20,493.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:04");
INSERT INTO products VALUES("690","Wrist Watch,.","397","standard","C128","39","818","1","1","1","120","120","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:04");
INSERT INTO products VALUES("691","ABAN-Ukulele Center,ABAN- A-40","398","standard","C128","132","819","1","1","1","4,575.00","4,575.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:04");
INSERT INTO products VALUES("692","ABIBA,City AHS-3910","399","standard","C128","44","819","1","1","1","4,400.00","4,400.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:04");
INSERT INTO products VALUES("693","Adam Smith,RNG-AC-AT70B","400","standard","C128","44","819","1","1","1","6,800.00","6,800.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:04");
INSERT INTO products VALUES("694","Adam Smith_120,.","401","standard","C128","44","819","1","1","1","7,200.00","7,200.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:04");
INSERT INTO products VALUES("695","Adam Smith_160,.","402","standard","C128","44","819","1","1","1","7,200.00","7,200.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:04");
INSERT INTO products VALUES("696","adam Smith_570,.","403","standard","C128","44","819","1","1","1","8,400.00","8,400.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:04");
INSERT INTO products VALUES("697","Albino,.","404","standard","C128","44","819","1","1","1","6,200.00","6,200.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:04");
INSERT INTO products VALUES("698","Aria,JSM-6219-Blue","406","standard","C128","44","819","1","1","1","5,000.00","5,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:04");
INSERT INTO products VALUES("699","AS Melody_Travel,AG-36 ","407","standard","C128","44","819","1","1","1","3,500.00","3,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:04");
INSERT INTO products VALUES("700","Ashai,GB","408","standard","C128","44","819","1","1","1","4,500.00","4,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:04");
INSERT INTO products VALUES("701","AXE,Anisha-M-AG-48C","409","standard","C128","44","819","1","1","1","4,500.00","4,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:04");
INSERT INTO products VALUES("702","AXE,BLK","410","standard","C128","44","819","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:04");
INSERT INTO products VALUES("703","AXE,Blue","673","standard","C128","147","819","1","1","1","5,100.00","5,100.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:06");
INSERT INTO products VALUES("704","AXE,City New _AG-51","412","standard","C128","44","819","1","1","1","5,165.98","5,165.98","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:04");
INSERT INTO products VALUES("705","AXE,City Normal","413","standard","C128","44","819","1","1","1","5,400.00","5,400.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:04");
INSERT INTO products VALUES("706","AXE,CITY Wooden","414","standard","C128","44","819","1","1","1","5,000.00","5,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:04");
INSERT INTO products VALUES("707","AXE,GB","415","standard","C128","44","819","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:04");
INSERT INTO products VALUES("708","AXE,m/s ","416","standard","C128","44","819","1","1","1","4,620.00","4,620.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:04");
INSERT INTO products VALUES("709","Bull Fighter,City D 4118 NG","417","standard","C128","44","819","1","1","1","8,000.00","8,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:04");
INSERT INTO products VALUES("710","Caeser _City,X-401-C-N","418","standard","C128","44","819","1","1","1","7,500.00","7,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:04");
INSERT INTO products VALUES("711","Caeser Anisha,Aanish_X 4002C","419","standard","C128","44","819","1","1","1","4,150.00","4,150.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:04");
INSERT INTO products VALUES("712","Caravan Music,.","420","standard","C128","44","819","1","1","1","5,600.00","5,600.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:04");
INSERT INTO products VALUES("713","Caraya_Anisha,Anisha F 641C BK","421","standard","C128","44","819","1","1","1","5,500.00","5,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:04");
INSERT INTO products VALUES("714","CHAD_CITY_TRAVEL,.","422","standard","C128","44","819","1","1","1","7,000.00","7,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:04");
INSERT INTO products VALUES("715","Chard,City M-EA19","423","standard","C128","44","819","1","1","1","5,500.00","5,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:04");
INSERT INTO products VALUES("716","Chard,City Travel GS MINI-2","424","standard","C128","44","819","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:04");
INSERT INTO products VALUES("717","Chard,City-C25","425","standard","C128","44","819","1","1","1","6,000.00","6,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:04");
INSERT INTO products VALUES("718","Chard,CITY-EA19","426","standard","C128","44","819","1","1","1","5,500.00","5,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:04");
INSERT INTO products VALUES("719","Chard,CITY-F4090C","427","standard","C128","44","819","1","1","1","6,500.00","6,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:04");
INSERT INTO products VALUES("720","Chard,JSM-C-19","428","standard","C128","44","819","1","1","1","4,200.00","4,200.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:04");
INSERT INTO products VALUES("721","Chard,M-4090c","429","standard","C128","44","819","1","1","1","9,800.00","9,800.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:04");
INSERT INTO products VALUES("722","Chard,Travel City M-32 G","430","standard","C128","44","819","1","1","1","6,200.00","6,200.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:04");
INSERT INTO products VALUES("723","Classical Guitar,Yamaha-c-40 mdy","431","standard","C128","44","819","1","1","1","10,000.00","10,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:04");
INSERT INTO products VALUES("724","CMC,CITY C-210B","432","standard","C128","44","819","1","1","1","4,600.00","4,600.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:04");
INSERT INTO products VALUES("725","Crafter,City-JA-J312C","433","standard","C128","44","819","1","1","1","5,500.00","5,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:04");
INSERT INTO products VALUES("726","Crafter,JA-J312C","434","standard","C128","44","819","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:04");
INSERT INTO products VALUES("727","Custom,CITY ","690","standard","C128","147","819","1","1","1","6,000.00","6,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:07");
INSERT INTO products VALUES("728","Custom,City-CS-30","436","standard","C128","44","819","1","1","1","3,833.33","3,833.33","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:04");
INSERT INTO products VALUES("729","Custom,GB","437","standard","C128","44","819","1","1","1","5,200.00","5,200.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:04");
INSERT INTO products VALUES("730","Custom,GB-C-130A","438","standard","C128","44","819","1","1","1","4,000.00","4,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:04");
INSERT INTO products VALUES("731","Custom,JSM","439","standard","C128","44","819","1","1","1","5,500.00","5,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:04");
INSERT INTO products VALUES("732","Dadarwood,403-CITY","702","standard","C128","147","819","1","1","1","14,000.00","14,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:07");
INSERT INTO products VALUES("733","Deviser,City -L 720A","441","standard","C128","44","819","1","1","1","7,300.00","7,300.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:04");
INSERT INTO products VALUES("734","Deviser,City New-4040","442","standard","C128","44","819","1","1","1","4,779.91","4,779.91","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:04");
INSERT INTO products VALUES("735","Deviser,City-625","443","standard","C128","44","819","1","1","1","6,900.00","6,900.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:04");
INSERT INTO products VALUES("736","Deviser,City-HS-4040","444","standard","C128","44","819","1","1","1","5,620.00","5,620.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:04");
INSERT INTO products VALUES("737","Deviser,CITY-L-620","445","standard","C128","44","819","1","1","1","6,186.25","6,186.25","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:04");
INSERT INTO products VALUES("738","Deviser,CITY-LS-120-40","446","standard","C128","44","819","1","1","1","6,300.00","6,300.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:04");
INSERT INTO products VALUES("739","Deviser,City-LS-570","447","standard","C128","44","819","1","1","1","6,800.00","6,800.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:04");
INSERT INTO products VALUES("740","Deviser,City-LS-570 New ","448","standard","C128","44","819","1","1","1","7,500.00","7,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:04");
INSERT INTO products VALUES("741","Deviser,City_G-4040","449","standard","C128","44","819","1","1","1","4,060.00","4,060.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:04");
INSERT INTO products VALUES("742","Deviser,GB-JA-03G","450","standard","C128","44","819","1","1","1","4,000.00","4,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:04");
INSERT INTO products VALUES("743","Deviser,GS-560","451","standard","C128","44","819","1","1","1","6,500.00","6,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:05");
INSERT INTO products VALUES("744","Deviser,GS-720A","452","standard","C128","44","819","1","1","1","5,500.00","5,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:05");
INSERT INTO products VALUES("745","Deviser,JA 4040 N","453","standard","C128","44","819","1","1","1","4,300.00","4,300.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:05");
INSERT INTO products VALUES("746","Deviser,JSM-Sound Hole Block","454","standard","C128","44","819","1","1","1","7,000.00","7,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:05");
INSERT INTO products VALUES("747","Deviser,L-MINI-05","455","standard","C128","44","819","1","1","1","6,000.00","6,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:05");
INSERT INTO products VALUES("748","Deviser,L2-720A","456","standard","C128","44","819","1","1","1","5,700.00","5,700.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:05");
INSERT INTO products VALUES("749","Deviser,LS-570-40 MDY","457","standard","C128","44","819","1","1","1","8,200.00","8,200.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:05");
INSERT INTO products VALUES("750","Deviser,MDY - LS-540-40","458","standard","C128","44","819","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:05");
INSERT INTO products VALUES("751","Deviser L 620 JSM,.","459","standard","C128","44","819","1","1","1","6,200.00","6,200.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:05");
INSERT INTO products VALUES("752","DO ,JSM ","710","standard","C128","147","819","1","1","1","8,500.00","8,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:07");
INSERT INTO products VALUES("753","DO ,JSM-DO-D-41-1","461","standard","C128","44","819","1","1","1","7,000.00","7,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:05");
INSERT INTO products VALUES("754","Doris,CITY-A-300C","462","standard","C128","44","819","1","1","1","7,000.00","7,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:05");
INSERT INTO products VALUES("755","Doris,MI-A-300 C","463","standard","C128","44","819","1","1","1","7,000.00","7,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:05");
INSERT INTO products VALUES("756","Doris,MI-MS-50-FC","464","standard","C128","44","819","1","1","1","16,500.00","16,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:05");
INSERT INTO products VALUES("757","Doris,RNG-A-300C","465","standard","C128","44","819","1","1","1","7,200.00","7,200.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:05");
INSERT INTO products VALUES("758","DOTCH,CIty-100","466","standard","C128","44","819","1","1","1","13,000.00","13,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:05");
INSERT INTO products VALUES("759","DOTCH,City-2000","467","standard","C128","44","819","1","1","1","16,000.00","16,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:05");
INSERT INTO products VALUES("760","DOTCH,CITY-MD-200C","468","standard","C128","44","819","1","1","1","10,500.00","10,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:05");
INSERT INTO products VALUES("761","DOTCH,CITY-MD-250C","469","standard","C128","44","819","1","1","1","10,000.00","10,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:05");
INSERT INTO products VALUES("762","DOTCH,City-S250C","470","standard","C128","44","819","1","1","1","14,000.00","14,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:05");
INSERT INTO products VALUES("763","DOTCH,JSM-DOTCH","471","standard","C128","44","819","1","1","1","7,000.00","7,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:05");
INSERT INTO products VALUES("764","Dream Catcher,RNG-M-4010","472","standard","C128","44","819","1","1","1","3,800.00","3,800.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:05");
INSERT INTO products VALUES("765","Dream Maker,.","713","standard","C128","147","819","1","1","1","6,200.00","6,200.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:07");
INSERT INTO products VALUES("766","Epiphone,City-DR-100","474","standard","C128","44","819","1","1","1","7,000.00","7,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:05");
INSERT INTO products VALUES("767","Fender,City-EA-110","475","standard","C128","44","819","1","1","1","6,000.00","6,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:05");
INSERT INTO products VALUES("768","Fender,JSM Fender","476","standard","C128","44","819","1","1","1","8,000.00","8,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:05");
INSERT INTO products VALUES("769","Fender,Jsm-CD-60-CE","477","standard","C128","44","819","1","1","1","8,000.00","8,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:05");
INSERT INTO products VALUES("770","Fender,JSM-FD-130","478","standard","C128","44","819","1","1","1","5,666.67","5,666.67","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:05");
INSERT INTO products VALUES("771","Fender,RNG-PM-6","479","standard","C128","44","819","1","1","1","5,500.00","5,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:05");
INSERT INTO products VALUES("772","Fiberovasion,.","480","standard","C128","44","819","1","1","1","8,500.00","8,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:05");
INSERT INTO products VALUES("773","Finks,FK-317 CITY","481","standard","C128","44","819","1","1","1","6,000.00","6,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:05");
INSERT INTO products VALUES("774","Finks,FK-415 CITY","482","standard","C128","44","819","1","1","1","7,500.00","7,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:05");
INSERT INTO products VALUES("775","Finks,FK-418 CITY","483","standard","C128","44","819","1","1","1","7,500.00","7,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:05");
INSERT INTO products VALUES("776","Finks,FK-700 CITY","484","standard","C128","44","819","1","1","1","9,000.00","9,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:05");
INSERT INTO products VALUES("777","Finks,FK-730 CITY","485","standard","C128","44","819","1","1","1","10,700.00","10,700.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:05");
INSERT INTO products VALUES("778","Finks,FK-811C CITY","486","standard","C128","44","819","1","1","1","6,000.00","6,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:05");
INSERT INTO products VALUES("779","Finks_city_fk 423,.","487","standard","C128","44","819","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:05");
INSERT INTO products VALUES("780","Finks_fk423_city,","488","standard","C128","44","819","1","1","1","6,500.00","6,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:05");
INSERT INTO products VALUES("781","FINLAY,GB-KM-1100","489","standard","C128","44","819","1","1","1","5,500.00","5,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:05");
INSERT INTO products VALUES("782","Firefly_Anisha,Anisha FE-40CBK","490","standard","C128","44","819","1","1","1","5,500.00","5,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:05");
INSERT INTO products VALUES("783","Five,City MC-307","491","standard","C128","44","819","1","1","1","16,000.00","16,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:05");
INSERT INTO products VALUES("784","Five,City-MC-108","492","standard","C128","44","819","1","1","1","7,500.00","7,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:05");
INSERT INTO products VALUES("785","Five,City-MC-109","493","standard","C128","44","819","1","1","1","8,200.00","8,200.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:05");
INSERT INTO products VALUES("786","Flamango,City-210","494","standard","C128","44","819","1","1","1","4,500.00","4,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:05");
INSERT INTO products VALUES("787","Floda,GB-P4025","495","standard","C128","44","819","1","1","1","4,000.00","4,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:05");
INSERT INTO products VALUES("788","Gavial,Anisha-G-310 FG","496","standard","C128","44","819","1","1","1","9,000.00","9,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:05");
INSERT INTO products VALUES("789","Givson,.","864","standard","C128","158","819","1","1","1","4,600.00","4,600.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:08");
INSERT INTO products VALUES("790","Glashutte,CITY ","498","standard","C128","44","819","1","1","1","8,000.00","8,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:05");
INSERT INTO products VALUES("791","Golden,City Normal","499","standard","C128","44","819","1","1","1","6,250.00","6,250.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:05");
INSERT INTO products VALUES("792","Golden,City-Jumbo","500","standard","C128","44","819","1","1","1","6,500.00","6,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:05");
INSERT INTO products VALUES("793","Grace,City GE-58","501","standard","C128","44","819","1","1","1","4,400.00","4,400.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:05");
INSERT INTO products VALUES("794","Greag,City-GE 58","502","standard","C128","44","819","1","1","1","4,300.00","4,300.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:05");
INSERT INTO products VALUES("795","Guiliani GAG,MDY-S1-MATT","503","standard","C128","44","819","1","1","1","5,000.00","5,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:05");
INSERT INTO products VALUES("796","Gusion,GA-02 Cm","504","standard","C128","44","819","1","1","1","9,000.00","9,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:05");
INSERT INTO products VALUES("797","Horn Grind,JSM","505","standard","C128","44","819","1","1","1","7,000.00","7,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:05");
INSERT INTO products VALUES("798","Ibanez,AEL 10-E","743","standard","C128","147","819","1","1","1","9,700.00","9,700.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:07");
INSERT INTO products VALUES("799","Italia,City-TG-160","507","standard","C128","44","819","1","1","1","5,000.00","5,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:05");
INSERT INTO products VALUES("800","JA 4040 TBS,","508","standard","C128","44","819","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:05");
INSERT INTO products VALUES("801","Jack Daniels,GB","509","standard","C128","44","819","1","1","1","4,000.00","4,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:05");
INSERT INTO products VALUES("802","Joker,GB","510","standard","C128","44","819","1","1","1","3,800.00","3,800.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:05");
INSERT INTO products VALUES("803","Joy,JSM-FA-40 N","511","standard","C128","44","819","1","1","1","5,000.00","5,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:05");
INSERT INTO products VALUES("804","KAXIDIA,City FH 6178","512","standard","C128","44","819","1","1","1","7,000.00","7,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:05");
INSERT INTO products VALUES("805","KEYSEN,K-C11-40","513","standard","C128","44","819","1","1","1","8,500.00","8,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:05");
INSERT INTO products VALUES("806","KImmy,.","514","standard","C128","44","819","1","1","1","8,500.00","8,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:05");
INSERT INTO products VALUES("807","Kramer,City KM-200","515","standard","C128","44","819","1","1","1","4,400.00","4,400.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:47","2024-01-10 15:01:05");
INSERT INTO products VALUES("808","Kulun ,Travel Guitar_KD-136 NT","516","standard","C128","44","819","1","1","1","5,500.00","5,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:05");
INSERT INTO products VALUES("809","LAG_CITY,.","517","standard","C128","44","819","1","1","1","8,250.00","8,250.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:05");
INSERT INTO products VALUES("810","Listen,L-2-720A JSM","518","standard","C128","44","819","1","1","1","5,500.00","5,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:05");
INSERT INTO products VALUES("811","Listen,LA1-JSM","519","standard","C128","44","819","1","1","1","6,000.00","6,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:05");
INSERT INTO products VALUES("812","Listen,LG-312 JSM","520","standard","C128","44","819","1","1","1","7,500.00","7,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:05");
INSERT INTO products VALUES("813","Local Normal,.","521","standard","C128","44","819","1","1","1","1,650.00","1,650.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:05");
INSERT INTO products VALUES("814","Luna,JSM-213","522","standard","C128","44","819","1","1","1","7,500.00","7,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:05");
INSERT INTO products VALUES("815","Mantek_City,.","523","standard","C128","44","819","1","1","1","7,500.00","7,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:05");
INSERT INTO products VALUES("816","Mataulun,City-MD-60 C LT-BK","524","standard","C128","44","819","1","1","1","8,000.00","8,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:05");
INSERT INTO products VALUES("817","mentreel,.","525","standard","C128","44","819","1","1","1","8,500.00","8,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:05");
INSERT INTO products VALUES("818","MVERIK_CITY,.","526","standard","C128","44","819","1","1","1","5,800.00","5,800.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:05");
INSERT INTO products VALUES("819","Nylon String,Anisha","762","standard","C128","147","819","1","1","1","7,000.00","7,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:07");
INSERT INTO products VALUES("820","Nylon String,Normal","528","standard","C128","44","819","1","1","1","5,300.00","5,300.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:05");
INSERT INTO products VALUES("821","Nylon String,Zealux","764","standard","C128","147","819","1","1","1","8,000.00","8,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:07");
INSERT INTO products VALUES("822","Palmer,.","530","standard","C128","44","819","1","1","1","7,000.00","7,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:05");
INSERT INTO products VALUES("823","QTE,BK","531","standard","C128","44","819","1","1","1","4,600.00","4,600.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:05");
INSERT INTO products VALUES("824","QTE,BLUE","532","standard","C128","44","819","1","1","1","4,600.00","4,600.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:05");
INSERT INTO products VALUES("825","QTE,PL","533","standard","C128","44","819","1","1","1","4,600.00","4,600.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:05");
INSERT INTO products VALUES("826","RC Stromm,.","534","standard","C128","44","819","1","1","1","6,000.00","6,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:05");
INSERT INTO products VALUES("827","Rockjam,A6-3 Natural","535","standard","C128","44","819","1","1","1","5,500.00","5,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:05");
INSERT INTO products VALUES("828","Rockjam,JSM ","536","standard","C128","44","819","1","1","1","5,000.00","5,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:05");
INSERT INTO products VALUES("829","ROCKSTAR,RK 4050","537","standard","C128","44","819","1","1","1","5,180.00","5,180.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:05");
INSERT INTO products VALUES("830","Ruison_Anisha,Anisha RA 1L","538","standard","C128","44","819","1","1","1","4,600.00","4,600.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:05");
INSERT INTO products VALUES("831","Saijer,City GAH-60","539","standard","C128","44","819","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:05");
INSERT INTO products VALUES("832","Sandy,JSM-S-403","540","standard","C128","44","819","1","1","1","4,800.00","4,800.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:05");
INSERT INTO products VALUES("833","SANDY,S403-NA","541","standard","C128","44","819","1","1","1","6,000.00","6,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:05");
INSERT INTO products VALUES("834","Sayt,Travel Guitar_S-29B City","542","standard","C128","44","819","1","1","1","6,000.00","6,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:05");
INSERT INTO products VALUES("835","Seiger,CIty-FN.10.N","543","standard","C128","44","819","1","1","1","6,400.00","6,400.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:05");
INSERT INTO products VALUES("836","Seiger,City-GAH-20BK","544","standard","C128","44","819","1","1","1","4,480.00","4,480.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:05");
INSERT INTO products VALUES("837","Silvertone,.","545","standard","C128","44","819","1","1","1","7,000.00","7,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:05");
INSERT INTO products VALUES("838","Sonata,Anisha-M-F-601","546","standard","C128","44","819","1","1","1","5,500.00","5,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:05");
INSERT INTO products VALUES("839","SQOE ,L2-720 A (JSM)","547","standard","C128","44","819","1","1","1","6,000.00","6,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:05");
INSERT INTO products VALUES("840","SQOE City,SQ N FG City","548","standard","C128","44","819","1","1","1","8,000.00","8,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:05");
INSERT INTO products VALUES("841","SQOE City,SQ-39B City","549","standard","C128","44","819","1","1","1","8,000.00","8,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:05");
INSERT INTO products VALUES("842","SQOE OCTAVE,SQ-K","550","standard","C128","44","819","1","1","1","10,200.00","10,200.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:05");
INSERT INTO products VALUES("843","SQOE-SQ-J,JSM-SQ-J","551","standard","C128","44","819","1","1","1","8,550.00","8,550.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:05");
INSERT INTO products VALUES("844","Square,Yd41-186","552","standard","C128","44","819","1","1","1","10,000.00","10,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:05");
INSERT INTO products VALUES("845","Sunrise,Black","789","standard","C128","147","819","1","1","1","4,200.00","4,200.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:08");
INSERT INTO products VALUES("846","Sunrise,Red","790","standard","C128","147","819","1","1","1","4,200.00","4,200.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:08");
INSERT INTO products VALUES("847","SX,City-40","555","standard","C128","44","819","1","1","1","3,800.00","3,800.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:05");
INSERT INTO products VALUES("848","SX,jsm ","556","standard","C128","44","819","1","1","1","5,500.00","5,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:05");
INSERT INTO products VALUES("849","SX,MD-160/VS","557","standard","C128","44","819","1","1","1","6,900.00","6,900.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:05");
INSERT INTO products VALUES("850","TAGIMA,TW 29","558","standard","C128","44","819","1","1","1","6,000.00","6,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:05");
INSERT INTO products VALUES("851","Takamyne,.","559","standard","C128","44","819","1","1","1","19,000.00","19,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:05");
INSERT INTO products VALUES("852","Takamyne,City-ED-340","560","standard","C128","44","819","1","1","1","8,000.00","8,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:05");
INSERT INTO products VALUES("853","Takamyne,City-ED-340-C","561","standard","C128","44","819","1","1","1","8,000.00","8,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:05");
INSERT INTO products VALUES("854","TAKLA- Anisha,M-320","562","standard","C128","44","819","1","1","1","9,000.00","9,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:05");
INSERT INTO products VALUES("855","TAKLA-Black Mat-Anisha,M-390","563","standard","C128","44","819","1","1","1","6,000.00","6,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:05");
INSERT INTO products VALUES("856","Tanglewood,TL  FCH ","564","standard","C128","44","819","1","1","1","6,000.00","6,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:05");
INSERT INTO products VALUES("857","Tanglewood,TL F CH (RED)","565","standard","C128","44","819","1","1","1","8,645.00","8,645.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:05");
INSERT INTO products VALUES("858","Tayste,402","566","standard","C128","44","819","1","1","1","5,800.00","5,800.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:05");
INSERT INTO products VALUES("859","Tayste,city-ts-225A","567","standard","C128","44","819","1","1","1","7,000.00","7,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:05");
INSERT INTO products VALUES("860","Tayste,CIty-TS-430 BU","568","standard","C128","44","819","1","1","1","7,000.00","7,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:05");
INSERT INTO products VALUES("861","Tayste,JSM-T-401 BK","569","standard","C128","44","819","1","1","1","4,940.00","4,940.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:06");
INSERT INTO products VALUES("862","Tayste,JSM-TS-J35-A","570","standard","C128","44","819","1","1","1","6,500.00","6,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:06");
INSERT INTO products VALUES("863","Tayste,TS-D11-OM","571","standard","C128","44","819","1","1","1","8,500.00","8,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:06");
INSERT INTO products VALUES("864","TGM   ,CITY ","572","standard","C128","44","819","1","1","1","5,511.69","5,511.69","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:06");
INSERT INTO products VALUES("865","TGM   ,City-AG-3B","573","standard","C128","44","819","1","1","1","4,495.24","4,495.24","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:06");
INSERT INTO products VALUES("866","TGM   ,GB ","574","standard","C128","44","819","1","1","1","3,800.00","3,800.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:06");
INSERT INTO products VALUES("867","TGM   ,Jakir","575","standard","C128","44","819","1","1","1","4,000.00","4,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:06");
INSERT INTO products VALUES("868","TGM   ,JSM-SH-2022 Black","576","standard","C128","44","819","1","1","1","4,200.00","4,200.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:06");
INSERT INTO products VALUES("869","TGM   ,JSM-SM 2022","577","standard","C128","44","819","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:06");
INSERT INTO products VALUES("870","URO,City-FL-8","578","standard","C128","44","819","1","1","1","5,000.00","5,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:06");
INSERT INTO products VALUES("871","Valencia,Classical","579","standard","C128","44","819","1","1","1","6,180.00","6,180.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:06");
INSERT INTO products VALUES("872","Vivid,JA-121C NA","580","standard","C128","44","819","1","1","1","5,000.00","5,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:06");
INSERT INTO products VALUES("873","Washbun,.","823","standard","C128","147","819","1","1","1","9,500.00","9,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:08");
INSERT INTO products VALUES("874","Washbun,CITY ","582","standard","C128","44","819","1","1","1","8,500.00","8,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:06");
INSERT INTO products VALUES("875","Washbun,VWF 10 S","583","standard","C128","44","819","1","1","1","13,500.00","13,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:06");
INSERT INTO products VALUES("876","X-WOOD,.","584","standard","C128","44","819","1","1","1","6,500.00","6,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:06");
INSERT INTO products VALUES("877","Yamaha,C-40","585","standard","C128","44","819","1","1","1","9,000.00","9,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:06");
INSERT INTO products VALUES("878","Yamaha,CITY F-310","832","standard","C128","147","819","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:08");
INSERT INTO products VALUES("879","Yamaha,City-6500","587","standard","C128","44","819","1","1","1","4,400.00","4,400.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:06");
INSERT INTO products VALUES("880","Yamaha,City-720","588","standard","C128","44","819","1","1","1","4,000.00","4,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:06");
INSERT INTO products VALUES("881","Yamaha,City-740","589","standard","C128","44","819","1","1","1","4,000.00","4,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:06");
INSERT INTO products VALUES("882","Yamaha,City-FG.700C","590","standard","C128","44","819","1","1","1","4,700.00","4,700.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:06");
INSERT INTO products VALUES("883","Yamaha,F-310 JSM","591","standard","C128","44","819","1","1","1","7,000.00","7,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:06");
INSERT INTO products VALUES("884","Yamaha,F-6000 JSM","592","standard","C128","44","819","1","1","1","8,000.00","8,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:06");
INSERT INTO products VALUES("885","Yamaha,F_310","593","standard","C128","44","819","1","1","1","9,000.00","9,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:06");
INSERT INTO products VALUES("886","Yamaha,FGX BLUE","594","standard","C128","44","819","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:06");
INSERT INTO products VALUES("887","Yamaha,FGX JAKIR","595","standard","C128","44","819","1","1","1","5,000.00","5,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:06");
INSERT INTO products VALUES("888","Yamaha,GB","596","standard","C128","44","819","1","1","1","5,800.00","5,800.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:06");
INSERT INTO products VALUES("889","Yamaha,JSM F3000","597","standard","C128","44","819","1","1","1","5,500.00","5,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:06");
INSERT INTO products VALUES("890","Yemaha,CM-2","846","standard","C128","147","819","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:08");
INSERT INTO products VALUES("891","Zealux,black","849","standard","C128","147","819","1","1","1","5,200.00","5,200.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:08");
INSERT INTO products VALUES("892","Zealux,Lefty","851","standard","C128","147","819","1","1","1","5,500.00","5,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:08");
INSERT INTO products VALUES("893","Zealux,Tavel-zd-836","601","standard","C128","44","819","1","1","1","6,000.00","6,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:06");
INSERT INTO products VALUES("894","Zuodanny,CITY ","602","standard","C128","44","819","1","1","1","8,500.00","8,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:06");
INSERT INTO products VALUES("895","Zuodanny,City Plain","603","standard","C128","44","819","1","1","1","5,500.00","5,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:06");
INSERT INTO products VALUES("896","Zuodanny,City Travel","604","standard","C128","44","819","1","1","1","4,500.00","4,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:06");
INSERT INTO products VALUES("897","Enya,UBS-1","605","standard","C128","133","819","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:06");
INSERT INTO products VALUES("898","Electro Acostic,As AXE AG-48T","606","standard","C128","134","819","1","1","1","4,400.00","4,400.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:06");
INSERT INTO products VALUES("899","Elc. Bass,.","852","standard","C128","148","819","1","1","1","16,000.00","16,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:08");
INSERT INTO products VALUES("900","Acoustic  Guitar,MDY- ","608","standard","C128","136","819","1","1","1","4,400.00","4,400.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:06");
INSERT INTO products VALUES("901","City_Normal,AXE -AG-50","609","standard","C128","136","819","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:06");
INSERT INTO products VALUES("902","City_Normal,AXE-AG-51","610","standard","C128","136","819","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:06");
INSERT INTO products VALUES("903","Ukulele center,AG-48C","611","standard","C128","136","819","1","1","1","4,400.00","4,400.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:06");
INSERT INTO products VALUES("904","Godson,.","613","standard","C128","138","819","1","1","1","2,800.00","2,800.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:06");
INSERT INTO products VALUES("905","Jielisi,Wooden   ","614","standard","C128","138","819","1","1","1","3,000.00","3,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:06");
INSERT INTO products VALUES("906","Novelty,wooden   ","615","standard","C128","138","819","1","1","1","3,000.00","3,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:06");
INSERT INTO products VALUES("907","Deviser,L-310 City","617","standard","C128","140","819","1","1","1","6,500.00","6,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:06");
INSERT INTO products VALUES("908","GRAPE,C 40 N","618","standard","C128","140","819","1","1","1","5,500.00","5,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:06");
INSERT INTO products VALUES("909","Nihil ,CG-36-SB UC","619","standard","C128","140","819","1","1","1","4,400.00","4,400.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:06");
INSERT INTO products VALUES("910","Texas ,City-CG20-17A-NAT TEX","620","standard","C128","140","819","1","1","1","9,500.00","9,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:06");
INSERT INTO products VALUES("911","Yamaha,C-80","621","standard","C128","140","819","1","1","1","9,000.00","9,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:06");
INSERT INTO products VALUES("912","Yamaha,CS-40","622","standard","C128","140","819","1","1","1","10,800.00","10,800.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:06");
INSERT INTO products VALUES("913","Yamaha,FC3945 JSM","623","standard","C128","140","819","1","1","1","7,000.00","7,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:06");
INSERT INTO products VALUES("914","Acoustic,8419","624","standard","C128","141","819","1","1","1","5,500.00","5,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:06");
INSERT INTO products VALUES("915","Electro Acostic,8419","625","standard","C128","141","819","1","1","1","6,500.00","6,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:06");
INSERT INTO products VALUES("916","Acoustic,City-L720A","626","standard","C128","142","819","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:06");
INSERT INTO products VALUES("917","Acoustic,City-LS-570 New ","627","standard","C128","142","819","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:06");
INSERT INTO products VALUES("918","Acoustic,JSM-620","628","standard","C128","142","819","1","1","1","6,200.00","6,200.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:06");
INSERT INTO products VALUES("919","Elc. Bass 4 string,.","1341","standard","C128","231","837","1","1","1","400","400","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:13");
INSERT INTO products VALUES("920","jsm  L 620,","630","standard","C128","142","819","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:06");
INSERT INTO products VALUES("921","Acoustic,Deviser -L-770A-City","631","standard","C128","143","819","1","1","1","6,700.00","6,700.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:06");
INSERT INTO products VALUES("922","Electro Acostic EQ,EQ-GB","633","standard","C128","144","819","1","1","1","5,300.00","5,300.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:06");
INSERT INTO products VALUES("923","Elc. lead,Deviser-E-G3Semi Floyed City","634","standard","C128","145","819","1","1","1","9,500.00","9,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:06");
INSERT INTO products VALUES("924","Acoustic,DM-34 T","635","standard","C128","51","819","1","1","1","7,000.00","7,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:06");
INSERT INTO products VALUES("925","Travel Guitar,DM-382","636","standard","C128","51","819","1","1","1","3,000.00","3,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:06");
INSERT INTO products VALUES("926",",LTD LESPOL","637","standard","C128","146","819","1","1","1","12,000.00","12,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:06");
INSERT INTO products VALUES("927","Ashbury,.","638","standard","C128","146","819","1","1","1","8,500.00","8,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:06");
INSERT INTO products VALUES("928","Ashton,.","639","standard","C128","146","819","1","1","1","9,000.00","9,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:06");
INSERT INTO products VALUES("929","Azalea,.","640","standard","C128","146","819","1","1","1","10,700.00","10,700.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:06");
INSERT INTO products VALUES("930","B.C Rich,Warbeast","641","standard","C128","146","819","1","1","1","27,500.00","27,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:06");
INSERT INTO products VALUES("931","Deviser,Floyd Rose (JSM)","642","standard","C128","146","819","1","1","1","10,000.00","10,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:06");
INSERT INTO products VALUES("932","Dream Maker,Semi Floyed Jsm","643","standard","C128","146","819","1","1","1","10,000.00","10,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:06");
INSERT INTO products VALUES("933","Fender,.","644","standard","C128","146","819","1","1","1","15,500.00","15,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:48","2024-01-10 15:01:06");
INSERT INTO products VALUES("934","Fender,Stratocaster","645","standard","C128","146","819","1","1","1","16,000.00","16,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:06");
INSERT INTO products VALUES("935","Fernandez,.","646","standard","C128","146","819","1","1","1","20,000.00","20,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:06");
INSERT INTO products VALUES("936","Gibson,Les Pol","647","standard","C128","146","819","1","1","1","25,000.00","25,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:06");
INSERT INTO products VALUES("937","GUSON-,Semi Floyed -Anisha","648","standard","C128","146","819","1","1","1","10,000.00","10,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:06");
INSERT INTO products VALUES("938","Ibanez,CITY-150 DR","649","standard","C128","146","819","1","1","1","16,000.00","16,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:06");
INSERT INTO products VALUES("939","Ibanez,CITY-170","650","standard","C128","146","819","1","1","1","18,000.00","18,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:06");
INSERT INTO products VALUES("940","Ibanez,jsm-170","651","standard","C128","146","819","1","1","1","13,000.00","13,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:06");
INSERT INTO products VALUES("941","Ibanez,JSM-N-427","652","standard","C128","146","819","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:06");
INSERT INTO products VALUES("942","Ibanez GRG 170 DXB,.","653","standard","C128","146","819","1","1","1","20,000.00","20,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:06");
INSERT INTO products VALUES("943","Ibanez Semi Floyed,City-GRG 270","654","standard","C128","146","819","1","1","1","18,500.00","18,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:06");
INSERT INTO products VALUES("944","Ibanez Semi Floyed,City-GRG 470","655","standard","C128","146","819","1","1","1","18,500.00","18,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:06");
INSERT INTO products VALUES("945","Ibenez,Yellow","656","standard","C128","146","819","1","1","1","9,500.00","9,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:06");
INSERT INTO products VALUES("946","Jackson JS 12 Dinky,.","657","standard","C128","146","819","1","1","1","25,000.00","25,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:06");
INSERT INTO products VALUES("947","JSM,Semi Floyed Jsm","658","standard","C128","146","819","1","1","1","9,000.00","9,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:06");
INSERT INTO products VALUES("948","LTD,Les Pol JSM","659","standard","C128","146","819","1","1","1","14,000.00","14,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:06");
INSERT INTO products VALUES("949","SEIB 760-NA JSM,SQOE-JSM","660","standard","C128","146","819","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:06");
INSERT INTO products VALUES("950","SQOE-SEIB 760-NA JSM,SQOE-JSM","661","standard","C128","146","819","1","1","1","18,000.00","18,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:06");
INSERT INTO products VALUES("951","SQOE-SQ-Jsm,Est -1883","662","standard","C128","146","819","1","1","1","12,000.00","12,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:06");
INSERT INTO products VALUES("952","Acoustic__RNG,AC-01_RNG","663","standard","C128","147","819","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:06");
INSERT INTO products VALUES("953","Adam Smith,RNG-EQ-AT70B","664","standard","C128","147","819","1","1","1","7,800.00","7,800.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:06");
INSERT INTO products VALUES("954","Alonso,CITY A.S-3910","665","standard","C128","147","819","1","1","1","5,800.00","5,800.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:06");
INSERT INTO products VALUES("955","Aria,JSM-6219 BK","667","standard","C128","147","819","1","1","1","6,000.00","6,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:06");
INSERT INTO products VALUES("956","AS Melody,AS SIGNATURE","668","standard","C128","147","819","1","1","1","3,201.41","3,201.41","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:06");
INSERT INTO products VALUES("957","AS Melody,Melody","669","standard","C128","147","819","1","1","1","4,200.00","4,200.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:06");
INSERT INTO products VALUES("958","Astone_AMC,AMC","670","standard","C128","147","819","1","1","1","3,470.00","3,470.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:06");
INSERT INTO products VALUES("959","AXE,AG 48 CE EQULIZER","671","standard","C128","147","819","1","1","1","6,300.00","6,300.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:06");
INSERT INTO products VALUES("960","AXE,Black","672","standard","C128","147","819","1","1","1","4,975.00","4,975.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:06");
INSERT INTO products VALUES("961","AXE,CITY ","674","standard","C128","147","819","1","1","1","6,000.00","6,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:06");
INSERT INTO products VALUES("962","AXE,City -979","675","standard","C128","147","819","1","1","1","5,300.00","5,300.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:06");
INSERT INTO products VALUES("963","AXE,City -EQ","676","standard","C128","147","819","1","1","1","5,500.00","5,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:06");
INSERT INTO products VALUES("964","AXE,CITY GLOSY BLACK EQ","677","standard","C128","147","819","1","1","1","5,500.00","5,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("965","AXE,EQ -BLACK","678","standard","C128","147","819","1","1","1","5,500.00","5,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("966","AXE,EQ-BLUE","679","standard","C128","147","819","1","1","1","5,500.00","5,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("967","AXE,EQ-SP 500","680","standard","C128","147","819","1","1","1","6,300.00","6,300.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("968","AXE,EQ-SUNBRUST","681","standard","C128","147","819","1","1","1","5,500.00","5,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("969","AXE,Jakir","682","standard","C128","147","819","1","1","1","4,543.25","4,543.25","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("970","AXE,Sunbrust","683","standard","C128","147","819","1","1","1","4,900.00","4,900.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("971","AXE,Wooden Color","684","standard","C128","147","819","1","1","1","4,900.00","4,900.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("972","AXE-Anisha-EQ,AXE-Anisha-EQ","685","standard","C128","147","819","1","1","1","6,500.00","6,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("973","Caravan Music,CITY ","686","standard","C128","147","819","1","1","1","4,500.00","4,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("974","Chord,.","687","standard","C128","147","819","1","1","1","7,000.00","7,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("975","Chord,City-EQ-EA-12","688","standard","C128","147","819","1","1","1","6,300.00","6,300.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("976","CMC,CITY-EQ","689","standard","C128","147","819","1","1","1","5,750.00","5,750.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("977","Custom,City EQ","691","standard","C128","147","819","1","1","1","6,000.00","6,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("978","Custom,City-CS30 EQ","692","standard","C128","147","819","1","1","1","5,150.00","5,150.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("979","Custom,city-xcgg-le","693","standard","C128","147","819","1","1","1","5,500.00","5,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("980","Custom,GB Black","694","standard","C128","147","819","1","1","1","4,900.00","4,900.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("981","Custom,GB Green","695","standard","C128","147","819","1","1","1","4,900.00","4,900.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("982","Custom,GB Wooden","696","standard","C128","147","819","1","1","1","4,900.00","4,900.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("983","Custom,Jakir","697","standard","C128","147","819","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("984","Custom,JK-7419","698","standard","C128","147","819","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("985","Custom,JSM-JK-7419","699","standard","C128","147","819","1","1","1","5,000.00","5,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("986","Custom,MDY-40SS-EQ-N-G","700","standard","C128","147","819","1","1","1","9,000.00","9,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("987","Dadarwood,401-CITY","701","standard","C128","147","819","1","1","1","13,000.00","13,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("988","Dadarwood,404-CITY","703","standard","C128","147","819","1","1","1","15,000.00","15,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("989","Dadarwood,DW-Om 460 CS- CITY","704","standard","C128","147","819","1","1","1","17,500.00","17,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("990","Daisy Rock,Royal Blue Burst","705","standard","C128","147","819","1","1","1","16,500.00","16,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("991","Deviser,City-LS-161","706","standard","C128","147","819","1","1","1","7,500.00","7,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("992","Deviser,CITY-LS-570-40","707","standard","C128","147","819","1","1","1","7,800.00","7,800.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("993","Deviser,JA-4040","708","standard","C128","147","819","1","1","1","4,400.00","4,400.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("994","Deviser,MDY-LS-161-EQ","709","standard","C128","147","819","1","1","1","8,550.00","8,550.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("995","DO ,JSM-DO-DE-41-38","711","standard","C128","147","819","1","1","1","8,500.00","8,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("996","Doris,RNG-A-300C EQ","712","standard","C128","147","819","1","1","1","8,200.00","8,200.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("997","Dream Maker,RNG-DM-305 C EQ","714","standard","C128","147","819","1","1","1","10,000.00","10,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("998","Dream Maker,RNG-DM-307 EQ","715","standard","C128","147","819","1","1","1","10,000.00","10,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("999","Econ,.","716","standard","C128","147","819","1","1","1","4,500.00","4,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("1000","Epiphone,City.","717","standard","C128","147","819","1","1","1","3,400.00","3,400.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("1001","Fender,CITY CD-60","718","standard","C128","147","819","1","1","1","9,500.00","9,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("1002","Fender,EQ-JSM","719","standard","C128","147","819","1","1","1","10,000.00","10,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("1003","Fender,Indian","720","standard","C128","147","819","1","1","1","3,800.00","3,800.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("1004","Fender,STI-FND-284756","721","standard","C128","147","819","1","1","1","3,800.00","3,800.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("1005","Flamango_City,.","722","standard","C128","147","819","1","1","1","5,500.00","5,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("1006","Flora,.","723","standard","C128","147","819","1","1","1","9,500.00","9,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("1007","Givson,Cut Away","725","standard","C128","147","819","1","1","1","4,000.00","4,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("1008","Givson,Jumbo Rose Cutway","726","standard","C128","147","819","1","1","1","4,300.00","4,300.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("1009","Givson,Oxford","727","standard","C128","147","819","1","1","1","4,700.00","4,700.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("1010","Givson,Topaz Crown Super","728","standard","C128","147","819","1","1","1","4,500.00","4,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("1011","Givson,Topaz Cutway Venus rose","729","standard","C128","147","819","1","1","1","4,500.00","4,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("1012","Givson,Venus Special","730","standard","C128","147","819","1","1","1","4,500.00","4,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("1013","Givson_AMC,AMC","731","standard","C128","147","819","1","1","1","3,870.00","3,870.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("1014","Glashutte,City. ","732","standard","C128","147","819","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("1015","Godson,2007","733","standard","C128","147","819","1","1","1","4,200.00","4,200.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("1016","Godson,Cambridge","734","standard","C128","147","819","1","1","1","4,266.67","4,266.67","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("1017","Godson,Coffee House","735","standard","C128","147","819","1","1","1","4,200.00","4,200.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("1018","Godson,Venus Special","736","standard","C128","147","819","1","1","1","4,000.00","4,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("1019","Godson,Venus Super Special","737","standard","C128","147","819","1","1","1","4,500.00","4,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("1020","Guiliani GAG,40SSEQ G","738","standard","C128","147","819","1","1","1","10,500.00","10,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("1021","Guiliani GAG,40SSEQ M","739","standard","C128","147","819","1","1","1","10,500.00","10,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("1022","Hobner,m/s ","740","standard","C128","147","819","1","1","1","4,200.00","4,200.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("1023","Ibanez, JSM-V74ECE#-OPEN-3H-01","741","standard","C128","147","819","1","1","1","12,000.00","12,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("1024","Ibanez,AeL 10 EEQ  UKC","742","standard","C128","147","819","1","1","1","5,000.00","5,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("1025","Ibanez,RNG-M-IB130","744","standard","C128","147","819","1","1","1","6,500.00","6,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("1026","Ibanez,RNG-M-IV-220","745","standard","C128","147","819","1","1","1","6,800.00","6,800.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("1027","Ibanez,Sunbrust","746","standard","C128","147","819","1","1","1","7,500.00","7,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("1028","Jack Daniels,GB Black","747","standard","C128","147","819","1","1","1","4,900.00","4,900.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("1029","Jack Daniels,GB Red","748","standard","C128","147","819","1","1","1","4,900.00","4,900.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("1030","Jack Daniels,GB Wooden","749","standard","C128","147","819","1","1","1","4,900.00","4,900.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("1031","Joy,jakir(FA40-F)","750","standard","C128","147","819","1","1","1","7,666.67","7,666.67","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("1032","Joy,Jakir-FA-40F (N EQ)","751","standard","C128","147","819","1","1","1","6,000.00","6,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("1033","JSM,Black","752","standard","C128","147","819","1","1","1","5,500.00","5,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("1034","JSM,Blue","753","standard","C128","147","819","1","1","1","5,650.00","5,650.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("1035","JSM,Red","754","standard","C128","147","819","1","1","1","5,700.00","5,700.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("1036","JSM,ROHS-SL. NO.21081106","755","standard","C128","147","819","1","1","1","5,200.00","5,200.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("1037","KAXIDIA_EQ,.","756","standard","C128","147","819","1","1","1","8,000.00","8,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("1038","Kramer,City-KM-450","757","standard","C128","147","819","1","1","1","5,600.00","5,600.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("1039","Kramer,K-420C","758","standard","C128","147","819","1","1","1","4,800.00","4,800.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("1040","Kramer,WOODEN (EQ K-420C)","759","standard","C128","147","819","1","1","1","6,000.00","6,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("1041","LTD,XAC 10E Black","760","standard","C128","147","819","1","1","1","15,500.00","15,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("1042","Mantek_City_EQ,.","761","standard","C128","147","819","1","1","1","9,000.00","9,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:49","2024-01-10 15:01:07");
INSERT INTO products VALUES("1043","Nylon String,Palmer ","763","standard","C128","147","819","1","1","1","11,500.00","11,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:07");
INSERT INTO products VALUES("1044","Occan,CITY-EQ","765","standard","C128","147","819","1","1","1","5,800.00","5,800.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:07");
INSERT INTO products VALUES("1045","Occan,OAG-3EQ-BK","766","standard","C128","147","819","1","1","1","6,000.00","6,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:07");
INSERT INTO products VALUES("1046","Palmer,PD-37 ceq","767","standard","C128","147","819","1","1","1","8,000.00","8,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:07");
INSERT INTO products VALUES("1047","Pleasure,.","768","standard","C128","147","819","1","1","1","3,800.00","3,800.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:07");
INSERT INTO products VALUES("1048","Puretone,.","769","standard","C128","147","819","1","1","1","5,500.00","5,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:07");
INSERT INTO products VALUES("1049","Rockjam,AG-1EQ-N","770","standard","C128","147","819","1","1","1","6,000.00","6,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:07");
INSERT INTO products VALUES("1050","Rockjam,AG-2EQ-N","771","standard","C128","147","819","1","1","1","6,000.00","6,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:07");
INSERT INTO products VALUES("1051","Rockjam,AG-2EQ-WA","772","standard","C128","147","819","1","1","1","6,000.00","6,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:07");
INSERT INTO products VALUES("1052","Rockjam,AG-2EQ/WBLS-FISHMAN ","773","standard","C128","147","819","1","1","1","7,500.00","7,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:07");
INSERT INTO products VALUES("1053","Rockjam,Ag-3EQ-BK","774","standard","C128","147","819","1","1","1","7,500.00","7,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:07");
INSERT INTO products VALUES("1054","Rockjam,AG-3EQ-N-Tuner","775","standard","C128","147","819","1","1","1","8,000.00","8,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:07");
INSERT INTO products VALUES("1055","Rockjam,JSM-EQ","776","standard","C128","147","819","1","1","1","6,000.00","6,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:07");
INSERT INTO products VALUES("1056","Rockjam,MD-RAG-2EQ-BLS-TUNER","777","standard","C128","147","819","1","1","1","7,000.00","7,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:07");
INSERT INTO products VALUES("1057","Rockjam,MD-RAG-3EQ-BK-LCS","778","standard","C128","147","819","1","1","1","7,000.00","7,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:07");
INSERT INTO products VALUES("1058","Signature,City-Special","779","standard","C128","147","819","1","1","1","3,291.07","3,291.07","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:07");
INSERT INTO products VALUES("1059","Signature,Glosy blue alam","780","standard","C128","147","819","1","1","1","3,000.00","3,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:07");
INSERT INTO products VALUES("1060","Signature,GOGO","781","standard","C128","147","819","1","1","1","4,300.00","4,300.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1061","Signature,GOGO - S.T.I","782","standard","C128","147","819","1","1","1","3,850.00","3,850.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1062","Signature,Good Quality","783","standard","C128","147","819","1","1","1","3,800.00","3,800.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1063","Signature,MELODY SIGNATURE","784","standard","C128","147","819","1","1","1","3,795.92","3,795.92","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1064","Signature,Roghu","785","standard","C128","147","819","1","1","1","3,271.43","3,271.43","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1065","Signature,Special","786","standard","C128","147","819","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1066","Signature_AMC,AMC","787","standard","C128","147","819","1","1","1","3,470.00","3,470.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1067","SQOE-SQ-J,JSM_EST1883 EQ","788","standard","C128","147","819","1","1","1","10,500.00","10,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1068","Suymphoni,.","791","standard","C128","147","819","1","1","1","3,600.00","3,600.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1069","SX,Custom Wooden","792","standard","C128","147","819","1","1","1","4,900.00","4,900.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1070","SX,EQ Custom Wooden ","793","standard","C128","147","819","1","1","1","6,200.00","6,200.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1071","SX,JSM-401-C","794","standard","C128","147","819","1","1","1","5,300.00","5,300.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1072","SX,SA3-Black","795","standard","C128","147","819","1","1","1","9,000.00","9,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1073","SX,SA3-SB","796","standard","C128","147","819","1","1","1","9,000.00","9,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1074","SX,SA3-Wooden","797","standard","C128","147","819","1","1","1","9,000.00","9,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1075","Takamyne,Jakir Jumbo Rose Cutway Fishman Pickup","798","standard","C128","147","819","1","1","1","10,500.00","10,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1076","Takamyne,Jakir Topaz Fishman Pickup","799","standard","C128","147","819","1","1","1","10,500.00","10,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1077","TAKLA-EQ- Anisha,M 390","800","standard","C128","147","819","1","1","1","7,500.00","7,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1078","TAKLA-EQ- Anisha,Y 01","801","standard","C128","147","819","1","1","1","7,500.00","7,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1079","Tanglewood,TL SFCE GBK","802","standard","C128","147","819","1","1","1","11,375.00","11,375.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1080","Tanglewood,TWY-AVB JSM","803","standard","C128","147","819","1","1","1","15,500.00","15,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1081","TGM   ,AG-14EQ-N","804","standard","C128","147","819","1","1","1","12,740.00","12,740.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1082","TGM   ,AG-2EQ-WBLS","805","standard","C128","147","819","1","1","1","7,000.00","7,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1083","TGM   ,AG-2EQ-WOOD","806","standard","C128","147","819","1","1","1","7,000.00","7,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1084","TGM   ,AG-3EQ-BK","807","standard","C128","147","819","1","1","1","7,000.00","7,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1085","TGM   ,AG-3EQ-BK-Tuner","808","standard","C128","147","819","1","1","1","7,000.00","7,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1086","TGM   ,AZAD( EQ & Tuner)","809","standard","C128","147","819","1","1","1","6,265.00","6,265.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1087","TGM   ,CITY BLK","810","standard","C128","147","819","1","1","1","5,000.00","5,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1088","TGM   ,CITY EQ ","811","standard","C128","147","819","1","1","1","5,650.00","5,650.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1089","TGM   ,CITY NATURAL","812","standard","C128","147","819","1","1","1","5,000.00","5,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1090","TGM   ,CITY SUNBRAST","813","standard","C128","147","819","1","1","1","5,000.00","5,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1091","TGM   ,GB 1400-C Black","814","standard","C128","147","819","1","1","1","4,900.00","4,900.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1092","TGM   ,GB 1400-C Blue","815","standard","C128","147","819","1","1","1","4,900.00","4,900.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1093","TGM   ,GB 1400-C Red","816","standard","C128","147","819","1","1","1","4,900.00","4,900.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1094","TGM   ,JK-7419","817","standard","C128","147","819","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1095","TGM   ,JSM-JK-7419","818","standard","C128","147","819","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1096","TGM   ,MD-TAG-3EQ-DRS","819","standard","C128","147","819","1","1","1","6,500.00","6,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1097","TGM- Anisha,TGM- EQ","820","standard","C128","147","819","1","1","1","6,500.00","6,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1098","Vinik,CITY V.C.W-39","821","standard","C128","147","819","1","1","1","5,800.00","5,800.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1099","Vivid,JA-121C BK","822","standard","C128","147","819","1","1","1","5,100.00","5,100.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1100","Washbun,EA12 BK","824","standard","C128","147","819","1","1","1","9,500.00","9,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1101","Washbun,EA12 RED","825","standard","C128","147","819","1","1","1","9,500.00","9,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1102","Winner,WAG-2EQ-BLS","826","standard","C128","147","819","1","1","1","5,500.00","5,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1103","Winner,WAG-3EQ-BK","827","standard","C128","147","819","1","1","1","5,500.00","5,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1104","Winner,WAG-3EQ-WBLS","828","standard","C128","147","819","1","1","1","6,000.00","6,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1105","X-MEN,BLK","829","standard","C128","147","819","1","1","1","4,900.00","4,900.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1106","X-MEN,Wooden Color","830","standard","C128","147","819","1","1","1","4,900.00","4,900.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1107","Yamaha,APX-500","831","standard","C128","147","819","1","1","1","23,000.00","23,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1108","Yamaha,City-YG-720 C-EQ","833","standard","C128","147","819","1","1","1","5,150.00","5,150.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1109","Yamaha,FG700S","834","standard","C128","147","819","1","1","1","8,500.00","8,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1110","Yamaha,FGX720","835","standard","C128","147","819","1","1","1","10,000.00","10,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1111","Yamaha,Good Quality","836","standard","C128","147","819","1","1","1","10,500.00","10,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1112","Yamaha,Jakir-F300 EQ","837","standard","C128","147","819","1","1","1","6,500.00","6,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1113","Yamaha,Jakir-F310","838","standard","C128","147","819","1","1","1","10,000.00","10,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1114","Yamaha,JK-Black","839","standard","C128","147","819","1","1","1","6,750.00","6,750.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1115","Yamaha,RNG-F-3000-EQ","840","standard","C128","147","819","1","1","1","6,000.00","6,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1116","Yemaha,.","841","standard","C128","147","819","1","1","1","3,300.00","3,300.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1117","Yemaha,2009","842","standard","C128","147","819","1","1","1","4,161.04","4,161.04","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1118","Yemaha,2011","843","standard","C128","147","819","1","1","1","4,500.00","4,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1119","Yemaha,C.M. P/Q Naple","844","standard","C128","147","819","1","1","1","4,700.00","4,700.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1120","Yemaha,CM-1","845","standard","C128","147","819","1","1","1","4,550.00","4,550.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1121","Yemaha,CM-2 pic up","847","standard","C128","147","819","1","1","1","4,500.00","4,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1122","Zealux,.","848","standard","C128","147","819","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1123","Zealux,blue","850","standard","C128","147","819","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1124","Electric Guitar Package ,.","873","standard","C128","165","819","1","1","1","27,000.00","27,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1125","FENDER-City-Mat,FENDER-City-Mat-CD-200","854","standard","C128","149","819","1","1","1","4,000.00","4,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1126","Elc. lead,.","1273","standard","C128","148","837","1","1","1","95","95","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:13");
INSERT INTO products VALUES("1127","Electro Acostic,City-BA-210","857","standard","C128","152","819","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1128","Classical Nylon,37NR-C/RDS","858","standard","C128","153","819","1","1","1","4,300.00","4,300.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1129","Classical Nylon,travell  37NR-C/BLS","859","standard","C128","153","819","1","1","1","4,300.00","4,300.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1130","Acoustic,FLODA-BK-JSM","860","standard","C128","154","819","1","1","1","4,500.00","4,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1131","Baby Guitar-City,Givson-City","861","standard","C128","155","819","1","1","1","3,500.00","3,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1132","Baby Guitar-City,Godson-City","862","standard","C128","156","819","1","1","1","3,500.00","3,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1133","Electro Acostic,.","1663","standard","C128","339","872","1","1","1","4,500.00","4,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:17");
INSERT INTO products VALUES("1134","Elc. lead,RG 270","865","standard","C128","159","819","1","1","1","17,000.00","17,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1135","Electric,RG 270","866","standard","C128","159","819","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1136","IBANEZ-city-Mat,IBANEZ-city-Mat-AG-52","867","standard","C128","160","819","1","1","1","4,000.00","4,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1137","Acoustic,","868","standard","C128","161","819","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1138","Acoustic,LG-212","869","standard","C128","162","819","1","1","1","7,000.00","7,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1139","MDY,New TGM","870","standard","C128","163","819","1","1","1","5,500.00","5,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1140","Electro Acostic,New TGM -MDY-EQ","871","standard","C128","164","819","1","1","1","6,300.00","6,300.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1141","Baby Guitar,.","872","standard","C128","39","819","1","1","1","1,650.00","1,650.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:08");
INSERT INTO products VALUES("1142","Acoustic,FN-20L","874","standard","C128","166","819","1","1","1","8,500.00","8,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:09");
INSERT INTO products VALUES("1143","Acoustic,SJ-R1L","875","standard","C128","166","819","1","1","1","7,500.00","7,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:09");
INSERT INTO products VALUES("1144","Electro Acostic,-S.T.I - Special","876","standard","C128","66","819","1","1","1","3,150.00","3,150.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:09");
INSERT INTO products VALUES("1145","Electro Acostic.,.","877","standard","C128","167","819","1","1","1","2,700.00","2,700.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:09");
INSERT INTO products VALUES("1146","Acoustic,TS-23-40-JSM","878","standard","C128","168","819","1","1","1","6,750.00","6,750.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:09");
INSERT INTO products VALUES("1147","Acoustic,TS-230 A","879","standard","C128","168","819","1","1","1","6,500.00","6,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:09");
INSERT INTO products VALUES("1148","Acoustic,TS-34 A-JSM","880","standard","C128","168","819","1","1","1","6,500.00","6,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:09");
INSERT INTO products VALUES("1149","Acoustic,TS-430-JSM","881","standard","C128","168","819","1","1","1","6,750.00","6,750.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:09");
INSERT INTO products VALUES("1150","Acoustic,TS-452 N (JSM)","882","standard","C128","168","819","1","1","1","7,000.00","7,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:09");
INSERT INTO products VALUES("1151","Acoustic-jsm,J-34A","883","standard","C128","168","819","1","1","1","6,500.00","6,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:09");
INSERT INTO products VALUES("1152","Acoustic-Jsm,TBS-404","884","standard","C128","168","819","1","1","1","4,500.00","4,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:09");
INSERT INTO products VALUES("1153","Acoustic,City-AG-3","885","standard","C128","32","819","1","1","1","4,000.00","4,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:09");
INSERT INTO products VALUES("1154","Electro Acostic,MDY BK LEFTY","886","standard","C128","32","819","1","1","1","8,000.00","8,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:50","2024-01-10 15:01:09");
INSERT INTO products VALUES("1155","Acoustic,GB","887","standard","C128","169","819","1","1","1","4,000.00","4,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:09");
INSERT INTO products VALUES("1156","Electro Acostic.,","888","standard","C128","169","819","1","1","1","5,500.00","5,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:09");
INSERT INTO products VALUES("1157","Electro Acostic,","890","standard","C128","171","819","1","1","1","6,500.00","6,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:09");
INSERT INTO products VALUES("1158","Electro Acostic,TGM-EQ","891","standard","C128","172","819","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:09");
INSERT INTO products VALUES("1159","TGM-Ukulele Center,TGM-BK-2022","892","standard","C128","173","819","1","1","1","4,300.00","4,300.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:09");
INSERT INTO products VALUES("1160","TGM-Ukulele Center,TGM-SM-2022","893","standard","C128","173","819","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:09");
INSERT INTO products VALUES("1161","Acoustic,TR-D1140","894","standard","C128","174","819","1","1","1","8,000.00","8,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:09");
INSERT INTO products VALUES("1162","Classical Guitar,vc 104 Rds","895","standard","C128","94","819","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:09");
INSERT INTO products VALUES("1163","Classical Guitar,vc 104 Rds MDY","896","standard","C128","94","819","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:09");
INSERT INTO products VALUES("1164","Nylon String,vc 104 Rds MDY","898","standard","C128","94","819","1","1","1","5,500.00","5,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:09");
INSERT INTO products VALUES("1165","Electro Acostic,VG 48 EQ","899","standard","C128","175","819","1","1","1","6,300.00","6,300.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:09");
INSERT INTO products VALUES("1166","Acoustic,travell XSD-31CM","900","standard","C128","176","819","1","1","1","6,000.00","6,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:09");
INSERT INTO products VALUES("1167","Elc. Bass,Wooden Color","901","standard","C128","41","819","1","1","1","36,500.00","36,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:09");
INSERT INTO products VALUES("1168","Electro Acostic,Yamaha-720-EQ -City","903","standard","C128","178","819","1","1","1","5,000.00","5,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:09");
INSERT INTO products VALUES("1169","Acoustic-City,Yamaha-F/FX- City","904","standard","C128","179","819","1","1","1","6,500.00","6,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:09");
INSERT INTO products VALUES("1170","Electro Acostic,Yamaha-F/FX- EQ-City","905","standard","C128","180","819","1","1","1","7,500.00","7,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:09");
INSERT INTO products VALUES("1171","10 WAT,Anisha-10","906","standard","C128","181","820","1","1","1","2,950.00","2,950.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:09");
INSERT INTO products VALUES("1172","22 Watt,Anisha-22","907","standard","C128","181","820","1","1","1","4,500.00","4,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:09");
INSERT INTO products VALUES("1173","52 watt,Anisha 52","908","standard","C128","181","820","1","1","1","5,500.00","5,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:09");
INSERT INTO products VALUES("1174","10 WAT,Ben-10","909","standard","C128","182","820","1","1","1","2,600.00","2,600.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:09");
INSERT INTO products VALUES("1175","22 Watt,Ben-22","910","standard","C128","182","820","1","1","1","3,850.00","3,850.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:09");
INSERT INTO products VALUES("1176","52 watt,Ben-52","911","standard","C128","182","820","1","1","1","5,100.00","5,100.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:09");
INSERT INTO products VALUES("1177","Bass Amp-MARTINA 8,MARTINA 8","912","standard","C128","182","820","1","1","1","3,150.00","3,150.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:09");
INSERT INTO products VALUES("1178","Bass_Amp 10 watt,.","913","standard","C128","182","820","1","1","1","4,200.00","4,200.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:09");
INSERT INTO products VALUES("1179","22 Watt,.","914","standard","C128","183","820","1","1","1","5,500.00","5,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:09");
INSERT INTO products VALUES("1180","10 WAT,AG 10","915","standard","C128","184","820","1","1","1","4,250.00","4,250.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:09");
INSERT INTO products VALUES("1181","7 WATT,KTN-MINI MDY","916","standard","C128","36","820","1","1","1","12,500.00","12,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:09");
INSERT INTO products VALUES("1182","10 WAT,City TG-25","917","standard","C128","142","820","1","1","1","3,700.00","3,700.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:09");
INSERT INTO products VALUES("1183","25 WAT,TG-25","918","standard","C128","142","820","1","1","1","4,500.00","4,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:09");
INSERT INTO products VALUES("1184","Mini,RNG-TG-10 R ","919","standard","C128","51","820","1","1","1","3,800.00","3,800.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:09");
INSERT INTO products VALUES("1185","Mini,Cube 20M","920","standard","C128","185","820","1","1","1","4,500.00","4,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:09");
INSERT INTO products VALUES("1186","Mini,EGM-10","921","standard","C128","186","820","1","1","1","4,250.00","4,250.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:09");
INSERT INTO products VALUES("1187","Mini,EGM-15","922","standard","C128","186","820","1","1","1","5,000.00","5,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:09");
INSERT INTO products VALUES("1188","Mini,EGM-20","923","standard","C128","186","820","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:09");
INSERT INTO products VALUES("1189","Mini,GTD-10WS","924","standard","C128","187","820","1","1","1","4,200.00","4,200.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:09");
INSERT INTO products VALUES("1190","Mini,GT-10","925","standard","C128","188","820","1","1","1","3,500.00","3,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:09");
INSERT INTO products VALUES("1191","Mini,GT-15","926","standard","C128","188","820","1","1","1","4,500.00","4,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:09");
INSERT INTO products VALUES("1192","Mini,GT-25","927","standard","C128","188","820","1","1","1","5,500.00","5,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:09");
INSERT INTO products VALUES("1193","GT-20-UK Center,GT-20-UK Center","928","standard","C128","189","820","1","1","1","4,300.00","4,300.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:09");
INSERT INTO products VALUES("1194","GT-40 Uk Center,GT-40 Uk Center","929","standard","C128","190","820","1","1","1","6,000.00","6,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:09");
INSERT INTO products VALUES("1195","12 Watt,CR-12L","930","standard","C128","165","820","1","1","1","11,500.00","11,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:09");
INSERT INTO products VALUES("1196","3 Watt,CR3","931","standard","C128","165","820","1","1","1","5,005.00","5,005.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:09");
INSERT INTO products VALUES("1197","CRUSH-20,.","932","standard","C128","165","820","1","1","1","6,800.00","6,800.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:09");
INSERT INTO products VALUES("1198","Mini,AG15R","933","standard","C128","191","820","1","1","1","8,500.00","8,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:09");
INSERT INTO products VALUES("1199","CUBE_20,.","934","standard","C128","192","820","1","1","1","5,800.00","5,800.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:09");
INSERT INTO products VALUES("1200","CUBE_27,.","935","standard","C128","192","820","1","1","1","7,000.00","7,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:09");
INSERT INTO products VALUES("1201","C-15,.","936","standard","C128","128","820","1","1","1","4,500.00","4,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:09");
INSERT INTO products VALUES("1202","C-6,.","937","standard","C128","128","820","1","1","1","4,200.00","4,200.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:09");
INSERT INTO products VALUES("1203","CUBE 40M,","938","standard","C128","128","820","1","1","1","9,500.00","9,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:09");
INSERT INTO products VALUES("1204","CUBE-29,.","939","standard","C128","128","820","1","1","1","8,000.00","8,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:09");
INSERT INTO products VALUES("1205","CUBE-80,City","940","standard","C128","128","820","1","1","1","14,000.00","14,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:09");
INSERT INTO products VALUES("1206","CUBE-80,Mdy  ","941","standard","C128","128","820","1","1","1","12,700.00","12,700.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:09");
INSERT INTO products VALUES("1207","Mini,C20","942","standard","C128","128","820","1","1","1","5,150.00","5,150.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:09");
INSERT INTO products VALUES("1208","STI,cube 40","943","standard","C128","128","820","1","1","1","11,500.00","11,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:09");
INSERT INTO products VALUES("1209","Acoustic Amp,GA1065/10 W","944","standard","C128","62","820","1","1","1","3,933.33","3,933.33","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:09");
INSERT INTO products VALUES("1210","Bass Amp,Ba-1565","945","standard","C128","62","820","1","1","1","5,000.00","5,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:09");
INSERT INTO products VALUES("1211","Lead Amp,10 Watts","946","standard","C128","62","820","1","1","1","4,000.00","4,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:09");
INSERT INTO products VALUES("1212","Lead Amp,GA1065/10 W","947","standard","C128","62","820","1","1","1","4,000.00","4,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:09");
INSERT INTO products VALUES("1213","Pocked Amp,.","948","standard","C128","193","820","1","1","1","1,200.00","1,200.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:09");
INSERT INTO products VALUES("1214","Mini,N6","949","standard","C128","194","820","1","1","1","6,500.00","6,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:09");
INSERT INTO products VALUES("1215","Normal,A040","950","standard","C128","95","821","1","1","1","130","130","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:09");
INSERT INTO products VALUES("1216","Normal,A040-LB","951","standard","C128","95","821","1","1","1","123.54","123.54","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:09");
INSERT INTO products VALUES("1217","Normal,S.T.I","952","standard","C128","95","821","1","1","1","118.78","118.78","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:09");
INSERT INTO products VALUES("1218","Elc ,SP 007","955","standard","C128","51","821","1","1","1","280","280","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:09");
INSERT INTO products VALUES("1219","Acoustic,City.","970","standard","C128","159","821","1","1","1","400","400","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:10");
INSERT INTO products VALUES("1220","JSM,.","2202","standard","C128","94","937","1","1","1","4,800.00","4,800.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:23");
INSERT INTO products VALUES("1221","Leather,.","1646","standard","C128","39","868","1","1","1","180","180","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:17");
INSERT INTO products VALUES("1222","Leather,Jakir ","959","standard","C128","148","821","1","1","1","360","360","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:09");
INSERT INTO products VALUES("1223","Normal,GB Normal","961","standard","C128","148","821","1","1","1","150","150","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:09");
INSERT INTO products VALUES("1224","Normal,JSM ","2215","standard","C128","39","944","1","1","1","250","250","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:23");
INSERT INTO products VALUES("1225","Normal,Rif.","963","standard","C128","148","821","1","1","1","150","150","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:09");
INSERT INTO products VALUES("1226","Normal /Anisha,.","964","standard","C128","148","821","1","1","1","125","125","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:09");
INSERT INTO products VALUES("1227","Good,.","2176","standard","C128","39","934","1","1","1","41.15","41.15","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:23");
INSERT INTO products VALUES("1228","Good Quality,G.Shop","968","standard","C128","198","821","1","1","1","350","350","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:09");
INSERT INTO products VALUES("1229","Medium,G.Shop","969","standard","C128","198","821","1","1","1","250","250","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:09");
INSERT INTO products VALUES("1230","Coloured ,.","1704","standard","C128","39","875","1","1","1","450","450","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:17");
INSERT INTO products VALUES("1231","Tucana,.","973","standard","C128","200","821","1","1","1","405","405","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:10");
INSERT INTO products VALUES("1232","Normal,Good Quality","1007","standard","C128","209","821","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:10");
INSERT INTO products VALUES("1233","CITY,City Normal","977","standard","C128","39","821","1","1","1","320","320","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:10");
INSERT INTO products VALUES("1234","Janani Music,.","978","standard","C128","39","821","1","1","1","220","220","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:10");
INSERT INTO products VALUES("1235","Leather,Good Quality","1003","standard","C128","208","821","1","1","1","1,000.00","1,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:10");
INSERT INTO products VALUES("1236","Normal,Anisha","981","standard","C128","39","821","1","1","1","160","160","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:10");
INSERT INTO products VALUES("1237","Normal,Fire Belt","982","standard","C128","39","821","1","1","1","550","550","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:10");
INSERT INTO products VALUES("1238","Normal,Grass","984","standard","C128","39","821","1","1","1","280","280","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:10");
INSERT INTO products VALUES("1239","Normal,Malay-China","985","standard","C128","39","821","1","1","1","49","49","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:10");
INSERT INTO products VALUES("1240","Normal,Priented","986","standard","C128","39","821","1","1","1","200","200","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:10");
INSERT INTO products VALUES("1241","Normal,Rook Belt","987","standard","C128","39","821","1","1","1","450","450","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:10");
INSERT INTO products VALUES("1242","Slim,UC-Acoustic/Lead","990","standard","C128","202","821","1","1","1","300","300","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:10");
INSERT INTO products VALUES("1243","Wide,.","991","standard","C128","202","821","1","1","1","517","517","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:10");
INSERT INTO products VALUES("1244","Normal,City Normal","1847","standard","C128","148","899","1","1","1","8","8","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:19");
INSERT INTO products VALUES("1245","Good Quality ,Wide","995","standard","C128","204","821","1","1","1","700","700","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:10");
INSERT INTO products VALUES("1246","JSM,Slim","996","standard","C128","204","821","1","1","1","373.53","373.53","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:10");
INSERT INTO products VALUES("1247","JSM,Wide","997","standard","C128","204","821","1","1","1","400","400","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:10");
INSERT INTO products VALUES("1248","melody,.","998","standard","C128","204","821","1","1","1","340","340","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:10");
INSERT INTO products VALUES("1249","Normal,CBN","1005","standard","C128","62","821","1","1","1","250","250","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:10");
INSERT INTO products VALUES("1250","Normal,S 40/BK","1006","standard","C128","62","821","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:10");
INSERT INTO products VALUES("1251","Special_Chaina.,.","1009","standard","C128","210","822","1","1","1","90","90","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:10");
INSERT INTO products VALUES("1252","Push,.","1011","standard","C128","39","822","1","1","1","5.78","5.78","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:10");
INSERT INTO products VALUES("1253","Normal,A047A","1013","standard","C128","95","823","1","1","1","445.24","445.24","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:10");
INSERT INTO products VALUES("1254","Normal,A047B","1014","standard","C128","95","823","1","1","1","136.67","136.67","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:10");
INSERT INTO products VALUES("1255","10 Feet (Good Quality),EC943 (Labu)","1015","standard","C128","212","823","1","1","1","560","560","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:10");
INSERT INTO products VALUES("1256","Normal,DFS220-10H","1016","standard","C128","213","823","1","1","1","950","950","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:51","2024-01-10 15:01:10");
INSERT INTO products VALUES("1257","3 mtr,.","1036","standard","C128","41","823","1","1","1","360","360","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:10");
INSERT INTO products VALUES("1258","Vintage Voltage,City Normal","1019","standard","C128","148","823","1","1","1","800","800","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:10");
INSERT INTO products VALUES("1259","Vintage Voltage_10ft,","1020","standard","C128","148","823","1","1","1","580","580","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:10");
INSERT INTO products VALUES("1260","Vintage Voltage_20ft,","1021","standard","C128","148","823","1","1","1","700","700","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:10");
INSERT INTO products VALUES("1261","Normal /Anisha,3 meter","1022","standard","C128","150","823","1","1","1","600","600","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:10");
INSERT INTO products VALUES("1262","Normal /Anisha,6 meter","1023","standard","C128","150","823","1","1","1","900","900","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:10");
INSERT INTO products VALUES("1263","Normal,10 ft Mono ","1024","standard","C128","214","823","1","1","1","150","150","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:10");
INSERT INTO products VALUES("1264","3 mtr,RNG    ","1025","standard","C128","215","823","1","1","1","450","450","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:10");
INSERT INTO products VALUES("1265","10 Feet (Good Quality),IC18(Ben music)","1026","standard","C128","216","823","1","1","1","270","270","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:10");
INSERT INTO products VALUES("1266","10 mtr,.","1027","standard","C128","217","823","1","1","1","800","800","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:10");
INSERT INTO products VALUES("1267","Custom,3 meter","1028","standard","C128","81","823","1","1","1","600","600","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:10");
INSERT INTO products VALUES("1268","Coloured ,city","1029","standard","C128","39","823","1","1","1","138.97","138.97","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:10");
INSERT INTO products VALUES("1269","PJ-28N-Z002,.","1031","standard","C128","39","823","1","1","1","150","150","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:10");
INSERT INTO products VALUES("1270","Wireless Jack,.","1032","standard","C128","39","823","1","1","1","800","800","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:10");
INSERT INTO products VALUES("1271","Normal,PL-C3","1033","standard","C128","218","823","1","1","1","550","550","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:10");
INSERT INTO products VALUES("1272","Normal,3 meter","1034","standard","C128","219","823","1","1","1","626.42","626.42","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:10");
INSERT INTO products VALUES("1273","Normal,6 meter","1035","standard","C128","219","823","1","1","1","681.85","681.85","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:10");
INSERT INTO products VALUES("1274","A007A,.","1037","standard","C128","95","824","1","1","1","286.67","286.67","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:10");
INSERT INTO products VALUES("1275","A007D,.","1038","standard","C128","95","824","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:10");
INSERT INTO products VALUES("1276","A007H/BR,.","1039","standard","C128","95","824","1","1","1","1,000.00","1,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:10");
INSERT INTO products VALUES("1277","A007K,.","1040","standard","C128","95","824","1","1","1","350","350","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:10");
INSERT INTO products VALUES("1278","Classical Guitar,A007F-C","1041","standard","C128","95","824","1","1","1","145","145","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:10");
INSERT INTO products VALUES("1279","Metal,A007D/SL-A","1042","standard","C128","95","824","1","1","1","700","700","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:10");
INSERT INTO products VALUES("1280","Plastic,A007E","1043","standard","C128","95","824","1","1","1","120","120","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:10");
INSERT INTO products VALUES("1281","Acoustic,Anisha","1044","standard","C128","82","824","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:10");
INSERT INTO products VALUES("1282","Acoustic,Anisha box","1045","standard","C128","82","824","1","1","1","175","175","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:10");
INSERT INTO products VALUES("1283","Acoustic,Anisha PP","1046","standard","C128","82","824","1","1","1","180","180","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:10");
INSERT INTO products VALUES("1284","Metal,.","1543","standard","C128","","856","1","1","1","98.72","98.72","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:15");
INSERT INTO products VALUES("1285","Metal,AC-05","1048","standard","C128","184","824","1","1","1","1,500.00","1,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:10");
INSERT INTO products VALUES("1286","Metal,AC-20","1049","standard","C128","184","824","1","1","1","350","350","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:10");
INSERT INTO products VALUES("1287","Metal,AC-21","1050","standard","C128","184","824","1","1","1","380","380","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:10");
INSERT INTO products VALUES("1288","A/C Elelctric Guitar,Azad ","1051","standard","C128","220","824","1","1","1","200","200","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:10");
INSERT INTO products VALUES("1289","Metal,CM-047","1052","standard","C128","221","824","1","1","1","350","350","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:10");
INSERT INTO products VALUES("1290","JSM,CP-03","1054","standard","C128","51","824","1","1","1","200","200","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:10");
INSERT INTO products VALUES("1291","JSM,CP-08","1055","standard","C128","51","824","1","1","1","350","350","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:10");
INSERT INTO products VALUES("1292","JSM,JSM","1534","standard","C128","313","854","1","1","1","2,000.00","2,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:15");
INSERT INTO products VALUES("1293","ED-03,","1057","standard","C128","148","824","1","1","1","159.49","159.49","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:10");
INSERT INTO products VALUES("1294","Metal,FC-3R","1058","standard","C128","214","824","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:10");
INSERT INTO products VALUES("1295","Capo+Tuner,FCT-80","1059","standard","C128","223","824","1","1","1","700","700","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:10");
INSERT INTO products VALUES("1296","Metal,FC-76","1060","standard","C128","223","824","1","1","1","400","400","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:10");
INSERT INTO products VALUES("1297","Metal,FC-81","1061","standard","C128","223","824","1","1","1","376.67","376.67","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:10");
INSERT INTO products VALUES("1298","Acoustic  Guitar,CP-500","1064","standard","C128","226","824","1","1","1","600","600","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:10");
INSERT INTO products VALUES("1299","Metal,MC-1","1065","standard","C128","227","824","1","1","1","400.08","400.08","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:10");
INSERT INTO products VALUES("1300","Anisha- Black,.","1066","standard","C128","39","824","1","1","1","168.18","168.18","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:10");
INSERT INTO products VALUES("1301","Janani Music-Black,.","1067","standard","C128","39","824","1","1","1","150","150","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:10");
INSERT INTO products VALUES("1302","Metal,CITY ","1069","standard","C128","39","824","1","1","1","160","160","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:11");
INSERT INTO products VALUES("1303","Metal,JSM Paper Capo","1070","standard","C128","39","824","1","1","1","300","300","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:11");
INSERT INTO products VALUES("1304","Metal,Rif.","1071","standard","C128","39","824","1","1","1","200","200","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:11");
INSERT INTO products VALUES("1305","Metal,STI-Metal","1072","standard","C128","39","824","1","1","1","173.67","173.67","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:11");
INSERT INTO products VALUES("1306","Metal_RNG,SC-5","1073","standard","C128","39","824","1","1","1","280","280","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:11");
INSERT INTO products VALUES("1307","STI _BLACK,.","1074","standard","C128","39","824","1","1","1","290","290","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:11");
INSERT INTO products VALUES("1308","Metal,GC-02","1075","standard","C128","228","824","1","1","1","450","450","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:11");
INSERT INTO products VALUES("1309","Metal,CP-01","1076","standard","C128","229","824","1","1","1","180","180","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:11");
INSERT INTO products VALUES("1310","Metal,JSM-Metal","1079","standard","C128","41","824","1","1","1","500","500","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:11");
INSERT INTO products VALUES("1311","Metal,City DC-03","1081","standard","C128","231","824","1","1","1","420","420","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:11");
INSERT INTO products VALUES("1312","Pick, Bottom & Bottom Puller,.","1082","standard","C128","231","825","1","1","1","210","210","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:11");
INSERT INTO products VALUES("1313","Pick, Bottom & Bottom Puller,Ziko-Anisha","1083","standard","C128","232","825","1","1","1","150","150","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:11");
INSERT INTO products VALUES("1314","Wall,All Hanger","1084","standard","C128","233","826","1","1","1","276.15","276.15","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:11");
INSERT INTO products VALUES("1315","Wall,AH-81 City","1085","standard","C128","184","826","1","1","1","350","350","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:11");
INSERT INTO products VALUES("1316","China,.","2210","standard","C128","39","941","1","1","1","100","100","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:23");
INSERT INTO products VALUES("1317","Wall,Anisha","1087","standard","C128","235","826","1","1","1","300","300","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:11");
INSERT INTO products VALUES("1318","wall,.","1088","standard","C128","236","826","1","1","1","350","350","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:11");
INSERT INTO products VALUES("1319","Wall,GSP 39WB","1089","standard","C128","237","826","1","1","1","910","910","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:11");
INSERT INTO products VALUES("1320","Wall,Large","1091","standard","C128","39","826","1","1","1","3,000.00","3,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:11");
INSERT INTO products VALUES("1321","Wall,Small","1092","standard","C128","39","826","1","1","1","575","575","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:11");
INSERT INTO products VALUES("1322","Wall,LGH-01","1093","standard","C128","238","826","1","1","1","466.67","466.67","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:11");
INSERT INTO products VALUES("1323","Full Set,AD-016P","1094","standard","C128","95","827","1","1","1","650","650","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:11");
INSERT INTO products VALUES("1324","Full Set,AL-015P","1095","standard","C128","95","827","1","1","1","-845.14","-845.14","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:11");
INSERT INTO products VALUES("1325","Guitar Shop,Machine Head","1096","standard","C128","198","827","1","1","1","475","475","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:11");
INSERT INTO products VALUES("1326","Black key,loose","1097","standard","C128","39","827","1","1","1","100","100","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:11");
INSERT INTO products VALUES("1327","Box set 6 pics,.","1098","standard","C128","39","827","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:11");
INSERT INTO products VALUES("1328","Lossoe,Box Left ","1099","standard","C128","39","827","1","1","1","97.73","97.73","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:11");
INSERT INTO products VALUES("1329","Lossoe,Box Right","1100","standard","C128","39","827","1","1","1","91.66","91.66","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:11");
INSERT INTO products VALUES("1330","Lossoe,TGM Left","1101","standard","C128","39","827","1","1","1","91.66","91.66","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:11");
INSERT INTO products VALUES("1331","Lossoe,TGM Right","1102","standard","C128","39","827","1","1","1","91.66","91.66","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:11");
INSERT INTO products VALUES("1332","Round shape key,loose","1103","standard","C128","39","827","1","1","1","100","100","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:11");
INSERT INTO products VALUES("1333","Signature,.","1104","standard","C128","39","827","1","1","1","57.15","57.15","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:11");
INSERT INTO products VALUES("1334","TGM Set 6 pics,.","1105","standard","C128","39","827","1","1","1","575","575","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:11");
INSERT INTO products VALUES("1335","Full Set,Machine Head","1106","standard","C128","239","827","1","1","1","92","92","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:11");
INSERT INTO products VALUES("1336","Full Set,City-QZ-QFB-01","1107","standard","C128","207","827","1","1","1","500","500","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:11");
INSERT INTO products VALUES("1337","Acoustic,WCP-60G","1108","standard","C128","240","828","1","1","1","320","320","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:11");
INSERT INTO products VALUES("1338","Acoustic,KQ-3","1109","standard","C128","241","828","1","1","1","800","800","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:11");
INSERT INTO products VALUES("1339","Acoustic,QH-6B","1110","standard","C128","241","828","1","1","1","800","800","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:11");
INSERT INTO products VALUES("1340","Acoustic,FCP-21","1111","standard","C128","223","828","1","1","1","290","290","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:11");
INSERT INTO products VALUES("1341","Pickup With Jack,Rif.","1112","standard","C128","242","828","1","1","1","600","600","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:11");
INSERT INTO products VALUES("1342","Acoustic,Round Shap","1113","standard","C128","39","828","1","1","1","334.44","334.44","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:11");
INSERT INTO products VALUES("1343","Head Phone Amp,GP-1","1114","standard","C128","243","829","1","1","1","1,800.00","1,800.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:11");
INSERT INTO products VALUES("1344","Big,A039PO-B","1115","standard","C128","95","830","1","1","1","250","250","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:11");
INSERT INTO products VALUES("1345","Small,A039PO-S","1116","standard","C128","95","830","1","1","1","403.29","403.29","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:11");
INSERT INTO products VALUES("1346","Small,A044 ","1117","standard","C128","95","830","1","1","1","350","350","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:11");
INSERT INTO products VALUES("1347","Body Polish,Lemon Oil, Hydrate","1118","standard","C128","244","830","1","1","1","750","750","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:11");
INSERT INTO products VALUES("1348","PW-PL-03,.","1119","standard","C128","244","830","1","1","1","500","500","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:11");
INSERT INTO products VALUES("1349","Fretboard,Formula 65 (118 ml)","1120","standard","C128","245","830","1","1","1","820","820","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:11");
INSERT INTO products VALUES("1350","shine 60ml,.","1124","standard","C128","200","830","1","1","1","180","180","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:11");
INSERT INTO products VALUES("1351","Lemon Oil,LEO-15","1122","standard","C128","200","830","1","1","1","450","450","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:11");
INSERT INTO products VALUES("1352","shine 50ml,","1123","standard","C128","200","830","1","1","1","140","140","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:11");
INSERT INTO products VALUES("1353","Small,LMP-06","1125","standard","C128","200","830","1","1","1","250","250","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:11");
INSERT INTO products VALUES("1354","Body Polish,120 ml","1126","standard","C128","247","830","1","1","1","810","810","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:11");
INSERT INTO products VALUES("1355","Body Polish,360 ml","1127","standard","C128","247","830","1","1","1","1,900.00","1,900.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:11");
INSERT INTO products VALUES("1356","Fretboard,F-ONE Oil","1128","standard","C128","247","830","1","1","1","950","950","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:11");
INSERT INTO products VALUES("1357","String Care Kit,2X Applications","1129","standard","C128","247","830","1","1","1","950","950","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:11");
INSERT INTO products VALUES("1358","Elc Led,GT-1","1130","standard","C128","36","831","1","1","1","17,500.00","17,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:11");
INSERT INTO products VALUES("1359","Elc Led,ME-25","1131","standard","C128","36","831","1","1","1","16,013.00","16,013.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:11");
INSERT INTO products VALUES("1360","Elc Led,ME-80","1132","standard","C128","36","831","1","1","1","22,000.00","22,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:11");
INSERT INTO products VALUES("1361","Turbo Distortion,DS-2","1133","standard","C128","36","831","1","1","1","5,460.00","5,460.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:11");
INSERT INTO products VALUES("1362","Elc. lead,RP 155","1134","standard","C128","248","831","1","1","1","6,825.00","6,825.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:11");
INSERT INTO products VALUES("1363","Elc. lead,RP 55","1135","standard","C128","248","831","1","1","1","5,005.00","5,005.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:11");
INSERT INTO products VALUES("1364","Elc. lead,RP 70","1136","standard","C128","248","831","1","1","1","5,460.00","5,460.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:11");
INSERT INTO products VALUES("1365","Elc. lead,RP 90","1137","standard","C128","248","831","1","1","1","6,825.00","6,825.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:52","2024-01-10 15:01:11");
INSERT INTO products VALUES("1366","Elc. lead,RP-360","1138","standard","C128","248","831","1","1","1","14,500.00","14,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:11");
INSERT INTO products VALUES("1367","STOMP BOX,.","1139","standard","C128","212","831","1","1","1","4,000.00","4,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:11");
INSERT INTO products VALUES("1368","JOYO_,.","1140","standard","C128","249","831","1","1","1","7,200.00","7,200.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:11");
INSERT INTO products VALUES("1369","Crunch Distortion,JF-03","1141","standard","C128","250","831","1","1","1","2,000.00","2,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:11");
INSERT INTO products VALUES("1370","Elc. lead,Gem box","1142","standard","C128","250","831","1","1","1","6,500.00","6,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:11");
INSERT INTO products VALUES("1371","Elc. lead,Gem box II","1143","standard","C128","250","831","1","1","1","8,500.00","8,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:11");
INSERT INTO products VALUES("1372","Elc Led,GE 100- Labu","1144","standard","C128","251","831","1","1","1","9,500.00","9,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:11");
INSERT INTO products VALUES("1373","Elc Led,MI-GE-100","1145","standard","C128","251","831","1","1","1","7,200.00","7,200.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:11");
INSERT INTO products VALUES("1374","Elc Led,MI-GE-150","1146","standard","C128","251","831","1","1","1","12,500.00","12,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:11");
INSERT INTO products VALUES("1375","Elc Led,MI-GE-200","1147","standard","C128","251","831","1","1","1","23,000.00","23,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:11");
INSERT INTO products VALUES("1376","Elc Led,MI-MFX-10","1148","standard","C128","243","831","1","1","1","12,500.00","12,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:11");
INSERT INTO products VALUES("1377","Elc. lead,MG-10 ","1149","standard","C128","243","831","1","1","1","12,500.00","12,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:11");
INSERT INTO products VALUES("1378","Elc. lead,MG-100","1150","standard","C128","243","831","1","1","1","7,800.00","7,800.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:11");
INSERT INTO products VALUES("1379","M-G-100,.","1151","standard","C128","243","831","1","1","1","7,200.00","7,200.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:11");
INSERT INTO products VALUES("1380",".,G1XON-M","1152","standard","C128","42","831","1","1","1","6,500.00","6,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:11");
INSERT INTO products VALUES("1381","Elc Led,G1X FOUR Multi Effects","1153","standard","C128","42","831","1","1","1","8,500.00","8,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:11");
INSERT INTO products VALUES("1382","Elc Led,MI-GIX-Four","1154","standard","C128","42","831","1","1","1","7,500.00","7,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:11");
INSERT INTO products VALUES("1383","Elc. lead ,G1 on","1155","standard","C128","42","831","1","1","1","4,933.33","4,933.33","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:11");
INSERT INTO products VALUES("1384","Elc. lead,G1X 4 (FOUR)","1156","standard","C128","42","831","1","1","1","10,600.00","10,600.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:11");
INSERT INTO products VALUES("1385","Elc. lead,G1XN","1157","standard","C128","42","831","1","1","1","6,440.00","6,440.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:11");
INSERT INTO products VALUES("1386","Elc. lead,G1XON","1158","standard","C128","42","831","1","1","1","6,542.86","6,542.86","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:11");
INSERT INTO products VALUES("1387","Elc. lead,G3X ","1159","standard","C128","42","831","1","1","1","14,000.00","14,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:11");
INSERT INTO products VALUES("1388","Elc. lead,G3xn","1160","standard","C128","42","831","1","1","1","14,200.00","14,200.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:11");
INSERT INTO products VALUES("1389","Elc. lead,G5","1161","standard","C128","42","831","1","1","1","22,295.00","22,295.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:11");
INSERT INTO products VALUES("1390","Elc. lead,MS-50G","1162","standard","C128","42","831","1","1","1","8,645.00","8,645.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:11");
INSERT INTO products VALUES("1391","G 1_Four,.","1163","standard","C128","42","831","1","1","1","8,800.00","8,800.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:11");
INSERT INTO products VALUES("1392","Electric Guitar   ,Anisha","1166","standard","C128","39","833","1","1","1","50","50","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:11");
INSERT INTO products VALUES("1393","India,.","1346","standard","C128","39","838","1","1","1","13.08","13.08","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:13");
INSERT INTO products VALUES("1394","Normal,A046A","1168","standard","C128","95","834","1","1","1","600","600","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:11");
INSERT INTO products VALUES("1395","Normal,A046B","1169","standard","C128","95","834","1","1","1","650","650","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:11");
INSERT INTO products VALUES("1396","Normal,A046C","1170","standard","C128","95","834","1","1","1","900","900","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:11");
INSERT INTO products VALUES("1397","Big,.","2233","standard","C128","39","56","1","1","1","500","500","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:23");
INSERT INTO products VALUES("1398","Small,.","2235","standard","C128","39","56","1","1","1","80","80","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:23");
INSERT INTO products VALUES("1399","Acoustic,AG S-03","1175","standard","C128","184","835","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:12");
INSERT INTO products VALUES("1400","Acoustic,AGS-01","1176","standard","C128","184","835","1","1","1","750","750","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:12");
INSERT INTO products VALUES("1401","Plastic,S1","1177","standard","C128","253","835","1","1","1","900","900","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:12");
INSERT INTO products VALUES("1402","Plastic,FL-01 MDY","1178","standard","C128","214","835","1","1","1","1,000.00","1,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:12");
INSERT INTO products VALUES("1403","Plastic,S2","1179","standard","C128","223","835","1","1","1","1,000.00","1,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:12");
INSERT INTO products VALUES("1404","Plastic,S5","1180","standard","C128","223","835","1","1","1","1,000.00","1,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:12");
INSERT INTO products VALUES("1405","Plastic,S9 ","1181","standard","C128","223","835","1","1","1","900","900","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:12");
INSERT INTO products VALUES("1406","Good Quality,GS 401BB","1182","standard","C128","237","835","1","1","1","1,740.00","1,740.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:12");
INSERT INTO products VALUES("1407","Good Quality,GS 402 BB","1183","standard","C128","237","835","1","1","1","1,633.33","1,633.33","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:12");
INSERT INTO products VALUES("1408","3 Guitar,.","1184","standard","C128","254","835","1","1","1","2,000.00","2,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:12");
INSERT INTO products VALUES("1409","7 Guitar,.","1185","standard","C128","254","835","1","1","1","2,500.00","2,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:12");
INSERT INTO products VALUES("1410","Nine Guitar,.","1186","standard","C128","254","835","1","1","1","2,700.00","2,700.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:12");
INSERT INTO products VALUES("1411","Single,Q/HBK-JSM","1187","standard","C128","225","835","1","1","1","800","800","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:12");
INSERT INTO products VALUES("1412","Acoustic Guitar,Anisha","1188","standard","C128","39","835","1","1","1","750","750","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:12");
INSERT INTO products VALUES("1413","single,.","2214","standard","C128","39","943","1","1","1","42","42","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:23");
INSERT INTO products VALUES("1414","Elc & Ac,.","1190","standard","C128","59","835","1","1","1","900","900","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:12");
INSERT INTO products VALUES("1415","CITY,.","1192","standard","C128","256","835","1","1","1","750","750","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:12");
INSERT INTO products VALUES("1416","Triple ,Black","1193","standard","C128","62","835","1","1","1","3,180.00","3,180.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:12");
INSERT INTO products VALUES("1417","Fret Sticker,Rif.","1195","standard","C128","39","836","1","1","1","120","120","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:12");
INSERT INTO products VALUES("1418","Acoustic,.010 SUPER LIGHT","1310","standard","C128","41","837","1","1","1","113.04","113.04","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:13");
INSERT INTO products VALUES("1419","Deviser Colour,.","1198","standard","C128","44","837","1","1","1","150","150","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:12");
INSERT INTO products VALUES("1420","Fender,60CL","1199","standard","C128","44","837","1","1","1","110","110","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:12");
INSERT INTO products VALUES("1421","Acoustic,206","1200","standard","C128","95","837","1","1","1","99.44","99.44","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:12");
INSERT INTO products VALUES("1422","Acoustic,306","1201","standard","C128","95","837","1","1","1","100.35","100.35","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:12");
INSERT INTO products VALUES("1423","Acoustic,406","1202","standard","C128","95","837","1","1","1","82.16","82.16","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:12");
INSERT INTO products VALUES("1424","Acoustic,407","1203","standard","C128","95","837","1","1","1","124.55","124.55","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:12");
INSERT INTO products VALUES("1425","Acoustic Color String,A407C","1204","standard","C128","95","837","1","1","1","150","150","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:12");
INSERT INTO products VALUES("1426","Acoustic Color String,AW435C","1205","standard","C128","95","837","1","1","1","225","225","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:12");
INSERT INTO products VALUES("1427","Acoustic Loose,1 no","1334","standard","C128","231","837","1","1","1","15.52","15.52","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:13");
INSERT INTO products VALUES("1428","Acoustic Loose,2 no","1335","standard","C128","231","837","1","1","1","11.85","11.85","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:13");
INSERT INTO products VALUES("1429","Acoustic Loose,3 no","1336","standard","C128","231","837","1","1","1","19.24","19.24","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:13");
INSERT INTO products VALUES("1430","Acoustic Loose,4 no","1337","standard","C128","231","837","1","1","1","16.03","16.03","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:13");
INSERT INTO products VALUES("1431","Acoustic Loose,5 no","1338","standard","C128","231","837","1","1","1","18.59","18.59","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:13");
INSERT INTO products VALUES("1432","Acoustic Loose,6 no","1339","standard","C128","231","837","1","1","1","18.93","18.93","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:13");
INSERT INTO products VALUES("1433","Elc bass loose,1 no","1212","standard","C128","95","837","1","1","1","83.57","83.57","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:12");
INSERT INTO products VALUES("1434","Elc bass loose,2 no","1213","standard","C128","95","837","1","1","1","89.58","89.58","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:12");
INSERT INTO products VALUES("1435","Elc bass loose,3 no","1214","standard","C128","95","837","1","1","1","85","85","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:12");
INSERT INTO products VALUES("1436","Elc. Bass,4 String A-606","1215","standard","C128","95","837","1","1","1","500","500","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:12");
INSERT INTO products VALUES("1437","Elc. Bass,5 String","1240","standard","C128","244","837","1","1","1","950","950","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:12");
INSERT INTO products VALUES("1438","Elc. Bass,5 String A 606","1217","standard","C128","95","837","1","1","1","536.11","536.11","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:12");
INSERT INTO products VALUES("1439","Elc. Bass,A606","1218","standard","C128","95","837","1","1","1","375","375","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:12");
INSERT INTO products VALUES("1440","Elc. lead,506p","1219","standard","C128","95","837","1","1","1","109.57","109.57","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:12");
INSERT INTO products VALUES("1441","Elc. lead,A503 (X)","1220","standard","C128","95","837","1","1","1","89.17","89.17","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:12");
INSERT INTO products VALUES("1442","Elc. Loose,1 no","1221","standard","C128","95","837","1","1","1","15.98","15.98","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:12");
INSERT INTO products VALUES("1443","Elc. Loose,2 no","1222","standard","C128","95","837","1","1","1","15.38","15.38","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:12");
INSERT INTO products VALUES("1444","Elc. Loose,3 no","1223","standard","C128","95","837","1","1","1","19.68","19.68","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:12");
INSERT INTO products VALUES("1445","Elc. Loose,4 no","1224","standard","C128","95","837","1","1","1","15","15","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:12");
INSERT INTO products VALUES("1446","Elc. Loose,5 no","1225","standard","C128","95","837","1","1","1","18","18","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:12");
INSERT INTO products VALUES("1447","Elc. Loose,6 no","1226","standard","C128","95","837","1","1","1","18.64","18.64","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:12");
INSERT INTO products VALUES("1448","Nylon String,A106","1227","standard","C128","95","837","1","1","1","148.07","148.07","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:12");
INSERT INTO products VALUES("1449","Acoustic,A-011","1228","standard","C128","82","837","1","1","1","85.6","85.6","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:12");
INSERT INTO products VALUES("1450","Acoustic,Box Capo","1229","standard","C128","82","837","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:12");
INSERT INTO products VALUES("1451","Acoustic,Anisha-EZ890","1231","standard","C128","244","837","1","1","1","190","190","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:12");
INSERT INTO products VALUES("1452","Acoustic,Anisha-EZ900","1232","standard","C128","244","837","1","1","1","190","190","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:12");
INSERT INTO products VALUES("1453","Acoustic,EXP 26 (Coated Phosphor Bronze)","1233","standard","C128","244","837","1","1","1","242.86","242.86","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:12");
INSERT INTO products VALUES("1454","Acoustic,EXP-16 ","1234","standard","C128","244","837","1","1","1","300","300","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:12");
INSERT INTO products VALUES("1455","Acoustic,EZ 920","1235","standard","C128","244","837","1","1","1","252.5","252.5","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:12");
INSERT INTO products VALUES("1456","Acoustic,EZ900","1236","standard","C128","244","837","1","1","1","226.4","226.4","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:12");
INSERT INTO products VALUES("1457","Acoustic,Ez910","1237","standard","C128","244","837","1","1","1","235.44","235.44","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:12");
INSERT INTO products VALUES("1458","Acoustic 12 String,EJ-39","1238","standard","C128","244","837","1","1","1","1,095.00","1,095.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:12");
INSERT INTO products VALUES("1459","Elc. Bass,4 String   ","1239","standard","C128","244","837","1","1","1","850","850","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:12");
INSERT INTO products VALUES("1460","Elc. Bass,exl120-7","1241","standard","C128","244","837","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:12");
INSERT INTO products VALUES("1461","Elc. Bass,EXL170","1242","standard","C128","244","837","1","1","1","850","850","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:12");
INSERT INTO products VALUES("1462","Elc. Bass,EXL170-5","1243","standard","C128","244","837","1","1","1","1,500.00","1,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:12");
INSERT INTO products VALUES("1463","Elc. lead,EXL110","1245","standard","C128","244","837","1","1","1","231.21","231.21","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:12");
INSERT INTO products VALUES("1464","Elc. lead,EXL120","1246","standard","C128","244","837","1","1","1","229.72","229.72","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:12");
INSERT INTO products VALUES("1465","Elc. lead,EXL120-7","1247","standard","C128","244","837","1","1","1","650","650","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:12");
INSERT INTO products VALUES("1466","Nylon String,EJ-49","1248","standard","C128","244","837","1","1","1","320","320","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:12");
INSERT INTO products VALUES("1467","Nylon String,EJ27N","1249","standard","C128","244","837","1","1","1","320","320","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:12");
INSERT INTO products VALUES("1468","Nylon String,EJ45","1250","standard","C128","244","837","1","1","1","350","350","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:12");
INSERT INTO products VALUES("1469","Nylon String,JSM-EJ45","1251","standard","C128","244","837","1","1","1","350","350","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:12");
INSERT INTO products VALUES("1470","Acoustic,PX-A30","1253","standard","C128","142","837","1","1","1","100","100","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:12");
INSERT INTO products VALUES("1471","Acoustic,DM-80","1254","standard","C128","51","837","1","1","1","68","68","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:12");
INSERT INTO products VALUES("1472","Electric,.","1255","standard","C128","258","837","1","1","1","475","475","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:12");
INSERT INTO products VALUES("1473","Electric,elixer-19002","1256","standard","C128","258","837","1","1","1","1,150.00","1,150.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:12");
INSERT INTO products VALUES("1474","Electric,ELIXER-19052","1257","standard","C128","258","837","1","1","1","1,150.00","1,150.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:12");
INSERT INTO products VALUES("1475","Acoustic,10-50","1258","standard","C128","259","837","1","1","1","343.68","343.68","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:12");
INSERT INTO products VALUES("1476","Acoustic,11 Gauge","1259","standard","C128","259","837","1","1","1","365","365","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:12");
INSERT INTO products VALUES("1477","Acoustic,12 Gauge","1260","standard","C128","259","837","1","1","1","365","365","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:53","2024-01-10 15:01:12");
INSERT INTO products VALUES("1478","Elc. lead,2220","1261","standard","C128","259","837","1","1","1","365","365","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:54","2024-01-10 15:01:12");
INSERT INTO products VALUES("1479","Elc. lead,2221","1262","standard","C128","259","837","1","1","1","318.33","318.33","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:54","2024-01-10 15:01:12");
INSERT INTO products VALUES("1480","Elc. lead,2222","1263","standard","C128","259","837","1","1","1","365","365","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:54","2024-01-10 15:01:12");
INSERT INTO products VALUES("1481","Elc. lead,2223","1264","standard","C128","259","837","1","1","1","300","300","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:54","2024-01-10 15:01:12");
INSERT INTO products VALUES("1482","Acoustic,60XL (City)","1265","standard","C128","148","837","1","1","1","300","300","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:54","2024-01-10 15:01:12");
INSERT INTO products VALUES("1483","Acoustic,70xL","1266","standard","C128","148","837","1","1","1","85","85","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:54","2024-01-10 15:01:12");
INSERT INTO products VALUES("1484","Acoustic  Guitar,B","1267","standard","C128","148","837","1","1","1","80","80","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:54","2024-01-10 15:01:12");
INSERT INTO products VALUES("1485","Acoustic Guitar,.011-.052","1269","standard","C128","148","837","1","1","1","105","105","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:54","2024-01-10 15:01:12");
INSERT INTO products VALUES("1486","Elc. lead,City .010-.046","1274","standard","C128","148","837","1","1","1","300","300","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:54","2024-01-10 15:01:13");
INSERT INTO products VALUES("1487","Elc Led,10 Super Ultra Light","1276","standard","C128","197","837","1","1","1","300","300","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:54","2024-01-10 15:01:13");
INSERT INTO products VALUES("1488","Elc Led,11 Medium Light","1277","standard","C128","197","837","1","1","1","285.67","285.67","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:54","2024-01-10 15:01:13");
INSERT INTO products VALUES("1489","Elc Led,9 Ultra Light","1278","standard","C128","197","837","1","1","1","275.43","275.43","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:54","2024-01-10 15:01:13");
INSERT INTO products VALUES("1490","Hawaiian Guitar Acoustic,Indian","1280","standard","C128","260","837","1","1","1","250","250","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:54","2024-01-10 15:01:13");
INSERT INTO products VALUES("1491","Hawaiian Guitar Electric,Indian","1281","standard","C128","260","837","1","1","1","250","250","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:54","2024-01-10 15:01:13");
INSERT INTO products VALUES("1492","Acoustic,LA-11","1282","standard","C128","200","837","1","1","1","260","260","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:54","2024-01-10 15:01:13");
INSERT INTO products VALUES("1493","Elc Led,LE-09","1283","standard","C128","200","837","1","1","1","260","260","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:54","2024-01-10 15:01:13");
INSERT INTO products VALUES("1494","Acoustic,Full Set Bronze","1284","standard","C128","39","837","1","1","1","82","82","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:54","2024-01-10 15:01:13");
INSERT INTO products VALUES("1495","Acoustic,Full Set Golden","1285","standard","C128","39","837","1","1","1","82","82","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:54","2024-01-10 15:01:13");
INSERT INTO products VALUES("1496","Acoustic Loose,Anisha-01 Loose","1286","standard","C128","39","837","1","1","1","12","12","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:54","2024-01-10 15:01:13");
INSERT INTO products VALUES("1497","Acoustic Loose,Anisha-03 Loose","1287","standard","C128","39","837","1","1","1","15","15","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:54","2024-01-10 15:01:13");
INSERT INTO products VALUES("1498","Acoustic,Extra Light ","1288","standard","C128","261","837","1","1","1","150","150","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:54","2024-01-10 15:01:13");
INSERT INTO products VALUES("1499","Acoustic,RX 15 JSM","1289","standard","C128","261","837","1","1","1","80","80","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:54","2024-01-10 15:01:13");
INSERT INTO products VALUES("1500","Acoustic,TX620","1290","standard","C128","261","837","1","1","1","95.57","95.57","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:54","2024-01-10 15:01:13");
INSERT INTO products VALUES("1501","Acoustic,TX630","1291","standard","C128","261","837","1","1","1","85.59","85.59","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:54","2024-01-10 15:01:13");
INSERT INTO products VALUES("1502","Acoustic,TX640","1292","standard","C128","261","837","1","1","1","86.24","86.24","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:54","2024-01-10 15:01:13");
INSERT INTO products VALUES("1503","Elc. Bass,Vx120-4 String","1296","standard","C128","261","837","1","1","1","400","400","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:54","2024-01-10 15:01:13");
INSERT INTO products VALUES("1504","Elc. lead,DE-2X","1297","standard","C128","261","837","1","1","1","200","200","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:54","2024-01-10 15:01:13");
INSERT INTO products VALUES("1505","Elc. lead,LE25","1298","standard","C128","261","837","1","1","1","195.45","195.45","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:54","2024-01-10 15:01:13");
INSERT INTO products VALUES("1506","Elc. lead,RX-15","1299","standard","C128","261","837","1","1","1","120","120","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:54","2024-01-10 15:01:13");
INSERT INTO products VALUES("1507","Elc. Loose,LE25-2 no","1300","standard","C128","261","837","1","1","1","15","15","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:54","2024-01-10 15:01:13");
INSERT INTO products VALUES("1508","Elc. Loose,LeE25-1 no","1301","standard","C128","261","837","1","1","1","12","12","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:54","2024-01-10 15:01:13");
INSERT INTO products VALUES("1509","Acoustic,Light Gauge","1302","standard","C128","262","837","1","1","1","94.95","94.95","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:54","2024-01-10 15:01:13");
INSERT INTO products VALUES("1510","Acoustic Loose,1no.","1303","standard","C128","262","837","1","1","1","11.25","11.25","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:54","2024-01-10 15:01:13");
INSERT INTO products VALUES("1511","Acoustic Loose,2no.","1304","standard","C128","262","837","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:54","2024-01-10 15:01:13");
INSERT INTO products VALUES("1512","Acoustic Loose,3 no.","1305","standard","C128","262","837","1","1","1","15","15","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:54","2024-01-10 15:01:13");
INSERT INTO products VALUES("1513","Acoustic Color String,SA18","1306","standard","C128","263","837","1","1","1","210","210","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:54","2024-01-10 15:01:13");
INSERT INTO products VALUES("1514","Acoustic,RX-A30 (.011-.050)","1307","standard","C128","174","837","1","1","1","140","140","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:54","2024-01-10 15:01:13");
INSERT INTO products VALUES("1515","Acoustic,.010/.048","1312","standard","C128","231","837","1","1","1","104.44","104.44","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:54","2024-01-10 15:01:13");
INSERT INTO products VALUES("1516","Elc. lead,.009/.042","1309","standard","C128","264","837","1","1","1","334.55","334.55","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:54","2024-01-10 15:01:13");
INSERT INTO products VALUES("1517"," Electric 5 String,.","1311","standard","C128","231","837","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:54","2024-01-10 15:01:13");
INSERT INTO products VALUES("1518","Acoustic,.011-.050","1313","standard","C128","231","837","1","1","1","70","70","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:54","2024-01-10 15:01:13");
INSERT INTO products VALUES("1519","Acoustic,Anisha DAG-010","1314","standard","C128","231","837","1","1","1","93.76","93.76","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:54","2024-01-10 15:01:13");
INSERT INTO products VALUES("1520","Acoustic,Anisha DAG-011","1315","standard","C128","231","837","1","1","1","70","70","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:54","2024-01-10 15:01:13");
INSERT INTO products VALUES("1521","Acoustic,Anisha DCZ-011","1316","standard","C128","231","837","1","1","1","200","200","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:54","2024-01-10 15:01:13");
INSERT INTO products VALUES("1522","Acoustic,Anisha DCZ-012","1317","standard","C128","231","837","1","1","1","180","180","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:54","2024-01-10 15:01:13");
INSERT INTO products VALUES("1523","Acoustic,Anisha DN-009","1318","standard","C128","231","837","1","1","1","180","180","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:54","2024-01-10 15:01:13");
INSERT INTO products VALUES("1524","Acoustic,Anisha DP-011","1319","standard","C128","231","837","1","1","1","200","200","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:54","2024-01-10 15:01:13");
INSERT INTO products VALUES("1525","Acoustic,Anisha DP-012","1320","standard","C128","231","837","1","1","1","180","180","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:54","2024-01-10 15:01:13");
INSERT INTO products VALUES("1526","Acoustic,Anisha DUS-010","1321","standard","C128","231","837","1","1","1","180","180","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:54","2024-01-10 15:01:13");
INSERT INTO products VALUES("1527","Acoustic,Anisha DUS-011","1322","standard","C128","231","837","1","1","1","180","180","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:54","2024-01-10 15:01:13");
INSERT INTO products VALUES("1528","Acoustic,Anisha-DCZ-010","1323","standard","C128","231","837","1","1","1","200","200","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:54","2024-01-10 15:01:13");
INSERT INTO products VALUES("1529","Acoustic,Anisha-DR-010","1324","standard","C128","231","837","1","1","1","290","290","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:54","2024-01-10 15:01:13");
INSERT INTO products VALUES("1530","Acoustic,City-DAG-010","1325","standard","C128","231","837","1","1","1","107.99","107.99","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:54","2024-01-10 15:01:13");
INSERT INTO products VALUES("1531","Acoustic,City-DAG-011","1326","standard","C128","231","837","1","1","1","90","90","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:54","2024-01-10 15:01:13");
INSERT INTO products VALUES("1532","Acoustic,City-DEG-009","1327","standard","C128","231","837","1","1","1","90","90","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:54","2024-01-10 15:01:13");
INSERT INTO products VALUES("1533","Acoustic,City-DP-010","1328","standard","C128","231","837","1","1","1","170","170","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:54","2024-01-10 15:01:13");
INSERT INTO products VALUES("1534","Acoustic,City-DP-011","1329","standard","C128","231","837","1","1","1","155.29","155.29","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:54","2024-01-10 15:01:13");
INSERT INTO products VALUES("1535","Acoustic,COPPER","1330","standard","C128","231","837","1","1","1","80","80","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:54","2024-01-10 15:01:13");
INSERT INTO products VALUES("1536","Acoustic,CUSTOM LIGHT","1331","standard","C128","231","837","1","1","1","118.42","118.42","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:54","2024-01-10 15:01:13");
INSERT INTO products VALUES("1537","Acoustic,DUS-010","1332","standard","C128","231","837","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:54","2024-01-10 15:01:13");
INSERT INTO products VALUES("1538","Acoustic,Labu-DCZ-010","1333","standard","C128","231","837","1","1","1","136.36","136.36","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:54","2024-01-10 15:01:13");
INSERT INTO products VALUES("1539","Elc Led,DEG-009 City","1340","standard","C128","231","837","1","1","1","85","85","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:54","2024-01-10 15:01:13");
INSERT INTO products VALUES("1540","Elc. Bass 5 string,","1342","standard","C128","231","837","1","1","1","500","500","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:54","2024-01-10 15:01:13");
INSERT INTO products VALUES("1541","extra light,Special","1343","standard","C128","231","837","1","1","1","150","150","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:54","2024-01-10 15:01:13");
INSERT INTO products VALUES("1542","elc ,.","1345","standard","C128","39","838","1","1","1","50","50","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:54","2024-01-10 15:01:13");
INSERT INTO products VALUES("1543","AT-2,CHROMATIC","1347","standard","C128","95","839","1","1","1","420","420","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:54","2024-01-10 15:01:13");
INSERT INTO products VALUES("1544","Digital,AMT-530","1348","standard","C128","184","839","1","1","1","812.5","812.5","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:54","2024-01-10 15:01:13");
INSERT INTO products VALUES("1545","Digital,AT 200D","1349","standard","C128","184","839","1","1","1","320","320","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:54","2024-01-10 15:01:13");
INSERT INTO products VALUES("1546","Digital,AT101","1350","standard","C128","184","839","1","1","1","384.37","384.37","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:54","2024-01-10 15:01:13");
INSERT INTO products VALUES("1547","Digital,JSM-AT-01 A","1351","standard","C128","184","839","1","1","1","370","370","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:54","2024-01-10 15:01:13");
INSERT INTO products VALUES("1548","Digital,DM-128","1352","standard","C128","51","839","1","1","1","350","350","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:13");
INSERT INTO products VALUES("1549","Digital,EMT-330","1353","standard","C128","265","839","1","1","1","1,000.00","1,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:13");
INSERT INTO products VALUES("1550","Digital,ET-3100","1354","standard","C128","265","839","1","1","1","800","800","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:13");
INSERT INTO products VALUES("1551","Digital,ET-33","1355","standard","C128","265","839","1","1","1","450","450","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:13");
INSERT INTO products VALUES("1552","Digital cromatic,et-02","1356","standard","C128","266","839","1","1","1","480","480","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:13");
INSERT INTO products VALUES("1553","Digital,FT-009","1357","standard","C128","223","839","1","1","1","550","550","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:13");
INSERT INTO products VALUES("1554","Digital,FT-119","1358","standard","C128","223","839","1","1","1","650","650","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:13");
INSERT INTO products VALUES("1555","Digital,FT-12","1359","standard","C128","223","839","1","1","1","700","700","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:13");
INSERT INTO products VALUES("1556","Digital,FT-13","1360","standard","C128","223","839","1","1","1","550","550","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:13");
INSERT INTO products VALUES("1557","Digital,FT-2001","1361","standard","C128","223","839","1","1","1","600","600","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:13");
INSERT INTO products VALUES("1558","Digital,FT-23","1362","standard","C128","223","839","1","1","1","566.67","566.67","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:13");
INSERT INTO products VALUES("1559","Digital,FT-66","1363","standard","C128","223","839","1","1","1","550","550","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:13");
INSERT INTO products VALUES("1560","Digital,FT-700","1364","standard","C128","223","839","1","1","1","550","550","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:13");
INSERT INTO products VALUES("1561","Digital,FT-8000","1365","standard","C128","223","839","1","1","1","650","650","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:13");
INSERT INTO products VALUES("1562","Digital,FT-Q3","1366","standard","C128","223","839","1","1","1","650","650","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:13");
INSERT INTO products VALUES("1563","Rechargable Touch,FMT-2013","1367","standard","C128","223","839","1","1","1","2,250.00","2,250.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:13");
INSERT INTO products VALUES("1564","Digital,JMT-01","1368","standard","C128","250","839","1","1","1","406.25","406.25","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:13");
INSERT INTO products VALUES("1565","Digital,JT-01","1369","standard","C128","250","839","1","1","1","326.67","326.67","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:13");
INSERT INTO products VALUES("1566","Digital,JT-06","1370","standard","C128","250","839","1","1","1","350","350","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:13");
INSERT INTO products VALUES("1567","Digital,T-20","1371","standard","C128","227","839","1","1","1","650","650","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:13");
INSERT INTO products VALUES("1568","Digital,T-26","1372","standard","C128","227","839","1","1","1","650","650","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:13");
INSERT INTO products VALUES("1569","Digital,T-29C","1373","standard","C128","227","839","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:13");
INSERT INTO products VALUES("1570","Digital,T-29G","1374","standard","C128","227","839","1","1","1","550","550","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:13");
INSERT INTO products VALUES("1571","Digital,T-5S","1375","standard","C128","227","839","1","1","1","550","550","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:13");
INSERT INTO products VALUES("1572","Digital,CT-117","1376","standard","C128","39","839","1","1","1","500","500","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:13");
INSERT INTO products VALUES("1573","Digital,Malay-China","1377","standard","C128","39","839","1","1","1","342","342","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:13");
INSERT INTO products VALUES("1574","Digital,JSM T-11","1378","standard","C128","207","839","1","1","1","350","350","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:13");
INSERT INTO products VALUES("1575","Digital,ZT-03","1379","standard","C128","65","839","1","1","1","516.15","516.15","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:13");
INSERT INTO products VALUES("1576","Normal,City-UG-30S","1380","standard","C128","267","840","1","1","1","4,000.00","4,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:14");
INSERT INTO products VALUES("1577","Normal,JSM-UKG-B","1382","standard","C128","161","840","1","1","1","4,500.00","4,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:14");
INSERT INTO products VALUES("1578","Normal,NR N","1383","standard","C128","269","840","1","1","1","4,200.00","4,200.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:14");
INSERT INTO products VALUES("1579","Normal,CITY ","1727","standard","C128","363","879","1","1","1","1,900.00","1,900.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:18");
INSERT INTO products VALUES("1580","Normal,GU-2813","1385","standard","C128","271","840","1","1","1","4,200.00","4,200.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:14");
INSERT INTO products VALUES("1581","Normal,GU-2818","1386","standard","C128","271","840","1","1","1","4,200.00","4,200.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:14");
INSERT INTO products VALUES("1582","Aktara,Wooden   ","1387","standard","C128","43","841","1","1","1","160","160","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:14");
INSERT INTO products VALUES("1583","Guitar ,Small","1388","standard","C128","39","841","1","1","1","175","175","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:14");
INSERT INTO products VALUES("1584","Lamp,Midium ","1389","standard","C128","39","841","1","1","1","750","750","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:14");
INSERT INTO products VALUES("1585","Stereo Recording,H1n","1390","standard","C128","42","842","1","1","1","12,000.00","12,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:14");
INSERT INTO products VALUES("1586","Single Scale,C Scale 28 Holes","1391","standard","C128","272","843","1","1","1","850","850","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:14");
INSERT INTO products VALUES("1587","Single Scale,10 Hole Black","1392","standard","C128","273","843","1","1","1","178","178","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:14");
INSERT INTO products VALUES("1588","Single Scale,10 Hole Golden","1418","standard","C128","280","843","1","1","1","547","547","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:14");
INSERT INTO products VALUES("1589","Single Scale,10 Hole Red","1394","standard","C128","273","843","1","1","1","178","178","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:14");
INSERT INTO products VALUES("1590","Single Scale,10 Hole Silver","1395","standard","C128","273","843","1","1","1","178","178","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:14");
INSERT INTO products VALUES("1591","Diatonic 16 Holes,C Scale","1396","standard","C128","51","843","1","1","1","1,100.00","1,100.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:14");
INSERT INTO products VALUES("1592","DM-10B,","1397","standard","C128","51","843","1","1","1","350","350","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:14");
INSERT INTO products VALUES("1593","DM-10B,Single Scale","1398","standard","C128","51","843","1","1","1","399.35","399.35","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:14");
INSERT INTO products VALUES("1594","DM-24B,.","1399","standard","C128","51","843","1","1","1","585.71","585.71","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:14");
INSERT INTO products VALUES("1595","DM-24B-JSM,.","1400","standard","C128","51","843","1","1","1","600","600","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:14");
INSERT INTO products VALUES("1596","DM-24B-S.T.I,DM-24B-S.T.I","1401","standard","C128","51","843","1","1","1","600","600","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:14");
INSERT INTO products VALUES("1597","Single Scale,C Scale","1413","standard","C128","279","843","1","1","1","1,800.00","1,800.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:14");
INSERT INTO products VALUES("1598","Chromatic-Forerunner,1248NV-12Holes","1403","standard","C128","274","843","1","1","1","3,400.00","3,400.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:14");
INSERT INTO products VALUES("1599","Chromatic-MDY, T10-40 - 10 Holes","1404","standard","C128","274","843","1","1","1","3,000.00","3,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:14");
INSERT INTO products VALUES("1600","Single Scale C- 10 Holes,MDY-T-10-4","1406","standard","C128","274","843","1","1","1","300","300","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:14");
INSERT INTO products VALUES("1601","Single Scale C-22 Holes,MDY-T22K","1407","standard","C128","274","843","1","1","1","1,500.00","1,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:14");
INSERT INTO products VALUES("1602","10 HOLE,.","1408","standard","C128","275","843","1","1","1","450","450","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:14");
INSERT INTO products VALUES("1603","24 hole,.","1433","standard","C128","287","843","1","1","1","500","500","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:14");
INSERT INTO products VALUES("1604","Single Small,C Scale Silverstar","1414","standard","C128","279","843","1","1","1","1,200.00","1,200.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:14");
INSERT INTO products VALUES("1605","Single Small,E Scale Silverstar","1415","standard","C128","279","843","1","1","1","1,400.00","1,400.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:14");
INSERT INTO products VALUES("1606","Single Small,F Scale Silverstar","1416","standard","C128","279","843","1","1","1","1,400.00","1,400.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:14");
INSERT INTO products VALUES("1607","Single Small,G Scale Silverstar","1417","standard","C128","279","843","1","1","1","1,400.00","1,400.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:14");
INSERT INTO products VALUES("1608","Chromatic,.","1459","standard","C128","290","843","1","1","1","850","850","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:14");
INSERT INTO products VALUES("1609","Single Scale,.","1425","standard","C128","285","843","1","1","1","450","450","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:14");
INSERT INTO products VALUES("1610","Single Small,C Scale","1455","standard","C128","62","843","1","1","1","480","480","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:14");
INSERT INTO products VALUES("1611","Diatonic 10 Hole,1072 (C Scale)","1426","standard","C128","286","843","1","1","1","400","400","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:14");
INSERT INTO products VALUES("1612","Tremolo 24 H,.","1427","standard","C128","286","843","1","1","1","700","700","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:14");
INSERT INTO products VALUES("1613","Winner, 16  holes","1428","standard","C128","286","843","1","1","1","500","500","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:14");
INSERT INTO products VALUES("1614",",senior PH 21","1449","standard","C128","288","843","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:14");
INSERT INTO products VALUES("1615","10 HOLE,JSM","1430","standard","C128","287","843","1","1","1","450","450","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:14");
INSERT INTO products VALUES("1616","21 Hole,.","1431","standard","C128","287","843","1","1","1","1,400.00","1,400.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:14");
INSERT INTO products VALUES("1617","24 hole,-S.T.I-C","1432","standard","C128","287","843","1","1","1","675","675","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:14");
INSERT INTO products VALUES("1618","24 hole,JSM-C","1434","standard","C128","287","843","1","1","1","750","750","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:14");
INSERT INTO products VALUES("1619","24 hole,S.T.I-A","1435","standard","C128","287","843","1","1","1","600","600","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:14");
INSERT INTO products VALUES("1620","24 hole,S.T.I-B","1436","standard","C128","287","843","1","1","1","600","600","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:14");
INSERT INTO products VALUES("1621","24 hole,S.T.I-D","1437","standard","C128","287","843","1","1","1","600","600","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:14");
INSERT INTO products VALUES("1622","24 hole,S.T.I-F","1438","standard","C128","287","843","1","1","1","600","600","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:14");
INSERT INTO products VALUES("1623","24 hole,S.T.I-G","1439","standard","C128","287","843","1","1","1","600","600","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:14");
INSERT INTO products VALUES("1624","Chromatic,SW-1040","1440","standard","C128","287","843","1","1","1","3,166.67","3,166.67","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:14");
INSERT INTO products VALUES("1625","Chromatic,SW-1248","1441","standard","C128","287","843","1","1","1","4,500.00","4,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:14");
INSERT INTO products VALUES("1626","Chromatic,SW-1664","1442","standard","C128","287","843","1","1","1","5,000.00","5,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:14");
INSERT INTO products VALUES("1627","Double Scale,.","1443","standard","C128","287","843","1","1","1","1,800.00","1,800.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:14");
INSERT INTO products VALUES("1628","Double Scale,senior PH 21","1444","standard","C128","287","843","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:14");
INSERT INTO products VALUES("1629","Single Small,D Scale","1456","standard","C128","62","843","1","1","1","470","470","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:14");
INSERT INTO products VALUES("1630","Single Small,E Scale","1457","standard","C128","62","843","1","1","1","480","480","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:14");
INSERT INTO products VALUES("1631","Single Small,G Scale  ","1448","standard","C128","287","843","1","1","1","300","300","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:14");
INSERT INTO products VALUES("1632","24 hole,senior PH 21","1450","standard","C128","288","843","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:14");
INSERT INTO products VALUES("1633","Single Scale,B","1452","standard","C128","62","843","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:14");
INSERT INTO products VALUES("1634","Single Scale,F","1453","standard","C128","62","843","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:14");
INSERT INTO products VALUES("1635","Single Small,B","1454","standard","C128","62","843","1","1","1","450","450","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:14");
INSERT INTO products VALUES("1636","Single Small,F","1458","standard","C128","62","843","1","1","1","450","450","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:14");
INSERT INTO products VALUES("1637","Chromatic-MDY,MDY-M1015","1460","standard","C128","290","843","1","1","1","800","800","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:14");
INSERT INTO products VALUES("1638","Chromatic,UC.","1461","standard","C128","291","843","1","1","1","1,100.00","1,100.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:14");
INSERT INTO products VALUES("1639","Single Scale,C Scale 24 Holes","1462","standard","C128","292","843","1","1","1","1,000.00","1,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:14");
INSERT INTO products VALUES("1640","HH-001,.","1464","standard","C128","39","845","1","1","1","700","700","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:14");
INSERT INTO products VALUES("1641","3 Octave,.","1465","standard","C128","81","846","1","1","1","11,000.00","11,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:55","2024-01-10 15:01:14");
INSERT INTO products VALUES("1642","3 Octave New,3 Octave New","1466","standard","C128","293","846","1","1","1","14,000.00","14,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:14");
INSERT INTO products VALUES("1643","German Key,Khara Pata","1467","standard","C128","39","846","1","1","1","12,000.00","12,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:14");
INSERT INTO products VALUES("1644","Normal,Pata Pata","1468","standard","C128","39","846","1","1","1","8,760.00","8,760.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:14");
INSERT INTO products VALUES("1645","Platinum,Khara Pata","1469","standard","C128","39","846","1","1","1","10,500.00","10,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:14");
INSERT INTO products VALUES("1646","Platinum,Pata Pata","1470","standard","C128","39","846","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:14");
INSERT INTO products VALUES("1647","Scale Changer,.","1471","standard","C128","39","846","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:15");
INSERT INTO products VALUES("1648","Electric,Mdy  ","1472","standard","C128","294","847","1","1","1","10,500.00","10,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:15");
INSERT INTO products VALUES("1649","Studio ,ATH M-30X","1473","standard","C128","295","848","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:15");
INSERT INTO products VALUES("1650","Studio ,ATH M-40X","1474","standard","C128","295","848","1","1","1","8,500.00","8,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:15");
INSERT INTO products VALUES("1651","Studio ,ATH-M-20X","1475","standard","C128","295","848","1","1","1","4,800.00","4,800.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:15");
INSERT INTO products VALUES("1652","Studio ,ATH-T200","1476","standard","C128","295","848","1","1","1","2,730.00","2,730.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:15");
INSERT INTO products VALUES("1653","Studio ,m50x","1477","standard","C128","295","848","1","1","1","11,000.00","11,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:15");
INSERT INTO products VALUES("1654","Gaming,CH-6100","1478","standard","C128","296","848","1","1","1","380","380","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:15");
INSERT INTO products VALUES("1655","Stereo HeadPhone,CH-6099","1479","standard","C128","296","848","1","1","1","380","380","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:15");
INSERT INTO products VALUES("1656","Studio  ,Labu_Extra 10","1480","standard","C128","297","848","1","1","1","5,500.00","5,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:15");
INSERT INTO products VALUES("1657","Normal,05A","1481","standard","C128","120","848","1","1","1","950","950","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:15");
INSERT INTO products VALUES("1658","Normal,HS-300N","1482","standard","C128","120","848","1","1","1","400","400","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:15");
INSERT INTO products VALUES("1659","Bluetooth,H2519BT","1483","standard","C128","121","848","1","1","1","1,950.00","1,950.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:15");
INSERT INTO products VALUES("1660","Bluetooth,HV-H-2558 BT","1484","standard","C128","121","848","1","1","1","950","950","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:15");
INSERT INTO products VALUES("1661","Bluetooth,HV-H2556BT","1485","standard","C128","121","848","1","1","1","1,250.00","1,250.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:15");
INSERT INTO products VALUES("1662","Bluetooth,HV-H2561BT","1486","standard","C128","121","848","1","1","1","950","950","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:15");
INSERT INTO products VALUES("1663","Normal,H2093d","1487","standard","C128","121","848","1","1","1","575","575","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:15");
INSERT INTO products VALUES("1664","Normal,H2098d","1488","standard","C128","121","848","1","1","1","750","750","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:15");
INSERT INTO products VALUES("1665","Normal,H2106d","1489","standard","C128","121","848","1","1","1","400","400","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:15");
INSERT INTO products VALUES("1666","Normal,H2116d","1490","standard","C128","121","848","1","1","1","425","425","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:15");
INSERT INTO products VALUES("1667","Normal,H328F","1491","standard","C128","121","848","1","1","1","925","925","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:15");
INSERT INTO products VALUES("1668","Normal,H611d","1492","standard","C128","121","848","1","1","1","575","575","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:15");
INSERT INTO products VALUES("1669","Normal,H61M","1493","standard","C128","121","848","1","1","1","650","650","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:15");
INSERT INTO products VALUES("1670","normal,HP610","1494","standard","C128","121","848","1","1","1","575","575","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:15");
INSERT INTO products VALUES("1671","normal,HV-H2068d","1495","standard","C128","121","848","1","1","1","485","485","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:15");
INSERT INTO products VALUES("1672","normal,HV-H2069d","1496","standard","C128","121","848","1","1","1","200","200","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:15");
INSERT INTO products VALUES("1673","Normal,HV-H2072d","1497","standard","C128","121","848","1","1","1","425","425","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:15");
INSERT INTO products VALUES("1674","normal,HV-ST063","1498","standard","C128","121","848","1","1","1","410","410","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:15");
INSERT INTO products VALUES("1675","Normal,HV-ST137","1499","standard","C128","121","848","1","1","1","250","250","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:15");
INSERT INTO products VALUES("1676","normal,ST129","1500","standard","C128","121","848","1","1","1","390","390","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:15");
INSERT INTO products VALUES("1677","Normal,ST520","1501","standard","C128","121","848","1","1","1","275","275","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:15");
INSERT INTO products VALUES("1678","USB,INTEX(m-888u)","1502","standard","C128","121","848","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:15");
INSERT INTO products VALUES("1679","USB,m-888u","1503","standard","C128","298","848","1","1","1","700","700","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:15");
INSERT INTO products VALUES("1680","Bluetooth,68","1504","standard","C128","299","848","1","1","1","850","850","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:15");
INSERT INTO products VALUES("1681","Bluetooth,V-685","1505","standard","C128","299","848","1","1","1","870","870","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:15");
INSERT INTO products VALUES("1682","Stereo ,JH-0808","1506","standard","C128","300","848","1","1","1","150","150","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:15");
INSERT INTO products VALUES("1683","Stereo ,h151","1507","standard","C128","301","848","1","1","1","1,190.00","1,190.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:15");
INSERT INTO products VALUES("1684","Studio ,Studio Pro 10 ","1509","standard","C128","303","848","1","1","1","2,200.00","2,200.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:15");
INSERT INTO products VALUES("1685","Studio ,JSM-HDJ-1000","1510","standard","C128","304","848","1","1","1","2,800.00","2,800.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:15");
INSERT INTO products VALUES("1686","Bluetooth,MDR-XBoo1BT","1511","standard","C128","305","848","1","1","1","820","820","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:15");
INSERT INTO products VALUES("1687","Professional Monitor,HD671","1512","standard","C128","306","848","1","1","1","3,150.00","3,150.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:15");
INSERT INTO products VALUES("1688","Professional Monitor,HD681","1513","standard","C128","306","848","1","1","1","2,400.00","2,400.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:15");
INSERT INTO products VALUES("1689","Professional Monitor,HD681B","1514","standard","C128","306","848","1","1","1","2,400.00","2,400.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:15");
INSERT INTO products VALUES("1690","Bluetooth,S970","1515","standard","C128","307","848","1","1","1","1,150.00","1,150.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:15");
INSERT INTO products VALUES("1691","14 inch,101","1516","standard","C128","97","849","1","1","1","5,642.00","5,642.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:15");
INSERT INTO products VALUES("1692","14 inch,PSTS5","1517","standard","C128","97","849","1","1","1","8,700.00","8,700.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:15");
INSERT INTO products VALUES("1693","Mono Phone ,NP2X","1519","standard","C128","308","851","1","1","1","350","350","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:15");
INSERT INTO products VALUES("1694","Stereo Phone,NP3X","1520","standard","C128","308","851","1","1","1","317","317","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:15");
INSERT INTO products VALUES("1695","XLR Female,NC3FXX","1521","standard","C128","308","851","1","1","1","285","285","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:15");
INSERT INTO products VALUES("1696","XLR Male,NC3MXX","1522","standard","C128","308","851","1","1","1","270","270","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:15");
INSERT INTO products VALUES("1697","Stereo ,CITY ","1523","standard","C128","39","851","1","1","1","350","350","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:15");
INSERT INTO products VALUES("1698","XLR MALE FEMALE,.","1524","standard","C128","39","851","1","1","1","200","200","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:15");
INSERT INTO products VALUES("1699","Stereo ,RCA","1525","standard","C128","309","851","1","1","1","200","200","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:15");
INSERT INTO products VALUES("1700","Kahon Normal,.","1526","standard","C128","85","852","1","1","1","3,000.00","3,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:15");
INSERT INTO products VALUES("1701","Kahon With Tuner,.","1527","standard","C128","85","852","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:15");
INSERT INTO products VALUES("1702","Hand Kahon-Soor Sathi,Pearl-Soor Sathi","1528","standard","C128","310","852","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:15");
INSERT INTO products VALUES("1703","With Set-Soor sathi,Pearl-Soor Sathi","1529","standard","C128","310","852","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:15");
INSERT INTO products VALUES("1704","FLOOR_KAHON,.","1530","standard","C128","311","852","1","1","1","2,243.57","2,243.57","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:15");
INSERT INTO products VALUES("1705","HAND_kAHON,.","1531","standard","C128","312","852","1","1","1","1,011.43","1,011.43","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:15");
INSERT INTO products VALUES("1706","STI,.","1535","standard","C128","313","854","1","1","1","2,250.00","2,250.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:15");
INSERT INTO products VALUES("1707","TRANSPARENT,.","1536","standard","C128","314","854","1","1","1","3,300.00","3,300.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:15");
INSERT INTO products VALUES("1708","JSM Karaoke,.","1539","standard","C128","225","855","1","1","1","1,000.00","1,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:15");
INSERT INTO products VALUES("1709","Mobile Portable Speaker,MPS1 ","1540","standard","C128","316","855","1","1","1","4,500.00","4,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:15");
INSERT INTO products VALUES("1710","GB,GB Karaoke","1541","standard","C128","39","855","1","1","1","14,000.00","14,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:15");
INSERT INTO products VALUES("1711","JSM Karaoke,WS-1816","1542","standard","C128","317","855","1","1","1","1,000.00","1,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:15");
INSERT INTO products VALUES("1712","Plastic,.","1808","standard","C128","372","895","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:18");
INSERT INTO products VALUES("1713","Metal- Anisha,,","1545","standard","C128","39","856","1","1","1","150","150","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:15");
INSERT INTO products VALUES("1714","X1 PLUSH-Anisha,.","1546","standard","C128","318","856","1","1","1","900","900","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:15");
INSERT INTO products VALUES("1715","MIDI KEYBOARD,Q-49","1547","standard","C128","96","857","1","1","1","9,500.00","9,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:15");
INSERT INTO products VALUES("1716","MIDI KEYBOARD,V 25","1548","standard","C128","96","857","1","1","1","10,500.00","10,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:15");
INSERT INTO products VALUES("1717","MIDI KEYBOARD,Vmini 25 Keys","1549","standard","C128","96","857","1","1","1","7,500.00","7,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:16");
INSERT INTO products VALUES("1718","MIDI KEYBOARD,.","1590","standard","C128","326","857","1","1","1","14,000.00","14,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:16");
INSERT INTO products VALUES("1719","Mini,SA-46","1551","standard","C128","37","857","1","1","1","3,500.00","3,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:16");
INSERT INTO products VALUES("1720","Mini,SA-76","1552","standard","C128","37","857","1","1","1","3,582.96","3,582.96","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:16");
INSERT INTO products VALUES("1721","Mini,SA-77","1553","standard","C128","37","857","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:16");
INSERT INTO products VALUES("1722","Mini,SA-78","1554","standard","C128","37","857","1","1","1","3,650.00","3,650.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:16");
INSERT INTO products VALUES("1723","mini,SA-80","1555","standard","C128","37","857","1","1","1","4,800.00","4,800.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:16");
INSERT INTO products VALUES("1724","mini,SA-81","1556","standard","C128","37","857","1","1","1","4,800.00","4,800.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:16");
INSERT INTO products VALUES("1725","standard Key,CT-X8000 IN","1557","standard","C128","37","857","1","1","1","29,800.00","29,800.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:16");
INSERT INTO products VALUES("1726","standard Key,CTK 870 IN","1558","standard","C128","37","857","1","1","1","20,500.00","20,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:16");
INSERT INTO products VALUES("1727","Standard Key,CTK-1250","1559","standard","C128","37","857","1","1","1","9,000.00","9,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:16");
INSERT INTO products VALUES("1728","Standard Key,CTK-1300","1560","standard","C128","37","857","1","1","1","9,000.00","9,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:16");
INSERT INTO products VALUES("1729","Standard Key,CTK-1550","1561","standard","C128","37","857","1","1","1","9,500.00","9,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:16");
INSERT INTO products VALUES("1730","Standard Key,CTK-240","1562","standard","C128","37","857","1","1","1","7,905.00","7,905.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:16");
INSERT INTO products VALUES("1731","Standard Key,CTK-2400","1563","standard","C128","37","857","1","1","1","12,000.00","12,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:16");
INSERT INTO products VALUES("1732","Standard Key,CTK-3200","1564","standard","C128","37","857","1","1","1","14,500.00","14,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:16");
INSERT INTO products VALUES("1733","Standard Key,CTK-3400","1565","standard","C128","37","857","1","1","1","14,500.00","14,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:16");
INSERT INTO products VALUES("1734","Standard Key,CTK-3500 MDY","1566","standard","C128","37","857","1","1","1","19,000.00","19,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:16");
INSERT INTO products VALUES("1735","Standard Key,CTK-4400","1567","standard","C128","37","857","1","1","1","16,000.00","16,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:16");
INSERT INTO products VALUES("1736","standard Key,CTK-6200","1568","standard","C128","37","857","1","1","1","19,500.00","19,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:16");
INSERT INTO products VALUES("1737","Standard Key,CTK-6200-K2","1569","standard","C128","37","857","1","1","1","19,500.00","19,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:16");
INSERT INTO products VALUES("1738","Standard Key,CTK-6300","1570","standard","C128","37","857","1","1","1","21,600.00","21,600.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:16");
INSERT INTO products VALUES("1739","Standard Key,CTK-7000","1571","standard","C128","37","857","1","1","1","18,500.00","18,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:16");
INSERT INTO products VALUES("1740","Standard Key,CTK-7200","1572","standard","C128","37","857","1","1","1","25,000.00","25,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:16");
INSERT INTO products VALUES("1741","Standard Key,CTS-100 MDY","1573","standard","C128","37","857","1","1","1","12,500.00","12,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:16");
INSERT INTO products VALUES("1742","Standard Key,CTS-200 MDY","1574","standard","C128","37","857","1","1","1","15,000.00","15,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:56","2024-01-10 15:01:16");
INSERT INTO products VALUES("1743","Standard Key,CTS-300 MDY","1575","standard","C128","37","857","1","1","1","16,000.00","16,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:16");
INSERT INTO products VALUES("1744","Standard Key,CTS-400 MDY","1576","standard","C128","37","857","1","1","1","32,500.00","32,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:16");
INSERT INTO products VALUES("1745","Standard Key,MDY-CT-X870IN","1577","standard","C128","37","857","1","1","1","17,500.00","17,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:16");
INSERT INTO products VALUES("1746","Midi,M49","1578","standard","C128","320","857","1","1","1","9,500.00","9,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:16");
INSERT INTO products VALUES("1747","32 KEYS,MS-41","1579","standard","C128","321","857","1","1","1","5,600.00","5,600.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:16");
INSERT INTO products VALUES("1748","Midi,Code 61","1580","standard","C128","322","857","1","1","1","28,000.00","28,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:16");
INSERT INTO products VALUES("1749","Midi,Oxygen 25","1581","standard","C128","322","857","1","1","1","12,500.00","12,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:16");
INSERT INTO products VALUES("1750","MIDI KEYBOARD,Oxygen 49 Key 4th Gen","1582","standard","C128","322","857","1","1","1","19,500.00","19,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:16");
INSERT INTO products VALUES("1751","MIDI KEYBOARD,Oxygen pro 61 Key","1583","standard","C128","322","857","1","1","1","28,500.00","28,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:16");
INSERT INTO products VALUES("1752","MIDI KEYBOARD,Oxygen pro mini 32 Key","1584","standard","C128","322","857","1","1","1","16,500.00","16,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:16");
INSERT INTO products VALUES("1753","Standard Key,MK-939","1585","standard","C128","323","857","1","1","1","10,000.00","10,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:16");
INSERT INTO products VALUES("1754","Standard Key,MK-902","1586","standard","C128","324","857","1","1","1","9,000.00","9,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:16");
INSERT INTO products VALUES("1755","Standard Key,MK-935","1587","standard","C128","324","857","1","1","1","12,500.00","12,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:16");
INSERT INTO products VALUES("1756","Midi,49 Keys","1588","standard","C128","325","857","1","1","1","14,000.00","14,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:16");
INSERT INTO products VALUES("1757","Midi,61 Key","1589","standard","C128","325","857","1","1","1","16,800.00","16,800.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:16");
INSERT INTO products VALUES("1758","32 KEYS,RS41XIN MDY","1591","standard","C128","327","857","1","1","1","5,500.00","5,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:16");
INSERT INTO products VALUES("1759",",XPS 30","1592","standard","C128","328","857","1","1","1","82,000.00","82,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:16");
INSERT INTO products VALUES("1760","Standard Key,Juno GI","1593","standard","C128","328","857","1","1","1","85,000.00","85,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:16");
INSERT INTO products VALUES("1761","Standard Key,MDY-A-49","1594","standard","C128","328","857","1","1","1","15,000.00","15,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:16");
INSERT INTO products VALUES("1762","Standard Key,MDY-XPS-10","1595","standard","C128","328","857","1","1","1","50,000.00","50,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:16");
INSERT INTO products VALUES("1763","PA-49X,.","1596","standard","C128","329","857","1","1","1","5,000.00","5,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:16");
INSERT INTO products VALUES("1764","PSR -E463-City,PSR -E463--City","1597","standard","C128","41","857","1","1","1","24,000.00","24,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:16");
INSERT INTO products VALUES("1765","PSR-E 473- MDY,PSR-E 473- MDY","1598","standard","C128","41","857","1","1","1","32,000.00","32,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:16");
INSERT INTO products VALUES("1766","Standard Key,E-343","1599","standard","C128","41","857","1","1","1","17,000.00","17,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:16");
INSERT INTO products VALUES("1767","Standard Key,E-353","1600","standard","C128","41","857","1","1","1","15,200.00","15,200.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:16");
INSERT INTO products VALUES("1768","Standard Key,E-453","1601","standard","C128","41","857","1","1","1","22,000.00","22,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:16");
INSERT INTO products VALUES("1769","Standard Key,E243","1602","standard","C128","41","857","1","1","1","13,500.00","13,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:16");
INSERT INTO products VALUES("1770","Standard Key,E443","1603","standard","C128","41","857","1","1","1","24,750.00","24,750.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:16");
INSERT INTO products VALUES("1771","Standard Key,I 400","1604","standard","C128","41","857","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:16");
INSERT INTO products VALUES("1772","Standard Key,PRS I455","1605","standard","C128","41","857","1","1","1","32,000.00","32,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:16");
INSERT INTO products VALUES("1773","standard Key,PSR 373","1606","standard","C128","41","857","1","1","1","19,500.00","19,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:16");
INSERT INTO products VALUES("1774","Standard Key,PSR E 263","1607","standard","C128","41","857","1","1","1","11,800.00","11,800.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:16");
INSERT INTO products VALUES("1775","Standard Key,PSR E 353","1608","standard","C128","41","857","1","1","1","16,500.00","16,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:16");
INSERT INTO products VALUES("1776","Standard Key,PSR E 463","1609","standard","C128","41","857","1","1","1","28,000.00","28,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:16");
INSERT INTO products VALUES("1777","Standard Key,PSR F 51","1610","standard","C128","41","857","1","1","1","12,800.00","12,800.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:16");
INSERT INTO products VALUES("1778","Standard Key,PSR I 455","1611","standard","C128","41","857","1","1","1","32,500.00","32,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:16");
INSERT INTO products VALUES("1779","Standard Key,PSR S 970","1612","standard","C128","41","857","1","1","1","130,500.00","130,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:16");
INSERT INTO products VALUES("1780","Standard Key,PSR-E 363 (JSM)","1613","standard","C128","41","857","1","1","1","18,000.00","18,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:16");
INSERT INTO products VALUES("1781","standard Key,PSR_EW_410","1614","standard","C128","41","857","1","1","1","35,000.00","35,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:16");
INSERT INTO products VALUES("1782","Standard Key,PSR_I_400","1615","standard","C128","41","857","1","1","1","32,500.00","32,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:16");
INSERT INTO products VALUES("1783","Yamaha-psr-463-Azad,Yamaha-psr-463-Azad","1616","standard","C128","41","857","1","1","1","23,500.00","23,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:16");
INSERT INTO products VALUES("1784","Standard Key,.","1617","standard","C128","330","857","1","1","1","240,000.00","240,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:16");
INSERT INTO products VALUES("1785","Good,DC-12V","1619","standard","C128","39","858","1","1","1","400","400","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:16");
INSERT INTO products VALUES("1786","Good,YGY-C4825C1210","1620","standard","C128","39","858","1","1","1","400","400","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:16");
INSERT INTO products VALUES("1787","Good,PSA-230","1621","standard","C128","328","858","1","1","1","2,000.00","2,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:16");
INSERT INTO products VALUES("1788","Good,AP-3","1622","standard","C128","41","858","1","1","1","480","480","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:16");
INSERT INTO products VALUES("1789","Good,PA-1","1623","standard","C128","41","858","1","1","1","456.64","456.64","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:16");
INSERT INTO products VALUES("1790","Good,PA-150B","1624","standard","C128","41","858","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:16");
INSERT INTO products VALUES("1791","Good,PA-300","1625","standard","C128","41","858","1","1","1","3,700.00","3,700.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:16");
INSERT INTO products VALUES("1792","Good,PA-3C","1626","standard","C128","41","858","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:16");
INSERT INTO products VALUES("1793","NoneBrand,.","1627","standard","C128","331","859","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:16");
INSERT INTO products VALUES("1794","Single,Melody/SX KS-222","1628","standard","C128","313","860","1","1","1","1,300.00","1,300.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:16");
INSERT INTO products VALUES("1795","Double Tube X Senior-City,Double Tube X Senior-City","1629","standard","C128","332","860","1","1","1","1,400.00","1,400.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:16");
INSERT INTO products VALUES("1796","Double Leg,","1630","standard","C128","333","860","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:16");
INSERT INTO products VALUES("1797","Double Leg,.","1631","standard","C128","333","860","1","1","1","1,600.00","1,600.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:16");
INSERT INTO products VALUES("1798","Single,KS 110B","1632","standard","C128","237","860","1","1","1","2,200.00","2,200.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:16");
INSERT INTO products VALUES("1799","Single,JSM Q1X","1633","standard","C128","225","860","1","1","1","1,851.85","1,851.85","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:16");
INSERT INTO products VALUES("1800","Flexi Stand,.","1634","standard","C128","81","860","1","1","1","3,500.00","3,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:17");
INSERT INTO products VALUES("1801","Single,Yamaha-caution","1636","standard","C128","39","860","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:17");
INSERT INTO products VALUES("1802","wodden,.","1638","standard","C128","39","861","1","1","1","4,000.00","4,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:17");
INSERT INTO products VALUES("1803","FOOT SWICH,PSP2","1640","standard","C128","192","863","1","1","1","1,500.00","1,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:17");
INSERT INTO products VALUES("1804","Selector Switch Knob,.","1642","standard","C128","39","865","1","1","1","60","60","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:17");
INSERT INTO products VALUES("1805","LED USB,LXS-001","1643","standard","C128","39","866","1","1","1","75","75","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:17");
INSERT INTO products VALUES("1806","Guitar,.","1886","standard","C128","387","906","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:19");
INSERT INTO products VALUES("1807","Microphone,.","1645","standard","C128","314","867","1","1","1","1,600.00","1,600.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:17");
INSERT INTO products VALUES("1808","Normal,BS108B","1647","standard","C128","237","869","1","1","1","1,800.00","1,800.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:17");
INSERT INTO products VALUES("1809","PA- 520 JSM,.","1650","standard","C128","334","869","1","1","1","2,500.00","2,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:17");
INSERT INTO products VALUES("1810","Normal,MBS-401","1651","standard","C128","62","869","1","1","1","1,183.00","1,183.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:17");
INSERT INTO products VALUES("1811","WD-517,.","1652","standard","C128","335","869","1","1","1","1,800.00","1,800.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:17");
INSERT INTO products VALUES("1812","Normal,JSM-32","1654","standard","C128","51","871","1","1","1","2,500.00","2,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:17");
INSERT INTO products VALUES("1813","Normal,MD-32","1655","standard","C128","337","871","1","1","1","2,800.00","2,800.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:17");
INSERT INTO products VALUES("1814","Normal,UC-37 KEY","1656","standard","C128","39","871","1","1","1","2,700.00","2,700.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:17");
INSERT INTO products VALUES("1815","Normal,MD-37","1657","standard","C128","287","871","1","1","1","3,500.00","3,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:17");
INSERT INTO products VALUES("1816","M&T,M1 VS","1658","standard","C128","44","872","1","1","1","5,500.00","5,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:17");
INSERT INTO products VALUES("1817","Acoustic,Indian","1659","standard","C128","294","872","1","1","1","4,466.67","4,466.67","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:17");
INSERT INTO products VALUES("1818","Acoustic,STI-Rose","1660","standard","C128","294","872","1","1","1","3,400.00","3,400.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:17");
INSERT INTO products VALUES("1819","Acoustic,STI-Special","1661","standard","C128","294","872","1","1","1","3,200.00","3,200.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:17");
INSERT INTO products VALUES("1820","AM03,.","1664","standard","C128","95","873","1","1","1","210","210","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:17");
INSERT INTO products VALUES("1821","ESTD 1942,","1665","standard","C128","260","873","1","1","1","138.57","138.57","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:17");
INSERT INTO products VALUES("1822","chaina M221,.","1666","standard","C128","340","873","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:17");
INSERT INTO products VALUES("1823","Dynamic,AUD-100XLR","1667","standard","C128","341","874","1","1","1","600","600","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:17");
INSERT INTO products VALUES("1824","Dynamic,AUD-98XLR","1668","standard","C128","341","874","1","1","1","385","385","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:17");
INSERT INTO products VALUES("1825","Condensor,P-120","1669","standard","C128","342","874","1","1","1","7,500.00","7,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:17");
INSERT INTO products VALUES("1826","Condensor,AT 2020","1670","standard","C128","295","874","1","1","1","11,500.00","11,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:17");
INSERT INTO products VALUES("1827","Live Streamer MIC 133,Streamer MIC 133","1671","standard","C128","343","874","1","1","1","5,900.00","5,900.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:17");
INSERT INTO products VALUES("1828","Condensor,Snowball","1672","standard","C128","344","874","1","1","1","8,200.00","8,200.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:17");
INSERT INTO products VALUES("1829","Condensor,BM 100","1673","standard","C128","345","874","1","1","1","2,050.00","2,050.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:17");
INSERT INTO products VALUES("1830","Clip-on,BY-M1","1674","standard","C128","346","874","1","1","1","650","650","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:17");
INSERT INTO products VALUES("1831","Vocal ,UDM-246","1675","standard","C128","347","874","1","1","1","450","450","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:17");
INSERT INTO products VALUES("1832","Condensor,AK-6200","1676","standard","C128","348","874","1","1","1","2,300.00","2,300.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:17");
INSERT INTO products VALUES("1833","Dynamic,CE- 1000S //","1677","standard","C128","348","874","1","1","1","1,050.00","1,050.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:17");
INSERT INTO products VALUES("1834","DJ Plus,City-DJ-2082","1678","standard","C128","349","874","1","1","1","6,000.00","6,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:17");
INSERT INTO products VALUES("1835","Studio Series,ES-4Sb","1679","standard","C128","350","874","1","1","1","6,300.00","6,300.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:17");
INSERT INTO products VALUES("1836","Condensor,Labu-Cosmik 10","1680","standard","C128","297","874","1","1","1","8,700.00","8,700.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:17");
INSERT INTO products VALUES("1837","Condensor,USB-K670B","1681","standard","C128","351","874","1","1","1","5,200.00","5,200.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:17");
INSERT INTO products VALUES("1838","Condensor,USB-K683A","1682","standard","C128","351","874","1","1","1","4,800.00","4,800.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:17");
INSERT INTO products VALUES("1839","Dynamic,NK-500","1683","standard","C128","299","874","1","1","1","1,500.00","1,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:17");
INSERT INTO products VALUES("1840","Condensor,BM-800","1684","standard","C128","225","874","1","1","1","3,800.00","3,800.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:17");
INSERT INTO products VALUES("1841","Vocal ,MK-680","1685","standard","C128","217","874","1","1","1","3,400.00","3,400.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:17");
INSERT INTO products VALUES("1842","Vocal ,TK 280","1686","standard","C128","217","874","1","1","1","2,800.00","2,800.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:17");
INSERT INTO products VALUES("1843","Vocal ,TX-8","1687","standard","C128","217","874","1","1","1","1,700.00","1,700.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:17");
INSERT INTO products VALUES("1844","Wireless System,US-8010D Pro-Mh-700D","1688","standard","C128","217","874","1","1","1","12,500.00","12,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:17");
INSERT INTO products VALUES("1845","wireless mic,Anisha-K8","1689","standard","C128","352","874","1","1","1","450","450","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:17");
INSERT INTO products VALUES("1846","Package,City-DH-744","1690","standard","C128","353","874","1","1","1","6,000.00","6,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:17");
INSERT INTO products VALUES("1847","Dynamic,MWm-5 (Labu)","1691","standard","C128","316","874","1","1","1","1,200.00","1,200.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:17");
INSERT INTO products VALUES("1848","Shock Mount,.","1692","standard","C128","39","874","1","1","1","1,500.00","1,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:57","2024-01-10 15:01:17");
INSERT INTO products VALUES("1849","Condensor,NT1-A","1693","standard","C128","354","874","1","1","1","14,500.00","14,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:17");
INSERT INTO products VALUES("1850","Condensor,NT2-A","1694","standard","C128","354","874","1","1","1","27,000.00","27,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:17");
INSERT INTO products VALUES("1851","USB,.","1695","standard","C128","355","874","1","1","1","13,000.00","13,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:17");
INSERT INTO products VALUES("1852","Dynamic,e 835","1696","standard","C128","356","874","1","1","1","7,500.00","7,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:17");
INSERT INTO products VALUES("1853","Dynamic,Beta58A","1697","standard","C128","357","874","1","1","1","1,250.00","1,250.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:17");
INSERT INTO products VALUES("1854","Dynamic,SM58","1698","standard","C128","357","874","1","1","1","3,000.00","3,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:17");
INSERT INTO products VALUES("1855","Dynamic,SmM-57","1699","standard","C128","357","874","1","1","1","6,825.00","6,825.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:17");
INSERT INTO products VALUES("1856","Shure-Wireless,City-UHF-555","1700","standard","C128","358","874","1","1","1","4,000.00","4,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:17");
INSERT INTO products VALUES("1857","wireless mic,.","1701","standard","C128","359","874","1","1","1","2,800.00","2,800.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:17");
INSERT INTO products VALUES("1858","Dynamic,M90s","1702","standard","C128","41","874","1","1","1","1,050.00","1,050.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:17");
INSERT INTO products VALUES("1859","Normal,DMDO7600","1703","standard","C128","213","875","1","1","1","850","850","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:17");
INSERT INTO products VALUES("1860","Normal,TS+XLR","1705","standard","C128","39","875","1","1","1","250","250","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:17");
INSERT INTO products VALUES("1861","Male and Female Jack,MDY-5 meter","1706","standard","C128","360","875","1","1","1","825","825","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:17");
INSERT INTO products VALUES("1862","Foam,Anisha","1707","standard","C128","39","876","1","1","1","13.33","13.33","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:17");
INSERT INTO products VALUES("1863","Live Voice MIC.STAND,.","1711","standard","C128","333","879","1","1","1","1,400.00","1,400.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:17");
INSERT INTO products VALUES("1864","Hydrolic,BS 100B","1712","standard","C128","237","879","1","1","1","2,000.00","2,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:17");
INSERT INTO products VALUES("1865","Hydrolic,MS120B","1713","standard","C128","237","879","1","1","1","2,548.00","2,548.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:17");
INSERT INTO products VALUES("1866","Hydrolic,MS631B","1714","standard","C128","237","879","1","1","1","3,512.50","3,512.50","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:17");
INSERT INTO products VALUES("1867","Hydrolic,MS632B","1715","standard","C128","237","879","1","1","1","3,185.00","3,185.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:17");
INSERT INTO products VALUES("1868","Normal,AMS-325XB","1716","standard","C128","283","879","1","1","1","1,800.00","1,800.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:17");
INSERT INTO products VALUES("1869","Normal,MMS-3 (Labu)","1718","standard","C128","316","879","1","1","1","1,608.33","1,608.33","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:17");
INSERT INTO products VALUES("1870","1 NO.,.","1719","standard","C128","39","879","1","1","1","1,800.00","1,800.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:17");
INSERT INTO products VALUES("1871","2 NO.,.","1720","standard","C128","39","879","1","1","1","1,500.00","1,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:17");
INSERT INTO products VALUES("1872","3 NO.,.","1721","standard","C128","39","879","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:17");
INSERT INTO products VALUES("1873","Table Stand,.","1723","standard","C128","39","879","1","1","1","850","850","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:18");
INSERT INTO products VALUES("1874","Table Stand,JSM Desk","1724","standard","C128","39","879","1","1","1","1,500.00","1,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:18");
INSERT INTO products VALUES("1875","Labu,.","1726","standard","C128","363","879","1","1","1","1,700.00","1,700.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:18");
INSERT INTO products VALUES("1876","Normal,JSM PRO","1728","standard","C128","363","879","1","1","1","2,000.00","2,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:18");
INSERT INTO products VALUES("1877","Prostand_RNG,.","1729","standard","C128","363","879","1","1","1","1,300.00","1,300.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:18");
INSERT INTO products VALUES("1878","Normal,MS-80/BK","1730","standard","C128","62","879","1","1","1","2,002.00","2,002.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:18");
INSERT INTO products VALUES("1879","pro microphone,WD-107","1731","standard","C128","335","879","1","1","1","1,600.00","1,600.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:18");
INSERT INTO products VALUES("1880","Midisport,Uno","1732","standard","C128","322","880","1","1","1","3,200.00","3,200.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:18");
INSERT INTO products VALUES("1881","5 Pin,MD-05","1733","standard","C128","364","881","1","1","1","1,400.00","1,400.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:18");
INSERT INTO products VALUES("1882","MINI KALIMBA -UK CENTER,MINI KALIMBA -CHINA","1734","standard","C128","365","882","1","1","1","450","450","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:18");
INSERT INTO products VALUES("1883","4 Channel,Multimix 4 USB FX","1735","standard","C128","96","883","1","1","1","11,000.00","11,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:18");
INSERT INTO products VALUES("1884","Stereo Echo,SM-6","1736","standard","C128","128","883","1","1","1","4,537.04","4,537.04","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:18");
INSERT INTO products VALUES("1885","Professional,4 Channel live mixer","1737","standard","C128","41","883","1","1","1","5,500.00","5,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:18");
INSERT INTO products VALUES("1886","Stereo Echo,MG6X","1738","standard","C128","41","883","1","1","1","11,000.00","11,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:18");
INSERT INTO products VALUES("1887","3 mtr,APS-159","1739","standard","C128","366","884","1","1","1","440","440","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:18");
INSERT INTO products VALUES("1888","3 mtr,APS-500","1740","standard","C128","366","884","1","1","1","430","430","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:18");
INSERT INTO products VALUES("1889","3 mtr,APS-K155","1741","standard","C128","366","884","1","1","1","435","435","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:18");
INSERT INTO products VALUES("1890","Portable,L.E.D","1743","standard","C128","283","885","1","1","1","1,200.00","1,200.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:18");
INSERT INTO products VALUES("1891","Cloth,25+25","1747","standard","C128","39","887","1","1","1","380","380","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:18");
INSERT INTO products VALUES("1892","Cloth,50+50","1748","standard","C128","39","887","1","1","1","750","750","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:18");
INSERT INTO products VALUES("1893","Thread,25+25","1749","standard","C128","39","887","1","1","1","350","350","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:18");
INSERT INTO products VALUES("1894","Thread,50+50","1750","standard","C128","39","887","1","1","1","700","700","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:18");
INSERT INTO products VALUES("1895","Pad 20 pro,.","1751","standard","C128","367","888","1","1","1","30,000.00","30,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:18");
INSERT INTO products VALUES("1896","SPD-20X,.","1752","standard","C128","328","888","1","1","1","50,500.00","50,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:18");
INSERT INTO products VALUES("1897","SPD Stand,.","1754","standard","C128","81","889","1","1","1","2,800.00","2,800.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:18");
INSERT INTO products VALUES("1898","Octapad Stand-City,Octapad Stand-City","1755","standard","C128","39","889","1","1","1","2,500.00","2,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:18");
INSERT INTO products VALUES("1899","novetion,.","1757","standard","C128","368","891","1","1","1","12,700.00","12,700.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:18");
INSERT INTO products VALUES("1900","Double Paddle,.","1758","standard","C128","369","892","1","1","1","10,500.00","10,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:18");
INSERT INTO products VALUES("1901","Keyboard,SVP 2","1759","standard","C128","128","892","1","1","1","1,400.00","1,400.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:18");
INSERT INTO products VALUES("1902","Bamboo,.","1760","standard","C128","43","893","1","1","1","30","30","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:18");
INSERT INTO products VALUES("1903","Hand Jhunjhuni big,.","1763","standard","C128","","895","1","1","1","120","120","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:18");
INSERT INTO products VALUES("1904","Hand Jhunjhuni Small,.","1764","standard","C128","","895","1","1","1","100","100","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:18");
INSERT INTO products VALUES("1905","Maraca,A043SE","1765","standard","C128","95","895","1","1","1","338","338","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:18");
INSERT INTO products VALUES("1906","Maraca,A045M","1766","standard","C128","95","895","1","1","1","320","320","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:18");
INSERT INTO products VALUES("1907","Tamborine,Star","1767","standard","C128","95","895","1","1","1","400","400","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:18");
INSERT INTO products VALUES("1908","Finger Shaker,.","1768","standard","C128","82","895","1","1","1","75","75","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:18");
INSERT INTO products VALUES("1909","Juri (Korotal),.","1769","standard","C128","126","895","1","1","1","700","700","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:18");
INSERT INTO products VALUES("1910","Mandira,.","1770","standard","C128","126","895","1","1","1","900","900","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:18");
INSERT INTO products VALUES("1911","Prem Juri,.","1771","standard","C128","126","895","1","1","1","250","250","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:18");
INSERT INTO products VALUES("1912","Baya,Hand ","1772","standard","C128","43","895","1","1","1","350","350","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:18");
INSERT INTO products VALUES("1913","Baya,Hand Big","1773","standard","C128","43","895","1","1","1","550","550","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:18");
INSERT INTO products VALUES("1914","Baya,Hand big special","1774","standard","C128","43","895","1","1","1","550","550","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:18");
INSERT INTO products VALUES("1915","Baya,Hand Medium","1775","standard","C128","43","895","1","1","1","380","380","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:18");
INSERT INTO products VALUES("1916","Baya,Hand Small","1776","standard","C128","43","895","1","1","1","380","380","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:18");
INSERT INTO products VALUES("1917","Khomok,.","1777","standard","C128","43","895","1","1","1","550","550","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:18");
INSERT INTO products VALUES("1918","Khomok,Medium Labu","1778","standard","C128","43","895","1","1","1","560","560","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:18");
INSERT INTO products VALUES("1919","Khomok,Small Labu","1779","standard","C128","43","895","1","1","1","560","560","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:18");
INSERT INTO products VALUES("1920","Khomok,Special","1780","standard","C128","43","895","1","1","1","716.67","716.67","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:18");
INSERT INTO products VALUES("1921","Mandira,Large","1781","standard","C128","43","895","1","1","1","450","450","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:18");
INSERT INTO products VALUES("1922","Mandira,Midium ","1782","standard","C128","43","895","1","1","1","350","350","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:18");
INSERT INTO products VALUES("1923","Mandira,Small","1783","standard","C128","43","895","1","1","1","250","250","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:18");
INSERT INTO products VALUES("1924","Egg Small,.","1784","standard","C128","370","895","1","1","1","200","200","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:18");
INSERT INTO products VALUES("1925","Soft Plastic,A045M","1785","standard","C128","370","895","1","1","1","340","340","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:18");
INSERT INTO products VALUES("1926","Soft Plastic,DD MA2","1786","standard","C128","370","895","1","1","1","550","550","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:18");
INSERT INTO products VALUES("1927","Soft Plastic,Normal","1787","standard","C128","370","895","1","1","1","220","220","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:18");
INSERT INTO products VALUES("1928","Baya,Large","1788","standard","C128","39","895","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:18");
INSERT INTO products VALUES("1929","Baya,Small","1789","standard","C128","39","895","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:18");
INSERT INTO products VALUES("1930","Cabasa,.","1790","standard","C128","39","895","1","1","1","650","650","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:18");
INSERT INTO products VALUES("1931","Mandira,Metal","1791","standard","C128","39","895","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:18");
INSERT INTO products VALUES("1932","Pipe Shaker,.","1792","standard","C128","39","895","1","1","1","480","480","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:18");
INSERT INTO products VALUES("1933","Premjuri (Krisno Kathi),.","1793","standard","C128","39","895","1","1","1","250","250","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:18");
INSERT INTO products VALUES("1934","Rain maker,Bamboo","1794","standard","C128","39","895","1","1","1","800","800","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:18");
INSERT INTO products VALUES("1935","Sistro,.","1795","standard","C128","39","895","1","1","1","1,500.00","1,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:18");
INSERT INTO products VALUES("1936","Tamborine,Double Half","1796","standard","C128","39","895","1","1","1","400","400","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:18");
INSERT INTO products VALUES("1937","Wooden,Rainstick","1797","standard","C128","39","895","1","1","1","340","340","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:18");
INSERT INTO products VALUES("1938","Wooden,Toca Hand Rattle","1798","standard","C128","39","895","1","1","1","260","260","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:18");
INSERT INTO products VALUES("1939","Wooden Hand Held,Dice","1799","standard","C128","39","895","1","1","1","150","150","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:58","2024-01-10 15:01:18");
INSERT INTO products VALUES("1940","Wooden Hand Held,Hand Shaker 2","1800","standard","C128","39","895","1","1","1","185","185","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:59","2024-01-10 15:01:18");
INSERT INTO products VALUES("1941","Wooden Hand Held,Magnet Shape","1801","standard","C128","39","895","1","1","1","185","185","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:59","2024-01-10 15:01:18");
INSERT INTO products VALUES("1942","Wooden Hand Held,Round Hand held","1802","standard","C128","39","895","1","1","1","260","260","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:59","2024-01-10 15:01:18");
INSERT INTO products VALUES("1943","Alice,Normal One Pair","1803","standard","C128","371","895","1","1","1","156.67","156.67","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:59","2024-01-10 15:01:18");
INSERT INTO products VALUES("1944","Alice,Normal One Pair Handle","1804","standard","C128","371","895","1","1","1","250","250","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:59","2024-01-10 15:01:18");
INSERT INTO products VALUES("1945","Alice,Hand ","1805","standard","C128","372","895","1","1","1","533.33","533.33","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:59","2024-01-10 15:01:18");
INSERT INTO products VALUES("1946","Alice,Hand Double","1806","standard","C128","372","895","1","1","1","450","450","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:59","2024-01-10 15:01:18");
INSERT INTO products VALUES("1947","Alice,Normal","1807","standard","C128","372","895","1","1","1","416.67","416.67","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:59","2024-01-10 15:01:18");
INSERT INTO products VALUES("1948","Wooden,Backless","1809","standard","C128","372","895","1","1","1","400","400","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:59","2024-01-10 15:01:18");
INSERT INTO products VALUES("1949","Wooden,With Back","1810","standard","C128","372","895","1","1","1","1,000.00","1,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:59","2024-01-10 15:01:18");
INSERT INTO products VALUES("1950","Acoustic,A025A (W)","1812","standard","C128","95","897","1","1","1","100","100","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:59","2024-01-10 15:01:18");
INSERT INTO products VALUES("1951","BLACK ,.","1813","standard","C128","373","897","1","1","1","70","70","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:59","2024-01-10 15:01:18");
INSERT INTO products VALUES("1952","G.Shop,BLACK  ","1814","standard","C128","198","897","1","1","1","50","50","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:59","2024-01-10 15:01:18");
INSERT INTO products VALUES("1953","G.Shop,HEAVY","1815","standard","C128","198","897","1","1","1","120","120","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:59","2024-01-10 15:01:18");
INSERT INTO products VALUES("1954","G.Shop,PP- A10","1816","standard","C128","198","897","1","1","1","90","90","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:59","2024-01-10 15:01:18");
INSERT INTO products VALUES("1955","3D   ,.","1861","standard","C128","39","899","1","1","1","70","70","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:59","2024-01-10 15:01:19");
INSERT INTO products VALUES("1956","Violin,KQ 2","1818","standard","C128","","898","1","1","1","800","800","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:59","2024-01-10 15:01:18");
INSERT INTO products VALUES("1957","Base Pik,.","1819","standard","C128","95","899","1","1","1","21.82","21.82","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:59","2024-01-10 15:01:19");
INSERT INTO products VALUES("1958","Design,Good Quality","1820","standard","C128","95","899","1","1","1","22.66","22.66","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:59","2024-01-10 15:01:19");
INSERT INTO products VALUES("1959","Mini Box Pic,Anisha","1821","standard","C128","95","899","1","1","1","20","20","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:59","2024-01-10 15:01:19");
INSERT INTO products VALUES("1960","Normal,Free","1823","standard","C128","95","899","1","1","1","5","5","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:59","2024-01-10 15:01:19");
INSERT INTO products VALUES("1961","Steal,.","1869","standard","C128","383","899","1","1","1","30","30","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:59","2024-01-10 15:01:19");
INSERT INTO products VALUES("1962","Thumb,.","1858","standard","C128","211","899","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:59","2024-01-10 15:01:19");
INSERT INTO products VALUES("1963","Alice- S.T.I,Alice- S.T.I","1826","standard","C128","374","899","1","1","1","3","3","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:59","2024-01-10 15:01:19");
INSERT INTO products VALUES("1964","Hawain Loose + steel,.","1827","standard","C128","375","899","1","1","1","8.58","8.58","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:59","2024-01-10 15:01:19");
INSERT INTO products VALUES("1965","Hawaiian Guitar,.","1829","standard","C128","314","899","1","1","1","150","150","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:59","2024-01-10 15:01:19");
INSERT INTO products VALUES("1966","Jazz,III","1833","standard","C128","245","899","1","1","1","31.54","31.54","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:59","2024-01-10 15:01:19");
INSERT INTO products VALUES("1967","Jazz,Ultex Jazz III","1834","standard","C128","245","899","1","1","1","87.69","87.69","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:59","2024-01-10 15:01:19");
INSERT INTO products VALUES("1968","Jazz,XL III","1835","standard","C128","245","899","1","1","1","12","12","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:59","2024-01-10 15:01:19");
INSERT INTO products VALUES("1969","Jim,JP","1836","standard","C128","245","899","1","1","1","140","140","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:59","2024-01-10 15:01:19");
INSERT INTO products VALUES("1970","Joyo ,. ","1837","standard","C128","245","899","1","1","1","15","15","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:59","2024-01-10 15:01:19");
INSERT INTO products VALUES("1971","Nylon pik,Jim 1.14 mm","1839","standard","C128","245","899","1","1","1","36","36","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:59","2024-01-10 15:01:19");
INSERT INTO products VALUES("1972","Signature,USA/Andy James","1840","standard","C128","245","899","1","1","1","188.18","188.18","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:59","2024-01-10 15:01:19");
INSERT INTO products VALUES("1973","Tortex,Flex / USA","1842","standard","C128","245","899","1","1","1","88.33","88.33","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:59","2024-01-10 15:01:19");
INSERT INTO products VALUES("1974","Tortex,White clr","1843","standard","C128","245","899","1","1","1","12","12","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:59","2024-01-10 15:01:19");
INSERT INTO products VALUES("1975","H ,.","1844","standard","C128","259","899","1","1","1","30","30","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:59","2024-01-10 15:01:19");
INSERT INTO products VALUES("1976","Medium,.","2234","standard","C128","39","56","1","1","1","300","300","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:59","2024-01-10 15:01:23");
INSERT INTO products VALUES("1977","Delrin ,. ","1848","standard","C128","378","899","1","1","1","53","53","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:59","2024-01-10 15:01:19");
INSERT INTO products VALUES("1978","Jazz,.","1849","standard","C128","378","899","1","1","1","45","45","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:59","2024-01-10 15:01:19");
INSERT INTO products VALUES("1979","Original,.","1850","standard","C128","378","899","1","1","1","43","43","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:59","2024-01-10 15:01:19");
INSERT INTO products VALUES("1980","China loose,.","1851","standard","C128","158","899","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:59","2024-01-10 15:01:19");
INSERT INTO products VALUES("1981","Hawain Loose,.","1852","standard","C128","158","899","1","1","1","11","11","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:59","2024-01-10 15:01:19");
INSERT INTO products VALUES("1982","Indian loose,.","1853","standard","C128","158","899","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:59","2024-01-10 15:01:19");
INSERT INTO products VALUES("1983","Heavy ,Celluloid / Polyacetal","1854","standard","C128","159","899","1","1","1","75","75","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:59","2024-01-10 15:01:19");
INSERT INTO products VALUES("1984","Hwaiian Guitar,.","1863","standard","C128","39","899","1","1","1","26.29","26.29","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:59","2024-01-10 15:01:19");
INSERT INTO products VALUES("1985","Custom,Jazz III","1860","standard","C128","380","899","1","1","1","21","21","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:59","2024-01-10 15:01:19");
INSERT INTO products VALUES("1986","Design,M/Rifat","1862","standard","C128","39","899","1","1","1","8.5","8.5","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:59","2024-01-10 15:01:19");
INSERT INTO products VALUES("1987","Normal,Black  ","2190","standard","C128","225","937","1","1","1","4,500.00","4,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:59","2024-01-10 15:01:23");
INSERT INTO products VALUES("1988","Shade,.","1865","standard","C128","39","899","1","1","1","35","35","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:59","2024-01-10 15:01:19");
INSERT INTO products VALUES("1989","speceal,.","1868","standard","C128","382","899","1","1","1","18","18","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:59","2024-01-10 15:01:19");
INSERT INTO products VALUES("1990","Normal,Normal","1871","standard","C128","65","899","1","1","1","6.7","6.7","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:59","2024-01-10 15:01:19");
INSERT INTO products VALUES("1991","Microphone Filter,JSM-PF-08","1872","standard","C128","51","900","1","1","1","1,000.00","1,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:59","2024-01-10 15:01:19");
INSERT INTO products VALUES("1992","Acoustic Filter,E008","1873","standard","C128","384","900","1","1","1","950","950","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:59","2024-01-10 15:01:19");
INSERT INTO products VALUES("1993","Microphone Filter,KN-PF2","1874","standard","C128","385","900","1","1","1","650","650","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:59","2024-01-10 15:01:19");
INSERT INTO products VALUES("1994","Microphone Filter,.","1875","standard","C128","39","900","1","1","1","1,000.00","1,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:59","2024-01-10 15:01:19");
INSERT INTO products VALUES("1995","Microphone Filter,Anisha","1876","standard","C128","39","900","1","1","1","850","850","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:59","2024-01-10 15:01:19");
INSERT INTO products VALUES("1996","PF-08,.","1877","standard","C128","39","900","1","1","1","1,100.00","1,100.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:59","2024-01-10 15:01:19");
INSERT INTO products VALUES("1997","Microphone Filter,MA91","1878","standard","C128","306","900","1","1","1","1,200.00","1,200.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:59","2024-01-10 15:01:19");
INSERT INTO products VALUES("1998","Repairing,.","1884","standard","C128","31","906","1","1","1","10.75","10.75","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:59","2024-01-10 15:01:19");
INSERT INTO products VALUES("1999","Drum,Repearing","1885","standard","C128","39","906","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:59","2024-01-10 15:01:19");
INSERT INTO products VALUES("2000","Drum,.","1888","standard","C128","39","907","1","1","1","109.29","109.29","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:59","2024-01-10 15:01:19");
INSERT INTO products VALUES("2001","Acounting software,Musicare 1","1891","standard","C128","55","909","1","1","1","3,500.00","3,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:59","2024-01-10 15:01:19");
INSERT INTO products VALUES("2002","Studio Package,Labu-U22XT Cosmik Set","1892","standard","C128","297","910","1","1","1","23,000.00","23,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:59","2024-01-10 15:01:19");
INSERT INTO products VALUES("2003","USB,Labu-Maya 22 USB","1893","standard","C128","297","910","1","1","1","8,000.00","8,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:59","2024-01-10 15:01:19");
INSERT INTO products VALUES("2004","USB,Labu-U22 XT","1894","standard","C128","297","910","1","1","1","8,900.00","8,900.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:59","2024-01-10 15:01:19");
INSERT INTO products VALUES("2005","FireWire,Liquied Saffire 56","1895","standard","C128","388","910","1","1","1","61,880.00","61,880.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:59","2024-01-10 15:01:19");
INSERT INTO products VALUES("2006","Saffire ,Pro 26","1896","standard","C128","388","910","1","1","1","15,000.00","15,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:59","2024-01-10 15:01:19");
INSERT INTO products VALUES("2007","USB,Scarlett 2i2","1897","standard","C128","388","910","1","1","1","11,700.00","11,700.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:59","2024-01-10 15:01:19");
INSERT INTO products VALUES("2008"," 3rd Gen,.","1898","standard","C128","389","910","1","1","1","24,500.00","24,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:58:59","2024-01-10 15:01:19");
INSERT INTO products VALUES("2009","2i2 3rd  generation,.","1899","standard","C128","389","910","1","1","1","14,500.00","14,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:19");
INSERT INTO products VALUES("2010","USB,Labu-Komplete Audio 1","1900","standard","C128","390","910","1","1","1","11,500.00","11,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:19");
INSERT INTO products VALUES("2011","M-Track   ,2*2M","1901","standard","C128","322","910","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:19");
INSERT INTO products VALUES("2012","M-Track  Duo,M-Track  Duo","1902","standard","C128","322","910","1","1","1","7,800.00","7,800.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:19");
INSERT INTO products VALUES("2013","M-Track Plus,.","1903","standard","C128","322","910","1","1","1","13,500.00","13,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:19");
INSERT INTO products VALUES("2014","Studio Package,M-Track 2*2 Vocal Studio Pro","1904","standard","C128","322","910","1","1","1","23,000.00","23,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:19");
INSERT INTO products VALUES("2015","Studio 2,JSM ","1905","standard","C128","391","910","1","1","1","9,500.00","9,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:19");
INSERT INTO products VALUES("2016","Studio Package,2i2 Studio","1906","standard","C128","392","910","1","1","1","23,500.00","23,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:19");
INSERT INTO products VALUES("2017","Acoustic Guitar,A048","1907","standard","C128","95","911","1","1","1","350","350","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:19");
INSERT INTO products VALUES("2018","Bluetooth,soundlink mini","1908","standard","C128","393","912","1","1","1","700","700","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:19");
INSERT INTO products VALUES("2019","2:01,M780BT","1909","standard","C128","394","912","1","1","1","2,450.00","2,450.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:19");
INSERT INTO products VALUES("2020","2:01,M781BT","1910","standard","C128","394","912","1","1","1","2,450.00","2,450.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:19");
INSERT INTO products VALUES("2021","2:01,X-E900BT","1911","standard","C128","394","912","1","1","1","2,575.00","2,575.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:19");
INSERT INTO products VALUES("2022","2:01,X-F905","1912","standard","C128","394","912","1","1","1","3,000.00","3,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:19");
INSERT INTO products VALUES("2023","2:01,X-L918","1913","standard","C128","394","912","1","1","1","3,025.00","3,025.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:19");
INSERT INTO products VALUES("2024","2:01,X-L920","1914","standard","C128","394","912","1","1","1","3,025.00","3,025.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:19");
INSERT INTO products VALUES("2025","2:01,X-M810","1915","standard","C128","394","912","1","1","1","6,375.00","6,375.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:19");
INSERT INTO products VALUES("2026","2:01,X-M929","1916","standard","C128","394","912","1","1","1","3,050.00","3,050.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:19");
INSERT INTO products VALUES("2027","5:01,X-F1200","1917","standard","C128","394","912","1","1","1","10,000.00","10,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:19");
INSERT INTO products VALUES("2028","5:01,X-M1008","1918","standard","C128","394","912","1","1","1","4,400.00","4,400.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:19");
INSERT INTO products VALUES("2029","Studio Monitor,Labu_ESI Octiv 05","1919","standard","C128","395","912","1","1","1","14,700.00","14,700.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:19");
INSERT INTO products VALUES("2030","Ctnno-34,.","1920","standard","C128","333","912","1","1","1","6,200.00","6,200.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:20");
INSERT INTO products VALUES("2031","Ctnno-40,.","1921","standard","C128","333","912","1","1","1","6,200.00","6,200.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:20");
INSERT INTO products VALUES("2032","2 pcs,SP-HF-150","1922","standard","C128","120","912","1","1","1","550","550","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:20");
INSERT INTO products VALUES("2033","Bluetooth,M8ME","1923","standard","C128","121","912","1","1","1","1,150.00","1,150.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:20");
INSERT INTO products VALUES("2034","Bluetooth,SK452BT","1924","standard","C128","121","912","1","1","1","890","890","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:20");
INSERT INTO products VALUES("2035","USB 2pcs,A51","1925","standard","C128","121","912","1","1","1","450","450","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:20");
INSERT INTO products VALUES("2036","USB 2pcs,HV-SK109","1926","standard","C128","121","912","1","1","1","475","475","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:20");
INSERT INTO products VALUES("2037","USB 2pcs,HV-SK431","1927","standard","C128","121","912","1","1","1","890","890","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:20");
INSERT INTO products VALUES("2038","USB 2pcs,HV-SK481","1928","standard","C128","121","912","1","1","1","750","750","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:20");
INSERT INTO products VALUES("2039","USB 2pcs,SK427","1929","standard","C128","121","912","1","1","1","600","600","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:20");
INSERT INTO products VALUES("2040","USB 2pcs,SK430","1930","standard","C128","121","912","1","1","1","390","390","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:20");
INSERT INTO products VALUES("2041","USB 2pcs,SK453","1931","standard","C128","121","912","1","1","1","375","375","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:20");
INSERT INTO products VALUES("2042","USB 2pcs,SK457","1932","standard","C128","121","912","1","1","1","450","450","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:20");
INSERT INTO products VALUES("2043","USB 2pcs,SK482","1933","standard","C128","121","912","1","1","1","600","600","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:20");
INSERT INTO products VALUES("2044","USB 2pcs,SK483","1934","standard","C128","121","912","1","1","1","600","600","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:20");
INSERT INTO products VALUES("2045","USB 2pcs,SK486","1935","standard","C128","121","912","1","1","1","235","235","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:20");
INSERT INTO products VALUES("2046","Monitor Speaker,jbl lsr 305","1936","standard","C128","299","912","1","1","1","23,000.00","23,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:20");
INSERT INTO products VALUES("2047","2 pcs,118-10B","1937","standard","C128","396","912","1","1","1","3,250.00","3,250.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:20");
INSERT INTO products VALUES("2048","2 pcs,SK 805","1938","standard","C128","396","912","1","1","1","4,300.00","4,300.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:20");
INSERT INTO products VALUES("2049","2 pcs,SK-601","1939","standard","C128","396","912","1","1","1","2,450.00","2,450.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:20");
INSERT INTO products VALUES("2050","2 pcs,SK-9900","1940","standard","C128","396","912","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:20");
INSERT INTO products VALUES("2051","Studio Monitor,AV 42","1941","standard","C128","322","912","1","1","1","13,000.00","13,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:20");
INSERT INTO products VALUES("2052","Studio Monitor,Bx 5 ","1942","standard","C128","322","912","1","1","1","25,935.00","25,935.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:20");
INSERT INTO products VALUES("2053","USB 2pcs,MI-201","1943","standard","C128","397","912","1","1","1","220","220","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:20");
INSERT INTO products VALUES("2054","Bluetooth,MD212","1944","standard","C128","398","912","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:20");
INSERT INTO products VALUES("2055","Bluetooth,S-204","1945","standard","C128","399","912","1","1","1","950","950","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:20");
INSERT INTO products VALUES("2056","Bluetooth,S-207","1946","standard","C128","399","912","1","1","1","1,050.00","1,050.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:20");
INSERT INTO products VALUES("2057","Bluetooth,S-815","1947","standard","C128","399","912","1","1","1","1,050.00","1,050.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:20");
INSERT INTO products VALUES("2058","Bluetooth,Blue","1948","standard","C128","400","912","1","1","1","750","750","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:20");
INSERT INTO products VALUES("2059","Bluetooth,.","1949","standard","C128","39","912","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:20");
INSERT INTO products VALUES("2060","USB 2pcs,V-113","1950","standard","C128","401","912","1","1","1","560","560","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:20");
INSERT INTO products VALUES("2061","Monitor Speaker,E5 ","1951","standard","C128","402","912","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:20");
INSERT INTO products VALUES("2062","Bluetooth,DH-17","1952","standard","C128","403","912","1","1","1","1,050.00","1,050.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:20");
INSERT INTO products VALUES("2063","2:01,SP-252","1953","standard","C128","404","912","1","1","1","3,100.00","3,100.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:20");
INSERT INTO products VALUES("2064","2 pcs,vk-9020m","1954","standard","C128","405","912","1","1","1","11,700.00","11,700.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:20");
INSERT INTO products VALUES("2065","vk-558,.","1955","standard","C128","405","912","1","1","1","7,500.00","7,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:20");
INSERT INTO products VALUES("2066","JHW-V361,.","1956","standard","C128","406","912","1","1","1","1,600.00","1,600.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:20");
INSERT INTO products VALUES("2067","Home theater,DM-8201","1957","standard","C128","407","912","1","1","1","9,500.00","9,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:20");
INSERT INTO products VALUES("2068","Home theater,DM-8202","1958","standard","C128","407","912","1","1","1","10,000.00","10,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:20");
INSERT INTO products VALUES("2069","Home theater,DM-8211","1959","standard","C128","407","912","1","1","1","12,000.00","12,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:20");
INSERT INTO products VALUES("2070","5:01,E932U","1960","standard","C128","408","912","1","1","1","4,700.00","4,700.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:20");
INSERT INTO products VALUES("2071","Bluetooth,E1101","1961","standard","C128","408","912","1","1","1","1,200.00","1,200.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:20");
INSERT INTO products VALUES("2072","Tower Speaker,E620U","1962","standard","C128","408","912","1","1","1","6,800.00","6,800.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:20");
INSERT INTO products VALUES("2073","ALICE _AW430,.","1964","standard","C128","44","914","1","1","1","300","300","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:20");
INSERT INTO products VALUES("2074","Clour,.","1965","standard","C128","142","914","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:20");
INSERT INTO products VALUES("2075","Mandolin,.","1966","standard","C128","260","914","1","1","1","135","135","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:20");
INSERT INTO products VALUES("2076","Sarengi,.","1967","standard","C128","39","914","1","1","1","500","500","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:20");
INSERT INTO products VALUES("2077","normal,","1969","standard","C128","95","915","1","1","1","64.19","64.19","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:20");
INSERT INTO products VALUES("2078","G.Shop,Normal","1970","standard","C128","198","915","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:20");
INSERT INTO products VALUES("2079","Duel,.","1971","standard","C128","247","915","1","1","1","1,000.00","1,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:20");
INSERT INTO products VALUES("2080","Combo,DX 01A","1972","standard","C128","231","915","1","1","1","350","350","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:20");
INSERT INTO products VALUES("2081","Combo-Anisha,DX-01A","1973","standard","C128","232","915","1","1","1","180","180","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:20");
INSERT INTO products VALUES("2082","All,WTB-005","1974","standard","C128","240","916","1","1","1","2,300.00","2,300.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:20");
INSERT INTO products VALUES("2083","All,SP-200","1975","standard","C128","51","916","1","1","1","2,000.00","2,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:20");
INSERT INTO products VALUES("2084","All,SP-1","1976","standard","C128","223","916","1","1","1","1,500.00","1,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:20");
INSERT INTO products VALUES("2085","All,SP2","1977","standard","C128","322","916","1","1","1","2,500.00","2,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:20");
INSERT INTO products VALUES("2086","All,.","1978","standard","C128","39","916","1","1","1","1,102.00","1,102.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:20");
INSERT INTO products VALUES("2087","All Size,.","1979","standard","C128","409","917","1","1","1","121.32","121.32","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:20");
INSERT INTO products VALUES("2088","M Size,.","1980","standard","C128","55","917","1","1","1","75","75","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:20");
INSERT INTO products VALUES("2089","Good Quality,MDY-Dyna and Bya","1982","standard","C128","81","918","1","1","1","4,800.00","4,800.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:20");
INSERT INTO products VALUES("2090","Electronic ,Sound Labs","1983","standard","C128","411","919","1","1","1","8,500.00","8,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:20");
INSERT INTO products VALUES("2091","Electronic ,Talmala digi 108","1984","standard","C128","412","919","1","1","1","10,500.00","10,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:20");
INSERT INTO products VALUES("2092","MAESTRO_DX,.","1985","standard","C128","412","919","1","1","1","7,500.00","7,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:20");
INSERT INTO products VALUES("2093","Electronic ,With Tabla","1986","standard","C128","413","919","1","1","1","13,000.00","13,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:20");
INSERT INTO products VALUES("2094","Ibanez,.","1988","standard","C128","39","921","1","1","1","800","800","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:20");
INSERT INTO products VALUES("2095","City-AG_3,City-AG-3B","1989","standard","C128","44","922","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:20");
INSERT INTO products VALUES("2096","FAN ZONE,1000 BDT","1990","standard","C128","414","923","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:20");
INSERT INTO products VALUES("2097","Special Zone,2500 BDT","1991","standard","C128","414","923","1","1","1","2,500.00","2,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:20");
INSERT INTO products VALUES("2098","VIP ZONE,5000 BDT","1992","standard","C128","414","923","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:20");
INSERT INTO products VALUES("2099","China,CITY ","1994","standard","C128","39","925","1","1","1","1,000.00","1,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:20");
INSERT INTO products VALUES("2100","Flute,Pitch Pipe","1995","standard","C128","95","926","1","1","1","350","350","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:20");
INSERT INTO products VALUES("2101","Guitar,Pitch Pipe","1996","standard","C128","95","926","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:00","2024-01-10 15:01:20");
INSERT INTO products VALUES("2102","Violin,Pitch Pipe","1997","standard","C128","95","926","1","1","1","170","170","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:20");
INSERT INTO products VALUES("2103","Violin,VT-005","1998","standard","C128","223","926","1","1","1","600","600","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:20");
INSERT INTO products VALUES("2104","LED  ,.","1999","standard","C128","415","927","1","1","1","9,000.00","9,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:20");
INSERT INTO products VALUES("2105","Elc & Ac,Uk-2000 City","2000","standard","C128","416","928","1","1","1","3,800.00","3,800.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:20");
INSERT INTO products VALUES("2106","Acoustic,MU20","2002","standard","C128","418","928","1","1","1","4,000.00","4,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:20");
INSERT INTO products VALUES("2107","24 Inch,City-24","2085","standard","C128","452","928","1","1","1","3,100.00","3,100.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:21");
INSERT INTO products VALUES("2108","24 Inch,JSM-UK-24-45 D","2004","standard","C128","136","928","1","1","1","2,800.00","2,800.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:20");
INSERT INTO products VALUES("2109","24 Inch,STI 24 Inch","2005","standard","C128","136","928","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:20");
INSERT INTO products VALUES("2110","24 Inch,UK C","2140","standard","C128","41","928","1","1","1","27","27","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:22");
INSERT INTO products VALUES("2111","26 Inch,City-26","2086","standard","C128","452","928","1","1","1","4,000.00","4,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:21");
INSERT INTO products VALUES("2112","26 Inch,JSM-UK-26-50 R","2008","standard","C128","136","928","1","1","1","3,500.00","3,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:20");
INSERT INTO products VALUES("2113","Acoustic,JSM 26 INCH  ","2010","standard","C128","136","928","1","1","1","3,680.00","3,680.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:20");
INSERT INTO products VALUES("2114","Acoustic,UK-24-45","2011","standard","C128","136","928","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:20");
INSERT INTO products VALUES("2115","with EQ,STI 24 Inch","2012","standard","C128","136","928","1","1","1","4,200.00","4,200.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:20");
INSERT INTO products VALUES("2116","AXE-Ukulele Center-24,AXE-Ukulele Center-24","2013","standard","C128","419","928","1","1","1","2,700.00","2,700.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:20");
INSERT INTO products VALUES("2117","AXE-Ukulele Center-26 new,AXE-Ukulele Center-26 new","2014","standard","C128","419","928","1","1","1","2,900.00","2,900.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:20");
INSERT INTO products VALUES("2118","Janani Music,24 Inch-JM","2037","standard","C128","428","928","1","1","1","3,000.00","3,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:21");
INSERT INTO products VALUES("2119","24 Inch,JSM-24 Inch","2130","standard","C128","469","928","1","1","1","2,800.00","2,800.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:22");
INSERT INTO products VALUES("2120","26 Inch,UKC","2146","standard","C128","478","928","1","1","1","2,900.00","2,900.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:22");
INSERT INTO products VALUES("2121","Electro Acostic,JSM-Chanson ","2021","standard","C128","425","928","1","1","1","5,000.00","5,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:21");
INSERT INTO products VALUES("2122","Electro Acostic 26 Inch,JSM-UE 70143","2022","standard","C128","426","928","1","1","1","4,000.00","4,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:21");
INSERT INTO products VALUES("2123","Electro Acostic 26 Inch,JSM-UE-70182","2023","standard","C128","426","928","1","1","1","4,000.00","4,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:21");
INSERT INTO products VALUES("2124","Electro Acostic 26 Inch,JSM-UE-70282","2024","standard","C128","426","928","1","1","1","4,000.00","4,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:21");
INSERT INTO products VALUES("2125","Electro Acostic 26 Inch,JSM-UE-70392","2025","standard","C128","426","928","1","1","1","4,000.00","4,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:21");
INSERT INTO products VALUES("2126","Electro Acostic 26 Inch,JSM-UE-70572","2026","standard","C128","426","928","1","1","1","4,000.00","4,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:21");
INSERT INTO products VALUES("2127","Cordoba 24,Cordoba Azad","2027","standard","C128","427","928","1","1","1","2,500.00","2,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:21");
INSERT INTO products VALUES("2128","24 Inch,City Normal","2120","standard","C128","287","928","1","1","1","3,200.00","3,200.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:22");
INSERT INTO products VALUES("2129","24 Inch,JSM-UK-24-50","2029","standard","C128","142","928","1","1","1","3,000.00","3,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:21");
INSERT INTO products VALUES("2130","24 Inch,STI-UK-24-30","2030","standard","C128","142","928","1","1","1","2,800.00","2,800.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:21");
INSERT INTO products VALUES("2131","Acoustic,City-Uk-24-30","2031","standard","C128","142","928","1","1","1","3,100.00","3,100.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:21");
INSERT INTO products VALUES("2132","Acoustic,City-UK-26-50","2032","standard","C128","142","928","1","1","1","3,400.00","3,400.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:21");
INSERT INTO products VALUES("2133","Azad 24 Inch,24 Inch","2033","standard","C128","142","928","1","1","1","3,100.00","3,100.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:21");
INSERT INTO products VALUES("2134","City-24 Inch,City-Uk 24-60","2034","standard","C128","142","928","1","1","1","3,000.00","3,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:21");
INSERT INTO products VALUES("2135","City-26 Inch,City-26 -30","2035","standard","C128","142","928","1","1","1","3,000.00","3,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:21");
INSERT INTO products VALUES("2136","PA-U30,.","2170","standard","C128","142","933","1","1","1","130","130","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:22");
INSERT INTO products VALUES("2137","24 Inch,.","2145","standard","C128","478","928","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:22");
INSERT INTO products VALUES("2138","Acoustic,CITY ","2109","standard","C128","460","928","1","1","1","3,000.00","3,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:22");
INSERT INTO products VALUES("2139","24 Inch,JSM-DL-23","2040","standard","C128","431","928","1","1","1","3,000.00","3,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:21");
INSERT INTO products VALUES("2140","Acoustic,24 Inch","2041","standard","C128","432","928","1","1","1","3,000.00","3,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:21");
INSERT INTO products VALUES("2141","Ovation,RNG-Ovation","2042","standard","C128","51","928","1","1","1","3,800.00","3,800.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:21");
INSERT INTO products VALUES("2142","Acoustic,Baritone 30 Inch City","2043","standard","C128","433","928","1","1","1","5,500.00","5,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:21");
INSERT INTO products VALUES("2143","Acoustic,Tenor 26 Inch City","2044","standard","C128","433","928","1","1","1","4,500.00","4,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:21");
INSERT INTO products VALUES("2144","Electro Acostic,Baritone 30 Inch City","2045","standard","C128","433","928","1","1","1","6,500.00","6,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:21");
INSERT INTO products VALUES("2145","Epiphone-Ukulele Center-26 new,Epiphone-Ukulele Center-26 new","2046","standard","C128","434","928","1","1","1","2,900.00","2,900.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:21");
INSERT INTO products VALUES("2146","24 Inch,MKU-SEA City","2047","standard","C128","148","928","1","1","1","3,400.00","3,400.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:21");
INSERT INTO products VALUES("2147","China_24 inch,.","2137","standard","C128","473","928","1","1","1","2,800.00","2,800.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:22");
INSERT INTO products VALUES("2148","Acoustic,GU 17","2050","standard","C128","436","928","1","1","1","3,200.00","3,200.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:21");
INSERT INTO products VALUES("2149","Acoustic,24 Inch GU-2413","2051","standard","C128","437","928","1","1","1","3,800.00","3,800.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:21");
INSERT INTO products VALUES("2150","24 Inch,AZAD-MUK-008","2052","standard","C128","438","928","1","1","1","3,100.00","3,100.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:21");
INSERT INTO products VALUES("2151","24 Inch,VK-10S City","2053","standard","C128","439","928","1","1","1","3,200.00","3,200.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:21");
INSERT INTO products VALUES("2152","Acoustic,JSM UK-L-100 BK","2054","standard","C128","439","928","1","1","1","3,000.00","3,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:21");
INSERT INTO products VALUES("2153","HOKE-Ukulele Center-26,HOKE-Ukulele Center-26","2055","standard","C128","440","928","1","1","1","2,700.00","2,700.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:21");
INSERT INTO products VALUES("2154","HOLA ! -Package-24,HOLA ! -Package-24","2057","standard","C128","442","928","1","1","1","4,000.00","4,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:21");
INSERT INTO products VALUES("2155","24 Inch,City. ","2058","standard","C128","159","928","1","1","1","3,400.00","3,400.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:21");
INSERT INTO products VALUES("2156","Acoustic,UKC-SMH","2059","standard","C128","443","928","1","1","1","3,200.00","3,200.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:21");
INSERT INTO products VALUES("2157","24 Inch,AZAD-24 INCH","2060","standard","C128","379","928","1","1","1","3,100.00","3,100.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:21");
INSERT INTO products VALUES("2158","Acoustic,JSM 26 INCH PEAVEY","2062","standard","C128","379","928","1","1","1","3,800.00","3,800.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:21");
INSERT INTO products VALUES("2159","Acoustic,JSM-26 INCH","2063","standard","C128","379","928","1","1","1","3,800.00","3,800.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:21");
INSERT INTO products VALUES("2160","Acoustic,UKC-26","2091","standard","C128","453","928","1","1","1","3,200.00","3,200.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:21");
INSERT INTO products VALUES("2161","Joker 24,Joker Azad","2065","standard","C128","444","928","1","1","1","2,500.00","2,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:21");
INSERT INTO products VALUES("2162","26 Inch-KYTH,.","2066","standard","C128","225","928","1","1","1","3,200.00","3,200.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:21");
INSERT INTO products VALUES("2163","UK210-24,.","2067","standard","C128","225","928","1","1","1","3,600.00","3,600.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:21");
INSERT INTO products VALUES("2164","Acoustic,UC-24","2068","standard","C128","445","928","1","1","1","2,600.00","2,600.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:21");
INSERT INTO products VALUES("2165","Acoustic,UC-26","2069","standard","C128","445","928","1","1","1","3,200.00","3,200.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:21");
INSERT INTO products VALUES("2166","Acoustic,24 Inch JSM(Kala)","2070","standard","C128","446","928","1","1","1","3,000.00","3,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:21");
INSERT INTO products VALUES("2167","24 Inch,UK-U1-24-BU JSM","2072","standard","C128","161","928","1","1","1","3,000.00","3,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:21");
INSERT INTO products VALUES("2168","24 Inch,JSM-UK-23","2073","standard","C128","226","928","1","1","1","3,000.00","3,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:21");
INSERT INTO products VALUES("2169","26 Inch,JSM-UK-26-100","2074","standard","C128","226","928","1","1","1","3,000.00","3,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:21");
INSERT INTO products VALUES("2170","Acoustic,JSM 26 INCH UK-26-100","2075","standard","C128","226","928","1","1","1","3,000.00","3,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:21");
INSERT INTO products VALUES("2171","Acoustic,UKC-Black","2077","standard","C128","449","928","1","1","1","5,800.00","5,800.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:21");
INSERT INTO products VALUES("2172","Acoustic,JSM LU-BT01 26"","2079","standard","C128","162","928","1","1","1","3,200.00","3,200.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:21");
INSERT INTO products VALUES("2173","Acoustic,JSM-24-LU-BC-01","2080","standard","C128","162","928","1","1","1","3,000.00","3,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:21");
INSERT INTO products VALUES("2174","Acoustic,LU-BT01","2081","standard","C128","162","928","1","1","1","4,000.00","4,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:21");
INSERT INTO products VALUES("2175","26 Inch,JSM-26","2083","standard","C128","450","928","1","1","1","3,000.00","3,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:21");
INSERT INTO products VALUES("2176","MAHALO-Ukulele Center-24,MAHALO-Ukulele Center-24","2084","standard","C128","451","928","1","1","1","2,600.00","2,600.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:21");
INSERT INTO products VALUES("2177","26 Inch,STI 26","2087","standard","C128","452","928","1","1","1","3,500.00","3,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:21");
INSERT INTO products VALUES("2178","Acoustic,24 Inch JSM (Matthew)","2088","standard","C128","453","928","1","1","1","3,000.00","3,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:21");
INSERT INTO products VALUES("2179","Acoustic,26 Inch JSM (Matthew)","2089","standard","C128","453","928","1","1","1","3,200.00","3,200.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:21");
INSERT INTO products VALUES("2180","Acoustic,JSM 26 INCH MU-26 S","2090","standard","C128","453","928","1","1","1","3,000.00","3,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:21");
INSERT INTO products VALUES("2181","Mentreel-26 Inch,.","2092","standard","C128","454","928","1","1","1","3,200.00","3,200.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:21");
INSERT INTO products VALUES("2182","21 Inch,STI 21 Inch","2093","standard","C128","56","928","1","1","1","1,800.00","1,800.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:21");
INSERT INTO products VALUES("2183","Normal,S-245","2094","standard","C128","39","928","1","1","1","3,500.00","3,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:21");
INSERT INTO products VALUES("2184","Normal,S-275","2095","standard","C128","39","928","1","1","1","4,500.00","4,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:21");
INSERT INTO products VALUES("2185","Normal,S-27aq","2096","standard","C128","39","928","1","1","1","5,500.00","5,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:21");
INSERT INTO products VALUES("2186","Normal,S-27M","2097","standard","C128","39","928","1","1","1","6,000.00","6,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:22");
INSERT INTO products VALUES("2187","Acoustic,U-200C City","2098","standard","C128","455","928","1","1","1","2,800.00","2,800.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:22");
INSERT INTO products VALUES("2188","Acoustic,None City New","2099","standard","C128","456","928","1","1","1","4,000.00","4,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:22");
INSERT INTO products VALUES("2189","Acoustic,U-250C City","2100","standard","C128","456","928","1","1","1","4,000.00","4,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:22");
INSERT INTO products VALUES("2190","Acoustic,U-290C City","2101","standard","C128","456","928","1","1","1","4,000.00","4,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:22");
INSERT INTO products VALUES("2191","Acoustic,U-350C City","2102","standard","C128","456","928","1","1","1","4,000.00","4,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:22");
INSERT INTO products VALUES("2192","Acoustic,U260C City","2103","standard","C128","456","928","1","1","1","4,000.00","4,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:22");
INSERT INTO products VALUES("2193","Acoustic,U360C City","2104","standard","C128","456","928","1","1","1","4,000.00","4,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:22");
INSERT INTO products VALUES("2194","Acoustic ,26 Inch MG-262C","2105","standard","C128","457","928","1","1","1","4,300.00","4,300.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:22");
INSERT INTO products VALUES("2195","Acoustic,JSM-45","2106","standard","C128","100","928","1","1","1","3,500.00","3,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:22");
INSERT INTO products VALUES("2196","QTE 24,QTE Azad","2107","standard","C128","458","928","1","1","1","2,500.00","2,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:01","2024-01-10 15:01:22");
INSERT INTO products VALUES("2197","24 Inch,LABU-24 Inch","2111","standard","C128","462","928","1","1","1","3,100.00","3,100.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:02","2024-01-10 15:01:22");
INSERT INTO products VALUES("2198","Acoustic,UK-24YS","2112","standard","C128","463","928","1","1","1","3,200.00","3,200.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:02","2024-01-10 15:01:22");
INSERT INTO products VALUES("2199","AXE,Normal","2113","standard","C128","115","928","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:02","2024-01-10 15:01:22");
INSERT INTO products VALUES("2200","Winfer,STI-WF-23H","2114","standard","C128","115","928","1","1","1","2,850.00","2,850.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:02","2024-01-10 15:01:22");
INSERT INTO products VALUES("2201","XCC,Normal","2115","standard","C128","115","928","1","1","1","2,850.00","2,850.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:02","2024-01-10 15:01:22");
INSERT INTO products VALUES("2202","Zealux,STI-ZUK-334","2116","standard","C128","115","928","1","1","1","2,850.00","2,850.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:02","2024-01-10 15:01:22");
INSERT INTO products VALUES("2203","26 Inch,UK-26","2118","standard","C128","465","928","1","1","1","3,500.00","3,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:02","2024-01-10 15:01:22");
INSERT INTO products VALUES("2204","Costellation,.","2121","standard","C128","62","928","1","1","1","3,200.00","3,200.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:02","2024-01-10 15:01:22");
INSERT INTO products VALUES("2205","Garage band,.","2122","standard","C128","62","928","1","1","1","3,600.00","3,600.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:02","2024-01-10 15:01:22");
INSERT INTO products VALUES("2206","Acoustic,JSM 26 INCH Summer","2123","standard","C128","168","928","1","1","1","3,500.00","3,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:02","2024-01-10 15:01:22");
INSERT INTO products VALUES("2207","Acoustic,JSM 26 INCH Winter","2124","standard","C128","168","928","1","1","1","3,600.00","3,600.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:02","2024-01-10 15:01:22");
INSERT INTO products VALUES("2208","Acoustic,TUK-200-26"","2125","standard","C128","168","928","1","1","1","3,200.00","3,200.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:02","2024-01-10 15:01:22");
INSERT INTO products VALUES("2209","Tayste-Ukulele Center-26 new,Tayste-Ukulele Center-26 new","2126","standard","C128","467","928","1","1","1","2,900.00","2,900.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:02","2024-01-10 15:01:22");
INSERT INTO products VALUES("2210","26 Inch,JSM-Uk-26 Q","2128","standard","C128","32","928","1","1","1","3,000.00","3,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:02","2024-01-10 15:01:22");
INSERT INTO products VALUES("2211","TGM   ,TGM Azad","2129","standard","C128","468","928","1","1","1","2,500.00","2,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:02","2024-01-10 15:01:22");
INSERT INTO products VALUES("2212","TGM-Ukulele Center-24,TGM-Ukulele Center-24","2131","standard","C128","173","928","1","1","1","2,600.00","2,600.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:02","2024-01-10 15:01:22");
INSERT INTO products VALUES("2213","TGM-Ukulele Center-26,TGM-Ukulele Center-26","2132","standard","C128","173","928","1","1","1","2,900.00","2,900.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:02","2024-01-10 15:01:22");
INSERT INTO products VALUES("2214","EQ_24,.","2135","standard","C128","472","928","1","1","1","6,500.00","6,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:02","2024-01-10 15:01:22");
INSERT INTO products VALUES("2215","24 hole,AZAD-24 INCH","2136","standard","C128","292","928","1","1","1","3,100.00","3,100.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:02","2024-01-10 15:01:22");
INSERT INTO products VALUES("2216","YAHAMA-Ukulele Center-26 new,YAHAMA-Ukulele Center-26 new","2138","standard","C128","474","928","1","1","1","2,900.00","2,900.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:02","2024-01-10 15:01:22");
INSERT INTO products VALUES("2217","24 Inch,GLS-1 City","2139","standard","C128","41","928","1","1","1","3,400.00","3,400.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:02","2024-01-10 15:01:22");
INSERT INTO products VALUES("2218","labu_UK 24,.","2141","standard","C128","41","928","1","1","1","2,900.00","2,900.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:02","2024-01-10 15:01:22");
INSERT INTO products VALUES("2219","Janani Music,26 Inch JM","2142","standard","C128","475","928","1","1","1","3,000.00","3,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:02","2024-01-10 15:01:22");
INSERT INTO products VALUES("2220","YAMAHA-Ukulele Center-24,YAMAHA-Ukulele Center-24","2143","standard","C128","476","928","1","1","1","2,700.00","2,700.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:02","2024-01-10 15:01:22");
INSERT INTO products VALUES("2221","24 Inch,JSM-ZUK-334","2147","standard","C128","65","928","1","1","1","3,000.00","3,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:02","2024-01-10 15:01:22");
INSERT INTO products VALUES("2222","Normal,24 ","2148","standard","C128","65","928","1","1","1","4,300.00","4,300.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:02","2024-01-10 15:01:22");
INSERT INTO products VALUES("2223","Normal,Design ukulele","2149","standard","C128","65","928","1","1","1","4,800.00","4,800.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:02","2024-01-10 15:01:22");
INSERT INTO products VALUES("2224","Normal,STI-ZUK-334","2150","standard","C128","65","928","1","1","1","3,200.00","3,200.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:02","2024-01-10 15:01:22");
INSERT INTO products VALUES("2225","Normal,ZUK-834","2151","standard","C128","65","928","1","1","1","4,300.00","4,300.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:02","2024-01-10 15:01:22");
INSERT INTO products VALUES("2226","Normal,ZUK334","2152","standard","C128","65","928","1","1","1","4,000.00","4,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:02","2024-01-10 15:01:22");
INSERT INTO products VALUES("2227","With Input,334 EQ","2153","standard","C128","65","928","1","1","1","4,900.00","4,900.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:02","2024-01-10 15:01:22");
INSERT INTO products VALUES("2228","With Input,337 (EQ)","2154","standard","C128","65","928","1","1","1","4,900.00","4,900.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:02","2024-01-10 15:01:22");
INSERT INTO products VALUES("2229","With Input,STI-ZUK-334 (EQ)","2155","standard","C128","65","928","1","1","1","4,100.00","4,100.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:02","2024-01-10 15:01:22");
INSERT INTO products VALUES("2230","With Input,ZUK334","2156","standard","C128","65","928","1","1","1","4,500.00","4,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:02","2024-01-10 15:01:22");
INSERT INTO products VALUES("2231","Octave Guitar,Octave Guitar","2161","standard","C128","39","930","1","1","1","100","100","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:02","2024-01-10 15:01:22");
INSERT INTO products VALUES("2232","Rifat,.","2162","standard","C128","39","930","1","1","1","57","57","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:02","2024-01-10 15:01:22");
INSERT INTO products VALUES("2233","flat,.","2163","standard","C128","313","931","1","1","1","125","125","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:02","2024-01-10 15:01:22");
INSERT INTO products VALUES("2234","Lossoe,Black-Left","2164","standard","C128","39","931","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:02","2024-01-10 15:01:22");
INSERT INTO products VALUES("2235","Lossoe,Black-Right","2165","standard","C128","39","931","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:02","2024-01-10 15:01:22");
INSERT INTO products VALUES("2236","Normal,AU02","2167","standard","C128","95","933","1","1","1","110.77","110.77","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:02","2024-01-10 15:01:22");
INSERT INTO products VALUES("2237","White Nylon,Anisha","2168","standard","C128","479","933","1","1","1","100","100","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:02","2024-01-10 15:01:22");
INSERT INTO products VALUES("2238","nylgut,.","2169","standard","C128","418","933","1","1","1","37","37","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:02","2024-01-10 15:01:22");
INSERT INTO products VALUES("2239","Normal,U105","2171","standard","C128","280","933","1","1","1","92","92","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:02","2024-01-10 15:01:22");
INSERT INTO products VALUES("2240","NIHIL- White Nylon,NIHIL- White Nylon","2172","standard","C128","480","933","1","1","1","75","75","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:02","2024-01-10 15:01:22");
INSERT INTO products VALUES("2241","White Nylon,RU-24 S/C","2174","standard","C128","203","933","1","1","1","120","120","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:02","2024-01-10 15:01:23");
INSERT INTO products VALUES("2242","Normal,RX-U30 JSM","2175","standard","C128","174","933","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:02","2024-01-10 15:01:23");
INSERT INTO products VALUES("2243","6 inc,BB-819","2177","standard","C128","39","935","1","1","1","400","400","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:02","2024-01-10 15:01:23");
INSERT INTO products VALUES("2244","Normal,FA-10","2179","standard","C128","214","936","1","1","1","500","500","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:02","2024-01-10 15:01:23");
INSERT INTO products VALUES("2245","MAT,.","2181","standard","C128","82","937","1","1","1","4,233.33","4,233.33","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:02","2024-01-10 15:01:23");
INSERT INTO products VALUES("2246","Azad,.","2201","standard","C128","94","937","1","1","1","4,200.00","4,200.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:02","2024-01-10 15:01:23");
INSERT INTO products VALUES("2247","Electric,CITY ","2183","standard","C128","126","937","1","1","1","10,000.00","10,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:02","2024-01-10 15:01:23");
INSERT INTO products VALUES("2248","V_20,.","2185","standard","C128","482","937","1","1","1","3,425.00","3,425.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:02","2024-01-10 15:01:23");
INSERT INTO products VALUES("2249",",MDY SV-1","2186","standard","C128","436","937","1","1","1","4,800.00","4,800.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:02","2024-01-10 15:01:23");
INSERT INTO products VALUES("2250","S.T.I ,picup","2187","standard","C128","211","937","1","1","1","4,400.00","4,400.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:02","2024-01-10 15:01:23");
INSERT INTO products VALUES("2251","Normal,City. ","2188","standard","C128","483","937","1","1","1","4,200.00","4,200.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:02","2024-01-10 15:01:23");
INSERT INTO products VALUES("2252","China,BLK","2189","standard","C128","225","937","1","1","1","4,800.00","4,800.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:02","2024-01-10 15:01:23");
INSERT INTO products VALUES("2253","Good Quality,SV-2","2191","standard","C128","484","937","1","1","1","7,735.00","7,735.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:02","2024-01-10 15:01:23");
INSERT INTO products VALUES("2254","Good Quality,Black","2193","standard","C128","39","937","1","1","1","4,000.00","4,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:02","2024-01-10 15:01:23");
INSERT INTO products VALUES("2255","Normal,City V ","2195","standard","C128","39","937","1","1","1","4,000.00","4,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:02","2024-01-10 15:01:23");
INSERT INTO products VALUES("2256","Normal,City V3","2196","standard","C128","39","937","1","1","1","4,500.00","4,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:02","2024-01-10 15:01:23");
INSERT INTO products VALUES("2257","Indian  ,JS Musical Normal","2197","standard","C128","115","937","1","1","1","3,700.00","3,700.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:02","2024-01-10 15:01:23");
INSERT INTO products VALUES("2258","Indian  ,JS Musical PICK UP","2198","standard","C128","115","937","1","1","1","4,050.00","4,050.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:02","2024-01-10 15:01:23");
INSERT INTO products VALUES("2259","Indian  ,NGM","2199","standard","C128","115","937","1","1","1","3,600.00","3,600.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:02","2024-01-10 15:01:23");
INSERT INTO products VALUES("2260",",mdy- ","2200","standard","C128","94","937","1","1","1","4,800.00","4,800.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:02","2024-01-10 15:01:23");
INSERT INTO products VALUES("2261","Labu,Electric","2203","standard","C128","94","937","1","1","1","6,000.00","6,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:02","2024-01-10 15:01:23");
INSERT INTO products VALUES("2262","Labu,Normal  ","2206","standard","C128","94","938","1","1","1","0","0","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:02","2024-01-10 15:01:23");
INSERT INTO products VALUES("2263","Chaina,.","2217","standard","C128","82","946","1","1","1","1,100.00","1,100.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:02","2024-01-10 15:01:23");
INSERT INTO products VALUES("2264","Indian  ,.","2209","standard","C128","39","940","1","1","1","250","250","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:02","2024-01-10 15:01:23");
INSERT INTO products VALUES("2265","Yeanling,.","2218","standard","C128","82","946","1","1","1","900","900","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:03","2024-01-10 15:01:23");
INSERT INTO products VALUES("2266","ME-044,","2219","standard","C128","485","946","1","1","1","600","600","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:03","2024-01-10 15:01:23");
INSERT INTO products VALUES("2267","Normal,A703","2220","standard","C128","95","53","1","1","1","106.36","106.36","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:03","2024-01-10 15:01:23");
INSERT INTO products VALUES("2268","1,.","2221","standard","C128","486","53","1","1","1","31.69","31.69","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:03","2024-01-10 15:01:23");
INSERT INTO products VALUES("2269","2,.","2222","standard","C128","486","53","1","1","1","31.22","31.22","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:03","2024-01-10 15:01:23");
INSERT INTO products VALUES("2270","3,.","2223","standard","C128","486","53","1","1","1","33.2","33.2","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:03","2024-01-10 15:01:23");
INSERT INTO products VALUES("2271","4 no.,.","2224","standard","C128","486","53","1","1","1","23","23","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:03","2024-01-10 15:01:23");
INSERT INTO products VALUES("2272","Studio Package,M. ","2226","standard","C128","322","54","1","1","1","23,000.00","23,000.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:03","2024-01-10 15:01:23");
INSERT INTO products VALUES("2273","All,DF1511A","2228","standard","C128","488","32","1","1","1","2,500.00","2,500.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:03","2024-01-10 15:01:23");
INSERT INTO products VALUES("2274","All,FL-1","2229","standard","C128","214","32","1","1","1","1,400.00","1,400.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:03","2024-01-10 15:01:23");
INSERT INTO products VALUES("2275","All,SVP2","2230","standard","C128","128","32","1","1","1","1,327.24","1,327.24","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:03","2024-01-10 15:01:23");
INSERT INTO products VALUES("2276","3D Vr Box,.","2231","standard","C128","39","55","1","1","1","3,560.00","3,560.00","0","","","","","","","1","zummXD2dvAtI.png","","","","","","","","","","1","2024-01-10 14:59:03","2024-01-10 15:01:23");



CREATE TABLE `purchase_product_return` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `return_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `product_batch_id` int(11) DEFAULT NULL,
  `variant_id` int(11) DEFAULT NULL,
  `qty` double NOT NULL,
  `purchase_unit_id` int(11) NOT NULL,
  `net_unit_cost` double NOT NULL,
  `discount` double NOT NULL,
  `tax_rate` double NOT NULL,
  `tax` double NOT NULL,
  `total` double NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO purchase_product_return VALUES("1","1","3","","","1","1","200","0","0","0","200","","2019-12-07 06:19:03");



CREATE TABLE `purchases` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(191) NOT NULL,
  `user_id` int(11) NOT NULL,
  `warehouse_id` int(11) NOT NULL,
  `supplier_id` int(11) DEFAULT NULL,
  `item` int(11) NOT NULL,
  `total_qty` double NOT NULL,
  `total_discount` double NOT NULL,
  `total_tax` double NOT NULL,
  `total_cost` double NOT NULL,
  `order_tax_rate` double DEFAULT NULL,
  `order_tax` double DEFAULT NULL,
  `order_discount` double DEFAULT NULL,
  `shipping_cost` double DEFAULT NULL,
  `grand_total` double NOT NULL,
  `paid_amount` double NOT NULL,
  `status` int(11) NOT NULL,
  `payment_status` int(11) NOT NULL,
  `document` varchar(191) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=157 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO purchases VALUES("12","pr-20180808-051614","1","2","3","2","300","0","0","10200","0","0","0","0","10200","0","1","1","","","2018-08-08 07:16:14","2018-09-21 22:53:24");
INSERT INTO purchases VALUES("13","pr-20180809-054723","1","2","3","4","410","0","7304.35","92600","10","9260","0","500","102360","300","1","1","","","2018-08-08 19:47:23","2018-08-29 23:07:18");
INSERT INTO purchases VALUES("14","pr-20180809-012348","1","1","1","5","400","0","4452.17","75300","10","7480","500","1000","83280","0","1","1","","","2018-08-09 03:23:48","2018-08-09 03:23:48");
INSERT INTO purchases VALUES("15","pr-20180903-100609","1","1","1","1","20","0","1600","17600","0","0","0","100","17700","0","1","1","","","2018-09-03 00:06:09","2018-10-07 18:11:24");
INSERT INTO purchases VALUES("16","pr-20180903-100714","1","2","3","1","20","0","1600","17600","0","0","0","150","17750","3350","1","1","","","2018-09-03 00:07:14","2018-10-06 20:57:36");
INSERT INTO purchases VALUES("18","pr-20181022-042625","1","1","1","1","50","0","0","50","0","0","","","50","0","1","1","","","2018-10-22 06:26:25","2018-10-22 06:26:25");
INSERT INTO purchases VALUES("19","pr-20181022-042652","1","2","3","1","50","0","0","50","0","0","","","50","0","1","1","","","2018-10-22 06:26:52","2018-10-22 06:26:52");
INSERT INTO purchases VALUES("20","pr-20181023-071420","11","1","1","1","15","0","750","8250","0","0","","","8250","0","1","1","","","2018-10-22 21:14:20","2018-10-22 21:14:20");
INSERT INTO purchases VALUES("21","pr-20181023-071441","11","2","3","1","15","0","750","8250","0","0","0","0","8250","0","1","1","","","2018-10-22 21:14:41","2018-10-22 21:14:58");
INSERT INTO purchases VALUES("22","pr-20181101-045903","1","1","1","1","5","0","400","4400","0","0","","","4400","0","1","1","","","2018-10-31 18:59:03","2018-10-31 18:59:03");
INSERT INTO purchases VALUES("23","pr-20181101-045928","1","2","3","1","5","0","400","4400","10","430","100","0","4730","500","1","1","","","2018-10-31 18:59:28","2018-12-03 20:01:34");
INSERT INTO purchases VALUES("24","pr-20181105-091819","1","2","1","2","20","0","1450","15950","0","0","","","15950","15950","1","2","","","2018-11-04 22:18:19","2018-11-04 22:21:27");
INSERT INTO purchases VALUES("25","pr-20181205-053429","1","1","1","2","30","0","0","4500","0","0","100","50","4450","4450","1","2","","","2018-12-04 18:34:29","2018-12-04 18:34:43");
INSERT INTO purchases VALUES("26","pr-20181205-053508","1","2","3","2","30","0","0","4500","0","0","","","4500","0","1","1","","","2018-12-04 18:35:08","2018-12-09 19:20:52");
INSERT INTO purchases VALUES("27","pr-20181219-055716","1","2","","1","10","0","0","10","0","0","0","0","10","10","1","2","","","2018-12-18 18:57:16","2018-12-19 19:34:39");
INSERT INTO purchases VALUES("33","pr-20181224-063840","1","1","","1","10","0","0","10","0","0","0","0","10","0","1","1","","","2018-12-23 19:38:40","2018-12-23 22:04:21");
INSERT INTO purchases VALUES("34","pr-20190103-070123","1","1","1","2","4","0","260","2860","0","0","","","2860","2860","1","2","","","2019-01-02 20:01:23","2019-01-28 23:03:24");
INSERT INTO purchases VALUES("35","pr-20190129-095448","9","1","1","2","4","0","0","600","0","0","","","600","100","1","1","","","2019-01-28 22:54:48","2019-02-07 02:06:40");
INSERT INTO purchases VALUES("36","pr-20190129-095558","9","2","1","2","5","0","0","650","0","0","","","650","650","1","2","","","2019-01-28 22:55:58","2019-01-28 23:03:02");
INSERT INTO purchases VALUES("37","pr-20190209-102138","1","2","1","3","18","0","580","6390","0","0","0","0","6390","6390","1","2","","","2019-02-08 23:21:38","2019-06-13 00:13:51");
INSERT INTO purchases VALUES("38","pr-20190209-102208","1","1","1","2","13","0","150","1660","0","0","0","0","1660","1660","1","2","","","2019-02-08 23:22:08","2019-02-08 23:49:40");
INSERT INTO purchases VALUES("39","pr-20190209-104413","1","1","1","2","3","10","63","885","10","88.5","","","973.5","973.5","1","2","","","2019-02-08 23:44:13","2019-02-08 23:49:59");
INSERT INTO purchases VALUES("40","pr-20190303-103917","1","1","1","1","10","0","0","100","0","0","","","100","100","1","2","","","2019-03-02 23:39:17","2019-03-02 23:40:46");
INSERT INTO purchases VALUES("41","pr-20190303-104358","1","2","","2","15","0","320","3570","0","0","","","3570","1000","1","1","","","2019-03-02 23:43:58","2019-04-13 07:02:41");
INSERT INTO purchases VALUES("42","pr-20190404-095757","1","1","3","2","2","0","0","300","0","0","0","0","300","300","1","2","","","2019-04-03 23:57:57","2019-04-13 09:50:08");
INSERT INTO purchases VALUES("43","pr-20190613-101600","1","2","1","2","6","0","390","4290","0","0","","","4290","4290","1","2","","","2019-06-13 00:16:00","2019-10-19 05:29:25");
INSERT INTO purchases VALUES("44","pr-20191019-033119","1","2","3","2","2","0","130","1430","0","0","","","1430","0","1","1","","","2019-10-19 05:31:19","2019-10-19 05:31:19");
INSERT INTO purchases VALUES("46","pr-20191103-113949","1","2","3","2","20","0","0","150","0","0","","50","200","200","1","2","","","2019-11-03 01:39:49","2019-11-03 01:42:22");
INSERT INTO purchases VALUES("47","pr-20191109-112510","1","1","","2","3","10","63","885","0","0","","66","951","0","1","1","","","2019-11-09 00:25:10","2019-11-09 00:25:10");
INSERT INTO purchases VALUES("48","pr-20191110-070221","1","2","","1","100","0","0","100","0","0","","40","140","0","1","1","","","2019-11-10 08:02:21","2019-11-10 08:02:21");
INSERT INTO purchases VALUES("49","pr-20191111-102155","1","2","1","1","10","0","800","8800","0","0","0","50","8850","7000","1","1","","","2019-11-10 23:21:55","2020-01-01 03:22:25");
INSERT INTO purchases VALUES("55","pr-20191127-102835","1","1","","2","2","0","0","4","0","0","","","4","4","1","2","","","2019-11-27 11:28:35","2020-01-01 03:21:52");
INSERT INTO purchases VALUES("56","pr-20191127-102906","1","2","","1","1","0","0","2","0","0","0","0","2","2","1","2","","","2019-11-27 11:29:06","2020-01-01 03:21:44");
INSERT INTO purchases VALUES("57","pr-20191204-110749","1","1","1","1","1","0","0","200","0","0","","20","220","220","1","2","","","2019-12-04 12:07:49","2019-12-04 12:11:24");
INSERT INTO purchases VALUES("58","pr-20191205-102110","1","1","1","2","2","0","0","4","0","0","0","0","4","4","1","2","","","2019-12-04 23:21:10","2020-01-01 03:21:37");
INSERT INTO purchases VALUES("59","pr-20191221-041851","1","1","","3","3","0","0","6","0","0","0","0","6","6","1","2","","","2019-12-21 05:18:51","2020-01-01 03:21:31");
INSERT INTO purchases VALUES("61","pr-20200101-010631","1","2","1","3","30","0","0","60","0","0","","","60","60","1","2","","","2020-01-01 02:06:31","2020-01-01 02:07:50");
INSERT INTO purchases VALUES("62","pr-20200101-022402","1","2","","1","3","0","150","1650","0","0","","","1650","1650","1","2","","","2020-01-01 03:24:02","2020-08-12 08:28:52");
INSERT INTO purchases VALUES("67","pr-20200204-110041","1","2","1","2","2","0","0","300","0","0","","","300","300","1","2","","","2020-02-04 12:00:41","2020-02-04 12:00:50");
INSERT INTO purchases VALUES("69","pr-20200302-115510","1","2","","1","50","0","0","50","0","0","","","50","50","1","2","","","2020-03-02 00:55:10","2020-03-02 00:58:20");
INSERT INTO purchases VALUES("70","pr-20200302-115603","1","1","1","1","50","0","0","50","0","0","","","50","50","1","2","","","2020-03-02 00:56:03","2020-03-02 00:58:11");
INSERT INTO purchases VALUES("71","pr-20200406-073512","1","2","3","3","11","0","150","3050","10","305","","","3355","2000","1","1","","","2020-04-06 09:35:12","2020-04-06 09:38:23");
INSERT INTO purchases VALUES("72","pr-20200816-100207","1","2","1","1","10","5000","3750","28750","0","0","","2000","30750","0","1","1","","","2020-08-16 12:02:07","2020-08-16 12:02:07");
INSERT INTO purchases VALUES("73","pr-20200927-125533","1","1","","1","2","0","0","2","0","0","0","0","2","0","1","1","","","2020-09-27 02:55:33","2020-09-27 05:07:44");
INSERT INTO purchases VALUES("74","pr-20201024-070201","1","2","1","2","15","0","5270","41470","0","0","0","0","41470","0","1","1","","","2020-10-23 21:02:01","2020-10-23 21:03:16");
INSERT INTO purchases VALUES("83","pr-20201027-045611","1","1","","1","2","0","0","2","0","0","","","2","0","1","1","","","2020-10-26 18:56:11","2020-10-26 18:56:11");
INSERT INTO purchases VALUES("84","pr-20201027-045658","1","1","","1","2","0","0","4","0","0","","","4","0","1","1","","","2020-10-26 18:56:58","2020-10-26 18:56:58");
INSERT INTO purchases VALUES("85","pr-20201102-092952","1","1","","1","1","0","32","352","0","0","","","352","0","1","1","","asasda
dasdasd","2020-11-01 22:29:52","2020-11-01 22:29:52");
INSERT INTO purchases VALUES("87","pr-20201102-093644","1","1","","1","1","0","32","352","0","0","0","0","352","0","1","1","","kjkljklj
lljkljkljkl
jhjhjh.","2020-11-01 22:36:44","2020-11-02 00:20:34");
INSERT INTO purchases VALUES("89","pr-20201116-030145","1","1","","2","2","0","32","353","0","0","","","353","0","1","1","","","2020-11-16 04:01:45","2020-11-16 04:01:45");
INSERT INTO purchases VALUES("90","pr-20201118-061543","1","2","","1","10","0","4500","34500","0","0","1000","100","33600","33000","1","1","","","2020-11-17 19:15:43","2020-11-17 19:20:36");
INSERT INTO purchases VALUES("98","pr-20210307-021405","1","1","","1","10","0","0","10","0","0","","","10","0","1","1","","","2021-03-07 03:14:05","2021-03-07 03:14:05");
INSERT INTO purchases VALUES("99","pr-20210307-021955","1","1","","1","5","0","0","5","0","0","0","0","5","0","1","1","","","2021-03-07 03:19:55","2021-03-09 04:43:48");
INSERT INTO purchases VALUES("100","pr-20210307-022116","1","2","","1","10","0","0","10","0","0","0","0","10","0","1","1","","","2021-03-07 03:21:16","2021-03-09 04:45:19");
INSERT INTO purchases VALUES("102","pr-20210309-023435","1","1","","1","5","0","0","5","0","0","0","0","5","0","1","1","","","2021-03-09 03:34:35","2021-03-10 22:47:53");
INSERT INTO purchases VALUES("105","pr-20210326-113914","1","1","","2","2","0","0","101","0","0","0","0","101","0","1","1","","","2021-03-26 01:39:14","2021-04-09 11:53:48");
INSERT INTO purchases VALUES("106","pr-20210524-071854","1","1","","1","1","0","32","352","0","0","","","352","0","1","1","","","2021-05-24 09:18:54","2021-05-24 09:18:54");
INSERT INTO purchases VALUES("113","pr-20210530-014119","1","1","","2","2","0","0","201","0","0","0","0","201","0","1","1","","","2021-05-30 03:41:19","2021-05-30 03:41:19");
INSERT INTO purchases VALUES("114","pr-20211016-034812","1","1","1","1","10","0","500","5500","0","0","","","5500","0","4","1","","","2021-10-16 15:48:12","2021-10-16 15:48:12");
INSERT INTO purchases VALUES("115","pr-20211219-015635","1","1","6","1","1000","0","0","100000","0","0","","","100000","0","1","1","","","2021-12-19 13:56:35","2021-12-19 13:56:35");
INSERT INTO purchases VALUES("116","pr-20211219-015728","1","1","6","1","1000","0","0","120000","0","0","","","120000","0","1","1","","","2021-12-19 13:57:28","2021-12-19 13:57:28");
INSERT INTO purchases VALUES("117","pr-20211219-015753","1","1","6","1","1000","0","0","450000","0","0","","","450000","0","1","1","","","2021-12-19 13:57:53","2021-12-19 13:57:53");
INSERT INTO purchases VALUES("118","pr-20211219-015817","1","1","6","1","1000","0","0","100000","0","0","","","100000","0","1","1","","","2021-12-19 13:58:17","2021-12-19 13:58:17");
INSERT INTO purchases VALUES("119","pr-20211219-015854","1","1","6","1","1000","0","0","70000","0","0","","","70000","0","1","1","","","2021-12-19 13:58:54","2021-12-19 13:58:54");
INSERT INTO purchases VALUES("120","pr-20211219-015932","1","1","6","1","1000","0","0","100000","0","0","","","100000","0","1","1","","","2021-12-19 13:59:32","2021-12-19 13:59:32");
INSERT INTO purchases VALUES("121","pr-20211219-015958","1","1","6","1","1000","0","0","150000","0","0","","","150000","0","1","1","","","2021-12-19 13:59:58","2021-12-19 13:59:58");
INSERT INTO purchases VALUES("122","pr-20211219-020028","1","1","6","1","1000","0","0","150000","0","0","","","150000","0","1","1","","","2021-12-19 14:00:28","2021-12-19 14:00:28");
INSERT INTO purchases VALUES("123","pr-20211219-020102","1","1","6","1","1000","0","0","80000","0","0","","","80000","0","1","1","","","2021-12-19 14:01:02","2021-12-19 14:01:02");
INSERT INTO purchases VALUES("124","pr-20211219-020138","1","1","6","1","1000","0","0","100000","0","0","","","100000","0","1","1","","","2021-12-19 14:01:38","2021-12-19 14:01:38");
INSERT INTO purchases VALUES("125","pr-20211219-020240","1","1","6","2","2000","0","0","600000","0","0","","","600000","0","1","1","","","2021-12-19 14:02:40","2021-12-19 14:02:40");
INSERT INTO purchases VALUES("126","pr-20211219-020321","1","1","6","2","2000","0","0","800000","0","0","","","800000","0","1","1","","","2021-12-19 14:03:21","2021-12-19 14:03:21");
INSERT INTO purchases VALUES("127","pr-20211219-020359","1","1","6","2","2000","0","0","680000","0","0","","","680000","0","1","1","","","2021-12-19 14:03:59","2021-12-19 14:03:59");
INSERT INTO purchases VALUES("128","pr-20211219-020442","1","1","6","2","2000","0","0","760000","0","0","","","760000","0","1","1","","","2021-12-19 14:04:42","2021-12-19 14:04:42");
INSERT INTO purchases VALUES("129","pr-20220205-044619","1","2","3","1","100","0","8000","88000","0","0","","","88000","80000","1","1","","","2022-02-05 16:46:19","2022-02-05 19:04:51");
INSERT INTO purchases VALUES("130","pr-20220305-015222","29","1","3","1","4","0","0","8","0","0","","","8","0","1","1","","","2022-03-05 13:52:22","2022-03-05 13:52:22");
INSERT INTO purchases VALUES("131","pr-20220307-093418","29","1","1","1","200","0","0","260000","0","0","","","260000","0","1","1","","","2022-03-07 09:34:18","2022-03-07 09:34:18");
INSERT INTO purchases VALUES("132","pr-20220307-095703","29","7","3","1","200","0","0","260000","0","0","","","260000","0","1","1","","","2022-03-07 09:57:03","2022-03-07 09:57:03");
INSERT INTO purchases VALUES("133","pr-20220307-101027","29","8","7","3","3668","0","0","2089000","0","0","","","2089000","0","1","1","","","2022-03-07 10:10:27","2022-03-07 10:10:27");
INSERT INTO purchases VALUES("134","pr-20220307-120114","29","8","7","2","200","0","0","180000","0","0","","","180000","0","1","1","","","2022-03-07 12:01:14","2022-03-07 12:01:14");
INSERT INTO purchases VALUES("135","pr-20220316-043656","29","1","","1","1000","0","0","1000000","0","0","","","1000000","0","1","1","","","2022-03-16 16:36:56","2022-03-16 16:36:56");
INSERT INTO purchases VALUES("136","pr-20220521-110838","1","9","3","1","10","0","0","5000","0","0","","","5000","3000","1","1","","","2022-05-21 23:08:38","2022-05-21 23:09:22");
INSERT INTO purchases VALUES("145","pr-20231023-021600","29","8","3","6","12","0","0","3600","0","0","","","3600","0","1","1","","","2023-10-23 02:16:00","2023-10-23 02:16:00");
INSERT INTO purchases VALUES("146","pr-20231029-035418","29","36","10","1","500","0","0","17500","0","0","","","17500","17500","1","2","","","2023-10-29 15:54:18","2023-10-29 16:04:27");
INSERT INTO purchases VALUES("150","pr-20231029-043001","29","36","11","1","500","0","0","15000","0","0","0","300","15300","15300","1","2","","","2023-10-29 16:30:01","2023-10-29 16:31:40");
INSERT INTO purchases VALUES("151","pr-20231029-043300","29","36","12","1","1000","0","0","5000","0","0","","","5000","5000","1","2","","","2023-10-29 16:33:00","2023-10-29 16:33:15");
INSERT INTO purchases VALUES("152","pr-20231030-072648","29","1","6","1","50","0","0","1320.5","10","132.05","","","1452.55","0","1","1","","","2023-10-30 19:26:48","2023-10-30 19:26:48");
INSERT INTO purchases VALUES("153","pr-20231030-073046","29","8","3","1","50","0","2000","22000","10","2200","","600","24800","0","1","1","","","2023-10-30 19:30:46","2023-10-30 19:30:46");
INSERT INTO purchases VALUES("154","pr-20231123-055941","29","1","9","1","100","0","0","420000","0","0","100","100","420000","420000","1","2","","","2023-11-23 17:59:41","2023-11-23 18:00:12");
INSERT INTO purchases VALUES("155","pr-20231126-010802","29","1","9","4","50","0","6550","132550","0","0","500","500","132550","0","1","1","","","2023-11-26 13:08:02","2023-11-26 13:08:02");
INSERT INTO purchases VALUES("156","pr-20231126-021459","29","1","13","9","63","0","24544.55","2690990","0","0","1000","1000","2690990","2690990","1","2","","asdfghjkl;","2023-11-26 14:14:59","2023-11-26 14:15:30");



CREATE TABLE `quotations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(191) NOT NULL,
  `user_id` int(11) NOT NULL,
  `biller_id` int(11) NOT NULL,
  `supplier_id` int(11) DEFAULT NULL,
  `customer_id` int(11) NOT NULL,
  `warehouse_id` int(11) NOT NULL,
  `item` int(11) NOT NULL,
  `total_qty` double NOT NULL,
  `total_discount` double NOT NULL,
  `total_tax` double NOT NULL,
  `total_price` double NOT NULL,
  `order_tax_rate` double DEFAULT NULL,
  `order_tax` double DEFAULT NULL,
  `order_discount` double DEFAULT NULL,
  `shipping_cost` double DEFAULT NULL,
  `grand_total` double NOT NULL,
  `quotation_status` int(11) NOT NULL,
  `document` varchar(191) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO quotations VALUES("1","qr-20180809-055250","1","1","3","3","1","3","57","35","767.73","5930","10","583","100","500","6913","2","","first quotation...","2018-08-08 19:52:50","2018-09-03 23:32:16");
INSERT INTO quotations VALUES("2","qr-20180904-040257","1","1","","1","1","2","3.5","0","0","76","0","0","1.6","2.7","77.1","1","","","2018-09-03 18:02:57","2018-09-21 03:05:57");
INSERT INTO quotations VALUES("3","qr-20181023-061249","9","1","3","11","1","2","2","0","40","453","0","0","0","0","453","2","","","2018-10-22 20:12:49","2019-12-21 01:41:36");
INSERT INTO quotations VALUES("11","qr-20201024-090814","1","1","","1","1","1","2","0","3000","23000","0","0","0","0","23000","1","","","2020-10-23 23:08:14","2020-10-23 23:28:35");
INSERT INTO quotations VALUES("12","qr-20201210-053401","1","1","1","19","2","2","15","0","600","9100","0","0","100","500","9500","1","","","2020-12-09 18:34:01","2020-12-09 18:34:01");
INSERT INTO quotations VALUES("13","qr-20210112-125803","1","1","","11","1","3","12","0","155.65","1660","0","0","0","0","1660","1","","","2021-01-12 01:58:03","2021-01-12 01:59:14");
INSERT INTO quotations VALUES("15","qr-20210529-105356","1","1","","11","2","2","2","0","40","442","0","0","0","0","442","1","","","2021-05-29 00:53:56","2021-05-30 04:04:07");



CREATE TABLE `return_purchases` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(191) NOT NULL,
  `supplier_id` int(11) DEFAULT NULL,
  `warehouse_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `account_id` int(11) NOT NULL,
  `item` int(11) NOT NULL,
  `total_qty` double NOT NULL,
  `total_discount` double NOT NULL,
  `total_tax` double NOT NULL,
  `total_cost` double NOT NULL,
  `order_tax_rate` double DEFAULT NULL,
  `order_tax` double DEFAULT NULL,
  `grand_total` double NOT NULL,
  `document` varchar(191) DEFAULT NULL,
  `return_note` text DEFAULT NULL,
  `staff_note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO return_purchases VALUES("1","prr-20190101-090759","3","1","1","1","1","1","0","0","200","0","0","200","","","","2018-12-31 22:07:59","2019-12-07 06:19:03");



CREATE TABLE `returns` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(191) NOT NULL,
  `user_id` int(11) NOT NULL,
  `cash_register_id` int(11) DEFAULT NULL,
  `customer_id` int(11) NOT NULL,
  `warehouse_id` int(11) NOT NULL,
  `biller_id` int(11) NOT NULL,
  `account_id` int(11) NOT NULL,
  `item` int(11) NOT NULL,
  `total_qty` double NOT NULL,
  `total_discount` double NOT NULL,
  `total_tax` double NOT NULL,
  `total_price` double NOT NULL,
  `order_tax_rate` double DEFAULT NULL,
  `order_tax` double DEFAULT NULL,
  `grand_total` double NOT NULL,
  `document` varchar(191) DEFAULT NULL,
  `return_note` text DEFAULT NULL,
  `staff_note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO returns VALUES("2","rr-20180809-055834","1","","1","1","1","1","1","20","0","0","40","10","4","44","","","","2018-08-08 19:58:34","2018-08-08 19:58:34");
INSERT INTO returns VALUES("3","rr-20180828-045527","1","","1","2","1","1","1","2","0","0","44","0","0","44","","","","2018-08-27 18:55:27","2018-09-20 07:03:47");
INSERT INTO returns VALUES("5","rr-20181007-082129","1","","11","2","2","1","1","1","0","0","250","0","0","250","","","","2018-10-06 22:21:29","2018-12-25 17:16:08");
INSERT INTO returns VALUES("6","rr-20190101-090630","9","","1","1","1","1","1","1","0","40","440","0","0","440","","","","2018-12-31 22:06:30","2018-12-31 22:06:30");
INSERT INTO returns VALUES("13","rr-20200816-102502","1","","1","2","2","1","1","1","0","1500","11500","0","0","11500","","","","2020-08-16 12:25:02","2020-08-16 12:25:02");
INSERT INTO returns VALUES("14","rr-20201013-053954","9","1","1","1","1","1","1","1","0","40","440","0","0","440","","","","2020-10-13 07:39:54","2020-10-13 07:39:54");
INSERT INTO returns VALUES("18","rr-20201118-070218","1","4","1","2","1","1","1","1","0","1500","11500","0","0","11500","","","","2020-11-17 20:02:18","2020-11-17 20:02:18");
INSERT INTO returns VALUES("19","rr-20201210-064025","1","3","19","1","1","1","1","1","0","0","250","0","0","250","","","","2020-12-09 19:40:25","2020-12-09 19:40:25");
INSERT INTO returns VALUES("25","rr-20210524-073950","1","3","1","1","1","1","1","1","0","0","2","0","0","2","","","","2021-05-24 09:39:50","2021-05-24 09:39:50");
INSERT INTO returns VALUES("26","rr-20220307-094833","29","6","26","1","1","1","1","1","0","0","2600","0","0","2600","","","","2022-03-07 09:48:33","2022-03-07 09:48:33");
INSERT INTO returns VALUES("27","rr-20220307-121443","29","6","26","1","1","1","1","1","0","0","2600","0","0","2600","","","","2022-03-07 12:14:43","2022-03-07 12:14:43");
INSERT INTO returns VALUES("28","rr-20221023-112011","29","6","11","1","1","1","1","200","0","0","200","0","0","200","","","","2022-10-23 23:20:11","2022-10-23 23:20:11");



CREATE TABLE `role_has_permissions` (
  `permission_id` int(10) unsigned NOT NULL,
  `role_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`role_id`),
  KEY `role_has_permissions_role_id_foreign` (`role_id`),
  CONSTRAINT `role_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `role_has_permissions_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO role_has_permissions VALUES("4","1");
INSERT INTO role_has_permissions VALUES("4","2");
INSERT INTO role_has_permissions VALUES("4","4");
INSERT INTO role_has_permissions VALUES("4","6");
INSERT INTO role_has_permissions VALUES("5","1");
INSERT INTO role_has_permissions VALUES("5","2");
INSERT INTO role_has_permissions VALUES("5","6");
INSERT INTO role_has_permissions VALUES("6","1");
INSERT INTO role_has_permissions VALUES("6","2");
INSERT INTO role_has_permissions VALUES("6","4");
INSERT INTO role_has_permissions VALUES("6","6");
INSERT INTO role_has_permissions VALUES("7","1");
INSERT INTO role_has_permissions VALUES("7","2");
INSERT INTO role_has_permissions VALUES("7","4");
INSERT INTO role_has_permissions VALUES("7","6");
INSERT INTO role_has_permissions VALUES("8","1");
INSERT INTO role_has_permissions VALUES("8","2");
INSERT INTO role_has_permissions VALUES("8","4");
INSERT INTO role_has_permissions VALUES("8","6");
INSERT INTO role_has_permissions VALUES("9","1");
INSERT INTO role_has_permissions VALUES("9","2");
INSERT INTO role_has_permissions VALUES("9","4");
INSERT INTO role_has_permissions VALUES("9","6");
INSERT INTO role_has_permissions VALUES("10","1");
INSERT INTO role_has_permissions VALUES("10","2");
INSERT INTO role_has_permissions VALUES("10","6");
INSERT INTO role_has_permissions VALUES("11","1");
INSERT INTO role_has_permissions VALUES("11","2");
INSERT INTO role_has_permissions VALUES("11","6");
INSERT INTO role_has_permissions VALUES("12","1");
INSERT INTO role_has_permissions VALUES("12","2");
INSERT INTO role_has_permissions VALUES("12","4");
INSERT INTO role_has_permissions VALUES("12","6");
INSERT INTO role_has_permissions VALUES("13","1");
INSERT INTO role_has_permissions VALUES("13","2");
INSERT INTO role_has_permissions VALUES("13","4");
INSERT INTO role_has_permissions VALUES("13","6");
INSERT INTO role_has_permissions VALUES("14","1");
INSERT INTO role_has_permissions VALUES("14","2");
INSERT INTO role_has_permissions VALUES("14","6");
INSERT INTO role_has_permissions VALUES("15","1");
INSERT INTO role_has_permissions VALUES("15","2");
INSERT INTO role_has_permissions VALUES("15","6");
INSERT INTO role_has_permissions VALUES("16","1");
INSERT INTO role_has_permissions VALUES("16","2");
INSERT INTO role_has_permissions VALUES("16","6");
INSERT INTO role_has_permissions VALUES("17","1");
INSERT INTO role_has_permissions VALUES("17","2");
INSERT INTO role_has_permissions VALUES("18","1");
INSERT INTO role_has_permissions VALUES("18","2");
INSERT INTO role_has_permissions VALUES("19","1");
INSERT INTO role_has_permissions VALUES("19","2");
INSERT INTO role_has_permissions VALUES("20","1");
INSERT INTO role_has_permissions VALUES("20","2");
INSERT INTO role_has_permissions VALUES("20","4");
INSERT INTO role_has_permissions VALUES("20","6");
INSERT INTO role_has_permissions VALUES("21","1");
INSERT INTO role_has_permissions VALUES("21","2");
INSERT INTO role_has_permissions VALUES("21","4");
INSERT INTO role_has_permissions VALUES("22","1");
INSERT INTO role_has_permissions VALUES("22","2");
INSERT INTO role_has_permissions VALUES("22","4");
INSERT INTO role_has_permissions VALUES("23","1");
INSERT INTO role_has_permissions VALUES("23","2");
INSERT INTO role_has_permissions VALUES("24","1");
INSERT INTO role_has_permissions VALUES("24","2");
INSERT INTO role_has_permissions VALUES("24","4");
INSERT INTO role_has_permissions VALUES("24","6");
INSERT INTO role_has_permissions VALUES("25","1");
INSERT INTO role_has_permissions VALUES("25","2");
INSERT INTO role_has_permissions VALUES("25","4");
INSERT INTO role_has_permissions VALUES("25","6");
INSERT INTO role_has_permissions VALUES("26","1");
INSERT INTO role_has_permissions VALUES("26","2");
INSERT INTO role_has_permissions VALUES("26","6");
INSERT INTO role_has_permissions VALUES("27","1");
INSERT INTO role_has_permissions VALUES("27","2");
INSERT INTO role_has_permissions VALUES("27","6");
INSERT INTO role_has_permissions VALUES("28","1");
INSERT INTO role_has_permissions VALUES("28","2");
INSERT INTO role_has_permissions VALUES("28","4");
INSERT INTO role_has_permissions VALUES("28","6");
INSERT INTO role_has_permissions VALUES("29","1");
INSERT INTO role_has_permissions VALUES("29","2");
INSERT INTO role_has_permissions VALUES("29","4");
INSERT INTO role_has_permissions VALUES("29","6");
INSERT INTO role_has_permissions VALUES("30","1");
INSERT INTO role_has_permissions VALUES("30","2");
INSERT INTO role_has_permissions VALUES("30","6");
INSERT INTO role_has_permissions VALUES("31","1");
INSERT INTO role_has_permissions VALUES("31","2");
INSERT INTO role_has_permissions VALUES("31","6");
INSERT INTO role_has_permissions VALUES("32","1");
INSERT INTO role_has_permissions VALUES("32","2");
INSERT INTO role_has_permissions VALUES("32","6");
INSERT INTO role_has_permissions VALUES("33","1");
INSERT INTO role_has_permissions VALUES("33","2");
INSERT INTO role_has_permissions VALUES("33","6");
INSERT INTO role_has_permissions VALUES("34","1");
INSERT INTO role_has_permissions VALUES("34","2");
INSERT INTO role_has_permissions VALUES("34","6");
INSERT INTO role_has_permissions VALUES("35","1");
INSERT INTO role_has_permissions VALUES("35","2");
INSERT INTO role_has_permissions VALUES("35","6");
INSERT INTO role_has_permissions VALUES("36","1");
INSERT INTO role_has_permissions VALUES("36","2");
INSERT INTO role_has_permissions VALUES("36","6");
INSERT INTO role_has_permissions VALUES("37","1");
INSERT INTO role_has_permissions VALUES("37","2");
INSERT INTO role_has_permissions VALUES("37","6");
INSERT INTO role_has_permissions VALUES("38","1");
INSERT INTO role_has_permissions VALUES("38","2");
INSERT INTO role_has_permissions VALUES("38","6");
INSERT INTO role_has_permissions VALUES("39","1");
INSERT INTO role_has_permissions VALUES("39","2");
INSERT INTO role_has_permissions VALUES("39","6");
INSERT INTO role_has_permissions VALUES("40","1");
INSERT INTO role_has_permissions VALUES("40","2");
INSERT INTO role_has_permissions VALUES("40","6");
INSERT INTO role_has_permissions VALUES("41","1");
INSERT INTO role_has_permissions VALUES("41","2");
INSERT INTO role_has_permissions VALUES("41","6");
INSERT INTO role_has_permissions VALUES("42","1");
INSERT INTO role_has_permissions VALUES("42","2");
INSERT INTO role_has_permissions VALUES("42","6");
INSERT INTO role_has_permissions VALUES("43","1");
INSERT INTO role_has_permissions VALUES("43","2");
INSERT INTO role_has_permissions VALUES("43","6");
INSERT INTO role_has_permissions VALUES("44","1");
INSERT INTO role_has_permissions VALUES("44","2");
INSERT INTO role_has_permissions VALUES("44","6");
INSERT INTO role_has_permissions VALUES("45","1");
INSERT INTO role_has_permissions VALUES("45","2");
INSERT INTO role_has_permissions VALUES("45","6");
INSERT INTO role_has_permissions VALUES("46","1");
INSERT INTO role_has_permissions VALUES("46","2");
INSERT INTO role_has_permissions VALUES("46","6");
INSERT INTO role_has_permissions VALUES("47","1");
INSERT INTO role_has_permissions VALUES("47","2");
INSERT INTO role_has_permissions VALUES("47","6");
INSERT INTO role_has_permissions VALUES("48","1");
INSERT INTO role_has_permissions VALUES("48","2");
INSERT INTO role_has_permissions VALUES("48","6");
INSERT INTO role_has_permissions VALUES("49","1");
INSERT INTO role_has_permissions VALUES("49","2");
INSERT INTO role_has_permissions VALUES("49","6");
INSERT INTO role_has_permissions VALUES("50","1");
INSERT INTO role_has_permissions VALUES("50","2");
INSERT INTO role_has_permissions VALUES("50","6");
INSERT INTO role_has_permissions VALUES("51","1");
INSERT INTO role_has_permissions VALUES("51","2");
INSERT INTO role_has_permissions VALUES("51","6");
INSERT INTO role_has_permissions VALUES("52","1");
INSERT INTO role_has_permissions VALUES("52","2");
INSERT INTO role_has_permissions VALUES("52","6");
INSERT INTO role_has_permissions VALUES("53","1");
INSERT INTO role_has_permissions VALUES("53","2");
INSERT INTO role_has_permissions VALUES("53","6");
INSERT INTO role_has_permissions VALUES("54","1");
INSERT INTO role_has_permissions VALUES("54","2");
INSERT INTO role_has_permissions VALUES("54","6");
INSERT INTO role_has_permissions VALUES("55","1");
INSERT INTO role_has_permissions VALUES("55","2");
INSERT INTO role_has_permissions VALUES("55","4");
INSERT INTO role_has_permissions VALUES("55","6");
INSERT INTO role_has_permissions VALUES("56","1");
INSERT INTO role_has_permissions VALUES("56","2");
INSERT INTO role_has_permissions VALUES("56","4");
INSERT INTO role_has_permissions VALUES("56","6");
INSERT INTO role_has_permissions VALUES("57","1");
INSERT INTO role_has_permissions VALUES("57","2");
INSERT INTO role_has_permissions VALUES("57","4");
INSERT INTO role_has_permissions VALUES("57","6");
INSERT INTO role_has_permissions VALUES("58","1");
INSERT INTO role_has_permissions VALUES("58","2");
INSERT INTO role_has_permissions VALUES("58","6");
INSERT INTO role_has_permissions VALUES("59","1");
INSERT INTO role_has_permissions VALUES("59","2");
INSERT INTO role_has_permissions VALUES("60","1");
INSERT INTO role_has_permissions VALUES("60","2");
INSERT INTO role_has_permissions VALUES("61","1");
INSERT INTO role_has_permissions VALUES("61","2");
INSERT INTO role_has_permissions VALUES("61","6");
INSERT INTO role_has_permissions VALUES("62","1");
INSERT INTO role_has_permissions VALUES("62","2");
INSERT INTO role_has_permissions VALUES("62","6");
INSERT INTO role_has_permissions VALUES("63","1");
INSERT INTO role_has_permissions VALUES("63","2");
INSERT INTO role_has_permissions VALUES("63","4");
INSERT INTO role_has_permissions VALUES("63","6");
INSERT INTO role_has_permissions VALUES("64","1");
INSERT INTO role_has_permissions VALUES("64","2");
INSERT INTO role_has_permissions VALUES("64","4");
INSERT INTO role_has_permissions VALUES("64","6");
INSERT INTO role_has_permissions VALUES("65","1");
INSERT INTO role_has_permissions VALUES("65","2");
INSERT INTO role_has_permissions VALUES("65","6");
INSERT INTO role_has_permissions VALUES("66","1");
INSERT INTO role_has_permissions VALUES("66","2");
INSERT INTO role_has_permissions VALUES("66","6");
INSERT INTO role_has_permissions VALUES("67","1");
INSERT INTO role_has_permissions VALUES("67","2");
INSERT INTO role_has_permissions VALUES("67","6");
INSERT INTO role_has_permissions VALUES("68","1");
INSERT INTO role_has_permissions VALUES("68","2");
INSERT INTO role_has_permissions VALUES("68","6");
INSERT INTO role_has_permissions VALUES("69","1");
INSERT INTO role_has_permissions VALUES("69","2");
INSERT INTO role_has_permissions VALUES("69","6");
INSERT INTO role_has_permissions VALUES("70","1");
INSERT INTO role_has_permissions VALUES("70","2");
INSERT INTO role_has_permissions VALUES("70","6");
INSERT INTO role_has_permissions VALUES("71","1");
INSERT INTO role_has_permissions VALUES("71","2");
INSERT INTO role_has_permissions VALUES("71","6");
INSERT INTO role_has_permissions VALUES("72","1");
INSERT INTO role_has_permissions VALUES("72","2");
INSERT INTO role_has_permissions VALUES("73","1");
INSERT INTO role_has_permissions VALUES("73","2");
INSERT INTO role_has_permissions VALUES("73","6");
INSERT INTO role_has_permissions VALUES("74","1");
INSERT INTO role_has_permissions VALUES("74","2");
INSERT INTO role_has_permissions VALUES("74","6");
INSERT INTO role_has_permissions VALUES("75","1");
INSERT INTO role_has_permissions VALUES("75","2");
INSERT INTO role_has_permissions VALUES("75","6");
INSERT INTO role_has_permissions VALUES("76","1");
INSERT INTO role_has_permissions VALUES("76","2");
INSERT INTO role_has_permissions VALUES("76","6");
INSERT INTO role_has_permissions VALUES("77","1");
INSERT INTO role_has_permissions VALUES("77","2");
INSERT INTO role_has_permissions VALUES("77","6");
INSERT INTO role_has_permissions VALUES("78","1");
INSERT INTO role_has_permissions VALUES("78","2");
INSERT INTO role_has_permissions VALUES("78","6");
INSERT INTO role_has_permissions VALUES("79","1");
INSERT INTO role_has_permissions VALUES("79","2");
INSERT INTO role_has_permissions VALUES("80","1");
INSERT INTO role_has_permissions VALUES("80","2");
INSERT INTO role_has_permissions VALUES("81","1");
INSERT INTO role_has_permissions VALUES("81","2");
INSERT INTO role_has_permissions VALUES("82","1");
INSERT INTO role_has_permissions VALUES("82","2");
INSERT INTO role_has_permissions VALUES("82","6");
INSERT INTO role_has_permissions VALUES("83","1");
INSERT INTO role_has_permissions VALUES("83","2");
INSERT INTO role_has_permissions VALUES("84","1");
INSERT INTO role_has_permissions VALUES("84","2");
INSERT INTO role_has_permissions VALUES("84","6");
INSERT INTO role_has_permissions VALUES("85","1");
INSERT INTO role_has_permissions VALUES("85","2");
INSERT INTO role_has_permissions VALUES("85","6");
INSERT INTO role_has_permissions VALUES("86","1");
INSERT INTO role_has_permissions VALUES("86","2");
INSERT INTO role_has_permissions VALUES("86","6");
INSERT INTO role_has_permissions VALUES("87","1");
INSERT INTO role_has_permissions VALUES("87","2");
INSERT INTO role_has_permissions VALUES("88","1");
INSERT INTO role_has_permissions VALUES("88","2");
INSERT INTO role_has_permissions VALUES("89","1");
INSERT INTO role_has_permissions VALUES("89","2");
INSERT INTO role_has_permissions VALUES("89","6");
INSERT INTO role_has_permissions VALUES("90","1");
INSERT INTO role_has_permissions VALUES("90","2");
INSERT INTO role_has_permissions VALUES("90","6");
INSERT INTO role_has_permissions VALUES("91","1");
INSERT INTO role_has_permissions VALUES("91","2");
INSERT INTO role_has_permissions VALUES("91","6");
INSERT INTO role_has_permissions VALUES("92","1");
INSERT INTO role_has_permissions VALUES("92","2");
INSERT INTO role_has_permissions VALUES("92","6");
INSERT INTO role_has_permissions VALUES("93","1");
INSERT INTO role_has_permissions VALUES("93","2");
INSERT INTO role_has_permissions VALUES("93","6");
INSERT INTO role_has_permissions VALUES("94","1");
INSERT INTO role_has_permissions VALUES("94","2");
INSERT INTO role_has_permissions VALUES("94","6");
INSERT INTO role_has_permissions VALUES("95","1");
INSERT INTO role_has_permissions VALUES("95","2");
INSERT INTO role_has_permissions VALUES("95","6");
INSERT INTO role_has_permissions VALUES("96","1");
INSERT INTO role_has_permissions VALUES("96","2");
INSERT INTO role_has_permissions VALUES("96","6");
INSERT INTO role_has_permissions VALUES("97","1");
INSERT INTO role_has_permissions VALUES("97","2");
INSERT INTO role_has_permissions VALUES("97","6");
INSERT INTO role_has_permissions VALUES("98","1");
INSERT INTO role_has_permissions VALUES("98","2");
INSERT INTO role_has_permissions VALUES("98","6");
INSERT INTO role_has_permissions VALUES("99","1");
INSERT INTO role_has_permissions VALUES("99","2");
INSERT INTO role_has_permissions VALUES("99","6");
INSERT INTO role_has_permissions VALUES("100","1");
INSERT INTO role_has_permissions VALUES("100","2");
INSERT INTO role_has_permissions VALUES("100","6");
INSERT INTO role_has_permissions VALUES("101","1");
INSERT INTO role_has_permissions VALUES("101","2");
INSERT INTO role_has_permissions VALUES("101","6");
INSERT INTO role_has_permissions VALUES("102","1");
INSERT INTO role_has_permissions VALUES("102","2");
INSERT INTO role_has_permissions VALUES("102","6");
INSERT INTO role_has_permissions VALUES("103","1");
INSERT INTO role_has_permissions VALUES("103","2");
INSERT INTO role_has_permissions VALUES("104","1");
INSERT INTO role_has_permissions VALUES("104","2");



CREATE TABLE `roles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  `guard_name` varchar(191) DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO roles VALUES("1","Admin","admin can access all data...","web","1","2018-06-01 19:46:44","2018-06-02 19:13:05");
INSERT INTO roles VALUES("2","Owner","Owner of shop...","web","1","2018-10-21 22:38:13","2018-10-21 22:38:13");
INSERT INTO roles VALUES("4","staff","staff has specific acess...","web","1","2018-06-01 20:05:27","2018-06-01 20:05:27");
INSERT INTO roles VALUES("5","Customer","","web","1","2020-11-05 01:43:16","2020-11-14 19:24:15");
INSERT INTO roles VALUES("6","DemoOwner","DemoOwner","web","1","2022-03-02 12:55:19","2022-03-02 12:55:19");



CREATE TABLE `sales` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(191) NOT NULL,
  `user_id` int(11) NOT NULL,
  `cash_register_id` int(11) DEFAULT NULL,
  `customer_id` int(11) NOT NULL,
  `warehouse_id` int(11) NOT NULL,
  `biller_id` int(11) DEFAULT NULL,
  `item` int(11) NOT NULL,
  `total_qty` double NOT NULL,
  `total_discount` double NOT NULL,
  `total_tax` double NOT NULL,
  `total_price` double NOT NULL,
  `grand_total` double NOT NULL,
  `order_tax_rate` double DEFAULT NULL,
  `order_tax` double DEFAULT NULL,
  `order_discount` double DEFAULT NULL,
  `coupon_id` int(11) DEFAULT NULL,
  `coupon_discount` double DEFAULT NULL,
  `shipping_cost` double DEFAULT NULL,
  `sale_status` int(11) NOT NULL,
  `payment_status` int(11) NOT NULL,
  `document` varchar(191) DEFAULT NULL,
  `paid_amount` double DEFAULT NULL,
  `sale_note` text DEFAULT NULL,
  `staff_note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=351 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO sales VALUES("1","sr-20180808-043622","1","","1","1","1","2","3","10","15.65","350","380","10","30","50","","","50","1","2","","0","ukgjkgjkgkj","gjkgjkgkujg","2018-08-08 06:36:22","2018-10-06 05:25:29");
INSERT INTO sales VALUES("2","sr-20180809-055453","1","","3","1","1","3","63","0","469.3","5103","5503","0","0","100","","","500","1","2","","2200","","","2018-08-08 19:54:53","2018-08-08 19:56:35");
INSERT INTO sales VALUES("3","posr-20180809-063214","1","","2","2","2","3","26","0","0","897","897","0","0","","","","","1","4","","897","","","2018-08-08 20:32:14","2018-08-08 20:32:14");
INSERT INTO sales VALUES("4","sr-20180825-034836","1","","1","1","1","1","2","0","80","880","880","0","0","","","","","1","2","","300","","","2018-08-24 17:48:36","2018-09-21 22:56:03");
INSERT INTO sales VALUES("6","sr-20180826-094836","1","","2","1","2","1","1","0","0","18.9","20","0","0","0","","","1.1","1","4","","20","","","2018-08-25 23:48:36","2018-08-26 01:48:05");
INSERT INTO sales VALUES("7","sr-20180827-073545","1","","1","1","1","1","2","0","80","880","880","0","0","","","","","1","4","","880","","","2018-08-26 21:35:45","2018-08-26 21:35:45");
INSERT INTO sales VALUES("8","posr-20180902-053954","1","","1","1","2","1","2","0","288","3168","3529.8","10","311.8","50","","","100","1","4","","3529.8","good customer","good customer","2018-09-01 19:39:54","2018-09-01 19:39:54");
INSERT INTO sales VALUES("9","posr-20180903-033314","1","","1","2","1","1","10","0","0","20","20","0","0","","","","","1","4","","20","","","2018-09-02 17:33:14","2018-09-02 17:33:14");
INSERT INTO sales VALUES("10","posr-20180903-050138","1","","11","2","1","1","1","0","0","250","250","0","0","","","","","1","2","","200","","","2018-09-02 19:01:38","2018-09-09 17:40:28");
INSERT INTO sales VALUES("11","posr-20180903-100821","1","","11","2","1","1","5","0","500","5500","5500","0","0","","","","","1","4","","5500","","","2018-09-03 00:08:21","2018-09-03 00:08:21");
INSERT INTO sales VALUES("12","sr-20180903-101026","1","","3","1","5","1","10","0","1050","11550","11550","0","0","","","","","1","2","","0","","","2018-09-03 00:10:26","2018-09-21 22:55:14");
INSERT INTO sales VALUES("29","sr-20180909-093841","1","","1","1","1","1","1","0","0","120","132","10","12","","","","","1","2","","0","","","2018-09-08 23:38:41","2018-10-05 22:36:52");
INSERT INTO sales VALUES("30","posr-20180910-045706","1","","11","2","1","1","1","0","40","440","440","0","0","0","","","0","1","2","","120","","","2018-09-09 18:57:06","2018-10-05 20:53:20");
INSERT INTO sales VALUES("31","posr-20180926-092059","1","","11","2","1","2","2","0","55.65","560","560","0","0","0","","","0","1","4","","560","","","2018-09-25 23:20:59","2018-09-25 23:21:25");
INSERT INTO sales VALUES("32","posr-20181004-095547","1","","11","2","1","1","1","0","40","440","440","0","0","","","","","1","2","","","","","2018-10-03 23:55:47","2018-10-03 23:55:47");
INSERT INTO sales VALUES("33","posr-20181004-100022","1","","11","2","1","1","1","0","40","440","440","0","0","","","","","1","2","","","","","2018-10-04 00:00:22","2018-10-04 00:00:22");
INSERT INTO sales VALUES("37","sr-20181007-064605","1","","1","1","1","1","1","0","0","250","250","0","0","","","","","1","2","","0","","","2018-10-06 20:46:05","2018-10-06 20:46:28");
INSERT INTO sales VALUES("38","posr-20181007-064719","1","","11","2","1","1","1","0","40","440","440","0","0","","","","","1","2","","0","","","2018-10-06 20:47:19","2018-10-06 23:17:02");
INSERT INTO sales VALUES("40","posr-20181007-071312","1","","11","2","1","1","1","0","40","440","440","0","0","","","","","1","2","","0","","","2018-10-06 21:13:12","2018-10-06 23:17:39");
INSERT INTO sales VALUES("41","posr-20181010-041621","1","","1","2","1","2","2","0","40","461","461","0","0","","","","","1","4","","461","","","2018-10-09 18:16:21","2018-10-09 18:16:21");
INSERT INTO sales VALUES("42","posr-20181010-053450","1","","1","2","1","1","1","0","40","440","440","0","0","","","","","1","4","","440","","","2018-10-09 19:34:50","2018-10-09 19:34:50");
INSERT INTO sales VALUES("43","sr-20181016-033434","1","","1","1","1","1","1","0","40","440","440","0","0","","","","","1","2","","0","sss
sss
s","","2018-10-15 17:34:34","2018-10-22 20:21:27");
INSERT INTO sales VALUES("55","posr-20181021-065334","1","","11","2","1","1","1","0","0","250","250","0","0","","","","","1","4","","250","","","2018-10-20 20:53:34","2018-10-20 20:53:34");
INSERT INTO sales VALUES("57","posr-20181021-082612","1","","11","2","1","2","3","0","40","482","575.2","10","43.2","50","","","100","1","4","","575.2","","","2018-10-20 22:26:12","2018-10-20 22:26:12");
INSERT INTO sales VALUES("58","posr-20181022-032723","1","","11","2","1","2","2","0","100","1220","1220","0","0","","","","","1","4","","1220","","","2018-10-22 05:27:23","2018-10-22 05:27:23");
INSERT INTO sales VALUES("73","posr-20181023-071543","11","","11","1","5","2","5","0","500","5500","5500","0","0","","","","","1","4","","5500","","","2018-10-22 21:15:43","2018-10-22 21:15:43");
INSERT INTO sales VALUES("74","posr-20181023-071644","1","","11","2","1","3","3","0","200","2320","2320","0","0","","","","","1","4","","2320","","","2018-10-22 21:16:44","2018-10-22 21:16:44");
INSERT INTO sales VALUES("75","posr-20181101-050027","1","","11","2","1","5","12","0","626.96","6980","7678","10","698","","","","","1","4","","7678","","","2018-10-31 19:00:27","2018-10-31 19:00:27");
INSERT INTO sales VALUES("76","posr-20181101-050126","1","","11","2","1","3","6","0","100","1434","1424","0","0","10","","","0","1","4","","1424","","","2018-10-31 19:01:26","2018-11-07 22:44:51");
INSERT INTO sales VALUES("79","posr-20181105-091516","1","","11","2","1","7","52","0","1069.57","14454","14454","0","0","","","","","1","4","","14454","","","2018-11-04 22:15:16","2018-11-04 22:15:16");
INSERT INTO sales VALUES("80","posr-20181105-091958","1","","11","2","1","3","8","0","191.3","2500","2500","0","0","","","","","1","4","","2500","","","2018-11-04 22:19:58","2018-11-04 22:19:58");
INSERT INTO sales VALUES("86","posr-20181105-095948","1","","11","2","1","1","1","0","100","1100","1100","0","0","","","","","1","4","","1100","","","2018-11-04 22:59:48","2018-11-04 22:59:48");
INSERT INTO sales VALUES("88","posr-20181105-100258","1","","11","2","1","1","1","0","100","1100","1100","0","0","","","","","1","4","","1100","","","2018-11-04 23:02:58","2018-11-04 23:02:58");
INSERT INTO sales VALUES("94","posr-20181126-020534","1","","11","2","1","1","1","0","15.65","120","120","0","0","","","","","1","4","","120","","","2018-11-26 03:05:34","2018-11-26 03:05:34");
INSERT INTO sales VALUES("95","posr-20181127-093608","1","","11","2","1","1","3","0","0","360","360","0","0","","","","","1","2","","","","","2018-11-26 22:36:08","2018-11-26 22:36:08");
INSERT INTO sales VALUES("96","posr-20181128-071509","1","","11","2","1","1","1","0","15.65","120","132","10","12","","","","","1","4","","132","","","2018-11-27 20:15:09","2018-11-27 20:15:09");
INSERT INTO sales VALUES("97","posr-20181201-060518","1","","11","2","1","2","3","0","31.3","262","262","0","0","","","","","1","2","","200","","","2018-11-30 19:05:18","2018-12-03 19:21:05");
INSERT INTO sales VALUES("98","posr-20181205-053558","1","","11","2","1","2","4","0","0","800","800","0","0","","","","","1","4","","800","","","2018-12-04 18:35:58","2018-12-04 18:35:58");
INSERT INTO sales VALUES("99","posr-20181205-053719","1","","11","1","1","2","4","0","0","800","800","0","0","","","","","1","4","","800","","","2018-12-04 18:37:19","2018-12-04 18:37:19");
INSERT INTO sales VALUES("101","posr-20181208-062026","1","","11","2","1","1","1","0","0","100","100","0","0","","","","","1","4","","100","","","2018-12-07 19:20:26","2018-12-07 19:20:26");
INSERT INTO sales VALUES("103","posr-20181224-045832","1","","11","2","1","1","1","0","15.65","120","120","0","0","","","","","1","4","","120","","","2018-12-23 17:58:32","2018-12-23 17:58:32");
INSERT INTO sales VALUES("104","sr-20181224-091527","1","","1","1","2","2","6","0","0","2508","2518","0","0","0","","","10","1","2","","","","","2018-12-23 22:15:27","2018-12-24 16:55:23");
INSERT INTO sales VALUES("105","posr-20190101-054538","1","","1","2","1","1","1","0","0","21","21","0","0","","","","","1","4","","21","","","2018-12-31 18:45:38","2018-12-31 18:45:38");
INSERT INTO sales VALUES("106","posr-20190101-091040","1","","11","2","1","3","5","0","15.65","860","860","0","0","","","","","1","4","","860","","","2018-12-31 22:10:40","2018-12-31 22:10:40");
INSERT INTO sales VALUES("107","posr-20190103-065626","1","","11","2","1","6","10","0","395.65","5040","5040","0","0","","","","","1","4","","5040","","","2019-01-02 19:56:26","2019-01-02 19:56:26");
INSERT INTO sales VALUES("108","posr-20190120-035824","1","","11","2","1","1","1","0","15.65","120","120","0","0","","","","","1","4","","120","","","2019-01-20 04:58:24","2019-01-20 04:58:24");
INSERT INTO sales VALUES("109","posr-20190129-101443","9","","11","1","5","2","2","0","40","540","540","0","0","","","","","1","4","","540","","","2019-01-28 23:14:43","2019-01-28 23:14:43");
INSERT INTO sales VALUES("110","posr-20190129-115041","9","","11","1","5","2","3","0","100","1700","1700","0","0","","","","","1","4","","1700","","","2019-01-29 00:50:41","2019-01-29 00:50:41");
INSERT INTO sales VALUES("111","posr-20190131-110839","9","","11","1","5","2","2","0","0","271","271","0","0","","","","","1","4","","271","","","2019-01-31 00:08:39","2019-01-31 00:08:39");
INSERT INTO sales VALUES("112","posr-20190202-104045","1","","11","2","1","1","1","0","40","440","440","0","0","","","","","1","4","","440","","","2019-02-01 23:40:45","2019-02-01 23:40:45");
INSERT INTO sales VALUES("113","posr-20190202-114117","1","","11","2","1","2","2","0","0","350","350","0","0","","","","","1","4","","350","","","2019-02-02 00:41:17","2019-02-02 00:41:17");
INSERT INTO sales VALUES("114","posr-20190205-030445","1","","11","2","1","1","1","0","40","440","440","0","0","","","","","1","4","","440","","","2019-02-05 04:04:45","2019-02-05 04:04:45");
INSERT INTO sales VALUES("118","posr-20190207-111542","1","","11","2","1","1","1","0","40","440","440","0","0","","","","","3","2","","","","","2019-02-07 00:15:42","2019-02-07 00:15:42");
INSERT INTO sales VALUES("120","sr-20190207-114036","1","","1","1","2","1","1","0","40","440","440","0","0","","","","","1","2","","50","","","2019-02-07 00:40:36","2019-02-07 02:09:15");
INSERT INTO sales VALUES("121","posr-20190209-104814","1","","11","2","1","7","17","0","55.65","1272","1272","0","0","","","","","1","4","","1272","","","2019-02-08 23:48:14","2019-02-08 23:48:14");
INSERT INTO sales VALUES("123","posr-20190219-023214","1","","11","2","1","1","1","0","40","440","440","0","0","","","","","1","4","","440","","","2019-02-19 03:32:14","2019-02-19 03:32:14");
INSERT INTO sales VALUES("127","posr-20190303-104010","1","","11","2","1","3","3","0","200","2500","2500","0","0","","","","","1","4","","2500","","","2019-03-02 23:40:10","2019-03-02 23:40:10");
INSERT INTO sales VALUES("128","posr-20190404-095555","1","","11","2","1","2","2","0","55.65","560","560","0","0","","","","","1","4","","560","","","2019-04-03 23:55:55","2019-04-03 23:55:55");
INSERT INTO sales VALUES("129","posr-20190404-095937","1","","11","2","1","1","2","0","0","240","240","0","0","0","","","0","1","2","","120","","","2019-04-03 23:59:37","2019-04-11 00:50:16");
INSERT INTO sales VALUES("130","posr-20190421-122124","1","","11","2","1","3","3","0","58.78","586","586","0","0","","","","","1","4","","586","","","2019-04-21 02:21:24","2019-04-21 02:21:24");
INSERT INTO sales VALUES("131","posr-20190528-103229","1","","11","2","1","4","4","0","240","2890","2890","0","0","","","","","1","4","","2890","","","2019-05-28 00:32:29","2019-05-28 00:32:29");
INSERT INTO sales VALUES("132","posr-20190613-101637","1","","11","2","1","3","3","0","40","840","840","0","0","","","","","1","4","","840","","","2019-06-13 00:16:37","2019-06-13 00:16:37");
INSERT INTO sales VALUES("133","posr-20190613-101751","1","","11","2","1","3","4","0","200","2700","2700","0","0","","","","","1","4","","2700","","","2019-06-13 00:17:51","2019-06-13 00:17:51");
INSERT INTO sales VALUES("134","posr-20191019-033028","1","","11","2","1","4","4","0","240","2940","2940","0","0","","","","","1","4","","2940","","","2019-10-19 05:30:28","2019-10-19 05:30:28");
INSERT INTO sales VALUES("138","sr-20191031-122937","1","","1","1","1","1","1","0","0","120","120","0","0","","","","","1","1","","","","","2019-10-31 02:29:37","2019-10-31 02:29:37");
INSERT INTO sales VALUES("139","posr-20191103-114044","1","","11","2","1","2","102","0","37.57","488","488","0","0","","","","","1","4","","488","","","2019-11-03 01:40:44","2019-11-03 01:40:44");
INSERT INTO sales VALUES("144","posr-20191109-074131","1","","11","2","1","2","2","0","100","1220","1220","0","0","0","","","0","1","4","","1220","","","2019-11-09 08:41:31","2019-11-09 08:41:31");
INSERT INTO sales VALUES("147","posr-20191111-104008","1","","11","2","1","3","12","0","200","2220","2220","0","0","","","","","1","4","","2220","","","2019-11-10 23:40:08","2019-11-10 23:40:08");
INSERT INTO sales VALUES("172","posr-20191203-034631","1","","11","2","1","1","1","0","40","440","440","0","0","","","","","1","2","","","","","2019-12-03 04:46:31","2019-12-03 04:46:31");
INSERT INTO sales VALUES("173","sr-20191204-111940","1","","2","1","1","2","2","0","36","621","621","0","0","","","","","1","4","","621","","","2019-12-04 12:19:40","2019-12-04 22:27:12");
INSERT INTO sales VALUES("187","posr-20191222-104058","1","","11","2","1","1","2","0","37.57","288","288","0","0","","","","","1","4","","288","","","2019-12-21 23:40:58","2019-12-21 23:40:58");
INSERT INTO sales VALUES("190","posr-20191223-125946","1","","11","2","1","1","1","0","100","1100","1100","0","0","","","","","1","4","","1100","","","2019-12-23 01:59:46","2019-12-23 01:59:46");
INSERT INTO sales VALUES("193","posr-20200101-022028","1","","11","2","1","1","1","0","100","1100","1100","0","0","","","","","1","4","","1100","","","2020-01-01 03:20:28","2020-01-01 03:20:28");
INSERT INTO sales VALUES("194","posr-20200102-043947","1","","11","2","1","2","3","0","81.57","892","892","0","0","","","","","1","4","","892","","","2020-01-02 05:39:47","2020-01-02 05:39:47");
INSERT INTO sales VALUES("201","posr-20200203-035256","1","","11","2","1","1","1","0","0","120","120","0","0","","","","","1","4","","120","","","2020-02-03 04:52:56","2020-02-03 04:52:56");
INSERT INTO sales VALUES("202","posr-20200204-105853","1","","11","2","1","2","2","0","100","1400","1400","0","0","","","","","1","4","","1400","","","2020-02-04 11:58:53","2020-02-04 11:58:53");
INSERT INTO sales VALUES("203","posr-20200302-115414","1","","11","2","1","2","2","0","0","350","350","0","0","","","","","1","4","","350","","","2020-03-02 00:54:14","2020-03-02 00:54:14");
INSERT INTO sales VALUES("204","posr-20200302-115741","1","","11","2","1","1","20","0","0","40","40","0","0","","","","","1","4","","40","","","2020-03-02 00:57:41","2020-03-02 00:57:41");
INSERT INTO sales VALUES("205","posr-20200311-044641","1","","11","2","1","1","1","0","40","440","352","0","0","","1","88","","1","4","","352","","","2020-03-11 06:46:42","2020-03-11 06:46:42");
INSERT INTO sales VALUES("206","sr-20200311-045230","1","","1","1","1","1","1","0","0","120","120","0","0","0","","","0","1","2","","","","","2020-03-11 06:52:30","2020-03-11 06:54:04");
INSERT INTO sales VALUES("207","posr-20200406-074024","1","","11","2","1","3","4","0","18.78","644","644","0","0","0","","","0","1","4","","644","","","2020-04-06 09:40:24","2020-04-06 09:42:01");
INSERT INTO sales VALUES("208","posr-20200506-105950","1","","11","2","1","2","2","0","140","1540","1540","0","0","","","","","1","4","","1540","","","2020-05-06 12:59:50","2020-05-06 12:59:50");
INSERT INTO sales VALUES("209","posr-20200609-124248","1","","11","2","1","2","2","0","100","1220","1220","0","0","","","","","1","4","","1220","","","2020-06-09 02:42:48","2020-06-09 02:42:48");
INSERT INTO sales VALUES("212","posr-20200703-063914","1","","11","2","1","3","3","0","235","2585","2585","0","0","","","","","1","4","","2585","","","2020-07-03 08:39:14","2020-07-03 08:39:14");
INSERT INTO sales VALUES("213","posr-20200712-095153","1","","11","2","1","1","1","0","0","13","13","0","0","","","","","1","4","","13","","","2020-07-12 11:51:53","2020-07-12 11:51:53");
INSERT INTO sales VALUES("214","posr-20200714-115341","1","","11","2","1","1","1","0","0","250","309.5","10","24.5","5","","","40","3","2","","","","","2020-07-14 01:53:41","2020-07-14 01:53:41");
INSERT INTO sales VALUES("217","posr-20200727-083808","1","","11","2","1","1","1","0","35","385","385","0","0","","","","","1","4","","385","","","2020-07-27 10:38:08","2020-07-27 10:38:08");
INSERT INTO sales VALUES("218","posr-20200727-084024","1","","11","2","1","1","1","0","35","385","385","0","0","","","","","1","4","","385","","","2020-07-27 10:40:24","2020-07-27 10:40:24");
INSERT INTO sales VALUES("219","posr-20200727-084644","1","","11","2","1","1","1","0","35","385","385","0","0","","","","","1","4","","385","","","2020-07-27 10:46:45","2020-07-27 10:46:45");
INSERT INTO sales VALUES("220","posr-20200812-062804","1","","11","2","1","3","6","0","0","760","760","0","0","","","","","1","4","","760","","","2020-08-12 08:28:04","2020-08-12 08:28:04");
INSERT INTO sales VALUES("221","posr-20200812-063035","1","","11","2","1","1","1","0","100","1100","1100","0","0","","","","","1","4","","1100","","","2020-08-12 08:30:35","2020-08-12 08:30:35");
INSERT INTO sales VALUES("222","posr-20200816-100424","1","","11","2","1","1","2","0","3000","23000","23000","0","0","","","","","1","4","","23000","","","2020-08-16 12:04:24","2020-08-16 12:04:24");
INSERT INTO sales VALUES("223","posr-20200816-100523","1","","11","2","1","1","1","0","40","440","440","0","0","","","","","1","4","","440","","","2020-08-16 12:05:23","2020-08-16 12:07:35");
INSERT INTO sales VALUES("224","sr-20200826-080139","1","","1","1","1","1","3","30","117","1287","1287","0","0","","","","","1","1","","","","","2020-08-26 10:01:39","2020-08-26 10:01:39");
INSERT INTO sales VALUES("230","posr-20201017-092852","9","2","11","1","5","1","1","0","0","250","250","0","0","","","","","1","2","","350","","","2020-10-17 11:28:52","2020-10-18 00:51:38");
INSERT INTO sales VALUES("231","sr-20201018-111333","9","2","1","1","5","1","1","0","40","440","440","0","0","","","","","1","2","","250","","","2020-10-18 01:13:33","2020-10-18 01:17:24");
INSERT INTO sales VALUES("232","posr-20201022-013014","9","2","11","1","5","1","1","0","0","100","100","0","0","","","","","1","4","","100","","","2020-10-22 03:30:14","2020-10-22 03:30:14");
INSERT INTO sales VALUES("233","posr-20201022-015604","1","3","11","1","1","1","1","0","0","250","250","0","0","","","","","1","4","","250","","","2020-10-22 03:56:04","2020-10-22 03:56:04");
INSERT INTO sales VALUES("234","posr-20201024-070506","1","4","11","2","1","1","1","0","1500","11500","11500","0","0","","","","","1","4","","11500","","","2020-10-23 21:05:06","2020-10-23 21:05:06");
INSERT INTO sales VALUES("235","posr-20201024-070751","1","4","11","2","1","1","1","0","0","250","250","0","0","","","","","1","4","","250","","","2020-10-23 21:07:51","2020-10-23 21:07:51");
INSERT INTO sales VALUES("237","posr-20201024-034601","1","4","11","2","1","3","9","0","7900","61900","61900","0","0","","","","","1","4","","61900","","","2020-10-24 05:46:01","2020-10-24 05:46:01");
INSERT INTO sales VALUES("239","posr-20201027-054002","1","3","11","1","1","1","1","0","0","2","2","0","0","","","","","1","4","","2","","","2020-10-26 19:40:02","2020-10-26 19:40:02");
INSERT INTO sales VALUES("240","posr-20201027-054206","1","3","11","1","1","1","2","0","0","6","6","0","0","","","","","1","4","","6","","","2020-10-26 19:42:06","2020-10-26 19:42:06");
INSERT INTO sales VALUES("241","posr-20201027-063200","1","4","11","2","1","1","1","0","0","250","250","0","0","","","","","1","4","","250","","","2020-10-26 20:32:00","2020-10-26 20:32:00");
INSERT INTO sales VALUES("242","posr-20201029-073030","1","4","11","2","1","1","1","0","0","250","250","0","0","","","","","1","4","","250","","","2020-10-28 21:30:30","2020-10-28 21:30:30");
INSERT INTO sales VALUES("243","posr-20201101-072112","1","4","11","2","1","1","1","0","0","250","250","0","0","","","","","1","4","","250","","","2020-10-31 21:21:12","2020-10-31 21:21:12");
INSERT INTO sales VALUES("245","posr-20201101-074223","1","3","11","1","5","2","3","0","80","1130","1130","","0","0","","","0","1","4","","1130","","","2020-10-31 21:42:23","2020-10-31 21:42:23");
INSERT INTO sales VALUES("246","posr-20201101-075017","1","4","11","2","1","1","1","0","40","440","440","0","0","0","","","0","1","4","","440","ssss
ssas","hhhh
kkkk","2020-10-31 21:50:17","2020-11-02 05:39:17");
INSERT INTO sales VALUES("250","posr-20201106-013041","1","4","11","2","1","1","1","0","34.4","378.4","378.4","0","0","","","","","1","4","","378.4","","","2020-11-06 02:30:41","2020-11-06 02:30:41");
INSERT INTO sales VALUES("251","posr-20201109-011524","1","4","19","2","1","2","2","0","34.4","610.6","610.6","0","0","","","","","1","2","","500","","","2020-11-09 02:15:24","2020-11-09 02:15:24");
INSERT INTO sales VALUES("252","posr-20201111-055858","1","3","11","1","1","1","1","0","0","229.5","229.5","0","0","","","","","1","4","","229.5","","","2020-11-10 18:58:58","2020-11-10 18:58:58");
INSERT INTO sales VALUES("253","posr-20201114-064736","1","4","11","2","1","3","3","0","1275","10242.5","10242.5","0","0","","","","","1","4","","10242.5","","","2020-11-13 19:47:36","2020-11-13 19:47:36");
INSERT INTO sales VALUES("256","posr-20201117-064748","1","4","11","2","1","2","2","0","65","715","715","0","0","","","","","1","4","","715","","","2020-11-16 19:47:48","2020-11-16 19:47:48");
INSERT INTO sales VALUES("257","posr-20201117-070919","1","4","11","2","1","1","1","0","0","250","250","0","0","","","","","1","4","","250","","","2020-11-16 20:09:19","2020-11-16 20:09:19");
INSERT INTO sales VALUES("258","posr-20201118-065239","1","4","11","2","1","1","3","0","4500","34500","27200","0","0","600","1","6800","100","1","4","","27200","","","2020-11-17 19:52:39","2020-11-17 19:52:39");
INSERT INTO sales VALUES("262","1111","1","3","1","1","1","1","2","0","3000","23000","23000","0","0","0","","","0","1","1","","","","","2020-11-28 18:21:30","2020-11-28 18:21:30");
INSERT INTO sales VALUES("263","posr-20201208-093957","1","4","11","2","1","1","1","0","40","440","440","0","0","","","","","1","2","","350","","","2020-12-07 22:39:57","2021-01-06 03:23:50");
INSERT INTO sales VALUES("270","sr-20210111-014535","1","3","1","1","1","2","2","0","137.57","1388","1388","0","0","0","","","0","1","2","","","","","2021-01-11 02:45:35","2021-01-11 02:58:44");
INSERT INTO sales VALUES("271","posr-20210111-021625","1","3","19","1","2","3","4","0","98.78","1274","1274","0","0","","","","","1","4","","1274","","","2021-01-11 03:16:25","2021-01-11 03:16:25");
INSERT INTO sales VALUES("274","posr-20210113-070243","1","4","11","2","1","4","15","40","91.65","1556","1556","0","0","","","","","1","4","","1556","","","2021-01-12 20:02:43","2021-01-12 20:02:43");
INSERT INTO sales VALUES("275","posr-20210201-023748","1","4","11","2","1","1","1","0","40","440","484","10","44","","","","","1","4","","484","","","2021-02-01 03:37:48","2021-02-01 03:37:48");
INSERT INTO sales VALUES("277","posr-20210216-070948","1","4","11","2","1","15","15","0","1758.78","15156","15156","0","0","","","","","1","4","","15156","","","2021-02-15 20:09:48","2021-02-15 20:09:48");
INSERT INTO sales VALUES("278","posr-20210217-073238","1","4","11","2","1","5","6","0","3140","24910","26949.9","10","2440.9","501","","","100","1","4","","26949.9","","","2021-02-16 20:32:38","2021-02-16 20:32:38");
INSERT INTO sales VALUES("279","sr-20210311-014034","1","3","1","1","1","1","2","0","0","4","4","0","0","","","","","1","1","","","","","2021-03-11 02:40:34","2021-03-11 02:40:34");
INSERT INTO sales VALUES("280","sr-20210317-041411","1","3","1","1","1","1","1","0","0","2","2","0","0","","","","","1","1","","","","","2021-03-16 18:14:11","2021-03-16 18:14:11");
INSERT INTO sales VALUES("282","sr-20210318-054729","1","3","1","2","1","1","1","0","0","2","2","0","0","0","","","0","1","2","","","","","2021-03-17 19:47:29","2021-03-20 00:59:57");
INSERT INTO sales VALUES("288","sr-20210412-014046","1","3","11","1","1","1","1","0","0","120","120","0","0","","","","","1","1","","","","","2021-04-12 03:40:46","2021-04-12 03:40:46");
INSERT INTO sales VALUES("289","posr-20210524-071424","1","4","11","2","1","2","2","0","40","690","640","0","0","50","","","","1","4","","640","","","2021-05-24 09:14:24","2021-05-24 09:14:24");
INSERT INTO sales VALUES("290","sr-20210524-071512","1","3","1","1","1","1","1","0","0","120","120","0","0","0","","","0","1","4","","120","","","2021-05-24 09:15:12","2021-05-24 09:46:47");
INSERT INTO sales VALUES("294","sr-20211016-035124","1","3","1","1","1","1","5","0","0","1500","1500","0","0","","","","","1","4","","1500","","","2021-10-16 15:51:24","2021-10-16 15:52:33");
INSERT INTO sales VALUES("295","posr-20211016-035454","1","4","11","2","1","1","5","0","200","2200","2200","0","0","","","","","1","4","","2200","","","2021-10-16 15:54:54","2021-10-16 15:54:54");
INSERT INTO sales VALUES("296","posr-20211219-112641","1","4","11","2","1","1","1","0","40","440","440","0","0","","","","","1","4","","440","","","2021-12-19 11:26:41","2021-12-19 11:26:41");
INSERT INTO sales VALUES("297","posr-20211219-024746","1","3","11","1","1","1","3","0","0","5475","5475","0","0","","","","","1","4","","5475","","","2021-12-19 14:47:46","2021-12-19 14:47:46");
INSERT INTO sales VALUES("298","posr-20220205-070121","1","3","2","1","5","2","2","0","36","414.9","414.9","0","0","","","","","1","4","","414.9","","","2022-02-05 19:01:21","2022-02-05 19:01:21");
INSERT INTO sales VALUES("299","sr-20220205-070251","1","4","2","2","2","1","10","0","900","9900","9900","0","0","","","","","1","1","","","","","2022-02-05 19:02:51","2022-02-05 19:02:51");
INSERT INTO sales VALUES("300","posr-20220303-123331","29","5","11","1","1","1","1","0","0","450","450","0","0","","","","","1","4","","450","","","2022-03-03 00:33:31","2022-03-03 00:33:31");
INSERT INTO sales VALUES("301","posr-20220303-123501","29","5","11","1","1","2","2","0","0","1580","1580","0","0","","","","","1","4","","1580","","","2022-03-03 00:35:01","2022-03-03 00:35:01");
INSERT INTO sales VALUES("302","posr-20220303-083006","29","5","21","1","1","5","7","0","0","2600","2600","0","0","","","","","3","2","","800","","","2022-03-03 20:30:06","2022-03-03 20:30:06"