<?php

namespace App\Http\Controllers\front;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use DB;
use App\Category;
use App\Product;
use App\Customer;
use App\Unit;
use App\CashRegister;
use App\Sale;
use App\ProductVariant;
use App\Variant;
use App\Product_Sale;
use App\Delivery;
use App\Slider;
use App\Page;
use App\Faq;
use App\BlogCat;
use App\Blog;
use App\Add;
use App\User;
use App\MailSetting;
use Auth;
use App\CustomerGroup;
use App\Biller;
use App\Mail\UserNotification;
use Illuminate\Support\Facades\Mail;
use Gloudemans\Shoppingcart\Facades\Cart; // for cart lib
use Illuminate\Validation\Rule;
use App\Review;
use App\Coupon;
use App\SeoMeta;
use Carbon\Carbon;
use Illuminate\Support\Str; 
use App\Library\SslCommerz\SslCommerzNotification;
use Session;
use URL;
use Srmklive\PayPal\Services\PayPal as PayPalClient;
use App\Traits\SeoTrait;


class WebController extends Controller
{
    use SeoTrait;

    //
    public function authenticate(){
        
        if (Auth::user()->role_id == 5) {
            return redirect('/check_out');
        } 

        else {
            return redirect('/home');
        }
    }
    public function index()
    {
        
        $categoriesWithMoreThan3Products = Product::select('category_id',
                                        DB::raw('COUNT(*) as product_count'),
                                        DB::raw('MAX(created_at) as latest_product_created_at')
                                        )
                                            ->where('is_active', true)
                                            ->groupBy('category_id')
                                            ->having('product_count', '>=', 3)
                                            ->take(3)
                                            ->get();
                                            //dd($categoriesWithMoreThan3Products);
        $cart_items = Cart::content();
        $featured_products = Product::where('is_active', true)
                            ->where('featured', true)
                            ->orderBy('id', 'desc')
                            ->paginate(20);
        //dd($featured_products);

        $vegetable_products =  DB::table('categories')
                    ->join('products', 'categories.id', '=', 'products.category_id')
                    ->where('categories.name', 'like', '%' . 'vegetable' . '%')
                    ->where('categories.is_active', true)
                    ->where('products.is_active', true)
                    
                    ->paginate(20);
        //dd($meat_products);

        $meat_products = DB::table('categories')
                    ->join('products', 'categories.id', '=', 'products.category_id')
                    ->where('categories.name', 'like', '%' . 'meat' . '%')
                    ->where('categories.is_active', true)
                    ->where('products.is_active', true)
                    
                    ->paginate(20);
        //dd($meat_products);

        $frozen_products = DB::table('categories')
                    ->join('products', 'categories.id', '=', 'products.category_id')
                    ->where('categories.name', 'like', '%' . 'frozen' . '%')
                    ->where('categories.is_active', true)
                    ->where('products.is_active', true)
                    
                    ->paginate(20);



        $deal_products = Product::where('is_active', true)
                                ->where('promotion_price', '!=', null)
                                ->where('last_date', '>', Carbon::today())
                                ->paginate(20);
        $products = Product::where('is_active',true)->orderBy('id','desc')->paginate(20);

        $categories = Category::where('is_active',true)->orderBy('id','desc')->where('parent_id',null)->get();

        $parent_category = Category::where('is_active',true)->orderBy('id','desc')->where('parent_id',null)->paginate(9);
        $general_setting = DB::table('general_settings')->latest()->first();
        /*return view('index',compact('slider','product','category','cart','order'));*/

        //dynamic
        $sliders=Slider::all();
        $blogs=Blog::orderBy('id','desc')->get();
        $blog_cats=BlogCat::all();
        $adds = Add::all();
        $this->applySeo('home');
        return view('front/index',compact('general_setting','categories','products','deal_products','cart_items','featured_products','vegetable_products','meat_products','frozen_products','categoriesWithMoreThan3Products','parent_category','sliders','blogs','blog_cats','adds'));
     
    }

    public function wishlist(){
        $cart_items = Cart::content();
        return view('front/wishlist',compact('cart_items'));
    }

    public function track_order(){
        $categories = Category::where('is_active',true)->orderBy('id','desc')->where('parent_id',null)->get();
        $cart_items = Cart::content();
        $user = Auth::user();
        $customer = Customer::where('user_id',$user->id)->first();
        $orders = Sale::where('customer_id',$customer->id)->orderBy('id','desc')->get();
        return view('front/track_order',compact('cart_items','orders','categories','customer'));
    }

    //csutomer_account
   public function customer_account()
    {
        $categories = Category::where('is_active', true)->orderBy('id', 'desc')->where('parent_id', null)->get();
        $cart_items = Cart::content();
        $user = Auth::user();
        $customer = Customer::where('user_id', $user->id)->first();

        // Check if the user is a customer
        if (!$customer) {
            return redirect()->route('home')->with('error', 'Access denied: You do not have permission to access this module.');
        }

        $orders = Sale::where('customer_id', $customer->id)->orderBy('id', 'desc')->get();

        return view('front/customer_account', compact('cart_items', 'orders', 'categories', 'customer'));
        
    }


    public function updateCustomerAccount(Request $request)
    {
        $user = Auth::user();
        $customer = Customer::where('user_id', $user->id)->first();

        if (!$customer) {
            return redirect()->route('home')->with('error', 'Access denied: You do not have permission to access this module.');
        }

        // Validate input fields with the exact column names
        $request->validate([
            'customer_name' => 'required|string|max:255', // Assuming 'customer_name' is the actual column name
            'company_name' => 'nullable|string|max:255',  // Assuming 'company_name' is the actual column name
            'phone_number' => 'nullable|string|max:20|unique:customers,phone_number,' . $customer->id,
            'email' => 'required|email|unique:customers,email,' . $customer->id,
            'address' => 'nullable|string|max:500',
        ]);

        // Update customer details using the exact column names
        $customer->update([
            'customer_name' => $request->input('customer_name'),
            'company_name' => $request->input('company_name'),
            'phone_number' => $request->input('phone_number'),
            'email' => $request->input('email'),
            'address' => $request->input('address')
        ]);

        return redirect()->route('customer_account')->with('success', 'Account details updated successfully!');
    }

    /*public function errorpage(){
        $cart_items = Cart::content();
        return view('front/404',compact('cart_items'));
    }*/

    public function notFound()
    {
        $categories = Category::where('is_active', true)
            ->orderBy('id', 'desc')
            ->where('parent_id', null)
            ->get();
        
        $cart_items = Cart::content();
        
        return view('front.404', compact('cart_items', 'categories'));
    }
    
    public function contact(){
        $categories = Category::where('is_active',true)->orderBy('id','desc')->where('parent_id',null)->get();
        $cart_items = Cart::content();
        $this->applySeo('contact');
        return view('front/contact',compact('cart_items','categories'));

    }
    public function faq(){
        $categories = Category::where('is_active',true)->orderBy('id','desc')->where('parent_id',null)->get();
        $cart_items = Cart::content();
        $faqs=Faq::all();
        return view('front/faq',compact('cart_items','categories','faqs'));
    }

    public function blog()
    {
        $blogs=Blog::orderBy('id','desc')->get();
        $blog_cats=BlogCat::all();
        $cart_items = Cart::content();
        

        return view('front.blog', compact('blogs','blog_cats','cart_items'));
    }

    public function blog_by_cat($id){
        $blogs = Blog::where('cat_id',$id)->get();
        $blog_cats=BlogCat::all();
        $cart_items = Cart::content();
        

        return view('front.blog', compact('blogs','blog_cats','cart_items'));

    }

    /*public function blog_item($id)
    {
        $blogs=Blog::where('id', '=', $id)->first();
        $blog_cats=BlogCat::all();
        $cart_items = Cart::content();
        $blog_all = Blog::orderBy('id', 'desc')->get();


        return view('front.blog-item', compact('blogs','blog_cats','cart_items','blog_all'));
    }*/

    /*public function pages($id)
    {
        $about=Page::where('id', '=', $id)->first();
        $content = $about->desc ?? ''; // Ensure it's not null
        // Separate the first <p> tag and the remaining content
        $firstParagraph = '';
        $remainingContent = '';

        
        if (preg_match('/<p[^>]*>.*?<\/p>/is', $content, $matches)) {
                $firstParagraph = $matches[0]; // The first <p> tag
                $remainingContent = str_replace($firstParagraph, '', $content); // Remove the first <p> tag from the rest
            } else {
                // If no <p> tags are found, keep the entire content in $remainingContent
                $remainingContent = $content;
            }
        $about->firstParagraph = $firstParagraph;
        $about->remainingContent = $remainingContent;
        $cart_items = Cart::content();
        return view('front.about-us', compact('about','cart_items'));
    }*/


    /*public function single_product($id)
    {
        $categories = Category::where('is_active', true)->orderBy('id', 'desc')->where('parent_id', null)->get();
        $cart_items = Cart::content();
        $product = Product::find($id);

        if ($product) {
            $reviews = Review::where('product_id', $product->id)->get();
            $number = $reviews->count();
            $totalStars = $reviews->sum('stars');
            $averageRating = $number > 0 ? $totalStars / $number : 0;

            // Process product details
            $productDetails = $product->product_details ?? ''; // Ensure it's not null

            // Separate the first <p> tag and the remaining content
            $firstParagraph = '';
            $remainingContent = '';

            // Regex to extract the first <p> tag
            if (preg_match('/<p[^>]*>.*?<\/p>/is', $productDetails, $matches)) {
                $firstParagraph = $matches[0]; // The first <p> tag
                $remainingContent = str_replace($firstParagraph, '', $productDetails); // Remove the first <p> tag from the rest
            } else {
                // If no <p> tags are found, keep the entire content in $remainingContent
                $remainingContent = $productDetails;
            }

            // Assign to product
            $product->product_details1 = $firstParagraph;
            $product->product_details2 = $remainingContent;

            // Related products
            $related_products = Product::where('is_active', true)
                ->where('category_id', $product->category_id)
                ->get();
        } else {
            // Handle product not found
            $product = null;
            $reviews = collect();
            $number = 0;
            $totalStars = 0;
            $averageRating = 0;
            $related_products = collect();
        }

        return view('front/single-product', compact('product','cart_items','categories','reviews','number','totalStars','averageRating','related_products'
        ));
    }*/
    public function blog_item($id)
    {
        $blog = Blog::findOrFail($id);

        $seo = SeoMeta::where('model_type', Blog::class)
                      ->where('model_id', $blog->id)
                      ->first();

        $slug = $seo && $seo->slug ? $seo->slug : \Str::slug($blog->title ?? 'blog-item');

        return redirect()->route('blog.seo', ['id' => $blog->id, 'slug' => $slug], 301);
    }

    public function blog_slug($id, $slug = null)
    {
        $blog = Blog::findOrFail($id);

        $seo = SeoMeta::where('model_type', Blog::class)
                      ->where('model_id', $blog->id)
                      ->first();

        $correctSlug = $seo && $seo->slug ? $seo->slug : \Str::slug($blog->title ?? 'blog');

        if ($slug !== $correctSlug) {
            return redirect()->route('blog.seo', ['id' => $blog->id, 'slug' => $correctSlug], 301);
        }

        // Apply SEO meta tags
        $this->applySeo(Blog::class, $blog->id);

        $blog_cats = BlogCat::all();
        $cart_items = Cart::content();
        $blog_all = Blog::orderBy('id', 'desc')->get();

        return view('front.blog-item', [
            'blogs' => $blog,
            'blog_cats' => $blog_cats,
            'cart_items' => $cart_items,
            'blog_all' => $blog_all
        ]);
    }



    public function pages($id)
    {
        $about = Page::findOrFail($id);

        $seo = SeoMeta::where('model_type', Page::class)
                      ->where('model_id', $about->id)
                      ->first();

        $slug = $seo && $seo->slug ? $seo->slug : \Str::slug($about->name ?? 'page');

        return redirect()->route('page.seo', ['id' => $about->id, 'slug' => $slug], 301);
    }
    public function pages_slug($id, $slug = null)
    {
        //dd($slug);
        $about = Page::findOrFail($id);

        $seo = SeoMeta::where('model_type', Page::class)
                      ->where('model_id', $about->id)
                      ->first();

        $correctSlug = $seo && $seo->slug ? $seo->slug : \Str::slug($about->title ?? 'page');

        if ($slug !== $correctSlug) {
            return redirect()->route('page.seo', ['id' => $about->id, 'slug' => $correctSlug], 301);
        }

        $content = $about->desc ?? '';
        $firstParagraph = '';
        $remainingContent = '';

        if (preg_match('/<p[^>]*>.*?<\/p>/is', $content, $matches)) {
            $firstParagraph = $matches[0];
            $remainingContent = str_replace($firstParagraph, '', $content);
        } else {
            $remainingContent = $content;
        }

        $about->firstParagraph = $firstParagraph;
        $about->remainingContent = $remainingContent;

        $cart_items = Cart::content();

        // Apply SEO tags
        $this->applySeo(Page::class, $about->id);

        return view('front.about-us', compact('about', 'cart_items'));
    }



    public function single_product($id)
    {
        $product = Product::find($id);

        if (!$product) {
            abort(404);
        }

        // Fetch SEO meta if exists
        $seo = SeoMeta::where('model_type', Product::class)
                      ->where('model_id', $product->id)
                      ->first();

        // Use SEO slug if exists, else slugify product name
        $slug = $seo && $seo->slug ? $seo->slug : \Str::slug($product->name);


        // Redirect to the slug URL with 301 permanent redirect
        return redirect()->route('product.seo', ['id' => $product->id, 'slug' => $slug], 301);
    }

    public function single_product_slug($id, $slug = null)
    {
        $categories = Category::where('is_active', true)->orderBy('id', 'desc')->where('parent_id', null)->get();
        $cart_items = Cart::content();
        $product = Product::find($id);

        if (!$product) {
            abort(404);
        }

        // Optional: Check if slug matches SEO slug or product slug
        $seo = SeoMeta::where('model_type', Product::class)
                      ->where('model_id', $product->id)
                      ->first();

        $correctSlug = $seo && $seo->slug ? $seo->slug : \Str::slug($product->name);

        // If URL slug is missing or wrong, redirect to correct slug URL
        if ($slug !== $correctSlug) {
            return redirect()->route('product.seo', ['id' => $product->id, 'slug' => $correctSlug], 301);
        }

        // Fetch reviews
        $reviews = Review::where('product_id', $product->id)->get();
        $number = $reviews->count();
        $totalStars = $reviews->sum('stars');
        $averageRating = $number > 0 ? $totalStars / $number : 0;

        // Process product details
        $productDetails = $product->product_details ?? ''; // Ensure it's not null

        $firstParagraph = '';
        $remainingContent = '';

        if (preg_match('/<p[^>]*>.*?<\/p>/is', $productDetails, $matches)) {
            $firstParagraph = $matches[0];
            $remainingContent = str_replace($firstParagraph, '', $productDetails);
        } else {
            $remainingContent = $productDetails;
        }

        $product->product_details1 = $firstParagraph;
        $product->product_details2 = $remainingContent;

        // Related products
        $related_products = Product::where('is_active', true)
            ->where('category_id', $product->category_id)
            ->get();
        $this->applySeo('App\Product', $product->id);

        return view('front/single-product', compact(
            'product', 'cart_items', 'categories',
            'reviews', 'number', 'totalStars', 'averageRating',
            'related_products'
        ));
    }



    public function order_now($id)
    {
        // Retrieve the product details
        $product = Product::find($id);
        // Check if the product exists and is active
        if (!$product || !$product->is_active) {
            return redirect()->back()->with('error', 'Product not found or not active');
        }
        
        // Check if the product is already in the cart
        $cartItem = Cart::content()->where('id', $id)->first();
        
        if (!$cartItem) {
            // If not in cart, add the product to the cart
            Cart::add([
                'id' => $product->id,
                'name' => $product->name,
                'qty' => 1, // Default quantity to 1 for 'order now'
                'price' => $product->promotion_price ?? $product->price,
                'weight' => 0,
                'options' => [
                    'size' => null,
                    'product_code' => $product->code
                ]
            ]);
        }
        
        // Retrieve the necessary elements for the view
        $categories = Category::where('is_active', true)->orderBy('id', 'desc')->where('parent_id', null)->get();
        $cart_items = Cart::content();
        // Return the 'order_now' view with the product details and other necessary data
        return view('front/order_now', compact('product', 'cart_items', 'categories'));
    }

    public function update_order_now_quantity(Request $request, $id)
    {
        $quantity = $request->input('quantity');
        $product = Product::find($id);

        if (!$product) {
            return response()->json(['success' => false, 'message' => 'Product not found']);
        }

        $cartItem = Cart::content()->where('id', $id)->first();

        if ($cartItem) {
            // If quantity is 2 and current qty is 1, increase by 1
            // If quantity is 1 and current qty is 2, decrease by 1
            $newQuantity = $quantity == 2 && $cartItem->qty == 1 ? 2 : 1;
            Cart::update($cartItem->rowId, $newQuantity);
            return response()->json(['success' => true]);
        }

        return response()->json(['success' => false, 'message' => 'Item not found in cart']);
    }


    public function shop_left_sidebar(Request $request){

        // Get sort parameter from request, default to 'default' if not present
        $sortBy = $request->input('sort', 'default');
        $categories = Category::where('is_active',true)->orderBy('id','desc')->where('parent_id',null)->get();
        $cart_items = Cart::content();
        $today = now()->toDateString();

        // Build the base query
        $query = Product::where('is_active',true);
        
        // Apply sorting based on parameter
        switch ($sortBy) {
            case 'name_asc':
                $query->orderBy('name', 'asc');
                break;
            case 'name_desc':
                $query->orderBy('name', 'desc');
                break;
            case 'price_asc':
                $query->orderByRaw("
                    CASE 
                        WHEN promotion_price IS NOT NULL 
                             AND starting_date <= ? 
                             AND last_date >= ? 
                        THEN promotion_price + 0 
                        ELSE price + 0 
                    END ASC
                ", [$today, $today]);
                break;

            case 'price_desc':
                $query->orderByRaw("
                    CASE 
                        WHEN promotion_price IS NOT NULL 
                             AND starting_date <= ? 
                             AND last_date >= ? 
                        THEN promotion_price + 0 
                        ELSE price + 0 
                    END DESC
                ", [$today, $today]);
                break;
            default:
                // Keep your original sorting
                $query->orderBy('id', 'desc');
                break;
        }
        
        // Get paginated products with the applied sorting
        $products = $query->paginate(30);


        // Append sort parameter to pagination links
        $products->appends(['sort' => $sortBy]);
        
        // Keep the rest of your code unchanged
        $featured_products = Product::where('is_active', true)
                            ->where('featured', true)
                            ->orderBy('id', 'desc')
                            ->paginate(20);
        $image = Page::where('name','Shop')->first();
        $shop = Page::where('name','Shop')->first();
        $slug = "All Products";
        $this->applySeo('shop');
        return view('front/shop', compact('products', 'cart_items', 'categories', 'image', 'shop', 'featured_products', 'sortBy','slug'));
    }

    public function deals(Request $request)
    {
        $sortBy = $request->input('sort', 'default');
        $today  = now()->toDateString();
        $categories   = Category::where('is_active', true)->whereNull('parent_id')->orderBy('id', 'desc')->get();
        $cart_items   = Cart::content();
        $image        = Page::where('name','Shop')->first();
        $shop         = $image; 

        
        $query = Product::where('is_active', true)
                 ->whereNotNull('promotion_price')
                 ->where('last_date', '>', $today);

        
        switch ($sortBy) {
            case 'name_asc':
                $query->orderBy('name', 'asc');
                break;
            case 'name_desc':
                $query->orderBy('name', 'desc');
                break;
            case 'price_asc':
                $query->orderByRaw("
                    CASE
                        WHEN promotion_price IS NOT NULL
                             AND starting_date <= ?
                             AND last_date     >= ?
                        THEN promotion_price + 0
                        ELSE price + 0
                    END ASC
                ", [$today, $today]);
                break;
            case 'price_desc':
                $query->orderByRaw("
                    CASE
                        WHEN promotion_price IS NOT NULL
                             AND starting_date <= ?
                             AND last_date     >= ?
                        THEN promotion_price + 0
                        ELSE price + 0
                    END DESC
                ", [$today, $today]);
                break;
            default:
                $query->orderBy('id', 'desc');
                break;
        }

       
        $deal_products = $query->paginate(4);
        $deal_products->appends(['sort' => $sortBy]);

      
        $products = Product::where('is_active', true)
                           ->whereNotNull('promotion')
                           ->orderBy('id', 'desc')
                           ->paginate(20);

        $featured_products = Product::where('is_active', true)
                            ->where('featured', true)
                            ->orderBy('id', 'desc')
                            ->paginate(20); 
        return view('front/deals',compact('products','cart_items','categories','image','shop','deal_products','featured_products'));
    }

    public function shop_left_sidebar_by_id($id, Request $request){
        $sortBy = $request->input('sort', 'default');
        $categories = Category::where('is_active',true)->orderBy('id','desc')->where('parent_id',null)->get();
        $cart_items = Cart::content();
        /*$products = Product::where('is_active',true)->orderBy('id','desc')->where('category_id',$id)->paginate(20);*/
        $today = now()->toDateString();

        $query = Product::join('categories', 'products.category_id', '=', 'categories.id')
            ->select('products.*')
            ->whereIn('products.category_id', function ($subQuery) use ($id) {
                $subQuery->select('id')
                    ->from('categories')
                    ->where('id', $id)
                    ->orWhere('parent_id', $id);
            })
            ->where('products.is_active', true);

        // Apply sorting
        switch ($sortBy) {
            case 'name_asc':
                $query->orderBy('name', 'asc');
                break;
            case 'name_desc':
                $query->orderBy('name', 'desc');
                break;
            case 'price_asc':
                $query->orderByRaw("
                    CASE 
                        WHEN promotion_price IS NOT NULL 
                             AND starting_date <= ? 
                             AND last_date >= ? 
                        THEN promotion_price + 0 
                        ELSE price + 0 
                    END ASC
                ", [$today, $today]);
                break;
            case 'price_desc':
                $query->orderByRaw("
                    CASE 
                        WHEN promotion_price IS NOT NULL 
                             AND starting_date <= ? 
                             AND last_date >= ? 
                        THEN promotion_price + 0 
                        ELSE price + 0 
                    END DESC
                ", [$today, $today]);
                break;
            default:
                $query->orderBy('id', 'desc');
                break;
        }

        $products = $query->paginate(20);
        // Append sort parameter to pagination links
        $products->appends(['sort' => $sortBy]);

        $featured_products = Product::where('is_active', true)
                            ->where('featured', true)
                            ->orderBy('id', 'desc')
                            ->paginate(20);    
            
        $image=Page::where('name','Shop')->first();
        $shop = Page::where('name','Shop')->first();
        $category = Category::find($id);
        $slug = $category->name;
        return view('front/shop',compact('products','cart_items','categories','image','shop','id', 'featured_products','slug'));
    }

    public function product_search(Request $request){
        //dd($request->all());
        $categories = Category::where('is_active',true)->orderBy('id','desc')->where('parent_id',null)->get();
        $cart_items = Cart::content();
        //$page_type = 1;
        $keyword = $request->search;

        $today = now()->toDateString();
        $sortBy = $request->input('sort', 'default');
        $query = DB::table('categories')
            ->join('products', 'categories.id', '=', 'products.category_id')
            ->where(function ($q) use ($keyword) {
                $q->where('categories.name', 'like', '%' . $keyword . '%')
                  ->orWhere('products.name', 'like', '%' . $keyword . '%');
            })
            ->where('categories.is_active', true)
            ->where('products.is_active', true)
            ->select('products.*'); // ensure you're only selecting products

        // Sorting
        switch ($sortBy) {
            case 'name_asc':
                $query->orderBy('products.name', 'asc');
                break;
            case 'name_desc':
                $query->orderBy('products.name', 'desc');
                break;
            case 'price_asc':
                $query->orderByRaw("
                    CASE 
                        WHEN promotion_price IS NOT NULL 
                             AND starting_date <= ? 
                             AND last_date >= ? 
                        THEN promotion_price + 0
                        ELSE price + 0
                    END ASC
                ", [$today, $today]);
                break;
            case 'price_desc':
                $query->orderByRaw("
                    CASE 
                        WHEN promotion_price IS NOT NULL 
                             AND starting_date <= ? 
                             AND last_date >= ? 
                        THEN promotion_price + 0
                        ELSE price + 0
                    END DESC
                ", [$today, $today]);
                break;
            default:
                $query->orderBy('products.id', 'desc');
                break;
        }

        $products = $query->paginate(12)->appends(request()->query());

        

        $featured_products = Product::where('is_active', true)
                            ->where('featured', true)
                            ->orderBy('id', 'desc')
                            ->paginate(20); 
        /*dd($products);*/
        $image=Page::where('name','Shop')->first();
        $shop = Page::where('name','Shop')->first();
        $slug = $keyword;
        return view('front/shop',compact('products','cart_items','categories','image','shop','featured_products','slug'));

    }

    //for sorting

    public function sortProducts(Request $request)
    {
        $sortBy = $request->input('sort', 'default');
        
        // Build the base query - keep consistent with your shop_left_sidebar method
        $query = Product::where('is_active', true);
        $today = now()->toDateString();
        // Apply sorting based on user selection
        switch ($sortBy) {
            case 'name_asc':
                $query->orderBy('name', 'asc');
                break;
            case 'name_desc':
                $query->orderBy('name', 'desc');
                break;
            case 'price_asc':
                $query->orderByRaw("
                    CASE 
                        WHEN promotion_price IS NOT NULL 
                             AND starting_date <= ? 
                             AND last_date >= ? 
                        THEN promotion_price + 0 
                        ELSE price + 0 
                    END ASC
                ", [$today, $today]);
                break;

            case 'price_desc':
                $query->orderByRaw("
                    CASE 
                        WHEN promotion_price IS NOT NULL 
                             AND starting_date <= ? 
                             AND last_date >= ? 
                        THEN promotion_price + 0 
                        ELSE price + 0 
                    END DESC
                ", [$today, $today]);
                break;
            default:
                // Keep your original sorting
                $query->orderBy('id', 'desc');
                break;
        }      
        
        // Paginate the results - use the same pagination size as your shop page
        $products = $query->paginate(30);
        
        // Append sort parameter to pagination links
        $products->appends(['sort' => $sortBy]);
        
        // For AJAX requests, return JSON response
        return response()->json([
            'products' => $products,
            'links' => $products->links()->toHtml()
        ]);
    }

    



    public function product_details_data($id){

        $product = Product::find($id);

        if($product->is_variant == null && $product->qty > 0){
            $stock_cond = 1;
        }
        elseif($product->is_variant != null){
            $stock_cond = 2;
        }
        else{$stock_cond = 3;}

        $product_detail[0] = $product->name;
        $product_detail[1] = $product->code;
        if($product->promotion_price == null){
            $product_detail[2] = $product->price;
        }
        else{
          $product_detail[2] = $product->promotion_price;  
        }
        $product_detail[3] = Str::limit($product->product_details, 300);
        $product_detail[4] = $product->image;
        $product_detail[5] = $product->id;
        $product_detail[6] = $stock_cond;
        return $product_detail;
    }

    public function checkout(){
        $categories = Category::where('is_active',true)->orderBy('id','desc')->where('parent_id',null)->get();
        $user = Auth::user();
        $cart_items= Cart::content();
        $customer_detail = Customer::where('user_id',$user->id)->first();
        return view('front/checkout',compact('cart_items','customer_detail','categories'));
    }
    

    public function addItem(Request $request){
        //dd($request->all());
        $product = Product::find($request->product_id);
        if($product->is_variant == null){
            if($product->qty < $request->quantity){
                return back()->with('error','quantity exceeds stock');
            }
        }
        else{
            $variant = ProductVariant::where('item_code',$request->product_code)->first();
            $stock = $variant->qty;
            if($stock < $request->quantity){
                return back()->with('error','quantity exceeds stock');
            }
        }
        $cart=Cart::add(['id'=>$request->product_id, 'name'=>$request->name,'qty'=>$request->quantity,'price'=>$request->price,'weight'=>0, 'options' => ['size' => null,'product_code'=>$request->product_code]]);

           
          return back()->with('success','Product added to cart');
         
   }

   public function update_cart(Request $request){
        $categories = Category::where('is_active',true)->orderBy('id','desc')->where('parent_id',null)->get();
        foreach($request->rowId as $key => $row){
            $cart_items= Cart::content();
            foreach($cart_items as $item){
                if($item->rowId == $row){
                    $product = Product::find($item->id);
                    if($product->is_variant == null){
                        if($product->qty < $request->quantity[$key]){
                            return view('front/shopping-cart', compact('cart_items'),['error'=>'quantity exceeds stock']);
                        }
                    }
                    else{
                        $variant = ProductVariant::where('item_code',$item->options->product_code)->first();
                        $stock = $variant->qty;
                        if($stock < $request->quantity[$key]){
                            return view('front/shopping-cart', compact('cart_items'),['error'=>'quantity exceeds stock']);
                        }
                    }
                }
            }
            $cart_update = Cart::update($row, $request->quantity[$key]);
        }
        $cart_items= Cart::content();
        //dd($cart_items);
        return redirect()->back();
   }

   public function removeItem($id){
        Cart::remove($id);
        $cart_items= Cart::content();
        return redirect()->back();
   }

    public function cart(){
        $categories = Category::where('is_active',true)->orderBy('id','desc')->where('parent_id',null)->get();
        $cart_items= Cart::content();
        return view('front/shopping-cart', compact('cart_items','categories'));

    }

    //for bkash payment
    private $base_url;
    private $username;
    private $password;
    private $app_key;
    private $app_secret;
    public function __construct()
    {
        env('SANDBOX') ? $this->base_url = 'https://tokenized.sandbox.bka.sh/v1.2.0-beta' : $this->base_url = 'https://tokenized.pay.bka.sh/v1.2.0-beta';
        $this->username = env('BKASH_USERNAME');
        $this->password  = env('BKASH_PASSWORD');
        $this->app_key = env('BKASH_APP_KEY');
        $this->app_secret  = env('BKASH_APP_SECRET');
    }

    public function authHeaders(){
        return array(
            'Content-Type:application/json',
            'Authorization:' .$this->grant(),
            'X-APP-Key:'. $this->app_key 
        );
    }

    public function curlWithBody($url,$header,$method,$body_data){
        $curl = curl_init($this->base_url.$url);
        curl_setopt($curl,CURLOPT_HTTPHEADER, $header);
        curl_setopt($curl,CURLOPT_CUSTOMREQUEST, $method);
        curl_setopt($curl,CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl,CURLOPT_POSTFIELDS, $body_data);
        curl_setopt($curl,CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($curl, CURLOPT_IPRESOLVE, CURL_IPRESOLVE_V4);
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, FALSE);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, FALSE);
        $response = curl_exec($curl);
        curl_close($curl);
        return $response;
    }

    public function grant()
    {
        $header = array(
                'Content-Type:application/json',
                'username:'.$this->username,
                'password:'.$this->password
                );

        $body_data = array('app_key'=> $this->app_key, 'app_secret'=> $this->app_secret);
    
        $response = $this->curlWithBody('/tokenized/checkout/token/grant',$header,'POST',json_encode($body_data));

        $token = json_decode($response)->id_token;

        return $token;
    }

    //bkash payment functions ends

    public function place_order(Request $request){
       //dd($request->all());
       //dd(Cart::content());

        $categories = Category::where('is_active',true)->orderBy('id','desc')->where('parent_id',null)->get();
        $biller = Biller::where('is_active',true)->first();
        $data = $request->all();
        $cart_items= Cart::content();
        $item = $cart_items->count();
        $strSubtotal = Cart::subtotal();
        $subtotal = str_replace(',', '', $strSubtotal);
        $grand_total = $subtotal+ $request->deliveryOption - $request->coupon_discount;

        if (Auth::check()) {
            $user = Auth::user();
            $customer = Customer::where('user_id',$user->id)->first();
        }
        elseif($request->create_account == 'on'){
            // Validate customer data first
            $validationRules = [
                
                'name' => [
                    'required',
                    'max:255',
                    Rule::unique('users')->where(function ($query) {
                        return $query->where('is_deleted', false);
                    }),
                ],
                'email' => [
                    'required',
                    'email',
                    'max:255',
                    Rule::unique('users')->where(function ($query) {
                        return $query->where('is_deleted', false);
                    }),
                ],
            ];

            $customMessages = [
                'phone_number.unique' => 'This phone number is already registered. Please login to place your order or use a different phone number.',
                'name.unique' => 'This username is already registered. Please login to place your order or use a different username.',
                'email.unique' => 'This email is already registered. Please login to place your order or use a different email address.',
                'email.email' => 'Please provide a valid email address.',
                'phone_number.required' => 'Phone number is required.',
                'name.required' => 'Name is required.',
                'email.required' => 'Email is required.',
            ];

            $validator = \Validator::make($request->all(), $validationRules, $customMessages);

            if ($validator->fails()) {
                return redirect()->back()
                    ->withErrors($validator)
                    ->withInput();
            }
            $customerData = $request->all();
            //dd($customerData);
            $customerData['is_active'] = true;
            
            $customer_group = CustomerGroup::where('name', 'general')->first();
            $customerData['phone_number'] = $customerData['phone'];
            $customerData['role_id'] = 5;
            $customerData['customer_group_id'] = $customer_group->id;
            $customerData['is_deleted'] = false;
            $customerData['password'] = bcrypt($customerData['password']);
            
            $user = User::create($customerData);
            $customerData['user_id'] = $user->id;
            
            $customerData['name'] = $customerData['name'];
            $customerData['district'] = $request->state;

            $customer = Customer::create($customerData);
        }

        else{
            $user = User::where('is_active',true)->first();
            $customer = Customer::where('name','guest')->first();
        }

        $data['reference_no'] = 'sr-' . date("Ymd") . '-'. date("his");
        $data['customer_id'] = $customer->id;
        $data['warehouse_id'] = "1";
        $data['biller_id'] = $biller->id;
        $data['item'] = $item;
        $data['total_qty'] = Cart::content()->count();
        $data['total_discount'] = "0.00";
        $data['total_tax'] = "0.00";
        $data['total_price'] = $subtotal;
        $data['order_tax'] = "0.00";
        $data['grand_total'] = $grand_total;
        $data['pos'] = "0";
        $data['order_tax_rate'] = "0";
        $data['sale_status'] = "2";
        $data['payment_status'] = "1";
        $data['paid_by_id'] = "1";
        $data['product_code_name'] = null;
        $data['order_discount'] = null;
        $data['shipping_cost'] = $request->input('deliveryOption');
        $data['paying_amount'] = null;
        $data['paid_amount'] = null;
        $data['gift_card_id'] = null;
        $data['cheque_no'] = null;
        $data['payment_note'] = null;
        $combinedinfo = 
                "Name: " . $request->name . ",\n" . 
                "Phone Number: " . $request->phone . ",\n" . 
                "Email: " . $request->email . ",\n" . 
                "Address: " . $request->address . ",\n" . 
                "Note: " . $request->note . "\n";

        // Add payment method conditionally
        if ($request->bkashNumber === null && $request->nagadNumber === null) {
            $combinedinfo .= ",\nPayment Method: Cash on Delivery";
        } elseif ($request->bkashNumber !== null) {
            $combinedinfo .= ",\nBkash Number: " . $request->bkashNumber;
        } elseif ($request->nagadNumber !== null) {
            $combinedinfo .= ",\nNagad Number: " . $request->nagadNumber;
        }

        $data['sale_note'] = $combinedinfo;
        //dd($cart_items);
        //return dd($data);
        if (Auth::check()) {
            $data['user_id'] = Auth::id();
        }
        else{
            $data['user_id'] = $user->id;
        }

        $cash_register_data = CashRegister::where([
            ['user_id', $data['user_id']],
            ['warehouse_id', $data['warehouse_id']],
            ['status', true]
        ])->first();

        if($cash_register_data)
            $data['cash_register_id'] = $cash_register_data->id;
        

        $lims_sale_data = Sale::create($data);
        $lims_customer_data = Customer::find($data['customer_id']);
        
        $key = 0;
        foreach($cart_items as $item){
            $product_details = Product::find($item->id);
            $sale_unit = Unit::find($product_details->sale_unit_id);
            $data['product_id'][$key] = $item->id;
            $data['product_batch_id'][$key] = null;
            $data['product_code'][$key] = $item->options->product_code;
            $data['qty'][$key] = $item->qty;
            $data['sale_unit'][$key] = $sale_unit->unit_name;
            $data['net_unit_price'][$key] = $item->price;
            $data['discount'][$key] = "0.00";
            $data['tax_rate'][$key] = "0.00";
            $data['tax'][$key] = "0.00";
            $data['subtotal'][$key] = $item->qty * $item->price;
            $key++;
        }
        //dd($data);
        $product_id = $data['product_id'];
        $product_batch_id = $data['product_batch_id'];
        $product_code = $data['product_code'];
        $qty = $data['qty'];
        $sale_unit = $data['sale_unit'];
        $net_unit_price = $data['net_unit_price'];
        $discount = $data['discount'];
        $tax_rate = $data['tax_rate'];
        $tax = $data['tax'];
        $total = $data['subtotal'];
        $product_sale = [];

        foreach ($product_id as $i => $id) {
            $lims_product_data = Product::where('id', $id)->first();
            $product_sale['variant_id'] = null;
            $product_sale['product_batch_id'] = null;


            if($sale_unit[$i] != 'n/a') {
                $lims_sale_unit_data  = Unit::where('unit_name', $sale_unit[$i])->first();
                $sale_unit_id = $lims_sale_unit_data->id;
                if($lims_product_data->is_variant) {
                    $lims_product_variant_data = ProductVariant::select('id', 'variant_id', 'qty')->FindExactProductWithCode($id, $product_code[$i])->first();
                    $product_sale['variant_id'] = $lims_product_variant_data->variant_id;
                }

                
            }
            else
                $sale_unit_id = 0;
            if($product_sale['variant_id']){
                $variant_data = Variant::select('name')->find($product_sale['variant_id']);
                $mail_data['products'][$i] = $lims_product_data->name . ' ['. $variant_data->name .']';
            }
            else
                $mail_data['products'][$i] = $lims_product_data->name;
            if($lims_product_data->type == 'digital')
                $mail_data['file'][$i] = url('/public/product/files').'/'.$lims_product_data->file;
            else
                $mail_data['file'][$i] = '';
            if($sale_unit_id)
                $mail_data['unit'][$i] = $lims_sale_unit_data->unit_code;
            else
                $mail_data['unit'][$i] = '';

            $product_sale['sale_id'] = $lims_sale_data->id ;
            $product_sale['product_id'] = $id;
            $product_sale['qty'] = $mail_data['qty'][$i] = $qty[$i];
            $product_sale['sale_unit_id'] = $sale_unit_id;
            $product_sale['net_unit_price'] = $net_unit_price[$i];
            $product_sale['discount'] = $discount[$i];
            $product_sale['tax_rate'] = $tax_rate[$i];
            $product_sale['tax'] = $tax[$i];
            $product_sale['total'] = $mail_data['total'][$i] = $total[$i];
            Product_Sale::create($product_sale);
        }
        
        $delivery = new Delivery ;
        $delivery->reference_no = 'dr-' . date("Ymd") . '-'. date("his");
        $delivery->sale_id = $lims_sale_data->id;
        $delivery->user_id = Auth::id();
        $delivery->address = 'address:' . $request->address. ', apt:'.$request->apartment. ', city:'.$request->city.', state:'.$request->state.', postcode:'.$request->postcode.', email:'.$request->email.', phone:'.$request->phone ;
        $delivery->delivered_by = 'alamminimarket';
        $delivery->recieved_by = $request->name;
        $delivery->status = 0;
        $delivery->note = $request->name;
        $delivery->save();
            $message = ' order placed successfully';
            //collecting male data
        $mail_data['email'] = $request->input('email');
        $mail_data['name'] = $request->input('name');
        $mail_data['reference_no'] = $lims_sale_data->reference_no;
        $mail_data['sale_status'] = $lims_sale_data->sale_status;
        $mail_data['payment_status'] = $lims_sale_data->payment_status;
        $mail_data['total_qty'] = $lims_sale_data->total_qty;
        $mail_data['total_price'] = $lims_sale_data->total_price;
        $mail_data['order_tax'] = $lims_sale_data->order_tax;
        $mail_data['order_tax_rate'] = $lims_sale_data->order_tax_rate;
        $mail_data['coupon_discount'] = $lims_sale_data->coupon_discount;
        $mail_data['order_discount'] = $lims_sale_data->order_discount;
        $mail_data['shipping_cost'] = $lims_sale_data->shipping_cost;
        $mail_data['grand_total'] = $lims_sale_data->grand_total;
        $mail_data['paid_amount'] = $lims_sale_data->paid_amount;
        try {
            Mail::send('mail.sale_details_ecom', $mail_data, function($message) use ($mail_data) {
                $message->to($mail_data['email'])->subject('Sale Details');
            });
        } catch (\Exception $e) {
            \Log::error('Failed to send sale email: ' . $e->getMessage());
            // Optionally, store the failed attempt in DB or take alternative action
        }

        Cart::destroy();
            if($request->payment_method == 'stripe')
            {
                $sale_id = $lims_sale_data->id; 
                $customer_id = $lims_customer_data->id;
                $amount = $grand_total;
                return view('stripe.payment', compact('sale_id', 'customer_id', 'amount'));

            }
            if($request->payment_method == 'paypal')
            {
                
                $provider = new PayPalClient;
                $provider->setApiCredentials(config('paypal'));
                $token = $provider->getAccessToken();

                $provider->setAccessToken($token);
                $response = $provider->createOrder([
                    "intent" => "CAPTURE",
                    "application_context" => [
                        "return_url" => route('paypal.success', ['sale_id' => $lims_sale_data->id]),
                        "cancel_url" => route('paypal.cancel'),
                    ],
                    "purchase_units" => [
                        [
                            "amount" => [
                                "currency_code" => "GBP",
                                "value" => $grand_total // You can make this dynamic
                            ]
                        ]
                    ]
                ]);

                if (isset($response['id']) && $response['status'] == 'CREATED') {
                    foreach ($response['links'] as $link) {
                        if ($link['rel'] === 'approve') {
                            return redirect()->away($link['href']);
                        }
                    }
                }

                return redirect()->route('paypal.cancel')->with('error', 'Something went wrong.');

            }
            elseif($request->payment_method == 'bkash')
            {
                if (env('BKASH_MODE') === 'merchant') {

                    if(!$grand_total || $grand_total < 1){
                        return redirect()->back();
                    }

                    $header =$this->authHeaders();
                    $website_url = URL::to("/");


                    $body_data = array(
                        'mode' => '0011',
                        'payerReference' => $lims_sale_data->id ? $lims_sale_data->id  : '1', // pass oderId or anything 
                        'callbackURL' => $website_url.'/bkash/callback',
                        'amount' => $grand_total,
                        'currency' => 'BDT',
                        'intent' => 'sale',
                        'merchantInvoiceNumber' => $request->merchantInvoiceNumber ? $request->merchantInvoiceNumber : "Inv_".Str::random(6)
                    );

                    $response = $this->curlWithBody('/tokenized/checkout/create',$header,'POST',json_encode($body_data));
                    //dd($response);
                    return redirect((json_decode($response)->bkashURL));
                }
            }
            elseif($request->payment_method == 'sslcommerz') {
                
                $post_data = array();
                $post_data['total_amount'] = $grand_total; # You cant not pay less than 10
                $post_data['currency'] = "BDT";
                $post_data['tran_id'] = 'sale-' . $lims_sale_data->id; // tran_id must be unique

                # CUSTOMER INFORMATION
                $post_data['cus_name'] = $lims_customer_data->name;
                $post_data['cus_email'] = $lims_customer_data->email;
                $post_data['cus_add1'] = $lims_customer_data->address;
                $post_data['cus_add2'] = "";
                $post_data['cus_city'] = "";
                $post_data['cus_state'] = "";
                $post_data['cus_postcode'] = "";
                $post_data['cus_country'] = "Bangladesh";
                $post_data['cus_phone'] = $lims_customer_data->phone_number;
                $post_data['cus_fax'] = "";

                # SHIPMENT INFORMATION
                $post_data['ship_name'] = $request->input('name');
                $post_data['ship_add1'] = $request->address;
                $post_data['ship_add2'] = "Dhaka";
                $post_data['ship_city'] = $request->city;
                $post_data['ship_state'] = $request->state;
                $post_data['ship_postcode'] = $request->postcode;
                $post_data['ship_phone'] = $request->phone;
                $post_data['ship_country'] = "Bangladesh";

                $post_data['shipping_method'] = "NO";
                $post_data['product_name'] = "any";
                $post_data['product_category'] = "Goods";
                $post_data['product_profile'] = "physical-goods";
                $sslc = new SslCommerzNotification();
                # initiate(Transaction Data , false: Redirect to SSLCOMMERZ gateway/ true: Show all the Payement gateway here )
                $payment_options = $sslc->makePayment($post_data, 'hosted');

                if (!is_array($payment_options)) {
                    print_r($payment_options);
                    $payment_options = array();
                }
            }

            else{
                return redirect('order_completed');
            }
            
    }



    public function guest_placeorder(Request $request)
    {
        /*dd($request->all());*/
        $categories = Category::where('is_active',true)->orderBy('id','desc')->where('parent_id',null)->get();
        $biller = Biller::where('is_active',true)->first();
        $data = $request->all();
        $cart_items= Cart::content();
        $item = $cart_items->count();
        $strSubtotal = Cart::subtotal();
        $subtotal = str_replace(',', '', $strSubtotal);
        $user = User::where('is_active',true)->first();
        $customer = Customer::where('name','guest')->first();

        $data['reference_no'] = 'sr-' . date("Ymd") . '-'. date("his");
        $data['customer_id'] = $customer->id;
        $data['warehouse_id'] = "1";
        $data['biller_id'] = $biller->id;
        $data['item'] = $item;
        $data['total_qty'] = Cart::content()->count();
        $data['total_discount'] = "0.00";
        $data['total_tax'] = "0.00";
        $data['total_price'] = $subtotal;
        $data['order_tax'] = "0.00";
        $data['grand_total'] = $subtotal;
        $data['pos'] = "0";
        $data['coupon_active'] = "0";
        $data['order_tax_rate'] = "0";
        $data['sale_status'] = "2";
        $data['payment_status'] = "1";
        $data['paid_by_id'] = "1";
        $data['product_code_name'] = null;
        $data['order_discount'] = null;
        $data['shipping_cost'] = $request->input('hidden_shipping_cost');
        $data['paying_amount'] = null;
        $data['paid_amount'] = null;
        $data['gift_card_id'] = null;
        $data['cheque_no'] = null;
        $data['payment_note'] = null;

        $combinedinfo =
                "Name: " . $request->name . ",\n" . 
                "Address: " . $request->address . ",\n" . 
                "Phone Number: " . $request->phone . ",\n" . 
                "Note: " . $request->note . "\n" ;

        // Add payment method conditionally
        if ($request->bkashNumber === null && $request->nagadNumber === null) {
            $combinedinfo .= ",\nPayment Method: Cash on Delivery";
        } elseif ($request->bkashNumber !== null) {
            $combinedinfo .= ",\nBkash Number: " . $request->bkashNumber;
        } elseif ($request->nagadNumber !== null) {
            $combinedinfo .= ",\nNagad Number: " . $request->nagadNumber;
        }
        //coupon
        if ($request->has('coupon_id')) {
            $coupon = Coupon::find($request->input('coupon_id'));
            
            $data['coupon_id'] = $coupon->id;
            $data['coupon_active'] = 1;
            $data['coupon_discount'] = $request->input('coupon_discount');
            
            // Reduce the subtotal and grand total by coupon discount
            $data['total_price'] = $subtotal - $request->input('coupon_discount');
            $data['grand_total'] = $data['total_price'] + $request->input('hidden_shipping_cost');
        }

        $data['sale_note'] = $combinedinfo;
        $data['staff_note'] = null;
        //dd($cart_items);
        //return dd($data);

        $data['user_id'] = $user->id;
        $cash_register_data = CashRegister::where([
            ['user_id', $data['user_id']],
            ['warehouse_id', $data['warehouse_id']],
            ['status', true]
        ])->first();

        if($cash_register_data)
            $data['cash_register_id'] = $cash_register_data->id;
        

        $lims_sale_data = Sale::create($data);
        $lims_customer_data = Customer::find($data['customer_id']);
        $key = 0;
        foreach($cart_items as $item){
            $product_details = Product::find($item->id);
            $sale_unit = Unit::find($product_details->sale_unit_id);
            $data['product_id'][$key] = $item->id;
            $data['product_batch_id'][$key] = null;
            $data['product_code'][$key] = $item->options->product_code;
            $data['qty'][$key] = $item->qty;
            $data['sale_unit'][$key] = $sale_unit->unit_name;
            $data['net_unit_price'][$key] = $product_details->price;
            $data['discount'][$key] = "0.00";
            $data['tax_rate'][$key] = "0.00";
            $data['tax'][$key] = "0.00";
            $data['subtotal'][$key] = $item->qty * $product_details->price;
            $key++;
        }
        //dd($data);
        $product_id = $data['product_id'];
        $product_batch_id = $data['product_batch_id'];
        $product_code = $data['product_code'];
        $qty = $data['qty'];
        $sale_unit = $data['sale_unit'];
        $net_unit_price = $data['net_unit_price'];
        $discount = $data['discount'];
        $tax_rate = $data['tax_rate'];
        $tax = $data['tax'];
        $total = $data['subtotal'];
        $product_sale = [];

        foreach ($product_id as $i => $id) {
            $lims_product_data = Product::where('id', $id)->first();
            $product_sale['variant_id'] = null;
            $product_sale['product_batch_id'] = null;


            if($sale_unit[$i] != 'n/a') {
                $lims_sale_unit_data  = Unit::where('unit_name', $sale_unit[$i])->first();
                $sale_unit_id = $lims_sale_unit_data->id;
                if($lims_product_data->is_variant) {
                    $lims_product_variant_data = ProductVariant::select('id', 'variant_id', 'qty')->FindExactProductWithCode($id, $product_code[$i])->first();
                    $product_sale['variant_id'] = $lims_product_variant_data->variant_id;
                }

                
            }
            else
                $sale_unit_id = 0;
            if($product_sale['variant_id']){
                $variant_data = Variant::select('name')->find($product_sale['variant_id']);
                $mail_data['products'][$i] = $lims_product_data->name . ' ['. $variant_data->name .']';
            }
            else
                $mail_data['products'][$i] = $lims_product_data->name;
            if($lims_product_data->type == 'digital')
                $mail_data['file'][$i] = url('/public/product/files').'/'.$lims_product_data->file;
            else
                $mail_data['file'][$i] = '';
            if($sale_unit_id)
                $mail_data['unit'][$i] = $lims_sale_unit_data->unit_code;
            else
                $mail_data['unit'][$i] = '';

            $product_sale['sale_id'] = $lims_sale_data->id ;
            $product_sale['product_id'] = $id;
            $product_sale['qty'] = $mail_data['qty'][$i] = $qty[$i];
            $product_sale['sale_unit_id'] = $sale_unit_id;
            $product_sale['net_unit_price'] = $net_unit_price[$i];
            $product_sale['discount'] = $discount[$i];
            $product_sale['tax_rate'] = $tax_rate[$i];
            $product_sale['tax'] = $tax[$i];
            $product_sale['total'] = $mail_data['total'][$i] = $total[$i];
            Product_Sale::create($product_sale);
        }
        
        $delivery = new Delivery ;
        $delivery->reference_no = 'dr-' . date("Ymd") . '-'. date("his");
        $delivery->sale_id = $lims_sale_data->id;
        $delivery->user_id = Auth::id();
        $delivery->address = 'address:' . $request->address. ', apt:'.$request->apartment. ', city:'.$request->city.', state:'.$request->state.', postcode:'.$request->postcode.', email:'.$request->email.', phone:'.$request->phone ;
        $delivery->delivered_by = 'alamminimarket';
        $delivery->recieved_by = $request->name;
        $delivery->status = 0;
        $delivery->note = $request->name;
        $delivery->save();

            $message = 'order placed successfully';
            Cart::destroy();
            /*dd($message);*/
            return redirect('order_completed');
    }

    public function c_o(){
        $categories = Category::where('is_active',true)->orderBy('id','desc')->where('parent_id',null)->get();
        $cart_items= Cart::content();
        return view('front/c_o',compact('cart_items','categories'));
    }

    public function order_completed(){
        $categories = Category::where('is_active',true)->orderBy('id','desc')->where('parent_id',null)->get();
        $cart_items= Cart::content();
        
        return view('front/order_completed',compact('cart_items','categories'));
    }

    /*public function contact_mail(Request $request){

        $validator = Validator::make($request->all(), [
            'name' => 'required',
            'email' => 'required|email',
            'message' => 'required',
            'g-recaptcha-response' => 'required|captcha',
        ]);

        if ($validator->fails()) {
            return back()->withErrors($validator)->withInput();
        }


        $mail_data['name'] = $request->name;
        $mail_data['email'] = $request->email;
        $mail_data['subject'] = $request->subject;
        $mail_data['email_message'] = $request->message;
        //dd($mail_data);
        $message = ' Email sent successfully';
        try {
                Mail::send( 'mail.contact', $mail_data, function( $message ) use ($mail_data)
                {
                    $message->to( env('MAIL_FROM_ADDRESS') )->subject( 'message from alamminimarket' );

                });
            }
            catch(\Exception $e){
                $message = ' your Email was unfortunately not sent for some technical issues.';
            }
        return back()->with('success',$message );
    }*/

    public function contact_mail(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'name' => 'required|string|max:255',
            'email' => 'required|email',
            'phone' => 'nullable|string|max:20',
            'subject' => 'required|string|max:255',
            'message' => 'required|string',
            'g-recaptcha-response' => 'required|captcha',
        ], [
            'g-recaptcha-response.required' => 'Please verify that you are not a robot.',
            'g-recaptcha-response.captcha' => 'reCAPTCHA verification failed, please try again.',
        ]);

        if ($validator->fails()) {
            return back()->withErrors($validator)->withInput();
        }

        $mail_data = [
            'name' => $request->name,
            'email' => $request->email,
            'phone' => $request->phone,
            'subject' => $request->subject,
            'email_message' => $request->message,
        ];

        try {
            Mail::send('mail.contact', $mail_data, function ($message) use ($mail_data) {
                $message->to(env('MAIL_TO_ADDRESS', env('MAIL_FROM_ADDRESS')))
                        ->subject('New contact form message: ' . $mail_data['subject']);
            });

            return back()->with('success', 'Your email has been sent successfully.');
        } catch (\Exception $e) {
            \Log::error('Contact email failed to send: ' . $e->getMessage());

            return back()->with('error', 'Your email could not be sent due to a technical issue. Please try again later.');
        }
    }



    

    public function check_out()
    {
        $categories = Category::where('is_active', true)->orderBy('id', 'desc')->where('parent_id', null)->get();
        $cart_items = Cart::content();
        
        if (Auth::check()) {
            $user = Auth::user();
            $customer_detail = Customer::where('user_id', $user->id)->first();
        } else {
            $customer_detail = new Customer(); // Create an empty customer object for guests
        }
        $categories = Category::where('is_active', true)->orderBy('id', 'desc')->where('parent_id', null)->get();
        $cart_items = Cart::content();
        $customer_group = CustomerGroup::where('name', 'general')->first();

        $lims_coupon_list = Coupon::where('is_active',true)->get();
        //dd($lims_coupon_list);
        return view('front/checkout', compact('cart_items', 'customer_detail', 'categories','categories','cart_items','customer_group','lims_coupon_list'));
    }

    
    public function customer_store(Request $request)
    {
        try {
            // Validate customer data first
            $validationRules = [
                'phone_number' => [
                    'required',
                    'max:255',
                    Rule::unique('customers')->where(function ($query) {
                        return $query->where('is_active', 1);
                    }),
                ],
                'name' => [
                    'required',
                    'max:255',
                    Rule::unique('users')->where(function ($query) {
                        return $query->where('is_deleted', false);
                    }),
                ],
                'email' => [
                    'required',
                    'email',
                    'max:255',
                    Rule::unique('users')->where(function ($query) {
                        return $query->where('is_deleted', false);
                    }),
                ],
            ];

            $customMessages = [
                'phone_number.unique' => 'This phone number is already registered. Please login to place your order or use a different phone number.',
                'name.unique' => 'This username is already registered. Please login to place your order or use a different username.',
                'email.unique' => 'This email is already registered. Please login to place your order or use a different email address.',
                'email.email' => 'Please provide a valid email address.',
                'phone_number.required' => 'Phone number is required.',
                'name.required' => 'Name is required.',
                'email.required' => 'Email is required.',
            ];

            $validator = \Validator::make($request->all(), $validationRules, $customMessages);

            if ($validator->fails()) {
                return redirect()->back()
                    ->withErrors($validator)
                    ->withInput();
            }

            // Original code starts here
            $customerData = $request->all();
            $customerData['is_active'] = true;
            
            $customer_group = CustomerGroup::where('name', 'general')->first();
            $customerData['phone'] = $customerData['phone_number'];
            $customerData['role_id'] = 5;
            $customerData['customer_group_id'] = $customer_group->id;
            $customerData['is_deleted'] = false;
            $customerData['password'] = bcrypt($customerData['password']);
            
            $user = User::create($customerData);
            $customerData['user_id'] = $user->id;
            
            $customerData['name'] = $customerData['customer_name'];
            $customerData['district'] = $request->state;

            $customer = Customer::create($customerData);

            // Order placement code
            $categories = Category::where('is_active', true)->orderBy('id', 'desc')->where('parent_id', null)->get();
            $biller = Biller::where('is_active', true)->first();
            $data = $request->all();
            $cart_items = Cart::content();
            $item = $cart_items->count();
            $strSubtotal = Cart::subtotal();
            $subtotal = str_replace(',', '', $strSubtotal);

            $data['reference_no'] = 'sr-' . date("Ymd") . '-'. date("his");
            $data['customer_id'] = $customer->id;
            $data['warehouse_id'] = "1";
            $data['biller_id'] = $biller->id;
            $data['item'] = $item;
            $data['total_qty'] = Cart::content()->count();
            $data['total_discount'] = "0.00";
            $data['total_tax'] = "0.00";
            $data['total_price'] = $subtotal;
            $data['order_tax'] = "0.00";
            $data['grand_total'] = $subtotal;
            $data['pos'] = "0";
            $data['coupon_active'] = "0";
            $data['order_tax_rate'] = "0";
            $data['sale_status'] = "2";
            $data['payment_status'] = "1";
            $data['paid_by_id'] = "1";
            $data['product_code_name'] = null;
            $data['order_discount'] = null;
            $data['shipping_cost'] = $request->input('hidden_shipping_cost');
            $data['paying_amount'] = null;
            $data['paid_amount'] = null;
            $data['gift_card_id'] = null;
            $data['cheque_no'] = null;
            $data['payment_note'] = null;
            $combinedinfo = $request->district . ",\n" . 
                "Name: " . $request->name . ",\n" . 
                "Address: " . $request->address . ",\n" . 
                "Apartment: " . $request->apartment . ",\n" . 
                "Phone Number: " . $request->phone . ",\n" . 
                "Note: " . $request->note . "\n";

            // Add payment method conditionally
            if ($request->bkashNumber === null && $request->nagadNumber === null) {
                $combinedinfo .= ",\nPayment Method: Cash on Delivery";
            } elseif ($request->bkashNumber !== null) {
                $combinedinfo .= ",\nBkash Number: " . $request->bkashNumber;
            } elseif ($request->nagadNumber !== null) {
                $combinedinfo .= ",\nNagad Number: " . $request->nagadNumber;
            }

            $data['sale_note'] = $combinedinfo;
            $data['staff_note'] = null;

            $data['user_id'] = $user->id;
            $cash_register_data = CashRegister::where([
                ['user_id', $data['user_id']],
                ['warehouse_id', $data['warehouse_id']],
                ['status', true]
            ])->first();

            if($cash_register_data)
                $data['cash_register_id'] = $cash_register_data->id;

            $lims_sale_data = Sale::create($data);
            $lims_customer_data = Customer::find($data['customer_id']);
            $key = 0;
            foreach($cart_items as $item){
                $product_details = Product::find($item->id);
                $sale_unit = Unit::find($product_details->sale_unit_id);
                $data['product_id'][$key] = $item->id;
                $data['product_batch_id'][$key] = null;
                $data['product_code'][$key] = $item->options->product_code;
                $data['qty'][$key] = $item->qty;
                $data['sale_unit'][$key] = $sale_unit->unit_name;
                $data['net_unit_price'][$key] = $product_details->price;
                $data['discount'][$key] = "0.00";
                $data['tax_rate'][$key] = "0.00";
                $data['tax'][$key] = "0.00";
                $data['subtotal'][$key] = $item->qty * $product_details->price;
                $key++;
            }

            $product_id = $data['product_id'];
            $product_batch_id = $data['product_batch_id'];
            $product_code = $data['product_code'];
            $qty = $data['qty'];
            $sale_unit = $data['sale_unit'];
            $net_unit_price = $data['net_unit_price'];
            $discount = $data['discount'];
            $tax_rate = $data['tax_rate'];
            $tax = $data['tax'];
            $total = $data['subtotal'];
            $product_sale = [];

            foreach ($product_id as $i => $id) {
                $lims_product_data = Product::where('id', $id)->first();
                $product_sale['variant_id'] = null;
                $product_sale['product_batch_id'] = null;

                if($sale_unit[$i] != 'n/a') {
                    $lims_sale_unit_data  = Unit::where('unit_name', $sale_unit[$i])->first();
                    $sale_unit_id = $lims_sale_unit_data->id;
                    if($lims_product_data->is_variant) {
                        $lims_product_variant_data = ProductVariant::select('id', 'variant_id', 'qty')->FindExactProductWithCode($id, $product_code[$i])->first();
                        $product_sale['variant_id'] = $lims_product_variant_data->variant_id;
                    }
                } else {
                    $sale_unit_id = 0;
                }

                if($product_sale['variant_id']){
                    $variant_data = Variant::select('name')->find($product_sale['variant_id']);
                    $mail_data['products'][$i] = $lims_product_data->name . ' ['. $variant_data->name .']';
                } else {
                    $mail_data['products'][$i] = $lims_product_data->name;
                }

                if($lims_product_data->type == 'digital')
                    $mail_data['file'][$i] = url('/public/product/files').'/'.$lims_product_data->file;
                else
                    $mail_data['file'][$i] = '';
                
                if($sale_unit_id)
                    $mail_data['unit'][$i] = $lims_sale_unit_data->unit_code;
                else
                    $mail_data['unit'][$i] = '';

                $product_sale['sale_id'] = $lims_sale_data->id;
                $product_sale['product_id'] = $id;
                $product_sale['qty'] = $mail_data['qty'][$i] = $qty[$i];
                $product_sale['sale_unit_id'] = $sale_unit_id;
                $product_sale['net_unit_price'] = $net_unit_price[$i];
                $product_sale['discount'] = $discount[$i];
                $product_sale['tax_rate'] = $tax_rate[$i];
                $product_sale['tax'] = $tax[$i];
                $product_sale['total'] = $mail_data['total'][$i] = $total[$i];
                Product_Sale::create($product_sale);
            }

            $delivery = new Delivery;
            $delivery->reference_no = 'dr-' . date("Ymd") . '-'. date("his");
            $delivery->sale_id = $lims_sale_data->id;
            $delivery->user_id = $user->id;
            $delivery->address = 'address:' . $request->address. ', apt:'.$request->apartment. ', city:'.$request->city.', state:'.$request->state.', postcode:'.$request->postcode.', email:'.$request->email.', phone:'.$request->phone;
            $delivery->delivered_by = 'alamminimarket';
            $delivery->recieved_by = $request->name;
            $delivery->status = 0;
            $delivery->note = $request->name;
            $delivery->save();

            Cart::destroy();
            return redirect('order_completed');

        } catch (\Exception $e) {
            // Log the error
            \Log::error('Error in customer_store: ' . $e->getMessage());
            
            // Redirect back with error
            return redirect()->back()
                ->with('error', 'An error occurred while processing your order. Please try again.')
                ->withInput();
        }
    }

   public function updateCartItem(Request $request)
    {
        $rowId = $request->input('rowId');
        $quantity = $request->input('quantity');

        // Get the cart item
        $cartItem = Cart::get($rowId);

        // Find the product
        $product = Product::find($cartItem->id);

        $availableStock = 0;

        if ($product->is_variant == null) {
            $availableStock = $product->qty;
        } else {
            $variant = ProductVariant::where('item_code', $cartItem->options->product_code)->first();
            $availableStock = $variant ? $variant->qty : 0;
        }

        if ($availableStock < $quantity) {
            return response()->json([
                'success' => false,
                'message' => 'Quantity exceeds available stock. Maximum available: ' . $availableStock
            ], 422);
        }

        // Update the cart item
        Cart::update($rowId, $quantity);

        // Get the updated cart total
        $cart_Total = Cart::subtotal();
        // Remove any non-numeric characters (like commas) and convert to float
        $cartTotal = (float) preg_replace('/[^0-9.]/', '', $cart_Total);

        return response()->json([
            'success' => true,
            'message' => 'Cart updated successfully',
            'cartTotal' => $cartTotal
        ], 200);
    }

}