<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Volunteer;
class VolunteerController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $lims_volunteer_all = Volunteer::all();
        return view('volunteer/index',compact('lims_volunteer_all'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('volunteer/create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        /*dd($request->all());*/
        $request->validate([
         
            'title' => 'required',
            'thumb' => 'required|image|mimes:jpg,png,jpeg,gif,svg|max:4096',
           
           
        ]);
        $path = $request->file('thumb')->store('public/images');
        $volunteer = new Volunteer ;
        $volunteer->title = $request->title;
        $volunteer->twitter = $request->twitter;
        $volunteer->facebook = $request->facebook;
        $volunteer->insta = $request->insta;
        $volunteer->linked_in = $request->linked_in;
        $volunteer->thumb = $path;
        $volunteer->save(); 

        if($volunteer){
            return back()
            ->with('success','You have successfully file uplaod.');
        }

           return back()->withInput()->with('error', 'Error inserting memory'); 
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $lims_user_data = Volunteer::findOrFail($id);
        return view('volunteer/edit',compact('lims_user_data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Volunteer $volunteer)
    {
        /*dd($request->all());*/
        //dd($memory);
         $volunteer = $volunteer::find($volunteer->id);

        $request->validate([
            'title' => 'required',            
        ]);

        if($request->hasFile('thumb')){
            $request->validate([
              'thumb' => 'image|mimes:jpg,png,jpeg,gif,svg|max:2048',
            ]);
            $path = $request->file('thumb')->store('public/images');
            $volunteer->thumb = $path;
        }    
       
        $volunteer->title = $request->title;
        //$memory->thumb = $path;
        
        $volunteer->twitter = $request->twitter;
        $volunteer->facebook = $request->facebook;
        $volunteer->insta = $request->insta;
        $volunteer->linked_in = $request->linked_in;
        $volunteer->update(); 


        if($volunteer){
            return back()
            ->with('success','You have successfully Updated.');
        }

        return back()->withInput()->with('error', 'Error Updating volunteers');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Volunteer $volunteer)
    {
        $volunteer->delete();

        if($volunteer){
            return back()
            ->with('success','You have successfully Deleted .');
        }

           return back()->with('error', 'Error Deliting '); 
    }
}
