<?php

namespace App\Http\Controllers;

use App\Models\TravelDetail;
use App\Models\Product;
use Illuminate\Http\Request;

class TravelDetailController extends Controller
{
    public function create($product_id)
    {
        $product = Product::findOrFail($product_id);
        return view('travel_details.create', compact('product'));
    }

    public function store(Request $request, $product_id)
    {
        $validatedData = $request->validate([
            'duration' => 'nullable|integer',
            'end_date' => 'nullable|date',
            'max_persons' => 'nullable|integer',
            'highlights' => 'nullable|string',
            'included' => 'nullable|string',
            'excluded' => 'nullable|string',
            'location' => 'nullable|string',
            'tour_plan' => 'nullable|string',
        ]);

        $travelDetail = new TravelDetail($validatedData);
        $travelDetail->product_id = $product_id;
        $travelDetail->save();

        return redirect()->route('products.index')->with('success', 'Travel details added successfully.');
    }

    public function edit($id)
    {
        $travelDetail = TravelDetail::findOrFail($id);
        return view('travel_details.edit', compact('travelDetail'));
    }

    public function update(Request $request, $id)
    {
        $validatedData = $request->validate([
            'duration' => 'nullable|integer',
            'end_date' => 'nullable|date',
            'max_persons' => 'nullable|integer',
            'highlights' => 'nullable|string',
            'included' => 'nullable|string',
            'excluded' => 'nullable|string',
            'location' => 'nullable|string',
            'tour_plan' => 'nullable|string',
        ]);

        $travelDetail = TravelDetail::findOrFail($id);
        $travelDetail->update($validatedData);

        return redirect()->route('products.index')->with('success', 'Travel details updated successfully.');
    }
}