<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Slider;
class SliderController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $lims_slider_all = Slider::all();
        return view('slider/index',compact('lims_slider_all'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('slider/create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        /*dd($request->all());*/
        $request->validate([
         
            'slider_title' => 'required',
            'slider_img' => 'required|image|mimes:jpg,png,jpeg,gif,svg|max:4096',
           
           
        ]);
        $path = $request->file('slider_img')->store('public/images');
        $slider = new Slider ;
        $slider->title = $request->slider_title;
        $slider->slider_content1 = $request->slider_content1;
        $slider->slider_content2 = $request->slider_content2;
        $slider->thumb = $path;
        $slider->save(); 

        if($slider){
            return back()
            ->with('success','You have successfully file uplaod.');
        }

           return back()->withInput()->with('error', 'Error inserting memory'); 
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $lims_user_data = Slider::findOrFail($id);
        return view('slider/edit',compact('lims_user_data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Slider $slider)
    {
        /*dd($request->all());*/
        //dd($memory);
         $slider = $slider::find($slider->id);

        $request->validate([
            'slider_title' => 'required',            
        ]);

        if($request->hasFile('slider_img')){
            $request->validate([
              'slider_img' => 'image|mimes:jpg,png,jpeg,gif,svg|max:2048',
            ]);
            $path = $request->file('slider_img')->store('public/images');
            $slider->thumb = $path;
        }    
       
        $slider->title = $request->slider_title;
        //$memory->thumb = $path;
        $slider->slider_content1 = $request->slider_content1;
        $slider->slider_content2 = $request->slider_content2;
        $slider->update(); 


        if($slider){
            return back()
            ->with('success','You have successfully Updated.');
        }

        return back()->withInput()->with('error', 'Error Updating sliders');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Slider $slider)
    {
        $slider->delete();

        if($slider){
            return back()
            ->with('success','You have successfully Deleted .');
        }

           return back()->with('error', 'Error Deliting '); 
    }
}
