<?php

namespace App\Http\Controllers;

use Laravelium\Sitemap\Facades\Sitemap;
use Illuminate\Http\Request;
use App\SeoMeta;
use App\Product;
use App\Blog;
use App\Page;

class SitemapController extends Controller
{
    private function generateUrl($seoMeta)
    {
        switch ($seoMeta->model_type) {
            case 'home':
                return url('/');
            case 'contact':
                return url('/contact');
            case 'shop':
                return url('/shop');
            case 'App\Product':
                if ($seoMeta->model_id) {
                    $product = Product::find($seoMeta->model_id);
                    if ($product && isset($product->name)) {
                        return url("/single-product/{$seoMeta->model_id}/{$seoMeta->slug}");
                    }
                }
                break;
            case 'App\Blog':
                if ($seoMeta->model_id) {
                    $blog = Blog::find($seoMeta->model_id);
                    if ($blog) {
                        return url("/blogs/{$seoMeta->model_id}/{$seoMeta->slug}");
                    }
                }
                break;
            case 'App\Page':
                if ($seoMeta->model_id) {
                    $page = Page::find($seoMeta->model_id);
                    if ($page) {
                        return url("/pages/{$seoMeta->model_id}/{$seoMeta->slug}");
                    }
                }
                break;
        }

        return null;
    }

    public function index()
    {
        $seoMetas = SeoMeta::all();
        $urls = [];

        foreach ($seoMetas as $seoMeta) {
            $url = $this->generateUrl($seoMeta);
            if ($url) {
                $urls[] = [
                    'loc' => $url,
                    'lastmod' => $seoMeta->updated_at ? $seoMeta->updated_at->toAtomString() : now()->toAtomString(),
                    'changefreq' => 'weekly',
                    'priority' => '0.8',
                ];
            }
        }

        return response()->view('sitemap', compact('urls'))->header('Content-Type', 'application/xml');
    }

}
