<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use App\Product;
use App\SeoMeta;

class ProductSeoController extends Controller
{
    public function edit($id)
    {
        $product = Product::findOrFail($id);

        $seo = SeoMeta::where('model_type', Product::class)
                      ->where('model_id', $id)
                      ->first();

        return view('product.seo', compact('product', 'seo'));
    }

    public function update(Request $request, $id)
    {
        $product = Product::findOrFail($id);

        $data = $request->only([
            'slug', 'title', 'meta_description', 'meta_keywords','canonical_url', 'robots', 'custom_head_script'
        ]);

        SeoMeta::updateOrCreate(
            ['model_type' => Product::class, 'model_id' => $id],
            $data
        );

        return redirect()->route('products.index')->with('success', 'SEO settings saved!');
    }

}
