<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Partner;
class PartnerController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $lims_partner_all = Partner::all();
        return view('partner/index',compact('lims_partner_all'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('partner/create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        /*dd($request->all());*/
        
        $path = $request->file('image')->store('public/images');
        $partner = new Partner ;
        $partner->link = $request->link;
        $partner->image = $path;
        $partner->save(); 

        if($partner){
            return back()
            ->with('success','You have successfully file uplaod.');
        }

           return back()->withInput()->with('error', 'Error inserting memory'); 
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $lims_user_data = partner::findOrFail($id);
        return view('partner/edit',compact('lims_user_data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Partner $partner)
    {
        /*dd($request->all());*/
        //dd($memory);
         $partner = $partner::find($partner->id);

        

        if($request->hasFile('image')){
            $request->validate([
              'image' => 'image|mimes:jpg,png,jpeg,gif,svg|max:2048',
            ]);
            $path = $request->file('image')->store('public/images');
            $partner->image = $path;
        }    
       
        $partner->link = $request->link;
        //$memory->image = $path;
        $partner->update(); 


        if($partner){
            return back()
            ->with('success','You have successfully Updated.');
        }

        return back()->withInput()->with('error', 'Error Updating partners');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Partner $partner)
    {
        $partner->delete();

        if($partner){
            return back()
            ->with('success','You have successfully Deleted .');
        }

           return back()->with('error', 'Error Deliting '); 
    }
}
