<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Page;
use App\SeoMeta;

class PageSeoController extends Controller
{
    public function edit($id)
    {
        $page = Page::findOrFail($id);

        $seo = SeoMeta::where('model_type', Page::class)
                      ->where('model_id', $id)
                      ->first();

        return view('page.seo', compact('page', 'seo'));
    }

    public function update(Request $request, $id)
    {
        $page = Page::findOrFail($id);

        $data = $request->only([
            'slug', 'title', 'meta_description', 'meta_keywords','canonical_url', 'robots', 'custom_head_script'
        ]);

        SeoMeta::updateOrCreate(
            ['model_type' => Page::class, 'model_id' => $id],
            $data
        );

        return redirect()->route('page.index')->with('success', 'SEO settings saved!');
    }

    public function staticpageedit($id)
    {

        $seo = SeoMeta::find($id);
        $page = $seo->model_type;
        return view('page.staticpage_seo', compact('page', 'seo'));
    }

    public function staticpageupdate(Request $request, $id)
    {
        
        $seo = SeoMeta::find($id);
        $data = $request->only([
            'slug', 'title', 'meta_description', 'meta_keywords','canonical_url', 'robots', 'custom_head_script'
        ]);

        SeoMeta::updateOrCreate(
            ['model_type' => $seo->model_type],
            $data
        );

        return redirect()->route('page.index')->with('success', 'SEO settings saved!');
    }
}
