<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Page;
class PageController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $lims_pages_all = Page::all();
        return view('page/index',compact('lims_pages_all'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('page/create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
         
            'page_title' => 'required',
           
           
        ]);
        $page = new Page ;
        $page->name = $request->page_title;
        $page->intro = $request->intro;
        $page->desc = $request->desc;
        $page->quote = $request->quote;
        // Check if a file was uploaded for 'page_img'
        if ($request->hasFile('page_img')) {
            $path = $request->file('page_img')->store('public/images/pages');
            $page->thumb = $path;
        }

        // Save the page
        $page->save();

        if ($page) {
            return back()->with('success', 'You have successfully uploaded the file.');
        }

        return back()->withInput()->with('error', 'Error inserting memory');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $lims_user_data = Page::findOrFail($id);
        
        return view('page/edit',compact('lims_user_data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Page $page)
    {
        $page = $page::find($page->id);

        $request->validate([
            'page_title' => 'required', 
        ]);

        if ($request->hasFile('page_img')) {
            $path = $request->file('page_img')->store('public/images/pages');
            $page->thumb = $path;
        }

        $page->name = $request->page_title;
        $page->intro = $request->intro;
        $page->desc = $request->desc;
        $page->quote = $request->quote;
        $page->save();

        return redirect()->route('page.index')->with('success', 'Page updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Page $page)
    {
        $page->delete();

        if($page){
            return back()
            ->with('success','You have successfully Deleted .');
        }

           return back()->with('error', 'Error Deliting '); 
    
    }
}
