<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Faq;

class FaqController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $lims_pages_all = Faq::all();
        return view('faqs/index',compact('lims_pages_all'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('faqs/create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $faqs = new Faq ;
        $faqs->ques = $request->ques;
        $faqs->ans = $request->ans;
        

        // Save the page
        $faqs->save();

        if ($faqs) {
            return back()->with('success', 'You have successfully uploaded the file.');
        }

        return back()->withInput()->with('error', 'Error inserting ');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $lims_user_data = Faq::findOrFail($id);
        
        return view('faqs/edit',compact('lims_user_data'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $lims_user_data = Faq::findOrFail($id);
        
        return view('faqs/edit',compact('lims_user_data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $faqs = Faq::find($id);

        if (!$faqs) {
            return back()->with('error', 'Faq not found.');
        }

        $faqs->ques = $request->ques;
        $faqs->ans = $request->ans;
        $faqs->save();

        return redirect()->route('faqs.index')->with('success', 'Faq updated successfully.');
    }



    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $faq = Faq::find($id);

        if (!$faq) {
            return back()->with('error', 'Faq not found.');
        }

        if ($faq->delete()) {
            return back()->with('success', 'Faq deleted successfully.');
        } else {
            return back()->with('error', 'Error deleting Faq.');
        }
    }



}
