<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Choose;
use App\ChooseCat;
class ChooseController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $lims_choose_all = Choose::all();
        return view('choose/index',compact('lims_choose_all'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $choose_cat=ChooseCat::all();
        return view('choose/create',compact('choose_cat'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        /*dd($request->all());*/
        $request->validate([
         
            'title' => 'required',
            'image' => 'required|image|mimes:jpg,png,jpeg,gif,svg|max:4096',
           
           
        ]);
        $path = $request->file('image')->store('public/images/choose');
        $choose = new Choose ;
        $choose->title = $request->title;
        $choose->cat_id = $request->cat_id;
        $choose->details = $request->details;
        $choose->image = $path;
        $choose->save(); 

        if($choose){
            return back()
            ->with('success','You have successfully file uplaod.');
        }

           return back()->withInput()->with('error', 'Error inserting memory'); 
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $choose_cat=ChooseCat::all();
        $lims_user_data = Choose::findOrFail($id);
        return view('choose/edit',compact('lims_user_data','choose_cat'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Choose $choose)
    {
        /*dd($request->all());*/
        //dd($memory);
         $choose = $choose::find($choose->id);

        $request->validate([
            'title' => 'required',            
        ]);

        if($request->hasFile('image')){
            $request->validate([
              'image' => 'image|mimes:jpg,png,jpeg,gif,svg|max:2048',
            ]);
            $path = $request->file('image')->store('public/images/choose');
            $choose->image = $path;
        }    
       
        $choose->title = $request->title;
        //$memory->image = $path;
        $choose->details = $request->details;
        $choose->cat_id = $request->cat_id;
        $choose->update(); 


        if($choose){
            return back()
            ->with('success','You have successfully Updated.');
        }

        return back()->withInput()->with('error', 'Error Updating chooses');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Choose $choose)
    {
        $choose->delete();

        if($choose){
            return back()
            ->with('success','You have successfully Deleted .');
        }

           return back()->with('error', 'Error Deliting '); 
    }
}
