<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\ChooseCat;
use Illuminate\Http\Request;

class chooseCatController extends Controller
{
    
    public function index()
    {
        $choose_cat=ChooseCat::all();
        
        return view('choose/category/index',compact('choose_cat'));
    }

    
    public function create()
    {
        return view('choose/category/create');
    }

    public function store(Request $request)
    {
        // Validate the request
        $request->validate([        
            'title' => 'required'
        ]);

        $choose_cat = new ChooseCat;
        $choose_cat->title = $request->title;
        $choose_cat->save(); 

        // Return success or error message
        if ($choose_cat) {
            return back()->with('success', 'You have successfully added the Category.');
        }

        return back()->withInput()->with('error', 'Error inserting Category');
    }


    public function show(ChooseCat $choose_cat)
    {
        //
    }

    public function edit(ChooseCat $choose_cat)
    {
        //dd($choose_cat);
        return view('choose/category/edit',compact('choose_cat'));
    }

    public function update(Request $request, ChooseCat $choose_cat)
    {
        // Validate the request
        $request->validate([
            'title' => 'required'
        ]);

        // Find the existing Catchoose
        $choose_cat = ChooseCat::find($choose_cat->id);

        
        // Update the title
        $choose_cat->title = $request->title;
        $choose_cat->update(); 

        // Return success or error message
        if ($choose_cat) {
            return back()->with('success', 'You have successfully updated the Category.');
        }

        return back()->withInput()->with('error', 'Error updating choose Category');
    }


    public function destroy(ChooseCat $choose_cat)
    {
        $choose_cat->delete();

        if($choose_cat){
            return back()
            ->with('success','You have successfully Deleted choose Category.');
        }

           return back()->with('error', 'Error Deliting choose Category');
    }
}