<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Blog;
use App\SeoMeta;

class BlogSeoController extends Controller
{
    public function edit($id)
    {
        $blog = Blog::findOrFail($id);

        $seo = SeoMeta::where('model_type', Blog::class)
                      ->where('model_id', $id)
                      ->first();

        return view('blog.seo', compact('blog', 'seo'));
    }

    public function update(Request $request, $id)
    {
        $blog = Blog::findOrFail($id);

        $data = $request->only([
            'slug', 'title', 'meta_description', 'meta_keywords','canonical_url', 'robots', 'custom_head_script'
        ]);

        SeoMeta::updateOrCreate(
            ['model_type' => Blog::class, 'model_id' => $id],
            $data
        );

        return redirect()->route('blogs.index')->with('success', 'SEO settings saved!');
    }
}
