<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\BlogCat;
use Illuminate\Http\Request;

class BlogCatController extends Controller
{
    
    public function index()
    {
        $blog_cat=BlogCat::paginate(10);
        
        return view('blog/category/blogcat-list',compact('blog_cat'));
    }

    
    public function create()
    {
        return view('blog/category/add-cat-blog');
    }

    public function store(Request $request)
    {
        // Validate the request
        $request->validate([        
            'title' => 'required'
        ]);

        $blog_cat = new BlogCat;
        $blog_cat->title = $request->title;
        $blog_cat->save(); 

        // Return success or error message
        if ($blog_cat) {
            return back()->with('success', 'You have successfully added the Category.');
        }

        return back()->withInput()->with('error', 'Error inserting Category');
    }


    public function show(BlogCat $blog_cat)
    {
        //
    }

    public function edit(BlogCat $blog_cat)
    {
        //dd($blog_cat);
        return view('blog/category/edit-cat-blog',compact('blog_cat'));
    }

    public function update(Request $request, BlogCat $blog_cat)
    {
        // Validate the request
        $request->validate([
            'title' => 'required'
        ]);

        // Find the existing Catblog
        $blog_cat = BlogCat::find($blog_cat->id);

        
        // Update the title
        $blog_cat->title = $request->title;
        $blog_cat->update(); 

        // Return success or error message
        if ($blog_cat) {
            return back()->with('success', 'You have successfully updated the Category.');
        }

        return back()->withInput()->with('error', 'Error updating blog Category');
    }


    public function destroy(BlogCat $blog_cat)
    {
        $blog_cat->delete();

        if($blog_cat){
            return back()
            ->with('success','You have successfully Deleted blog Category.');
        }

           return back()->with('error', 'Error Deliting blog Category');
    }
}