<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Bankdeposit;
use App\Account;
use Illuminate\Validation\Rule;
use Auth;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use App\Mail\UserNotification;
use Illuminate\Support\Facades\Mail;

class BankDepositController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //dd('Hello Bangladesh');
        $role = Role::find(Auth::user()->role_id);
         $permissions = Role::findByName($role->name)->permissions;
            foreach ($permissions as $permission)
                $all_permission[] = $permission->name;
            if(empty($all_permission))
                $all_permission[] = 'dummy text';
        $lims_bankdeposit_all = Bankdeposit::all();
        return view('bankdeposit.index',compact('lims_bankdeposit_all', 'all_permission'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $role = Role::find(Auth::user()->role_id);
        $account= Account::where('is_active', true)->get();
        
            return view('bankdeposit.create',compact('account'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //dd($request);
               
        $lims_bankdeposit_data = $request->all();
        
        Bankdeposit::create($lims_bankdeposit_data);
        $message = 'Data inserted successfully';
        
        return redirect('bankdeposit')->with('message', $message);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $role = Role::find(Auth::user()->role_id);
            $account= Account::where('is_active', true)->get();
            $lims_bankdeposit_data = Bankdeposit::where('id',$id)->first();
            return view('bankdeposit.edit',compact('lims_bankdeposit_data','account'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $input = $request->all();
        $lims_bankdeposit_data = Bankdeposit::findOrFail($id);
        $lims_bankdeposit_data->update($input);
        //dd($lims_bankdeposit_data);
        return redirect('bankdeposit')->with('message','Data updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $lims_bankdeposit_data = Bankdeposit::findOrFail($id);
        $lims_bankdeposit_data->delete();
        return redirect('bankdeposit')->with('not_permitted','Data deleted successfully');
    }
}
